/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.mo;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.mm.basedata.OverRunMeasureEnum;
import com.kingdee.eas.mm.common.util.ResourceUtils;
import com.kingdee.eas.mm.mo.GetStockCanToDoConditionInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderFactory;
import com.kingdee.eas.mm.mo.ManufactureOrderInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderStockCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderStockInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderTechnicsCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderTechnicsInfo;
import com.kingdee.eas.mm.mo.MaterialTransactionPlatformFacadeFactory;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.ISCMBillParam;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.SCMBillParamFactory;
import com.kingdee.eas.scm.common.service.SCMServiceFactory;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class MOUtil {
    private static final String billTypeId = "B2aZSVXaSx6qxdfekgCmrEY+1VI=";
    public static final int PRECISION_MAX = 8;

    public static GetStockCanToDoConditionInfo getInventorySurplusQty(String StorageOrgUnitId, String materialId, String stockid, String warehsID, String unitId, String locationID) throws Exception {
        GetStockCanToDoConditionInfo info = new GetStockCanToDoConditionInfo();
        info.setMaterialID(materialId);
        info.setStrorageOrgUnitID(StorageOrgUnitId);
        info.setStorckID(stockid);
        info.setWarehsID(warehsID);
        info.setLocationID(locationID);
        info.setUnitID(unitId);
        ArrayList<GetStockCanToDoConditionInfo> list = new ArrayList<GetStockCanToDoConditionInfo>();
        list.add(info);
        Map map = MaterialTransactionPlatformFacadeFactory.getRemoteInstance().getStockCanToDoQty(list);
        return (GetStockCanToDoConditionInfo)map.get(stockid);
    }

    public static int manufactureOrderClosedCheck(Context ctx, BatchActionResults batchResults, ManufactureOrderInfo orderInfo) throws BOSException, EASBizException {
        int result = 1;
        if (orderInfo == null) {
            ArrayList idList = new ArrayList(batchResults.getToDoIdsList());
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("transactionType.*"));
            sic.add(new SelectorItemInfo("routing.*"));
            sic.add(new SelectorItemInfo("stocks.*"));
            sic.add(new SelectorItemInfo("expectOutputs.*"));
            sic.add(new SelectorItemInfo("technics.*"));
            filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(idList), CompareType.INCLUDE));
            viewInfo.setSelector(sic);
            viewInfo.setFilter(filter);
            ManufactureOrderCollection coll = ManufactureOrderFactory.getLocalInstance(ctx).getManufactureOrderCollection(viewInfo);
            MOUtil.MoClosedCommonCheck(ctx, coll, batchResults, false);
        } else {
            ManufactureOrderCollection coll = new ManufactureOrderCollection();
            coll.add(orderInfo);
            result = MOUtil.MoClosedCommonCheck(ctx, coll, batchResults, true);
        }
        return result;
    }

    public static String getString(Context ctx, String resourceName) {
        String path = "com.kingdee.eas.mm.mo.ManufactureOrderResource";
        String strTemp = ResourceBase.getString((String)path, (String)resourceName, (Locale)ctx.getLocale());
        if (strTemp.equals("Missing Resource")) {
            return "Missing Resource{" + resourceName + "}";
        }
        return strTemp;
    }

    public static String isManufactureOrderClosed(Context ctx, String idStr, BatchActionEnum action) throws BOSException, EASBizException {
        StringBuffer returnStr = new StringBuffer();
        StringBuffer selectSql = new StringBuffer();
        selectSql.append(" select distinct mo.fid fid, mo.fnumber fnumber");
        selectSql.append(" from T_MM_ManufactureOrder mo ");
        selectSql.append(" where mo.fid in (").append(idStr).append(") ");
        selectSql.append(" and mo.fBaseStatus in (6,7,11) ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSql.toString());
        String msg = null;
        if (action.equals((Object)BatchActionEnum.UNAUDIT)) {
            msg = ResourceUtils.getMessageForServer((String)"com.kingdee.eas.mm.mo.ScrapOrderResource", (String)"Unaudit_Order_Is_Closed");
        } else if (action.equals((Object)BatchActionEnum.DELETE)) {
            msg = ResourceUtils.getMessageForServer((String)"com.kingdee.eas.mm.mo.ScrapOrderResource", (String)"Delete_Order_Is_Closed");
        } else if (action.equals((Object)BatchActionEnum.AUDIT)) {
            msg = ResourceUtils.getMessageForServer((String)"com.kingdee.eas.mm.mo.ScrapOrderResource", (String)"Audit_Order_Is_Closed");
        }
        try {
            while (rs != null && rs.next()) {
                returnStr.append("[").append(rs.getString("fnumber")).append("]").append(msg).append("\r\n");
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return returnStr.toString();
    }

    public static BatchActionResults checkMOClose(Context ctx, BatchActionResults batchResults, String idStr, String tableName, BatchActionEnum action) throws BOSException, EASBizException {
        StringBuffer selectSql = new StringBuffer();
        selectSql.append(" select t.fid ");
        selectSql.append(" from T_MM_ManufactureOrder mo ");
        selectSql.append(" inner join ").append(tableName).append(" t on t.fSourceBillID = mo.fid ");
        selectSql.append(" where t.fid in (").append(idStr).append(") ").append(" and mo.fBaseStatus in (6,7,11)  and t.FsourceBillTypeid = 'B2aZSVXaSx6qxdfekgCmrEY+1VI=' ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSql.toString());
        String msg = null;
        msg = action.equals((Object)BatchActionEnum.UNAUDIT) ? ResourceUtils.getMessageForServer((String)"com.kingdee.eas.mm.mo.ScrapOrderResource", (String)"Unaudit_Order_Is_Closed") : ResourceUtils.getMessageForServer((String)"com.kingdee.eas.mm.mo.ScrapOrderResource", (String)"Audit_Order_Is_Closed");
        try {
            while (rs != null && rs.next()) {
                batchResults.addError(rs.getString("fid"), msg);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return batchResults;
    }

    private static int MoClosedCommonCheck(Context ctx, ManufactureOrderCollection moColl, BatchActionResults batchResults, boolean flag) throws BOSException, EASBizException {
        String id = null;
        String msg = null;
        String messageFormatString = null;
        BigDecimal one = new BigDecimal("1.0");
        int result = 1;
        ManufactureOrderStockCollection stockCol = null;
        ManufactureOrderStockInfo entry = null;
        BigDecimal orderQty = null;
        BigDecimal totalSplitQty = null;
        BigDecimal rejectedQty = null;
        BigDecimal totalDirectReceiveQty = null;
        BigDecimal plannedQty = null;
        BigDecimal wipQty = null;
        BigDecimal actIssueQty = null;
        BigDecimal extraRatio = null;
        BigDecimal lackRatio = null;
        BigDecimal finishedQty = null;
        BigDecimal toStroreQty = null;
        ManufactureOrderTechnicsCollection tecCol = null;
        ManufactureOrderTechnicsInfo tecEntry = null;
        BigDecimal reportQty = null;
        BigDecimal qty = null;
        BigDecimal totalQtyLower = null;
        BigDecimal totalQtyUpper = null;
        Iterator iterator = moColl.iterator();
        while (iterator.hasNext()) {
            int j;
            ISCMBillParam scmParam;
            String strAutoClose;
            ManufactureOrderInfo moInfo = (ManufactureOrderInfo)iterator.next();
            id = moInfo.getId() == null ? "NEWID" : moInfo.getId().toString();
            if (!moInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.COMPLETE)) {
                msg = MOUtil.getString(ctx, "STATUS_CANNT_FINISH1");
                batchResults.addError(id, msg);
            }
            if (!flag && !batchResults.isToDo(id)) continue;
            IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
            BOTRelationCollection botcoll = iBTPManager.getDestRelation(id);
            boolean autoClose = false;
            if (flag && (strAutoClose = (scmParam = SCMBillParamFactory.getLocalInstance((Context)ctx)).getParamByBillTypeID("MM_Close_01", 4, moInfo.getStorageOrgUnit().getId().toString(), billTypeId)) != null && strAutoClose.trim().length() != 0 && strAutoClose.trim().toLowerCase().equals("1")) {
                autoClose = true;
            }
            for (j = 0; j < botcoll.size(); ++j) {
                IRowSet resultSet;
                String sql;
                String destObjectid;
                String destEntityid;
                block34: {
                    BOTRelationInfo botInfo = botcoll.get(j);
                    destEntityid = botInfo.getDestEntityID();
                    destObjectid = botInfo.getDestObjectID();
                    if (moInfo.getTransactionType() != null && moInfo.getTransactionType().isIsWPManagement()) {
                        if ("6F0D8519".equals(destEntityid)) {
                            sql = " select Fbasestatus from t_mm_distaskdispatch where fbasestatus<4 and fid='" + destObjectid + "'";
                            resultSet = DbUtil.executeQuery((Context)ctx, (String)sql);
                            try {
                                if (resultSet.next()) {
                                    msg = MOUtil.getString(ctx, "OrderHasAuditDest");
                                    batchResults.addError(id, msg);
                                    if (!flag) break;
                                    result = autoClose ? 2 : 3;
                                    return result;
                                }
                                break block34;
                            }
                            catch (SQLException e) {
                                throw new BOSException((Throwable)e);
                            }
                        }
                        if ("DFBE5164".equals(destEntityid)) {
                            sql = " select Fbasestatus from T_MM_CompletionReport where fbasestatus<4 and fid='" + destObjectid + "'";
                            resultSet = DbUtil.executeQuery((Context)ctx, (String)sql);
                            try {
                                if (resultSet.next()) {
                                    msg = MOUtil.getString(ctx, "OrderHasAuditDest");
                                    batchResults.addError(id, msg);
                                    if (!flag) break;
                                    result = autoClose ? 2 : 3;
                                    return result;
                                }
                                break block34;
                            }
                            catch (SQLException e) {
                                throw new BOSException((Throwable)e);
                            }
                        }
                        if ("200BB61F".equals(destEntityid)) {
                            sql = " select Fbasestatus from T_MM_WPTransferBill where fbasestatus<4 and fid='" + destObjectid + "'";
                            resultSet = DbUtil.executeQuery((Context)ctx, (String)sql);
                            try {
                                if (resultSet.next()) {
                                    msg = MOUtil.getString(ctx, "OrderHasAuditDest");
                                    batchResults.addError(id, msg);
                                    if (!flag) break;
                                    result = autoClose ? 2 : 3;
                                    return result;
                                }
                            }
                            catch (SQLException e) {
                                throw new BOSException((Throwable)e);
                            }
                        }
                    }
                }
                if ("FA1292B4".equals(destEntityid)) {
                    sql = " select Fbasestatus from T_IM_ManufactureRecBill where fbasestatus<4 and fid='" + destObjectid + "'";
                    resultSet = DbUtil.executeQuery((Context)ctx, (String)sql);
                    try {
                        if (!resultSet.next()) continue;
                        msg = MOUtil.getString(ctx, "OrderHasAuditDest");
                        batchResults.addError(id, msg);
                        if (!flag) break;
                        result = autoClose ? 2 : 3;
                        return result;
                    }
                    catch (SQLException e) {
                        throw new BOSException((Throwable)e);
                    }
                }
                if ("76C9F8D8".equals(destEntityid)) {
                    sql = " select Fbasestatus from T_MM_DirectDeliveryBill where fbasestatus<4 and fid='" + destObjectid + "'";
                    resultSet = DbUtil.executeQuery((Context)ctx, (String)sql);
                    try {
                        if (!resultSet.next()) continue;
                        msg = MOUtil.getString(ctx, "OrderHasAuditDest");
                        batchResults.addError(id, msg);
                        if (!flag) break;
                        result = autoClose ? 2 : 3;
                        return result;
                    }
                    catch (SQLException e) {
                        throw new BOSException((Throwable)e);
                    }
                }
                if (!"500AB75E".equals(destEntityid)) continue;
                sql = " select Fbasestatus from T_IM_MaterialReqBill where fbasestatus<4 and fid='" + destObjectid + "'";
                resultSet = DbUtil.executeQuery((Context)ctx, (String)sql);
                try {
                    if (!resultSet.next()) continue;
                    msg = MOUtil.getString(ctx, "OrderHasAuditDest");
                    batchResults.addError(id, msg);
                    if (!flag) break;
                    result = autoClose ? 2 : 3;
                    return result;
                }
                catch (SQLException e) {
                    throw new BOSException((Throwable)e);
                }
            }
            if (flag) {
                result = autoClose ? 2 : 3;
            }
            stockCol = moInfo.getStocks();
            finishedQty = moInfo.getFinishedQty();
            toStroreQty = moInfo.getToStroreQty();
            orderQty = moInfo.getQty();
            totalSplitQty = moInfo.getTotalSplitQty();
            for (j = 0; j < stockCol.size(); ++j) {
                MessageFormat messageFormat;
                entry = stockCol.get(j);
                boolean isQtyLimt = entry.isIsQtyLimit();
                plannedQty = entry.getPlannedQty();
                actIssueQty = entry.getActIssueQty();
                wipQty = entry.getWipQty();
                extraRatio = entry.getExtraRatio().multiply(new BigDecimal("0.01"));
                lackRatio = entry.getLackRatio().multiply(new BigDecimal("0.01"));
                rejectedQty = entry.getRejectedQty();
                totalDirectReceiveQty = entry.getTotalDirectReceiveQty();
                if (isQtyLimt && actIssueQty.subtract(rejectedQty).compareTo(plannedQty.multiply(one.subtract(lackRatio))) < 0) {
                    messageFormatString = MOUtil.getString(ctx, "ACTISSUEQTY_LESS_PLANNEDQTYLACK");
                    messageFormat = new MessageFormat(messageFormatString);
                    msg = messageFormat.format(new String[]{" " + (j + 1) + " "});
                    batchResults.addError(id, msg);
                }
                if (wipQty.compareTo(SysConstant.BIGZERO) != 0) {
                    messageFormatString = MOUtil.getString(ctx, "WIPQTY_NOT_ZERO");
                    messageFormat = new MessageFormat(messageFormatString);
                    msg = messageFormat.format(new String[]{" " + (j + 1) + " "});
                    batchResults.addError(id, msg);
                }
                if (moInfo.getTransactionType() != null && moInfo.getTransactionType().isIsWPManagement()) {
                    if (orderQty.subtract(totalSplitQty).compareTo(new BigDecimal(0)) > 0) {
                        if (actIssueQty.subtract(rejectedQty).compareTo(finishedQty.multiply(plannedQty.divide(orderQty.subtract(totalSplitQty), 8, 4))) >= 0) continue;
                        messageFormatString = MOUtil.getString(ctx, "ACTISSUEQTY_LESS_PLANNEDQTY");
                        messageFormat = new MessageFormat(messageFormatString);
                        msg = messageFormat.format(new String[]{" " + (j + 1) + " "});
                        batchResults.addError(id, msg);
                        continue;
                    }
                    if (actIssueQty.subtract(rejectedQty).compareTo(new BigDecimal(0)) >= 0) continue;
                    messageFormatString = MOUtil.getString(ctx, "ACTISSUEQTY_LESS_PLANNEDQTY");
                    messageFormat = new MessageFormat(messageFormatString);
                    msg = messageFormat.format(new String[]{" " + (j + 1) + " "});
                    batchResults.addError(id, msg);
                    continue;
                }
                if (moInfo.getTransactionType() == null || moInfo.getTransactionType().isIsWPManagement()) continue;
                if (orderQty.subtract(totalSplitQty).compareTo(new BigDecimal(0)) > 0) {
                    if (actIssueQty.subtract(rejectedQty).compareTo(toStroreQty.multiply(plannedQty.divide(orderQty.subtract(totalSplitQty), 8, 4))) >= 0) continue;
                    messageFormatString = MOUtil.getString(ctx, "ACTISSUEQTY_LESS_TOSTORAGEQTY");
                    messageFormat = new MessageFormat(messageFormatString);
                    msg = messageFormat.format(new String[]{" " + (j + 1) + " "});
                    batchResults.addError(id, msg);
                    continue;
                }
                if (actIssueQty.subtract(rejectedQty).compareTo(new BigDecimal(0)) >= 0) continue;
                messageFormatString = MOUtil.getString(ctx, "ACTISSUEQTY_LESS_TOSTORAGEQTY");
                messageFormat = new MessageFormat(messageFormatString);
                msg = messageFormat.format(new String[]{" " + (j + 1) + " "});
                batchResults.addError(id, msg);
            }
            if (moInfo.getTransactionType() != null && moInfo.getTransactionType().isIsWPManagement() && finishedQty.compareTo(toStroreQty) != 0) {
                msg = MOUtil.getString(ctx, "FINISHEDQTY_NOTEQUAL_TOSTROREQTY");
                batchResults.addError(id, msg);
            }
            tecCol = moInfo.getTechnics();
            for (j = 0; j < tecCol.size(); ++j) {
                tecEntry = tecCol.get(j);
                if (!tecEntry.isIsReportPoint()) continue;
                reportQty = tecEntry.getFinishedQty();
                qty = tecEntry.getQty();
                totalQtyLower = tecEntry.getTotalQtyLower().multiply(new BigDecimal("0.01"));
                totalQtyUpper = tecEntry.getTotalQtyUpper().multiply(new BigDecimal("0.01"));
                if (reportQty.compareTo(qty.multiply(new BigDecimal("1.00").subtract(totalQtyLower))) >= 0 || moInfo.getTransactionType() == null || !moInfo.getTransactionType().isIsWPManagement() || !tecEntry.getOverrunMeasure().equals((Object)OverRunMeasureEnum.REFUSE) && !tecEntry.getOverrunMeasure().equals((Object)OverRunMeasureEnum.WARNING)) continue;
                messageFormatString = MOUtil.getString(ctx, "REPORTQTY_LESS_QTY");
                MessageFormat messageFormat = new MessageFormat(messageFormatString);
                msg = messageFormat.format(new String[]{" " + (j + 1) + " "});
                batchResults.addError(id, msg);
            }
        }
        return result;
    }

    private static void BacthExecMoClosed(Context ctx, ManufactureOrderCollection moColl, boolean flag) throws BOSException, EASBizException {
        Set idSet = MOUtil.getStrIds(moColl);
        if (idSet != null) {
            StringBuffer updateSQLBuffer = new StringBuffer();
            updateSQLBuffer.append("update T_MM_ManufactureOrder set ");
            if (flag) {
                updateSQLBuffer.append(" fbasestatus=7 ");
            } else {
                updateSQLBuffer.append(" fbasestatus=8 ");
            }
            updateSQLBuffer.append(" where fid in (" + idSet + ") ");
            if (flag) {
                updateSQLBuffer.append(" and fbasestatus=8 ");
            } else {
                updateSQLBuffer.append(" and fbasestatus=7 ");
            }
            DbUtil.execute((Context)ctx, (String)updateSQLBuffer.toString());
        }
    }

    private static Set getStrIds(AbstractObjectCollection collection) {
        if (collection != null) {
            HashSet<String> idSet = new HashSet<String>();
            for (SCMBillBaseInfo info : collection) {
                idSet.add(new String("'" + info.getId().toString() + "'"));
            }
            return idSet;
        }
        return null;
    }

    public static int AutoExecMoClosedOrNot(Context ctx, boolean flag) throws BOSException, EASBizException {
        int result = 0;
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("transactionType.*"));
        sic.add(new SelectorItemInfo("routing.*"));
        sic.add(new SelectorItemInfo("stocks.*"));
        sic.add(new SelectorItemInfo("expectOutputs.*"));
        sic.add(new SelectorItemInfo("technics.*"));
        if (flag) {
            filter.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)BillBaseStatusEnum.COMPLETE, CompareType.EQUALS));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)BillBaseStatusEnum.CLOSED, CompareType.EQUALS));
        }
        HashSet<String> orgSet = new HashSet<String>();
        OrgUnitInfo[] mainOrgs = SCMServiceFactory.getLocalInstance((Context)ctx).getAuthorizedBizOrgUnits(ctx.getCaller(), OrgType.Storage, null);
        for (int i = 0; i < mainOrgs.length; ++i) {
            orgSet.add(mainOrgs[i].getId().toString());
        }
        filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit", orgSet, CompareType.INCLUDE));
        viewInfo.setSelector(sic);
        viewInfo.setFilter(filter);
        ManufactureOrderCollection moColl = ManufactureOrderFactory.getLocalInstance(ctx).getManufactureOrderCollection(viewInfo);
        if (moColl.size() > 0) {
            if (flag) {
                BatchActionResults batchResults = new BatchActionResults();
                result = MOUtil.MoClosedCommonCheck(ctx, moColl, batchResults, false);
            }
            MOUtil.BacthExecMoClosed(ctx, moColl, flag);
        }
        return result;
    }
}

