/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.mo.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.client.util.PermissionHelper;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.mm.mo.IManufactureOrderScheduleFacade;
import com.kingdee.eas.mm.mo.ManufactureOrderInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderScheduleFacadeFactory;
import com.kingdee.eas.mm.mo.ManufactureOrderTechnicsInfo;
import com.kingdee.eas.mm.mo.client.ManufactureOrderEditUI;
import com.kingdee.eas.mm.project.client.MMGanttProject;
import com.kingdee.eas.mm.project.client.ProjectUtil;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.GanttTask;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.IGanttProject;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.action.task.TaskActionBase;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.UIFacade;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.TaskSelectionManager;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class MOShedulePropertiesAction
extends TaskActionBase {
    private static final long serialVersionUID = 1L;
    private IGanttProject myProject;
    private IUIWindow dialog = null;

    public MOShedulePropertiesAction(IGanttProject project, TaskSelectionManager selectionManager, UIFacade uiFacade) {
        super(project.getTaskManager(), selectionManager, uiFacade);
        this.myProject = project;
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(76, 128));
    }

    protected void run(List selection, int tabIndex) throws BOSException {
        if (selection == null || selection.size() != 1) {
            MsgBox.showInfo((String)ProjectUtil.getResource((String)"com.kingdee.eas.mm.project.WBSResource", (String)"CHOOSE_ONE_ROW"));
            SysUtil.abort();
            return;
        }
        GanttTask[] tasks = new GanttTask[]{(GanttTask)selection.get(0)};
        BOSUuid rootID = null;
        String storageId = null;
        CoreBaseInfo selectObject = (CoreBaseInfo)tasks[0].getUserObject();
        if (selectObject instanceof ManufactureOrderInfo) {
            rootID = selectObject.getId();
            storageId = ((ManufactureOrderInfo)selectObject).getStorageOrgUnit().getId().toString();
        } else if (selectObject instanceof ManufactureOrderTechnicsInfo) {
            rootID = ((ManufactureOrderTechnicsInfo)selectObject).getParent().getId();
            IManufactureOrderScheduleFacade iMoShedulle = ManufactureOrderScheduleFacadeFactory.getRemoteInstance();
            try {
                Map map = iMoShedulle.getBillInfoByEntryId(((ManufactureOrderTechnicsInfo)selectObject).getId().toString());
                storageId = (String)map.get("storageUnitId");
            }
            catch (EASBizException e) {
                ExceptionHandler.handle((Throwable)e);
                SysUtil.abort();
            }
        }
        this.checkPermission("mm_mo_view", storageId);
        UIContext context = new UIContext();
        context.put((Object)"ID", (Object)rootID.toString());
        this.dialog = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(((MMGanttProject)this.myProject).getTaskPropertiesUI(), (Map)context, null, OprtState.VIEW);
        this.dialog.show();
        ((ManufactureOrderEditUI)this.dialog.getUIObject()).requestFocusInWindow();
        SwingUtilities.invokeLater(new Thread(){

            @Override
            public void run() {
                MOShedulePropertiesAction.this.dialog.show();
                ((ManufactureOrderEditUI)MOShedulePropertiesAction.this.dialog.getUIObject()).requestFocusInWindow();
            }
        });
    }

    protected String getLocalizedName() {
        return this.getMoScheduleResource("view");
    }

    protected String getTooltipText() {
        return this.getMoScheduleResource("view");
    }

    public void setIconSize(String iconSize) {
        Icon icon = EASResource.getIcon((String)"imgTbtn_view");
        if (icon != null) {
            this.putValue("SmallIcon", icon);
            this.myIcon = icon;
        }
    }

    protected boolean isEnabled(List selection) {
        return true;
    }

    protected void run(List selection) throws BOSException {
        this.run(selection, 0);
    }

    protected String getIconFilePrefix() {
        return "properties_";
    }

    public String getMoScheduleResource(String key) {
        return EASResource.getString((String)("com.kingdee.eas.mm.mo.MOSheduleResource." + key));
    }

    protected void checkPermission(String permission, String storageUnitId) throws BOSException {
        if (!permission.equals("")) {
            try {
                if (storageUnitId != null && !"".equals(storageUnitId)) {
                    PermissionHelper.checkFunctionPermission((IObjectPK)this.getUserPk(), (IObjectPK)new ObjectUuidPK(storageUnitId), (String)permission);
                } else {
                    PermissionHelper.checkFunctionPermission((IObjectPK)this.getUserPk(), null, (String)permission);
                }
            }
            catch (EASBizException e) {
                ExceptionHandler.handle((Throwable)e);
                SysUtil.abort();
            }
        }
    }

    private IObjectPK getUserPk() {
        UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
        ObjectUuidPK userPK = new ObjectUuidPK(userInfo.getId());
        return userPK;
    }
}

