/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.mo.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.mm.mo.client.AbstractMOWIPMaterialUI;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class MOWIPMaterialUI
extends AbstractMOWIPMaterialUI {
    private static final long serialVersionUID = 3951172278963154042L;
    private static final Logger logger = CoreUIObject.getLogger(MOWIPMaterialUI.class);
    private boolean isConfirm = false;

    public MOWIPMaterialUI() throws Exception {
        this.kdtMain.checkParsed();
        this.kdtMain.getActionMap().remove("Paste");
        this.kdtMain.getActionMap().remove("Delete");
        this.kdtMain.getActionMap().remove("Copy");
        this.kdtMain.getActionMap().remove("Cut");
    }

    public void onLoad() throws Exception {
        this.kdtMain.getGroupManager().setGroup(true);
        this.kdtMain.getColumn("orderNumber").setGroup(true);
        this.kdtMain.getColumn("orderNumber").setMergeable(true);
        IRowSet rs = (IRowSet)this.getUIContext().get("WIP_RS");
        if (rs != null) {
            String[] qtyCols = new String[]{"plannedQty", "actureIssueQty", "wipQty"};
            String oldNumber = null;
            int fromRow = -1;
            rs.beforeFirst();
            while (rs != null && rs.next()) {
                IRow row = this.kdtMain.addRow();
                String theNumber = rs.getString("fnumber");
                row.getCell("selectFlag").setValue((Object)Boolean.FALSE);
                row.getCell("orderID").setValue((Object)rs.getString("fid"));
                row.getCell("orderNumber").setValue((Object)theNumber);
                row.getCell("materialNumber").setValue((Object)rs.getString("fmaterialnumber"));
                row.getCell("materialName").setValue((Object)rs.getString("fmaterialname"));
                row.getCell("materialModel").setValue((Object)rs.getString("fmodel"));
                row.getCell("materialUnit").setValue((Object)rs.getString("funitname"));
                row.getCell("operationNO").setValue((Object)rs.getString("FOperationNo"));
                row.getCell("plannedQty").setValue((Object)rs.getBigDecimal("FPlannedQty"));
                row.getCell("actureIssueQty").setValue((Object)rs.getBigDecimal("FActIssueQty"));
                row.getCell("wipQty").setValue((Object)rs.getBigDecimal("FWipQty"));
                int prec = rs.getInt("FQtyPrecision");
                SCMClientUtils.changeTableColPrecision((int)prec, (KDTable)this.kdtMain, (String[])qtyCols, (int)row.getRowIndex());
                if (oldNumber != null && oldNumber.equals(theNumber)) continue;
                if (oldNumber != null) {
                    this.kdtMain.getMergeManager().mergeBlock(fromRow, 0, row.getRowIndex() > 0 ? row.getRowIndex() - 1 : 0, 0);
                }
                oldNumber = theNumber;
                fromRow = row.getRowIndex();
            }
            if (fromRow != -1) {
                this.kdtMain.getMergeManager().mergeBlock(fromRow, 0, this.kdtMain.getRowCount() - 1, 0);
            }
        }
    }

    @Override
    public void actionOK_actionPerformed(ActionEvent e) throws Exception {
        this.isConfirm = true;
        this.actionExitCurrent_actionPerformed(e);
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.isConfirm = false;
        this.actionExitCurrent_actionPerformed(e);
    }

    public Set getOrderIDS() {
        HashSet<Object> idSet = new HashSet<Object>();
        if (this.isConfirm) {
            for (int i = 0; i < this.kdtMain.getRowCount(); ++i) {
                boolean selected = (Boolean)this.kdtMain.getCell(i, "selectFlag").getValue();
                if (!selected) continue;
                idSet.add(this.kdtMain.getCell(i, "orderID").getValue());
            }
        }
        return idSet;
    }

    public boolean isConfirm() {
        return this.isConfirm;
    }
}

