/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.mo.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.im.inv.IWarehouse;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseFactory;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.client.multiDetail.DetailPanel;
import com.kingdee.eas.mm.mo.IdleWarehouseRangeEnum;
import com.kingdee.eas.mm.mo.PriorityEnum;
import com.kingdee.eas.mm.mo.client.AbstractMaterialParamSettingUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class MaterialParamSettingUI
extends AbstractMaterialParamSettingUI {
    private static String CLEAR_ITEM = "ClearItem";
    protected DetailPanel tblWareHouse_detailPanel = null;
    private static final String NUMBER = "number";
    private static final String NAME = "name";
    private static final Logger logger = CoreUIObject.getLogger(MaterialParamSettingUI.class);

    public MaterialParamSettingUI() throws Exception {
        this.kDTable.checkParsed();
    }

    public MaterialParamSettingUI(StorageOrgUnitInfo storage) throws Exception {
        this();
        this.prmtStorageOrgUnit.setValue((Object)storage);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.kDComProprityRule.getActionMap().remove(CLEAR_ITEM);
        this.kDCombWareHouseRange.getActionMap().remove(CLEAR_ITEM);
        this.initKDWorkButtion();
        this.registerCustomerBindings();
    }

    protected void initListener() {
        super.initListener();
        this.kDCombWareHouseRange.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                MaterialParamSettingUI.this.btnState_changed(e);
            }
        });
        this.kDTable.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                int colIndex = e.getColIndex();
                int rowIndex = e.getRowIndex();
                if (colIndex == MaterialParamSettingUI.this.kDTable.getColumnIndex(MaterialParamSettingUI.NUMBER) && MaterialParamSettingUI.this.kDTable.getCell(rowIndex, MaterialParamSettingUI.NUMBER).getValue() != null) {
                    WarehouseInfo info = (WarehouseInfo)MaterialParamSettingUI.this.kDTable.getCell(rowIndex, MaterialParamSettingUI.NUMBER).getValue();
                    MaterialParamSettingUI.this.kDTable.getCell(rowIndex, MaterialParamSettingUI.NAME).setValue((Object)info.getName());
                }
            }
        });
    }

    protected void btnState_changed(ItemEvent e) {
        Object selectedItem = this.kDCombWareHouseRange.getSelectedItem();
        if (selectedItem.equals((Object)IdleWarehouseRangeEnum.CUSTOM_WAREHOUSE)) {
            this.enable_btnDisable(true);
        } else {
            this.enable_btnDisable(false);
            this.kDTable.refresh();
        }
    }

    protected void enable_btnDisable(boolean isAble) {
        this.btnAdd.setEnabled(isAble);
        this.btnInsert.setEnabled(isAble);
        this.btnRemove.setEnabled(isAble);
        this.kDTable.setEnabled(isAble);
        this.kDTable.setEditable(isAble);
    }

    protected void registerCustomerBindings() {
        ObjectValueRender numberValueRender = new ObjectValueRender();
        numberValueRender.setFormat((IDataFormat)new BizDataFormat("$number$"));
        this.kDTable.getColumn(NUMBER).setRenderer((IBasicRender)numberValueRender);
        KDBizPromptBox kDTable_F7WareHouse_PromptBox = new KDBizPromptBox();
        kDTable_F7WareHouse_PromptBox.setQueryInfo("com.kingdee.eas.basedata.scm.im.inv.app.F7AllWarehouseQuery");
        kDTable_F7WareHouse_PromptBox.setVisible(true);
        kDTable_F7WareHouse_PromptBox.setEditable(true);
        kDTable_F7WareHouse_PromptBox.setDisplayFormat("$number$");
        kDTable_F7WareHouse_PromptBox.setEditFormat("$number$");
        kDTable_F7WareHouse_PromptBox.setCommitFormat("$number$");
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.setMaskString(" (#0 OR #1) AND #2 AND #3 ");
        filterInfo.getFilterItems().add(new FilterItemInfo("transState", (Object)String.valueOf("1")));
        filterInfo.getFilterItems().add(new FilterItemInfo("transState", (Object)String.valueOf("2")));
        filterInfo.getFilterItems().add(new FilterItemInfo("storageOrg.id", (Object)((StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue()).getId(), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("whState", (Object)String.valueOf("1")));
        view.setFilter(filterInfo);
        kDTable_F7WareHouse_PromptBox.setEntityViewInfo(view);
        KDTDefaultCellEditor kDTable_WareHouse_CellEditor = new KDTDefaultCellEditor((IKDEditor)kDTable_F7WareHouse_PromptBox);
        this.kDTable.getColumn(NUMBER).setEditor((ICellEditor)kDTable_WareHouse_CellEditor);
    }

    public FilterInfo getFilterInfo() {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isOccupy", (Object)new Boolean(this.cbIsOrderOccupy.isSelected()), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("priorityRule", (Object)new Integer(((PriorityEnum)((Object)this.kDComProprityRule.getSelectedItem())).getValue()), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("warehouseRange", (Object)new Integer(((IdleWarehouseRangeEnum)((Object)this.kDCombWareHouseRange.getSelectedItem())).getValue()), CompareType.EQUALS));
        if (this.kDCombWareHouseRange.getSelectedItem().equals((Object)IdleWarehouseRangeEnum.CUSTOM_WAREHOUSE)) {
            HashSet<String> set = new HashSet<String>();
            if (this.kDTable.getRowCount() != 0) {
                for (int i = 0; i < this.kDTable.getRowCount(); ++i) {
                    WarehouseInfo wareHouse = (WarehouseInfo)this.kDTable.getCell(i, NUMBER).getValue();
                    if (wareHouse == null) continue;
                    set.add(wareHouse.getId().toString());
                }
            }
            filter.getFilterItems().add(new FilterItemInfo("warehouseID", set, CompareType.INCLUDE));
        }
        return filter;
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmtStorageOrgUnit;
    }

    public void clear() {
        this.setDefaultValue();
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        this.clear();
        FilterInfo filter = entityViewInfo.getFilter();
        FilterItemCollection item = filter.getFilterItems();
        for (int i = 0; i < item.size(); ++i) {
            FilterItemInfo itemInfo = item.get(i);
            if (itemInfo.getPropertyName().equals("isOccupy")) {
                if (itemInfo.getCompareValue().equals(new Integer(0))) {
                    this.cbIsOrderOccupy.setSelected(false);
                    continue;
                }
                this.cbIsOrderOccupy.setSelected(true);
                continue;
            }
            if (itemInfo.getPropertyName().equals("priorityRule")) {
                if (itemInfo.getCompareValue().equals(new Integer(10))) {
                    this.kDComProprityRule.setSelectedItem((Object)PriorityEnum.STARTDATE);
                    continue;
                }
                this.kDComProprityRule.setSelectedItem((Object)PriorityEnum.ENDDATE);
                continue;
            }
            if (itemInfo.getPropertyName().equals("warehouseRange")) {
                if (itemInfo.getCompareValue().equals(new Integer(10))) {
                    this.kDCombWareHouseRange.setSelectedItem((Object)IdleWarehouseRangeEnum.ALL_WAREHOUSE);
                    this.kDTable.refresh();
                    continue;
                }
                if (itemInfo.getCompareValue().equals(new Integer(20))) {
                    this.kDCombWareHouseRange.setSelectedItem((Object)IdleWarehouseRangeEnum.ONLY_PICKWAREHOUSE);
                    this.kDTable.refresh();
                    continue;
                }
                this.kDCombWareHouseRange.setSelectedItem((Object)IdleWarehouseRangeEnum.CUSTOM_WAREHOUSE);
                continue;
            }
            try {
                this.loadWarehouseTokdTabl(itemInfo.getCompareValue());
                continue;
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        }
    }

    private void loadWarehouseTokdTabl(Object compareValue) throws BOSException {
        if (compareValue != null) {
            HashSet set = (HashSet)compareValue;
            Iterator it = set.iterator();
            StringBuffer sb = new StringBuffer("");
            while (it.hasNext()) {
                sb.append(it.next());
                if (!it.hasNext()) continue;
                sb.append(",");
            }
            IWarehouse warehouse = WarehouseFactory.getRemoteInstance();
            CoreBaseCollection items = warehouse.getCollection("select id,name,number where id in ('" + sb.toString().replaceAll(",", "','") + "')");
            if (items.size() > 0) {
                for (int i = 0; i < items.size(); ++i) {
                    this.kDTable.addRow();
                    this.kDTable.getCell(i, NUMBER).setValue((Object)items.get(i));
                    this.kDTable.getCell(i, NAME).setValue((Object)((WarehouseInfo)items.get(i)).getName());
                }
            }
        }
    }

    private void setDefaultValue() {
        this.cbIsOrderOccupy.setSelected(true);
        this.kDComProprityRule.setSelectedItem((Object)PriorityEnum.STARTDATE);
        this.kDCombWareHouseRange.setSelectedItem((Object)IdleWarehouseRangeEnum.ALL_WAREHOUSE);
        this.kDTable.refresh();
    }

    public void initKDWorkButtion() {
        this.enable_btnDisable(false);
    }

    @Override
    public void actionInsertLine_actionPerformed(ActionEvent e) throws Exception {
        IRow row = null;
        if (this.kDTable.getSelectManager().size() > 0) {
            int top = this.kDTable.getSelectManager().get().getTop();
            row = this.isTableColumnSelected(this.kDTable) ? this.kDTable.addRow() : this.kDTable.addRow(top);
        } else {
            row = this.kDTable.addRow();
        }
    }

    @Override
    public void actionRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        if (this.kDTable.getSelectManager().size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
            return;
        }
        int top = this.kDTable.getSelectManager().getActiveRowIndex();
        int[] selectRowIndexs = KDTableUtil.getSelectedRows((KDTable)this.kDTable);
        if (this.kDTable.getRow(top) == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
            return;
        }
        for (int i = 0; i < selectRowIndexs.length; ++i) {
            this.kDTable.removeRow(selectRowIndexs[i]);
        }
    }

    @Override
    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        IRow row = this.kDTable.addRow();
    }

    private boolean isTableColumnSelected(KDTable table) {
        KDTSelectBlock block;
        return table.getSelectManager().size() > 0 && ((block = table.getSelectManager().get()).getMode() == 4 || block.getMode() == 8);
    }

    public boolean verify() {
        if (this.kDCombWareHouseRange.getSelectedItem().equals((Object)IdleWarehouseRangeEnum.CUSTOM_WAREHOUSE)) {
            if (this.kDTable.getRowCount() == 0) {
                MsgBox.showInfo((String)this.getResource("CUSTOMWAREHOUSE_NOTNULL"));
                return false;
            }
            ArrayList<String> list = new ArrayList<String>();
            for (int i = 0; i < this.kDTable.getRowCount(); ++i) {
                WarehouseInfo wareHouse = (WarehouseInfo)this.kDTable.getCell(i, NUMBER).getValue();
                if (wareHouse != null) continue;
                list.add("null");
            }
            if (list.size() == this.kDTable.getRowCount()) {
                MsgBox.showInfo((String)this.getResource("CUSTOMWAREHOUSE_NOTNULL"));
                return false;
            }
        }
        return super.verify();
    }

    public String getResource(String key) {
        return EASResource.getString((String)"com.kingdee.eas.mm.mo.MaterialTransactionPlatformResource", (String)key);
    }
}

