/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.mo.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.mm.common.client.MMUtils;
import com.kingdee.eas.mm.common.client.UIHelper;
import com.kingdee.eas.mm.mo.client.AbstractOrderSimulationFilterUI;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.scm.common.verify.VerifyItem;
import com.kingdee.eas.scm.common.verify.VerifyType;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import org.apache.log4j.Logger;

public class OrderSimulationFilterUI
extends AbstractOrderSimulationFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(OrderSimulationFilterUI.class);
    private StorageOrgUnitInfo storage;
    public static final String KEY_STARTDATE = "startDate";
    public static final String KEY_ENDDATE = "endDate";
    protected KDBizPromptBox[] disableCommitF7;

    public OrderSimulationFilterUI(StorageOrgUnitInfo storage) throws Exception {
        this.disableCommitF7 = new KDBizPromptBox[]{this.prmtmaterialfrom, this.prmtmaterialto};
        this.setStorage(storage);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.setMaterialFilter(this.prmtmaterialfrom);
        this.setMaterialFilter(this.prmtmaterialto);
        this.prmtStorageOrgUnit.setEditable(false);
        this.prmtStorageOrgUnit.setEnabled(false);
        SingleFilterElement mainOrgElement = new SingleFilterElement("storageOrgUnitnum", (Component)this.prmtStorageOrgUnit);
        mainOrgElement.addVerifyItem(new VerifyItem(VerifyType.REQUIRED_TYPE, this.getResource("Stroage_IsNotNull")));
        mainOrgElement.setDefaultValue((Object)this.getStorage());
        CompositeFilterElement elements = new CompositeFilterElement(0);
        elements.add((FilterElement)mainOrgElement);
        SingleFilterElement floworder = new SingleFilterElement("kdcheckboxfloworder", (Component)this.kdcheckboxfloworder);
        floworder.setDefaultValue((Object)new Boolean(false));
        elements.add((FilterElement)floworder);
        SingleFilterElement scraporder = new SingleFilterElement("kdcheckboxscraporder", (Component)this.kdcheckboxscraporder);
        scraporder.setDefaultValue((Object)new Boolean(false));
        elements.add((FilterElement)scraporder);
        SingleFilterElement planorder = new SingleFilterElement("kDCheckBoxplanorder", (Component)this.kDCheckBoxplanorder);
        planorder.setDefaultValue((Object)new Boolean(false));
        elements.add((FilterElement)planorder);
        SingleFilterElement checkboxsave = new SingleFilterElement("kDCheckBoxsave", (Component)this.kDCheckBoxsave);
        checkboxsave.setDefaultValue((Object)new Boolean(false));
        elements.add((FilterElement)checkboxsave);
        SingleFilterElement checkboxcommit = new SingleFilterElement("kDCheckBoxcommit", (Component)this.kDCheckBoxcommit);
        checkboxcommit.setDefaultValue((Object)new Boolean(false));
        elements.add((FilterElement)checkboxcommit);
        SingleFilterElement checkboxaudit = new SingleFilterElement("kDCheckBoxaudit", (Component)this.kDCheckBoxaudit);
        checkboxaudit.setDefaultValue((Object)new Boolean(false));
        elements.add((FilterElement)checkboxaudit);
        SingleFilterElement materialFrom = new SingleFilterElement("materialfrom", (Component)this.prmtmaterialfrom);
        elements.add((FilterElement)materialFrom);
        SingleFilterElement materialTo = new SingleFilterElement("materialto", (Component)this.prmtmaterialto);
        elements.add((FilterElement)materialTo);
        SingleFilterElement adminFrom = new SingleFilterElement("orgunitfrom", (Component)this.orgunitfrom);
        elements.add((FilterElement)adminFrom);
        UIHelper.registerTrackNumberF7ForFilter((KDBizPromptBox)this.getMainBizOrgF7(), (KDBizPromptBox)this.prmtTrackNumStart);
        UIHelper.registerTrackNumberF7ForFilter((KDBizPromptBox)this.getMainBizOrgF7(), (KDBizPromptBox)this.prmtTrackNumEnd);
        SingleFilterElement trackNumStart = new SingleFilterElement("prmtTrackNumStart", (Component)this.prmtTrackNumStart);
        elements.add((FilterElement)trackNumStart);
        SingleFilterElement trackNumEnd = new SingleFilterElement("prmtTrackNumEnd", (Component)this.prmtTrackNumEnd);
        elements.add((FilterElement)trackNumEnd);
        SingleFilterElement startdate = new SingleFilterElement("startdatefrom", (Component)this.startdatefrom);
        SingleFilterElement stardateto = new SingleFilterElement("startdateto", (Component)this.startdateto);
        this.startdatefrom.setTimeEnabled(false);
        this.startdateto.setTimeEnabled(false);
        elements.add((FilterElement)startdate);
        elements.add((FilterElement)stardateto);
        SingleFilterElement endFrom = new SingleFilterElement("enddatefrom", (Component)this.enddatefrom);
        SingleFilterElement endTo = new SingleFilterElement("enddateto", (Component)this.enddateto);
        this.enddatefrom.setTimeEnabled(false);
        this.enddateto.setTimeEnabled(false);
        elements.add((FilterElement)endFrom);
        elements.add((FilterElement)endTo);
        elements.add((FilterElement)mainOrgElement);
        this.getFilterManager().setElement((FilterElement)elements);
        this.getFilterManager().setMainOrgElement((FilterElement)mainOrgElement, this.getPropertyOfMainBizOrg());
        MMUtils.initWorkshopF7((KDBizPromptBox)this.orgunitfrom, (StorageOrgUnitInfo)this.getStorage());
        MMUtils.resetF7CommitParser((KDBizPromptBox[])this.disableCommitF7);
    }

    private void setMaterialFilter(KDBizPromptBox prmtMaterial) {
        String queryInfo = UIHelper.getMaterialPlanQuery((int)this.f7Manager.getF7DisplayMode());
        this.f7Manager.registerBizMaterialF7(prmtMaterial, null, queryInfo, (OrgUnitInfo)this.storage, OrgType.Storage, false, true);
        prmtMaterial.setDisplayFormat("$number$");
        EntityViewInfo eview = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(1), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("Inventory.status", (Object)new Integer(1), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("PLAN.status", (Object)new Integer(1), CompareType.EQUALS));
        if (this.storage != null) {
            filter.getFilterItems().add(new FilterItemInfo("StorageOrgUnit.id", (Object)this.storage.getId().toString(), CompareType.EQUALS));
        }
        eview.setFilter(filter);
        prmtMaterial.setEntityViewInfo(eview);
    }

    private Timestamp getSCMQueryTime(Date d, String s) {
        Calendar calendar = Calendar.getInstance();
        if (d != null) {
            calendar.setTime(d);
        } else {
            calendar.setTime(SCMClientUtils.getServerDate2());
        }
        if (s.equalsIgnoreCase(KEY_STARTDATE)) {
            calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0);
            calendar.set(14, 0);
        } else if (s.equalsIgnoreCase(KEY_ENDDATE)) {
            calendar.add(2, 1);
            calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 23, 59, 59);
            calendar.set(14, 999);
        }
        return new Timestamp(calendar.getTimeInMillis());
    }

    protected void setDefaultValue() {
        this.startdatefrom.setValue((Object)this.getSCMQueryTime(null, KEY_STARTDATE));
        this.startdateto.setValue((Object)this.getSCMQueryTime(null, KEY_ENDDATE));
        this.kdcheckboxfloworder.setSelected(true);
        this.kdcheckboxscraporder.setSelected(true);
        this.kDCheckBoxaudit.setSelected(true);
        super.setDefaultValue();
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    protected String getPropertyOfMainBizOrg() {
        return "storageOrgUnit.id";
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmtStorageOrgUnit;
    }

    public void clear() {
        this.getFilterManager().clearAll();
        this.setDefaultValue();
    }

    public String getResource(String key) {
        return EASResource.getString((String)"com.kingdee.eas.mm.mo.OrderSimulationResource", (String)key);
    }

    public StorageOrgUnitInfo getStorage() {
        return this.storage;
    }

    public void setStorage(StorageOrgUnitInfo storage) {
        this.storage = storage;
    }

    public boolean verify() {
        boolean result = super.verify();
        if (result) {
            if (!(this.kdcheckboxfloworder.isSelected() || this.kdcheckboxscraporder.isSelected() || this.kDCheckBoxplanorder.isSelected())) {
                MsgBox.showInfo((Component)((Object)this), (String)this.getResource("NotSelectOsSourceType"));
                return false;
            }
            if (!(this.kDCheckBoxsave.isSelected() || this.kDCheckBoxcommit.isSelected() || this.kDCheckBoxaudit.isSelected())) {
                MsgBox.showInfo((Component)((Object)this), (String)this.getResource("NotSelectOsBaseStaus"));
                return false;
            }
            if (!this.storage.getId().equals((Object)((OrgUnitInfo)this.prmtStorageOrgUnit.getValue()).getId())) {
                MsgBox.showInfo((Component)((Object)this), (String)this.getResource("StoOrgNotSame"));
                return false;
            }
        }
        return result;
    }
}

