/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.mo.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSortManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.base.commonquery.client.IProcessor;
import com.kingdee.eas.base.commonquery.client.IPromptBoxFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.common.client.KDTableUtils;
import com.kingdee.eas.mm.common.util.EditTableUtil;
import com.kingdee.eas.mm.mo.OSFilterParamInfo;
import com.kingdee.eas.mm.mo.OSSourceBillTypeEnum;
import com.kingdee.eas.mm.mo.OSSourceCollection;
import com.kingdee.eas.mm.mo.OSSourceInfo;
import com.kingdee.eas.mm.mo.OrderSimulationFacadeFactory;
import com.kingdee.eas.mm.mo.client.AbstractOrderSimulationSourceUI;
import com.kingdee.eas.mm.mo.client.OrderSimulationEditUI;
import com.kingdee.eas.mm.mo.client.OrderSimulationFilterUI;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.client.SCMCommonProcessor;
import com.kingdee.eas.scm.common.client.SCMPromptBoxFactory;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class OrderSimulationSourceUI
extends AbstractOrderSimulationSourceUI {
    private static final Logger logger = CoreUIObject.getLogger(OrderSimulationSourceUI.class);
    private static final String STORAGEUNIT = "storageunit";
    private static final String DATA_TO_SELECTUI = "DATA_TO_SELECTUI";
    private static final String OUT_DATA = "outData";
    private static final String RTN_STATE = "retrunState";
    public CommonQueryDialog commonQueryDialog = null;
    protected HashMap queryCachDataMap = new HashMap();
    protected HashMap InCachDataMap = new HashMap();
    private static final String TB_SRCTYPE = "srctype";
    private static final String TB_SRCORDERNUM = "srcordernum";
    private static final String TB_STATUS = "status";
    private static final String TB_PROJECTNUM = "projectnum";
    private static final String TB_TRACENUM = "tracenum";
    private static final String TB_MATERIALNUM = "materialnum";
    private static final String TB_MATERIALNAME = "materialname";
    private static final String TB_SPEC = "spec";
    private static final String TB_UNIT = "unit";
    private static final String TB_SOURCEQTY = "sourceqty";
    private static final String TB_STARTDATE = "startdate";
    private static final String TB_ENDDATE = "enddate";
    private static final String TB_REMARK = "remark";
    private static final String TB_SOURCEBILLID = "sourcebillid";
    private static final String[] KDT_DATES = new String[]{"startdate", "enddate"};
    protected OrderSimulationFilterUI conditionPanel = null;
    protected IMetaDataPK mainQueryPK;
    private static Map precisionMap = new HashMap();
    String[] qtyFieldNames = new String[]{"sourceqty"};

    public OrderSimulationSourceUI() throws Exception {
        this.uptable.getSelectManager().setSelectMode(10);
        this.downtable.getSelectManager().setSelectMode(10);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void actionAdd_actionPerformed(ActionEvent e) throws Exception {
        int count = this.uptable.getRowCount();
        if (count <= 0) {
            MsgBox.showInfo((String)this.getResource("MustSelecteSourceBillType"));
            return;
        }
        if (this.uptable.getSelectManager().size() == 0) {
            MsgBox.showInfo((String)this.getResource("MustSelecteSourceBillType"));
            return;
        }
        int[] index = KDTableUtil.getSelectedRows((KDTable)this.uptable);
        this.uptable.getSelectManager().setSelectMode(10);
        Arrays.sort(index);
        for (int i = 0; i < index.length; ++i) {
            OSSourceInfo info = (OSSourceInfo)this.queryCachDataMap.get(this.uptable.getRow(index[i] - i).getCell(TB_SOURCEBILLID).getValue());
            this.uptable.removeRow(index[i] - i);
            this.initRowData(info, false);
        }
        if (this.uptable.getRow(0) != null) {
            this.uptable.getSelectManager().select(0, 0);
        }
        this.kDButton3.setEnabled(true);
        this.updateUI();
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.destroyWindow();
        this.queryCachDataMap.clear();
        this.InCachDataMap.clear();
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        HashMap ContextMap = new HashMap();
        int size = this.downtable.getRowCount();
        if (size > 0) {
            for (int i = 0; i < size; ++i) {
                String sourceBillId = (String)this.downtable.getRow(i).getCell(TB_SOURCEBILLID).getValue();
                if (this.queryCachDataMap != null && this.queryCachDataMap.containsKey(sourceBillId)) {
                    ContextMap.put(sourceBillId, this.queryCachDataMap.get(sourceBillId));
                }
                if (this.InCachDataMap == null || !this.InCachDataMap.containsKey(sourceBillId)) continue;
                ContextMap.put(sourceBillId, this.InCachDataMap.get(sourceBillId));
            }
            OrderSimulationEditUI parent = (OrderSimulationEditUI)((Object)this.getUIContext().get("Owner"));
            parent.getUIContext().put(RTN_STATE, new Integer(0));
            parent.getUIContext().put(OUT_DATA, ContextMap);
            parent.getUIContext().put("sourceDialog", this.commonQueryDialog);
            parent.precisionMap.putAll(precisionMap);
            parent.initTalbeForOssourceEntry();
        }
        this.queryCachDataMap.clear();
        this.destroyWindow();
    }

    public void onShow() throws Exception {
        OrderSimulationEditUI parent = (OrderSimulationEditUI)((Object)this.getUIContext().get("Owner"));
        this.commonQueryDialog = (CommonQueryDialog)parent.getUIContext().get("sourceDialog");
        precisionMap.putAll((HashMap)this.getUIContext().get("precisionMap"));
        this.initSimuSourceDownTable();
        this.kDButton3.setEnabled(false);
        super.onShow();
        KDTableUtils.setDefaultFreezeCol((KDTable)this.uptable, (int)(this.uptable.getColumnIndex(TB_SRCORDERNUM) + 1));
        KDTableUtils.setDefaultFreezeCol((KDTable)this.downtable, (int)(this.downtable.getColumnIndex(TB_SRCORDERNUM) + 1));
        this.initSortManager(this.uptable);
        this.initSortManager(this.downtable);
        EditTableUtil.formatColDate((KDTable)this.uptable, (String[])KDT_DATES);
        EditTableUtil.formatColDate((KDTable)this.downtable, (String[])KDT_DATES);
    }

    private void initSortManager(KDTable kdtable) {
        KDTSortManager sortManager = new KDTSortManager(kdtable);
        sortManager.setSortAuto(true);
        sortManager.setClickCount(1);
        kdtable.setSortMange(sortManager);
        for (int i = 0; i < kdtable.getColumnCount(); ++i) {
            kdtable.getColumn(i).setSortable(true);
        }
    }

    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        int count = this.downtable.getSelectManager().size();
        if (count <= 0) {
            MsgBox.showInfo((String)this.getResource("MustSelecteSourceBillType"));
            return;
        }
        int[] index = KDTableUtil.getSelectedRows((KDTable)this.downtable);
        this.downtable.getSelectManager().setSelectMode(10);
        Arrays.sort(index);
        for (int i = 0; i < index.length; ++i) {
            String sourceBillId = (String)this.downtable.getRow(index[i] - i).getCell(TB_SOURCEBILLID).getValue();
            this.InCachDataMap.remove(sourceBillId);
            this.downtable.removeRow(index[i] - i);
            if (sourceBillId == null || !this.queryCachDataMap.containsKey(sourceBillId)) continue;
            OSSourceInfo info = (OSSourceInfo)this.queryCachDataMap.get(sourceBillId);
            this.initRowData(info, true);
        }
        if (this.downtable.getRow(0) != null) {
            this.downtable.getSelectManager().select(0, 0);
        }
        this.kDButton3.setEnabled(true);
        this.updateUI();
    }

    public void actionclose_actionPerformed(ActionEvent e) throws Exception {
        this.queryCachDataMap.clear();
        this.InCachDataMap.clear();
        super.destroyWindow();
    }

    private void setRowPrecision(IRow orderRow, OSSourceInfo osinfo) {
        if (osinfo.getMaterial() == null || osinfo.getUnit() == null) {
            return;
        }
        this.setRowPrecision(orderRow, osinfo.getMaterial().getId().toString(), osinfo.getUnit().getId().toString());
    }

    private void setRowPrecision(IRow orderRow, String materialId, String unitId) {
        String key = materialId + unitId;
        int precision = 0;
        if (precisionMap != null && precisionMap.containsKey(key)) {
            precision = (Integer)precisionMap.get(key);
        }
        SCMClientUtils.changeCellPrecision((IRow)orderRow, (String[])this.qtyFieldNames, (int)precision, (boolean)false, (boolean)false);
    }

    @Override
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        if (this.commonQueryDialog == null) {
            this.initCommonQueryDialog();
        }
        this.commonQueryDialog.show();
        EntityViewInfo entityViewInfo = this.commonQueryDialog.getEntityViewInfoResult();
        if (entityViewInfo.getFilter() == null) {
            this.abort();
        }
        this.uptable.removeRows();
        OrderSimulationFilterUI filterUI = (OrderSimulationFilterUI)((Object)this.commonQueryDialog.getCommonQueryParam().getPanels().get(0));
        filterUI.getParent();
        OSFilterParamInfo filterinfo = new OSFilterParamInfo();
        filterinfo.setStorageUnitNum((StorageOrgUnitInfo)this.getUIContext().get(STORAGEUNIT));
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        Date date = null;
        for (FilterItemInfo filter : entityViewInfo.getFilter().getFilterItems()) {
            Calendar cal;
            TrackNumberInfo trackNum;
            if (filter.getPropertyName().equalsIgnoreCase("kDCheckBoxaudit")) {
                filterinfo.setHasAudit((String)filter.getCompareValue() == "true" ? new Integer(32) : new Integer(16));
            }
            if (filter.getPropertyName().equalsIgnoreCase("kDCheckBoxcommit")) {
                filterinfo.setHasSumbmit((String)filter.getCompareValue() == "true" ? new Integer(32) : new Integer(16));
            }
            if (filter.getPropertyName().equalsIgnoreCase("kdcheckboxfloworder")) {
                filterinfo.setHasFlowOrder((String)filter.getCompareValue() == "true" ? new Integer(32) : new Integer(16));
            }
            if (filter.getPropertyName().equalsIgnoreCase("kDCheckBoxplanorder")) {
                filterinfo.setHasPlanOrder((String)filter.getCompareValue() == "true" ? new Integer(32) : new Integer(16));
            }
            if (filter.getPropertyName().equalsIgnoreCase("kDCheckBoxsave")) {
                filterinfo.setHasSave((String)filter.getCompareValue() == "true" ? new Integer(32) : new Integer(16));
            }
            if (filter.getPropertyName().equalsIgnoreCase("kdcheckboxscraporder")) {
                filterinfo.setHasDiscreteOrder((String)filter.getCompareValue() == "true" ? new Integer(32) : new Integer(16));
            }
            if (filter.getPropertyName().equalsIgnoreCase("materialfrom")) {
                if (filter.getCompareValue() != null && filter.getCompareValue() instanceof String) {
                    MaterialInfo materialFrom = new MaterialInfo();
                    materialFrom.setNumber((String)filter.getCompareValue());
                    filterinfo.setMaterialNumFrom(materialFrom);
                } else {
                    filterinfo.setMaterialNumFrom(filter.getCompareValue() != null ? (MaterialInfo)filter.getCompareValue() : null);
                }
            }
            if (filter.getPropertyName().equalsIgnoreCase("materialto")) {
                if (filter.getCompareValue() != null && filter.getCompareValue() instanceof String) {
                    MaterialInfo materialTo = new MaterialInfo();
                    materialTo.setNumber((String)filter.getCompareValue());
                    filterinfo.setMaterialNumTo(materialTo);
                } else {
                    filterinfo.setMaterialNumTo(filter.getCompareValue() != null ? (MaterialInfo)filter.getCompareValue() : null);
                }
            }
            if (filter.getPropertyName().equalsIgnoreCase("orgunitfrom")) {
                filterinfo.setOrgunitNums(filter.getCompareValue() != null ? filter.getCompareValue() : null);
            }
            if (filter.getPropertyName().equalsIgnoreCase("prmtTrackNumStart")) {
                if (!StringUtils.isEmpty((String)((String)filter.getCompareValue()))) {
                    trackNum = new TrackNumberInfo();
                    trackNum.setNumber((String)filter.getCompareValue());
                    filterinfo.setTrackNumStart(trackNum);
                } else {
                    filterinfo.setTrackNumStart(null);
                }
            }
            if (filter.getPropertyName().equalsIgnoreCase("prmtTrackNumEnd")) {
                if (!StringUtils.isEmpty((String)((String)filter.getCompareValue()))) {
                    trackNum = new TrackNumberInfo();
                    trackNum.setNumber((String)filter.getCompareValue());
                    filterinfo.setTrackNumEnd(trackNum);
                } else {
                    filterinfo.setTrackNumEnd(null);
                }
            }
            if (filter.getPropertyName().equalsIgnoreCase("startdatefrom")) {
                if (filter.getCompareValue() != null) {
                    date = df.parse((String)filter.getCompareValue());
                }
                filterinfo.setStartdateFrom(filter.getCompareValue() != null ? date : null);
            }
            if (filter.getPropertyName().equalsIgnoreCase("startdateto")) {
                if (filter.getCompareValue() != null) {
                    date = df.parse((String)filter.getCompareValue());
                    cal = Calendar.getInstance();
                    cal.setTime(date);
                    cal.set(10, 23);
                    cal.set(12, 59);
                    cal.set(13, 59);
                    cal.set(14, 999);
                    date = cal.getTime();
                }
                filterinfo.setStartdateTo(filter.getCompareValue() != null ? date : null);
            }
            if (filter.getPropertyName().equalsIgnoreCase("enddatefrom")) {
                if (filter.getCompareValue() != null) {
                    date = df.parse((String)filter.getCompareValue());
                }
                filterinfo.setEnddateFrom(filter.getCompareValue() != null ? date : null);
            }
            if (!filter.getPropertyName().equalsIgnoreCase("enddateto")) continue;
            if (filter.getCompareValue() != null) {
                date = df.parse((String)filter.getCompareValue());
                cal = Calendar.getInstance();
                cal.setTime(date);
                cal.set(10, 23);
                cal.set(12, 59);
                cal.set(13, 59);
                cal.set(14, 999);
                date = cal.getTime();
            }
            filterinfo.setEnddateTo(filter.getCompareValue() != null ? date : null);
        }
        List result = OrderSimulationFacadeFactory.getRemoteInstance().getOSSourceCollectionByFilter(filterinfo);
        if (result != null) {
            OSSourceCollection coll = (OSSourceCollection)((Object)result.get(0));
            precisionMap.putAll((HashMap)result.get(1));
            if (coll != null && coll.size() > 0) {
                for (int i = 0; i < coll.size(); ++i) {
                    OSSourceInfo os = coll.get(i);
                    int downTableCount = this.downtable.getRowCount();
                    if (downTableCount > 0) {
                        boolean hasInDownTable = false;
                        for (int m = 0; m < downTableCount; ++m) {
                            OSSourceBillTypeEnum dTableRowType = (OSSourceBillTypeEnum)((Object)this.downtable.getRow(m).getCell(TB_SRCTYPE).getValue());
                            String dTableRowsourceNum = (String)this.downtable.getRow(m).getCell(TB_SRCORDERNUM).getValue();
                            if (os.getSourceType().getValue() != dTableRowType.getValue() || !os.getSourceBillNumber().equals(dTableRowsourceNum)) continue;
                            hasInDownTable = true;
                        }
                        if (hasInDownTable) continue;
                        this.initRowData(os, true);
                    } else {
                        this.initRowData(os, true);
                    }
                    this.queryCachDataMap.put(os.getSourceBillId(), os);
                }
            }
        }
    }

    protected void initSimuSourceDownTable() {
        HashMap contextMap;
        Map uiContext = this.getUIContext();
        this.InCachDataMap = contextMap = (HashMap)uiContext.get(DATA_TO_SELECTUI);
        if (contextMap != null) {
            for (String sourceBillID : contextMap.keySet()) {
                OSSourceInfo os = (OSSourceInfo)contextMap.get(sourceBillID);
                this.initRowData(os, false);
            }
        }
    }

    protected void initRowData(OSSourceInfo os, boolean upOrDown) {
        IRow newRow = null;
        if (upOrDown) {
            this.uptable.checkParsed();
            newRow = this.uptable.addRow();
        } else {
            this.downtable.checkParsed();
            newRow = this.downtable.addRow();
        }
        newRow.getCell(TB_SRCTYPE).setValue((Object)os.getSourceType());
        newRow.getCell(TB_SRCORDERNUM).setValue((Object)os.getSourceBillNumber());
        if (newRow.getCell(TB_SRCTYPE).getValue() == OSSourceBillTypeEnum.HANDINPUT) {
            newRow.getCell(TB_STATUS).setValue(null);
        } else {
            newRow.getCell(TB_STATUS).setValue((Object)os.getBaseStatus());
        }
        newRow.getCell(TB_PROJECTNUM).setValue((Object)(os.getProject() != null ? os.getProject().getNumber() : ""));
        newRow.getCell(TB_TRACENUM).setValue((Object)(os.getTrackNumber() != null ? os.getTrackNumber().getNumber() : ""));
        newRow.getCell(TB_MATERIALNUM).setValue((Object)(os.getMaterial() != null ? os.getMaterial().getNumber() : ""));
        newRow.getCell(TB_MATERIALNAME).setValue((Object)os.getMaterialName());
        newRow.getCell(TB_SPEC).setValue((Object)os.getMaterialModel());
        newRow.getCell(TB_UNIT).setValue((Object)(os.getUnit() != null ? os.getUnit().getName() : ""));
        newRow.getCell(TB_SOURCEQTY).setValue((Object)os.getOrderQty());
        newRow.getCell(TB_STARTDATE).setValue((Object)os.getStartDate());
        newRow.getCell(TB_ENDDATE).setValue((Object)os.getEndDate());
        newRow.getCell(TB_REMARK).setValue((Object)os.getRemark());
        newRow.getCell(TB_SOURCEBILLID).setValue((Object)os.getSourceBillId());
        this.setRowPrecision(newRow, os);
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        this.commonQueryDialog = this.initMyCommonQueryDialog();
        this.commonQueryDialog.setWidth(450);
        this.commonQueryDialog.setHeight(320);
        try {
            SCMPromptBoxFactory scmF7Factory = new SCMPromptBoxFactory((CustomerQueryPanel)this.getFilterUI(), this.getMainBizOrgType());
            this.commonQueryDialog.setPromptBoxFactory((IPromptBoxFactory)scmF7Factory);
            this.commonQueryDialog.setProcessor((IProcessor)new SCMCommonProcessor());
            this.commonQueryDialog.getCommonQueryParam().setDisVisiableDefaultView(true);
            this.commonQueryDialog.addUserPanel((KDPanel)this.getFilterUI());
        }
        catch (Exception e) {
            this.handUIException(e);
            SysUtil.abort();
        }
        return this.commonQueryDialog;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    protected String getPropertyOfMainBizOrg() {
        return "storageOrgUnit.id";
    }

    protected OrderSimulationFilterUI getFilterUI() throws Exception {
        Map uiContext = this.getUIContext();
        StorageOrgUnitInfo storage = (StorageOrgUnitInfo)uiContext.get(STORAGEUNIT);
        this.conditionPanel = new OrderSimulationFilterUI(storage);
        return this.conditionPanel;
    }

    protected CommonQueryDialog initMyCommonQueryDialog() {
        CommonQueryDialog dialog = new CommonQueryDialog();
        if (this.getUIWindow() == null) {
            dialog.setOwner((Component)this.getUIContext().get("OwnerWindow"));
        } else {
            dialog.setOwner((Component)((Object)this));
        }
        this.mainQueryPK = new MetaDataPK("com.kingdee.eas.mm.mo.app", "OSSourceFilterQuery");
        dialog.setQueryObjectPK(this.mainQueryPK);
        dialog.setParentUIClassName(((Object)((Object)this)).getClass().getName());
        dialog.setTitle(this.getUITitle() + " - " + EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Query_Filter"));
        dialog.setShowSorter(false);
        dialog.setShowFilter(false);
        return dialog;
    }

    public String getResource(String key) {
        return EASResource.getString((String)"com.kingdee.eas.mm.mo.OrderSimulationResource", (String)key);
    }
}

