/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.mo.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitCollection;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.mm.basedata.StandardRootingFactory;
import com.kingdee.eas.mm.common.client.UIHelper;
import com.kingdee.eas.mm.mo.client.AbstractRoutingF7ListUI;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.scm.common.util.F7ContextManager;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class RoutingF7ListUI
extends AbstractRoutingF7ListUI {
    private static final Logger logger = CoreUIObject.getLogger(RoutingF7ListUI.class);
    protected F7ContextManager f7Manager = new F7ContextManager((Component)((Object)this), this.getMainBizOrgType());
    private DataChangeListener materialDataChanged;
    protected boolean isCanceled = true;
    private MaterialInfo materialInfo = null;
    private StorageOrgUnitInfo mainOrgInfo = null;
    private static final String DEFAULT_SORTER = "isMainRooting";

    public void onLoad() throws Exception {
        this.materialInfo = (MaterialInfo)this.getUIContext().get("MATERIAL");
        this.mainOrgInfo = (StorageOrgUnitInfo)this.getUIContext().get("ORG");
        this.initUIMainOrgContext(this.mainOrgInfo.getId().toString());
        this.initMaterialF7(this.mainOrgInfo);
        this.prmtmaterial.setEnabled(false);
        this.currentMaterialRooting.setSelected(true);
        this.removeListener();
        this.prmtmaterial.setValue((Object)this.materialInfo);
        this.txtMaterialName.setText(this.materialInfo == null ? null : this.materialInfo.getName());
        this.addListener();
        super.onLoad();
    }

    private void initMaterialF7(StorageOrgUnitInfo storageOrgInfo) throws Exception {
        UIHelper.registerBizMaterialF7((F7ContextManager)this.f7Manager, (KDBizPromptBox)this.prmtmaterial, (OrgUnitInfo)storageOrgInfo);
        EntityViewInfo viewInfo = this.prmtmaterial.getEntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("StorageOrgUnit.id", (Object)storageOrgInfo.getId().toString(), CompareType.EQUALS));
        String attrFilter = "10030,10050";
        filterInfo.getFilterItems().add(new FilterItemInfo("plan.materialAttr", (Object)attrFilter, CompareType.INNER));
        filterInfo.getFilterItems().add(new FilterItemInfo("plan.status", (Object)new Integer(1), CompareType.EQUALS));
        viewInfo.getFilter().mergeFilter(filterInfo, "and");
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(60), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)this.mainOrgInfo.getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isChildRooting", (Object)Boolean.FALSE, CompareType.EQUALS));
        MaterialInfo materialInfo = (MaterialInfo)this.prmtmaterial.getData();
        if (materialInfo != null && materialInfo.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialInfo.getId().toString(), CompareType.EQUALS));
        }
        return filter;
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.setCanceled(false);
        this.disposeUIWindow();
    }

    protected void refresh(ActionEvent e) throws Exception {
        this.checkBeforeQuery();
        EntityViewInfo viewInfo = new EntityViewInfo();
        if (this.mainQuery != null && this.mainQuery.getSorter() != null) {
            viewInfo.setSorter(this.mainQuery.getSorter());
        }
        this.mainQuery = this.getEntityViewInfo(viewInfo);
        this.execQuery();
    }

    protected void beforeExcutQuery(EntityViewInfo ev) {
        if (ev != null && ev.getSorter() != null) {
            boolean hasMainRootingSorter = false;
            Iterator iter = ev.getSorter().iterator();
            while (iter.hasNext()) {
                if (!DEFAULT_SORTER.equals(((SorterItemInfo)iter.next()).getPropertyName())) continue;
                hasMainRootingSorter = true;
                break;
            }
            if (!hasMainRootingSorter) {
                SorterItemInfo sortItem = new SorterItemInfo(DEFAULT_SORTER);
                sortItem.setSortType(SortType.DESCEND);
                ev.getSorter().add(sortItem);
            }
        }
        super.beforeExcutQuery(ev);
    }

    private void checkBeforeQuery() {
        if (this.prmtmaterial.getValue() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.mm.mo.ManufactureOrderResource.FirstSelectMaterial"));
            SysUtil.abort();
        }
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getType() == 1 && e.getButton() == 1 && e.getClickCount() == 2) {
            ActionEvent evt = new ActionEvent(this.btnConfirm, 0, "Double Clicked");
            ItemAction actConfirm = this.getActionFromActionEvent(evt);
            actConfirm.actionPerformed(evt);
        } else {
            super.tblMain_tableClicked(e);
        }
    }

    protected void initKeyStroke() {
        this.tblMain.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "Confirm_1");
        this.tblMain.getActionMap().put("Confirm_1", new AbstractAction(){
            private static final long serialVersionUID = -5669325198048189263L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ActionEvent evt = new ActionEvent(RoutingF7ListUI.this.btnConfirm, 0, "Enter");
                ItemAction actConfirm = RoutingF7ListUI.this.getActionFromActionEvent(evt);
                actConfirm.actionPerformed(evt);
            }
        });
    }

    private boolean isMaterialUnitSameGroup(String materialId1, String materialId2) throws BOSException {
        if (materialId1.equals(materialId2)) {
            return true;
        }
        boolean isSameGroup = false;
        IMultiMeasureUnit multiUnit = MultiMeasureUnitFactory.getRemoteInstance();
        HashSet<String> set = new HashSet<String>();
        set.add(materialId1);
        set.add(materialId2);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("material.id", set, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("isBasicUnit", (Object)Boolean.TRUE, CompareType.EQUALS));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("material.id"));
        sic.add(new SelectorItemInfo("measureUnit.measureUnitGroup.id"));
        view.setSelector(sic);
        MultiMeasureUnitCollection multiMeaUnitCol = multiUnit.getMultiMeasureUnitCollection(view);
        if (multiMeaUnitCol.size() == 2) {
            String unitGroup1 = multiMeaUnitCol.get(0).getMeasureUnit().getMeasureUnitGroup().getId().toString();
            String unitGroup2 = multiMeaUnitCol.get(1).getMeasureUnit().getMeasureUnitGroup().getId().toString();
            if (unitGroup1 != null && unitGroup2 != null && unitGroup1.equals(unitGroup2)) {
                isSameGroup = true;
            }
        }
        return isSameGroup;
    }

    @Override
    public void actionCurrentMaterial_actionPerformed(ActionEvent e) throws Exception {
        this.tblMain.removeRows(false);
        this.prmtmaterial.setValue((Object)this.materialInfo);
        this.txtMaterialName.setText(this.materialInfo == null ? null : this.materialInfo.getName());
        this.prmtmaterial.setEnabled(false);
        this.actionRefresh_actionPerformed(null);
    }

    @Override
    public void actionOtherMaterial_actionPerformed(ActionEvent e) throws Exception {
        this.tblMain.repaint();
        this.tblMain.removeRows(false);
        this.prmtmaterial.setEnabled(true);
    }

    protected ICoreBase getBizInterface() throws Exception {
        return StandardRootingFactory.getRemoteInstanceWithObjectContext((Context)this.getMainOrgContext());
    }

    protected void prmtmaterial_dataChanged(DataChangeEvent e) {
        try {
            boolean isDiffrent = SCMGroupClientUtils.isDiffrent((Object)e.getNewValue(), (Object)e.getOldValue());
            if (isDiffrent) {
                if (e.getNewValue() != null) {
                    MaterialInfo materialInfo = (MaterialInfo)e.getNewValue();
                    this.txtMaterialName.setText(materialInfo.getName());
                } else {
                    this.txtMaterialName.setText(null);
                }
            }
        }
        catch (Exception e1) {
            this.handUIException(e1);
        }
    }

    public void removeListener() {
        if (this.materialDataChanged != null) {
            this.prmtmaterial.removeDataChangeListener(this.materialDataChanged);
        }
    }

    public void addListener() {
        if (this.materialDataChanged == null) {
            this.materialDataChanged = new DataChangeListener(){

                public void dataChanged(DataChangeEvent e) {
                    try {
                        RoutingF7ListUI.this.prmtmaterial_dataChanged(e);
                    }
                    catch (Exception exc) {
                        RoutingF7ListUI.this.handUIException(exc);
                    }
                }
            };
        }
        this.prmtmaterial.addDataChangeListener(this.materialDataChanged);
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    protected String getEditUIName() {
        return null;
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    public void setCanceled(boolean isCancel) {
        this.isCanceled = isCancel;
    }
}

