/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.mo.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.KDTableHelper;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.CommitEvent;
import com.kingdee.bos.ctrl.swing.event.CommitListener;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialInventoryCollection;
import com.kingdee.eas.basedata.master.material.MaterialInventoryFactory;
import com.kingdee.eas.basedata.master.material.MaterialInventoryInfo;
import com.kingdee.eas.basedata.master.material.MaterialPlanCollection;
import com.kingdee.eas.basedata.master.material.MaterialPlanFactory;
import com.kingdee.eas.basedata.master.material.MaterialPlanInfo;
import com.kingdee.eas.basedata.master.material.MaterialProvideTypeEnum;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.StorageOrgUnitCollection;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchaction.ActionLevelEnum;
import com.kingdee.eas.mm.basedata.CSEntrustTypeEnum;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.common.client.UIHelper;
import com.kingdee.eas.mm.common.util.MMUtils;
import com.kingdee.eas.mm.mo.IScrapOrder;
import com.kingdee.eas.mm.mo.ManufactureOrderInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderTechnicsInfo;
import com.kingdee.eas.mm.mo.ScrapOrderEntryAgent;
import com.kingdee.eas.mm.mo.ScrapOrderEntryInfo;
import com.kingdee.eas.mm.mo.ScrapOrderFactory;
import com.kingdee.eas.mm.mo.ScrapOrderInfo;
import com.kingdee.eas.mm.mo.ScrapTypeEnum;
import com.kingdee.eas.mm.mo.client.AbstractScrapOrderEditUI;
import com.kingdee.eas.mm.mo.util.MOStockUtil;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.ISCMBillCommonFacade;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.SCMBillCommonFacadeFactory;
import com.kingdee.eas.scm.common.SCMBillEntryBaseInfo;
import com.kingdee.eas.scm.common.SCMGroupFacadeFactory;
import com.kingdee.eas.scm.common.action.ISupportBatchAction;
import com.kingdee.eas.scm.common.client.SCMClientHelper;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.scm.common.client.SplitOptionConfig;
import com.kingdee.eas.scm.common.client.helper.FormattedEditorFactory;
import com.kingdee.eas.scm.common.loadmass.SCMEntryDataVO;
import com.kingdee.eas.scm.im.inv.client.InvClientUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class ScrapOrderEditUI
extends AbstractScrapOrderEditUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(ScrapOrderEditUI.class);
    private static final String TB_SRCBILL_ID = "sourceBillId";
    private static final String TB_SRCBILL_NUM = "sourceBillNumber";
    private static final String TB_SRCBILL_TYPE = "sourceBillType";
    private static final String TB_MATERIAL = "material";
    private static final String TB_MATERIAL_ID = "material.id";
    private static final String TB_MATERIAL_NAME = "materialName";
    private static final String TB_MATERIAL_MODEL = "materialModel";
    private static final String TB_PRODUCT = "product";
    private static final String TB_PRODUCT_NUM = "productNumber";
    private static final String TB_PRODUCT_NAME = "productName";
    private static final String TB_PRODUCT_MODEL = "productModel";
    private static final String TB_PROJECT = "project";
    private static final String TB_PROJECT_NUM = "projectNumber";
    private static final String TB_TRACK = "track";
    private static final String TB_TRACK_NUM = "trackNumber";
    private static final String TB_REASON_CODE = "reasonCode";
    private static final String TB_BACK_WAREHOUSE = "backWarehouse";
    private static final String TB_BACK_LOCATION = "backLocation";
    private static final String TB_SCRAP_QTY = "scrapQty";
    private static final String TB_BACK_QTY = "backQty";
    private static final String TB_SUPPLY_REQUIRED_QTY = "supplyRequiredQty";
    private static final String TB_SUPPLIED_QTY = "suppliedQty";
    private static final String TB_IS_SUPPLY_MATERIAL = "isSupplyMaterial";
    private static final String TB_UNIT = "unit";
    private static final String TB_BASE_UNIT = "baseUnit";
    private static final String TB_REQUIRE_DATE = "requireDate";
    private static final String TB_OPERATION_NUMBER = "operationNo";
    private static final String TB_OPERATION_NAME = "operationName";
    private static final String TB_OPERATION = "operation";
    private static final String TB_MOTECHNIC_ID = "technicID";
    private static final String TB_PICK_DEPT = "pickDept";
    private static final String TB_PROCESS_ORG = "processOrgUnit";
    private static final String TB_PROCESS_DEPT = "processDept";
    private static final String TB_PRODUCT_QTY = "productQty";
    private static final String TB_PRODUCT_UNIT = "productUnit";
    private static final String TB_SCRAP_TYPE = "scrapType";
    private static final String TB_LOT = "lot";
    private static final String TB_PROVIDE = "provideType";
    private static final String TB_STO = "storageOrgUnit";
    private static final String TB_WAREHOUSE = "warehouse";
    private static final String TB_UNIT_QTY = "qtyUnit";
    private static final String TB_COST_OBJECT = "costObject";
    private String ManuOrderBillTypeId = "B2aZSVXaSx6qxdfekgCmrEY+1VI=";
    private static final String TB_OPERATION_QUERY = "com.kingdee.eas.mm.basedata.app.F7OperationQuery";
    private static final String TB_REASON_CODE_QUERY = "com.kingdee.eas.basedata.scm.common.app.F7ReasonCodeQuery";
    private static final String TB_MO_QUERY = "com.kingdee.eas.mm.mo.app.F7ManufactureOrderQuery";
    private static final String TB_MOTECH_QUERY = "com.kingdee.eas.mm.mo.app.F7MFTOrderTechnicsQuery";
    private static final String[] TB_QTYS = new String[]{"scrapQty", "backQty", "supplyRequiredQty", "suppliedQty"};
    private KDBizPromptBox kDBizPromptBoxMaterial = null;
    private Color requiredColor = new Color(252, 251, 223);
    private KDTEditAdapter entryTableChange;
    private StorageOrgUnitInfo curStorageOrgUnit;
    private KDTDefaultCellEditor kdtEntries_scrapType_Redundancy;
    private KDTDefaultCellEditor kdtEntries_scrapType_noRedundancy;
    private Map conRateMap = new HashMap();
    private Action actionTable;
    private DataChangeListener prmtadminOrgUnitDataChanged;
    private int qtyPrecision = 2;

    public ScrapOrderEditUI() throws Exception {
        KDComboBox kdtEntries_scrapType_ComboBox = new KDComboBox();
        kdtEntries_scrapType_ComboBox.setVisible(true);
        kdtEntries_scrapType_ComboBox.addItem((Object)ScrapTypeEnum.BecauseOfRedundancy);
        this.kdtEntries_scrapType_Redundancy = new KDTDefaultCellEditor((JComboBox)kdtEntries_scrapType_ComboBox);
        KDComboBox kdtEntries_scrapType_ComboBox1 = new KDComboBox();
        kdtEntries_scrapType_ComboBox1.setVisible(true);
        kdtEntries_scrapType_ComboBox1.addItem((Object)ScrapTypeEnum.BecauseOfWork);
        kdtEntries_scrapType_ComboBox1.addItem((Object)ScrapTypeEnum.BecauseOfRawMaterial);
        this.kdtEntries_scrapType_noRedundancy = new KDTDefaultCellEditor((JComboBox)kdtEntries_scrapType_ComboBox1);
    }

    public void onLoad() throws Exception {
        this.kdtEntries.checkParsed();
        super.onLoad();
        this.btnReset.setEnabled(false);
        this.btnReset.setVisible(false);
        this.btnAttachment.setEnabled(false);
        this.btnAttachment.setVisible(false);
        this.separator4.setEnabled(false);
        this.separator4.setVisible(false);
        this.menuItemMultiapprove.setIcon(EASResource.getIcon((String)"imgTbtn_dealmultilevelaudit"));
        this.setSourcBillType();
        this.setEntryColumns();
        this.menuBizProcess.setIcon(EASResource.getIcon((String)"imgTbtn_collateresult"));
        this.workbtnBizProcess.setIcon(EASResource.getIcon((String)"imgTbtn_collateresult"));
        this.btnSplitOption.setVisible(false);
        if (this.actionAddLine.isEnabled()) {
            KDTableHelper.downArrowAutoAddRow((KDTable)this.kdtEntries, (boolean)true, (Action)this.actionTable);
            KDTableHelper.updateEnterWithTab((KDTable)this.kdtEntries, (boolean)true, (Action)this.actionTable);
        } else {
            KDTableHelper.downArrowAutoAddRow((KDTable)this.kdtEntries, (boolean)false, (Action)this.actionTable);
            KDTableHelper.updateEnterWithTab((KDTable)this.kdtEntries, (boolean)false, (Action)this.actionTable);
        }
        super.setReservationVisible(false);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        String menuBizProcessText = this.menuBizProcess.getText();
        if (!menuBizProcessText.endsWith("(H)")) {
            this.menuBizProcess.setText(this.menuBizProcess.getText() + "(H)");
        }
        this.menuBizProcess.setMnemonic(72);
        String workbtnBizProcessText = this.workbtnBizProcess.getText();
        if (!workbtnBizProcessText.endsWith("(H)")) {
            this.workbtnBizProcess.setText(this.workbtnBizProcess.getText() + "(H)");
        }
        this.workbtnBizProcess.setMnemonic(72);
    }

    protected void showBotpMenu() {
        if (!this.menuBizProcess.isVisible()) {
            return;
        }
        Component[] menus = this.menuBizProcess.getMenuComponents();
        int count = menus.length;
        for (int i = 0; i < count; ++i) {
            KDMenuItem kDMenuItem = (KDMenuItem)this.menuBizProcess.getMenuComponent(i);
        }
    }

    private void setEntryColumns() {
        KDDatePicker datePicker = new KDDatePicker();
        this.kdtEntries.getColumn(TB_REQUIRE_DATE).setEditor((ICellEditor)new KDTDefaultCellEditor(datePicker));
        this.kdtEntries.getColumn(TB_REQUIRE_DATE).getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDateFormatString());
        KDTextField txt = new KDTextField();
        txt.setMaxLength(80);
        this.kdtEntries.getColumn(TB_LOT).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txt));
        this.kdtEntries.getColumn("remark").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txt));
        this.setQtyColumns();
        this.setEntryF7Columns();
        this.kdtEntries.getColumn(TB_SRCBILL_NUM).getStyleAttributes().setLocked(false);
        this.kdtEntries.getColumn(TB_OPERATION_NUMBER).getStyleAttributes().setLocked(false);
    }

    private void setQtyColumns() {
        KDTDefaultCellEditor productQtyEditor = FormattedEditorFactory.getBigDecimalCellEditor((int)8, (boolean)false);
        this.kdtEntries.getColumn(TB_PRODUCT_QTY).setEditor((ICellEditor)productQtyEditor);
        KDTDefaultCellEditor scrapQtyEditor = FormattedEditorFactory.getBigDecimalCellEditor((int)8, (boolean)false);
        this.kdtEntries.getColumn(TB_SCRAP_QTY).setEditor((ICellEditor)scrapQtyEditor);
        KDTDefaultCellEditor supplyRequiredQtyEditor = FormattedEditorFactory.getBigDecimalCellEditor((int)8, (boolean)false);
        this.kdtEntries.getColumn(TB_SUPPLY_REQUIRED_QTY).setEditor((ICellEditor)supplyRequiredQtyEditor);
        KDTDefaultCellEditor suppliedQtyEditor = FormattedEditorFactory.getBigDecimalCellEditor((int)8, (boolean)false);
        this.kdtEntries.getColumn(TB_SUPPLIED_QTY).setEditor((ICellEditor)suppliedQtyEditor);
        this.kdtEntries.getColumn(TB_SUPPLIED_QTY).getStyleAttributes().setLocked(true);
        KDTDefaultCellEditor backQtyEditor = FormattedEditorFactory.getBigDecimalCellEditor((int)8, (boolean)false);
        this.kdtEntries.getColumn(TB_BACK_QTY).setEditor((ICellEditor)backQtyEditor);
    }

    protected void setAddLineStatus(boolean status) {
        if (!"ADDNEW".equals(this.getOprtState())) {
            super.setAddLineStatus(status);
        }
        if ("EDIT".equals(this.getOprtState())) {
            this.actionAddLine.setEnabled(true);
            this.actionInsertLine.setEnabled(true);
        }
    }

    protected void initListener() {
    }

    private void setSourcBillType() throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        FilterItemInfo itemInfo = new FilterItemInfo("id", (Object)"B2aZSVXaSx6qxdfekgCmrEY+1VI=", CompareType.EQUALS);
        filterInfo.getFilterItems().add(itemInfo);
        view.setFilter(filterInfo);
        this.prmtSourceBillType.setEntityViewInfo(view);
        this.prmtSourceBillType.getQueryAgent().resetRuntimeEntityView();
    }

    private void setEntryF7Columns() {
        ObjectValueRender numberValueRender = new ObjectValueRender();
        numberValueRender.setFormat((IDataFormat)new BizDataFormat("$number$"));
        KDBizPromptBox entryF7Operation = new KDBizPromptBox();
        entryF7Operation.setQueryInfo(TB_OPERATION_QUERY);
        entryF7Operation.setEditFormat("$number$");
        entryF7Operation.setDisplayFormat("$number$");
        entryF7Operation.setCommitFormat("$number$");
        entryF7Operation.setEditable(false);
        this.kdtEntries.getColumn(TB_OPERATION).setRenderer((IBasicRender)numberValueRender);
        this.kdtEntries.getColumn(TB_OPERATION).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)entryF7Operation));
        KDBizPromptBox entryF7ReasonCode = new KDBizPromptBox();
        entryF7ReasonCode.setQueryInfo(TB_REASON_CODE_QUERY);
        entryF7ReasonCode.setEditFormat("$name$");
        entryF7ReasonCode.setDisplayFormat("$name$");
        entryF7ReasonCode.setCommitFormat("$name$");
        entryF7ReasonCode.setEditable(true);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("reasonCodeType.id", (Object)"6Rt8eBMIRieK5BOmdycx+6XM1dw=", CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        entryF7ReasonCode.setEntityViewInfo(viewInfo);
        this.kdtEntries.getColumn(TB_REASON_CODE).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)entryF7ReasonCode));
        ObjectValueRender opNumRender = new ObjectValueRender();
        opNumRender.setFormat((IDataFormat)new BizDataFormat("$operationNo$"));
        KDBizPromptBox opNumF7 = new KDBizPromptBox();
        opNumF7.setQueryInfo(TB_MOTECH_QUERY);
        opNumF7.setEditFormat("$operationNo$");
        opNumF7.setDisplayFormat("$operationNo$");
        opNumF7.setCommitFormat("$operationNo$");
        opNumF7.setEditable(true);
        this.kdtEntries.getColumn(TB_OPERATION_NUMBER).setRenderer((IBasicRender)opNumRender);
        this.kdtEntries.getColumn(TB_OPERATION_NUMBER).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)opNumF7));
        KDBizPromptBox srcBillF7 = new KDBizPromptBox();
        srcBillF7.setQueryInfo(TB_MO_QUERY);
        srcBillF7.setEditFormat("$number$");
        srcBillF7.setDisplayFormat("$number$");
        srcBillF7.setCommitFormat("$number$");
        srcBillF7.setEditable(true);
        this.kdtEntries.getColumn(TB_SRCBILL_NUM).setRenderer((IBasicRender)numberValueRender);
        this.kdtEntries.getColumn(TB_SRCBILL_NUM).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)srcBillF7));
    }

    @Override
    public void loadFields() {
        this.removeListener();
        super.loadFields();
        try {
            this.initEntry();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        this.addListener();
        if (this.editData != null && this.editData.getBaseStatus() == BillBaseStatusEnum.AUDITED) {
            this.actionEdit.setEnabled(true);
        }
        if (this.actionAddLine.isEnabled()) {
            KDTableHelper.downArrowAutoAddRow((KDTable)this.kdtEntries, (boolean)true, (Action)this.actionTable);
            KDTableHelper.updateEnterWithTab((KDTable)this.kdtEntries, (boolean)true, (Action)this.actionTable);
        } else {
            KDTableHelper.downArrowAutoAddRow((KDTable)this.kdtEntries, (boolean)false, (Action)this.actionTable);
            KDTableHelper.updateEnterWithTab((KDTable)this.kdtEntries, (boolean)false, (Action)this.actionTable);
        }
    }

    private void initEntry() throws EASBizException, BOSException {
        this.setMaterial();
        this.setScrapType();
        if (this.kdtEntries.getRowCount() == 0) {
            return;
        }
        MaterialInfo[] products = new MaterialInfo[this.kdtEntries.getRowCount()];
        MeasureUnitInfo[] productsUnits = new MeasureUnitInfo[this.kdtEntries.getRowCount()];
        MaterialInfo[] materials = new MaterialInfo[this.kdtEntries.getRowCount()];
        MeasureUnitInfo[] units = new MeasureUnitInfo[this.kdtEntries.getRowCount()];
        String[] productQty = new String[]{TB_PRODUCT_QTY};
        for (int i = 0; i < this.kdtEntries.getRowCount(); ++i) {
            products[i] = (MaterialInfo)this.kdtEntries.getRow(i).getCell(TB_PRODUCT).getValue();
            productsUnits[i] = (MeasureUnitInfo)this.kdtEntries.getRow(i).getCell(TB_PRODUCT_UNIT).getValue();
            materials[i] = (MaterialInfo)this.kdtEntries.getRow(i).getCell(TB_MATERIAL).getValue();
            units[i] = (MeasureUnitInfo)this.kdtEntries.getRow(i).getCell(TB_UNIT).getValue();
        }
        SCMEntryDataVO vo = new SCMEntryDataVO();
        vo.setMaterialInfos(materials);
        vo.setMeasureUnitInfos(units);
        SCMEntryDataVO voResult1 = SCMGroupFacadeFactory.getRemoteInstance().loadMmuPrecision(vo);
        vo = new SCMEntryDataVO();
        vo.setMaterialInfos(products);
        vo.setMeasureUnitInfos(productsUnits);
        SCMEntryDataVO voResult2 = SCMGroupFacadeFactory.getRemoteInstance().loadMmuPrecision(vo);
        if (voResult1.getMmuConvsRate() != null) {
            this.conRateMap.putAll(voResult1.getMmuConvsRate());
        }
        for (int i = 0; i < this.kdtEntries.getRowCount(); ++i) {
            if (materials[i] != null) {
                this.kdtEntries.getCell(i, TB_MATERIAL_NAME).setValue((Object)materials[i].getName());
                this.kdtEntries.getCell(i, TB_MATERIAL_MODEL).setValue((Object)materials[i].getModel());
            }
            this.setQtiesPrecision(materials[i], units[i], i, voResult1);
            SCMClientUtils.changeTableColPrecision((Map)voResult2.getMmuPrecisions(), (MaterialInfo)products[i], (MeasureUnitInfo)productsUnits[i], (KDTable)this.kdtEntries, (String[])productQty, (int)i);
            this.setDataStatusForScrapType(i, (ScrapTypeEnum)((Object)this.kdtEntries.getCell(i, TB_SCRAP_TYPE).getValue()));
            if (this.kdtEntries.getCell(i, TB_OPERATION_NUMBER).getValue() == null || this.kdtEntries.getCell(i, TB_OPERATION_NUMBER).getValue().toString().equals("0")) {
                this.kdtEntries.getCell(i, TB_OPERATION_NUMBER).setValue(null);
            }
            if (this.isManual() || this.kdtEntries.getCell(i, TB_SCRAP_TYPE).getValue() != null) continue;
            this.kdtEntries.getCell(i, TB_SCRAP_TYPE).setValue((Object)ScrapTypeEnum.BecauseOfWork);
        }
    }

    private void removeListener() {
        this.kdtEntries.removeKDTEditListener((KDTEditListener)this.entryTableChange);
        if (this.prmtadminOrgUnitDataChanged != null) {
            this.prmtAdminOrgUnit.removeDataChangeListener(this.prmtadminOrgUnitDataChanged);
        }
    }

    private void addListener() {
        if (this.entryTableChange == null) {
            this.entryTableChange = new KDTEditAdapter(){

                public void editStopped(KDTEditEvent e) {
                    try {
                        ScrapOrderEditUI.this.kdtEntries_EditStopped(e);
                    }
                    catch (Exception exc) {
                        ScrapOrderEditUI.this.handUIException(exc);
                    }
                }

                public void editStarting(KDTEditEvent e) {
                    try {
                        ScrapOrderEditUI.this.kdtEntries_EditStarting(e);
                    }
                    catch (Exception exc) {
                        ScrapOrderEditUI.this.handUIException(exc);
                    }
                }
            };
        }
        this.kdtEntries.addKDTEditListener((KDTEditListener)this.entryTableChange);
        this.actionTable = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ScrapOrderEditUI.this.getDetailTable() != null) {
                    ScrapOrderEditUI.this.getDetailTable().removeRow(ScrapOrderEditUI.this.getDetailTable().getRowCount() - 1);
                    ScrapOrderEditUI.this.addLine(ScrapOrderEditUI.this.getDetailTable());
                }
            }
        };
        this.prmtadminOrgUnitDataChanged = new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                if (SCMGroupClientUtils.isDiffrent((Object)eventObj.getNewValue(), (Object)eventObj.getOldValue())) {
                    ScrapOrderEditUI.this.onAdminOrgChanged(eventObj);
                }
            }
        };
        this.prmtAdminOrgUnit.addDataChangeListener(this.prmtadminOrgUnitDataChanged);
    }

    protected void kdtEntries_EditStarting(KDTEditEvent e) throws EASBizException, BOSException {
        if (MMUtils.isEmptyString((String)this.txtNumber.getText()) && 0 == this.txtNumber.getAccessAuthority()) {
            MsgBox.showInfo((String)this.getScrapOrderResource("TableHeadInfo_Not_Complete"));
            this.txtNumber.requestFocus();
            e.setCancel(true);
        } else if (this.prmtStorageOrgUnit.getValue() == null) {
            MsgBox.showInfo((String)this.getScrapOrderResource("TableHeadInfo_Not_Complete"));
            this.prmtStorageOrgUnit.requestFocus();
            e.setCancel(true);
        } else if (this.prmtAdminOrgUnit.getValue() == null) {
            MsgBox.showInfo((String)this.getScrapOrderResource("TableHeadInfo_Not_Complete"));
            this.prmtAdminOrgUnit.requestFocus();
            e.setCancel(true);
        }
        if (!e.isCancel()) {
            if (e.getColIndex() == this.kdtEntries.getColumn(TB_OPERATION_NUMBER).getColumnIndex()) {
                this.onOPNumCellFocusIn(e);
            }
            if (e.getColIndex() == this.kdtEntries.getColumn(TB_SRCBILL_NUM).getColumnIndex()) {
                this.onSrcBillNumFocusIn(e);
            }
            if (e.getColIndex() == this.kdtEntries.getColumn(TB_MATERIAL).getColumnIndex()) {
                this.onMaterialFocusIn(e);
            }
            if (e.getColIndex() == this.kdtEntries.getColumn(TB_SCRAP_TYPE).getColumnIndex()) {
                this.onScrapTypeFocusIn(e);
            }
        }
    }

    private void onScrapTypeFocusIn(KDTEditEvent e) {
        int curRowIdx = e.getRowIndex();
        if (ScrapTypeEnum.BecauseOfRedundancy.equals((Object)((ScrapTypeEnum)((Object)this.kdtEntries.getRow(curRowIdx).getCell(TB_SCRAP_TYPE).getValue())))) {
            e.setCancel(true);
        } else {
            this.kdtEntries.getColumn(TB_SCRAP_TYPE).setEditor((ICellEditor)this.kdtEntries_scrapType_noRedundancy);
        }
    }

    private void onMaterialFocusIn(KDTEditEvent e) {
        int curRowIdx = e.getRowIndex();
        if (!ScrapTypeEnum.BecauseOfRedundancy.equals((Object)((ScrapTypeEnum)((Object)this.kdtEntries.getRow(curRowIdx).getCell(TB_SCRAP_TYPE).getValue())))) {
            e.setCancel(true);
            return;
        }
    }

    private void onSrcBillNumFocusIn(KDTEditEvent e) {
        int curRowIdx = e.getRowIndex();
        if (!ScrapTypeEnum.BecauseOfRedundancy.equals((Object)((ScrapTypeEnum)((Object)this.kdtEntries.getRow(curRowIdx).getCell(TB_SCRAP_TYPE).getValue())))) {
            e.setCancel(true);
            return;
        }
        KDBizPromptBox bizPromptBox = (KDBizPromptBox)this.kdtEntries.getColumn(TB_SRCBILL_NUM).getEditor().getComponent();
        EntityViewInfo moViewInfo = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo(TB_MATERIAL_ID));
        sic.add(new SelectorItemInfo("material.number"));
        sic.add(new SelectorItemInfo("material.name"));
        sic.add(new SelectorItemInfo("material.model"));
        sic.add(new SelectorItemInfo("project.id"));
        sic.add(new SelectorItemInfo("project.number"));
        sic.add(new SelectorItemInfo("trackNumber.id"));
        sic.add(new SelectorItemInfo("trackNumber.number"));
        sic.add(new SelectorItemInfo(TB_LOT));
        sic.add(new SelectorItemInfo("bizType.id"));
        sic.add(new SelectorItemInfo("bizType.name"));
        sic.add(new SelectorItemInfo("qty"));
        sic.add(new SelectorItemInfo("unit.id"));
        sic.add(new SelectorItemInfo("unit.name"));
        sic.add(new SelectorItemInfo("bizDate"));
        sic.add(new SelectorItemInfo("billType.id"));
        sic.add(new SelectorItemInfo("costObject.id"));
        sic.add(new SelectorItemInfo("costObject.name"));
        bizPromptBox.setSelectorCollection(sic);
        FilterInfo moFilterInfo = new FilterInfo();
        StorageOrgUnitInfo orgInfo = (StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue();
        String storageOrgId = "";
        if (orgInfo != null) {
            storageOrgId = orgInfo.getId().toString();
        }
        AdminOrgUnitInfo adminOrgInfo = (AdminOrgUnitInfo)this.prmtAdminOrgUnit.getValue();
        String adminOrgId = "";
        if (adminOrgInfo != null) {
            adminOrgId = adminOrgInfo.getId().toString();
        }
        moFilterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storageOrgId));
        moFilterInfo.getFilterItems().add(new FilterItemInfo("adminOrgUnit.id", (Object)adminOrgId));
        moFilterInfo.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)"5,8", CompareType.INCLUDE));
        moViewInfo.setFilter(moFilterInfo);
        bizPromptBox.setEntityViewInfo(moViewInfo);
    }

    private void onOPNumCellFocusIn(KDTEditEvent e) {
        int curRowIdx = e.getRowIndex();
        if (!ScrapTypeEnum.BecauseOfRedundancy.equals((Object)((ScrapTypeEnum)((Object)this.kdtEntries.getRow(curRowIdx).getCell(TB_SCRAP_TYPE).getValue())))) {
            e.setCancel(true);
            return;
        }
        Object srcBillId = this.kdtEntries.getCell(curRowIdx, TB_SRCBILL_ID).getValue();
        if (srcBillId == null || srcBillId.equals("")) {
            e.setCancel(true);
            return;
        }
        KDBizPromptBox bizPromptBox = (KDBizPromptBox)this.kdtEntries.getColumn(TB_OPERATION_NUMBER).getEditor().getComponent();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo(TB_OPERATION_NUMBER));
        sic.add(new SelectorItemInfo("operation.number"));
        sic.add(new SelectorItemInfo("operation.name"));
        sic.add(new SelectorItemInfo("operation.id"));
        sic.add(new SelectorItemInfo("parent.*"));
        sic.add(new SelectorItemInfo("storageOrgUnit.id"));
        sic.add(new SelectorItemInfo("storageOrgUnit.name"));
        sic.add(new SelectorItemInfo("entrustType"));
        sic.add(new SelectorItemInfo("adminOrgUnit.id"));
        sic.add(new SelectorItemInfo("adminOrgUnit.name"));
        sic.add(new SelectorItemInfo("moAdminOrgUnit.id"));
        sic.add(new SelectorItemInfo("moAdminOrgUnit.name"));
        bizPromptBox.setSelectorCollection(sic);
        EntityViewInfo curViewInfo = new EntityViewInfo();
        FilterInfo curFilterInfo = new FilterInfo();
        curFilterInfo.getFilterItems().add(new FilterItemInfo("ManufactureOrder.id", (Object)srcBillId.toString(), CompareType.EQUALS));
        curViewInfo.setFilter(curFilterInfo);
        bizPromptBox.setEntityViewInfo(curViewInfo);
    }

    private void onOPNumChanged(KDTEditEvent e) {
        int curRowIdx = e.getRowIndex();
        ManufactureOrderTechnicsInfo curMOTechInfo = null;
        if (e.getValue() != null) {
            curMOTechInfo = (ManufactureOrderTechnicsInfo)e.getValue();
        }
        if (curMOTechInfo != null) {
            this.kdtEntries.getCell(curRowIdx, TB_OPERATION_NUMBER).setValue((Object)new Integer(curMOTechInfo.getOperationNo()));
            this.kdtEntries.getCell(curRowIdx, TB_OPERATION).setValue((Object)curMOTechInfo.getOperation());
            this.kdtEntries.getCell(curRowIdx, TB_OPERATION_NAME).setValue((Object)curMOTechInfo.getOperation().getName());
            this.kdtEntries.getCell(curRowIdx, TB_PROCESS_ORG).setValue((Object)curMOTechInfo.getStorageOrgUnit());
            this.kdtEntries.getCell(curRowIdx, TB_PROCESS_DEPT).setValue((Object)curMOTechInfo.getAdminOrgUnit());
            this.kdtEntries.getCell(curRowIdx, TB_MOTECHNIC_ID).setValue((Object)curMOTechInfo);
            CSEntrustTypeEnum entrustType = curMOTechInfo.getEntrustType();
            AdminOrgUnitInfo techAdminOrg = curMOTechInfo.getAdminOrgUnit();
            AdminOrgUnitInfo moAdminOrg = (AdminOrgUnitInfo)this.prmtAdminOrgUnit.getValue();
            this.kdtEntries.getCell(curRowIdx, TB_PICK_DEPT).setValue((Object)MOStockUtil.getDefaultPickDept(moAdminOrg, entrustType, techAdminOrg));
        } else {
            this.kdtEntries.getCell(curRowIdx, TB_OPERATION_NUMBER).setValue(null);
            this.kdtEntries.getCell(curRowIdx, TB_OPERATION).setValue(null);
            this.kdtEntries.getCell(curRowIdx, TB_OPERATION_NAME).setValue(null);
            this.kdtEntries.getCell(curRowIdx, TB_PROCESS_ORG).setValue(null);
            this.kdtEntries.getCell(curRowIdx, TB_PROCESS_DEPT).setValue(null);
            this.kdtEntries.getCell(curRowIdx, TB_MOTECHNIC_ID).setValue(null);
            this.kdtEntries.getCell(curRowIdx, TB_PICK_DEPT).setValue(this.prmtAdminOrgUnit.getValue());
            ScrapOrderEntryInfo targetEntry = this.editData.getEntries().get(curRowIdx);
            if (targetEntry != null) {
                targetEntry.setOperationNo(0);
            }
        }
    }

    private void onSrcBillNumChanged(KDTEditEvent e) {
        MeasureUnitInfo curProductUnitInfo;
        TrackNumberInfo curTrackInfo;
        ProjectInfo curProjectInfo;
        MaterialInfo productItem;
        int curRowIdx = e.getRowIndex();
        ManufactureOrderInfo curMOInfo = null;
        if (e.getValue() != null) {
            curMOInfo = (ManufactureOrderInfo)e.getValue();
        }
        if (curMOInfo != null) {
            this.kdtEntries.getCell(curRowIdx, TB_SRCBILL_ID).setValue((Object)curMOInfo.getId().toString());
            this.kdtEntries.getCell(curRowIdx, TB_SRCBILL_NUM).setValue((Object)curMOInfo.getNumber());
        } else {
            this.kdtEntries.getCell(curRowIdx, TB_SRCBILL_ID).setValue(null);
            this.kdtEntries.getCell(curRowIdx, TB_SRCBILL_NUM).setValue(null);
        }
        MaterialInfo materialInfo = productItem = curMOInfo == null ? null : curMOInfo.getMaterial();
        if (productItem != null) {
            this.kdtEntries.getCell(curRowIdx, TB_PRODUCT).setValue((Object)productItem);
            this.kdtEntries.getCell(curRowIdx, TB_PRODUCT_NUM).setValue((Object)productItem.getNumber());
            this.kdtEntries.getCell(curRowIdx, TB_PRODUCT_NAME).setValue((Object)productItem.getName());
            this.kdtEntries.getCell(curRowIdx, TB_PRODUCT_MODEL).setValue((Object)productItem.getModel());
        } else {
            this.kdtEntries.getCell(curRowIdx, TB_PRODUCT).setValue(null);
            this.kdtEntries.getCell(curRowIdx, TB_PRODUCT_NUM).setValue(null);
            this.kdtEntries.getCell(curRowIdx, TB_PRODUCT_NAME).setValue(null);
            this.kdtEntries.getCell(curRowIdx, TB_PRODUCT_MODEL).setValue(null);
        }
        ProjectInfo projectInfo = curProjectInfo = curMOInfo == null ? null : curMOInfo.getProject();
        if (curProjectInfo != null) {
            this.kdtEntries.getCell(curRowIdx, TB_PROJECT).setValue((Object)curProjectInfo);
            this.kdtEntries.getCell(curRowIdx, TB_PROJECT_NUM).setValue((Object)curProjectInfo.getNumber());
        } else {
            this.kdtEntries.getCell(curRowIdx, TB_PROJECT).setValue(null);
            this.kdtEntries.getCell(curRowIdx, TB_PROJECT_NUM).setValue(null);
        }
        TrackNumberInfo trackNumberInfo = curTrackInfo = curMOInfo == null ? null : curMOInfo.getTrackNumber();
        if (curTrackInfo != null) {
            this.kdtEntries.getCell(curRowIdx, TB_TRACK).setValue((Object)curTrackInfo);
            this.kdtEntries.getCell(curRowIdx, TB_TRACK_NUM).setValue((Object)curTrackInfo.getNumber());
        } else {
            this.kdtEntries.getCell(curRowIdx, TB_TRACK).setValue(null);
            this.kdtEntries.getCell(curRowIdx, TB_TRACK_NUM).setValue(null);
        }
        MeasureUnitInfo measureUnitInfo = curProductUnitInfo = curMOInfo == null ? null : curMOInfo.getUnit();
        if (curProductUnitInfo != null) {
            this.kdtEntries.getCell(curRowIdx, TB_PRODUCT_UNIT).setValue((Object)curProductUnitInfo);
        } else {
            this.kdtEntries.getCell(curRowIdx, TB_PRODUCT_UNIT).setValue(null);
        }
        this.kdtEntries.getCell(curRowIdx, TB_PRODUCT_QTY).setValue((Object)SCMClientUtils.ZERO);
        if (curMOInfo != null) {
            this.kdtEntries.getCell(curRowIdx, TB_SRCBILL_TYPE).setValue((Object)curMOInfo.getBillType());
        } else {
            this.editData.getEntries().get(curRowIdx).setSourceBillType(null);
        }
        if (curMOInfo != null) {
            this.kdtEntries.getCell(curRowIdx, TB_COST_OBJECT).setValue((Object)curMOInfo.getCostObject());
        } else {
            this.kdtEntries.getCell(curRowIdx, TB_COST_OBJECT).setValue(null);
        }
        this.kdtEntries.getCell(curRowIdx, TB_PICK_DEPT).setValue(this.prmtAdminOrgUnit.getValue());
        this.kdtEntries.getCell(curRowIdx, TB_OPERATION_NAME).setValue(null);
        this.kdtEntries.getCell(curRowIdx, TB_OPERATION_NUMBER).setValue(null);
        this.kdtEntries.getCell(curRowIdx, TB_OPERATION).setValue(null);
        this.kdtEntries.getCell(curRowIdx, TB_PROCESS_ORG).setValue(null);
        this.kdtEntries.getCell(curRowIdx, TB_PROCESS_DEPT).setValue(null);
        ScrapOrderEntryInfo targetEntry = this.editData.getEntries().get(curRowIdx);
        if (targetEntry != null) {
            targetEntry.setOperationNo(0);
        }
    }

    protected void kdtEntries_EditStopped(KDTEditEvent e) throws EASBizException, BOSException {
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        if (colIndex == this.kdtEntries.getColumn(TB_IS_SUPPLY_MATERIAL).getColumnIndex()) {
            this.setDataStatusAndValueForSupplyMaterial(rowIndex);
        }
        if (colIndex == this.kdtEntries.getColumn(TB_UNIT).getColumnIndex()) {
            MaterialInfo material = (MaterialInfo)this.kdtEntries.getCell(e.getRowIndex(), TB_MATERIAL).getValue();
            if (material == null) {
                return;
            }
            MeasureUnitInfo oldUnit = (MeasureUnitInfo)e.getOldValue();
            MeasureUnitInfo newUnit = (MeasureUnitInfo)e.getValue();
            if (newUnit == null) {
                newUnit = oldUnit;
                this.kdtEntries.getCell(rowIndex, TB_UNIT).setValue((Object)newUnit);
            }
            this.unitChange(material, newUnit, oldUnit, rowIndex);
        }
        if (colIndex == this.kdtEntries.getColumn(TB_BACK_WAREHOUSE).getColumnIndex()) {
            WarehouseInfo oldUnit = (WarehouseInfo)e.getOldValue();
            WarehouseInfo newUnit = (WarehouseInfo)e.getValue();
            if (oldUnit == null || newUnit != null && newUnit.getId().equals((Object)oldUnit.getId())) {
                return;
            }
            this.kdtEntries.getRow(rowIndex).getCell(TB_BACK_LOCATION).setValue(null);
            this.setLocationForBackWareHouse(rowIndex);
        }
        if (colIndex == this.kdtEntries.getColumn(TB_PRODUCT_QTY).getColumnIndex()) {
            if (this.kdtEntries.getRow(rowIndex).getCell(TB_PRODUCT_QTY).getValue() == null) {
                this.kdtEntries.getRow(rowIndex).getCell(TB_PRODUCT_QTY).setValue((Object)SCMClientUtils.ZERO);
            }
            this.setQtyForProductQty(rowIndex);
        }
        if (colIndex == this.kdtEntries.getColumn(TB_SUPPLY_REQUIRED_QTY).getColumnIndex() && this.kdtEntries.getRow(rowIndex).getCell(TB_SUPPLY_REQUIRED_QTY).getValue() == null) {
            this.kdtEntries.getRow(rowIndex).getCell(TB_SUPPLY_REQUIRED_QTY).setValue((Object)SCMClientUtils.ZERO);
        }
        if (colIndex == this.kdtEntries.getColumn(TB_SCRAP_QTY).getColumnIndex()) {
            if (this.kdtEntries.getRow(rowIndex).getCell(TB_SCRAP_QTY).getValue() == null) {
                this.kdtEntries.getRow(rowIndex).getCell(TB_SCRAP_QTY).setValue((Object)SCMClientUtils.ZERO);
            }
            if (this.kdtEntries.getRow(rowIndex).getCell(TB_IS_SUPPLY_MATERIAL).getValue().toString().equals("true")) {
                this.kdtEntries.getRow(rowIndex).getCell(TB_SUPPLY_REQUIRED_QTY).setValue((Object)((BigDecimal)this.kdtEntries.getRow(rowIndex).getCell(TB_SCRAP_QTY).getValue()));
            }
        }
        if (colIndex == this.kdtEntries.getColumn(TB_MATERIAL).getColumnIndex() && e.getValue() == null) {
            this.kdtEntries.getCell(rowIndex, TB_MATERIAL).setValue(e.getOldValue());
        }
        if (colIndex == this.kdtEntries.getColumn(TB_SRCBILL_NUM).getColumnIndex() && SCMGroupClientUtils.isDiffrent((Object)e.getValue(), (Object)e.getOldValue())) {
            this.onSrcBillNumChanged(e);
        }
        if (colIndex == this.kdtEntries.getColumn(TB_OPERATION_NUMBER).getColumnIndex() && SCMGroupClientUtils.isDiffrent((Object)e.getValue(), (Object)e.getOldValue())) {
            this.onOPNumChanged(e);
        }
    }

    private void unitChange(MaterialInfo material, MeasureUnitInfo unit, MeasureUnitInfo oldUnit, int rowIndex) throws EASBizException, BOSException {
        SCMEntryDataVO vo = new SCMEntryDataVO();
        vo.setMaterialInfos(new MaterialInfo[]{material});
        vo.setMeasureUnitInfos(new MeasureUnitInfo[]{unit});
        SCMEntryDataVO voResult = SCMGroupFacadeFactory.getRemoteInstance().loadMmuPrecision(vo);
        ICell iCell = null;
        IRow row = this.kdtEntries.getRow(rowIndex);
        BigDecimal qty = null;
        int num = TB_QTYS.length;
        for (int i = 0; i < num; ++i) {
            iCell = row.getCell(TB_QTYS[i]);
            if (iCell == null || iCell.getValue() == null) continue;
            qty = new BigDecimal(iCell.getValue().toString());
            iCell.setValue(qty == null ? null : com.kingdee.eas.mm.common.client.MMUtils.getExchangeQtyForClient((String)material.getId().toString(), (MeasureUnitInfo)oldUnit, (MeasureUnitInfo)unit, (BigDecimal)qty));
        }
        this.setQtiesPrecision(material, unit, rowIndex, voResult);
        if (this.isManual()) {
            return;
        }
        if (voResult.getMmuConvsRate() != null) {
            this.conRateMap.putAll(voResult.getMmuConvsRate());
        }
        String keyNew = material.getId().toString() + unit.getId().toString();
        BigDecimal rateNew = (BigDecimal)this.conRateMap.get(keyNew);
        String keyOld = material.getId().toString() + oldUnit.getId().toString();
        BigDecimal rateOld = (BigDecimal)this.conRateMap.get(keyOld);
        ICell unitQtyCell = this.kdtEntries.getCell(rowIndex, TB_UNIT_QTY);
        BigDecimal oldUnitQty = (BigDecimal)unitQtyCell.getValue();
        if (rateOld != null) {
            BigDecimal ratio = rateOld.divide(rateNew, 8, 4);
            if (oldUnitQty != null) {
                BigDecimal unitQty = oldUnitQty.multiply(ratio).setScale(8, 4);
                this.kdtEntries.getCell(rowIndex, TB_UNIT_QTY).setValue((Object)unitQty);
            }
        }
    }

    private void setQtiesPrecision(MaterialInfo material, MeasureUnitInfo unit, int rowIndex, SCMEntryDataVO voResult) {
        Integer preci = null;
        Map mulUnitMap = voResult.getMmuPrecisions();
        if (mulUnitMap != null && unit != null && material != null && (preci = (Integer)mulUnitMap.get(material.getId().toString() + unit.getId().toString())) != null) {
            this.qtyPrecision = preci;
        }
        SCMClientUtils.changeTableColPrecision((int)this.qtyPrecision, (KDTable)this.kdtEntries, (String[])TB_QTYS, (int)rowIndex);
    }

    protected IObjectValue createNewData() {
        StorageOrgUnitInfo storageOrgInfo;
        this.curStorageOrgUnit = storageOrgInfo = (StorageOrgUnitInfo)this.getDefaultMainBizOrg();
        ScrapOrderInfo info = null;
        try {
            info = this.createNewData(storageOrgInfo);
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
        }
        info.setStorageOrgUnit(this.curStorageOrgUnit);
        this.txtNumber.setText(null);
        return info;
    }

    private ScrapOrderInfo createNewData(StorageOrgUnitInfo storageOrgInfo) throws Exception {
        return ((IScrapOrder)this.getBizInterface()).createNewSO(this.isUseAgent(), storageOrgInfo);
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        ScrapOrderEntryInfo info = new ScrapOrderEntryInfo();
        info.setScrapType(ScrapTypeEnum.BecauseOfRedundancy);
        info.setIsSupplyMaterial(true);
        info.setRequireDate((Date)this.pkBizDate.getValue());
        info.setAssCoefficient(new BigDecimal("0.0"));
        return info;
    }

    protected void afterMainOrgChanged(String arg0, String arg1) {
        if (arg1 == null) {
            this.getMainBizOrg().setValue((Object)this.getMainOrgInfo());
            return;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)arg0, CompareType.EQUALS));
        view.setFilter(filterInfo);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("id"));
        StorageOrgUnitCollection SOUCol = null;
        try {
            SOUCol = StorageOrgUnitFactory.getRemoteInstance().getStorageOrgUnitCollection(view);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        if (SOUCol != null && SOUCol.size() > 0 && !SOUCol.get(0).isIsBizUnit()) {
            return;
        }
        super.afterMainOrgChanged(arg0, arg1);
        boolean isDiffrent = SCMGroupClientUtils.isDiffrent((Object)arg0, (Object)arg1);
        if (isDiffrent) {
            if (arg0 != null) {
                this.prmtAdminOrgUnit.setValue(null);
            }
            this.getDetailTable().removeRows();
            if (this.getMainBizOrg().getValue() != null) {
                this.setEntryMaterialF7();
                this.setEntryBackWareHouseF7();
            }
        }
    }

    protected String getPermissionItem(String status) {
        if ("ADDNEW".equals(status)) {
            return "mm_scrapOrder_addNew";
        }
        if ("EDIT".equals(status)) {
            return "mm_scrapOrder_update";
        }
        if ("VIEW".equals(status)) {
            return "mm_scrapOrder_view";
        }
        return null;
    }

    protected KDTable getDetailTable() {
        return this.kdtEntries;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    protected KDBizPromptBox getMainBizOrg() {
        return this.prmtStorageOrgUnit;
    }

    public KDBizPromptBox getMainOrgUnit() {
        return this.prmtStorageOrgUnit;
    }

    public KDTextField getNumTextField() {
        return this.txtNumber;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return ScrapOrderFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return ScrapOrderEditUI.class.getName();
    }

    protected void doBeforeSubmit(ActionEvent e) throws Exception {
        super.doBeforeSubmit(e);
    }

    private String getScrapOrderResource(String sKey) {
        return EASResource.getString((String)"com.kingdee.eas.mm.mo.ScrapOrderResource", (String)sKey);
    }

    protected void initNeedMainOrgF7s() {
        this.setEntryMaterialF7();
        this.f7Manager.registerMeasureUnitF7(this.kdtEntries, TB_MATERIAL, TB_UNIT);
        this.f7Manager.registerBizOrgF7(this.prmtAdminOrgUnit, null, this.getMainBizOrgType(), OrgType.Admin, true);
        this.registerWarehouse();
        KDBizPromptBox locationF7Operation = new KDBizPromptBox();
        locationF7Operation.setEditFormat("$name$");
        locationF7Operation.setDisplayFormat("$name$");
        locationF7Operation.setCommitFormat("$name$");
        this.kdtEntries.getColumn(TB_BACK_LOCATION).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)locationF7Operation));
        this.kdtEntries.getColumn(TB_BACK_LOCATION).getEditor().getComponent();
        UIHelper.registerLocationF7((KDTable)this.kdtEntries, (String)TB_BACK_WAREHOUSE, (String)TB_BACK_LOCATION);
        UIHelper.registerProjectF7((KDBizPromptBox)this.getMainOrgUnit(), null, (KDTable)this.kdtEntries, (String)TB_PROJECT);
        UIHelper.registerTrackNumberF7((KDBizPromptBox)this.getMainOrgUnit(), null, (KDTable)this.kdtEntries, (String)TB_PROJECT, (String)TB_TRACK, (boolean)false);
        this.setNeedMainOrgF7s(new KDBizPromptBox[]{this.prmtAdminOrgUnit});
    }

    private void registerWarehouse() {
        KDBizPromptBox kDBizPromptBoxBackWarehouse = new KDBizPromptBox();
        kDBizPromptBoxBackWarehouse.setEditable(true);
        kDBizPromptBoxBackWarehouse.setDisplayFormat("$number$");
        kDBizPromptBoxBackWarehouse.setEditFormat("$number$");
        kDBizPromptBoxBackWarehouse.setCommitFormat("$number$");
        this.kdtEntries.getColumn(TB_BACK_WAREHOUSE).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)kDBizPromptBoxBackWarehouse));
        kDBizPromptBoxBackWarehouse.setQueryInfo("com.kingdee.eas.basedata.scm.im.inv.app.F7WarehouseQuery");
        KDBizPromptBox kDBizPromptBoxWarehouse = new KDBizPromptBox();
        kDBizPromptBoxWarehouse.setEditable(true);
        kDBizPromptBoxWarehouse.setDisplayFormat("$number$");
        kDBizPromptBoxWarehouse.setEditFormat("$number$");
        kDBizPromptBoxWarehouse.setCommitFormat("$number$");
        this.kdtEntries.getColumn(TB_WAREHOUSE).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)kDBizPromptBoxWarehouse));
        kDBizPromptBoxWarehouse.setQueryInfo("com.kingdee.eas.basedata.scm.im.inv.app.F7WarehouseQuery");
        kDBizPromptBoxWarehouse.addCommitListener(new CommitListener(){

            public void willCommit(CommitEvent paramCommitEvent) {
                ScrapOrderEditUI.this.setWareHouseF7((KDBizPromptBox)paramCommitEvent.getSource());
            }
        });
        kDBizPromptBoxWarehouse.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                ScrapOrderEditUI.this.setWareHouseF7((KDBizPromptBox)e.getSource());
            }
        });
    }

    private void setWareHouseF7(KDBizPromptBox prmtBox) {
        try {
            int rowIndex = this.kdtEntries.getSelectManager().getActiveRowIndex();
            StorageOrgUnitInfo storageOrgUnitInfo = (StorageOrgUnitInfo)this.kdtEntries.getCell(rowIndex, TB_STO).getValue();
            MaterialProvideTypeEnum mptEnum = (MaterialProvideTypeEnum)this.kdtEntries.getCell(rowIndex, TB_PROVIDE).getValue();
            if (MaterialProvideTypeEnum.SPANORGATTEMPERPROVIDE.equals((Object)mptEnum)) {
                storageOrgUnitInfo = (StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue();
            }
            if (storageOrgUnitInfo != null) {
                prmtBox.setEntityViewInfo(SCMClientUtils.getWarehouseFilter((StorageOrgUnitInfo)storageOrgUnitInfo, (int)-1));
            }
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        prmtBox.getQueryAgent().resetRuntimeEntityView();
    }

    protected void initDataStatus() {
        SCMBillBaseInfo info = (SCMBillBaseInfo)this.dataBinder.getValueObject();
        if (info != null && info.getBaseStatus().getValue() >= 4) {
            this.setOprtState("VIEW");
        }
        super.initDataStatus();
        this.prmtSourceBillType.setEnabled(false);
        if (info != null) {
            boolean b;
            BillBaseStatusEnum billStatus = info.getBaseStatus();
            boolean bl = b = billStatus.equals((Object)BillBaseStatusEnum.SUBMITED) || billStatus.equals((Object)BillBaseStatusEnum.TEMPORARILYSAVED);
            if (this.getOprtState().equals("EDIT")) {
                this.actionEdit.setEnabled(false);
            } else {
                this.actionEdit.setEnabled(b);
            }
        }
        this.prmtAdminOrgUnit.setReadOnly(this.isBotpBill());
        this.prmtAdminOrgUnit.setRequired(!this.isBotpBill());
    }

    public String getOprtState() {
        if (this.oprtState == null) {
            this.oprtState = "ADDNEW";
        }
        return this.oprtState;
    }

    protected boolean checkValid() {
        return true;
    }

    public boolean isSupportedBatchActions() {
        return true;
    }

    public void initBatchActions() throws BOSException {
        this.actionManager.setClzIBizFactory(ActionLevelEnum.HEAD, ScrapOrderFactory.class);
        this.getTableSelectionHelper().setTableProperty((ISupportBatchAction)this, this.kdtEntries, "id", this.txtNumber, null);
        super.initBatchActions();
    }

    protected IMetaDataPK getTDQueryPK() {
        return MetaDataPK.create((String)"com.kingdee.eas.mm.mo.app.ScrapOrderPrintQuery");
    }

    protected String getTDFileName() {
        return "/MM/dmes/mo/so";
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        IObjectPK pk = LogUtil.beginLog(null, (String)"print", (BOSObjectType)this.editData.getBOSType(), null, (String)"mm_scrapOrder_print");
        super.actionPrint_actionPerformed(e);
        this.invokePrintFunction(true);
        LogUtil.afterLog(null, (IObjectPK)pk);
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrintPreview_actionPerformed(e);
        this.invokePrintFunction(false);
    }

    protected void initInFirstOnLoad() {
        super.initInFirstOnLoad();
    }

    public String getBOTPCreateFromListUIClassName(String destBosType) {
        return "com.kingdee.eas.mm.mo.client.ManufactureOrderStockListUI";
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        if (this.kdtEntries == null || this.kdtEntries.getRowCount() == 0) {
            MsgBox.showInfo((String)this.getScrapOrderResource("Entries_Is_Null"));
            SysUtil.abort();
        }
        super.actionSave_actionPerformed(e);
    }

    public void actionRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemoveLine_actionPerformed(e);
    }

    protected boolean isSplitLine() {
        return true;
    }

    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddLine_actionPerformed(e);
    }

    protected void afterAddLine(KDTable table, IObjectValue lineData) {
        this.setNewLine(table.getRowCount() - 1);
    }

    protected void afterInsertLine(KDTable table, IObjectValue lineData) {
        int top = 0;
        if (table.getSelectManager().size() > 0 && (top = table.getSelectManager().get().getTop()) < 0 && table.getSelectManager().size() > 0) {
            top = 0;
        }
        this.setNewLine(top);
    }

    private void setNewLine(int index) {
        if (this.getDetailTable() != null) {
            ICell cell = this.getDetailTable().getCell(index, TB_SCRAP_TYPE);
            cell.getStyleAttributes().setLocked(true);
            cell.setEditor((ICellEditor)this.kdtEntries_scrapType_Redundancy);
            cell = this.getDetailTable().getCell(index, TB_IS_SUPPLY_MATERIAL);
            cell.getStyleAttributes().setLocked(true);
            cell = this.getDetailTable().getCell(index, TB_OPERATION_NUMBER);
            cell.setValue(null);
        }
    }

    protected List getSplitLineData(SCMBillEntryBaseInfo entryInfo, SplitOptionConfig splitOptConf, int topRow) {
        ArrayList<ScrapOrderEntryAgent> entryList = new ArrayList<ScrapOrderEntryAgent>();
        ScrapOrderEntryAgent info = null;
        for (int i = 0; i < splitOptConf.getSplitNum() - 1; ++i) {
            info = ScrapOrderEntryAgent.copyOvAsNewAgent((IObjectValue)entryInfo);
            info.setId(BOSUuid.create((String)"3302BCA5"));
            if (splitOptConf.getSplitPos() == 0) {
                if (entryInfo.getSeq() == 0) {
                    entryInfo.setSeq(topRow + 1);
                }
                info.setSeq(entryInfo.getSeq() + i + 1);
            } else {
                info.setSeq(this.getDetailTable().getRowCount() + i + 1);
            }
            entryList.add(info);
        }
        return entryList;
    }

    protected void afterInsertMaterials(int rowIdx, MaterialInfo[] materialInfos, Map dataMap) throws Exception {
        super.afterInsertMaterials(rowIdx, materialInfos, dataMap);
        StorageOrgUnitInfo org = (StorageOrgUnitInfo)this.getMainBizOrg().getData();
        HashSet<String> materialIdsSet = new HashSet<String>();
        for (int i = 0; i < materialInfos.length; ++i) {
            materialIdsSet.add(materialInfos[i].getId().toString());
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo(TB_PROVIDE));
        selectors.add(new SelectorItemInfo("supplyOrgUnit.*"));
        filter.getFilterItems().add(new FilterItemInfo(TB_MATERIAL_ID, materialIdsSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("orgUnit", (Object)org.getId().toString()));
        view.setFilter(filter);
        view.setSelector(selectors);
        MaterialPlanCollection mpCollection = MaterialPlanFactory.getRemoteInstance().getMaterialPlanCollection(view);
        view = new EntityViewInfo();
        filter = new FilterInfo();
        selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("defaultWarehouse.*"));
        filter.getFilterItems().add(new FilterItemInfo(TB_MATERIAL_ID, materialIdsSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("orgUnit", (Object)org.getId().toString()));
        view.setFilter(filter);
        view.setSelector(selectors);
        MaterialInventoryCollection miCollection = MaterialInventoryFactory.getRemoteInstance().getMaterialInventoryCollection(view);
        if (org != null) {
            MaterialPlanInfo materialPlan = null;
            MaterialInventoryInfo materialInventory = null;
            SCMEntryDataVO voResult = UIHelper.getDataVO((StorageOrgUnitInfo)org, (MaterialInfo[])materialInfos);
            for (int i = 0; i < materialInfos.length; ++i) {
                int j;
                this.kdtEntries.getCell(rowIdx + i, TB_MATERIAL_NAME).setValue((Object)materialInfos[i].getName());
                this.kdtEntries.getCell(rowIdx + i, TB_MATERIAL_MODEL).setValue((Object)materialInfos[i].getModel());
                this.kdtEntries.getCell(rowIdx + i, TB_UNIT).setValue((Object)voResult.getMeasureUnitInfos()[i]);
                this.kdtEntries.getCell(rowIdx + i, TB_BASE_UNIT).setValue((Object)voResult.getBaseMeasureUnitInfos()[i]);
                this.kdtEntries.getCell(rowIdx + i, TB_MATERIAL_ID).setValue((Object)materialInfos[i].getId());
                this.setQtiesPrecision(materialInfos[i], voResult.getMeasureUnitInfos()[i], rowIdx + i, voResult);
                for (j = 0; j < mpCollection.size(); ++j) {
                    if (!materialInfos[i].getId().equals((Object)mpCollection.get(j).getMaterial().getId())) continue;
                    materialPlan = mpCollection.get(j);
                }
                for (j = 0; j < miCollection.size(); ++j) {
                    if (!materialInfos[i].getId().equals((Object)miCollection.get(j).getMaterial().getId())) continue;
                    materialInventory = miCollection.get(j);
                }
                if (materialPlan != null) {
                    this.kdtEntries.getCell(rowIdx + i, TB_PROVIDE).setValue((Object)materialPlan.getProvideType());
                    this.kdtEntries.getCell(rowIdx + i, TB_STO).setValue((Object)materialPlan.getSupplyOrgUnit());
                }
                if (materialInventory == null) continue;
                this.kdtEntries.getCell(rowIdx + i, TB_WAREHOUSE).setValue((Object)materialInventory.getDefaultWarehouse());
            }
        }
    }

    private boolean isManual() {
        return this.prmtSourceBillType.getValue() == null;
    }

    private boolean isLotMaterial(MaterialInfo material) throws EASBizException, BOSException {
        StorageOrgUnitInfo org = (StorageOrgUnitInfo)this.getMainBizOrg().getData();
        SCMEntryDataVO voResult = UIHelper.getDataVO((StorageOrgUnitInfo)org, (MaterialInfo[])new MaterialInfo[]{material});
        String key = material.getId().toString() + org.getId().toString();
        MaterialInventoryInfo materialInv = (MaterialInventoryInfo)voResult.getMaterialInventoryInfos().get(key);
        return materialInv.isIsLotNumber();
    }

    private void setDataStatusForScrapType(int rowIndex, ScrapTypeEnum scrapType) throws EASBizException, BOSException {
        ICell lotCell = this.kdtEntries.getCell(rowIndex, TB_LOT);
        MaterialProvideTypeEnum provideType = (MaterialProvideTypeEnum)this.kdtEntries.getCell(rowIndex, TB_PROVIDE).getValue();
        if (ScrapTypeEnum.BecauseOfRedundancy.equals((Object)scrapType)) {
            this.kdtEntries.getCell(rowIndex, TB_BACK_WAREHOUSE).getStyleAttributes().setLocked(true);
            this.kdtEntries.getCell(rowIndex, TB_BACK_LOCATION).getStyleAttributes().setLocked(true);
            this.kdtEntries.getCell(rowIndex, TB_PRODUCT_QTY).getStyleAttributes().setLocked(true);
            this.kdtEntries.getCell(rowIndex, TB_SCRAP_QTY).getStyleAttributes().setLocked(true);
            this.kdtEntries.getCell(rowIndex, TB_IS_SUPPLY_MATERIAL).getStyleAttributes().setLocked(true);
            this.setDataStatusForSupplyMaterial(rowIndex);
            lotCell.getStyleAttributes().setLocked(true);
            lotCell.getStyleAttributes().setBackground(Color.WHITE);
        } else {
            this.kdtEntries.getCell(rowIndex, TB_BACK_WAREHOUSE).getStyleAttributes().setLocked(false);
            this.setLocationForBackWareHouse(rowIndex);
            this.kdtEntries.getCell(rowIndex, TB_PRODUCT_QTY).getStyleAttributes().setLocked(false);
            this.kdtEntries.getCell(rowIndex, TB_SCRAP_QTY).getStyleAttributes().setLocked(false);
            if (MaterialProvideTypeEnum.CURRENTORGPROVIDE.equals((Object)provideType) || MaterialProvideTypeEnum.SPANORGPROVIDE.equals((Object)provideType) || MaterialProvideTypeEnum.SPANORGATTEMPERPROVIDE.equals((Object)provideType)) {
                this.kdtEntries.getCell(rowIndex, TB_IS_SUPPLY_MATERIAL).getStyleAttributes().setLocked(false);
            } else {
                this.kdtEntries.getCell(rowIndex, TB_IS_SUPPLY_MATERIAL).setValue((Object)Boolean.FALSE);
                this.kdtEntries.getCell(rowIndex, TB_IS_SUPPLY_MATERIAL).getStyleAttributes().setLocked(true);
            }
            this.setDataStatusForSupplyMaterial(rowIndex);
            MaterialInfo material = (MaterialInfo)this.kdtEntries.getCell(rowIndex, TB_MATERIAL).getValue();
            if (material != null && this.isLotMaterial(material)) {
                lotCell.getStyleAttributes().setLocked(false);
                lotCell.getStyleAttributes().setBackground(this.requiredColor);
            } else {
                lotCell.getStyleAttributes().setLocked(true);
                lotCell.getStyleAttributes().setBackground(Color.WHITE);
            }
        }
    }

    private void setScrapType() {
        if (this.isManual()) {
            this.kdtEntries.getColumn(TB_SCRAP_TYPE).setEditor((ICellEditor)this.kdtEntries_scrapType_Redundancy);
            this.kdtEntries.getColumn(TB_SCRAP_TYPE).getStyleAttributes().setLocked(true);
        } else {
            this.kdtEntries.getColumn(TB_SCRAP_TYPE).setEditor((ICellEditor)this.kdtEntries_scrapType_noRedundancy);
            this.kdtEntries.getColumn(TB_SCRAP_TYPE).getStyleAttributes().setLocked(false);
        }
    }

    private void setMaterial() {
        this.kdtEntries.getColumn(TB_MATERIAL).getStyleAttributes().setLocked(false);
    }

    private void setDataStatusAndValueForSupplyMaterial(int rowIndex) {
        if (this.kdtEntries.getRow(rowIndex).getCell(TB_IS_SUPPLY_MATERIAL).getValue().toString().equals("true")) {
            this.kdtEntries.getRow(rowIndex).getCell(TB_REQUIRE_DATE).getStyleAttributes().setLocked(false);
            this.kdtEntries.getRow(rowIndex).getCell(TB_REQUIRE_DATE).getStyleAttributes().setBackground(this.requiredColor);
            if (!ScrapTypeEnum.BecauseOfRedundancy.equals((Object)((ScrapTypeEnum)((Object)this.kdtEntries.getRow(rowIndex).getCell(TB_SCRAP_TYPE).getValue())))) {
                this.kdtEntries.getRow(rowIndex).getCell(TB_SUPPLY_REQUIRED_QTY).setValue((Object)((BigDecimal)this.kdtEntries.getRow(rowIndex).getCell(TB_SCRAP_QTY).getValue()));
            }
            this.kdtEntries.getRow(rowIndex).getCell(TB_SUPPLY_REQUIRED_QTY).getStyleAttributes().setLocked(false);
        } else {
            this.kdtEntries.getRow(rowIndex).getCell(TB_REQUIRE_DATE).getStyleAttributes().setLocked(true);
            this.kdtEntries.getRow(rowIndex).getCell(TB_REQUIRE_DATE).getStyleAttributes().setBackground(Color.WHITE);
            this.kdtEntries.getRow(rowIndex).getCell(TB_SUPPLY_REQUIRED_QTY).setValue((Object)SCMClientUtils.ZERO);
            this.kdtEntries.getRow(rowIndex).getCell(TB_SUPPLY_REQUIRED_QTY).getStyleAttributes().setLocked(true);
        }
    }

    private void setDataStatusForSupplyMaterial(int rowIndex) {
        if (this.kdtEntries.getRow(rowIndex).getCell(TB_IS_SUPPLY_MATERIAL).getValue().toString().equals("true")) {
            this.kdtEntries.getRow(rowIndex).getCell(TB_REQUIRE_DATE).getStyleAttributes().setLocked(false);
            this.kdtEntries.getRow(rowIndex).getCell(TB_REQUIRE_DATE).getStyleAttributes().setBackground(this.requiredColor);
            this.kdtEntries.getRow(rowIndex).getCell(TB_SUPPLY_REQUIRED_QTY).getStyleAttributes().setLocked(false);
        } else {
            this.kdtEntries.getRow(rowIndex).getCell(TB_REQUIRE_DATE).getStyleAttributes().setLocked(true);
            this.kdtEntries.getRow(rowIndex).getCell(TB_REQUIRE_DATE).getStyleAttributes().setBackground(Color.WHITE);
            this.kdtEntries.getRow(rowIndex).getCell(TB_SUPPLY_REQUIRED_QTY).getStyleAttributes().setLocked(true);
        }
    }

    private void setLocationForBackWareHouse(int rowIndex) {
        WarehouseInfo warehouse = (WarehouseInfo)this.kdtEntries.getCell(rowIndex, TB_BACK_WAREHOUSE).getValue();
        if (warehouse != null) {
            this.kdtEntries.getCell(rowIndex, TB_BACK_LOCATION).getStyleAttributes().setLocked(!warehouse.isHasLocation());
        }
    }

    private void setQtyForProductQty(int rowIndex) {
        BigDecimal productQty = (BigDecimal)this.kdtEntries.getCell(rowIndex, TB_PRODUCT_QTY).getValue();
        BigDecimal unitQty = (BigDecimal)this.kdtEntries.getCell(rowIndex, TB_UNIT_QTY).getValue();
        if (unitQty != null) {
            BigDecimal resultQty = productQty.multiply(unitQty);
            resultQty = resultQty.setScale(this.qtyPrecision, 4);
            if (this.kdtEntries.getRow(rowIndex).getCell(TB_IS_SUPPLY_MATERIAL).getValue().toString().equals("true")) {
                this.kdtEntries.getCell(rowIndex, TB_SUPPLY_REQUIRED_QTY).setValue((Object)resultQty);
            }
            this.kdtEntries.getCell(rowIndex, TB_SCRAP_QTY).setValue((Object)resultQty);
        }
    }

    private void setEntryMaterialF7() {
        StorageOrgUnitInfo info = (StorageOrgUnitInfo)this.getMainBizOrg().getValue();
        if (info == null) {
            info = (StorageOrgUnitInfo)this.getDefaultMainBizOrg();
        }
        if (null == info) {
            return;
        }
        String id = info.getId().toString();
        String materialPlanQuery = UIHelper.getMaterialPlanQuery((int)this.f7Manager.getF7DisplayMode());
        this.kDBizPromptBoxMaterial = this.getBizMaterialF7(this.kdtEntries.getColumn(TB_MATERIAL), materialPlanQuery);
        EntityViewInfo viewInfo = this.kDBizPromptBoxMaterial.getEntityViewInfo();
        FilterInfo filter = viewInfo.getFilter();
        filter.getFilterItems().add(new FilterItemInfo("STORAGEORGUNIT.id", (Object)id));
        filter.getFilterItems().add(new FilterItemInfo("plan.provideType", (Object)"10910,10920,10930", CompareType.INCLUDE));
        viewInfo.setFilter(filter);
        this.kDBizPromptBoxMaterial.setEntityViewInfo(viewInfo);
    }

    private void setEntryBackWareHouseF7() {
        try {
            StorageOrgUnitInfo storageOrgUnitInfo = (StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue();
            if (storageOrgUnitInfo != null) {
                ((KDBizPromptBox)this.kdtEntries.getColumn(TB_BACK_WAREHOUSE).getEditor().getComponent()).setEntityViewInfo(SCMClientUtils.getWarehouseFilter((StorageOrgUnitInfo)storageOrgUnitInfo, (int)-1));
            }
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
    }

    public void splitOrCopyLine(boolean isCopy) throws Exception {
        if (this.editData == null) {
            return;
        }
        if (this.splitOptConf.getSplitNum() > 10) {
            this.splitOptConf.setSplitNum(10);
        }
        if (this.editData.getBaseStatus().equals((Object)BillBaseStatusEnum.ADD) && this.isBotpBill()) {
            MsgBox.showInfo((Component)((Object)this), (String)InvClientUtils.getResource((String)"ISBOTPBILLANDADDNOSPLIT"));
            return;
        }
        if (this.editData.getBaseStatus().equals((Object)BillBaseStatusEnum.AUDITED)) {
            MsgBox.showInfo((Component)((Object)this), (String)InvClientUtils.getResource((String)"AUDITNOSPLIT"));
            return;
        }
        KDTable detialTable = this.getDetailTable();
        if (detialTable != null) {
            String noSelectStr = "NOSELNOSPLIT";
            if (isCopy) {
                noSelectStr = "NOSELNOCOPY";
            }
            if (detialTable.getRowCount() <= 0 || detialTable.getSelectManager().size() <= 0) {
                MsgBox.showInfo((Component)((Object)this), (String)InvClientUtils.getResource((String)noSelectStr));
                return;
            }
            int topRow = detialTable.getSelectManager().get().getBeginRow();
            int endRow = detialTable.getSelectManager().get().getEndRow();
            if (topRow < 0) {
                topRow = 0;
            }
            if (endRow < 0) {
                endRow = 0;
            }
            if (SCMClientHelper.checkIsTotalLine((IRow)detialTable.getRow(topRow))) {
                MsgBox.showInfo((Component)((Object)this), (String)InvClientUtils.getResource((String)"ISTOTALROW"));
                return;
            }
            this.storeLineFields(detialTable, detialTable.getRow(topRow), null);
            SCMBillEntryBaseInfo entryInfo = (SCMBillEntryBaseInfo)detialTable.getRow(topRow).getUserObject();
            this.storeLineFields(detialTable, detialTable.getRow(topRow), (IObjectValue)entryInfo);
            List detailDataList = null;
            if (!isCopy) {
                detailDataList = this.getSplitLineData(entryInfo, this.splitOptConf, topRow);
            }
            if (detailDataList == null || detailDataList.isEmpty()) {
                return;
            }
            logger.debug((Object)("detailDataList.size:" + detailDataList.size() + ", splitOptConf.getSplitNum():" + this.splitOptConf.getSplitNum()));
            HashMap<String, String> hsEntryRetion = new HashMap<String, String>(0);
            SCMBillEntryBaseInfo detailData = null;
            ArrayList<Integer> rowIndexList = new ArrayList<Integer>();
            rowIndexList.add(new Integer(topRow));
            for (int i = 0; i < detailDataList.size(); ++i) {
                logger.debug((Object)("readu adding a new line:" + i));
                detailData = (SCMBillEntryBaseInfo)detailDataList.get(i);
                IRow row = null;
                if (this.splitOptConf.getSplitPos() == 0) {
                    endRow = topRow + i + 1;
                    row = detialTable.addRow(endRow);
                } else {
                    endRow = detialTable.getRowCount();
                    row = detialTable.addRow(endRow);
                }
                rowIndexList.add(new Integer(endRow));
                this.loadLineFields(detialTable, row, (IObjectValue)detailData);
                this.storeLineFields(detialTable, row, (IObjectValue)detailData);
                logger.debug((Object)("added a new line, row index:" + endRow));
                this.isCoay = false;
                if (entryInfo.getSourceBillEntryId() == null || this.editData.getId() == null || detailData.getId() == null || entryInfo.getId() == null || entryInfo.get("isInitBill") != null && ((Boolean)entryInfo.get("isInitBill")).booleanValue()) continue;
                hsEntryRetion.put(detailData.getId().toString(), entryInfo.getId().toString());
            }
            if (!isCopy && this.splitOptConf.getSplitType() == 0) {
                this.splitQty(rowIndexList, this.splitOptConf.getSplitNum());
            }
            this.setDataStatusForSplit(rowIndexList);
            if (this.editData.getId() != null && hsEntryRetion.size() > 0) {
                ISCMBillCommonFacade iScmBillCommonFacade = SCMBillCommonFacadeFactory.getRemoteInstance();
                iScmBillCommonFacade.saveNewEentyReation(this.editData.getId().toString(), hsEntryRetion);
            }
        }
    }

    public void actionSplitLine_actionPerformed(ActionEvent e) throws Exception {
        this.kdtEntries.getEditManager().stopEditing();
        super.actionSplitLine_actionPerformed(e);
        this.kdtEntries.setFocusable(true);
    }

    private void setDataStatusForSplit(List rowIndexList) throws EASBizException, BOSException {
        int index = (Integer)rowIndexList.get(0);
        String scrapQtyF = this.kdtEntries.getCell(index, TB_SCRAP_QTY).getStyleAttributes().getNumberFormat();
        String productQtyF = this.kdtEntries.getCell(index, TB_PRODUCT_QTY).getStyleAttributes().getNumberFormat();
        String supplyRequiredQtyF = this.kdtEntries.getCell(index, TB_SUPPLY_REQUIRED_QTY).getStyleAttributes().getNumberFormat();
        ICellEditor scrapQtyE = this.kdtEntries.getCell(index, TB_SCRAP_QTY).getEditor();
        ICellEditor productQtyE = this.kdtEntries.getCell(index, TB_PRODUCT_QTY).getEditor();
        ICellEditor supplyRequiredQtyE = this.kdtEntries.getCell(index, TB_SUPPLY_REQUIRED_QTY).getEditor();
        StyleAttributes lotStyle = this.kdtEntries.getCell(index, TB_LOT).getStyleAttributes();
        for (int i = 1; i < rowIndexList.size(); ++i) {
            index = (Integer)rowIndexList.get(i);
            this.kdtEntries.getCell(index, TB_SCRAP_QTY).getStyleAttributes().setNumberFormat(scrapQtyF);
            this.kdtEntries.getCell(index, TB_PRODUCT_QTY).getStyleAttributes().setNumberFormat(productQtyF);
            this.kdtEntries.getCell(index, TB_SUPPLY_REQUIRED_QTY).getStyleAttributes().setNumberFormat(supplyRequiredQtyF);
            this.kdtEntries.getCell(index, TB_SCRAP_QTY).setEditor(scrapQtyE);
            this.kdtEntries.getCell(index, TB_PRODUCT_QTY).setEditor(productQtyE);
            this.kdtEntries.getCell(index, TB_SUPPLY_REQUIRED_QTY).setEditor(supplyRequiredQtyE);
            if (this.kdtEntries.getCell(index, TB_OPERATION_NUMBER).getValue() == null || this.kdtEntries.getCell(index, TB_OPERATION_NUMBER).getValue().toString().equals("0")) {
                this.kdtEntries.getCell(index, TB_OPERATION_NUMBER).setValue(null);
            }
            this.kdtEntries.getCell(index, TB_LOT).setStyleAttributes(lotStyle);
            MaterialProvideTypeEnum provideType = (MaterialProvideTypeEnum)this.kdtEntries.getCell(index, TB_PROVIDE).getValue();
            if (ScrapTypeEnum.BecauseOfRedundancy.equals(this.kdtEntries.getCell(index, TB_SCRAP_TYPE).getValue())) {
                this.kdtEntries.getCell(index, TB_BACK_WAREHOUSE).getStyleAttributes().setLocked(true);
                this.kdtEntries.getCell(index, TB_BACK_LOCATION).getStyleAttributes().setLocked(true);
                this.kdtEntries.getCell(index, TB_PRODUCT_QTY).getStyleAttributes().setLocked(true);
                this.kdtEntries.getCell(index, TB_SCRAP_QTY).getStyleAttributes().setLocked(true);
                this.kdtEntries.getCell(index, TB_IS_SUPPLY_MATERIAL).getStyleAttributes().setLocked(true);
            } else {
                this.kdtEntries.getCell(index, TB_BACK_WAREHOUSE).getStyleAttributes().setLocked(false);
                this.setLocationForBackWareHouse(index);
                this.kdtEntries.getCell(index, TB_PRODUCT_QTY).getStyleAttributes().setLocked(false);
                this.kdtEntries.getCell(index, TB_SCRAP_QTY).getStyleAttributes().setLocked(false);
                if (MaterialProvideTypeEnum.CURRENTORGPROVIDE.equals((Object)provideType) || MaterialProvideTypeEnum.SPANORGPROVIDE.equals((Object)provideType) || MaterialProvideTypeEnum.SPANORGATTEMPERPROVIDE.equals((Object)provideType)) {
                    this.kdtEntries.getCell(index, TB_IS_SUPPLY_MATERIAL).getStyleAttributes().setLocked(false);
                } else {
                    this.kdtEntries.getCell(index, TB_IS_SUPPLY_MATERIAL).getStyleAttributes().setLocked(true);
                }
            }
            this.setDataStatusForSupplyMaterial(index);
        }
        this.setMaterial();
        this.setScrapType();
    }

    private void onAdminOrgChanged(DataChangeEvent eventObj) {
        int curRowCnt = this.kdtEntries.getRowCount();
        if (curRowCnt <= 0) {
            return;
        }
        int confirm = MsgBox.showConfirm2((String)this.getScrapOrderResource("ADMINORG_CHANGED_CLEARROWS"));
        if (confirm == 2 || confirm == 1) {
            this.prmtAdminOrgUnit.removeDataChangeListener(this.prmtadminOrgUnitDataChanged);
            this.prmtAdminOrgUnit.setValue(eventObj.getOldValue());
            this.prmtAdminOrgUnit.addDataChangeListener(this.prmtadminOrgUnitDataChanged);
        } else {
            this.kdtEntries.removeRows();
        }
    }

    protected void doBeforeSave(ActionEvent e) throws Exception {
        super.doBeforeSave(e);
        if (this.editData.getId() != null && !this.editData.getId().toString().equals("")) {
            String srcBosType = new ManufactureOrderInfo().getBOSType().toString();
            BOTRelationFactory.getRemoteInstance().removeRelationByDestObjId(this.editData.getId().toString(), srcBosType);
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.remove(new SelectorItemInfo("entries.unit.*"));
        sic.add(new SelectorItemInfo("entries.unit.id"));
        sic.add(new SelectorItemInfo("entries.unit.number"));
        sic.add(new SelectorItemInfo("entries.unit.name"));
        sic.remove(new SelectorItemInfo("entries.material.*"));
        sic.add(new SelectorItemInfo("entries.material.id"));
        sic.add(new SelectorItemInfo("entries.material.number"));
        sic.add(new SelectorItemInfo("entries.material.name"));
        sic.remove(new SelectorItemInfo("entries.backWarehouse.*"));
        sic.add(new SelectorItemInfo("entries.backWarehouse.id"));
        sic.add(new SelectorItemInfo("entries.backWarehouse.number"));
        sic.add(new SelectorItemInfo("entries.backWarehouse.name"));
        sic.remove(new SelectorItemInfo("entries.backLocation.*"));
        sic.add(new SelectorItemInfo("entries.backLocation.id"));
        sic.add(new SelectorItemInfo("entries.backLocation.number"));
        sic.add(new SelectorItemInfo("entries.backLocation.name"));
        sic.remove(new SelectorItemInfo("entries.backLocation.*"));
        sic.add(new SelectorItemInfo("entries.backLocation.id"));
        sic.add(new SelectorItemInfo("entries.backLocation.number"));
        sic.add(new SelectorItemInfo("entries.backLocation.name"));
        sic.remove(new SelectorItemInfo("entries.reasonCode.*"));
        sic.add(new SelectorItemInfo("entries.reasonCode.id"));
        sic.add(new SelectorItemInfo("entries.reasonCode.number"));
        sic.add(new SelectorItemInfo("entries.reasonCode.name"));
        sic.remove(new SelectorItemInfo("entries.operation.*"));
        sic.add(new SelectorItemInfo("entries.operation.id"));
        sic.add(new SelectorItemInfo("entries.operation.number"));
        sic.add(new SelectorItemInfo("entries.operation.name"));
        sic.remove(new SelectorItemInfo("entries.operation.*"));
        sic.add(new SelectorItemInfo("entries.storageOrgUnit.id"));
        sic.add(new SelectorItemInfo("entries.storageOrgUnit.number"));
        sic.add(new SelectorItemInfo("entries.storageOrgUnit.name"));
        sic.remove(new SelectorItemInfo("entries.warehouse.*"));
        sic.add(new SelectorItemInfo("entries.warehouse.id"));
        sic.add(new SelectorItemInfo("entries.warehouse.number"));
        sic.add(new SelectorItemInfo("entries.warehouse.name"));
        sic.remove(new SelectorItemInfo("entries.productUnit.*"));
        sic.add(new SelectorItemInfo("entries.productUnit.id"));
        sic.add(new SelectorItemInfo("entries.productUnit.number"));
        sic.add(new SelectorItemInfo("entries.productUnit.name"));
        sic.remove(new SelectorItemInfo("entries.product.*"));
        sic.add(new SelectorItemInfo("entries.product.id"));
        sic.add(new SelectorItemInfo("entries.product.number"));
        sic.add(new SelectorItemInfo("entries.product.name"));
        sic.remove(new SelectorItemInfo("entries.costObject.*"));
        sic.add(new SelectorItemInfo("entries.costObject.id"));
        sic.add(new SelectorItemInfo("entries.costObject.number"));
        sic.add(new SelectorItemInfo("entries.costObject.name"));
        sic.remove(new SelectorItemInfo("entries.project.*"));
        sic.add(new SelectorItemInfo("entries.project.id"));
        sic.add(new SelectorItemInfo("entries.project.number"));
        sic.add(new SelectorItemInfo("entries.project.name"));
        sic.remove(new SelectorItemInfo("entries.trackNumber.*"));
        sic.add(new SelectorItemInfo("entries.trackNumber.id"));
        sic.add(new SelectorItemInfo("entries.trackNumber.number"));
        sic.add(new SelectorItemInfo("entries.trackNumber.name"));
        sic.remove(new SelectorItemInfo("entries.sourceBillType.*"));
        sic.add(new SelectorItemInfo("entries.sourceBillType.id"));
        sic.add(new SelectorItemInfo("entries.sourceBillType.number"));
        sic.add(new SelectorItemInfo("entries.sourceBillType.name"));
        sic.remove(new SelectorItemInfo("entries.processOrgUnit.*"));
        sic.add(new SelectorItemInfo("entries.processOrgUnit.id"));
        sic.add(new SelectorItemInfo("entries.processOrgUnit.number"));
        sic.add(new SelectorItemInfo("entries.processOrgUnit.name"));
        sic.remove(new SelectorItemInfo("entries.processDept.*"));
        sic.add(new SelectorItemInfo("entries.processDept.id"));
        sic.add(new SelectorItemInfo("entries.processDept.number"));
        sic.add(new SelectorItemInfo("entries.processDept.name"));
        sic.remove(new SelectorItemInfo("entries.pickDept.*"));
        sic.add(new SelectorItemInfo("entries.pickDept.id"));
        sic.add(new SelectorItemInfo("entries.pickDept.number"));
        sic.add(new SelectorItemInfo("entries.pickDept.name"));
        sic.remove(new SelectorItemInfo("entries.technic.*"));
        sic.add(new SelectorItemInfo("entries.technic.id"));
        sic.add(new SelectorItemInfo("entries.technic.number"));
        sic.add(new SelectorItemInfo("entries.technic.name"));
        sic.remove(new SelectorItemInfo("creator.*"));
        sic.add(new SelectorItemInfo("creator.id"));
        sic.add(new SelectorItemInfo("creator.number"));
        sic.add(new SelectorItemInfo("creator.name"));
        sic.remove(new SelectorItemInfo("lastUpdateUser.*"));
        sic.add(new SelectorItemInfo("lastUpdateUser.id"));
        sic.add(new SelectorItemInfo("lastUpdateUser.number"));
        sic.add(new SelectorItemInfo("lastUpdateUser.name"));
        sic.remove(new SelectorItemInfo("auditor.*"));
        sic.add(new SelectorItemInfo("auditor.id"));
        sic.add(new SelectorItemInfo("auditor.number"));
        sic.add(new SelectorItemInfo("auditor.name"));
        sic.remove(new SelectorItemInfo("sourceBillType.*"));
        sic.add(new SelectorItemInfo("sourceBillType.id"));
        sic.add(new SelectorItemInfo("sourceBillType.number"));
        sic.add(new SelectorItemInfo("sourceBillType.name"));
        sic.remove(new SelectorItemInfo("storageOrgUnit.*"));
        sic.add(new SelectorItemInfo("storageOrgUnit.id"));
        sic.add(new SelectorItemInfo("storageOrgUnit.number"));
        sic.add(new SelectorItemInfo("storageOrgUnit.name"));
        sic.add(new SelectorItemInfo("storageOrgUnit.CU.id"));
        sic.add(new SelectorItemInfo("storageOrgUnit.CU.name"));
        sic.add(new SelectorItemInfo("storageOrgUnit.CU.number"));
        sic.remove(new SelectorItemInfo("adminOrgUnit.*"));
        sic.add(new SelectorItemInfo("adminOrgUnit.id"));
        sic.add(new SelectorItemInfo("adminOrgUnit.number"));
        sic.add(new SelectorItemInfo("adminOrgUnit.name"));
        return sic;
    }
}

