/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.mo.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.base.commonquery.client.IProcessor;
import com.kingdee.eas.base.commonquery.client.IPromptBoxFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.common.client.KDTableUtils;
import com.kingdee.eas.mm.common.client.MMUtils;
import com.kingdee.eas.mm.common.util.EditTableUtil;
import com.kingdee.eas.mm.mo.IMaterialTransactionPlatformFacade;
import com.kingdee.eas.mm.mo.ManufactureOrderCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderInfo;
import com.kingdee.eas.mm.mo.MaterialTransactionPlatformFacadeFactory;
import com.kingdee.eas.mm.mo.client.AbstractSelectMOListUI;
import com.kingdee.eas.mm.mo.client.MaterialTransactionPlatformFilterUI;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMGroupFacadeFactory;
import com.kingdee.eas.scm.common.client.SCMBillFilterUI;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.client.SCMCommonProcessor;
import com.kingdee.eas.scm.common.client.SCMPromptBoxFactory;
import com.kingdee.eas.scm.common.loadmass.SCMEntryDataVO;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class SelectMOListUI
extends AbstractSelectMOListUI {
    private static final Logger logger = CoreUIObject.getLogger(SelectMOListUI.class);
    private String moTable = null;
    private String stockTable = null;
    private static final String[] KDT_DATES = new String[]{"planBeginDate", "planEndDate"};
    protected MaterialTransactionPlatformFilterUI conditionPanel = null;
    public CommonQueryDialog commonQueryDialog = null;
    private int FormulaRule = 0;
    private SCMEntryDataVO voResult = null;
    private static final String[] STK_QTYS = new String[]{"qty"};
    private String ORGID = "";
    protected IMetaDataPK mainQueryPK;
    private boolean isCancel = true;
    private String BILL_TYPE = "";
    private StorageOrgUnitInfo storageOrgUnitInfo;
    private FilterInfo paramFilter;
    private Boolean isGetMaterialObject;
    private boolean isOrder;
    private CommonQueryDialog dialog = null;
    private Context ctx = null;
    private boolean isOK = false;
    private ManufactureOrderCollection cocn;
    private List moList;
    private IRowSet moRowSet;
    private IRowSet moStockRowSet;

    public SelectMOListUI() throws Exception {
        this.kdtable.checkParsed();
        MMUtils.sortTable((KDTable)this.kdtable);
    }

    public void onShow() throws Exception {
        super.onShow();
        KDTableUtils.setDefaultFreezeCol((KDTable)this.kdtable, (int)(this.kdtable.getColumnIndex("number") + 1));
        EditTableUtil.formatColDate((KDTable)this.kdtable, (String[])KDT_DATES);
    }

    public String getBILL_TYPE() {
        return this.BILL_TYPE;
    }

    public void setBILL_TYPE(String bill_type) {
        this.BILL_TYPE = bill_type;
    }

    public IRowSet getMoStockRowSet() {
        return this.moStockRowSet;
    }

    public void setMoStockRowSet(IRowSet moStockRowSet) {
        this.moStockRowSet = moStockRowSet;
    }

    public List getMoList() {
        return this.moList;
    }

    public IRowSet getMoRowSet() {
        return this.moRowSet;
    }

    public void setMoRowSet(IRowSet moRowSet) {
        this.moRowSet = moRowSet;
    }

    public void setMoList(List moList) {
        this.moList = moList;
    }

    public String getMoTable() {
        return this.moTable;
    }

    public String getStockTable() {
        return this.stockTable;
    }

    public void setStockTable(String stockTable) {
        this.stockTable = stockTable;
    }

    public void setMoTable(String moTable) {
        this.moTable = moTable;
    }

    public ManufactureOrderCollection getCocn() {
        return this.cocn;
    }

    public void setCocn(ManufactureOrderCollection cocn) {
        this.cocn = cocn;
    }

    public boolean isCancel() {
        return this.isCancel;
    }

    public void setCancel(boolean isCancel) {
        this.isCancel = isCancel;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.btnOK.setEnabled(false);
        this.kdtable.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                int[] selectRowIndexs = KDTableUtil.getSelectedRows((KDTable)SelectMOListUI.this.kdtable);
                if (selectRowIndexs != null && selectRowIndexs.length > 0 && selectRowIndexs[0] >= 0) {
                    SelectMOListUI.this.btnOK.setEnabled(true);
                }
            }
        });
        Map uictx = this.getUIContext();
        this.isOrder = (Boolean)uictx.get("isOrder");
        this.FormulaRule = (Integer)uictx.get("FormulaRule");
        this.ORGID = (String)uictx.get("orgId");
        this.isGetMaterialObject = (Boolean)uictx.get("getMaterial");
        this.storageOrgUnitInfo = (StorageOrgUnitInfo)uictx.get("storageOrgUnitInfo");
        this.dialog = (CommonQueryDialog)uictx.get("dialog");
        this.ctx = (Context)uictx.get("context");
        this.paramFilter = (FilterInfo)uictx.get("paramFilter");
        if (uictx.get("mococn") != null) {
            if (this.isOrder) {
                IRowSet moRowSet = (IRowSet)uictx.get("mococn");
                this.moTable = (String)uictx.get("moTable");
                this.stockTable = (String)uictx.get("stockTable");
                this.setMoRowSet(moRowSet);
                this.bindingDataForRowSet();
            } else {
                List mcocn = (List)uictx.get("mococn");
                this.setMoList(mcocn);
                this.bindingData();
                this.setpersion();
            }
        }
        this.kdtable.getSelectManager().setSelectMode(10);
        this.kdtable.setRefresh(true);
    }

    @Override
    public void actionOK_actionPerformed(ActionEvent e) throws Exception {
        ArrayList list = new ArrayList();
        int[] index = KDTableUtil.getSelectedRows((KDTable)this.kdtable);
        if (this.isOrder) {
            Map moAndStockResult;
            this.BILL_TYPE = "manufactureOrder";
            HashSet<String> listSet = new HashSet<String>();
            FilterInfo filter = new FilterInfo();
            if (index.length != this.kdtable.getRowCount()) {
                for (int i = 0; i < index.length; ++i) {
                    if (this.kdtable.getRow(index[i]).getCell("id").getValue() == null) continue;
                    listSet.add(this.kdtable.getRow(index[i]).getCell("id").getValue().toString());
                }
                filter.getFilterItems().add(new FilterItemInfo("id", listSet, CompareType.INCLUDE));
            }
            IMaterialTransactionPlatformFacade bizface = MaterialTransactionPlatformFacadeFactory.getRemoteInstanceWithObjectContext(this.ctx);
            if (!StringUtils.isEmpty((String)this.stockTable)) {
                bizface.releaseTempTable(this.stockTable);
            }
            if ((moAndStockResult = bizface.queryMoStockByFilter(filter, this.ORGID, this.isGetMaterialObject, this.moTable)) != null) {
                IRowSet rs = (IRowSet)moAndStockResult.get("moResult");
                IRowSet rsStock = (IRowSet)moAndStockResult.get("moStockResult");
                this.moTable = (String)moAndStockResult.get("moTable");
                this.stockTable = (String)moAndStockResult.get("moStockTable");
                this.setMoRowSet(rs);
                this.setMoStockRowSet(rsStock);
                this.setBILL_TYPE(this.BILL_TYPE);
                this.setCancel(false);
                this.isOK = true;
                this.actionExitCurrent_actionPerformed(e);
            } else {
                MsgBox.showInfo((String)this.getResource("PickingMaterialIsNull"));
                SysUtil.abort();
            }
        } else {
            this.BILL_TYPE = "disTaskDispatch";
            HashSet<String> dispatchListSet = new HashSet<String>();
            for (int i = 0; i < index.length; ++i) {
                if (this.kdtable.getRow(index[i]).getCell("dispatchID").getValue() != null) {
                    dispatchListSet.add(this.kdtable.getRow(index[i]).getCell("dispatchID").getValue().toString());
                }
                List mococn = new ArrayList();
                this.ctx.put((Object)"isNeedStock", (Object)Boolean.TRUE);
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", dispatchListSet, CompareType.INCLUDE));
                mococn = MaterialTransactionPlatformFacadeFactory.getRemoteInstanceWithObjectContext(this.ctx).queryTaskDispBillByFilter(filter, this.ORGID, null);
                if (mococn != null && mococn.size() > 0) {
                    this.setMoList(mococn);
                    this.setBILL_TYPE(this.BILL_TYPE);
                    this.setCancel(false);
                    this.isOK = true;
                    this.actionExitCurrent_actionPerformed(e);
                    continue;
                }
                MsgBox.showInfo((String)this.getResource("PickingMaterialIsNull"));
                SysUtil.abort();
            }
        }
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.setCancel(true);
        this.actionExitCurrent_actionPerformed(e);
    }

    private void bindingData() {
        this.kdtable.removeRows();
        if (this.getMoList() != null && this.getMoList().size() > 0) {
            List mcll = this.getMoList();
            for (int i = 0; i < this.moList.size(); ++i) {
                ManufactureOrderInfo moinfo = (ManufactureOrderInfo)mcll.get(i);
                if (moinfo.getStorageOrgUnit() != null && !this.ORGID.equals(moinfo.getStorageOrgUnit().getId().toString())) continue;
                if (!moinfo.getBaseStatus().equals((Object)BillBaseStatusEnum.RELEASED) && !moinfo.getBaseStatus().equals((Object)BillBaseStatusEnum.COMPLETE)) {
                    mcll.remove(moinfo);
                    --i;
                    continue;
                }
                IRow row = this.kdtable.addRow();
                row.getCell("id").setValue((Object)moinfo.getId());
                if (moinfo.getStorageOrgUnit() != null) {
                    row.getCell("storageOrgUnit").setValue((Object)moinfo.getStorageOrgUnit().getName());
                }
                row.getCell("number").setValue((Object)moinfo.getNumber());
                if (moinfo.getProject() != null) {
                    row.getCell("projectNumber").setValue((Object)moinfo.getProject().getNumber());
                }
                if (moinfo.getTrackNumber() != null) {
                    row.getCell("trackNumber").setValue((Object)moinfo.getTrackNumber().getNumber());
                }
                if (moinfo.getBizType() != null) {
                    row.getCell("bizType").setValue((Object)moinfo.getBizType().getName());
                }
                if (moinfo.getMaterial() != null) {
                    row.getCell("material.id").setValue((Object)moinfo.getMaterial().getId().toString());
                    row.getCell("material.number").setValue((Object)moinfo.getMaterial().getNumber());
                    row.getCell("material.name").setValue((Object)moinfo.getMaterial().getName());
                    row.getCell("material.model").setValue((Object)moinfo.getMaterial().getModel());
                }
                if (moinfo.getUnit() != null) {
                    row.getCell("unit").setValue((Object)moinfo.getUnit().getName());
                    row.getCell("unit.id").setValue((Object)moinfo.getUnit().getId().toString());
                }
                row.getCell("basestatus").setValue((Object)moinfo.getBaseStatus());
                row.getCell("qty").setValue((Object)moinfo.getQty());
                if (moinfo.getAdminOrgUnit() != null) {
                    row.getCell("adminOrgUnit").setValue((Object)moinfo.getAdminOrgUnit().getName());
                }
                if (moinfo.getPlanBeginDate() != null) {
                    row.getCell("planBeginDate").setValue((Object)moinfo.getPlanBeginDate());
                }
                if (moinfo.getPlanEndDate() != null) {
                    row.getCell("planEndDate").setValue((Object)moinfo.getPlanEndDate());
                }
                if (moinfo.get("dispatchID") != null) {
                    row.getCell("dispatchID").setValue(moinfo.get("dispatchID"));
                }
                row.getCell("number").setValue((Object)moinfo.getNumber());
            }
        } else {
            this.btnOK.setEnabled(false);
        }
    }

    private void bindingDataForRowSet() throws SQLException {
        this.kdtable.removeRows();
        if (this.getMoRowSet() != null && this.getMoRowSet().size() > 0) {
            IRowSet mcll = this.getMoRowSet();
            while (mcll.next()) {
                IRow row = this.kdtable.addRow();
                row.getCell("id").setValue((Object)mcll.getString("FID"));
                row.getCell("storageOrgUnit").setValue((Object)mcll.getString("FOrgUnitName"));
                row.getCell("number").setValue((Object)mcll.getString("FNumber"));
                row.getCell("projectNumber").setValue((Object)mcll.getString("FProjectNumber"));
                row.getCell("trackNumber").setValue((Object)mcll.getString("FTrackNumber"));
                row.getCell("bizType").setValue((Object)mcll.getString("FBizTypeName"));
                row.getCell("material.id").setValue((Object)mcll.getString("FMaterialID"));
                row.getCell("material.number").setValue((Object)mcll.getString("FMaterialNumber"));
                row.getCell("material.name").setValue((Object)mcll.getString("FMaterialName"));
                row.getCell("material.model").setValue((Object)mcll.getString("FMaterialModel"));
                row.getCell("unit").setValue((Object)mcll.getString("FUnitName"));
                row.getCell("unit.id").setValue((Object)mcll.getString("FUnitId"));
                row.getCell("basestatus").setValue((Object)BillBaseStatusEnum.getEnum((int)mcll.getInt("FBasestatus")));
                row.getCell("qty").setValue((Object)mcll.getBigDecimal("FQty"));
                row.getCell("adminOrgUnit").setValue((Object)mcll.getString("FAdminOrgName"));
                row.getCell("planBeginDate").setValue((Object)mcll.getDate("FPlanBeginDate"));
                row.getCell("planEndDate").setValue((Object)mcll.getDate("FPlanEndDate"));
            }
        } else {
            this.btnOK.setEnabled(false);
        }
    }

    @Override
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        if (this.dialog == null) {
            this.dialog = this.initCommonQueryDialog();
        }
        this.dialog.show();
        EntityViewInfo entityViewInfo = this.dialog.getEntityViewInfoResult();
        if (entityViewInfo.getFilter() == null) {
            this.abort();
        }
        IMaterialTransactionPlatformFacade bizface = MaterialTransactionPlatformFacadeFactory.getRemoteInstanceWithObjectContext(this.ctx);
        if (!StringUtils.isEmpty((String)this.moTable)) {
            bizface.releaseTempTable(this.moTable);
        }
        entityViewInfo = this.removeBillTypeFilter(entityViewInfo);
        List mococn = new ArrayList();
        this.ctx.put((Object)"isNeedStock", (Object)Boolean.FALSE);
        if (this.isOrder) {
            this.BILL_TYPE = "manufactureOrder";
            Map moResult = bizface.queryMoSqlByFilter(entityViewInfo.getFilter(), this.ORGID, this.isGetMaterialObject, this.paramFilter);
            if (moResult != null) {
                IRowSet rs = (IRowSet)moResult.get("moResult");
                this.moTable = (String)moResult.get("moTable");
                this.setMoRowSet(rs);
            }
            this.bindingDataForRowSet();
        } else {
            this.BILL_TYPE = "disTaskDispatch";
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)new Integer(4)));
            entityViewInfo.getFilter().mergeFilter(filter, "and");
            mococn = bizface.queryTaskDispBillByFilter(entityViewInfo.getFilter(), this.ORGID, null);
            if (mococn != null) {
                this.setMoList(mococn);
            }
            this.bindingData();
        }
    }

    private Object isWhitchBill(EntityViewInfo entityViewInfo) {
        FilterInfo filter = entityViewInfo.getFilter();
        FilterItemCollection items = filter.getFilterItems();
        Object billType = null;
        for (int index = 0; index < items.size(); ++index) {
            FilterItemInfo filterInfo = items.get(index);
            if (!filterInfo.getPropertyName().equals("billType")) continue;
            billType = filterInfo.getCompareValue();
        }
        return billType;
    }

    private EntityViewInfo removeBillTypeFilter(EntityViewInfo entityViewInfo) {
        FilterInfo filter = entityViewInfo.getFilter();
        FilterItemCollection items = filter.getFilterItems();
        for (int index = items.size() - 1; index >= 0; --index) {
            FilterItemInfo filterInfo = items.get(index);
            if (filterInfo.getPropertyName().equals("billType")) {
                if (filterInfo.getCompareValue().toString().equals("20") && this.FormulaRule != 0) {
                    MsgBox.showInfo((String)this.getResource("TDBILL_CANNOTQUERY"));
                    SysUtil.abort();
                }
                if (filterInfo.getCompareValue().toString().equals("20") && "false".equals(this.isGetMaterialObject.toString())) {
                    MsgBox.showInfo((String)this.getResource("TDBILL_CANNOTREJECT"));
                    SysUtil.abort();
                }
                filterInfo.setPropertyName("number");
                filterInfo.setCompareValue(null);
                filterInfo.setCompareType(CompareType.NOTEQUALS);
                break;
            }
            if (!filterInfo.getPropertyName().equals("storageOrgUnit.number") || filterInfo.getCompareValue().toString().equals(this.storageOrgUnitInfo.getNumber())) continue;
            MsgBox.showInfo((String)this.getResource("STORAGE_ORG_DIFFERENT"));
            SysUtil.abort();
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        return view;
    }

    public String getResource(String key) {
        return EASResource.getString((String)"com.kingdee.eas.mm.mo.MaterialTransactionPlatformResource", (String)key);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    protected CommonQueryDialog initCommonQueryDialog() throws Exception {
        if (this.commonQueryDialog == null) {
            this.commonQueryDialog = this.initMyCommonQueryDialog();
            this.commonQueryDialog.setWidth(450);
            this.commonQueryDialog.setHeight(320);
            CustomerQueryPanel queryPanel = this.getFilterUI();
            try {
                SCMPromptBoxFactory scmF7Factory = new SCMPromptBoxFactory(queryPanel, this.getMainBizOrgType());
                this.commonQueryDialog.setPromptBoxFactory((IPromptBoxFactory)scmF7Factory);
                this.commonQueryDialog.setProcessor((IProcessor)new SCMCommonProcessor());
                this.commonQueryDialog.addUserPanel((KDPanel)queryPanel);
                try {
                    SCMBillFilterUI filterUI = (SCMBillFilterUI)queryPanel;
                    filterUI.setContextObject((Object)new Integer(this.FormulaRule));
                }
                catch (Exception e) {
                    this.handleException(e);
                }
            }
            catch (Exception e) {
                this.handUIException(e);
                SysUtil.abort();
            }
        }
        return this.commonQueryDialog;
    }

    protected CustomerQueryPanel getFilterUI() throws Exception {
        this.conditionPanel = new MaterialTransactionPlatformFilterUI(this.isGetMaterialObject.toString(), this.storageOrgUnitInfo);
        return this.conditionPanel;
    }

    protected CommonQueryDialog initMyCommonQueryDialog() {
        CommonQueryDialog dialog = new CommonQueryDialog();
        if (this.getUIWindow() == null) {
            dialog.setOwner((Component)this.getUIContext().get("OwnerWindow"));
        } else {
            dialog.setOwner((Component)((Object)this));
        }
        this.mainQueryPK = new MetaDataPK("com.kingdee.eas.base.message", "MsgQuery");
        dialog.setQueryObjectPK(this.mainQueryPK);
        dialog.setParentUIClassName("com.kingdee.eas.mm.mo.client.MaterialTransactionPlatformUI");
        dialog.setTitle(this.getUITitle() + " - " + EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Query_Filter"));
        dialog.setShowSorter(false);
        dialog.setShowFilter(false);
        return dialog;
    }

    protected boolean checkBeforeWindowClosing() {
        if (this.isOK) {
            this.setCancel(false);
        } else {
            this.setCancel(true);
        }
        this.isOK = false;
        this.kdtable.removeRows();
        return super.checkBeforeWindowClosing();
    }

    private void setpersion() throws EASBizException, BOSException {
        if (this.kdtable.getRowCount() == 0) {
            return;
        }
        MaterialInfo[] materials = new MaterialInfo[this.kdtable.getRowCount()];
        MeasureUnitInfo[] units = new MeasureUnitInfo[this.kdtable.getRowCount()];
        for (int i = 0; i < this.kdtable.getRowCount(); ++i) {
            String mId = this.kdtable.getRow(i).getCell("material.id").getValue().toString();
            String uId = this.kdtable.getRow(i).getCell("unit.id").getValue().toString();
            MaterialInfo materialInfo = new MaterialInfo();
            MeasureUnitInfo measureUnitInfo = new MeasureUnitInfo();
            materialInfo.setId(BOSUuid.read((String)mId));
            measureUnitInfo.setId(BOSUuid.read((String)uId));
            materials[i] = materialInfo;
            units[i] = measureUnitInfo;
        }
        SCMEntryDataVO vo = new SCMEntryDataVO();
        vo.setMaterialInfos(materials);
        vo.setMeasureUnitInfos(units);
        this.voResult = SCMGroupFacadeFactory.getRemoteInstance().loadMmuPrecision(vo);
        for (int i = 0; i < this.kdtable.getRowCount(); ++i) {
            SCMClientUtils.changeTableColPrecision((Map)this.voResult.getMmuPrecisions(), (MaterialInfo)materials[i], (MeasureUnitInfo)units[i], (KDTable)this.kdtable, (String[])STK_QTYS, (int)i);
        }
    }
}

