/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.mo.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSortManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.backport.Collections;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.base.commonquery.client.IProcessor;
import com.kingdee.eas.base.commonquery.client.IPromptBoxFactory;
import com.kingdee.eas.basedata.master.material.MaterialIssueModeEnum;
import com.kingdee.eas.basedata.master.material.MaterialProvideTypeEnum;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.mm.common.ITotalLine;
import com.kingdee.eas.mm.common.client.KDTableUtils;
import com.kingdee.eas.mm.common.client.MMUtils;
import com.kingdee.eas.mm.common.util.EditTableUtil;
import com.kingdee.eas.mm.common.util.TotalLineHandler;
import com.kingdee.eas.mm.mo.IStockTransactionEditFacade;
import com.kingdee.eas.mm.mo.ManufactureOrderCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderFactory;
import com.kingdee.eas.mm.mo.ManufactureOrderInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderStockCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderStockInfo;
import com.kingdee.eas.mm.mo.STCalcParamInfo;
import com.kingdee.eas.mm.mo.STGroupEnum;
import com.kingdee.eas.mm.mo.STRuleEnum;
import com.kingdee.eas.mm.mo.STSourceInfo;
import com.kingdee.eas.mm.mo.STStockInfo;
import com.kingdee.eas.mm.mo.STStockTotalInfo;
import com.kingdee.eas.mm.mo.StockTransactionEditFacadeFactory;
import com.kingdee.eas.mm.mo.client.AbstractStockTransactionEditUI;
import com.kingdee.eas.mm.mo.client.StockTransactionFilterUI;
import com.kingdee.eas.mm.mo.client.StockTransactionParamUI;
import com.kingdee.eas.mm.mo.client.StockTransactionSourceUI;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.client.SCMCommonProcessor;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.scm.common.client.SCMPromptBoxFactory;
import com.kingdee.eas.scm.common.service.SCMServiceFactory;
import com.kingdee.eas.scm.common.util.SortUtil;
import com.kingdee.eas.scm.im.inv.StockTransferBillCollection;
import com.kingdee.eas.scm.im.inv.StockTransferBillEntryCollection;
import com.kingdee.eas.scm.im.inv.StockTransferBillEntryInfo;
import com.kingdee.eas.scm.im.inv.StockTransferBillInfo;
import com.kingdee.eas.scm.im.inv.TransferOrderBillCollection;
import com.kingdee.eas.scm.im.inv.TransferOrderBillEntryCollection;
import com.kingdee.eas.scm.im.inv.TransferOrderBillEntryInfo;
import com.kingdee.eas.scm.im.inv.TransferOrderBillInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class StockTransactionEditUI
extends AbstractStockTransactionEditUI
implements ITotalLine {
    private static final long serialVersionUID = -7104552598128835162L;
    private static final Logger logger = CoreUIObject.getLogger(StockTransactionEditUI.class);
    private static final BigDecimal ZERO = SysConstant.BIGZERO;
    private static final BigDecimal MAX_VALUE = new BigDecimal("9999999999999.99999999");
    private IUIWindow stockTransactionSourceWindow;
    protected StockTransactionFilterUI conditionPanel;
    protected IMetaDataPK mainQueryPK2;
    private ManufactureOrderCollection mnfStaticOrderCollection;
    private Map sTStockCalMap;
    private DataChangeListener storageOrgChangeListener = null;
    private Map sTSourceMap;
    private Map sTStockMap;
    private Map billMap;
    private Map precisionMap;
    private Map receiptQtyMap = new HashMap();
    private static final String IS_BUILD = "isBuild";
    private static final String STORAGEORGUNITINFO_KEY = "storageOrgUnitInfo";
    private static final String ORDERID_LIST = "orderIdList";
    String[] orderQtyFieldNames = new String[]{"orderQty", "totalReceiptQty", "receiptQty"};
    String[] stockQtyFieldNames = new String[]{"invQty", "stockReserveQty", "reqQty", "receiptQty", "totalReceiptQty", "transferBatch"};
    private static final String CLEAR_ITEM = "ClearItem";
    CommonQueryDialog dialog = null;
    CommonQueryDialog dialogCalculate = null;
    private static final String TB_ORDER_NUMBER = "number";
    private static final String TB_TRANSACTION_TYPE = "transactionType";
    private static final String TB_PRD_NUMBER = "prdNumber";
    private static final String TB_PRD_NAME = "prdName";
    private static final String TB_PRD_MODEL = "prdModel";
    private static final String TB_BOM_NUM = "bomNum";
    private static final String TB_ORDER_QTY = "orderQty";
    private static final String TB_TOTALRECEIPT_QTY = "totalReceiptQty";
    private static final String TB_RECEIPT_QTY = "receiptQty";
    private static final String TB_UNIT = "unit";
    private static final String TB_PLANBEGIN_DATE = "planBeginDate";
    private static final String TB_PLANEND_DATE = "planEndDate";
    private static final String TB_ADMINORG_UNIT = "adminOrgUnit";
    private static final String TB_ORDER_ID = "orderId";
    private static final String TB_PRD_ID = "prdId";
    private static final String TB_UNIT_ID = "unitID";
    private static final String TB_BSUNIT_ID = "bsUnitID";
    private static final String TB_MAXRECEIPT_QTY = "maxReceiptQty";
    private static final String TB_BSMAXRECEIPT_QTY = "bsMaxReceiptQty";
    private static final String TB_MINRECEIPT_QTY = "minReceiptQty";
    private static final String TB_BSMINRECEIPT_QTY = "bsMinReceiptQty";
    private static final String TB_QTY = "qty";
    private static final String TB_TOTALPAR_QTY = "totalParQty";
    private static final String TB_TOSTRORE_QTY = "toStroreQty";
    private static final String TB_FINISHED_QTY = "finishedQty";
    private static final String TB_ORDERNUMBER = "orderNumber";
    private static final String TB_PRODUCTNUMBER = "productNumber";
    private static final String TB_PRODUCTNAME = "productName";
    private static final String TB_MATERIALNUMBER = "materialNumber";
    private static final String TB_MATERIALNAME = "materialName";
    private static final String TB_MATERIALMODEL = "materialModel";
    private static final String TB_OPERATIONNO = "operationNo";
    private static final String TB_OPERATIONNAME = "operationName";
    private static final String TB_STOCK_UNIT = "stockUnit";
    private static final String TB_INVQTY = "invQty";
    private static final String TB_STOCKRESERVEQTY = "stockReserveQty";
    private static final String TB_DEMANDTIME = "demandTime";
    private static final String TB_REQQTY = "reqQty";
    private static final String TB_RECEIPTQTY = "receiptQty";
    private static final String TB_TOTALRECEIPTQTY = "totalReceiptQty";
    private static final String TB_TRANSFERBATCH = "transferBatch";
    private static final String TB_WAREHOUSE = "warehouse";
    private static final String TB_FROMSTORAGEORG = "fromStorageOrg";
    private static final String TB_FROMWAREHS = "fromWarehs";
    private static final String TB_REMARK = "remark";
    private static final String TB_ID = "id";
    private static final String TB_ORDERID = "orderId";
    private static final String TB_STOCKENTRYID = "stockEntryId";
    private static final String TB_MATERIALID = "materialId";
    private static final String TB_UNITID = "unitId";
    private static final String TB_BSUNITID = "bsUnitId";
    private static final String TB_BSINVQTY = "bsInvQty";
    private static final String TB_BSSTOCKRESERVEQTY = "bsStockReserveQty";
    private static final String TB_BSREQQTY = "bsReqQty";
    private static final String TB_BSRECEIPTQTY = "bsReceiptQty";
    private static final String TB_BSTOTALRECEIPTQTY = "bsTotalReceiptQty";
    private static final String TB_BSTRANSFERBATCH = "bsTransferBatch";
    private static final String TB_WAREHOUSEID = "warehouseId";
    private static final String TB_FROMSTORAGEORGID = "fromStorageOrgId";
    private static final String TB_FROMWAREHSID = "fromWarehsId";
    private static final String TB_TRANSFERTYPE = "transferType";
    private static final String TB_BILL_ID = "id";
    private static final String TB_BILL_ENTRY_ID = "entryId";
    private static final String TB_STDESTBILLTYPE = "sTDestBillType";
    private static final String TB_ISSUESTORAGEORGUNIT = "issueStorageOrgUnit";
    private static final String TB_NUMBER = "number";
    private static final String TB_BIZTYPE = "bizType";
    private static final String TB_RECEIPTADMINORGUNIT = "receiptAdminOrgUnit";
    private static final String TB_MATERIAL_NUMBER = "materialNumber";
    private static final String TB_MATERIAL_NAME = "materialName";
    private static final String TB_MATERIAL_MODEL = "materialModel";
    private static final String TB_MEASUREUNIT = "unit";
    private static final String TB_RECEQTY = "qty";
    private static final String TB_RECEIPTPLANDATE = "receiptPlanDate";
    private static final String TB_MREMARK = "remark";
    private static final String TB_PROJECT = "project";
    private static final String TB_TRACKNUM = "trackNum";
    private static final String STOCK_COLLELCTION_KEY = "mnfStockCollection";
    private static final String ID_MAP_KEY = "idMap";
    private KDTEditAdapter kdOrderChanged;
    private KDTEditAdapter kdStockChanged;
    private KDTEditAdapter kdSimulateChanged;
    private static final String TRANSFER_ORDER_BILL_KEY = "transferOrderBillCollection";
    private static final String STOCK_TRANSFER_BILL_KEY = "stockTransferBillCollection";
    private static final String[] STO_DATES = new String[]{"demandTime"};
    private static final String[] ORD_DATES = new String[]{"planBeginDate", "planEndDate"};
    private static final String[] SIM_DATES = new String[]{"receiptPlanDate"};
    private ITotalLine itl = new TotalLineHandler();

    public void onLoad() throws Exception {
        Map uiContext = this.getUIContext();
        StorageOrgUnitInfo storageUnit = (StorageOrgUnitInfo)uiContext.get(OrgType.Storage);
        super.onLoad();
        SCMClientUtils.setMainBizOrgF7((KDBizPromptBox)this.prmtStorageOrgUnit, (OrgType)OrgType.Storage, (String)"mm_discrete_stockTransaction");
        StorageOrgUnitInfo storage = (StorageOrgUnitInfo)MMUtils.getDefaultMainBizOrg((OrgType)this.getMainBizOrgType(), (String)"mm_discrete_stockTransaction");
        this.prmtStorageOrgUnit.removeDataChangeListener(this.storageOrgChangeListener);
        this.prmtStorageOrgUnit.setValue((Object)storage);
        this.init();
        this.initSortManager();
        this.kdOrder.getActionMap().remove("Delete");
        this.kdOrder.getActionMap().remove("Paste");
        this.kdStock.getActionMap().remove("Delete");
        this.kdStock.getActionMap().remove("Paste");
        this.kdSimulationOrder.getActionMap().remove("Delete");
        this.kdSimulationOrder.getActionMap().remove("Paste");
        this.showWithOrder(storageUnit);
    }

    public void onShow() throws Exception {
        super.onShow();
        this.setTableToSumField();
        this.appendFootRow(null);
        KDTableUtils.setDefaultFreezeCol((KDTable)this.kdOrder, (int)(this.kdOrder.getColumnIndex("number") + 1));
        KDTableUtils.setDefaultFreezeCol((KDTable)this.kdStock, (int)(this.kdStock.getColumnIndex("materialNumber") + 1));
        EditTableUtil.formatColDate((KDTable)this.kdStock, (String[])STO_DATES);
        EditTableUtil.formatColDate((KDTable)this.kdSimulationOrder, (String[])SIM_DATES);
        EditTableUtil.formatColDate((KDTable)this.kdOrder, (String[])ORD_DATES);
    }

    private void initSortManager() {
        KDTable[] kdTables = new KDTable[]{this.kdOrder, this.kdStock, this.kdSimulationOrder};
        for (int i = 0; i < kdTables.length; ++i) {
            KDTSortManager sortManager = new KDTSortManager(kdTables[i]);
            sortManager.setSortAuto(true);
            sortManager.setClickCount(1);
            kdTables[i].setSortMange(sortManager);
            for (int j = 0; j < kdTables[i].getColumnCount(); ++j) {
                kdTables[i].getColumn(j).setSortable(true);
            }
        }
    }

    private void showWithOrder(StorageOrgUnitInfo storageUnit) throws BOSException, EASBizException {
        Map uiContext = this.getUIContext();
        if (uiContext != null) {
            List orderIds = (List)uiContext.get(ORDERID_LIST);
            String isOrder = (String)uiContext.get("isOrder");
            if (isOrder != null && "1".equals(isOrder)) {
                StorageOrgUnitInfo orderStorage = null;
                orderStorage = (StorageOrgUnitInfo)this.checkOrgPermission(this.getMainBizOrgType(), "mm_discrete_stockTransaction", storageUnit);
                if (orderStorage == null) {
                    MsgBox.showInfo((Component)((Object)this), (String)MessageFormat.format(StockTransactionEditUI.getResource("NotHasPermission"), storageUnit));
                    SysUtil.abort();
                }
                this.prmtStorageOrgUnit.removeDataChangeListener(this.storageOrgChangeListener);
                this.prmtStorageOrgUnit.setValue((Object)orderStorage);
                this.prmtStorageOrgUnit.addDataChangeListener(this.storageOrgChangeListener);
                if (orderIds != null && orderIds.size() > 0) {
                    IStockTransactionEditFacade facade = StockTransactionEditFacadeFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
                    List resultList = facade.sTSourceList((StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue(), orderIds, ((STRuleEnum)((Object)this.stRule.getSelectedItem())).getValue());
                    if (resultList != null && resultList.size() > 0) {
                        ManufactureOrderCollection mnfOrderCollection = (ManufactureOrderCollection)((Object)resultList.get(0));
                        ManufactureOrderCollection filteredOrderCollection = this.filterMOCollection(mnfOrderCollection);
                        if (filteredOrderCollection.size() == 0) {
                            MsgBox.showInfo((String)StockTransactionEditUI.getResource("NO_STOCK"));
                            SysUtil.abort();
                        }
                        resultList.remove(0);
                        resultList.add(0, filteredOrderCollection);
                        this.bindingOrderData(resultList);
                    }
                } else {
                    MsgBox.showInfo((String)StockTransactionEditUI.getResource("NO_STOCK"));
                    SysUtil.abort();
                }
            }
        }
    }

    private OrgUnitInfo checkOrgPermission(OrgType orgType, String strStatus, StorageOrgUnitInfo orderStorage) {
        OrgUnitInfo[] mainOrgs = null;
        try {
            mainOrgs = SCMServiceFactory.getPermissionService().getAuthorizedBizOrgUnits((IObjectPK)new ObjectStringPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString()), orgType, strStatus);
            if (mainOrgs == null || mainOrgs.length == 0) {
                return null;
            }
            if (mainOrgs.length > 0) {
                mainOrgs = (OrgUnitInfo[])SortUtil.sortDataByNumber((DataBaseInfo[])mainOrgs, (boolean)true);
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        int k = 0;
        if (mainOrgs == null) {
            orderStorage = null;
        }
        if (orderStorage != null && mainOrgs.length > 0) {
            for (int i = 0; i < mainOrgs.length; ++i) {
                if (orderStorage.getId().toString().equals(mainOrgs[i].getId().toString())) {
                    return orderStorage;
                }
                if (++k != mainOrgs.length) continue;
                orderStorage = null;
            }
        } else {
            orderStorage = null;
        }
        return orderStorage;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.panelOrder.putClientProperty((Object)"OriginalBounds", (Object)new Rectangle(0, 0, 997, 257));
        this.panelStock.putClientProperty((Object)"OriginalBounds", (Object)new Rectangle(0, 0, 997, 257));
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.menuItemQuery.setIcon(MMUtils.getNewIcon((String)"imgTbtn_sourcebillfilter"));
        this.btnQuery.setIcon(MMUtils.getNewIcon((String)"imgTbtn_sourcebillfilter"));
        this.menuItemCollectCalculate.setIcon(MMUtils.getNewIcon((String)"imgTbtn_collectcomputation"));
        this.btnCollectCalculate.setIcon(MMUtils.getNewIcon((String)"imgTbtn_collectcomputation"));
        this.menuItemBuild.setIcon(MMUtils.getNewIcon((String)"imgTbtn_createbill"));
        this.btnBuild.setIcon(MMUtils.getNewIcon((String)"imgTbtn_createbill"));
        this.menuItemSimulate.setIcon(EASResource.getIcon((String)"imgTbtn_simulate"));
        this.btnSimulate.setIcon(EASResource.getIcon((String)"imgTbtn_simulate"));
    }

    private void init() {
        this.kdOrder.checkParsed();
        this.kdStock.checkParsed();
        this.panleSourse.setEnabledAt(1, false);
        this.stRule.getActionMap().remove(CLEAR_ITEM);
        this.stGroup.getActionMap().remove(CLEAR_ITEM);
        this.initOrderRecepitQty(true);
        this.initDemandTime();
        this.initStockRecepitQty();
        this.addListener();
    }

    private void addListener() {
        this.stRule.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                StockTransactionEditUI.this.stRuleChanged();
            }
        });
        this.kdOrderChanged = new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                String fieldName = StockTransactionEditUI.this.kdOrder.getColumnKey(e.getColIndex());
                if ("receiptQty".equals(fieldName)) {
                    StockTransactionEditUI.this.receipChanged(e);
                }
            }
        };
        this.kdStockChanged = new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                String fieldName = StockTransactionEditUI.this.kdStock.getColumnKey(e.getColIndex());
                if ("receiptQty".equals(fieldName)) {
                    StockTransactionEditUI.this.stockReceipChanged(e);
                }
                if ("remark".equals(fieldName)) {
                    StockTransactionEditUI.this.remarkChanged(e);
                }
                if (StockTransactionEditUI.TB_DEMANDTIME.equals(fieldName)) {
                    StockTransactionEditUI.this.demandTimeChanged(e);
                }
            }
        };
        this.kdSimulateChanged = new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                String fieldName = StockTransactionEditUI.this.kdSimulationOrder.getColumnKey(e.getColIndex());
                if ("remark".equals(fieldName)) {
                    StockTransactionEditUI.this.remarkSimulateChanged(e);
                }
                if ("number".equals(fieldName)) {
                    StockTransactionEditUI.this.simulateNumberReceipChanged(e);
                }
            }
        };
        this.storageOrgChangeListener = new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                StockTransactionEditUI.this.storagChanged(e);
            }
        };
        this.kdOrder.addKDTEditListener((KDTEditListener)this.kdOrderChanged);
        this.kdStock.addKDTEditListener((KDTEditListener)this.kdStockChanged);
        this.kdSimulationOrder.addKDTEditListener((KDTEditListener)this.kdSimulateChanged);
        this.prmtStorageOrgUnit.addDataChangeListener(this.storageOrgChangeListener);
    }

    private void storagChanged(DataChangeEvent e) {
        StorageOrgUnitInfo oldStorage = (StorageOrgUnitInfo)e.getOldValue();
        StorageOrgUnitInfo newStorage = (StorageOrgUnitInfo)e.getNewValue();
        if (newStorage == null) {
            this.prmtStorageOrgUnit.removeDataChangeListener(this.storageOrgChangeListener);
            this.prmtStorageOrgUnit.setValue((Object)oldStorage);
            this.prmtStorageOrgUnit.addDataChangeListener(this.storageOrgChangeListener);
        } else {
            boolean isDiffrent = SCMGroupClientUtils.isDiffrent((Object)oldStorage, (Object)newStorage);
            if (isDiffrent && this.kdOrder.getRowCount() > 0) {
                if (MsgBox.showConfirm2((String)StockTransactionEditUI.getResource("IS_CLEAR_DATA")) == 0) {
                    this.clearRow();
                    this.clearStaticData(0);
                    this.removeFootRow();
                    this.appendFootRow(null);
                } else {
                    this.prmtStorageOrgUnit.removeDataChangeListener(this.storageOrgChangeListener);
                    this.prmtStorageOrgUnit.setValue((Object)oldStorage);
                    this.prmtStorageOrgUnit.addDataChangeListener(this.storageOrgChangeListener);
                }
            }
            if (isDiffrent) {
                this.dialog = null;
            }
        }
    }

    private void receipChanged(KDTEditEvent e) {
        BigDecimal newValue = (BigDecimal)e.getValue();
        BigDecimal oldValue = (BigDecimal)e.getOldValue();
        if (newValue == null) {
            this.kdOrder.getCell(e.getRowIndex(), e.getColIndex()).setValue((Object)oldValue);
        } else if (newValue.compareTo(new BigDecimal(this.kdOrder.getCell(e.getRowIndex(), "totalReceiptQty").getValue().toString())) < 0) {
            if (STRuleEnum.REINFORCE == (STRuleEnum)((Object)this.stRule.getSelectedItem())) {
                this.kdOrder.getCell(e.getRowIndex(), e.getColIndex()).setValue((Object)oldValue);
            } else {
                this.updateReceiptQty(e.getRowIndex(), newValue);
            }
        } else {
            this.updateReceiptQty(e.getRowIndex(), newValue);
        }
    }

    private void stockReceipChanged(KDTEditEvent e) {
        BigDecimal newValue = (BigDecimal)e.getValue();
        BigDecimal oldValue = (BigDecimal)e.getOldValue();
        if (newValue == null) {
            this.kdStock.getCell(e.getRowIndex(), e.getColIndex()).setValue((Object)oldValue);
        } else {
            this.updateStockReceiptQty(e.getRowIndex(), newValue);
        }
    }

    private void remarkChanged(KDTEditEvent e) {
        Object newValue = e.getValue();
        String id = this.kdStock.getCell(e.getRowIndex(), "id").getValue().toString();
        STStockInfo stStockInfo = (STStockInfo)this.sTStockMap.get(id);
        stStockInfo.setRemark((String)newValue);
    }

    private void demandTimeChanged(KDTEditEvent e) {
        Date newValue = (Date)e.getValue();
        Date oldValue = (Date)e.getOldValue();
        if (newValue == null) {
            this.kdStock.getCell(e.getRowIndex(), TB_DEMANDTIME).setValue((Object)oldValue);
            return;
        }
        long newTime = newValue.getTime();
        String id = this.kdStock.getCell(e.getRowIndex(), "id").getValue().toString();
        ManufactureOrderStockCollection mnfStockCollection = (ManufactureOrderStockCollection)((Object)this.sTStockMap.get(STOCK_COLLELCTION_KEY));
        Map idMap = (Map)this.sTStockMap.get(ID_MAP_KEY);
        String mnfStockId = (String)idMap.get(id);
        if (mnfStockCollection != null && mnfStockCollection.size() > 0) {
            for (int j = 0; j < mnfStockCollection.size(); ++j) {
                ManufactureOrderStockInfo mnfStockInfo = mnfStockCollection.get(j);
                if (!mnfStockId.equals(mnfStockInfo.getId().toString())) continue;
                mnfStockInfo.setDemandTime(new Timestamp(newTime));
                break;
            }
        }
    }

    private void remarkSimulateChanged(KDTEditEvent e) {
        block5: {
            StockTransferBillCollection stCollection;
            String billBizType;
            String entryId;
            String id;
            Object newValue;
            block6: {
                newValue = e.getValue();
                id = this.kdSimulationOrder.getCell(e.getRowIndex(), "id").getValue().toString();
                entryId = this.kdSimulationOrder.getCell(e.getRowIndex(), TB_BILL_ENTRY_ID).getValue().toString();
                billBizType = this.kdSimulationOrder.getCell(e.getRowIndex(), TB_STDESTBILLTYPE).getValue().toString();
                TransferOrderBillCollection toCollection = (TransferOrderBillCollection)this.billMap.get(TRANSFER_ORDER_BILL_KEY);
                stCollection = (StockTransferBillCollection)this.billMap.get(STOCK_TRANSFER_BILL_KEY);
                if (!billBizType.equals(StockTransactionEditUI.getResource("BIZ_TRANSFER_ORDER"))) break block6;
                if (toCollection == null || toCollection.size() <= 0) break block5;
                for (int i = 0; i < toCollection.size(); ++i) {
                    TransferOrderBillInfo toInfo = toCollection.get(i);
                    if (!toInfo.getId().toString().equals(id)) continue;
                    TransferOrderBillEntryCollection toEntryCollection = toInfo.getEntry();
                    if (toEntryCollection == null || toEntryCollection.size() <= 0) break block5;
                    for (int j = 0; j < toEntryCollection.size(); ++j) {
                        TransferOrderBillEntryInfo toEntryInfo = toEntryCollection.get(j);
                        if (!toEntryInfo.getId().toString().equals(entryId)) continue;
                        toEntryInfo.setRemark((String)newValue);
                        break block5;
                    }
                    break block5;
                }
                break block5;
            }
            if (billBizType.equals(StockTransactionEditUI.getResource("BIZ_STOCK_TRANSFER")) && stCollection != null && stCollection.size() > 0) {
                for (int i = 0; i < stCollection.size(); ++i) {
                    StockTransferBillInfo stInfo = stCollection.get(i);
                    if (!stInfo.getId().toString().equals(id)) continue;
                    StockTransferBillEntryCollection stEntryCollection = stInfo.getEntry();
                    if (stEntryCollection == null || stEntryCollection.size() <= 0) break;
                    for (int j = 0; j < stEntryCollection.size(); ++j) {
                        StockTransferBillEntryInfo stEntryInfo = stEntryCollection.get(j);
                        if (!stEntryInfo.getId().toString().equals(entryId)) continue;
                        stEntryInfo.setRemark((String)newValue);
                        break block5;
                    }
                    break;
                }
            }
        }
    }

    private void simulateNumberReceipChanged(KDTEditEvent e) {
        block3: {
            StockTransferBillCollection stCollection;
            String billBizType;
            String id;
            String newValue;
            block5: {
                block4: {
                    newValue = (String)e.getValue();
                    String oldValue = (String)e.getOldValue();
                    if (newValue != null && !"".equals(newValue.trim())) break block4;
                    this.kdSimulationOrder.getCell(e.getRowIndex(), e.getColIndex()).setValue((Object)oldValue);
                    break block3;
                }
                id = this.kdSimulationOrder.getCell(e.getRowIndex(), "id").getValue().toString();
                billBizType = this.kdSimulationOrder.getCell(e.getRowIndex(), TB_STDESTBILLTYPE).getValue().toString();
                TransferOrderBillCollection toCollection = (TransferOrderBillCollection)this.billMap.get(TRANSFER_ORDER_BILL_KEY);
                stCollection = (StockTransferBillCollection)this.billMap.get(STOCK_TRANSFER_BILL_KEY);
                if (!billBizType.equals(StockTransactionEditUI.getResource("BIZ_TRANSFER_ORDER"))) break block5;
                if (toCollection == null || toCollection.size() <= 0) break block3;
                for (int i = 0; i < toCollection.size(); ++i) {
                    TransferOrderBillInfo toInfo = toCollection.get(i);
                    if (!toInfo.getId().toString().equals(id)) continue;
                    toInfo.setNumber(newValue);
                    break block3;
                }
                break block3;
            }
            if (billBizType.equals(StockTransactionEditUI.getResource("BIZ_STOCK_TRANSFER")) && stCollection != null && stCollection.size() > 0) {
                for (int i = 0; i < stCollection.size(); ++i) {
                    StockTransferBillInfo stInfo = stCollection.get(i);
                    if (!stInfo.getId().toString().equals(id)) continue;
                    stInfo.setNumber(newValue);
                    break;
                }
            }
        }
    }

    private void clearStaticData(int key) {
        switch (key) {
            case 0: {
                if (this.mnfStaticOrderCollection != null) {
                    this.mnfStaticOrderCollection.clear();
                }
                if (this.sTStockCalMap != null) {
                    this.sTStockCalMap.clear();
                }
                if (this.sTSourceMap != null) {
                    this.sTSourceMap.clear();
                }
                if (this.sTStockMap != null) {
                    this.sTStockMap.clear();
                }
                if (this.billMap == null) break;
                this.billMap.clear();
                break;
            }
            case 1: {
                if (this.billMap == null) break;
                this.billMap.clear();
                break;
            }
            case 2: {
                if (this.billMap == null) break;
                this.billMap.clear();
                break;
            }
            case 3: {
                break;
            }
        }
    }

    private void initOrderRecepitQty(boolean editable) {
        KDFormattedTextField orderRreceiptQty = new KDFormattedTextField();
        orderRreceiptQty.setName("orderRreceiptQty");
        orderRreceiptQty.setDataType(1);
        orderRreceiptQty.setVisible(true);
        orderRreceiptQty.setRequired(true);
        orderRreceiptQty.setSupportedEmpty(false);
        orderRreceiptQty.setMinimumValue((Comparable)ZERO);
        orderRreceiptQty.setMaximumValue((Comparable)MAX_VALUE);
        KDTDefaultCellEditor orderRreceiptQtyCellEditor = new KDTDefaultCellEditor((JTextField)orderRreceiptQty);
        this.kdOrder.getColumn("receiptQty").setEditor((ICellEditor)orderRreceiptQtyCellEditor);
        this.kdOrder.getColumn("receiptQty").getStyleAttributes().setLocked(editable);
    }

    private void initStockRecepitQty() {
        KDFormattedTextField stockReceiptQty = new KDFormattedTextField();
        stockReceiptQty.setName("stockRecepitQty");
        stockReceiptQty.setDataType(1);
        stockReceiptQty.setVisible(true);
        stockReceiptQty.setRequired(true);
        stockReceiptQty.setSupportedEmpty(false);
        stockReceiptQty.setMinimumValue((Comparable)ZERO);
        stockReceiptQty.setMaximumValue((Comparable)MAX_VALUE);
        KDTDefaultCellEditor orderRreceiptQtyCellEditor = new KDTDefaultCellEditor((JTextField)stockReceiptQty);
        this.kdStock.getColumn("receiptQty").setEditor((ICellEditor)orderRreceiptQtyCellEditor);
        this.kdStock.getColumn("receiptQty").getStyleAttributes().setLocked(false);
    }

    private void initDemandTime() {
        KDDatePicker stockDemandTimeDatePicker = new KDDatePicker();
        stockDemandTimeDatePicker.setTimeEnabled(true);
        stockDemandTimeDatePicker.setName("stockDemandTime_DatePicker");
        stockDemandTimeDatePicker.setVisible(true);
        stockDemandTimeDatePicker.setEditable(true);
        stockDemandTimeDatePicker.setDatePattern(CtrlFormatUtilities.getDateTimeFormatString());
        KDTDefaultCellEditor stockDemandTime_CellEditor = new KDTDefaultCellEditor(stockDemandTimeDatePicker);
        this.kdStock.getColumn(TB_DEMANDTIME).setEditor((ICellEditor)stockDemandTime_CellEditor);
    }

    @Override
    public void actionRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        int[] selectRowIndexs = KDTableUtil.getSelectedRows((KDTable)this.kdStock);
        if (selectRowIndexs == null || selectRowIndexs.length == 0) {
            MsgBox.showInfo((String)StockTransactionEditUI.getResource("SELECT_STOCKROW_IS_NULL"));
            SysUtil.abort();
        }
        for (int i = selectRowIndexs.length - 1; i >= 0; --i) {
            IRow stockRow = this.kdStock.getRow(selectRowIndexs[i]);
            String id = (String)stockRow.getCell("id").getValue();
            this.sTStockMap.remove(id);
            ManufactureOrderStockCollection mnfStockCollection = (ManufactureOrderStockCollection)((Object)this.sTStockMap.get(STOCK_COLLELCTION_KEY));
            Map idMap = (Map)this.sTStockMap.get(ID_MAP_KEY);
            String mnfStockId = (String)idMap.get(id);
            if (mnfStockCollection != null && mnfStockCollection.size() > 0) {
                for (int j = 0; j < mnfStockCollection.size(); ++j) {
                    ManufactureOrderStockInfo mnfStockInfo = mnfStockCollection.get(j);
                    if (!mnfStockId.equals(mnfStockInfo.getId().toString())) continue;
                    mnfStockCollection.remove(mnfStockInfo);
                    break;
                }
            }
            this.kdStock.removeRow(selectRowIndexs[i]);
            this.removeFootRow();
            this.appendFootRow(null);
        }
    }

    @Override
    public void actionBuild_actionPerformed(ActionEvent e) throws Exception {
        this.checkStorage();
        if (this.kdSimulationOrder.getRowCount() <= 0) {
            MsgBox.showInfo((String)StockTransactionEditUI.getResource("BILL_IS_NULL"));
            SysUtil.abort();
        }
        if (((Boolean)this.billMap.get(IS_BUILD)).booleanValue()) {
            MsgBox.showInfo((String)StockTransactionEditUI.getResource("ALREADY_BUILDED"));
            SysUtil.abort();
        }
        IStockTransactionEditFacade remoteFacade = StockTransactionEditFacadeFactory.getRemoteInstance();
        this.billMap.put(STORAGEORGUNITINFO_KEY, (StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue());
        remoteFacade.generateDestBill(this.billMap);
        this.billMap.put(IS_BUILD, new Boolean(true));
        String msg = StockTransactionEditUI.getResource("BUILD_SUCCEED");
        this.setMessageText(msg);
        this.showMessage();
        MsgBox.showInfo((String)msg);
    }

    @Override
    public void actionSimulate_actionPerformed(ActionEvent e) throws Exception {
        this.checkStorage();
        this.setMergeColumn();
        if (this.kdStock.getRowCount() <= 0) {
            MsgBox.showInfo((String)StockTransactionEditUI.getResource("STOCK_IS_NULL"));
            SysUtil.abort();
        }
        boolean flag = false;
        ManufactureOrderStockCollection mnfStockCollection = (ManufactureOrderStockCollection)((Object)this.sTStockMap.get(STOCK_COLLELCTION_KEY));
        Map idMap = (Map)this.sTStockMap.get(ID_MAP_KEY);
        if (mnfStockCollection != null && mnfStockCollection.size() > 0) {
            for (int i = 0; i < mnfStockCollection.size(); ++i) {
                ManufactureOrderStockInfo mnfStockInfo = mnfStockCollection.get(i);
                STStockInfo sTStockInfo = (STStockInfo)this.sTStockMap.get((String)idMap.get(mnfStockInfo.getId().toString()));
                if (sTStockInfo.getReceiptQty().signum() > 0) continue;
                flag = true;
                break;
            }
        }
        if (flag) {
            int result = MsgBox.showConfirm3((String)StockTransactionEditUI.getResource("STOCK_ZERO"));
            if (result == 0) {
                this.sTStockMap.put("isRemoveZero", "0");
                this.simulate();
            } else if (result == 1) {
                this.sTStockMap.put("isRemoveZero", "1");
                this.simulate();
            } else {
                SysUtil.abort();
            }
        } else {
            this.sTStockMap.put("isRemoveZero", "0");
            this.simulate();
        }
    }

    private void simulate() throws BOSException, EASBizException {
        boolean flag = false;
        IStockTransactionEditFacade remoteFacade = StockTransactionEditFacadeFactory.getRemoteInstance();
        if (this.billMap != null && (this.billMap.containsKey(TRANSFER_ORDER_BILL_KEY) || this.billMap.containsKey(STOCK_TRANSFER_BILL_KEY)) && ((Boolean)this.billMap.get(IS_BUILD)).booleanValue()) {
            if (MsgBox.showConfirm2((String)StockTransactionEditUI.getResource("STOCK_BILL_IS_BUILD")) == 0) {
                remoteFacade.deleteDestBill(this.billMap);
                this.billMap.put(IS_BUILD, new Boolean(false));
            } else {
                flag = true;
            }
        }
        if (!flag) {
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("sTStockMap", this.sTStockMap);
            paramMap.put("STGroupEnum", (Object)((STGroupEnum)((Object)this.stGroup.getSelectedItem())));
            paramMap.put(STORAGEORGUNITINFO_KEY, (StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue());
            Map resultMap = remoteFacade.prepareDestBill(paramMap);
            this.bindingBillData(resultMap);
        }
    }

    @Override
    public void actionCollectCalculate_actionPerformed(ActionEvent e) throws Exception {
        BigDecimal orderQty;
        BigDecimal receiptQty;
        IRow row;
        int i;
        this.checkStorage();
        if (this.kdOrder.getRowCount() <= 0) {
            MsgBox.showInfo((String)StockTransactionEditUI.getResource("ORDER_IS_NULL"));
            SysUtil.abort();
        }
        boolean flag = false;
        boolean flag1 = false;
        boolean flag2 = false;
        for (i = this.kdOrder.getRowCount() - 1; i >= 0; --i) {
            row = this.kdOrder.getRow(i);
            receiptQty = (BigDecimal)row.getCell("receiptQty").getValue();
            if (receiptQty.signum() > 0) continue;
            flag = true;
            break;
        }
        if (STRuleEnum.REINFORCE == (STRuleEnum)((Object)this.stRule.getSelectedItem())) {
            for (i = this.kdOrder.getRowCount() - 1; i >= 0; --i) {
                row = this.kdOrder.getRow(i);
                receiptQty = (BigDecimal)row.getCell("receiptQty").getValue();
                if (receiptQty.compareTo(orderQty = (BigDecimal)row.getCell(TB_ORDER_QTY).getValue()) <= 0) continue;
                flag1 = true;
                break;
            }
        } else if (STRuleEnum.SUIT == (STRuleEnum)((Object)this.stRule.getSelectedItem())) {
            for (i = this.kdOrder.getRowCount() - 1; i >= 0; --i) {
                BigDecimal totalRecetipQty;
                row = this.kdOrder.getRow(i);
                receiptQty = (BigDecimal)row.getCell("receiptQty").getValue();
                orderQty = (BigDecimal)row.getCell(TB_ORDER_QTY).getValue();
                BigDecimal noReceiptQty = orderQty.subtract(totalRecetipQty = (BigDecimal)row.getCell("totalReceiptQty").getValue());
                if (noReceiptQty.signum() < 0) {
                    noReceiptQty = ZERO;
                }
                if (receiptQty.compareTo(noReceiptQty) <= 0) continue;
                flag2 = true;
                break;
            }
        }
        if (flag1 && MsgBox.showConfirm2((String)StockTransactionEditUI.getResource("RECEIPT_QTY_MORETHEN_QTY")) != 0) {
            SysUtil.abort();
        }
        if (flag2 && MsgBox.showConfirm2((String)StockTransactionEditUI.getResource("RECEIPT_QTY_MORETHEN_QTY_SUBSTRACTRECEPT")) != 0) {
            SysUtil.abort();
        }
        if (flag && MsgBox.showConfirm2((String)StockTransactionEditUI.getResource("RECEIPT_QTY_IS_NULL")) != 0) {
            SysUtil.abort();
        }
        this.dialogCalculate = this.initParamDialog();
        this.dialogCalculate.show();
        EntityViewInfo entityViewInfo = this.dialogCalculate.getEntityViewInfoResult();
        if (entityViewInfo.getFilter() != null) {
            STCalcParamInfo sTCalcParam = this.transferToSTCalParamInfo(entityViewInfo);
            IStockTransactionEditFacade remoteFacade = StockTransactionEditFacadeFactory.getRemoteInstance();
            Map map = remoteFacade.sTCalculate(this.mnfStaticOrderCollection, this.sTStockCalMap, this.sTSourceMap, this.receiptQtyMap, sTCalcParam, (STRuleEnum)((Object)this.stRule.getSelectedItem()), ((StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue()).getId().toString());
            this.clearStaticData(1);
            this.panleSourse.setEnabledAt(1, true);
            this.panleSourse.setSelectedIndex(1);
            this.bindingStockData(map);
        }
    }

    private STCalcParamInfo transferToSTCalParamInfo(EntityViewInfo entityViewInfo) {
        STCalcParamInfo resultInfo = new STCalcParamInfo();
        FilterInfo filterInfo = entityViewInfo.getFilter();
        if (filterInfo == null) {
            return null;
        }
        FilterItemCollection items = filterInfo.getFilterItems();
        if (items != null && items.size() > 0) {
            for (int i = 0; i < items.size(); ++i) {
                Set<String> set;
                FilterItemInfo info = items.get(i);
                Field field = null;
                try {
                    String propertyName = info.getPropertyName();
                    field = resultInfo.getClass().getDeclaredField(propertyName);
                    field.setAccessible(true);
                    if (!(info.getCompareValue() instanceof Set)) {
                        field.set(resultInfo, info.getCompareValue());
                        continue;
                    }
                    set = (Set)info.getCompareValue();
                    field.set(resultInfo, set);
                    continue;
                }
                catch (Exception e) {
                    logger.error((Object)e);
                    set = new HashSet<String>();
                    set.add((String)info.getCompareValue());
                    try {
                        if (null == field) continue;
                        field.set(resultInfo, set);
                        continue;
                    }
                    catch (Exception e1) {
                        logger.error((Object)e1);
                    }
                }
            }
        }
        return resultInfo;
    }

    @Override
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        this.checkStorage();
        UIContext uiContext = new UIContext((Object)this);
        this.setSTRuleSel(uiContext);
        if (this.billMap != null && (this.billMap.containsKey(TRANSFER_ORDER_BILL_KEY) || this.billMap.containsKey(STOCK_TRANSFER_BILL_KEY)) && !((Boolean)this.billMap.get(IS_BUILD)).booleanValue() && MsgBox.showConfirm2((String)StockTransactionEditUI.getResource("SIMULATE_NO_BUILD")) != 0) {
            SysUtil.abort();
        }
        if (this.dialog == null) {
            this.dialog = this.initCommonQueryDialog();
        }
        this.dialog.show();
        EntityViewInfo entityViewInfo = this.dialog.getEntityViewInfoResult();
        if (entityViewInfo.getFilter() == null) {
            this.abort();
        }
        FilterInfo filter1 = entityViewInfo.getFilter();
        FilterItemCollection items = filter1.getFilterItems();
        for (int index = items.size() - 1; index >= 0; --index) {
            FilterItemInfo filterInfo = items.get(index);
            if (!filterInfo.getPropertyName().equals("storageOrgUnit.number") || filterInfo.getCompareValue().toString().equals(((StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue()).getNumber())) continue;
            MsgBox.showInfo((String)StockTransactionEditUI.getResource("STORAGE_ORG_DIFFERENT"));
            SysUtil.abort();
        }
        FilterInfo filter = new FilterInfo();
        HashSet<Integer> baseStatusSet = new HashSet<Integer>();
        baseStatusSet.add(new Integer(4));
        baseStatusSet.add(new Integer(5));
        baseStatusSet.add(new Integer(8));
        filter.getFilterItems().add(new FilterItemInfo("baseStatus", baseStatusSet, CompareType.INCLUDE));
        entityViewInfo.getFilter().mergeFilter(filter, "and");
        entityViewInfo.setSelector(this.getSelectors());
        entityViewInfo.getSorter().add(new SorterItemInfo(TB_PLANBEGIN_DATE));
        entityViewInfo.getSorter().add(new SorterItemInfo("number"));
        entityViewInfo.getSorter().add(new SorterItemInfo("material.number"));
        ManufactureOrderCollection mococn = ManufactureOrderFactory.getRemoteInstance().getManufactureOrderCollection(entityViewInfo);
        ManufactureOrderCollection anotherCon = this.filterMOCollection(mococn);
        uiContext.put((Object)"mococn", (Object)anotherCon);
        uiContext.put((Object)"storageUnitInfo", this.prmtStorageOrgUnit.getValue());
        uiContext.put((Object)"dialog", (Object)this.dialog);
        this.stockTransactionSourceWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.mm.mo.client.StockTransactionSourceUI", (Map)uiContext, null, OprtState.VIEW);
        StockTransactionSourceUI sourceUI = (StockTransactionSourceUI)this.stockTransactionSourceWindow.getUIObject();
        this.stockTransactionSourceWindow.show();
        if (sourceUI.getResultList() != null) {
            this.clearStaticData(0);
            List resultList = sourceUI.getResultList();
            this.kdStock.removeRows();
            this.kdSimulationOrder.removeRows();
            this.removeFootRow();
            this.appendFootRow(null);
            this.bindingOrderData(resultList);
        }
        this.panleSourse.setSelectedIndex(0);
    }

    private void checkStorage() {
        if (this.prmtStorageOrgUnit.getValue() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)StockTransactionEditUI.getResource("STORAGEUNIT_IS_NOT_NULL"));
            SysUtil.abort();
        }
    }

    private ManufactureOrderCollection filterMOCollection(ManufactureOrderCollection mococn) {
        ManufactureOrderCollection anotherCon = new ManufactureOrderCollection();
        if (mococn != null) {
            block0: for (int i = 0; i < mococn.size(); ++i) {
                ManufactureOrderStockCollection mnfStockCollection;
                ManufactureOrderInfo manufactureOrderInfo = mococn.get(i);
                BillBaseStatusEnum baseStatus = manufactureOrderInfo.getBaseStatus();
                if (baseStatus != BillBaseStatusEnum.AUDITED && baseStatus != BillBaseStatusEnum.RELEASED && baseStatus != BillBaseStatusEnum.COMPLETE || (mnfStockCollection = manufactureOrderInfo.getStocks()) == null || mnfStockCollection.size() <= 0) continue;
                for (int j = 0; j < mnfStockCollection.size(); ++j) {
                    ManufactureOrderStockInfo mnfStockInfo = mnfStockCollection.get(j);
                    boolean isStockAllot = mnfStockInfo.isIsStockAllot();
                    MaterialIssueModeEnum issueMode = mnfStockInfo.getIssueMode();
                    MaterialProvideTypeEnum provideType = mnfStockInfo.getProvideType();
                    if (!isStockAllot || issueMode != MaterialIssueModeEnum.PRODUCEISSMODE || provideType != MaterialProvideTypeEnum.CURRENTORGPROVIDE && provideType != MaterialProvideTypeEnum.SPANORGATTEMPERPROVIDE) continue;
                    anotherCon.add(manufactureOrderInfo);
                    continue block0;
                }
            }
        }
        return anotherCon;
    }

    private void bindingOrderData(List resultList) throws EASBizException, BOSException {
        ManufactureOrderCollection mnfOrderCollection;
        this.clearRow();
        this.mnfStaticOrderCollection = mnfOrderCollection = (ManufactureOrderCollection)((Object)resultList.get(0));
        this.sTSourceMap = (Map)resultList.get(1);
        this.precisionMap = (Map)resultList.get(2);
        this.sTStockCalMap = (Map)resultList.get(3);
        for (int i = 0; i < mnfOrderCollection.size(); ++i) {
            IRow orderRow = this.kdOrder.addRow();
            ManufactureOrderInfo mnfOrderInfo = mnfOrderCollection.get(i);
            STSourceInfo stSourceInfo = (STSourceInfo)this.sTSourceMap.get(mnfOrderInfo.getId().toString());
            orderRow.getCell("number").setValue((Object)mnfOrderInfo.getNumber());
            orderRow.getCell(TB_TRANSACTION_TYPE).setValue((Object)(mnfOrderInfo.getTransactionType() != null ? mnfOrderInfo.getTransactionType().getName() : ""));
            orderRow.getCell(TB_PRD_NUMBER).setValue((Object)(mnfOrderInfo.getMaterial() != null ? mnfOrderInfo.getMaterial().getNumber() : ""));
            orderRow.getCell(TB_PRD_NAME).setValue((Object)(mnfOrderInfo.getMaterial() != null ? mnfOrderInfo.getMaterial().getName() : ""));
            orderRow.getCell(TB_PRD_MODEL).setValue((Object)(mnfOrderInfo.getMaterial() != null ? mnfOrderInfo.getMaterial().getModel() : ""));
            orderRow.getCell(TB_BOM_NUM).setValue((Object)mnfOrderInfo.getBomNum());
            orderRow.getCell(TB_ORDER_QTY).setValue((Object)mnfOrderInfo.getQty());
            orderRow.getCell("totalReceiptQty").setValue((Object)this.getTotalReceiptQtyBySTSourceInfo(stSourceInfo));
            BigDecimal receiptQty = this.getReceiptQtyBySTSourceInfo(mnfOrderInfo, orderRow);
            orderRow.getCell("receiptQty").setValue((Object)receiptQty);
            this.receiptQtyMap.put(mnfOrderInfo.getId().toString(), receiptQty);
            orderRow.getCell("unit").setValue((Object)mnfOrderInfo.getUnit());
            orderRow.getCell(TB_PLANBEGIN_DATE).setValue((Object)mnfOrderInfo.getPlanBeginDate());
            orderRow.getCell(TB_PLANEND_DATE).setValue((Object)mnfOrderInfo.getPlanEndDate());
            orderRow.getCell(TB_ADMINORG_UNIT).setValue((Object)mnfOrderInfo.getAdminOrgUnit());
            orderRow.getCell("orderId").setValue((Object)mnfOrderInfo.getId());
            orderRow.getCell(TB_PRD_ID).setValue((Object)(mnfOrderInfo.getMaterial() != null ? mnfOrderInfo.getMaterial().getId().toString() : ""));
            orderRow.getCell(TB_UNIT_ID).setValue((Object)(mnfOrderInfo.getUnit() != null ? mnfOrderInfo.getUnit().getId().toString() : ""));
            orderRow.getCell(TB_BSUNIT_ID).setValue((Object)(mnfOrderInfo.getMaterial().getBaseUnit() != null ? mnfOrderInfo.getMaterial().getBaseUnit().getId().toString() : ""));
            orderRow.getCell(TB_MAXRECEIPT_QTY).setValue((Object)stSourceInfo.getMaxReceiptQty());
            orderRow.getCell(TB_BSMAXRECEIPT_QTY).setValue((Object)stSourceInfo.getBsMaxReceiptQty());
            orderRow.getCell(TB_MINRECEIPT_QTY).setValue((Object)stSourceInfo.getMinReceiptQty());
            orderRow.getCell(TB_BSMINRECEIPT_QTY).setValue((Object)stSourceInfo.getBsMinReceiptQty());
            orderRow.getCell("qty").setValue((Object)mnfOrderInfo.getQty());
            orderRow.getCell(TB_TOTALPAR_QTY).setValue((Object)(mnfOrderInfo.getTotalSplitQty() != null ? mnfOrderInfo.getTotalSplitQty() : ZERO));
            orderRow.getCell(TB_TOSTRORE_QTY).setValue((Object)mnfOrderInfo.getToStroreQty());
            orderRow.getCell(TB_FINISHED_QTY).setValue((Object)mnfOrderInfo.getFinishedQty());
            orderRow.getCell(TB_PROJECT).setValue((Object)(mnfOrderInfo.getProject() != null ? mnfOrderInfo.getProject().getNumber() : ""));
            orderRow.getCell(TB_TRACKNUM).setValue((Object)(mnfOrderInfo.getTrackNumber() != null ? mnfOrderInfo.getTrackNumber().getNumber() : ""));
            this.setOrderRowPrecision(orderRow, mnfOrderInfo);
        }
    }

    private void bindingStockData(Map resultMap) throws EASBizException, BOSException {
        int i;
        this.kdStock.removeRows();
        this.kdSimulationOrder.removeRows();
        this.sTStockMap = resultMap;
        ManufactureOrderStockCollection mnfStockCollection = (ManufactureOrderStockCollection)((Object)resultMap.get(STOCK_COLLELCTION_KEY));
        Map idMap = (Map)resultMap.get(ID_MAP_KEY);
        ArrayList<STStockTotalInfo> stockTotalList = new ArrayList<STStockTotalInfo>();
        if (mnfStockCollection != null && mnfStockCollection.size() > 0) {
            for (i = 0; i < mnfStockCollection.size(); ++i) {
                STStockTotalInfo sTStockTotalInfo = new STStockTotalInfo();
                ManufactureOrderStockInfo mnfStockInfo = mnfStockCollection.get(i);
                STStockInfo sTStockInfo = (STStockInfo)resultMap.get((String)idMap.get(mnfStockInfo.getId().toString()));
                sTStockTotalInfo.setsTStockInfo(sTStockInfo);
                sTStockTotalInfo.setManufactureOrderStockInfo(mnfStockInfo);
                stockTotalList.add(sTStockTotalInfo);
            }
        }
        Collections.sort(stockTotalList, (Comparator)StockTransactionEditUI.getStockComparator());
        if (stockTotalList.size() > 0) {
            for (i = 0; i < stockTotalList.size(); ++i) {
                IRow stockRow = this.kdStock.addRow();
                STStockTotalInfo sTStockTotalInfo = (STStockTotalInfo)stockTotalList.get(i);
                ManufactureOrderStockInfo mnfStockInfo = sTStockTotalInfo.getManufactureOrderStockInfo();
                STStockInfo sTStockInfo = sTStockTotalInfo.getsTStockInfo();
                stockRow.getCell(TB_ORDERNUMBER).setValue((Object)(mnfStockInfo.getParent() != null ? mnfStockInfo.getParent().getNumber() : ""));
                if (mnfStockInfo.getParent() != null && !"".equals(mnfStockInfo.getParent())) {
                    stockRow.getCell(TB_PRODUCTNUMBER).setValue((Object)(mnfStockInfo.getParent().getMaterial() != null ? mnfStockInfo.getParent().getMaterial().getNumber() : ""));
                    stockRow.getCell(TB_PRODUCTNAME).setValue((Object)(mnfStockInfo.getParent().getMaterial() != null ? mnfStockInfo.getParent().getMaterial().getName() : ""));
                }
                stockRow.getCell("materialNumber").setValue((Object)(mnfStockInfo.getMaterial() != null ? mnfStockInfo.getMaterial().getNumber() : ""));
                stockRow.getCell("materialName").setValue((Object)(mnfStockInfo.getMaterial() != null ? mnfStockInfo.getMaterial().getName() : ""));
                stockRow.getCell("materialModel").setValue((Object)(mnfStockInfo.getMaterial() != null ? mnfStockInfo.getMaterial().getModel() : ""));
                stockRow.getCell(TB_STOCK_UNIT).setValue((Object)(mnfStockInfo.getUnit() != null ? mnfStockInfo.getUnit().getName() : ""));
                stockRow.getCell(TB_INVQTY).setValue((Object)sTStockInfo.getInvQty());
                stockRow.getCell(TB_STOCKRESERVEQTY).setValue((Object)sTStockInfo.getStockReserveQty());
                stockRow.getCell(TB_DEMANDTIME).setValue((Object)mnfStockInfo.getDemandTime());
                stockRow.getCell(TB_REQQTY).setValue((Object)sTStockInfo.getReqQty());
                stockRow.getCell("receiptQty").setValue((Object)sTStockInfo.getReceiptQty());
                stockRow.getCell("totalReceiptQty").setValue((Object)sTStockInfo.getTotalReceiptQty());
                stockRow.getCell(TB_TRANSFERBATCH).setValue((Object)sTStockInfo.getTransferBatch());
                stockRow.getCell(TB_WAREHOUSE).setValue((Object)(mnfStockInfo.getWarehouse() != null ? mnfStockInfo.getWarehouse().getName() : ""));
                stockRow.getCell(TB_FROMSTORAGEORG).setValue((Object)(mnfStockInfo.getReceiptStroageOrgUnit() != null ? mnfStockInfo.getReceiptStroageOrgUnit().getName() : ""));
                stockRow.getCell(TB_FROMWAREHS).setValue((Object)(mnfStockInfo.getReceiptStock() != null ? mnfStockInfo.getReceiptStock().getName() : ""));
                stockRow.getCell("remark").setValue((Object)mnfStockInfo.getRemark());
                stockRow.getCell("id").setValue((Object)sTStockInfo.getId());
                stockRow.getCell("orderId").setValue((Object)sTStockInfo.getOrderId());
                stockRow.getCell(TB_STOCKENTRYID).setValue((Object)sTStockInfo.getStockEntryId());
                stockRow.getCell(TB_MATERIALID).setValue((Object)sTStockInfo.getMaterialId());
                stockRow.getCell(TB_UNITID).setValue((Object)sTStockInfo.getUnitId());
                stockRow.getCell(TB_BSUNITID).setValue((Object)sTStockInfo.getBsUnitId());
                stockRow.getCell(TB_BSINVQTY).setValue((Object)sTStockInfo.getBsInvQty());
                stockRow.getCell(TB_BSSTOCKRESERVEQTY).setValue((Object)sTStockInfo.getBsStockReserveQty());
                stockRow.getCell(TB_BSREQQTY).setValue((Object)sTStockInfo.getBsReqQty());
                stockRow.getCell(TB_BSRECEIPTQTY).setValue((Object)sTStockInfo.getBsReceiptQty());
                stockRow.getCell(TB_BSTOTALRECEIPTQTY).setValue((Object)sTStockInfo.getBsTotalReceiptQty());
                stockRow.getCell(TB_BSTRANSFERBATCH).setValue((Object)sTStockInfo.getBsTransferBatch());
                stockRow.getCell(TB_WAREHOUSEID).setValue((Object)sTStockInfo.getWarehouseId());
                stockRow.getCell(TB_FROMSTORAGEORGID).setValue((Object)sTStockInfo.getFromStorageOrgId());
                stockRow.getCell(TB_FROMWAREHSID).setValue((Object)sTStockInfo.getFromWarehsId());
                stockRow.getCell(TB_OPERATIONNO).setValue((Object)sTStockInfo.getOperationNo());
                stockRow.getCell(TB_OPERATIONNAME).setValue((Object)sTStockInfo.getOperationName());
                stockRow.getCell(TB_TRANSFERTYPE).setValue((Object)mnfStockInfo.getTransferType());
                stockRow.getCell(TB_PROJECT).setValue(sTStockInfo.getProjectInfo() != null ? sTStockInfo.getProjectInfo().getNumber() : null);
                stockRow.getCell(TB_TRACKNUM).setValue(sTStockInfo.getTrackNumberInfo() != null ? sTStockInfo.getTrackNumberInfo().getNumber() : null);
                this.setStockRowPrecision(stockRow, mnfStockInfo);
            }
        }
    }

    public static Comparator getStockComparator() {
        return new Comparator(){

            public int compare(Object o1, Object o2) {
                STStockTotalInfo mo1 = (STStockTotalInfo)o1;
                STStockTotalInfo mo2 = (STStockTotalInfo)o2;
                if (StockTransactionEditUI.setNullTo0((ObjectBaseInfo)mo1.getManufactureOrderStockInfo().getWarehouse()).compareTo(StockTransactionEditUI.setNullTo0((ObjectBaseInfo)mo2.getManufactureOrderStockInfo().getWarehouse())) == 0) {
                    if (StockTransactionEditUI.setNullTo0((ObjectBaseInfo)mo1.getsTStockInfo().getProjectInfo()).compareTo(StockTransactionEditUI.setNullTo0((ObjectBaseInfo)mo2.getsTStockInfo().getProjectInfo())) == 0) {
                        if (StockTransactionEditUI.setNullTo0((ObjectBaseInfo)mo1.getsTStockInfo().getTrackNumberInfo()).compareTo(StockTransactionEditUI.setNullTo0((ObjectBaseInfo)mo2.getsTStockInfo().getTrackNumberInfo())) == 0) {
                            if (StockTransactionEditUI.setNullTo0((ObjectBaseInfo)mo1.getManufactureOrderStockInfo().getMaterial()).compareTo(StockTransactionEditUI.setNullTo0((ObjectBaseInfo)mo2.getManufactureOrderStockInfo().getMaterial())) == 0) {
                                return StockTransactionEditUI.setNullTo0((ObjectBaseInfo)mo1.getManufactureOrderStockInfo().getParent()).compareTo(StockTransactionEditUI.setNullTo0((ObjectBaseInfo)mo2.getManufactureOrderStockInfo().getParent()));
                            }
                            return StockTransactionEditUI.setNullTo0((ObjectBaseInfo)mo1.getManufactureOrderStockInfo().getMaterial()).compareTo(StockTransactionEditUI.setNullTo0((ObjectBaseInfo)mo2.getManufactureOrderStockInfo().getMaterial()));
                        }
                        return StockTransactionEditUI.setNullTo0((ObjectBaseInfo)mo1.getsTStockInfo().getTrackNumberInfo()).compareTo(StockTransactionEditUI.setNullTo0((ObjectBaseInfo)mo2.getsTStockInfo().getTrackNumberInfo()));
                    }
                    return StockTransactionEditUI.setNullTo0((ObjectBaseInfo)mo1.getsTStockInfo().getProjectInfo()).compareTo(StockTransactionEditUI.setNullTo0((ObjectBaseInfo)mo2.getsTStockInfo().getProjectInfo()));
                }
                return StockTransactionEditUI.setNullTo0((ObjectBaseInfo)mo1.getManufactureOrderStockInfo().getWarehouse()).compareTo(StockTransactionEditUI.setNullTo0((ObjectBaseInfo)mo2.getManufactureOrderStockInfo().getWarehouse()));
            }
        };
    }

    private static String setNullTo0(ObjectBaseInfo info) {
        if (info == null) {
            return "0";
        }
        if (info instanceof CoreBillBaseInfo) {
            return ((CoreBillBaseInfo)info).getNumber();
        }
        if (info instanceof DataBaseInfo) {
            return ((DataBaseInfo)info).getNumber();
        }
        return "0";
    }

    private void bindingBillData(Map resultMap) throws EASBizException, BOSException {
        IRow simulationOrderRow;
        int j;
        int i;
        this.kdSimulationOrder.removeRows();
        this.billMap = resultMap;
        TransferOrderBillCollection toCollection = (TransferOrderBillCollection)resultMap.get(TRANSFER_ORDER_BILL_KEY);
        StockTransferBillCollection stCollection = (StockTransferBillCollection)resultMap.get(STOCK_TRANSFER_BILL_KEY);
        if (toCollection != null && toCollection.size() > 0) {
            for (i = 0; i < toCollection.size(); ++i) {
                TransferOrderBillInfo toInfo = toCollection.get(i);
                TransferOrderBillEntryCollection toEntryCollection = toInfo.getEntry();
                if (toEntryCollection == null || toEntryCollection.size() <= 0) continue;
                for (j = 0; j < toEntryCollection.size(); ++j) {
                    TransferOrderBillEntryInfo toEntryInfo = toEntryCollection.get(j);
                    simulationOrderRow = this.kdSimulationOrder.addRow();
                    simulationOrderRow.getCell("id").setValue((Object)toInfo.getId().toString());
                    simulationOrderRow.getCell(TB_BILL_ENTRY_ID).setValue((Object)toEntryInfo.getId().toString());
                    simulationOrderRow.getCell(TB_STDESTBILLTYPE).setValue((Object)StockTransactionEditUI.getResource("BIZ_TRANSFER_ORDER"));
                    simulationOrderRow.getCell(TB_ISSUESTORAGEORGUNIT).setValue((Object)(toInfo.getIssueStorageOrgUnit() != null ? toInfo.getIssueStorageOrgUnit().getName() : ""));
                    simulationOrderRow.getCell("number").setValue((Object)toInfo.getNumber());
                    simulationOrderRow.getCell(TB_BIZTYPE).setValue((Object)(toInfo.getBizType() != null ? toInfo.getBizType().getName() : ""));
                    simulationOrderRow.getCell(TB_PROJECT).setValue((Object)(toEntryInfo.getProject() != null ? toEntryInfo.getProject().getNumber() : ""));
                    simulationOrderRow.getCell(TB_TRACKNUM).setValue((Object)(toEntryInfo.getTrackNumber() != null ? toEntryInfo.getTrackNumber().getNumber() : ""));
                    simulationOrderRow.getCell(TB_RECEIPTADMINORGUNIT).setValue((Object)(toInfo.getReceiptAdminOrgUnit() != null ? toInfo.getReceiptAdminOrgUnit().getName() : ""));
                    simulationOrderRow.getCell("materialNumber").setValue((Object)(toEntryInfo.getMaterial() != null ? toEntryInfo.getMaterial().getNumber() : ""));
                    simulationOrderRow.getCell("materialName").setValue((Object)(toEntryInfo.getMaterial() != null ? toEntryInfo.getMaterial().getName() : ""));
                    simulationOrderRow.getCell("materialModel").setValue((Object)(toEntryInfo.getMaterial() != null ? toEntryInfo.getMaterial().getModel() : ""));
                    simulationOrderRow.getCell("unit").setValue((Object)(toEntryInfo.getUnit() != null ? toEntryInfo.getUnit().getName() : ""));
                    simulationOrderRow.getCell("qty").setValue((Object)toEntryInfo.getQty());
                    simulationOrderRow.getCell(TB_RECEIPTPLANDATE).setValue((Object)toEntryInfo.getReceiptPlanDate());
                    simulationOrderRow.getCell("remark").setValue((Object)toEntryInfo.getRemark());
                }
            }
        }
        if (stCollection != null && stCollection.size() > 0) {
            for (i = 0; i < stCollection.size(); ++i) {
                StockTransferBillInfo stInfo = stCollection.get(i);
                StockTransferBillEntryCollection stEntryCollection = stInfo.getEntry();
                if (stEntryCollection == null || stEntryCollection.size() <= 0) continue;
                for (j = 0; j < stEntryCollection.size(); ++j) {
                    StockTransferBillEntryInfo stEntryInfo = stEntryCollection.get(j);
                    simulationOrderRow = this.kdSimulationOrder.addRow();
                    simulationOrderRow.getCell("id").setValue((Object)stInfo.getId().toString());
                    simulationOrderRow.getCell(TB_BILL_ENTRY_ID).setValue((Object)stEntryInfo.getId().toString());
                    simulationOrderRow.getCell(TB_STDESTBILLTYPE).setValue((Object)StockTransactionEditUI.getResource("BIZ_STOCK_TRANSFER"));
                    simulationOrderRow.getCell(TB_ISSUESTORAGEORGUNIT).setValue((Object)(stInfo.getIssueStorageOrgUnit() != null ? stInfo.getIssueStorageOrgUnit().getName() : ""));
                    simulationOrderRow.getCell("number").setValue((Object)stInfo.getNumber());
                    simulationOrderRow.getCell(TB_BIZTYPE).setValue((Object)(stInfo.getBizType() != null ? stInfo.getBizType().getName() : ""));
                    simulationOrderRow.getCell(TB_PROJECT).setValue((Object)(stEntryInfo.getProject() != null ? stEntryInfo.getProject().getNumber() : ""));
                    simulationOrderRow.getCell(TB_TRACKNUM).setValue((Object)(stEntryInfo.getTrackNumber() != null ? stEntryInfo.getTrackNumber().getNumber() : ""));
                    simulationOrderRow.getCell(TB_RECEIPTADMINORGUNIT).setValue((Object)(stInfo.getReceiptAdminOrgUnit() != null ? stInfo.getReceiptAdminOrgUnit().getName() : ""));
                    simulationOrderRow.getCell("materialNumber").setValue((Object)(stEntryInfo.getMaterial() != null ? stEntryInfo.getMaterial().getNumber() : ""));
                    simulationOrderRow.getCell("materialName").setValue((Object)(stEntryInfo.getMaterial() != null ? stEntryInfo.getMaterial().getName() : ""));
                    simulationOrderRow.getCell("materialModel").setValue((Object)(stEntryInfo.getMaterial() != null ? stEntryInfo.getMaterial().getModel() : ""));
                    simulationOrderRow.getCell("unit").setValue((Object)(stEntryInfo.getUnit() != null ? stEntryInfo.getUnit().getName() : ""));
                    simulationOrderRow.getCell("qty").setValue((Object)stEntryInfo.getQty());
                    simulationOrderRow.getCell(TB_RECEIPTPLANDATE).setValue((Object)stEntryInfo.getReceiptPlanDate());
                    simulationOrderRow.getCell("remark").setValue((Object)stEntryInfo.getRemark());
                }
            }
        }
        this.setMergeColumn();
    }

    private void setOrderRowPrecision(IRow orderRow, ManufactureOrderInfo mnfOrderInfo) {
        this.setOrderRowPrecision(orderRow, mnfOrderInfo.getMaterial().getId().toString(), mnfOrderInfo.getUnit().getId().toString());
    }

    private void setStockRowPrecision(IRow stockRow, ManufactureOrderStockInfo mnfStockInfo) {
        this.setStockRowPrecision(stockRow, mnfStockInfo.getMaterial().getId().toString(), mnfStockInfo.getUnit().getId().toString());
    }

    private void setOrderRowPrecision(IRow orderRow, String materialId, String unitId) {
        String key = materialId + unitId;
        int precision = 0;
        if (this.precisionMap.containsKey(key)) {
            precision = (Integer)this.precisionMap.get(key);
        }
        SCMClientUtils.changeCellPrecision((IRow)orderRow, (String[])this.orderQtyFieldNames, (int)precision, (boolean)false, (boolean)false);
    }

    private void setStockRowPrecision(IRow stockRow, String materialId, String unitId) {
        String key = materialId + unitId;
        int precision = 0;
        if (this.precisionMap.containsKey(key)) {
            precision = (Integer)this.precisionMap.get(key);
        }
        SCMClientUtils.changeCellPrecision((IRow)stockRow, (String[])this.stockQtyFieldNames, (int)precision, (boolean)false, (boolean)false);
    }

    private BigDecimal getTotalReceiptQtyBySTSourceInfo(STSourceInfo stSourceInfo) {
        if (this.stRule.getSelectedItem() == STRuleEnum.SUIT) {
            return stSourceInfo.getMaxReceiptQty();
        }
        if (this.stRule.getSelectedItem() == STRuleEnum.REINFORCE) {
            return stSourceInfo.getMinReceiptQty();
        }
        return null;
    }

    private BigDecimal getReceiptQtyBySTSourceInfo(ManufactureOrderInfo mnfOrderInfo, IRow currentRow) {
        BigDecimal qty = mnfOrderInfo.getQty();
        if (this.stRule.getSelectedItem() == STRuleEnum.NORMAL) {
            return qty;
        }
        if (this.stRule.getSelectedItem() == STRuleEnum.SUIT) {
            BigDecimal subtrac = qty.subtract(new BigDecimal(currentRow.getCell("totalReceiptQty").getValue().toString()));
            return subtrac.signum() > 0 ? subtrac : ZERO;
        }
        if (this.stRule.getSelectedItem() == STRuleEnum.REINFORCE) {
            return qty;
        }
        return null;
    }

    private void clearRow() {
        this.kdOrder.removeRows();
        this.kdStock.removeRows();
        this.kdSimulationOrder.removeRows();
    }

    private void setSTRuleSel(UIContext uiContext) {
        STRuleEnum stRuleSelEnum = (STRuleEnum)((Object)this.stRule.getSelectedItem());
        uiContext.put((Object)"stRuleSelEnum", (Object)stRuleSelEnum);
    }

    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("bizType.name"));
        sic.add(new SelectorItemInfo("technics.*"));
        sic.add(new SelectorItemInfo("stocks.*"));
        sic.add(new SelectorItemInfo("project.id"));
        sic.add(new SelectorItemInfo("project.number"));
        sic.add(new SelectorItemInfo("project.name"));
        sic.add(new SelectorItemInfo("trackNumber.id"));
        sic.add(new SelectorItemInfo("trackNumber.number"));
        sic.add(new SelectorItemInfo("trackNumber.name"));
        sic.add(new SelectorItemInfo("billType.id"));
        sic.add(new SelectorItemInfo("billType.number"));
        sic.add(new SelectorItemInfo("billType.name"));
        sic.add(new SelectorItemInfo("material.id"));
        sic.add(new SelectorItemInfo("material.number"));
        sic.add(new SelectorItemInfo("material.name"));
        sic.add(new SelectorItemInfo("material.model"));
        sic.add(new SelectorItemInfo("adminOrgUnit.id"));
        sic.add(new SelectorItemInfo("adminOrgUnit.number"));
        sic.add(new SelectorItemInfo("adminOrgUnit.name"));
        sic.add(new SelectorItemInfo("routing.*"));
        sic.add(new SelectorItemInfo("transactionType.name"));
        sic.add(new SelectorItemInfo("dispatcher.name"));
        sic.add(new SelectorItemInfo("storageOrgUnit.id"));
        sic.add(new SelectorItemInfo("storageOrgUnit.number"));
        sic.add(new SelectorItemInfo("storageOrgUnit.name"));
        sic.add(new SelectorItemInfo("unit.id"));
        sic.add(new SelectorItemInfo("unit.number"));
        sic.add(new SelectorItemInfo("unit.name"));
        sic.add(new SelectorItemInfo("unit.qtyPrecision"));
        sic.add(new SelectorItemInfo("unit.isBaseUnit"));
        sic.add(new SelectorItemInfo("unit.coefficient"));
        sic.add(new SelectorItemInfo("baseUnit.number"));
        sic.add(new SelectorItemInfo("baseUnit.name"));
        sic.add(new SelectorItemInfo("baseUnit.qtyPrecision"));
        sic.add(new SelectorItemInfo("baseUnit.isBaseUnit"));
        sic.add(new SelectorItemInfo("baseUnit.coefficient"));
        sic.add(new SelectorItemInfo("warehouse.*"));
        sic.add(new SelectorItemInfo("assistUnit.name"));
        sic.add(new SelectorItemInfo("replaceMaterial.name"));
        sic.add(new SelectorItemInfo("operation.name"));
        sic.add(new SelectorItemInfo("storageOrgUnit1.name"));
        sic.add(new SelectorItemInfo("storageOrgUnit1.id"));
        sic.add(new SelectorItemInfo("stocks.material.id"));
        sic.add(new SelectorItemInfo("stocks.material.number"));
        sic.add(new SelectorItemInfo("stocks.material.name"));
        sic.add(new SelectorItemInfo("stocks.material.model"));
        sic.add(new SelectorItemInfo("stocks.baseUnit.number"));
        sic.add(new SelectorItemInfo("stocks.baseUnit.name"));
        sic.add(new SelectorItemInfo("stocks.baseUnit.qtyPrecision"));
        sic.add(new SelectorItemInfo("stocks.baseUnit.isBaseUnit"));
        sic.add(new SelectorItemInfo("stocks.baseUnit.coefficient"));
        sic.add(new SelectorItemInfo("stocks.unit.id"));
        sic.add(new SelectorItemInfo("stocks.unit.number"));
        sic.add(new SelectorItemInfo("stocks.unit.name"));
        sic.add(new SelectorItemInfo("stocks.unit.qtyPrecision"));
        sic.add(new SelectorItemInfo("stocks.unit.isBaseUnit"));
        sic.add(new SelectorItemInfo("stocks.unit.coefficient"));
        sic.add(new SelectorItemInfo("stocks.warehouse.name"));
        sic.add(new SelectorItemInfo("stocks.warehouse.hasLocation"));
        sic.add(new SelectorItemInfo("stocks.warehouse.number"));
        sic.add(new SelectorItemInfo("stocks.warehouse.id"));
        sic.add(new SelectorItemInfo("stocks.location.id"));
        sic.add(new SelectorItemInfo("stocks.location.number"));
        sic.add(new SelectorItemInfo("stocks.location.name"));
        sic.add(new SelectorItemInfo("stocks.storageOrgUnit.id"));
        sic.add(new SelectorItemInfo("stocks.storageOrgUnit.name"));
        sic.add(new SelectorItemInfo("stocks.storageOrgUnit.number"));
        sic.add(new SelectorItemInfo("stocks.workcenter.number"));
        sic.add(new SelectorItemInfo("stocks.operationNo"));
        sic.add(new SelectorItemInfo("stocks.workcenter.id"));
        sic.add(new SelectorItemInfo("stocks.workcenter.name"));
        sic.add(new SelectorItemInfo("stocks.operation.number"));
        sic.add(new SelectorItemInfo("stocks.operation.name"));
        sic.add(new SelectorItemInfo("stocks.operation.id"));
        sic.add(new SelectorItemInfo("defaultWarehous.name"));
        sic.add(new SelectorItemInfo("defaultWarehous.number"));
        sic.add(new SelectorItemInfo("stocks.storageOrgUnit.name"));
        return sic;
    }

    protected CommonQueryDialog initCommonQueryDialog() throws Exception {
        CommonQueryDialog commonQueryDialog = this.initMyCommonQueryDialog("com.kingdee.eas.base.message", "MsgQuery");
        commonQueryDialog.setWidth(450);
        commonQueryDialog.setHeight(320);
        CustomerQueryPanel conditionPanel = this.getFilterUI();
        try {
            SCMPromptBoxFactory scmF7Factory = new SCMPromptBoxFactory(conditionPanel, this.getMainBizOrgType());
            commonQueryDialog.setPromptBoxFactory((IPromptBoxFactory)scmF7Factory);
            commonQueryDialog.setProcessor((IProcessor)new SCMCommonProcessor());
            commonQueryDialog.addUserPanel((KDPanel)conditionPanel);
        }
        catch (Exception e) {
            this.handUIException(e);
            SysUtil.abort();
        }
        return commonQueryDialog;
    }

    protected CommonQueryDialog initParamDialog() throws Exception {
        CommonQueryDialog paramDialog = this.initMyCommonQueryDialog2("com.kingdee.eas.mm.mo.app", "STCalculateQuery");
        paramDialog.setWidth(450);
        paramDialog.setHeight(320);
        CustomerQueryPanel paramPanel = this.getParamUI();
        try {
            SCMPromptBoxFactory scmF7Factory = new SCMPromptBoxFactory(paramPanel, this.getMainBizOrgType());
            paramDialog.setPromptBoxFactory((IPromptBoxFactory)scmF7Factory);
            paramDialog.setProcessor((IProcessor)new SCMCommonProcessor());
            paramDialog.addUserPanel((KDPanel)paramPanel);
        }
        catch (Exception e) {
            this.handUIException(e);
            SysUtil.abort();
        }
        return paramDialog;
    }

    protected CommonQueryDialog initMyCommonQueryDialog(String queryPackage, String queryName) {
        CommonQueryDialog dialog = new CommonQueryDialog();
        if (this.getUIWindow() == null) {
            dialog.setOwner((Component)this.getUIContext().get("OwnerWindow"));
        } else {
            dialog.setOwner((Component)((Object)this));
        }
        MetaDataPK mainQueryPK = new MetaDataPK(queryPackage, queryName);
        dialog.setQueryObjectPK((IMetaDataPK)mainQueryPK);
        dialog.setParentUIClassName(((Object)((Object)this)).getClass().getName());
        MessageFormat format = BOSLocaleUtil.getMessageFormat((String)"{0}-{1}");
        String title = format.format(new Object[]{StockTransactionEditUI.getResource("MANUFACTURETITLE"), EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Query_Filter")});
        dialog.setTitle(title);
        dialog.setShowSorter(false);
        dialog.setShowFilter(false);
        return dialog;
    }

    protected CommonQueryDialog initMyCommonQueryDialog2(String queryPackage, String queryName) {
        CommonQueryDialog dialog = new CommonQueryDialog();
        if (this.getUIWindow() == null) {
            dialog.setOwner((Component)this.getUIContext().get("OwnerWindow"));
        } else {
            dialog.setOwner((Component)((Object)this));
        }
        this.mainQueryPK2 = new MetaDataPK(queryPackage, queryName);
        dialog.setQueryObjectPK(this.mainQueryPK2);
        dialog.setParentUIClassName(((Object)((Object)this)).getClass().getName());
        dialog.setTitle(this.getUITitle() + " - " + StockTransactionEditUI.getResource("CALCULATE_TITLE"));
        dialog.setShowSorter(false);
        dialog.setShowFilter(false);
        return dialog;
    }

    protected CustomerQueryPanel getFilterUI() throws Exception {
        StockTransactionFilterUI conditionPanel = new StockTransactionFilterUI(this.prmtStorageOrgUnit.getValue());
        return conditionPanel;
    }

    protected CustomerQueryPanel getParamUI() throws Exception {
        StockTransactionParamUI paramPanel = new StockTransactionParamUI(this.kdOrder.getRowCount(), (StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue());
        return paramPanel;
    }

    private void stRuleChanged() {
        this.kdStock.removeRows();
        this.kdSimulationOrder.removeRows();
        this.removeFootRow();
        this.appendFootRow(null);
        if (this.stRule.getSelectedItem() == STRuleEnum.NORMAL) {
            this.initOrderRecepitQty(true);
        } else if (this.stRule.getSelectedItem() == STRuleEnum.SUIT) {
            this.initOrderRecepitQty(false);
        } else if (this.stRule.getSelectedItem() == STRuleEnum.REINFORCE) {
            this.initOrderRecepitQty(false);
        }
        int orderRowCount = this.kdOrder.getRowCount();
        if (orderRowCount > 0) {
            for (int i = 0; i < orderRowCount; ++i) {
                STSourceInfo stSourceInfo = new STSourceInfo();
                ManufactureOrderInfo mnfOrderInfo = new ManufactureOrderInfo();
                IRow orderRow = this.kdOrder.getRow(i);
                stSourceInfo.setMaxReceiptQty(new BigDecimal(orderRow.getCell(TB_MAXRECEIPT_QTY).getValue().toString()));
                stSourceInfo.setMinReceiptQty(new BigDecimal(orderRow.getCell(TB_MINRECEIPT_QTY).getValue().toString()));
                orderRow.getCell("totalReceiptQty").setValue((Object)this.getTotalReceiptQtyBySTSourceInfo(stSourceInfo));
                mnfOrderInfo.setQty(new BigDecimal(orderRow.getCell("qty").getValue().toString()));
                mnfOrderInfo.setTotalSplitQty(new BigDecimal(orderRow.getCell(TB_TOTALPAR_QTY).getValue().toString()));
                mnfOrderInfo.setToStroreQty(new BigDecimal(orderRow.getCell(TB_TOSTRORE_QTY).getValue().toString()));
                mnfOrderInfo.setFinishedQty(new BigDecimal(orderRow.getCell(TB_FINISHED_QTY).getValue().toString()));
                BigDecimal receiptQty = this.getReceiptQtyBySTSourceInfo(mnfOrderInfo, orderRow);
                this.updateReceiptQty(i, receiptQty);
                orderRow.getCell("receiptQty").setValue((Object)receiptQty);
                this.setOrderRowPrecision(orderRow, orderRow.getCell(TB_PRD_ID).getValue().toString(), orderRow.getCell(TB_UNIT_ID).getValue().toString());
            }
        }
        this.panleSourse.setSelectedIndex(0);
    }

    private void updateReceiptQty(int rowIndex, BigDecimal newValue) {
        String orderId = this.kdOrder.getCell(rowIndex, "orderId").getValue().toString();
        this.receiptQtyMap.put(orderId, newValue);
    }

    private void updateStockReceiptQty(int rowIndex, BigDecimal newValue) {
        String id = this.kdStock.getCell(rowIndex, "id").getValue().toString();
        STStockInfo stStockInfo = (STStockInfo)this.sTStockMap.get(id);
        stStockInfo.setReceiptQty(newValue);
    }

    private void setMergeColumn() {
        this.kdSimulationOrder.getGroupManager().group();
        this.kdSimulationOrder.getGroupManager().setGroup(true);
        String[] mergeColumnKeys = this.getMergeColumnKeys();
        if (mergeColumnKeys != null && mergeColumnKeys.length > 0) {
            for (int i = 0; i < mergeColumnKeys.length; ++i) {
                this.kdSimulationOrder.getColumn(mergeColumnKeys[i]).setGroup(true);
                this.kdSimulationOrder.getColumn(mergeColumnKeys[i]).setMergeable(true);
            }
        }
    }

    public String[] getMergeColumnKeys() {
        String[] strArray = new String[]{"number", TB_STDESTBILLTYPE, TB_ISSUESTORAGEORGUNIT, TB_BIZTYPE, TB_RECEIPTADMINORGUNIT};
        return strArray;
    }

    public static String getResource(String strKey) {
        return EASResource.getString((String)"com.kingdee.eas.mm.mo.StockTransactionResource", (String)strKey);
    }

    public void appendFootRow(KDTable table) {
        this.itl.appendFootRow(table);
    }

    public void refreshFootROw(KDTable table) {
        this.itl.refreshFootROw(table);
    }

    public void setTableToSumField() {
        this.setTableToSumField(this.kdStock, this.stockQtyFieldNames);
        this.setTableToSumField(this.kdSimulationOrder, new String[]{"qty"});
    }

    public void setTableToSumField(KDTable table, String[] columnFields) {
        this.itl.setTableToSumField(table, columnFields);
    }

    public void removeFootRow() {
        this.itl.removeFootRow();
    }
}

