/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.mo.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.event.CommitEvent;
import com.kingdee.bos.ctrl.swing.event.CommitListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.mm.common.client.MMUtils;
import com.kingdee.eas.mm.common.client.UIHelper;
import com.kingdee.eas.mm.mo.client.AbstractStockTransactionFilterUI;
import com.kingdee.eas.mm.sfc.BizTypeEnum;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.RangeFilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.scm.common.verify.VerifyItem;
import com.kingdee.eas.scm.common.verify.VerifyType;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class StockTransactionFilterUI
extends AbstractStockTransactionFilterUI {
    private static final long serialVersionUID = 2182202985789480895L;
    private static final Logger logger = CoreUIObject.getLogger(StockTransactionFilterUI.class);
    private StorageOrgUnitInfo storageOrgUnitInfo;
    protected KDBizPromptBox[] disableCommitF7;

    public StockTransactionFilterUI() throws Exception {
        this.disableCommitF7 = new KDBizPromptBox[]{this.PromptBizType, this.kDBizBillNumFrom, this.kDBizBillNumTo, this.prmtProjectNumberFrom, this.prmtProjectNumberTo, this.prmtTrackNumberFrom, this.prmtTrackNumberTo, this.promMaterialNumFrom, this.promMaterialNumTo, this.promOrgUnitFrom, this.promPersonFrom};
    }

    public StockTransactionFilterUI(Object storageOrgUnitInfo) throws Exception {
        this.disableCommitF7 = new KDBizPromptBox[]{this.PromptBizType, this.kDBizBillNumFrom, this.kDBizBillNumTo, this.prmtProjectNumberFrom, this.prmtProjectNumberTo, this.prmtTrackNumberFrom, this.prmtTrackNumberTo, this.promMaterialNumFrom, this.promMaterialNumTo, this.promOrgUnitFrom, this.promPersonFrom};
        this.storageOrgUnitInfo = (StorageOrgUnitInfo)storageOrgUnitInfo;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.setMaterialFilter(this.promMaterialNumFrom);
        this.setMaterialFilter(this.promMaterialNumTo);
        CompositeFilterElement elements = new CompositeFilterElement(0);
        SingleFilterElement mainOrgElement = new SingleFilterElement("storageOrgUnit.number", (Component)this.prmtStorageOrgUnit);
        mainOrgElement.addVerifyItem(new VerifyItem(VerifyType.REQUIRED_TYPE, StockTransactionFilterUI.getResource("Stroage_IsNotNull")));
        mainOrgElement.setDefaultValue((Object)this.storageOrgUnitInfo);
        Date date = SCMClientUtils.getServerDate2();
        this.setNumber(this.kDBizBillNumFrom, this.storageOrgUnitInfo != null ? this.storageOrgUnitInfo.getId().toString() : "");
        this.setNumber(this.kDBizBillNumTo, this.storageOrgUnitInfo != null ? this.storageOrgUnitInfo.getId().toString() : "");
        RangeFilterElement elementBizDate = new RangeFilterElement("bizDate", (Component)this.dateBizDateFrom, (Component)this.dateBizDateTo);
        elementBizDate.addVerifyItem(new VerifyItem(VerifyType.LESS_EQUAL_TYPE, SCMClientUtils.getResource((String)"CompareDate")));
        elements.add((FilterElement)elementBizDate);
        elements.add((FilterElement)new SingleFilterElement("storageOrgUnit.number", (Component)this.prmtStorageOrgUnit));
        SingleFilterElement bizType = new SingleFilterElement("bizType.number", (Component)this.PromptBizType);
        elements.add((FilterElement)bizType);
        elements.add((FilterElement)new RangeFilterElement("number", (Component)this.kDBizBillNumFrom, (Component)this.kDBizBillNumTo));
        UIHelper.registerProjectF7ForEdit((KDBizPromptBox)this.getMainBizOrgF7(), null, (KDBizPromptBox)this.prmtProjectNumberFrom);
        UIHelper.registerProjectF7ForEdit((KDBizPromptBox)this.getMainBizOrgF7(), null, (KDBizPromptBox)this.prmtProjectNumberTo);
        UIHelper.registerTrackNumberF7ForFilter((KDBizPromptBox)this.getMainBizOrgF7(), (KDBizPromptBox)this.prmtTrackNumberFrom);
        UIHelper.registerTrackNumberF7ForFilter((KDBizPromptBox)this.getMainBizOrgF7(), (KDBizPromptBox)this.prmtTrackNumberTo);
        elements.add((FilterElement)new RangeFilterElement("project.number", (Component)this.prmtProjectNumberFrom, (Component)this.prmtProjectNumberTo));
        elements.add((FilterElement)new RangeFilterElement("trackNumber.number", (Component)this.prmtTrackNumberFrom, (Component)this.prmtTrackNumberTo));
        elements.add((FilterElement)new RangeFilterElement("material.number", (Component)this.promMaterialNumFrom, (Component)this.promMaterialNumTo));
        UIHelper.registerBizOrgF7((KDBizPromptBox)this.promOrgUnitFrom, null, null, (OrgType)this.getMainBizOrgType(), (OrgType)OrgType.Admin, (boolean)false);
        elements.add((FilterElement)new SingleFilterElement("adminOrgUnit.number", (Component)this.promOrgUnitFrom));
        elements.add((FilterElement)new SingleFilterElement("dispatcher.number", (Component)this.promPersonFrom));
        RangeFilterElement planBeginDate = new RangeFilterElement("planBeginDate", (Component)this.datePlanStartFrom, (Component)this.datePlanStartTo);
        planBeginDate.setDefaultValue((Object)StockTransactionFilterUI.getDefaultDateRange(date));
        planBeginDate.addVerifyItem(new VerifyItem(VerifyType.LESS_EQUAL_TYPE, SCMClientUtils.getResource((String)"CompareDate")));
        elements.add((FilterElement)planBeginDate);
        RangeFilterElement planEnfDate = new RangeFilterElement("planEndDate", (Component)this.datePlanEndFrom, (Component)this.datePlanEndTo);
        planEnfDate.addVerifyItem(new VerifyItem(VerifyType.LESS_EQUAL_TYPE, SCMClientUtils.getResource((String)"CompareDate")));
        elements.add((FilterElement)planEnfDate);
        elements.add((FilterElement)mainOrgElement);
        this.getFilterManager().setElement((FilterElement)elements);
        this.getFilterManager().setMainOrgElement((FilterElement)mainOrgElement, this.getPropertyOfMainBizOrg());
        this.setNeedMainOrgF7s(new KDBizPromptBox[]{this.promOrgUnitFrom, this.promMaterialNumFrom, this.promMaterialNumTo, this.kDBizBillNumFrom, this.kDBizBillNumTo});
        this.addEntityViewForPerson();
        this.addViewForMOBillnumber();
        this.initNeedMainOrgF7s();
        MMUtils.resetF7CommitParser((KDBizPromptBox[])this.disableCommitF7);
    }

    protected void initNeedMainOrgF7s() {
        this.PromptBizType.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                StockTransactionFilterUI.this.setBizTypeF7(StockTransactionFilterUI.this.PromptBizType);
            }
        });
        this.PromptBizType.addCommitListener(new CommitListener(){

            public void willCommit(CommitEvent e) {
                StockTransactionFilterUI.this.setBizTypeF7(StockTransactionFilterUI.this.PromptBizType);
            }
        });
        this.prmtProjectNumberFrom.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                StockTransactionFilterUI.this.setProjectNumberF7(StockTransactionFilterUI.this.prmtProjectNumberFrom);
            }
        });
        this.prmtProjectNumberFrom.addCommitListener(new CommitListener(){

            public void willCommit(CommitEvent e) {
                StockTransactionFilterUI.this.setProjectNumberF7(StockTransactionFilterUI.this.prmtProjectNumberFrom);
            }
        });
        this.prmtProjectNumberTo.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                StockTransactionFilterUI.this.setProjectNumberF7(StockTransactionFilterUI.this.prmtProjectNumberTo);
            }
        });
        this.prmtProjectNumberTo.addCommitListener(new CommitListener(){

            public void willCommit(CommitEvent e) {
                StockTransactionFilterUI.this.setProjectNumberF7(StockTransactionFilterUI.this.prmtProjectNumberTo);
            }
        });
        this.promPersonFrom.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                StockTransactionFilterUI.this.setPersonF7(StockTransactionFilterUI.this.promPersonFrom);
            }
        });
        this.promPersonFrom.addCommitListener(new CommitListener(){

            public void willCommit(CommitEvent e) {
                StockTransactionFilterUI.this.setPersonF7(StockTransactionFilterUI.this.promPersonFrom);
            }
        });
        this.promOrgUnitFrom.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                StockTransactionFilterUI.this.setAdminDepartmentF7(StockTransactionFilterUI.this.promOrgUnitFrom);
            }
        });
        this.promOrgUnitFrom.addCommitListener(new CommitListener(){

            public void willCommit(CommitEvent e) {
                StockTransactionFilterUI.this.setAdminDepartmentF7(StockTransactionFilterUI.this.promOrgUnitFrom);
            }
        });
    }

    private void setBizTypeF7(KDBizPromptBox bizPromptBox) {
        bizPromptBox.setDisplayFormat("$name$");
        bizPromptBox.setEditFormat("$number$");
        bizPromptBox.setCommitFormat("$number$");
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        HashSet<String> set = new HashSet<String>();
        set.add("401");
        set.add("402");
        set.add("403");
        filter.getFilterItems().add(new FilterItemInfo("number", set, CompareType.INCLUDE));
        ev.setFilter(filter);
        bizPromptBox.setEntityViewInfo(ev);
        bizPromptBox.getQueryAgent().resetRuntimeEntityView();
    }

    private void setProjectNumberF7(KDBizPromptBox bizPromptBox) {
        bizPromptBox.setDisplayFormat("$name$");
        bizPromptBox.setEditFormat("$number$");
        bizPromptBox.setCommitFormat("$number$");
        bizPromptBox.getQueryAgent().resetRuntimeEntityView();
    }

    private void setPersonF7(KDBizPromptBox bizPromptBox) {
        bizPromptBox.setDisplayFormat("$name$");
        bizPromptBox.setEditFormat("$number$");
        bizPromptBox.setCommitFormat("$number$");
        bizPromptBox.getQueryAgent().resetRuntimeEntityView();
    }

    private void setAdminDepartmentF7(KDBizPromptBox bizPromptBox) {
        bizPromptBox.setDisplayFormat("$name$");
        bizPromptBox.setEditFormat("$number$");
        bizPromptBox.setCommitFormat("$number$;$code$");
        bizPromptBox.getQueryAgent().resetRuntimeEntityView();
    }

    private static Timestamp[] getDefaultDateRange(Date d) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 23, 59, 59);
        calendar.set(14, 999);
        Timestamp currDate = new Timestamp(calendar.getTimeInMillis());
        calendar.add(2, 1);
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0);
        calendar.set(14, 0);
        return new Timestamp[]{currDate, new Timestamp(calendar.getTimeInMillis())};
    }

    public void clear() {
        this.getFilterManager().clearAll();
        this.setDefaultValue();
    }

    private void setMaterialFilter(KDBizPromptBox prmtMaterial) {
        String queryInfo = UIHelper.getMaterialPlanQuery((int)this.f7Manager.getF7DisplayMode());
        this.f7Manager.registerBizMaterialF7(prmtMaterial, null, queryInfo, (OrgUnitInfo)this.storageOrgUnitInfo, OrgType.Storage, false, true);
        prmtMaterial.setDisplayFormat("$name$");
        EntityViewInfo eview = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(1), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("Inventory.status", (Object)new Integer(1), CompareType.EQUALS));
        if (this.storageOrgUnitInfo != null) {
            filter.getFilterItems().add(new FilterItemInfo("StorageOrgUnit.id", (Object)this.storageOrgUnitInfo.getId().toString(), CompareType.EQUALS));
        }
        eview.setFilter(filter);
        prmtMaterial.setEntityViewInfo(eview);
    }

    private void addEntityViewForPerson() {
        this.promPersonFrom.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                if (StockTransactionFilterUI.this.prmtStorageOrgUnit.getValue() != null) {
                    StringBuffer sql = new StringBuffer("");
                    sql.append("SELECT a.FtoUnitID FROM T_ORG_UnitRelation AS a ");
                    sql.append("INNER JOIN T_ORG_TypeRelation AS B ");
                    sql.append("ON a.FTypeRelationID = b.FID ");
                    sql.append(" WHERE b.FFromType = 4 AND b.FToType = 0  and a.FfromUnitID = '");
                    sql.append(((OrgUnitInfo)StockTransactionFilterUI.this.prmtStorageOrgUnit.getValue()).getId().toString());
                    sql.append("'");
                    EntityViewInfo ev = new EntityViewInfo();
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("AdminOrgUnit.id", (Object)sql.toString(), CompareType.INNER));
                    ev.setFilter(filter);
                    StockTransactionFilterUI.this.promPersonFrom.setEntityViewInfo(ev);
                } else {
                    StockTransactionFilterUI.this.promPersonFrom.setEntityViewInfo(null);
                }
                StockTransactionFilterUI.this.promPersonFrom.getQueryAgent().resetRuntimeEntityView();
            }
        });
    }

    private void addViewForMOBillnumber() {
        this.kDBizBillNumFrom.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                if (StockTransactionFilterUI.this.prmtStorageOrgUnit.getText() == null) {
                    MsgBox.showInfo((String)StockTransactionFilterUI.getResource("STORAGE_IS_NULL"));
                    SysUtil.abort();
                }
            }
        });
        this.kDBizBillNumTo.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                if (StockTransactionFilterUI.this.prmtStorageOrgUnit.getText() == null) {
                    MsgBox.showInfo((String)StockTransactionFilterUI.getResource("STORAGE_IS_NULL"));
                    SysUtil.abort();
                }
            }
        });
    }

    public static String getResource(String strKey) {
        return EASResource.getString((String)"com.kingdee.eas.mm.mo.ManufactureOrderResource", (String)strKey);
    }

    public static String getResourceStock(String strKey) {
        return EASResource.getString((String)"com.kingdee.eas.mm.mo.StockTransactionResource", (String)strKey);
    }

    protected void setNumber(KDBizPromptBox kDBizBillNum, String storageId) {
        kDBizBillNum.setQueryInfo("com.kingdee.eas.mm.mo.app.F7ManufactureOrderQuery");
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storageId, CompareType.EQUALS));
        HashSet<Integer> baseStatusSet = new HashSet<Integer>();
        baseStatusSet.add(new Integer(4));
        baseStatusSet.add(new Integer(5));
        baseStatusSet.add(new Integer(8));
        filter.getFilterItems().add(new FilterItemInfo("baseStatus", baseStatusSet, CompareType.INCLUDE));
        viewInfo.setFilter(filter);
        kDBizBillNum.setEntityViewInfo(viewInfo);
        kDBizBillNum.setVisible(true);
        kDBizBillNum.setEditFormat("$number$");
        kDBizBillNum.setDisplayFormat("$number$");
        kDBizBillNum.setCommitFormat("$number$");
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmtStorageOrgUnit;
    }

    protected String getPropertyOfMainBizOrg() {
        return "storageOrgUnit.id";
    }

    protected void setDefaultValue() {
        super.setDefaultValue();
        BizTypeInfo type = new BizTypeInfo();
        type.setNumber("401");
        type.setName(BizTypeEnum.NORMAL_PRODUCT.getAlias());
        this.PromptBizType.setValue((Object)type);
    }
}

