/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.mo.client;

import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.base.commonquery.client.IProcessor;
import com.kingdee.eas.base.commonquery.client.IPromptBoxFactory;
import com.kingdee.eas.basedata.master.material.MaterialIssueModeEnum;
import com.kingdee.eas.basedata.master.material.MaterialProvideTypeEnum;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.mm.common.client.KDTableUtils;
import com.kingdee.eas.mm.common.util.EditTableUtil;
import com.kingdee.eas.mm.mo.IStockTransactionEditFacade;
import com.kingdee.eas.mm.mo.ManufactureOrderCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderFactory;
import com.kingdee.eas.mm.mo.ManufactureOrderInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderStockCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderStockInfo;
import com.kingdee.eas.mm.mo.STRuleEnum;
import com.kingdee.eas.mm.mo.StockTransactionEditFacadeFactory;
import com.kingdee.eas.mm.mo.client.AbstractStockTransactionSourceUI;
import com.kingdee.eas.mm.mo.client.StockTransactionFilterUI;
import com.kingdee.eas.scm.common.client.SCMCommonProcessor;
import com.kingdee.eas.scm.common.client.SCMPromptBoxFactory;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class StockTransactionSourceUI
extends AbstractStockTransactionSourceUI {
    private static final long serialVersionUID = 2858690080241204991L;
    private static final Logger logger = CoreUIObject.getLogger(StockTransactionSourceUI.class);
    private StorageOrgUnitInfo storagetOrgUnitInfo;
    private CommonQueryDialog dialog = null;
    private static final String ID = "id";
    private static final String STORAGEORGUNIT = "storageOrgUnit";
    private static final String NUMBER = "number";
    private static final String BASESTATUS = "baseStatus";
    private static final String PROJECTNUMBER = "projectNumber";
    private static final String TRACKNUMBER = "trackNumber";
    private static final String BIZTYPE = "bizType";
    private static final String MATERIAL_NUMBER = "material.number";
    private static final String MATERIAL_NAME = "material.name";
    private static final String MATERIAL_MODEL = "material.model";
    private static final String QTY = "qty";
    private static final String UNIT = "unit";
    private static final String ADMINORGUNIT = "adminOrgUnit";
    private static final String PLANBEGINDATE = "planBeginDate";
    private static final String PLANENDDATE = "planEndDate";
    private static final String[] KDT_DATES = new String[]{"planBeginDate", "planEndDate"};
    private STRuleEnum stRuleSelEnum;
    private ManufactureOrderCollection cocn;
    private List resultList;

    public ManufactureOrderCollection getCocn() {
        return this.cocn;
    }

    public void setCocn(ManufactureOrderCollection cocn) {
        this.cocn = cocn;
    }

    public List getResultList() {
        return this.resultList;
    }

    public void setResultList(List resultList) {
        this.resultList = resultList;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.kdtable.checkParsed();
        this.kdtable.getSelectManager().setSelectMode(10);
        this.btnOK.setEnabled(false);
        this.kdtable.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                int[] index = KDTableUtil.getSelectedRows((KDTable)StockTransactionSourceUI.this.kdtable);
                if (index != null && index.length > 0) {
                    StockTransactionSourceUI.this.btnOK.setEnabled(true);
                }
            }
        });
        Map uictx = this.getUIContext();
        this.storagetOrgUnitInfo = (StorageOrgUnitInfo)uictx.get("storageUnitInfo");
        this.dialog = (CommonQueryDialog)uictx.get("dialog");
        if (uictx.get("stRuleSelEnum") != null) {
            this.stRuleSelEnum = (STRuleEnum)((Object)uictx.get("stRuleSelEnum"));
        }
        if (uictx.get("mococn") != null) {
            ManufactureOrderCollection mcocn = (ManufactureOrderCollection)((Object)uictx.get("mococn"));
            this.setCocn(mcocn);
            this.bindingData();
        }
        EditTableUtil.formatColDate((KDTable)this.kdtable, (String[])KDT_DATES);
    }

    public void onShow() throws Exception {
        super.onShow();
        KDTableUtils.setDefaultFreezeCol((KDTable)this.kdtable, (int)(this.kdtable.getColumnIndex(NUMBER) + 1));
    }

    private void bindingData() {
        this.kdtable.removeRows();
        if (this.getCocn() != null && this.getCocn().size() > 0) {
            ManufactureOrderCollection mcll = this.getCocn();
            for (int i = 0; i < this.cocn.size(); ++i) {
                ManufactureOrderInfo moinfo = mcll.get(i);
                if (moinfo.getStocks() == null || moinfo.getStocks().size() == 0) continue;
                IRow row = this.kdtable.addRow();
                row.getCell(ID).setValue((Object)moinfo.getId());
                row.getCell(STORAGEORGUNIT).setValue((Object)(moinfo.getStorageOrgUnit() != null ? moinfo.getStorageOrgUnit().getName() : ""));
                row.getCell(NUMBER).setValue((Object)moinfo.getNumber());
                row.getCell(BASESTATUS).setValue((Object)moinfo.getBaseStatus());
                row.getCell(PROJECTNUMBER).setValue((Object)(moinfo.getProject() != null ? moinfo.getProject().getNumber() : ""));
                row.getCell(TRACKNUMBER).setValue((Object)(moinfo.getTrackNumber() != null ? moinfo.getTrackNumber().getNumber() : ""));
                row.getCell(BIZTYPE).setValue((Object)(moinfo.getBizType() != null ? moinfo.getBizType().getName() : ""));
                row.getCell(MATERIAL_NUMBER).setValue((Object)(moinfo.getMaterial() != null ? moinfo.getMaterial().getNumber() : ""));
                row.getCell(MATERIAL_NAME).setValue((Object)(moinfo.getMaterial() != null ? moinfo.getMaterial().getName() : ""));
                row.getCell(MATERIAL_MODEL).setValue((Object)(moinfo.getMaterial() != null ? moinfo.getMaterial().getModel() : ""));
                row.getCell(QTY).setValue((Object)moinfo.getQty());
                row.getCell(UNIT).setValue((Object)moinfo.getUnit().getName());
                row.getCell(ADMINORGUNIT).setValue((Object)(moinfo.getAdminOrgUnit() != null ? moinfo.getAdminOrgUnit().getName() : ""));
                row.getCell(PLANBEGINDATE).setValue(moinfo.getPlanBeginDate() != null ? moinfo.getPlanBeginDate() : "");
                row.getCell(PLANENDDATE).setValue(moinfo.getPlanEndDate() != null ? moinfo.getPlanEndDate() : "");
            }
        } else {
            this.btnOK.setEnabled(false);
        }
    }

    @Override
    public void actionOK_actionPerformed(ActionEvent e) throws Exception {
        int stRule = this.stRuleSelEnum.getValue();
        int[] index = KDTableUtil.getSelectedRows((KDTable)this.kdtable);
        ArrayList<String> orderIdList = new ArrayList<String>();
        for (int i = 0; i < index.length; ++i) {
            orderIdList.add(this.kdtable.getRow(index[i]).getCell(ID).getValue().toString());
        }
        IStockTransactionEditFacade facade = StockTransactionEditFacadeFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
        this.resultList = facade.sTSourceList(this.storagetOrgUnitInfo, orderIdList, stRule);
        this.actionExitCurrent_actionPerformed(e);
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.actionExitCurrent_actionPerformed(e);
    }

    @Override
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        if (this.dialog == null) {
            this.dialog = this.initCommonQueryDialog();
        }
        this.dialog.show();
        EntityViewInfo entityViewInfo = this.dialog.getEntityViewInfoResult();
        if (entityViewInfo.getFilter() == null) {
            this.abort();
        }
        FilterInfo filter1 = entityViewInfo.getFilter();
        FilterItemCollection items = filter1.getFilterItems();
        for (int index = items.size() - 1; index >= 0; --index) {
            FilterItemInfo filterInfo = items.get(index);
            if (!filterInfo.getPropertyName().equals("storageOrgUnit.number") || filterInfo.getCompareValue().toString().equals(this.storagetOrgUnitInfo.getNumber())) continue;
            MsgBox.showInfo((String)StockTransactionSourceUI.getResource("STORAGE_ORG_DIFFERENT"));
            SysUtil.abort();
        }
        FilterInfo filter = new FilterInfo();
        HashSet<Integer> baseStatusSet = new HashSet<Integer>();
        baseStatusSet.add(new Integer(4));
        baseStatusSet.add(new Integer(5));
        baseStatusSet.add(new Integer(8));
        filter.getFilterItems().add(new FilterItemInfo(BASESTATUS, baseStatusSet, CompareType.INCLUDE));
        entityViewInfo.getFilter().mergeFilter(filter, "and");
        entityViewInfo.setSelector(this.getSelectors());
        entityViewInfo.getSorter().add(new SorterItemInfo(PLANBEGINDATE));
        entityViewInfo.getSorter().add(new SorterItemInfo(NUMBER));
        entityViewInfo.getSorter().add(new SorterItemInfo(MATERIAL_NUMBER));
        ManufactureOrderCollection mococn = ManufactureOrderFactory.getRemoteInstance().getManufactureOrderCollection(entityViewInfo);
        ManufactureOrderCollection anotherCon = new ManufactureOrderCollection();
        if (mococn != null) {
            block1: for (int i = 0; i < mococn.size(); ++i) {
                ManufactureOrderInfo manufactureOrderInfo = mococn.get(i);
                ManufactureOrderStockCollection mnfStockCollection = manufactureOrderInfo.getStocks();
                if (mnfStockCollection == null || mnfStockCollection.size() <= 0) continue;
                for (int j = 0; j < mnfStockCollection.size(); ++j) {
                    ManufactureOrderStockInfo mnfStockInfo = mnfStockCollection.get(j);
                    boolean isStockAllot = mnfStockInfo.isIsStockAllot();
                    MaterialIssueModeEnum issueMode = mnfStockInfo.getIssueMode();
                    MaterialProvideTypeEnum provideType = mnfStockInfo.getProvideType();
                    if (!isStockAllot || issueMode != MaterialIssueModeEnum.PRODUCEISSMODE || provideType != MaterialProvideTypeEnum.CURRENTORGPROVIDE && provideType != MaterialProvideTypeEnum.SPANORGATTEMPERPROVIDE) continue;
                    anotherCon.add(manufactureOrderInfo);
                    continue block1;
                }
            }
            this.setCocn(anotherCon);
        }
        this.bindingData();
    }

    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("bizType.name"));
        sic.add(new SelectorItemInfo("technics.*"));
        sic.add(new SelectorItemInfo("stocks.*"));
        sic.add(new SelectorItemInfo("project.id"));
        sic.add(new SelectorItemInfo("project.number"));
        sic.add(new SelectorItemInfo("project.name"));
        sic.add(new SelectorItemInfo("trackNumber.id"));
        sic.add(new SelectorItemInfo("trackNumber.number"));
        sic.add(new SelectorItemInfo("trackNumber.name"));
        sic.add(new SelectorItemInfo("billType.id"));
        sic.add(new SelectorItemInfo("billType.number"));
        sic.add(new SelectorItemInfo("billType.name"));
        sic.add(new SelectorItemInfo("material.id"));
        sic.add(new SelectorItemInfo(MATERIAL_NUMBER));
        sic.add(new SelectorItemInfo(MATERIAL_NAME));
        sic.add(new SelectorItemInfo(MATERIAL_MODEL));
        sic.add(new SelectorItemInfo("adminOrgUnit.id"));
        sic.add(new SelectorItemInfo("adminOrgUnit.number"));
        sic.add(new SelectorItemInfo("adminOrgUnit.name"));
        sic.add(new SelectorItemInfo("routing.*"));
        sic.add(new SelectorItemInfo("transactionType.name"));
        sic.add(new SelectorItemInfo("dispatcher.name"));
        sic.add(new SelectorItemInfo("storageOrgUnit.id"));
        sic.add(new SelectorItemInfo("storageOrgUnit.number"));
        sic.add(new SelectorItemInfo("storageOrgUnit.name"));
        sic.add(new SelectorItemInfo("unit.id"));
        sic.add(new SelectorItemInfo("unit.number"));
        sic.add(new SelectorItemInfo("unit.name"));
        sic.add(new SelectorItemInfo("unit.qtyPrecision"));
        sic.add(new SelectorItemInfo("unit.isBaseUnit"));
        sic.add(new SelectorItemInfo("unit.coefficient"));
        sic.add(new SelectorItemInfo("baseUnit.number"));
        sic.add(new SelectorItemInfo("baseUnit.name"));
        sic.add(new SelectorItemInfo("baseUnit.qtyPrecision"));
        sic.add(new SelectorItemInfo("baseUnit.isBaseUnit"));
        sic.add(new SelectorItemInfo("baseUnit.coefficient"));
        sic.add(new SelectorItemInfo("warehouse.*"));
        sic.add(new SelectorItemInfo("assistUnit.name"));
        sic.add(new SelectorItemInfo("replaceMaterial.name"));
        sic.add(new SelectorItemInfo("operation.name"));
        sic.add(new SelectorItemInfo("storageOrgUnit1.name"));
        sic.add(new SelectorItemInfo("storageOrgUnit1.id"));
        sic.add(new SelectorItemInfo("stocks.material.id"));
        sic.add(new SelectorItemInfo("stocks.material.number"));
        sic.add(new SelectorItemInfo("stocks.material.name"));
        sic.add(new SelectorItemInfo("stocks.material.model"));
        sic.add(new SelectorItemInfo("stocks.baseUnit.number"));
        sic.add(new SelectorItemInfo("stocks.baseUnit.name"));
        sic.add(new SelectorItemInfo("stocks.baseUnit.qtyPrecision"));
        sic.add(new SelectorItemInfo("stocks.baseUnit.isBaseUnit"));
        sic.add(new SelectorItemInfo("stocks.baseUnit.coefficient"));
        sic.add(new SelectorItemInfo("stocks.unit.id"));
        sic.add(new SelectorItemInfo("stocks.unit.number"));
        sic.add(new SelectorItemInfo("stocks.unit.name"));
        sic.add(new SelectorItemInfo("stocks.unit.qtyPrecision"));
        sic.add(new SelectorItemInfo("stocks.unit.isBaseUnit"));
        sic.add(new SelectorItemInfo("stocks.unit.coefficient"));
        sic.add(new SelectorItemInfo("stocks.warehouse.name"));
        sic.add(new SelectorItemInfo("stocks.warehouse.hasLocation"));
        sic.add(new SelectorItemInfo("stocks.warehouse.number"));
        sic.add(new SelectorItemInfo("stocks.warehouse.id"));
        sic.add(new SelectorItemInfo("stocks.location.id"));
        sic.add(new SelectorItemInfo("stocks.location.number"));
        sic.add(new SelectorItemInfo("stocks.location.name"));
        sic.add(new SelectorItemInfo("stocks.storageOrgUnit.id"));
        sic.add(new SelectorItemInfo("stocks.storageOrgUnit.name"));
        sic.add(new SelectorItemInfo("stocks.storageOrgUnit.number"));
        sic.add(new SelectorItemInfo("stocks.workcenter.number"));
        sic.add(new SelectorItemInfo("stocks.operationNo"));
        sic.add(new SelectorItemInfo("stocks.workcenter.id"));
        sic.add(new SelectorItemInfo("stocks.workcenter.name"));
        sic.add(new SelectorItemInfo("stocks.operation.number"));
        sic.add(new SelectorItemInfo("stocks.operation.name"));
        sic.add(new SelectorItemInfo("stocks.operation.id"));
        sic.add(new SelectorItemInfo("defaultWarehous.name"));
        sic.add(new SelectorItemInfo("defaultWarehous.number"));
        sic.add(new SelectorItemInfo("stocks.storageOrgUnit.name"));
        return sic;
    }

    protected CommonQueryDialog initCommonQueryDialog() throws Exception {
        CommonQueryDialog commonQueryDialog = this.initMyCommonQueryDialog();
        commonQueryDialog.setWidth(450);
        commonQueryDialog.setHeight(320);
        CustomerQueryPanel conditionPanel = this.getFilterUI();
        try {
            SCMPromptBoxFactory scmF7Factory = new SCMPromptBoxFactory(conditionPanel, this.getMainBizOrgType());
            commonQueryDialog.setPromptBoxFactory((IPromptBoxFactory)scmF7Factory);
            commonQueryDialog.setProcessor((IProcessor)new SCMCommonProcessor());
            commonQueryDialog.addUserPanel((KDPanel)conditionPanel);
        }
        catch (Exception e) {
            this.handUIException(e);
            SysUtil.abort();
        }
        return commonQueryDialog;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    protected CommonQueryDialog initMyCommonQueryDialog() {
        CommonQueryDialog dialog = new CommonQueryDialog();
        if (this.getUIWindow() == null) {
            dialog.setOwner((Component)this.getUIContext().get("OwnerWindow"));
        } else {
            dialog.setOwner((Component)((Object)this));
        }
        MetaDataPK mainQueryPK = new MetaDataPK("com.kingdee.eas.base.message", "MsgQuery");
        dialog.setQueryObjectPK((IMetaDataPK)mainQueryPK);
        dialog.setParentUIClassName("com.kingdee.eas.mm.mo.client.StockTransactionEditUI");
        MessageFormat format = BOSLocaleUtil.getMessageFormat((String)"{0}-{1}");
        String title = format.format(new Object[]{StockTransactionSourceUI.getResource("MANUFACTURETITLE"), EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Query_Filter")});
        dialog.setTitle(title);
        dialog.setShowSorter(false);
        dialog.setShowFilter(false);
        return dialog;
    }

    protected CustomerQueryPanel getFilterUI() throws Exception {
        StockTransactionFilterUI conditionPanel = new StockTransactionFilterUI(this.storagetOrgUnitInfo);
        return conditionPanel;
    }

    public static String getResource(String strKey) {
        return EASResource.getString((String)"com.kingdee.eas.mm.mo.StockTransactionResource", (String)strKey);
    }
}

