/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.mo.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.mo.IManufactureOrder;
import com.kingdee.eas.mm.mo.ManufactureOrderException;
import com.kingdee.eas.mm.mo.ManufactureOrderFactory;
import com.kingdee.eas.mm.mo.app.MOMaterialBackFlush;
import com.kingdee.eas.mm.mo.app.ManufactureRecBillAuditUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.Map;

public class MOBackFlushUtil {
    public static void setIsBackFlush(Context ctx, String tempTable, String billTypeID, boolean isAuditAction) throws EASBizException, BOSException {
        String selectSql = "select FBillID from " + tempTable;
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSql);
        if (rs != null && rs.size() > 0) {
            BillTypeInfo billType = new BillTypeInfo();
            billType.setId(BOSUuid.read((String)billTypeID));
            String[] billIDs = new String[rs.size()];
            try {
                int i = 0;
                while (rs != null && rs.next()) {
                    billIDs[i++] = rs.getString("FBillID");
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
            if (isAuditAction) {
                try {
                    ManufactureRecBillAuditUtil.setManufactureRecBillBackFlushStatus((Context)ctx, (String[])billIDs);
                }
                catch (SQLException e1) {
                    throw new SQLDataException(e1);
                }
                StringBuffer sql1 = new StringBuffer();
                sql1.append("select tt.fid fid,").append("tt.fnumber num from ( ").append("select t.FID,count(t.fid) fcount , ").append(" t.FNumber,").append(" sum(fflag) fflag from ( ").append("select t0.FID,t1.FSourceBillID FOrderID,t0.FNumber,t3.FIsAutoBackFlush fflag ").append("from T_IM_ManufactureRecBill t0  ").append("inner join T_IM_ManufactureRecBillEntry t1 on t0.FID = t1.FParentID  ").append("inner join T_MM_ManufactureOrder t2 on t1.FMANUBILLID = t2.FID  ").append("inner join T_MM_ProductTransactionType t3 on t2.FTransactionTypeID = t3.FID  ").append("where t0.fid in ( select FBillID from ").append(tempTable).append(" )").append(") as t  group by t.fid, ").append(" t.FNumber ").append(") as tt where fcount = fflag ");
                IRowSet rs1 = DbUtil.executeQuery((Context)ctx, (String)sql1.toString());
                if (null != rs1 && rs1.size() > 0) {
                    String[] bills = new String[rs1.size()];
                    String[] numbers = new String[rs1.size()];
                    int k = 0;
                    try {
                        while (rs1.next()) {
                            bills[k] = rs1.getString("fid");
                            numbers[k] = rs1.getString("num");
                            ++k;
                        }
                    }
                    catch (SQLException e) {
                        throw new SQLDataException(e);
                    }
                    ctx.put((Object)"isAutoFlushFromMRB", (Object)Boolean.TRUE);
                    IObjectPK[] logPks = new IObjectPK[bills.length];
                    for (int i = 0; i < bills.length; ++i) {
                        IObjectPK pk;
                        logPks[i] = pk = LogUtil.beginLog((Context)ctx, (String)"_inStockBackFlush", (BOSObjectType)new BOSObjectType("FA1292B4"), (IObjectPK)new ObjectUuidPK(bills[i]), (String)numbers[i], (String)"mm_sfc_backflushmanufacturerecbill");
                    }
                    Map returnMap = MOMaterialBackFlush.backFlush((Context)ctx, (String[])bills, (BillTypeInfo)billType, (boolean)false);
                    if (returnMap != null && returnMap.size() > 0) {
                        StringBuffer sb = new StringBuffer();
                        try {
                            sb.append("\u5012\u51b2\u5931\u8d25\uff0c\u5ba1\u6838\u4e0d\u901a\u8fc7\uff01");
                            throw new ManufactureOrderException(ManufactureOrderException.BACKFLUSH_INSTOCK_ERROR_CHECK, new String[]{sb.toString()});
                        }
                        catch (Exception e) {
                            throw new ManufactureOrderException(ManufactureOrderException.BACKFLUSH_INSTOCK_ERROR_CHECK, new String[]{sb.toString()});
                        }
                    }
                    for (IObjectPK pk : logPks) {
                        LogUtil.afterLog((Context)ctx, (IObjectPK)pk);
                    }
                }
            } else {
                IManufactureOrder moBiz = ManufactureOrderFactory.getLocalInstance(ctx);
                ctx.put((Object)"isAutoFlushFromMRB", (Object)Boolean.TRUE);
                moBiz.materialUnBackFlush(billIDs);
            }
        }
    }
}

