/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.mo.util;

import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.mm.basedata.CSEntrustTypeEnum;
import com.kingdee.eas.mm.mo.MOStockDeptCalcVO;
import com.kingdee.eas.mm.mo.ManufactureOrderInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderStockInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderTechnicsCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderTechnicsInfo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MOStockUtil {
    public static AdminOrgUnitInfo getDefaultPickDept(AdminOrgUnitInfo moAdminOrgUnitInfo, CSEntrustTypeEnum technicsEntrustType, AdminOrgUnitInfo technicsAdminOrgUnitInfo) {
        AdminOrgUnitInfo defaultPickDept = null;
        if (technicsEntrustType.equals((Object)CSEntrustTypeEnum.NONE)) {
            defaultPickDept = technicsAdminOrgUnitInfo;
        } else if (technicsEntrustType.equals((Object)CSEntrustTypeEnum.INNERCOOPERATE)) {
            defaultPickDept = moAdminOrgUnitInfo;
        } else if (technicsEntrustType.equals((Object)CSEntrustTypeEnum.OPERATIONENTRUST)) {
            defaultPickDept = technicsAdminOrgUnitInfo;
        }
        return defaultPickDept;
    }

    public static Map getStockPickDept(List moStockDeptCalcVOList) {
        if (moStockDeptCalcVOList == null || moStockDeptCalcVOList.size() <= 0) {
            return null;
        }
        HashMap<Integer, AdminOrgUnitInfo> rtnMap = new HashMap<Integer, AdminOrgUnitInfo>();
        for (int curIdx = 0; curIdx < moStockDeptCalcVOList.size(); ++curIdx) {
            MOStockDeptCalcVO curVO = (MOStockDeptCalcVO)moStockDeptCalcVOList.get(curIdx);
            AdminOrgUnitInfo defautStockDept = MOStockUtil.getDefaultPickDept(curVO.getMoAdminOrgUnitInfo(), curVO.getTechnicsEntrustType(), curVO.getTechnicsAdminOrgUnitInfo());
            rtnMap.put(new Integer(curVO.getOpNum()), defautStockDept);
        }
        return rtnMap;
    }

    public static AdminOrgUnitInfo getDefaultPickDept(ManufactureOrderInfo orderInfo, ManufactureOrderStockInfo orderStockInfo) {
        if (orderStockInfo == null || orderInfo == null) {
            return null;
        }
        AdminOrgUnitInfo moAdminOrgUnitInfo = orderInfo.getAdminOrgUnit();
        ManufactureOrderTechnicsInfo ownedTechnicsInfo = MOStockUtil.getOwnedTechnicsInfo(orderInfo, orderStockInfo);
        AdminOrgUnitInfo technicsAdminOrgUnitInfo = ownedTechnicsInfo == null ? null : ownedTechnicsInfo.getAdminOrgUnit();
        CSEntrustTypeEnum technicsEntrustType = ownedTechnicsInfo == null ? CSEntrustTypeEnum.NONE : ownedTechnicsInfo.getEntrustType();
        return MOStockUtil.getDefaultPickDept(moAdminOrgUnitInfo, technicsEntrustType, technicsAdminOrgUnitInfo);
    }

    public static ManufactureOrderTechnicsInfo getOwnedTechnicsInfo(ManufactureOrderInfo orderInfo, ManufactureOrderStockInfo orderStockInfo) {
        if (orderStockInfo == null || orderInfo == null) {
            return null;
        }
        ManufactureOrderTechnicsCollection orderTechnics = orderInfo.getTechnics();
        if (orderTechnics == null || orderTechnics.size() <= 0) {
            return null;
        }
        ManufactureOrderTechnicsInfo ownedTechnicsInfo = null;
        for (int index = 0; index < orderTechnics.size(); ++index) {
            ManufactureOrderTechnicsInfo technicsInfo = orderTechnics.get(index);
            if (technicsInfo.getOperationNo() != orderStockInfo.getOperationNo()) continue;
            ownedTechnicsInfo = technicsInfo;
            break;
        }
        return ownedTechnicsInfo;
    }
}

