/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.mo.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.framework.config.ConfigControllerFactory;
import com.kingdee.eas.scm.common.ISMSDBillConfig;
import com.kingdee.eas.scm.common.SMSDBillConfigCollection;
import com.kingdee.eas.scm.common.SMSDBillConfigFactory;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class UIhandleUtil {
    public static void handleSMSDBillConfig(Context context, String currentUserId, String uiName) throws BOSException {
        ISMSDBillConfig iSMSDBillConfig = SMSDBillConfigFactory.getLocalInstance((Context)context);
        SMSDBillConfigCollection configCol = iSMSDBillConfig.getSMSDBillConfigCollection(UIhandleUtil.getConfigTypeEntityView(uiName, "noZeroShow", currentUserId, true));
        configCol = iSMSDBillConfig.getSMSDBillConfigCollection(UIhandleUtil.getConfigTypeEntityView(uiName, "IS_SHOW_SUMROW", currentUserId, true));
    }

    public static List findBotpBill(Context context, String srcObjectID, String srcentityid, boolean isUp) throws BOSException {
        ArrayList<String> list = new ArrayList<String>();
        StringBuffer selectSql = new StringBuffer();
        Connection con = null;
        PreparedStatement batchStatement = null;
        ResultSet rs = null;
        if (!isUp) {
            selectSql.append("select distinct fdestentityid from t_bot_Relation ").append("where FSrcObjectID =? and fsrcentityid=? ");
        } else {
            selectSql.append("select distinct fsrcentityid from t_bot_Relation ").append("where FdestObjectID =? and fdestentityid=? ");
        }
        try {
            con = EJBFactory.getConnection((Context)context);
            batchStatement = con.prepareStatement(selectSql.toString());
            batchStatement.setString(1, srcObjectID);
            batchStatement.setString(2, srcentityid);
            rs = batchStatement.executeQuery();
            while (rs.next()) {
                list.add(rs.getString(1));
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, batchStatement, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)batchStatement, (Connection)con);
        return list;
    }

    public static void handleListUICfg(Context context, String currentUserId, String currentUserOrgId, String uiName) throws BOSException {
        Object obj = DynamicObjectFactory.getLocalInstance((Context)context).invoke(BOSObjectType.create((String)"7F9AC9C0"), "getListUIConfigure", new Object[]{currentUserId, currentUserOrgId, uiName});
        obj = DynamicObjectFactory.getLocalInstance((Context)context).invoke(BOSObjectType.create((String)"6F3DB90B"), "getListUICfgId", new Object[]{currentUserOrgId, uiName});
    }

    public static void handleActionTrace(Context context, String billid, String bosType, boolean isUp) throws Exception {
        String currentUserId = ContextUtil.getCurrentUserInfo((Context)context).getId().toString();
        String currentUserOrgId = ContextUtil.getCurrentOrgUnit((Context)context).getId().toString();
        currentUserId = StringUtils.isEmpty((String)currentUserId) ? "" : currentUserId;
        currentUserOrgId = StringUtils.isEmpty((String)currentUserOrgId) ? "" : currentUserOrgId;
        List list = UIhandleUtil.findBotpBill(context, billid, bosType, isUp);
        EntityObjectInfo mainEO = null;
        StringBuffer ui = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            mainEO = MetaDataLoaderFactory.getMetaDataLoader((Context)context).getEntity(BOSObjectType.create((String)((String)list.get(i))));
            ui.append(mainEO.getObjectValueClass().subSequence(0, mainEO.getObjectValueClass().length() - 4));
            UIhandleUtil.handleListUICfg(context, currentUserId, currentUserOrgId, mainEO.getExtendedProperty("listUI"));
            UIhandleUtil.handleSMSDBillConfig(context, currentUserId, mainEO.getExtendedProperty("listUI"));
            ui.setLength(0);
        }
    }

    private static EntityViewInfo getConfigTypeEntityView(String className, String configTypeValue, String currentUserId, boolean defaultValue) {
        FilterInfo filter = new FilterInfo();
        FilterItemInfo billClassNameFilter = new FilterItemInfo("billClassName", (Object)className, CompareType.EQUALS);
        FilterItemInfo userIDFilter = new FilterItemInfo("userID", (Object)currentUserId, CompareType.EQUALS);
        FilterItemInfo configTypeFilter = new FilterItemInfo("configType", (Object)configTypeValue, CompareType.EQUALS);
        filter.getFilterItems().add(billClassNameFilter);
        filter.getFilterItems().add(userIDFilter);
        filter.getFilterItems().add(configTypeFilter);
        EntityViewInfo ev = new EntityViewInfo();
        ev.setFilter(filter);
        return ev;
    }

    public static void handleEditUIUserConfigData(Context context, String uiName) throws BOSException {
        String currentUserId = ContextUtil.getCurrentUserInfo((Context)context).getId().toString();
        String currentUserOrgId = ContextUtil.getCurrentOrgUnit((Context)context).getId().toString();
        currentUserId = StringUtils.isEmpty((String)currentUserId) ? "" : currentUserId;
        currentUserOrgId = StringUtils.isEmpty((String)currentUserOrgId) ? "" : currentUserOrgId;
        ConfigControllerFactory.getLocalInstance((Context)context).getUserConfigData("SubmitAndAdd", uiName);
        ConfigControllerFactory.getLocalInstance((Context)context).getUserConfigData("SubmitAndPrint", uiName);
        ConfigControllerFactory.getLocalInstance((Context)context).saveUserConfigData("enterToNextRow", uiName, "true");
        ConfigControllerFactory.getLocalInstance((Context)context).getUserConfigData("enterToNextRow", uiName);
        Object obj = DynamicObjectFactory.getLocalInstance((Context)context).invoke(BOSObjectType.create((String)"7F9AC9C0"), "getEditUIConfigure", new Object[]{currentUserId, currentUserOrgId, uiName});
        obj = DynamicObjectFactory.getLocalInstance((Context)context).invoke(BOSObjectType.create((String)"6F3DB90B"), "getEditUICfgId", new Object[]{currentUserOrgId, uiName});
    }
}

