/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.mo.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.master.material.MaterialLeadTimeTypeEnum;
import com.kingdee.eas.basedata.master.material.MaterialPlanCollection;
import com.kingdee.eas.basedata.master.material.MaterialPlanFactory;
import com.kingdee.eas.basedata.master.material.MaterialPlanInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.basedata.FactoryCalendarFactory;
import com.kingdee.eas.mm.basedata.IFactoryCalendar;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;

public class calculateDateUtil {
    private IFactoryCalendar mmCalendarFactory = null;

    public Date getDate(Context ctx, String storageOrgID, String materialID, Date startDate, Date endDate, boolean startOrEnd, BigDecimal planQty) throws BOSException, EASBizException {
        Date result = null;
        MaterialPlanInfo plan = null;
        if (ctx != null) {
            plan = calculateDateUtil.getServerMaterialPlanInfo(ctx, storageOrgID, materialID);
            this.mmCalendarFactory = FactoryCalendarFactory.getLocalInstance((Context)ctx);
        } else {
            plan = calculateDateUtil.getClientMaterialPlanInfo(storageOrgID, materialID);
            this.mmCalendarFactory = FactoryCalendarFactory.getRemoteInstance();
        }
        MaterialLeadTimeTypeEnum leanTimeType = plan.getLeadTimeType();
        result = leanTimeType == MaterialLeadTimeTypeEnum.FIXBATCHTYPE ? calculateDateUtil.getFixTypeDate(ctx, startDate, endDate, plan, startOrEnd, planQty, storageOrgID) : (leanTimeType == MaterialLeadTimeTypeEnum.CHANGEBATCHTYPE ? calculateDateUtil.getChangeTypeDate(ctx, startDate, endDate, plan, startOrEnd, planQty, storageOrgID) : calculateDateUtil.getFixTypeDate(ctx, startDate, endDate, plan, startOrEnd, planQty, storageOrgID));
        Calendar calDate = Calendar.getInstance();
        calDate.set(11, 0);
        calDate.set(12, 0);
        calDate.set(13, 0);
        calDate.set(14, 0);
        Date nowDate = new Date(calDate.getTimeInMillis());
        if (result == null) {
            result = nowDate;
        }
        if (endDate != null && startDate == null && result.before(nowDate)) {
            return this.setWorkDate(this.mmCalendarFactory, storageOrgID, nowDate, false);
        }
        return result;
    }

    private Timestamp setWorkDate(IFactoryCalendar workCalendarFactory, String orgID, Date date, boolean isForward) throws BOSException, EASBizException {
        int direct = 1;
        int daycount = 1;
        if (!isForward) {
            direct = 2;
            daycount = 0;
        }
        Calendar calendar1 = Calendar.getInstance();
        calendar1.setTime(date);
        Calendar calendar2 = Calendar.getInstance();
        Date workDate = workCalendarFactory.findDateFromFCalendar(orgID, date, direct, daycount, 2);
        if (workDate != null) {
            calendar2.setTime(workDate);
        } else {
            calendar2.setTime(date);
            calendar2.set(10, calendar1.get(10));
            calendar2.set(12, calendar1.get(12));
            calendar2.set(13, calendar1.get(13));
        }
        return new Timestamp(calendar2.getTimeInMillis());
    }

    private static MaterialPlanInfo getServerMaterialPlanInfo(Context ctx, String orgId, String materialID) throws BOSException {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
        selectorItemCollection.add(new SelectorItemInfo("leadTimeType"));
        selectorItemCollection.add(new SelectorItemInfo("backwardProcessTime"));
        selectorItemCollection.add(new SelectorItemInfo("forwardProcessTime"));
        selectorItemCollection.add(new SelectorItemInfo("changeBatch"));
        selectorItemCollection.add(new SelectorItemInfo("changeLeadTime"));
        selectorItemCollection.add(new SelectorItemInfo("produceLeadTime"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialID, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgId, CompareType.EQUALS));
        entityViewInfo.setFilter(filterInfo);
        entityViewInfo.setSelector(selectorItemCollection);
        MaterialPlanCollection materialPlanCollection = MaterialPlanFactory.getLocalInstance((Context)ctx).getMaterialPlanCollection(entityViewInfo);
        if (materialPlanCollection != null && materialPlanCollection.size() > 0) {
            MaterialPlanInfo materialPlanInfo = materialPlanCollection.get(0);
            return materialPlanInfo;
        }
        return null;
    }

    private static MaterialPlanInfo getClientMaterialPlanInfo(String orgId, String materialID) throws BOSException {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
        selectorItemCollection.add(new SelectorItemInfo("leadTimeType"));
        selectorItemCollection.add(new SelectorItemInfo("backwardProcessTime"));
        selectorItemCollection.add(new SelectorItemInfo("forwardProcessTime"));
        selectorItemCollection.add(new SelectorItemInfo("changeBatch"));
        selectorItemCollection.add(new SelectorItemInfo("changeLeadTime"));
        selectorItemCollection.add(new SelectorItemInfo("produceLeadTime"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialID, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgId, CompareType.EQUALS));
        entityViewInfo.setFilter(filterInfo);
        entityViewInfo.setSelector(selectorItemCollection);
        MaterialPlanCollection materialPlanCollection = MaterialPlanFactory.getRemoteInstance().getMaterialPlanCollection(entityViewInfo);
        if (materialPlanCollection != null && materialPlanCollection.size() > 0) {
            MaterialPlanInfo materialPlanInfo = materialPlanCollection.get(0);
            return materialPlanInfo;
        }
        return null;
    }

    private static Date getFixTypeDate(Context ctx, Date startDate, Date endDate, MaterialPlanInfo plan, boolean startOrEnd, BigDecimal planQty, String orgId) throws BOSException {
        Date result = null;
        if (startOrEnd) {
            int calculateDay = plan.getProduceLeadTime() + plan.getForwardProcessTime() + plan.getBackwardProcessTime();
            result = calculateDateUtil.getWorkDate(ctx, orgId, calculateDay, 1, startDate);
        } else {
            int calculateDay = plan.getProduceLeadTime() + plan.getForwardProcessTime() + plan.getBackwardProcessTime();
            result = calculateDateUtil.getWorkDate(ctx, orgId, calculateDay, 2, endDate);
        }
        return result;
    }

    private static Date getChangeTypeDate(Context ctx, Date startDate, Date endDate, MaterialPlanInfo plan, boolean startOrEnd, BigDecimal planQty, String orgId) throws BOSException {
        Date result = null;
        int changeBatch = 1;
        if (plan.getChangeBatch() != 0) {
            changeBatch = plan.getChangeBatch();
        }
        BigDecimal qty = planQty.divide(new BigDecimal(changeBatch), 8, 0);
        if (startOrEnd) {
            int calculateDay = plan.getProduceLeadTime() + plan.getForwardProcessTime() + plan.getBackwardProcessTime() + qty.multiply(new BigDecimal(plan.getChangeLeadTime())).setScale(0, 0).intValue();
            result = calculateDateUtil.getWorkDate(ctx, orgId, calculateDay, 1, startDate);
        } else {
            int calculateDay = plan.getProduceLeadTime() + plan.getForwardProcessTime() + plan.getBackwardProcessTime() + qty.multiply(new BigDecimal(plan.getChangeLeadTime())).setScale(0, 0).intValue();
            result = calculateDateUtil.getWorkDate(ctx, orgId, calculateDay, 2, endDate);
        }
        return result;
    }

    private static Date getWorkDate(Context ctx, String orgId, int day, int addOrSub, Date date) throws BOSException {
        Date result = null;
        IFactoryCalendar ifactoryCalendar = null;
        ifactoryCalendar = ctx != null ? FactoryCalendarFactory.getLocalInstance((Context)ctx) : FactoryCalendarFactory.getRemoteInstance();
        try {
            result = ifactoryCalendar.findDateFromFCalendar(orgId, date, addOrSub, day, 2);
        }
        catch (EASBizException eASBizException) {
            // empty catch block
        }
        return result;
    }

    public static Date thisMonth() {
        Date now = SCMClientUtils.getServerDate2();
        Calendar localTime = Calendar.getInstance();
        localTime.setTime(now);
        localTime.set(5, 1);
        return localTime.getTime();
    }

    public static Date thisMonthEnd() {
        Date now = SCMClientUtils.getServerDate2();
        Calendar localTime = Calendar.getInstance();
        localTime.setTime(now);
        localTime.set(2, localTime.get(2) + 1);
        localTime.set(5, 0);
        return localTime.getTime();
    }

    public static Date thisSeason() {
        Date now = SCMClientUtils.getServerDate2();
        Calendar localTime = Calendar.getInstance();
        localTime.setTime(now);
        int month = localTime.get(2) + 1;
        int seasonMonth = 0;
        if (month >= 1 && month <= 3) {
            seasonMonth = 0;
        }
        if (month >= 4 && month <= 6) {
            seasonMonth = 3;
        }
        if (month >= 7 && month <= 9) {
            seasonMonth = 6;
        }
        if (month >= 10 && month <= 12) {
            seasonMonth = 9;
        }
        localTime.set(2, seasonMonth);
        localTime.set(5, 1);
        return localTime.getTime();
    }

    public static Date thisSeasonEnd() {
        Date now = SCMClientUtils.getServerDate2();
        Calendar localTime = Calendar.getInstance();
        localTime.setTime(now);
        int month = localTime.get(2) + 1;
        int seasonMonth = 0;
        int seasonDate = 0;
        if (month >= 1 && month <= 3) {
            seasonMonth = 2;
            seasonDate = 31;
        }
        if (month >= 4 && month <= 6) {
            seasonMonth = 5;
            seasonDate = 30;
        }
        if (month >= 7 && month <= 9) {
            seasonMonth = 8;
            seasonDate = 30;
        }
        if (month >= 10 && month <= 12) {
            seasonMonth = 11;
            seasonDate = 31;
        }
        localTime.set(2, seasonMonth);
        localTime.set(5, seasonDate);
        return localTime.getTime();
    }

    public static Date thisYear() {
        Date now = SCMClientUtils.getServerDate2();
        Calendar localTime = Calendar.getInstance();
        localTime.setTime(now);
        localTime.set(2, 0);
        localTime.set(5, 1);
        return localTime.getTime();
    }

    public static Date thisYearEnd() {
        Date now = SCMClientUtils.getServerDate2();
        Calendar localTime = Calendar.getInstance();
        localTime.setTime(now);
        localTime.set(2, 11);
        localTime.set(5, 31);
        return localTime.getTime();
    }

    public static boolean leapYear(int year) {
        boolean leap = year % 4 == 0 ? (year % 100 == 0 ? year % 400 == 0 : true) : false;
        return leap;
    }
}

