/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.pdm;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.AbstractBaseObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.mm.pdm.ActionCommonException;
import com.kingdee.eas.mm.pdm.ActionResult;
import com.kingdee.eas.mm.pdm.ActionResultEnum;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ActionResults
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -4259484175635469607L;
    private static final ActionResult SUCCESS = new ActionResult(ActionResultEnum.SUCCESS, "");
    private static final String STRING_TYPE = "STRING";
    private static final String PK_TYPE = "PK";
    private static final String VO_TYPE = "OBJECTVALUE";
    private String idType = "STRING";
    protected HashMap resultMap;
    private List<String> newObjectIdList = new ArrayList<String>();
    private List<CoreBillBaseInfo> originalInfoList = new ArrayList<CoreBillBaseInfo>();
    private List<CoreBillBaseInfo> newInfoList = new ArrayList<CoreBillBaseInfo>();
    private transient IObjectCollection objCollection = null;
    public static final String NEWID = "NEWID";
    private boolean isNewId = false;
    private int errorCount = 0;

    public ActionResults(String idType) {
        this.idType = idType;
        this.resultMap = new HashMap();
    }

    public ActionResults(String idType, boolean isNewId) {
        this(idType);
        this.isNewId = isNewId;
    }

    public ActionResults() {
        this.resultMap = new HashMap();
    }

    private static String getIdType(Object o) {
        if (o instanceof IObjectPK) {
            return PK_TYPE;
        }
        if (o instanceof String) {
            return STRING_TYPE;
        }
        if (o instanceof IObjectValue) {
            return VO_TYPE;
        }
        throw new IllegalArgumentException("The ID parameter should be IObjectPK or String type.");
    }

    public static ActionResults populateActionResults(Object[] entries) {
        ActionResults results;
        block5: {
            String idType;
            block7: {
                block6: {
                    results = null;
                    if (entries == null || entries.length == 0) {
                        return null;
                    }
                    if (entries == null || entries.length <= 0) break block5;
                    idType = ActionResults.getIdType(entries[0]);
                    results = new ActionResults(idType);
                    if (!idType.equals(PK_TYPE)) break block6;
                    int size = entries.length;
                    for (int i = 0; i < size; ++i) {
                        results.addSuccess((IObjectPK)entries[i]);
                    }
                    break block5;
                }
                if (!idType.equals(STRING_TYPE)) break block7;
                int size = entries.length;
                for (int i = 0; i < size; ++i) {
                    results.addSuccess((String)entries[i]);
                }
                break block5;
            }
            if (!idType.equals(VO_TYPE)) break block5;
            int size = entries.length;
            for (int i = 0; i < size; ++i) {
                IObjectValue objValue = (IObjectValue)entries[i];
                BOSUuid pk = (BOSUuid)objValue.get(objValue.getPKField());
                if (pk == null) {
                    results = new ActionResults(idType, true);
                    results.addSuccess(NEWID);
                    continue;
                }
                results.addSuccess(pk.toString());
            }
        }
        return results;
    }

    public void add(String id, ActionResultEnum actionResult, String message) {
        if (actionResult.equals(ActionResultEnum.ERROR)) {
            this.addError(id, message);
        } else {
            this.addSuccess(id);
        }
    }

    public void addSuccess(String id) {
        this.resultMap.put(id, SUCCESS);
    }

    public void addSuccess(IObjectPK id) {
        this.resultMap.put(id, SUCCESS);
    }

    public void addError(String id, String message) {
        Object key = this.getAppropriateKey(id);
        ActionResult result = (ActionResult)this.resultMap.get(key);
        this.putError(result, key, message);
        ++this.errorCount;
    }

    private void putError(ActionResult result, Object key, String message) {
        if (result != null && ActionResultEnum.ERROR.equals(result.getResult())) {
            String msgExist = result.getMessage();
            if (!result.isHasMultiErrors() && result.getException() != null) {
                msgExist = result.getException().getMessage();
            }
            if (msgExist != null) {
                StringBuffer sb = new StringBuffer();
                if (!result.isHasMultiErrors()) {
                    sb.append("[");
                }
                sb.append(msgExist);
                if (!result.isHasMultiErrors()) {
                    sb.append("]");
                }
                sb.append("[");
                sb.append(message);
                sb.append("]");
                result.setMessage(sb.toString());
                result.setHasMultiErrors(true);
            }
        } else {
            this.resultMap.put(key, new ActionResult(ActionResultEnum.ERROR, message));
        }
    }

    private Object getAppropriateKey(Object id) {
        Object pk = id instanceof String ? (this.idType.equals(STRING_TYPE) || this.idType.equals(VO_TYPE) ? id : new ObjectUuidPK(BOSUuid.read((String)((String)id)))) : (this.idType.equals(STRING_TYPE) || this.idType.equals(VO_TYPE) ? ((IObjectPK)id).toString() : id);
        return pk;
    }

    public void addError(String id, Exception exception) {
        Object key = this.getAppropriateKey(id);
        ActionResult result = (ActionResult)this.resultMap.get(key);
        if (result != null && result.isHasMultiErrors()) {
            this.putError(result, key, exception.getMessage());
            result.addException(exception);
        } else {
            this.resultMap.put(this.getAppropriateKey(id), new ActionResult(ActionResultEnum.ERROR, exception));
        }
        ++this.errorCount;
    }

    public void addErrors(List idList, String message) {
        if (idList == null || idList.size() <= 0) {
            return;
        }
        ActionResult errorResult = new ActionResult(ActionResultEnum.ERROR, message);
        int size = idList.size();
        for (int i = 0; i < size; ++i) {
            this.resultMap.put(this.getAppropriateKey(idList.get(i)), errorResult);
        }
    }

    public void addErrors(String[] ids, String message) {
        if (ids == null || ids.length <= 0) {
            return;
        }
        ActionResult errorResult = new ActionResult(ActionResultEnum.ERROR, message);
        int size = ids.length;
        for (int i = 0; i < size; ++i) {
            this.resultMap.put(this.getAppropriateKey(ids[i]), errorResult);
        }
    }

    public ActionResult getActionResult(Object id) {
        if (id == null) {
            return SUCCESS;
        }
        if (this.isNewId) {
            return (ActionResult)this.resultMap.get(NEWID);
        }
        if (id instanceof String) {
            if (this.idType.equals(STRING_TYPE) || this.idType.equals(VO_TYPE)) {
                return (ActionResult)this.resultMap.get(id);
            }
            if (this.idType.equals(PK_TYPE)) {
                for (Map.Entry entry : this.resultMap.entrySet()) {
                    IObjectPK pk = (IObjectPK)entry.getKey();
                    if (!pk.toString().equals(id)) continue;
                    return (ActionResult)entry.getValue();
                }
            }
        } else {
            if (this.idType.equals(STRING_TYPE) || this.idType.equals(VO_TYPE)) {
                return (ActionResult)this.resultMap.get(((IObjectPK)id).toString());
            }
            if (this.idType.equals(PK_TYPE)) {
                return (ActionResult)this.resultMap.get(id);
            }
        }
        return SUCCESS;
    }

    private boolean containsKey(Object id) {
        boolean result = false;
        if (id == null) {
            return false;
        }
        if (id instanceof String) {
            if (this.idType.equals(STRING_TYPE)) {
                return this.resultMap.containsKey(id);
            }
            for (IObjectPK pk : this.resultMap.keySet()) {
                result = pk.toString().equals(id);
                if (!result) continue;
                return true;
            }
        } else {
            if (this.idType.equals(STRING_TYPE)) {
                return this.resultMap.containsKey(((IObjectPK)id).toString());
            }
            return this.resultMap.containsKey(id);
        }
        return result;
    }

    public ActionResult getActionResult(IObjectPK id) {
        if (this.isNewId) {
            return (ActionResult)this.resultMap.get(NEWID);
        }
        Object key = this.idType.equals(PK_TYPE) ? id : id.toString();
        if (this.containsKey(key)) {
            return (ActionResult)this.resultMap.get(key);
        }
        return SUCCESS;
    }

    public ActionResults getToDoResults() {
        ActionResults todo = null;
        try {
            todo = (ActionResults)this.clone();
            Iterator iter = todo.resultMap.entrySet().iterator();
            IObjectCollection todoColl = todo.objCollection;
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                ActionResult result = (ActionResult)entry.getValue();
                if (!result.getResult().equals(ActionResultEnum.ERROR)) continue;
                iter.remove();
                this.removeCollection(todoColl, entry.getKey().toString());
            }
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        return todo;
    }

    public Object clone() throws CloneNotSupportedException {
        ActionResults results = (ActionResults)super.clone();
        results.resultMap = (HashMap)this.resultMap.clone();
        AbstractBaseObjectCollection objColl = (AbstractBaseObjectCollection)this.objCollection;
        results.objCollection = (IObjectCollection)objColl.clone();
        return results;
    }

    public void mergeResults(ActionResults actionResults) {
        for (Map.Entry entry : actionResults.resultMap.entrySet()) {
            Object id = entry.getKey();
            ActionResult result = (ActionResult)entry.getValue();
            ActionResult oldResult = (ActionResult)this.resultMap.get(id);
            if (oldResult != null && oldResult.getResult().equals(ActionResultEnum.ERROR) && result.getResult().equals(ActionResultEnum.ERROR)) {
                oldResult.setMessage(new StringBuffer().append("[").append(oldResult.getMessage()).append("]").append(" [").append(result.getMessage()).append("]").toString());
                continue;
            }
            this.resultMap.put(id, result);
            if (ActionResultEnum.ERROR.equals(result.getResult()) || !this.resultMap.containsKey(NEWID) || id.equals(NEWID)) continue;
            this.resultMap.remove(NEWID);
        }
        this.objCollection = actionResults.objCollection;
    }

    public String[] getToDoIdsArray() {
        String[] results;
        List list = this.getToDoIdsList();
        if (list != null && list.size() > 0) {
            int size = list.size();
            results = new String[size];
            if (list.get(0) instanceof String) {
                list.toArray(results);
            } else {
                for (int i = 0; i < size; ++i) {
                    results[i] = list.get(i).toString();
                }
            }
        } else {
            results = new String[]{};
        }
        return results;
    }

    public List getToDoIdsList() {
        Iterator iter = this.resultMap.entrySet().iterator();
        ArrayList todoList = new ArrayList();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            ActionResult result = (ActionResult)entry.getValue();
            if (result.getResult().equals(ActionResultEnum.ERROR)) continue;
            todoList.add(entry.getKey());
        }
        return todoList;
    }

    public Set getToDoIdsSet() {
        Iterator iter = this.resultMap.entrySet().iterator();
        HashSet todoSet = new HashSet();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            ActionResult result = (ActionResult)entry.getValue();
            if (result.getResult().equals(ActionResultEnum.ERROR)) continue;
            todoSet.add(entry.getKey());
        }
        return todoSet;
    }

    public IObjectPK[] getToDoPkArray() {
        IObjectPK[] results;
        List list = this.getToDoIdsList();
        if (list != null && list.size() > 0) {
            results = new IObjectPK[list.size()];
            if (list.get(0) instanceof IObjectPK) {
                System.arraycopy(list.toArray(), 0, results, 0, list.size());
            } else {
                int size = list.size();
                for (int i = 0; i < size; ++i) {
                    String id = (String)list.get(i);
                    if (NEWID.equals(list.get(i))) continue;
                    results[i] = new ObjectUuidPK(BOSUuid.read((String)id));
                }
            }
        } else {
            results = new IObjectPK[]{};
        }
        return results;
    }

    public void throwExceptions() throws BOSException, EASBizException {
        for (Map.Entry entry : this.resultMap.entrySet()) {
            ActionResult result = (ActionResult)entry.getValue();
            if (!ActionResultEnum.ERROR.equals(result.getResult())) continue;
            Exception exp = result.getException();
            if (exp != null) {
                if (exp instanceof BOSException) {
                    throw (BOSException)exp;
                }
                if (exp instanceof EASBizException) {
                    throw (EASBizException)exp;
                }
                throw new BOSException((Throwable)exp);
            }
            ActionCommonException bizExp = new ActionCommonException(null);
            bizExp.setMessage(result.getMessage());
            throw bizExp;
        }
    }

    public IObjectCollection getObjCollection() {
        return this.objCollection;
    }

    public void setObjCollection(IObjectCollection objCollection) {
        this.objCollection = objCollection;
    }

    public boolean hasToDos() {
        for (Map.Entry entry : this.resultMap.entrySet()) {
            ActionResult result = (ActionResult)entry.getValue();
            if (result.getResult().equals(ActionResultEnum.ERROR)) continue;
            return true;
        }
        return false;
    }

    public boolean isError(IObjectPK id) {
        ActionResult actionResult = this.getActionResult(id);
        if (actionResult == null) {
            return true;
        }
        return ActionResultEnum.ERROR.equals(actionResult.getResult());
    }

    public boolean isToDo(String id) {
        ActionResult actionResult = this.getActionResult(id);
        if (actionResult == null) {
            return false;
        }
        return !ActionResultEnum.ERROR.equals(actionResult.getResult());
    }

    public boolean hasException(EASBizException exception) {
        for (Map.Entry entry : this.resultMap.entrySet()) {
            ActionResult aresult = (ActionResult)entry.getValue();
            if (!aresult.hasException(exception)) continue;
            return true;
        }
        return false;
    }

    public String getDetailErrors() {
        Map map = this.getErrors();
        if (map.size() == 0) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        Iterator it = map.entrySet().iterator();
        String msg = null;
        Map.Entry entry = null;
        while (it.hasNext()) {
            entry = it.next();
            msg = entry.getValue().toString();
            sb.append(msg).append(" \n ");
        }
        return sb.toString();
    }

    public List<String> getDetailErrorList() {
        ArrayList<String> result = new ArrayList<String>();
        Map map = this.getErrors();
        if (map.size() == 0) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        Iterator it = map.entrySet().iterator();
        String msg = null;
        Map.Entry entry = null;
        while (it.hasNext()) {
            sb.setLength(0);
            entry = it.next();
            msg = entry.getValue().toString();
            result.add(msg);
        }
        return result;
    }

    public Map getErrors() {
        HashMap<String, String> rst = new HashMap<String, String>();
        if (this.resultMap == null || this.resultMap.size() == 0) {
            return rst;
        }
        Iterator it = this.resultMap.keySet().iterator();
        ActionResult result = null;
        ActionResultEnum rstEnum = null;
        Exception exc = null;
        String key = null;
        String msg = null;
        while (it.hasNext()) {
            key = (String)it.next();
            result = this.getActionResult(key);
            rstEnum = result.getResult();
            if (!rstEnum.equals(ActionResultEnum.ERROR)) continue;
            exc = result.getException();
            msg = exc == null ? result.getMessage() : exc.getMessage();
            rst.put(key, msg);
        }
        return rst;
    }

    private void removeCollection(IObjectCollection objColl, String key) {
        Iterator it = objColl.iterator();
        IObjectValue objVal = null;
        String pkField = null;
        while (it.hasNext()) {
            objVal = (IObjectValue)it.next();
            if (!objVal.get(pkField = objVal.getPKField()).toString().equals(key)) continue;
            it.remove();
        }
    }

    public void setNewObjectIdList(List<String> newObjectIdList) {
        this.newObjectIdList = newObjectIdList;
    }

    public List<String> getNewObjectIdList() {
        return this.newObjectIdList;
    }

    public void setOriginalInfoList(List<CoreBillBaseInfo> originalInfoList) {
        this.originalInfoList = originalInfoList;
    }

    public List<CoreBillBaseInfo> getOriginalInfoList() {
        return this.originalInfoList;
    }

    public void setNewInfoList(List<CoreBillBaseInfo> newInfoList) {
        this.newInfoList = newInfoList;
    }

    public List<CoreBillBaseInfo> getNewInfoList() {
        return this.newInfoList;
    }
}

