/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.pdm.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.KDToolkit;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDDBntScrollBar;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.CommitEvent;
import com.kingdee.bos.ctrl.swing.event.CommitListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.mm.pdm.IMaterialMatchHistory;
import com.kingdee.eas.mm.pdm.MaterialMatchHistoryFactory;
import com.kingdee.eas.mm.pdm.MaterialMatchHistoryInfo;
import com.kingdee.eas.mm.pdm.client.AbstractMaterialMatchHistoryUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JScrollBar;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class MaterialMatchHistoryUI
extends AbstractMaterialMatchHistoryUI {
    private static final long serialVersionUID = 1L;
    private static final String TAB_COL_MATERIAL_NUMBER = "materialNumber";
    private static final String TAB_COL_MATERIAL_ID = "materialID";
    private static final String TAB_COL_CU = "CU";
    private static final String TAB_COL_NAME = "name";
    private static final String TAB_COL_MODEL = "model";
    private static final String TAB_COL_PICTURENUMBER = "pictureNumber";
    private static final String TAB_COL_ID = "id";
    private static final String TAB_COL_UPDATETIME = "updateTime";
    private static final String TAB_COL_ISUPDATE = "isUpdate";
    private KDBizPromptBox kdtEASDataPromptBox;
    private JScrollBar vBar = new KDDBntScrollBar(1);
    private AdjustmentListener listener = null;
    private KDTEditAdapter tableChangeListener = null;
    private int delRowSize;
    private Map params = new HashMap();
    private boolean hasData = true;
    public static int defaultPageRow;

    public MaterialMatchHistoryUI() throws Exception {
        this.kdtEASDataPromptBox = new KDBizPromptBox();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.addListener();
        this.initMenu();
        this.initTable();
        this.tblMain.getLayoutManager().setVerticalScrollBar(this.vBar);
        this.tblMain.getSelectManager().setSelectMode(15);
        this.tblMain.getDataRequestManager().setDataRequestMode(1);
        this.tblMain.setFocusTraversalKeys(0, new HashSet());
        this.tblMain.getInputMap(1).put(KeyStroke.getKeyStroke(9, 0), "FocusChangeRow");
        this.tblMain.getActionMap().remove("Cut");
        this.tblMain.getActionMap().remove("Paste");
        this.tblMain.getActionMap().remove("Delete");
        this.tblMain.getColumn(TAB_COL_UPDATETIME).getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDateFormatString());
    }

    protected KDTable getDetailTable() {
        return this.tblMain;
    }

    protected void initListener() {
    }

    private void addListener() {
        if (null == this.listener) {
            this.listener = new AdjustmentListener(){

                @Override
                public void adjustmentValueChanged(AdjustmentEvent e) {
                    MaterialMatchHistoryUI.this.getNextPageData(e);
                }
            };
        }
        this.vBar.addAdjustmentListener(this.listener);
        if (null == this.tableChangeListener) {
            this.tableChangeListener = new KDTEditAdapter(){

                public void editStopped(KDTEditEvent e) {
                    try {
                        MaterialMatchHistoryUI.this.mainTableChange(e);
                    }
                    catch (Exception exc) {
                        MaterialMatchHistoryUI.this.handUIException(exc);
                    }
                }
            };
        }
        this.tblMain.addKDTEditListener((KDTEditListener)this.tableChangeListener);
        this.kdtEASDataPromptBox.addCommitListener(new CommitListener(){

            public void willCommit(CommitEvent paramCommitEvent) {
                MaterialMatchHistoryUI.this.materialF7HandleForCU();
            }
        });
        this.kdtEASDataPromptBox.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                MaterialMatchHistoryUI.this.materialF7HandleForCU();
            }
        });
    }

    private void initTable() {
        this.kdtEASDataPromptBox.setQueryInfo("com.kingdee.eas.mm.pdm.app.F7MaterialNoGroupQuery");
        this.kdtEASDataPromptBox.setVisible(true);
        this.kdtEASDataPromptBox.setEditable(true);
        this.kdtEASDataPromptBox.setRequired(true);
        this.kdtEASDataPromptBox.setEnabledMultiSelection(false);
        this.kdtEASDataPromptBox.setDisplayFormat("$number$");
        this.kdtEASDataPromptBox.setEditFormat("$number$");
        this.kdtEASDataPromptBox.setCommitFormat("$number$");
        KDTDefaultCellEditor cellEditor = new KDTDefaultCellEditor((IKDEditor)this.kdtEASDataPromptBox);
        this.tblMain.getColumn(TAB_COL_MATERIAL_NUMBER).setEditor((ICellEditor)cellEditor);
        ObjectValueRender kdtEntrysStorageOrgUnitOVR = new ObjectValueRender();
        kdtEntrysStorageOrgUnitOVR.setFormat((IDataFormat)new BizDataFormat("$number$"));
        this.tblMain.getColumn(TAB_COL_MATERIAL_NUMBER).setRenderer((IBasicRender)kdtEntrysStorageOrgUnitOVR);
        KDTextField txt = new KDTextField();
        txt.setMaxLength(255);
        KDTDefaultCellEditor cellEditorForTxt = new KDTDefaultCellEditor((JTextField)txt);
        this.tblMain.getColumn(TAB_COL_NAME).setEditor((ICellEditor)cellEditorForTxt);
        this.tblMain.getColumn(TAB_COL_MODEL).setEditor((ICellEditor)cellEditorForTxt);
        this.tblMain.getColumn(TAB_COL_PICTURENUMBER).setEditor((ICellEditor)cellEditorForTxt);
        this.tblMain.getStyleAttributes().setLocked(false);
        this.tblMain.getColumn(TAB_COL_CU).getStyleAttributes().setLocked(true);
        this.tblMain.getColumn(TAB_COL_UPDATETIME).getStyleAttributes().setLocked(true);
    }

    private void initMenu() {
        this.actionAttachment.setVisible(false);
        this.actionAttachment.setEnabled(false);
        this.actionCreateTo.setVisible(false);
        this.actionCreateTo.setEnabled(false);
        this.actionCopyTo.setEnabled(false);
        this.actionCopyTo.setVisible(false);
        this.actionTraceDown.setEnabled(false);
        this.actionTraceDown.setVisible(false);
        this.actionTraceUp.setVisible(false);
        this.actionTraceUp.setEnabled(false);
        this.menuBiz.setVisible(false);
        this.menuWorkFlow.setVisible(false);
        this.actionAuditResult.setVisible(false);
        this.actionAuditResult.setEnabled(false);
        this.actionViewDoProccess.setVisible(false);
        this.actionWorkFlowG.setVisible(false);
        this.changeMenuState(true);
    }

    private void changeMenuState(boolean state) {
        this.actionEdit.setEnabled(state);
        this.actionSave.setEnabled(!state);
        this.tblMain.setEditable(!state);
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    protected void tblMain_doRequestRowSet(RequestRowSetEvent e) {
        this.params.put("VIEW", this.mainQuery);
        this.params.put(TAB_COL_CU, (CtrlUnitInfo)SysContext.getSysContext().getCurrentOrgUnit(OrgType.ControlUnit));
        this.getDataWithStart(0);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        CtrlUnitInfo currentMainOrg = (CtrlUnitInfo)SysContext.getSysContext().getCurrentOrgUnit(OrgType.ControlUnit);
        if (this.getRemoteInstance().getLock(currentMainOrg.getId().toString())) {
            this.remove();
            this.releaseLock();
        } else {
            MsgBox.showConfirm2((String)this.getResource("BASEDATA_MSG_LOCK"));
        }
    }

    private void remove() {
        ArrayList blocks = this.tblMain.getSelectManager().getBlocks();
        int selectSize = blocks.size();
        if (selectSize == 0 || this.getDetailTable().getRowCount() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
            return;
        }
        int mode = this.tblMain.getSelectManager().get().getMode();
        if (mode == 8) {
            KDTSelectBlock selectBlock = (KDTSelectBlock)blocks.get(0);
            selectBlock.setBottom(0);
            selectBlock.setTop(this.getDetailTable().getRowCount() - 1);
        }
        if (!this.confirmRemove()) {
            return;
        }
        IRow row = null;
        ArrayList<String> ids = new ArrayList<String>();
        ArrayList<Integer> rowIndexs = new ArrayList<Integer>();
        String id = null;
        while (selectSize > 0) {
            int endRowIndex;
            KDTSelectBlock block = (KDTSelectBlock)blocks.get(selectSize - 1);
            int startRowIndex = block.getBeginRow();
            if (startRowIndex > (endRowIndex = block.getEndRow())) {
                int tmp = endRowIndex;
                endRowIndex = startRowIndex;
                startRowIndex = tmp;
            }
            while (endRowIndex >= startRowIndex) {
                row = this.tblMain.getRow(endRowIndex);
                id = (String)row.getCell(TAB_COL_ID).getValue();
                if (null != id) {
                    ids.add(id);
                    ++this.delRowSize;
                }
                rowIndexs.add(new Integer(endRowIndex));
                if (--endRowIndex >= 0) continue;
            }
            if (--selectSize > 0) continue;
            break;
        }
        boolean isSuccess = true;
        if (ids.size() > 0) {
            try {
                this.getRemoteInstance().delete(ids);
            }
            catch (Exception err) {
                isSuccess = false;
                this.handleException(err);
            }
        }
        if (!isSuccess) {
            return;
        }
        int size = rowIndexs.size();
        for (int i = 0; i < size; ++i) {
            this.tblMain.removeRow(((Integer)rowIndexs.get(i)).intValue());
        }
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        HashMap params = new HashMap();
        Map updateData = this.getDataForSave();
        if (updateData.size() < 1) {
            this.releaseLock();
            this.changeMenuState(true);
        } else {
            params.put("update", updateData);
            params.put("CU_INFO", SysContext.getSysContext().getCurrentOrgUnit(OrgType.ControlUnit));
            Map result = this.getRemoteInstance().save(params);
            this.afterSaveAction(result, updateData);
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        CtrlUnitInfo currentMainOrg = (CtrlUnitInfo)SysContext.getSysContext().getCurrentOrgUnit(OrgType.ControlUnit);
        if (this.getRemoteInstance().getLock(currentMainOrg.getId().toString())) {
            this.changeMenuState(false);
        } else {
            MsgBox.showConfirm2((String)this.getResource("BASEDATA_MSG_LOCK"));
        }
    }

    private void afterSaveAction(Map result, Map updateData) {
        if (!((Boolean)result.get("checkResult")).booleanValue()) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)this.getResource("MATERIALMATCHHISTORY_SAVE_ERROR_TITLE"), (String)((String)result.get("errorMessage")), (int)0);
        } else {
            this.releaseLock();
            this.refeshTable();
            this.changeMenuState(true);
            Iterator it = updateData.keySet().iterator();
            Date now = new Date();
            while (it.hasNext()) {
                this.tblMain.getRow(((Integer)it.next()).intValue()).getCell(TAB_COL_UPDATETIME).setValue((Object)now);
            }
        }
    }

    private Map getDataForSave() {
        TreeMap<Integer, MaterialMatchHistoryInfo> data = new TreeMap<Integer, MaterialMatchHistoryInfo>();
        int rowSize = this.tblMain.getRowCount();
        IRow row = null;
        for (int i = 0; i < rowSize; ++i) {
            row = this.tblMain.getRow(i);
            if (null == row.getCell(TAB_COL_ISUPDATE).getValue()) continue;
            data.put(new Integer(i), this.getRowData(row));
        }
        return data;
    }

    private MaterialMatchHistoryInfo getRowData(IRow row) {
        MaterialMatchHistoryInfo info = new MaterialMatchHistoryInfo();
        BOSUuid id = BOSUuid.read((String)((String)row.getCell(TAB_COL_ID).getValue()));
        info.setId(id);
        info.setMaterialName(this.checkIsNull((String)row.getCell(TAB_COL_NAME).getValue()));
        info.setMaterialModel(this.checkIsNull((String)row.getCell(TAB_COL_MODEL).getValue()));
        info.setPictureNumber(this.checkIsNull((String)row.getCell(TAB_COL_PICTURENUMBER).getValue()));
        if (row.getCell(TAB_COL_MATERIAL_NUMBER).getValue() instanceof String) {
            MaterialInfo materialInfo = new MaterialInfo();
            materialInfo.setId(BOSUuid.read((String)((String)row.getCell(TAB_COL_MATERIAL_ID).getValue())));
            info.setMaterial(materialInfo);
        } else {
            info.setMaterial((MaterialInfo)row.getCell(TAB_COL_MATERIAL_NUMBER).getValue());
        }
        return info;
    }

    private String checkIsNull(String value) {
        if (null == value || value.trim().length() < 1) {
            return null;
        }
        return value;
    }

    private void getNextPageData(AdjustmentEvent e) {
        int tablesize;
        if (!this.hasData) {
            return;
        }
        int last = this.tblMain.getLayoutManager().getVertical(1).getLast();
        if (last + 3 >= (tablesize = this.tblMain.getRowCount())) {
            this.getDataWithStart(tablesize);
        }
    }

    private void mainTableChange(KDTEditEvent e) {
        int rowIndex = e.getRowIndex();
        if (e.getValue() == null) {
            if (e.getOldValue() != null) {
                this.tblMain.getRow(rowIndex).getCell(TAB_COL_ISUPDATE).setValue((Object)new Integer(1));
            }
        } else if (!e.getValue().equals(e.getOldValue())) {
            this.tblMain.getRow(rowIndex).getCell(TAB_COL_ISUPDATE).setValue((Object)new Integer(1));
        }
    }

    private void getDataWithStart(int start) {
        Map result = null;
        try {
            result = this.getRemoteInstance().getCollectionByVirtualMode(this.params, start, defaultPageRow, "");
        }
        catch (BOSException e1) {
            this.handleException((Exception)((Object)e1));
        }
        if (null != result) {
            RptRowSet rowset = (RptRowSet)result.get("RESULT_ROW");
            this.forRowSet(rowset);
            if (rowset.getVirtualRowCount() == 0) {
                this.hasData = false;
            }
        }
    }

    private void forRowSet(RptRowSet rowset) {
        while (rowset.next()) {
            IRow row = this.tblMain.addRow();
            row.getCell(TAB_COL_CU).setValue((Object)rowset.getString("cuNumber"));
            row.getCell(TAB_COL_MATERIAL_NUMBER).setValue((Object)rowset.getString(TAB_COL_MATERIAL_NUMBER));
            row.getCell(TAB_COL_MATERIAL_ID).setValue((Object)rowset.getString(TAB_COL_MATERIAL_ID));
            row.getCell(TAB_COL_NAME).setValue((Object)rowset.getString(TAB_COL_NAME));
            row.getCell(TAB_COL_MODEL).setValue((Object)rowset.getString(TAB_COL_MODEL));
            row.getCell(TAB_COL_PICTURENUMBER).setValue((Object)rowset.getString(TAB_COL_PICTURENUMBER));
            row.getCell(TAB_COL_UPDATETIME).setValue(rowset.getObject(TAB_COL_UPDATETIME));
            row.getCell(TAB_COL_ID).setValue((Object)rowset.getString("FID"));
        }
    }

    public String getResource(String sKey) {
        return EASResource.getString((String)"com.kingdee.eas.mm.pdm.PDMResource", (String)sKey);
    }

    protected String getEntityBOSType() {
        return "DE6810A1";
    }

    protected IMaterialMatchHistory getRemoteInstance() throws BOSException {
        return MaterialMatchHistoryFactory.getRemoteInstance();
    }

    protected boolean checkBeforeWindowClosing() {
        boolean isChange = false;
        boolean returnValue = true;
        if (this.tblMain.getRowCount() < 0) {
            isChange = false;
        }
        IRow row = null;
        int rowSize = this.tblMain.getRowCount();
        for (int i = 0; i < rowSize; ++i) {
            row = this.tblMain.getRow(i);
            if (null == row.getCell(TAB_COL_ISUPDATE).getValue()) continue;
            isChange = true;
            break;
        }
        if (isChange) {
            int userChoice = MsgBox.showConfirm3((String)this.getResource("BASEDATA_TABLE_REFRESH_NOTICE_SAVE"));
            if (userChoice == 0) {
                Map updateData = this.getDataForSave();
                if (updateData.size() > 0) {
                    Map result = null;
                    HashMap params = new HashMap();
                    params.put("update", updateData);
                    params.put("CU_INFO", SysContext.getSysContext().getCurrentOrgUnit(OrgType.ControlUnit));
                    try {
                        result = this.getRemoteInstance().save(params);
                        if (!((Boolean)result.get("checkResult")).booleanValue()) {
                            MsgBox.showDetailAndOK((Component)((Object)this), (String)this.getResource("MATERIALMATCHHISTORY_SAVE_ERROR_TITLE"), (String)((String)result.get("errorMessage")), (int)0);
                            returnValue = false;
                        }
                    }
                    catch (BOSException e) {
                        this.handleException((Exception)((Object)e));
                    }
                    returnValue = true;
                }
            } else {
                returnValue = userChoice == 1;
            }
        }
        if (!this.actionEdit.isEnabled()) {
            this.releaseLock();
        }
        return returnValue;
    }

    private void releaseLock() {
        try {
            CtrlUnitInfo currentMainOrg = (CtrlUnitInfo)SysContext.getSysContext().getCurrentOrgUnit(OrgType.ControlUnit);
            this.getRemoteInstance().releaseLock(currentMainOrg.getId().toString());
        }
        catch (BOSException e1) {
            this.handleException((Exception)((Object)e1));
        }
    }

    private void refeshTable() {
        int rowSize = this.tblMain.getRowCount();
        IRow row = null;
        for (int i = 0; i < rowSize; ++i) {
            row = this.tblMain.getRow(i);
            if (null == row.getCell(TAB_COL_ISUPDATE).getValue()) continue;
            row.getCell(TAB_COL_ISUPDATE).setValue(null);
        }
    }

    private void materialF7HandleForCU() {
        int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        if (rowIndex < 0) {
            if (this.tblMain.getRowCount() > 0) {
                rowIndex = 0;
            } else {
                return;
            }
        }
        String cuNumber = (String)this.tblMain.getCell(rowIndex, TAB_COL_CU).getValue();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("CU.number", (Object)cuNumber));
        view.setFilter(filterInfo);
        this.kdtEASDataPromptBox.setEntityViewInfo(view);
        this.kdtEASDataPromptBox.getQueryAgent().resetRuntimeEntityView();
    }

    static {
        Dimension d = KDToolkit.getScreenSize();
        int h = 768;
        if (d != null) {
            h = d.height;
        }
        defaultPageRow = h <= 768 ? 30 : 50;
    }
}

