/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.pdm.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.master.material.MaterialGroupInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.client.F7BaseSelector;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.mm.common.util.ResourceUtils;
import com.kingdee.eas.mm.pdm.MaterialMiddleInfo;
import com.kingdee.eas.mm.pdm.client.AbstractMaterialMiddleFilterUI;
import com.kingdee.eas.mm.pdm.client.F7MaterialGroupUI;
import com.kingdee.eas.scm.common.client.GeneralKDPromptSelectorAdaptor;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class MaterialMiddleFilterUI
extends AbstractMaterialMiddleFilterUI {
    private static final long serialVersionUID = 1L;
    private static final String RESOURCE_PATH = "com.kingdee.eas.mm.pdm.PDMResource";

    public MaterialMiddleFilterUI() throws Exception {
        this.prmtMaterialGroup.setDisplayFormat("$name$");
        this.prmtMaterialGroup.setEditFormat("$number$");
        this.prmtMaterialGroup.setCommitFormat("$number$");
    }

    public void onLoad() throws Exception {
        super.onLoad();
        CompositeFilterElement elements = new CompositeFilterElement(0);
        SingleFilterElement element = new SingleFilterElement("number", (Component)this.prmtMaterial);
        elements.add((FilterElement)element);
        element = new SingleFilterElement("link_materialGroup.number", (Component)this.prmtMaterialGroup);
        elements.add((FilterElement)element);
        this.getFilterManager().setElement((FilterElement)elements);
        this.setFilter();
    }

    public FilterInfo getFilterInfo() {
        FilterInfo filterInfo = super.getFilterInfo();
        HashSet<Integer> flagSet = new HashSet<Integer>();
        FilterInfo filter = new FilterInfo();
        if (this.chkHasNotTransmit.isSelected()) {
            flagSet.add(new Integer(10));
        }
        if (this.chkSuccessTransmit.isSelected()) {
            flagSet.add(new Integer(20));
        }
        if (this.chkFailTransmit.isSelected()) {
            flagSet.add(new Integer(30));
        }
        if (this.chkSuccessMatched.isSelected()) {
            flagSet.add(new Integer(40));
        }
        if (this.chkFailMatched.isSelected()) {
            flagSet.add(new Integer(50));
        }
        if (this.chkNotTransmit.isSelected()) {
            flagSet.add(new Integer(60));
        }
        filter.getFilterItems().add(new FilterItemInfo("flag", flagSet, CompareType.INCLUDE));
        HashSet<Integer> optTypeSet = new HashSet<Integer>();
        if (this.chkUpdate.isSelected()) {
            optTypeSet.add(new Integer(10));
        }
        if (this.chkDelete.isSelected()) {
            optTypeSet.add(new Integer(20));
        }
        filter.getFilterItems().add(new FilterItemInfo("base_operationType", optTypeSet, CompareType.INCLUDE));
        try {
            if (filterInfo == null) {
                filterInfo = new FilterInfo();
            }
            filterInfo.mergeFilter(filter, "and");
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return filterInfo;
    }

    public boolean verify() {
        boolean hasSelected = false;
        KDCheckBox[] flags = this.getFlagCheckBoxes();
        for (int i = 0; i < flags.length; ++i) {
            if (!flags[i].isSelected()) continue;
            hasSelected = true;
            break;
        }
        if (!hasSelected) {
            MsgBox.showWarning((Component)((Object)this), (String)this.getResource("Flag_Not_Selected"));
            return false;
        }
        hasSelected = false;
        KDCheckBox[] optTypes = this.getOptTypeCheckBoxes();
        for (int i = 0; i < optTypes.length; ++i) {
            if (!optTypes[i].isSelected()) continue;
            hasSelected = true;
            break;
        }
        if (!hasSelected) {
            MsgBox.showWarning((Component)((Object)this), (String)this.getResource("OptType_Not_Selected"));
            return false;
        }
        return true;
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        super.loadData(entityViewInfo);
        FilterInfo filter = entityViewInfo.getFilter();
        FilterItemCollection filterColl = filter.getFilterItems();
        if (filterColl == null || filterColl.size() == 0) {
            return;
        }
        FilterItemInfo item = null;
        String propertyName = null;
        for (int i = 0; i < filterColl.size(); ++i) {
            item = filterColl.get(i);
            propertyName = item.getPropertyName();
            if ("flag".equalsIgnoreCase(propertyName)) {
                this.setFlagValue((Set)item.getCompareValue());
                continue;
            }
            if ("base_operationType".equalsIgnoreCase(propertyName)) {
                this.setOptTypeValue((Set)item.getCompareValue());
                continue;
            }
            if ("number".equalsIgnoreCase(propertyName)) {
                this.setMaterialValue(item.getCompareValue());
                continue;
            }
            if (!"link_materialGroup.number".equalsIgnoreCase(propertyName)) continue;
            this.setMaterialGroupValue(item.getCompareValue());
        }
    }

    public void clear() {
        super.clear();
        KDCheckBox[] flagChbs = this.getFlagCheckBoxes();
        this.setCheckBoxSelected(flagChbs, true);
        KDCheckBox[] optChbs = this.getOptTypeCheckBoxes();
        this.setCheckBoxSelected(optChbs, true);
    }

    private void setFilter() {
        CtrlUnitInfo cu = SysContext.getSysContext().getCurrentCtrlUnit();
        this.initF7Material(cu, this.prmtMaterial);
        this.setMaterialGroupFilter(this.prmtMaterialGroup, cu, (Object)this, true);
    }

    private void initF7Material(CtrlUnitInfo cu, KDBizPromptBox prmtMaterial) {
        try {
            prmtMaterial.setEditFormat("$number$");
            prmtMaterial.setDisplayFormat("$number$");
            prmtMaterial.setCommitFormat("$number$;$name$;$model$;$helpCode$");
            int f7DisplayMode = SCMGroupClientUtils.getF7DisplayMode((String)SysContext.getSysContext().getCurrentCtrlUnit().getId().toString());
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            if (f7DisplayMode == 0) {
                String materialGroupQuery = "com.kingdee.eas.mm.pdm.app.F7MaterialGroupQuery";
                String materialNoGroupQuery = "com.kingdee.eas.mm.pdm.app.F7MaterialNoGroupQuery";
                GeneralKDPromptSelectorAdaptor selectorLisenterMaterial = new GeneralKDPromptSelectorAdaptor((KDPromptBox)prmtMaterial, "com.kingdee.eas.basedata.master.material.client.F7MaterialTreeListUI", (Object)this, MaterialGroupInfo.getBosType(), materialGroupQuery, "materialGroup.id", null, materialNoGroupQuery);
                selectorLisenterMaterial.setIsMultiSelect(true);
                prmtMaterial.setSelector((KDPromptSelector)selectorLisenterMaterial);
                prmtMaterial.addSelectorListener((SelectorListener)selectorLisenterMaterial);
                entityViewInfo = new EntityViewInfo();
                FilterInfo filterInfo = new FilterInfo();
                if (cu != null) {
                    filterInfo.getFilterItems().add(new FilterItemInfo("CU.id", (Object)cu.getId().toString(), CompareType.EQUALS));
                }
                entityViewInfo.setFilter(filterInfo);
            } else {
                prmtMaterial.setQueryInfo("com.kingdee.eas.mm.pdm.app.F7MaterialNoGroupQuery");
                entityViewInfo = new EntityViewInfo();
                FilterInfo filterInfo = new FilterInfo();
                if (cu != null) {
                    filterInfo.getFilterItems().add(new FilterItemInfo("company.id", (Object)cu.getId().toString(), CompareType.EQUALS));
                }
                entityViewInfo.setFilter(filterInfo);
            }
            prmtMaterial.setEditable(true);
            prmtMaterial.setEnabledMultiSelection(true);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    private KDCheckBox[] getFlagCheckBoxes() {
        KDCheckBox[] box = new KDCheckBox[]{this.chkHasNotTransmit, this.chkSuccessTransmit, this.chkFailTransmit, this.chkSuccessMatched, this.chkFailMatched, this.chkNotTransmit};
        return box;
    }

    private KDCheckBox[] getOptTypeCheckBoxes() {
        KDCheckBox[] box = new KDCheckBox[]{this.chkUpdate, this.chkDelete};
        return box;
    }

    private String getResource(String key) {
        return ResourceUtils.getMessageForClient((String)RESOURCE_PATH, (String)key);
    }

    private void setMaterialGroupFilter(KDBizPromptBox prmtMaterialGroup, CtrlUnitInfo cu, Object owner, boolean isMulSelect) {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("groupStandard.standardType", (Object)new Integer(1)));
        if (!MaterialInfo.isAllowNonLeafGroup()) {
            filter.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)Boolean.TRUE));
        }
        view.setFilter(filter);
        prmtMaterialGroup.setEntityViewInfo(view);
        UIContext ctx = new UIContext(owner);
        ctx.put((Object)"onlyBaseStandard", (Object)Boolean.TRUE);
        ctx.put((Object)"cu", (Object)cu);
        Class innerUIClass = com.kingdee.eas.basedata.master.material.client.F7MaterialGroupUI.class;
        if (isMulSelect) {
            innerUIClass = F7MaterialGroupUI.class;
        }
        F7BaseSelector f7Selector = new F7BaseSelector(innerUIClass, prmtMaterialGroup, ctx);
        prmtMaterialGroup.setSelector((KDPromptSelector)f7Selector);
    }

    private void setCheckBoxSelected(KDCheckBox[] chbs, boolean isSeleded) {
        for (int i = 0; i < chbs.length; ++i) {
            chbs[i].setSelected(isSeleded);
        }
    }

    private void setFlagValue(Set set) {
        if (set == null) {
            this.setCheckBoxSelected(this.getFlagCheckBoxes(), true);
            return;
        }
        this.setCheckBoxSelected(this.getFlagCheckBoxes(), false);
        Iterator it = set.iterator();
        int flagValue = 0;
        while (it.hasNext()) {
            flagValue = Integer.parseInt(it.next().toString());
            if (10 == flagValue) {
                this.chkHasNotTransmit.setSelected(true);
                continue;
            }
            if (20 == flagValue) {
                this.chkSuccessTransmit.setSelected(true);
                continue;
            }
            if (30 == flagValue) {
                this.chkFailTransmit.setSelected(true);
                continue;
            }
            if (40 == flagValue) {
                this.chkSuccessMatched.setSelected(true);
                continue;
            }
            if (50 == flagValue) {
                this.chkFailMatched.setSelected(true);
                continue;
            }
            if (60 != flagValue) continue;
            this.chkNotTransmit.setSelected(true);
        }
    }

    private void setOptTypeValue(Set set) {
        if (set == null) {
            this.setCheckBoxSelected(this.getOptTypeCheckBoxes(), true);
            return;
        }
        this.setCheckBoxSelected(this.getOptTypeCheckBoxes(), false);
        Iterator it = set.iterator();
        int optValue = 0;
        while (it.hasNext()) {
            optValue = Integer.parseInt(it.next().toString());
            if (10 == optValue) {
                this.chkUpdate.setSelected(true);
                continue;
            }
            if (20 != optValue) continue;
            this.chkDelete.setSelected(true);
        }
    }

    private void setMaterialValue(Object obj) {
        Set set = this.conversionSet(obj);
        if (set == null || set.size() == 0) {
            this.prmtMaterial.setValue(null);
            return;
        }
        MaterialMiddleInfo[] infos = new MaterialMiddleInfo[set.size()];
        int index = 0;
        MaterialMiddleInfo info = null;
        Iterator it = set.iterator();
        while (it.hasNext()) {
            info = new MaterialMiddleInfo();
            info.setNumber(it.next().toString());
            infos[index] = info;
            ++index;
        }
        this.prmtMaterial.setValue((Object)infos);
    }

    private void setMaterialGroupValue(Object obj) {
        Set set = this.conversionSet(obj);
        if (set == null || set.size() == 0) {
            this.prmtMaterialGroup.setValue(null);
            return;
        }
        MaterialGroupInfo[] infos = new MaterialGroupInfo[set.size()];
        int index = 0;
        MaterialGroupInfo info = null;
        Iterator it = set.iterator();
        while (it.hasNext()) {
            info = new MaterialGroupInfo();
            info.setNumber(it.next().toString());
            infos[index] = info;
            ++index;
        }
        this.prmtMaterialGroup.setValue((Object)infos);
    }

    private Set conversionSet(Object obj) {
        Set<String> set = new HashSet();
        if (obj == null) {
            return set;
        }
        if (obj instanceof Set) {
            set = (Set)obj;
        } else if (obj instanceof String) {
            set.add((String)obj);
        }
        return set;
    }
}

