/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.pdm.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.base.commonquery.client.IProcessor;
import com.kingdee.eas.base.commonquery.client.IPromptBoxFactory;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.mm.common.client.KDTableUtils;
import com.kingdee.eas.mm.common.util.EditTableUtil;
import com.kingdee.eas.mm.common.util.MMConstant;
import com.kingdee.eas.mm.common.util.ResourceUtils;
import com.kingdee.eas.mm.pdm.ActionResults;
import com.kingdee.eas.mm.pdm.IMaterialMiddle;
import com.kingdee.eas.mm.pdm.MaterialMiddleFactory;
import com.kingdee.eas.mm.pdm.client.AbstractMaterialMiddleListUI;
import com.kingdee.eas.mm.pdm.client.MaterialMiddleEditUI;
import com.kingdee.eas.mm.pdm.client.MaterialMiddleFilterUI;
import com.kingdee.eas.mm.pdm.client.PDMLotClientHelper;
import com.kingdee.eas.scm.common.client.SCMCommonProcessor;
import com.kingdee.eas.scm.common.client.SCMPromptBoxFactory;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class MaterialMiddleListUI
extends AbstractMaterialMiddleListUI {
    private static final long serialVersionUID = -3142447040115068242L;
    private static final String RESOURCE_PATH = "com.kingdee.eas.mm.pdm.PDMResource";
    private static final String[] KDT_DATETIMES = new String[]{"inputTime", "transmitTime"};
    private int defaultPrecision = 8;
    private CommonQueryDialog commonQueryDialog = null;
    protected MaterialMiddleFilterUI conditionPanel = null;
    private int freezeColIndex = 5;
    private static final String COL_ID = "id";
    private static final String COL_FLAG = "flag";
    private static final String COL_OPTTYPE = "optType";
    private static final String COL_LOT = "lot";
    private static final String COL_NUMBER = "number";
    private static final String COL_NAME = "name";
    private static final String COL_MODEL = "model";
    private static final String COL_SHORTNAME = "shortName";
    private static final String COL_MATERIALGROUP = "materialGroup.name";
    private static final String COL_BASEUNIT = "baseUnit.name";
    private static final String COL_PICTURENUMBER = "pictureNumber";
    private static final String COL_LENGTHUNIT = "lengthUnit.name";
    private static final String COL_LENGTH = "length";
    private static final String COL_WIDTH = "width";
    private static final String COL_HEIGHT = "height";
    private static final String COL_WEIGHTUNIT = "weightUnit.name";
    private static final String COL_GROSSWEIGHT = "grossWeight";
    private static final String COL_NETWEIGHT = "netWeight";
    private static final String COL_VOLUMNUNIT = "volumnUnit.name";
    private static final String COL_VOLUME = "volume";
    private static final String COL_PDMNUMBER = "pdmNumber";
    private static final String COL_PDMMATERIALGROUP = "pdmMaterialGroup";
    private static final String COL_PDMBASEUNIT = "pdmBaseUnit";
    private static final String COL_PDMLENGTHUNIT = "pdmLengthUnit";
    private static final String COL_PDMWEIGHTUNIT = "pdmWeightUnit";
    private static final String COL_PDMVOLUMNUNIT = "pdmVolumnUnit";
    private static final String COL_PDMCU = "pdmCU";
    private static final String COL_CUNAME = "CU.name";
    private static final String COL_TRANSMITUSER = "transmitUser";
    private static final String COL_LENGTHUNIT_QTYPRECISION = "lengthUnit.qtyPrecision";
    private static final String COL_WEIGHTUNIT_QTYPRECISION = "weightUnit.qtyPrecision";
    private static final String COL_VOLUMNUNIT_QTYPRECISION = "volumnUnit.qtyPrecision";

    public void onLoad() throws Exception {
        super.onLoad();
        this.initButton();
        this.initWidget();
        this.btnBatchEdit.setIcon(EASResource.getIcon((String)"imgTbtn_editbatch"));
        this.menuItemBatchEdit.setIcon(EASResource.getIcon((String)"imgTbtn_editbatch"));
        EditTableUtil.formatColDateTime((KDTable)this.tblMain, (String[])KDT_DATETIMES);
    }

    protected ICoreBase getBizInterface() throws Exception {
        return MaterialMiddleFactory.getRemoteInstance();
    }

    public String getKeyFieldName() {
        return COL_ID;
    }

    public String getEditUIName() {
        return MaterialMiddleEditUI.class.getName();
    }

    protected ArrayList getImportParam() {
        DatataskParameter param = new DatataskParameter();
        param.solutionName = "materialMiddleImportTemplate";
        param.alias = this.getResource("materialMiddleTemplate");
        param.datataskMode = 0;
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    public void actionImportData_actionPerformed(ActionEvent e) throws Exception {
        this.getMainOrgContext().put((Object)"LOT", (Object)PDMLotClientHelper.getPDMLotNumber());
        super.actionImportData_actionPerformed(e);
    }

    protected ArrayList getExportParam() {
        DatataskParameter param = new DatataskParameter();
        param.solutionName = "materialMiddleImportTemplate";
        param.alias = this.getResource("materialMiddleTemplate");
        param.datataskMode = 1;
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filterInfo = new FilterInfo();
        String orgkey = this.getOrgFieldName();
        filterInfo.getFilterItems().add(new FilterItemInfo(orgkey, (Object)SysContext.getSysContext().getCurrentCtrlUnit().getId().toString(), CompareType.INCLUDE));
        return filterInfo;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.ControlUnit;
    }

    protected String getOrgFieldName() {
        return "cu.id";
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        if (this.commonQueryDialog == null) {
            if (this.mainQuery == null) {
                this.mainQuery = new EntityViewInfo();
            }
            this.commonQueryDialog = super.initCommonQueryDialog();
            try {
                SCMPromptBoxFactory scmF7Factory = new SCMPromptBoxFactory(this.getFilterUI(), this.getMainBizOrgType());
                this.commonQueryDialog.setPromptBoxFactory((IPromptBoxFactory)scmF7Factory);
                this.commonQueryDialog.setProcessor((IProcessor)new SCMCommonProcessor());
                this.commonQueryDialog.addUserPanel((KDPanel)this.getFilterUI());
            }
            catch (Exception e) {
                this.handUIException(e);
                SysUtil.abort();
            }
        }
        return this.commonQueryDialog;
    }

    protected boolean initDefaultFilter() {
        return true;
    }

    protected CustomerQueryPanel getFilterUI() throws Exception {
        if (this.conditionPanel == null) {
            this.conditionPanel = new MaterialMiddleFilterUI();
        }
        return this.conditionPanel;
    }

    protected String[] getQueryShowField() {
        return new String[]{COL_FLAG, COL_OPTTYPE, COL_LOT, COL_NUMBER, COL_NAME, COL_MODEL, COL_SHORTNAME, COL_MATERIALGROUP, COL_BASEUNIT, COL_PICTURENUMBER, COL_LENGTHUNIT, COL_LENGTH, COL_WIDTH, COL_HEIGHT, COL_WEIGHTUNIT, COL_GROSSWEIGHT, COL_NETWEIGHT, COL_VOLUMNUNIT, COL_VOLUME, COL_PDMNUMBER, COL_PDMMATERIALGROUP, COL_PDMBASEUNIT, COL_PDMLENGTHUNIT, COL_PDMWEIGHTUNIT, COL_PDMVOLUMNUNIT, COL_PDMCU, COL_CUNAME};
    }

    @Override
    public void loadFields() {
        super.loadFields();
        int precision = this.defaultPrecision;
        Object precisionObj = null;
        for (int i = 0; i <= this.tblMain.getRowCount(); ++i) {
            precisionObj = this.tblMain.getCell(i, COL_LENGTHUNIT_QTYPRECISION).getValue();
            if (precisionObj != null) {
                precision = Integer.parseInt(precisionObj.toString());
            }
            this.setCellValue(this.tblMain.getCell(i, COL_LENGTH), precision);
            this.setCellValue(this.tblMain.getCell(i, COL_WIDTH), precision);
            this.setCellValue(this.tblMain.getCell(i, COL_HEIGHT), precision);
            precision = this.defaultPrecision;
            precisionObj = this.tblMain.getCell(i, COL_WEIGHTUNIT_QTYPRECISION).getValue();
            if (precisionObj != null) {
                precision = Integer.parseInt(precisionObj.toString());
            }
            this.setCellValue(this.tblMain.getCell(i, COL_GROSSWEIGHT), precision);
            this.setCellValue(this.tblMain.getCell(i, COL_NETWEIGHT), precision);
            precision = this.defaultPrecision;
            precisionObj = this.tblMain.getCell(i, COL_VOLUMNUNIT_QTYPRECISION).getValue();
            if (precisionObj != null) {
                precision = Integer.parseInt(precisionObj.toString());
            }
            this.setCellValue(this.tblMain.getCell(i, COL_VOLUME), precision);
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        if (!this.verify(e.getActionCommand())) {
            return;
        }
        super.actionEdit_actionPerformed(e);
        this.refresh(e);
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        super.actionView_actionPerformed(e);
        this.refreshList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        int failNum;
        if (!this.verify(e.getActionCommand())) {
            return;
        }
        String[] ids = this.getSelectedIds();
        if (ids == null || ids.length == 0) {
            return;
        }
        IMaterialMiddle materialmiddle = (IMaterialMiddle)this.getBizInterface();
        ActionResults actionResults = new ActionResults();
        try {
            this.setOprtState("EDIT");
            for (int i = 0; i < ids.length; ++i) {
                this.pubFireVOChangeListener(ids[i]);
            }
            actionResults = materialmiddle.delete(ids);
        }
        catch (Exception exc) {
            this.handUIExceptionAndAbort(exc);
        }
        catch (Throwable exc) {
            actionResults.addErrors(ids, exc.getMessage());
            this.abort();
        }
        finally {
            this.setOprtState("RELEASEALL");
            try {
                this.pubFireVOChangeListener("");
            }
            catch (Throwable e1) {
                this.handUIException(e1);
            }
        }
        int totalNum = ids.length;
        int sucNum = 0;
        List todoList = actionResults.getToDoIdsList();
        if (todoList != null && todoList.size() > 0) {
            sucNum = todoList.size();
        }
        if ((failNum = totalNum - sucNum) == 0) {
            this.setMessageText(this.getResource("Code_Remove_Finished"));
            this.showMessage();
        } else {
            String[] strs = new String[]{String.valueOf(totalNum), String.valueOf(failNum)};
            String message = this.getResource("Detail_Error_Title", strs);
            StringBuffer errorsMsg = new StringBuffer();
            Map errorsMap = actionResults.getErrors();
            String msg = null;
            for (int i = 0; i < ids.length; ++i) {
                msg = (String)errorsMap.get(ids[i]);
                if (msg == null) continue;
                errorsMsg.append("  ").append(msg).append("\n");
            }
            MsgBox.showDetailAndOK((Component)((Object)this), (String)message, (String)errorsMsg.toString(), (int)8188);
        }
        this.refreshList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionCodeMatch_actionPerformed(ActionEvent e) throws Exception {
        if (!this.verify(e.getActionCommand())) {
            return;
        }
        String[] ids = this.getSelectedIds();
        if (ids == null || ids.length == 0) {
            return;
        }
        IMaterialMiddle materialmiddle = (IMaterialMiddle)this.getBizInterface();
        ActionResults actionResults = new ActionResults();
        try {
            this.setOprtState("EDIT");
            for (int i = 0; i < ids.length; ++i) {
                this.pubFireVOChangeListener(ids[i]);
            }
            actionResults = materialmiddle.codeMatch(ids);
        }
        catch (Exception exc) {
            this.handUIExceptionAndAbort(exc);
        }
        catch (Throwable exc) {
            actionResults.addErrors(ids, exc.getMessage());
        }
        finally {
            try {
                this.pubFireVOChangeListener("");
            }
            catch (Throwable e1) {
                this.handUIException(e1);
            }
        }
        this.setMessageText(this.getResource("Code_Match_Finished"));
        this.showMessage();
        this.refreshList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionTransmit_actionPerformed(ActionEvent e) throws Exception {
        if (!this.verify(e.getActionCommand())) {
            return;
        }
        String[] ids = this.getSelectedIds();
        if (ids == null || ids.length == 0) {
            return;
        }
        IMaterialMiddle materialmiddle = (IMaterialMiddle)this.getBizInterface();
        try {
            this.setOprtState("EDIT");
            for (int i = 0; i < ids.length; ++i) {
                this.pubFireVOChangeListener(ids[i]);
            }
            materialmiddle.transmit(ids);
        }
        catch (Exception exc) {
            this.handUIExceptionAndAbort(exc);
        }
        catch (Throwable exc) {
            this.handleException(new Exception(exc));
        }
        finally {
            try {
                this.pubFireVOChangeListener("");
            }
            catch (Throwable e1) {
                this.handUIException(e1);
            }
        }
        this.setMessageText(this.getResource("Transmit_Finished"));
        this.showMessage();
        this.refreshList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionNoTransmit_actionPerformed(ActionEvent e) throws Exception {
        int failNum;
        if (!this.verify(e.getActionCommand())) {
            return;
        }
        IMaterialMiddle materialmiddle = (IMaterialMiddle)this.getBizInterface();
        String[] ids = this.getSelectedIds();
        if (ids == null || ids.length == 0) {
            return;
        }
        ActionResults actionResults = new ActionResults();
        try {
            this.setOprtState("EDIT");
            for (int i = 0; i < ids.length; ++i) {
                this.pubFireVOChangeListener(ids[i]);
            }
            actionResults = materialmiddle.noTransmit(ids);
        }
        catch (Exception exc) {
            this.handUIExceptionAndAbort(exc);
        }
        catch (Throwable exc) {
            actionResults.addErrors(ids, exc.getMessage());
        }
        finally {
            try {
                this.pubFireVOChangeListener("");
            }
            catch (Throwable e1) {
                this.handUIException(e1);
            }
        }
        int totalNum = ids.length;
        int sucNum = 0;
        List todoList = actionResults.getToDoIdsList();
        if (todoList != null && todoList.size() > 0) {
            sucNum = todoList.size();
        }
        if ((failNum = totalNum - sucNum) == 0) {
            this.setMessageText(this.getResource("No_Transmit_Finished"));
            this.showMessage();
        } else {
            String[] strs = new String[]{String.valueOf(totalNum), String.valueOf(failNum)};
            String message = this.getResource("Detail_Error_Title", strs);
            String errorStr = actionResults.getDetailErrors();
            MsgBox.showDetailAndOK((Component)((Object)this), (String)message, (String)errorStr, (int)8188);
        }
        this.refreshList();
    }

    @Override
    public void actionBatchEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        super.actionBatchEdit_actionPerformed(e);
        IUIFactory uiFactory = null;
        Map map = this.getUIContext();
        map.put("Owner", this);
        map.put("idlist", this.getSelectedIdValues());
        try {
            uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
            IUIWindow groupDialog = uiFactory.create("com.kingdee.eas.mm.pdm.client.BatchModifyMaterialUI", map);
            groupDialog.show();
        }
        catch (BOSException ex) {
            this.handleException((Exception)((Object)ex));
        }
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
    }

    public void onShow() throws Exception {
        super.onShow();
        KDTableUtils.setDefaultFreezeCol((KDTable)this.tblMain, (int)this.freezeColIndex);
    }

    private void initButton() {
        this.btnCodeMatch.setIcon(EASResource.getIcon((String)"imgTbtn_fmakeknown"));
        this.menuItemCodeMatch.setIcon(EASResource.getIcon((String)"imgTbtn_fmakeknown"));
        this.btnTransmit.setIcon(EASResource.getIcon((String)"imgTbtn_maintenance"));
        this.menuItemTransmit.setIcon(EASResource.getIcon((String)"imgTbtn_maintenance"));
        this.btnNoTransmit.setIcon(EASResource.getIcon((String)"imgTbtn_creat"));
        this.menuItemNoTransmit.setIcon(EASResource.getIcon((String)"imgTbtn_creat"));
        this.btnImportData.setIcon(EASResource.getIcon((String)"imgTbtn_input"));
        this.btnExportData.setIcon(EASResource.getIcon((String)"imgTbtn_output"));
        this.actionCodeMatch.setEnabled(true);
        this.actionTransmit.setEnabled(true);
        this.actionNoTransmit.setEnabled(true);
        this.btnAuditResult.setVisible(false);
        this.btnAttachment.setVisible(false);
        this.MenuItemAttachment.setVisible(false);
        this.actionRemove.setEnabled(true);
    }

    private void initWidget() {
        this.registerF7ForColumn(COL_MATERIALGROUP, "com.kingdee.eas.basedata.master.material.app.F7MaterialGroupQuery");
        this.registerF7ForColumn(COL_BASEUNIT, "com.kingdee.eas.basedata.assistant.app.F7MeasureUnitQuery");
        this.registerF7ForColumn(COL_LENGTHUNIT, "com.kingdee.eas.basedata.assistant.app.F7MeasureUnitQuery");
        this.registerF7ForColumn(COL_WEIGHTUNIT, "com.kingdee.eas.basedata.assistant.app.F7MeasureUnitQuery");
        this.registerF7ForColumn(COL_VOLUMNUNIT, "com.kingdee.eas.basedata.assistant.app.F7MeasureUnitQuery");
        this.registerF7ForColumn(COL_TRANSMITUSER, "com.kingdee.eas.base.permission.app.F7AllUserQuery");
    }

    private void registerF7ForColumn(String columnName, String queryInfo) {
        KDBizPromptBox prmtBox = new KDBizPromptBox();
        prmtBox.setQueryInfo(queryInfo);
        prmtBox.setCommitFormat("$number$");
        prmtBox.setDisplayFormat("$name$");
        prmtBox.setEditFormat("$number$");
        IColumn column = this.tblMain.getColumn(columnName);
        column.setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtBox));
    }

    private boolean verify(String actionCommand) {
        this.checkSelected();
        actionCommand = actionCommand.toLowerCase();
        if (actionCommand.endsWith("edit")) {
            int[] rows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
            ICell cell = this.tblMain.getCell(rows[0], COL_FLAG);
            BizEnumValueDTO bizEnum = (BizEnumValueDTO)cell.getValue();
            int flag = bizEnum.getInt();
            if (flag == 20 || flag == 60) {
                MsgBox.showWarning((Component)((Object)this), (String)this.getResource("Not_Edit"));
                return false;
            }
        } else if (actionCommand.endsWith("remove")) {
            return this.confirmRemove();
        }
        return true;
    }

    private String[] getSelectedIds() {
        int[] rows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        if (rows == null || rows.length == 0) {
            return null;
        }
        HashSet<String> set = new HashSet<String>();
        ICell cell = null;
        String id = null;
        for (int i = 0; i < rows.length; ++i) {
            cell = this.tblMain.getCell(rows[i], COL_ID);
            id = cell.getValue().toString();
            if (set.contains(id)) continue;
            set.add(id);
        }
        Object[] objs = set.toArray();
        String[] ids = new String[objs.length];
        System.arraycopy(objs, 0, ids, 0, objs.length);
        return ids;
    }

    private BigDecimal getValue(BigDecimal val, int precision) {
        if (val.compareTo(MMConstant.BIGDECIMAL_ZERO) == 0) {
            return null;
        }
        BigDecimal rst = null;
        rst = val.setScale(precision, 4);
        return rst;
    }

    private void setCellValue(ICell cell, int precision) {
        BigDecimal bd = (BigDecimal)cell.getValue();
        if (bd == null) {
            return;
        }
        cell.setValue((Object)this.getValue(bd, precision));
    }

    private String getResource(String key) {
        return ResourceUtils.getMessageForClient((String)RESOURCE_PATH, (String)key);
    }

    private String getResource(String key, String[] params) {
        return ResourceUtils.getMessageForClient((String)RESOURCE_PATH, (String)key, (String[])params);
    }
}

