/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.bos.ctrl.excel.model.util.SortedParameterArray;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.rpt.IBackfillHandler;
import com.kingdee.eas.fi.rpt.batch.DiscreteAcctBackfill;
import com.kingdee.eas.mm.planning.MMBatchCalculater;
import com.kingdee.eas.mm.planning.MMParamBean;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;

public class MMPlanCorrectedValueCalculater
extends MMBatchCalculater {
    public MMPlanCorrectedValueCalculater(ICalculateContextProvider contextProvider) {
        super(contextProvider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(SortedParameterArray paramArray) throws SQLException {
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)this.contextProvider.getServerContext());
            int querySize = paramArray.size();
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            Parameter param = null;
            MMParamBean mmBean = null;
            for (int queryIndex = 0; queryIndex < querySize; ++queryIndex) {
                param = paramArray.getParameter(queryIndex);
                if (null == param) continue;
                mmBean = new MMParamBean(param);
                if (null == mmBean.getBackFiller()) {
                    mmBean.setBackFiller((IBackfillHandler)new DiscreteAcctBackfill(param));
                }
                String[] materialNumber = this.getChangeNumberArray(mmBean.getMaterialNumber());
                String[] storageNumber = this.getChangeNumberArray(mmBean.getStorageOrgNumber());
                if (null != materialNumber && materialNumber.length > 0 && null != storageNumber && storageNumber.length > 0) {
                    block11: {
                        try {
                            pstmt = conn.prepareStatement(this.getSql(mmBean));
                            BigDecimal tmp = new BigDecimal("0.00");
                            rs = pstmt.executeQuery();
                            while (rs.next()) {
                                tmp = tmp.add(rs.getBigDecimal(this.getReturnField()));
                            }
                            if (null != tmp) {
                                mmBean.getBackFiller().setValue((Object)tmp);
                                break block11;
                            }
                            mmBean.getBackFiller().setValue((Object)new BigDecimal("0.00"));
                        }
                        catch (Exception e) {
                            try {
                                mmBean.getBackFiller().setException((Throwable)e);
                            }
                            catch (Throwable throwable) {
                                SQLUtils.cleanup(rs, pstmt);
                                throw throwable;
                            }
                            SQLUtils.cleanup(rs, (Statement)pstmt);
                            continue;
                        }
                    }
                    SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt);
                    continue;
                }
                mmBean.getBackFiller().setValue((Object)new BigDecimal("0.00"));
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(conn);
            throw throwable;
        }
        SQLUtils.cleanup((Connection)conn);
    }

    protected String getSql() {
        StringBuffer sql = new StringBuffer();
        sql.append("select sum(Fproductionqty) ").append(this.getReturnField());
        sql.append(" from T_MM_sopplan where FEditMode = 20 and FperiodNumber in ( ? ) and FparentId in ");
        sql.append(" (select sopbill.fid from T_MM_SopBill sopbill,T_MM_SOPPlanVersion sopplanversion,T_BD_Material material,T_ORG_Storage storage ");
        sql.append(" where sopbill.FStorageOrgUnitID = storage.fid and storage.fnumber in (?) and");
        sql.append(" sopbill.FPlanVersionID = sopplanversion.fid and sopplanversion.fnumber = '000' and ");
        sql.append(" sopbill.FMaterialID = material.fid and material.Fnumber in (?)) ");
        return sql.toString();
    }

    protected String getSql(MMParamBean mmBean) {
        int i;
        StringBuffer sql = new StringBuffer();
        Object[] periodNumberArray = this.getPeriodNumberArray(mmBean);
        String[] storageNumber = this.getChangeNumberArray(mmBean.getStorageOrgNumber());
        String[] materialNumber = this.getChangeNumberArray(mmBean.getMaterialNumber());
        boolean isFirstAppend = true;
        sql.append("select sum(isnull(sopplan.FProductionQty,0) * isnull(measure.FBaseConvsRate,1)) ").append(this.getReturnField());
        sql.append(" from T_MM_SOPPLAN as sopplan ");
        sql.append("inner join T_MM_SOPBILL as sopbill on sopplan.FParentID = sopbill.FID ");
        sql.append("inner join T_MM_SOPPlanVersion as sopplanversion on sopbill.FPlanVersionID = sopplanversion.fid ");
        sql.append("inner join T_BD_Material as material on sopbill.FMaterialID = material.fid ");
        sql.append("inner join T_ORG_Storage as storage on sopbill.FSupplyStorageOrgUnitID = storage.fid ");
        sql.append("inner join T_BD_MaterialPlan as materialplan on material.FID = materialplan.FMaterialID ");
        sql.append("and storage.fid = materialplan.FOrgUnit ");
        sql.append("left join T_BD_MultiMeasureUnit as measure on measure.FMaterialID = materialplan.FMaterialID ");
        sql.append("and measure.FMeasureUnitID = materialplan.FProductUnitID ");
        sql.append("where sopplanversion.fnumber = '000'");
        sql.append("and  material.Fnumber in ( ");
        if (null != materialNumber) {
            for (i = 0; i < materialNumber.length; ++i) {
                if (isFirstAppend) {
                    sql.append("'").append(materialNumber[i].trim()).append("'");
                    isFirstAppend = false;
                    continue;
                }
                sql.append(",").append("'").append(materialNumber[i].trim()).append("'");
            }
        } else {
            sql.append("'").append("null").append("'");
        }
        isFirstAppend = true;
        sql.append(" )");
        sql.append("and  storage.fnumber in (");
        if (null != storageNumber) {
            for (i = 0; i < storageNumber.length; ++i) {
                if (isFirstAppend) {
                    sql.append("'").append(storageNumber[i].trim()).append("'");
                    isFirstAppend = false;
                    continue;
                }
                sql.append(",").append("'").append(storageNumber[i].trim()).append("'");
            }
        } else {
            sql.append("'").append("null").append("'");
        }
        sql.append(" )");
        isFirstAppend = true;
        sql.append("and  sopplan.FEditMode = 20 ");
        sql.append("and  sopplan.FperiodNumber in (");
        if (null != periodNumberArray) {
            for (i = 0; i < periodNumberArray.length; ++i) {
                if (isFirstAppend) {
                    sql.append(Integer.valueOf(periodNumberArray[i].toString()));
                    isFirstAppend = false;
                    continue;
                }
                sql.append(" , ").append(Integer.valueOf(periodNumberArray[i].toString()));
            }
        } else {
            sql.append("'").append("null").append("'");
        }
        sql.append(" )");
        sql.append(" group by material.Fnumber , storage.fnumber");
        return sql.toString();
    }

    private Object[] getPeriodNumberArray(MMParamBean mmBean) {
        int startYear;
        ArrayList<Integer> result = new ArrayList<Integer>();
        if (null == mmBean) {
            return null;
        }
        int startMonth = Integer.valueOf(mmBean.getPlanPeriodNumberMonth());
        int size = Integer.valueOf(mmBean.getPeriodTimes());
        int endYear = startYear + (startMonth + size - 1) / 12;
        int endMonth = (startMonth + size - 1) % 12;
        for (startYear = Integer.valueOf(mmBean.getPlanPeriodNumberYear()).intValue(); startYear < endYear; ++startYear) {
            while (startMonth < 13) {
                result.add(new Integer(startYear * 100 + startMonth));
                ++startMonth;
            }
            startMonth = 1;
        }
        if (startYear == endYear) {
            while (startMonth <= endMonth) {
                result.add(new Integer(startYear * 100 + startMonth));
                ++startMonth;
            }
        }
        return result.toArray();
    }

    @Override
    protected String[] getParameterProperty() {
        return new String[]{"storageOrgNumber", "planVersionNumber", "materialNumber"};
    }

    @Override
    protected String[] getParameterPropertySplit() {
        return new String[]{";", ";", ";"};
    }

    @Override
    protected void innerLoadNumberID(int index, HashMap map, Set numberSet) throws Exception {
    }

    private String[] getChangeNumberArray(String resource) {
        if (null == resource) {
            return null;
        }
        String[] result = resource.split(";");
        if (result != null) {
            for (int i = 0; i < result.length; ++i) {
                result[i] = result[i].trim();
            }
        }
        return result;
    }
}

