/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.mm.planning.SOPEditModeEnum;
import com.kingdee.eas.mm.planning.SOPPeriod;
import com.kingdee.eas.mm.planning.SOPSysParams;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.Date;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;

public class SopDateUtil {
    private static IRowSet getWorkDayRS(Context ctx, String storageOrgUnitId, SOPPeriod[] range) throws BOSException, SQLException {
        if (range == null) {
            return null;
        }
        String clr = "\r\n";
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT t0.FWorkDate ").append(clr).append("  FROM t_mm_factorycalendarentry t0 ,t_mm_factorycalendar t1 ").append(clr).append(" WHERE t0.fparentid = t1.fid ").append(clr).append("   AND t0.fworkdate > ? ").append(clr).append("   AND t0.fworkdate < ? ").append(clr).append("   AND t1.fstorageorgunitid = ? ").append(clr).append("   AND t0.FWorkDateSeq > 0").append(clr).append(" ORDER BY t0.FWorkDateSeq ASC;");
        Calendar begin = (Calendar)range[0].getBeginDate().clone();
        begin.add(5, -1);
        Calendar end = (Calendar)range[range.length - 1].getEndDate().clone();
        end.add(5, 1);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{new Date(begin.getTimeInMillis()), new Date(end.getTimeInMillis()), storageOrgUnitId});
        return rs;
    }

    public static Map getPeriod2DayMap(Context ctx, String storageOrgUnitId, SOPPeriod[] range) throws BOSException {
        int curDateNumber = SopDateUtil.getCurDateNumber();
        HashMap<String, ArrayList<Calendar>> period2Day = new HashMap<String, ArrayList<Calendar>>();
        try {
            IRowSet rs = SopDateUtil.getWorkDayRS(ctx, storageOrgUnitId, range);
            block2: while (rs.next()) {
                Calendar date = Calendar.getInstance();
                date.setTime(rs.getDate("FWorkDate"));
                for (int i = 0; i < range.length; ++i) {
                    if (SopDateUtil.compareCalendarIgnoreTime(date, range[i].getBeginDate()) < 0 || SopDateUtil.compareCalendarIgnoreTime(date, range[i].getEndDate()) > 0) continue;
                    String key = Integer.toString(range[i].toNumber());
                    ArrayList<Calendar> dateArray = (ArrayList<Calendar>)period2Day.get(key);
                    if (dateArray == null) {
                        dateArray = new ArrayList<Calendar>();
                        period2Day.put(key, dateArray);
                    }
                    dateArray.add(date);
                    continue block2;
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return period2Day;
    }

    public static Map getPeriod2DayMap(Context ctx, String storageOrgUnitId, SOPPeriod[] range, SOPSysParams param) throws BOSException {
        HashMap<String, ArrayList<Calendar>> period2Day = new HashMap<String, ArrayList<Calendar>>();
        try {
            range = SopDateUtil.changeRange(range[0], range.length, param);
            IRowSet rs = SopDateUtil.getWorkDayRS(ctx, storageOrgUnitId, range);
            block2: while (rs.next()) {
                Calendar date = Calendar.getInstance();
                date.setTime(rs.getDate("FWorkDate"));
                for (int i = 0; i < range.length; ++i) {
                    if (SopDateUtil.compareCalendarIgnoreTime(date, range[i].getBeginDate()) < 0 || SopDateUtil.compareCalendarIgnoreTime(date, range[i].getEndDate()) > 0) continue;
                    String key = Integer.toString(range[i].toNumber());
                    ArrayList<Calendar> dateArray = (ArrayList<Calendar>)period2Day.get(key);
                    if (dateArray == null) {
                        dateArray = new ArrayList<Calendar>();
                        period2Day.put(key, dateArray);
                    }
                    dateArray.add(date);
                    continue block2;
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return period2Day;
    }

    private static SOPPeriod[] changeRange(SOPPeriod period, int size, SOPSysParams param) {
        SOPPeriod start = new SOPPeriod();
        if (period.getType().equals((Object)SOPEditModeEnum.MONTHLY)) {
            int year = period.getYear();
            start.setYear(year);
            start.setNumber(period.getNumber());
            int month = period.getNumber() - 1;
            int beginDay = param.getSOPMonthStartDate();
            start.setParamMonthStartDay(beginDay);
            Calendar beginDate = Calendar.getInstance();
            Calendar endDate = Calendar.getInstance();
            if (beginDay > 15) {
                beginDate.set(1, year);
                beginDate.set(2, month - 1);
                beginDate.set(5, beginDay);
                endDate.set(1, year);
                endDate.set(2, month);
                endDate.set(5, beginDay - 1);
                start.setBeginDate(beginDate);
                start.setEndDate(endDate);
            } else {
                beginDate.set(1, year);
                beginDate.set(2, month);
                beginDate.set(5, beginDay);
                if (beginDay == 1) {
                    endDate = SopDateUtil.getLastDayOfMonth(year, month);
                } else {
                    endDate.set(1, year);
                    endDate.set(2, month + 1);
                    endDate.set(5, beginDay - 1);
                }
                start.setEndDate(endDate);
                start.setBeginDate(beginDate);
            }
            start.setType(SOPEditModeEnum.MONTHLY);
        } else {
            Calendar beginDate = period.getBeginDate();
            Calendar endDate = period.getEndDate();
            int firstDayOfWeek = param.getSOPWeekStartDay();
            Calendar newBeginDate = (Calendar)beginDate.clone();
            Calendar newEndDate = (Calendar)endDate.clone();
            int day = beginDate.get(7);
            if (firstDayOfWeek == 0) {
                newBeginDate.setFirstDayOfWeek(2);
                newEndDate.setFirstDayOfWeek(2);
            } else if (firstDayOfWeek == 1) {
                newBeginDate.setFirstDayOfWeek(1);
                newEndDate.setFirstDayOfWeek(1);
            }
            if (day == 2 && firstDayOfWeek == 1) {
                newBeginDate.set(6, beginDate.get(6) - 1);
                newEndDate.set(6, endDate.get(6) - 1);
            } else if (day == 1 && firstDayOfWeek == 0) {
                newBeginDate.set(6, beginDate.get(6) + 1);
                newEndDate.set(6, endDate.get(6) + 1);
            }
            start.setBeginDate(newBeginDate);
            start.setEndDate(newEndDate);
            start.setNumber(newBeginDate.get(3));
            start.setYear(newBeginDate.get(1));
            start.setParamMonthStartDay(period.getParamMonthStartDay());
            start.setType(SOPEditModeEnum.WEEKLY);
        }
        if (size == 1) {
            return new SOPPeriod[]{start};
        }
        return start.forwardPeriods(size);
    }

    public static boolean isTodayBetween(Calendar d1, Calendar d2) {
        Calendar today = SopDateUtil.getToday();
        return SopDateUtil.compareCalendarIgnoreTime(today, d1) >= 0 && SopDateUtil.compareCalendarIgnoreTime(today, d2) <= 0;
    }

    public static int compareCalendarIgnoreTime(Calendar d1, Calendar d2) {
        int d2Int;
        int d1Int = d1.get(1) * 10000 + (d1.get(2) + 1) * 100 + d1.get(5);
        return d1Int > (d2Int = d2.get(1) * 10000 + (d2.get(2) + 1) * 100 + d2.get(5)) ? 1 : (d1Int == d2Int ? 0 : -1);
    }

    public static int compareCalendarIgnoreTime(Calendar d1, int d2Int) {
        int d1Int = d1.get(1) * 10000 + (d1.get(2) + 1) * 100 + d1.get(5);
        return d1Int > d2Int ? 1 : (d1Int == d2Int ? 0 : -1);
    }

    public static int getNumberFromCalendar(Calendar date) {
        return date.get(1) * 10000 + (date.get(2) + 1) * 100 + date.get(5);
    }

    public static int getCurDateNumber() {
        int curDateNumber = SopDateUtil.getNumberFromCalendar(SopDateUtil.getToday());
        return curDateNumber;
    }

    private static Calendar getToday() {
        Calendar curDate = Calendar.getInstance();
        curDate.set(10, 0);
        curDate.set(12, 0);
        curDate.set(13, 0);
        return curDate;
    }

    public static Calendar getLastDayOfMonth(int year, int month) {
        Calendar date = Calendar.getInstance();
        date.set(1, year);
        date.set(2, month);
        date.set(5, 1);
        date.add(2, 1);
        date.add(6, -1);
        return date;
    }

    public static Calendar getSpecifiedDayOfMonth(int year, int month, int dayOfMonth) {
        Calendar retDate = Calendar.getInstance();
        retDate.set(1, year);
        retDate.set(2, month);
        retDate.set(5, dayOfMonth);
        if (retDate.get(2) != month) {
            retDate = SopDateUtil.getLastDayOfMonth(year, month);
        }
        return retDate;
    }

    public static Calendar getSpecifiedDayOfMonth(int period, int dayOfMonth) {
        Calendar date = SopDateUtil.getToday();
        int year = period / 100;
        int month = period % 100 - 1;
        date = SopDateUtil.getSpecifiedDayOfMonth(year, month, dayOfMonth);
        return date;
    }

    public static Calendar getNewSpecifiedDayOfMonth(int period, int dayOfMonth, int startDay) {
        int year = period / 100;
        int month = startDay < 16 ? period % 100 - 1 : period % 100 - 2;
        int sumDay = dayOfMonth + startDay - 1;
        Calendar retDate = Calendar.getInstance();
        retDate.set(1, year);
        retDate.set(2, month);
        retDate.set(5, sumDay);
        if (retDate.get(5) >= startDay && retDate.get(2) > month && month >= 0) {
            if (startDay == 1) {
                retDate = SopDateUtil.getLastDayOfMonth(year, month);
            } else {
                retDate.set(5, startDay - 1);
            }
        }
        return retDate;
    }

    public static Calendar getSpecifiedDayOfWeek(int period, int dayOfWeek) {
        Calendar date = SopDateUtil.getToday();
        date.set(1, period / 100);
        date.set(3, period % 100);
        date.set(7, dayOfWeek);
        return date;
    }
}

