/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.extendcontrols.ext.IFilterInfoProducer;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.event.CommitEvent;
import com.kingdee.bos.ctrl.swing.event.CommitListener;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.PreChangeEvent;
import com.kingdee.bos.ctrl.swing.event.PreChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.form.model.combin.CombinUIApplication;
import com.kingdee.eas.base.form.model.combin.IPlugUI;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.NewOrgUnitFilterInfoProducer;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.mm.basedata.AvailableWarehouseEntryCollection;
import com.kingdee.eas.mm.basedata.AvailableWarehouseEntryInfo;
import com.kingdee.eas.mm.basedata.CollaPlanVersionSetBillsCollection;
import com.kingdee.eas.mm.basedata.CollaPlanVersionSetBillsInfo;
import com.kingdee.eas.mm.basedata.CollabAllocateBillInfo;
import com.kingdee.eas.mm.basedata.CollabPlanVersionEntryInfo;
import com.kingdee.eas.mm.basedata.CollabPlanVersionFactory;
import com.kingdee.eas.mm.basedata.CollabPlanVersionInfo;
import com.kingdee.eas.mm.basedata.CollabPlanVersionSetStoreStateCollection;
import com.kingdee.eas.mm.basedata.CollabPlanVersionSetStoreStateInfo;
import com.kingdee.eas.mm.basedata.CollabPlanVersionSetStoreTypeCollection;
import com.kingdee.eas.mm.basedata.CollabPlanVersionSetStoreTypeInfo;
import com.kingdee.eas.mm.common.client.MMUtils;
import com.kingdee.eas.mm.common.util.EditTableUtil;
import com.kingdee.eas.mm.planning.IMRPCalcFacade;
import com.kingdee.eas.mm.planning.MRPCalcFacadeFactory;
import com.kingdee.eas.mm.planning.MRPException;
import com.kingdee.eas.mm.planning.MRPRunLogFactory;
import com.kingdee.eas.mm.planning.MRPRunLogInfo;
import com.kingdee.eas.mm.planning.MrpRunEnum;
import com.kingdee.eas.mm.planning.PlanningConst;
import com.kingdee.eas.mm.planning.client.AbstractCMPSRunEditUI;
import com.kingdee.eas.mm.planning.client.ProgressDialog;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class CMPSRunEditUI
extends AbstractCMPSRunEditUI
implements IPlugUI {
    private static final Logger logger = CoreUIObject.getLogger(CMPSRunEditUI.class);
    private String strPermissionItem;
    private static final String[] kdcplanversion_colums = new String[]{"planningHorizonSet", "coStorageOrgUnit", "warehouseRange", "remark", "isCareScheduleRec", "isCareAvailStock"};
    private static final String[] kdWareHous_colums = new String[]{"number", "name", "address", "hasLocation", "whState", "region", "whman"};
    private static final String[] storetype_colums = new String[]{"storeType.number", "storeType.name", "isMrpRun", "id"};
    private static final String[] storestore_colums = new String[]{"storeState.number", "storeState.name", "isMrpRun", "id"};
    private static final String[] billtable_colums = new String[]{"billTypeId", "priority", "isParticipation", "bizTypeId", "ID"};
    public static final String strResource = "com.kingdee.eas.mm.planning.client.PlanningResource.";
    private CombinUIApplication application;

    public void onLoad() throws Exception {
        super.onLoad();
        this.menuItemCancelCancel.setIcon(EASResource.getIcon((String)"imgTbtn_execute"));
        this.kdcplanversion.checkParsed();
        this.kdWareHous.checkParsed();
        this.prmtStorageOrgUnit.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                StorageOrgUnitInfo org = (StorageOrgUnitInfo)e.getNewValue();
                if (org == null) {
                    CMPSRunEditUI.this.prmtCplanVersion.setValue(null);
                    CMPSRunEditUI.this.pkStartTime.setValue(null);
                    return;
                }
                CMPSRunEditUI.this.application.getApplicationContext().putData("storageOrgUnit.number", (Object)org.getNumber());
                String storageId = org.getId().toString();
                CMPSRunEditUI.this.setF7PlanVersion(CMPSRunEditUI.this.prmtCplanVersion, storageId);
                CMPSRunEditUI.this.prmtCplanVersion.setValue(null);
                try {
                    CMPSRunEditUI.this.pkStartTime.setValue(null);
                    CMPSRunEditUI.this.pkStartTime.setValue((Object)CMPSRunEditUI.this.getNextWorkDay());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.prmtStorageOrgUnit.addPreChangeListener(new PreChangeListener(){

            public void preChange(PreChangeEvent arg0) {
                if (arg0.getOldData() == null || arg0.getData() != null && arg0.getData().equals(arg0.getOldData())) {
                    return;
                }
                if (arg0.getData() == null && arg0.getSource().equals(CMPSRunEditUI.this.prmtStorageOrgUnit)) {
                    CMPSRunEditUI.this.prmtStorageOrgUnit.setValue(arg0.getOldData());
                    CMPSRunEditUI.this.prmtStorageOrgUnit.requestFocus(true);
                    arg0.setResult(0);
                    return;
                }
            }
        });
        this.prmtCplanVersion.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                CollabPlanVersionInfo collabPlanVersionInfo = (CollabPlanVersionInfo)e.getNewValue();
                CMPSRunEditUI.this.cPanVersionChange(collabPlanVersionInfo);
            }
        });
        this.prmtCplanVersion.addCommitListener(new CommitListener(){

            public void willCommit(CommitEvent e) {
                CMPSRunEditUI.this.isOrgExistCheck();
            }
        });
        this.prmtCplanVersion.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                CMPSRunEditUI.this.isOrgExistCheck();
            }
        });
        this.strPermissionItem = "mm_cmps_planGlobal_execution";
        OrgUnitInfo orgUnit = MMUtils.getDefaultMainBizOrg((OrgType)OrgType.Storage, (String)this.strPermissionItem);
        if (orgUnit != null) {
            this.prmtStorageOrgUnit.setValue((Object)orgUnit);
        }
        this.setMainBizOrgF7(this.prmtStorageOrgUnit, OrgType.Storage);
        MRPRunLogInfo info = new MRPRunLogInfo();
        info.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        info.setStartTime(Calendar.getInstance().getTime());
        info.setDesc(" ");
        this.setDataObject((IObjectValue)info);
        info.setRunName(MrpRunEnum.COOPERATE_PLAN);
        this.prmtCollabAllocateBill.setDisplayFormat("$number$");
    }

    private void cPanVersionChange(CollabPlanVersionInfo collabPlanVersionInfo) {
        if (collabPlanVersionInfo != null) {
            try {
                collabPlanVersionInfo = (CollabPlanVersionInfo)CollabPlanVersionFactory.getRemoteInstanceWithObjectContext((Context)this.getMainOrgContext()).getValue((IObjectPK)new ObjectUuidPK(collabPlanVersionInfo.getId().toString()), this.getSelectors());
                this.prmtCollabAllocateBill.setValue((Object)collabPlanVersionInfo.getCoAllocateBill());
            }
            catch (EASBizException e1) {
                this.handUIException(e1);
            }
            catch (BOSException e1) {
                this.handUIException(e1);
            }
        } else {
            this.prmtCollabAllocateBill.setValue(null);
        }
        this.loadLine(collabPlanVersionInfo);
    }

    private void isOrgExistCheck() {
        if (this.prmtStorageOrgUnit.getValue() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.mm.planning.client.PlanningResource.CMPS_IMPUT_ORG"));
            SysUtil.abort();
        }
    }

    private void loadLine(CollabPlanVersionInfo collabPlanVersionInfo) {
        this.kdcplanversion.removeRows();
        this.kdWareHous.removeRows();
        this.storeStore.removeRows();
        this.storetype.removeRows();
        this.billtable.removeRows();
        EditTableUtil.setColLock((KDTable)this.storeStore, (String[])storestore_colums, (boolean)true);
        EditTableUtil.setColLock((KDTable)this.storetype, (String[])storetype_colums, (boolean)true);
        EditTableUtil.setColLock((KDTable)this.billtable, (String[])billtable_colums, (boolean)true);
        if (collabPlanVersionInfo == null) {
            return;
        }
        IRow row = this.kdcplanversion.addRow();
        CollabPlanVersionEntryInfo collabPlanVersionEntryInfo = collabPlanVersionInfo.getEntrys().get(0);
        for (int i = 0; i < kdcplanversion_colums.length; ++i) {
            row.getCell(kdcplanversion_colums[i]).getStyleAttributes().setLocked(true);
            if (i == 2) {
                row.getCell(kdcplanversion_colums[i]).setValue((Object)collabPlanVersionEntryInfo.getWarehouseRange());
                continue;
            }
            row.getCell(kdcplanversion_colums[i]).setValue(collabPlanVersionEntryInfo.get(kdcplanversion_colums[i]));
        }
        CollabPlanVersionSetStoreStateCollection storestate = collabPlanVersionEntryInfo.getStorestate();
        CollabPlanVersionSetStoreStateInfo collab = null;
        int n = storestate.size();
        for (int i = 0; i < n; ++i) {
            row = this.storeStore.addRow();
            collab = storestate.get(i);
            row.getCell(storestore_colums[0]).setValue((Object)collab.getStoreState().getNumber());
            row.getCell(storestore_colums[1]).setValue((Object)collab.getStoreState().getName());
            row.getCell(storestore_colums[2]).setValue((Object)new Boolean(collab.isIsMrpRun()));
            row.getCell(storestore_colums[3]).setValue((Object)collab.getId().toString());
        }
        CollabPlanVersionSetStoreTypeCollection storetype2 = collabPlanVersionEntryInfo.getStoretype();
        CollabPlanVersionSetStoreTypeInfo collStoreTypeInfo = null;
        int n2 = storetype2.size();
        for (int i = 0; i < n2; ++i) {
            row = this.storetype.addRow();
            collStoreTypeInfo = storetype2.get(i);
            row.getCell(storetype_colums[0]).setValue((Object)collStoreTypeInfo.getStoreType().getNumber());
            row.getCell(storetype_colums[1]).setValue((Object)collStoreTypeInfo.getStoreType().getName());
            row.getCell(storetype_colums[2]).setValue((Object)new Boolean(collStoreTypeInfo.isIsMrpRun()));
            row.getCell(storestore_colums[3]).setValue((Object)collStoreTypeInfo.getId().toString());
        }
        CollaPlanVersionSetBillsCollection billParam = collabPlanVersionEntryInfo.getBillParam();
        CollaPlanVersionSetBillsInfo collaPlanVersionSetBillsInfo = null;
        int n3 = billParam.size();
        for (int i = 0; i < n3; ++i) {
            collaPlanVersionSetBillsInfo = billParam.get(i);
            row = this.billtable.addRow();
            row.getCell(billtable_colums[0]).setValue((Object)collaPlanVersionSetBillsInfo.getBillType().getName());
            row.getCell(billtable_colums[1]).setValue((Object)new Integer(collaPlanVersionSetBillsInfo.getPriority()));
            row.getCell(billtable_colums[2]).setValue((Object)new Boolean(collaPlanVersionSetBillsInfo.isIsParticipation()));
            String collection = (String)collaPlanVersionSetBillsInfo.get("bizTypeBillName");
            row.getCell(billtable_colums[3]).setValue((Object)collection);
            row.getCell(billtable_colums[4]).setValue((Object)collaPlanVersionSetBillsInfo.getId().toString());
        }
        AvailableWarehouseEntryCollection c = collabPlanVersionEntryInfo.getWarehouseEntrys();
        AvailableWarehouseEntryInfo warehouseEntryInfo = null;
        if (c != null) {
            for (int i = 0; i < c.size(); ++i) {
                row = this.kdWareHous.addRow();
                warehouseEntryInfo = c.get(i);
                for (int j = 0; j < kdWareHous_colums.length - 3; ++j) {
                    if (warehouseEntryInfo.getWarehouse() == null) continue;
                    row.getCell(kdWareHous_colums[j]).getStyleAttributes().setLocked(true);
                    row.getCell(kdWareHous_colums[j]).setValue(warehouseEntryInfo.getWarehouse().get(kdWareHous_colums[j]));
                }
                row.getCell(kdWareHous_colums[4]).getStyleAttributes().setLocked(true);
                row.getCell(kdWareHous_colums[5]).getStyleAttributes().setLocked(true);
                row.getCell(kdWareHous_colums[6]).getStyleAttributes().setLocked(true);
                if (warehouseEntryInfo.getWarehouse() == null) continue;
                if (warehouseEntryInfo.getWarehouse().getWhState() != null) {
                    row.getCell(kdWareHous_colums[4]).setValue((Object)warehouseEntryInfo.getWarehouse().getWhState());
                }
                if (warehouseEntryInfo.getWarehouse().getRegion() != null) {
                    row.getCell(kdWareHous_colums[5]).setValue((Object)warehouseEntryInfo.getWarehouse().getRegion().getName());
                }
                if (warehouseEntryInfo.getWarehouse().getWhman() == null) continue;
                row.getCell(kdWareHous_colums[6]).setValue((Object)warehouseEntryInfo.getWarehouse().getWhman().getName());
            }
        }
    }

    @Override
    public void actionRunMPS_actionPerformed(ActionEvent e) throws Exception {
        this.storeToBoundObject();
        MRPRunLogInfo objRunLog = (MRPRunLogInfo)this.getDataObject();
        StringBuffer sb = new StringBuffer();
        StorageOrgUnitInfo org = objRunLog.getStorageOrgUnit();
        if (org == null) {
            sb.append(EASResource.getString((String)"com.kingdee.eas.mm.planning.client.PlanningResource.CMPS_IMPUT_ORG"));
            sb.append("\n");
        }
        if (this.pkStartTime.getValue() == null) {
            if (org != null) {
                sb.append(org.getName());
            }
            sb.append(EASResource.getString((String)"com.kingdee.eas.mm.planning.client.PlanningResource.MPS_MRP_RUN_NO_PLAN_DATE"));
            sb.append("\n");
        }
        if (this.prmtCplanVersion.getValue() == null) {
            sb.append(EASResource.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"84_CMPSRunEditUI"));
            sb.append("\n");
        }
        if (sb.length() > 0) {
            MsgBox.showError((String)sb.toString());
            return;
        }
        IMRPCalcFacade calcFacade = MRPCalcFacadeFactory.getRemoteInstance();
        this.writeOpLog("CMPS", "CMPS");
        objRunLog.setId(BOSUuid.create((BOSObjectType)objRunLog.getBOSType()));
        objRunLog.setRunName(MrpRunEnum.COOPERATE_PLAN);
        calcFacade.backRun(objRunLog, true);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CMPSRunEditUI.this.showProgressDialog();
            }
        });
    }

    protected IObjectValue createNewData() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return MRPRunLogFactory.getRemoteInstance();
    }

    protected void setMainBizOrgF7(KDBizPromptBox bizOrgUnitBox, OrgType orgType) {
        if (SysContext.getSysContext().getCurrentStorageUnit() != null) {
            NewOrgUnitFilterInfoProducer iProducer = new NewOrgUnitFilterInfoProducer(orgType);
            iProducer.getModel().setPermissionItem(this.strPermissionItem);
            bizOrgUnitBox.setFilterInfoProducer((IFilterInfoProducer)iProducer);
            bizOrgUnitBox.setCommitFormat("$number$;$code$");
        }
    }

    private void storeToBoundObject() {
        MRPRunLogInfo objRunLog = (MRPRunLogInfo)this.getDataObject();
        objRunLog.setIsDelayOrder(this.cbAllowOverduePlanDate.getModel().isSelected());
        objRunLog.setIsManageLLC(this.cbReCalcLLC.getModel().isSelected());
        objRunLog.setStorageOrgUnit((StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue());
        objRunLog.setPlanDate((Date)this.pkStartTime.getValue());
        objRunLog.setCplanVersion((CollabPlanVersionInfo)this.prmtCplanVersion.getValue());
        objRunLog.setCollabAllocateBill((CollabAllocateBillInfo)this.prmtCollabAllocateBill.getValue());
        objRunLog.setIsDelayOrder(this.cbAllowOverduePlanDate.getModel().isSelected());
        objRunLog.setIsCheckBOM(this.cbReCalcLLC.getModel().isSelected());
    }

    private Date getNextWorkDay() throws BOSException, EASBizException {
        IMRPCalcFacade calcFacade = MRPCalcFacadeFactory.getRemoteInstance();
        Date date = null;
        OrgUnitInfo org = (OrgUnitInfo)this.prmtStorageOrgUnit.getValue();
        if (org != null) {
            date = calcFacade.getNextWorkDay(org.getId().toString());
        }
        return date;
    }

    private void setMrpLogNumber(MRPRunLogInfo objRunLog) throws Exception {
        String strNumber = PlanningConst.getBizNumber((IObjectValue)objRunLog, SysContext.getSysContext().getCurrentStorageUnit().getId().toString());
        if (strNumber == null) {
            throw new MRPException(MRPException.MRP_RUN_LOG_RULE_NOT_EXIST);
        }
        objRunLog.setNumber("CMPS" + strNumber);
    }

    public void setF7PlanVersion(KDBizPromptBox bizBox, String storageUnitId) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storageUnitId, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)new Integer(3), CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        bizBox.setHasCUDefaultFilter(false);
        bizBox.setEntityViewInfo(viewInfo);
        bizBox.setSelectorCollection(this.getSelectors());
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("storageOrgUnit.*"));
        sic.add(new SelectorItemInfo("status"));
        sic.add(new SelectorItemInfo("coAllocateBill.*"));
        sic.add(new SelectorItemInfo("entrys.warehouseRange"));
        sic.add(new SelectorItemInfo("entrys.remark"));
        sic.add(new SelectorItemInfo("entrys.isCareWIP"));
        sic.add(new SelectorItemInfo("entrys.isCareScheduleRec"));
        sic.add(new SelectorItemInfo("entrys.isCareAvailStock"));
        sic.add(new SelectorItemInfo("entrys.*"));
        sic.add(new SelectorItemInfo("entrys.number"));
        sic.add(new SelectorItemInfo("entrys.planningHorizonSet.*"));
        sic.add(new SelectorItemInfo("entrys.planningHorizonSet.number"));
        sic.add(new SelectorItemInfo("entrys.planningHorizonSet.id"));
        sic.add(new SelectorItemInfo("entrys.id"));
        sic.add(new SelectorItemInfo("entrys.coStorageOrgUnit.*"));
        sic.add(new SelectorItemInfo("entrys.coStorageOrgUnit.number"));
        sic.add(new SelectorItemInfo("entrys.warehouseEntrys.*"));
        sic.add(new SelectorItemInfo("entrys.warehouseEntrys.number"));
        sic.add(new SelectorItemInfo("entrys.warehouseEntrys.id"));
        sic.add(new SelectorItemInfo("entrys.warehouseEntrys.warehouse.*"));
        sic.add(new SelectorItemInfo("entrys.warehouseEntrys.warehouse.name"));
        sic.add(new SelectorItemInfo("entrys.warehouseEntrys.warehouse.region.name"));
        sic.add(new SelectorItemInfo("entrys.warehouseEntrys.warehouse.address"));
        sic.add(new SelectorItemInfo("entrys.warehouseEntrys.warehouse.hasLocation"));
        sic.add(new SelectorItemInfo("entrys.warehouseEntrys.warehouse.whState"));
        sic.add(new SelectorItemInfo("entrys.warehouseEntrys.warehouse.whman.name"));
        sic.add(new SelectorItemInfo("entrys.warehouseEntrys.warehouse.id"));
        sic.add(new SelectorItemInfo("entrys.storetype.id"));
        sic.add(new SelectorItemInfo("entrys.storetype.isMrpRun"));
        sic.add(new SelectorItemInfo("entrys.storetype.storeType.name"));
        sic.add(new SelectorItemInfo("entrys.storetype.storeType.number"));
        sic.add(new SelectorItemInfo("entrys.storestate.id"));
        sic.add(new SelectorItemInfo("entrys.storestate.isMrpRun"));
        sic.add(new SelectorItemInfo("entrys.storestate.storeState.name"));
        sic.add(new SelectorItemInfo("entrys.storestate.storeState.number"));
        sic.add(new SelectorItemInfo("entrys.billParam.id"));
        sic.add(new SelectorItemInfo("entrys.billParam.bizTypeBill"));
        sic.add(new SelectorItemInfo("entrys.billParam.isParticipation"));
        sic.add(new SelectorItemInfo("entrys.billParam.priority"));
        sic.add(new SelectorItemInfo("entrys.billParam.billType.number"));
        sic.add(new SelectorItemInfo("entrys.billParam.billType.name"));
        return sic;
    }

    @Override
    public void storeFields() {
        this.initOldData((IObjectValue)this.editData);
    }

    private boolean checkPlanVersionExist() {
        boolean bRet = false;
        if (this.prmtCplanVersion.getValue() == null) {
            String prompt = EASResource.getString((String)"com.kingdee.eas.mm.planning.client.PlanningResource.MPS_MRP_PLANVERSION_NOT_EXIST");
            MsgBox.showError((Component)((Object)this), (String)prompt);
        } else {
            bRet = true;
        }
        return bRet;
    }

    private void writeOpLog(String strMethod, String strDetail) {
        IObjectPK pk = LogUtil.beginLog(null, (String)strMethod, (BOSObjectType)new BOSObjectType("F94043EF"), null, (String)strDetail);
        LogUtil.afterLog(null, (IObjectPK)pk);
    }

    private void showProgressDialog() {
        ProgressDialog dialog = ProgressDialog.getDialogInstance(null);
        MRPRunLogInfo objRunLog = (MRPRunLogInfo)this.getDataObject();
        try {
            dialog.show();
            this.displayMRPRunLogListUI(objRunLog);
        }
        catch (Exception e1) {
            this.handleException(e1);
        }
    }

    private void displayMRPRunLogListUI(MRPRunLogInfo objLog) throws EASBizException, UIException, BOSException, Exception {
        MRPRunLogInfo objRunLog = (MRPRunLogInfo)this.getDataObject();
        this.application.getView().getFilterInfo();
        this.application.getApplicationContext().putData("storageOrgUnit.number", (Object)objRunLog.getStorageOrgUnit().getNumber());
        this.application.setEditType("EDIT");
        this.application.setRefresh("com.kingdee.eas.mm.planning.client.CMPSRunLogListUI");
        this.application.getView().changePage(1);
    }

    protected IObjectPK getOrgPK(MRPRunLogInfo objLog) {
        ObjectUuidPK orgPK = null;
        if (objLog != null) {
            orgPK = new ObjectUuidPK(objLog.getStorageOrgUnit().getId().toString());
        }
        return orgPK;
    }

    protected KDBizPromptBox getMainBizOrg() {
        return this.prmtStorageOrgUnit;
    }

    private boolean handleBomCheckAndReCalcLLC(Map rsMap, MRPRunLogInfo objRunLog) {
        int nYes;
        boolean bRet = true;
        Integer nVal = new Integer(-1);
        StringBuffer sbPrompt = new StringBuffer();
        Object obj = rsMap.get("ValidateBOM");
        if (obj != null) {
            nVal = (Integer)obj;
        }
        if (nVal.equals(new Integer(10))) {
            objRunLog.setBomNestingCheck(true);
            sbPrompt.append(EASResource.getString((String)"com.kingdee.eas.mm.planning.client.PlanningResource.MPS_MRP_RUN_BOM_NESTED_PROMPT")).append("\n");
        } else {
            objRunLog.setBomNestingCheck(false);
        }
        obj = rsMap.get("ValidateSub");
        if (obj != null) {
            nVal = (Integer)obj;
        }
        if (nVal.equals(new Integer(10)) && objRunLog.isIsMaterialReplace()) {
            objRunLog.setBomNestingCheck(true);
            sbPrompt.append(EASResource.getString((String)"com.kingdee.eas.mm.planning.client.PlanningResource.MPS_MRP_RUN_SUM_NESTED_PROMPT")).append("\n");
        }
        if ((obj = rsMap.get("ReCalcLLC")) != null) {
            nVal = (Integer)obj;
        }
        if (nVal.equals(new Integer(1))) {
            objRunLog.setIsCalculateLLC(false);
            sbPrompt.append(EASResource.getString((String)"com.kingdee.eas.mm.planning.client.PlanningResource.MPS_MRP_RUN_RECALC_LLC_FAIL_PROMPT"));
        } else {
            objRunLog.setIsCalculateLLC(true);
        }
        if (sbPrompt.length() > 0 && 0 != (nYes = MsgBox.showConfirm2((String)sbPrompt.toString()))) {
            bRet = false;
        }
        return bRet;
    }

    public void attach(CombinUIApplication app) {
        this.application = app;
    }

    private void refreshListUI() {
        if (this.application != null) {
            this.application.setRefresh("com.kingdee.eas.mm.planning.client.CMPSRunLogListUI");
        }
    }
}

