/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.master.material.UsedStatusEnum;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.mm.common.client.MMRangeFilterElement;
import com.kingdee.eas.mm.common.client.UIHelper;
import com.kingdee.eas.mm.planning.AllEnum;
import com.kingdee.eas.mm.planning.CentralPurReqSourceTypeEnum;
import com.kingdee.eas.mm.planning.client.AbstractCentralPurReqPlanFilterUI;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.common.verify.VerifyItem;
import com.kingdee.eas.scm.common.verify.VerifyType;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class CentralPurReqPlanFilterUI
extends AbstractCentralPurReqPlanFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(CentralPurReqPlanFilterUI.class);
    private CustomerParams cp = null;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        CompositeFilterElement elements = new CompositeFilterElement(0);
        SingleFilterElement mainOrgElement = new SingleFilterElement("storageOrgUnit.number", (Component)this.prmtStorageOrgUnit);
        mainOrgElement.addVerifyItem(new VerifyItem(VerifyType.REQUIRED_TYPE, this.getResource("STORAGEORG_ISNULL")));
        elements.add((FilterElement)mainOrgElement);
        elements.add((FilterElement)new MMRangeFilterElement("number", (Component)this.prmtReqNumFrom, (Component)this.prmtReqNumTo));
        elements.add((FilterElement)new MMRangeFilterElement("material.number", (Component)this.prmtMaterialFrom, (Component)this.prmtMaterialTo));
        elements.add((FilterElement)new MMRangeFilterElement("bom.number", (Component)this.prmtBomFrom, (Component)this.prmtBomTo));
        elements.add((FilterElement)new MMRangeFilterElement("sourceOrgUnit.number", (Component)this.prmtSourceOrgUnitFrom, (Component)this.prmtSourceOrgUnitTo));
        elements.add((FilterElement)new MMRangeFilterElement("sourceBillNum", (Component)this.prmtSourceBillNumFrom, (Component)this.prmtSourceBillNumTo));
        elements.add((FilterElement)new MMRangeFilterElement("projectNum.number", (Component)this.prmtProjectNumFrom, (Component)this.prmtProjectNumTo));
        elements.add((FilterElement)new MMRangeFilterElement("trackNum.number", (Component)this.prmtTrackNumFrom, (Component)this.prmtTrackNumTo));
        MMRangeFilterElement elementBizDate = new MMRangeFilterElement("planStartTime", (Component)this.pkPlanStartTimeFrom, (Component)this.pkPlanStartTimeTo);
        elementBizDate.addVerifyItem(new VerifyItem(VerifyType.LESS_EQUAL_TYPE, this.getResource("PLANSTARTTIME_NOT_VALID")));
        Calendar calendar = Calendar.getInstance();
        Timestamp[] dates = new Timestamp[2];
        calendar.setTime(SCMUtils.getSCMQueryTime(null, (String)"startDate"));
        calendar.add(2, 1);
        dates[0] = new Timestamp(calendar.getTimeInMillis());
        calendar.setTime(SCMUtils.getSCMQueryTime(null, (String)"endDate"));
        calendar.add(2, 1);
        dates[1] = new Timestamp(calendar.getTimeInMillis());
        elementBizDate.setDefaultValue((Object)dates);
        elements.add((FilterElement)elementBizDate);
        this.comboSourceType.removeAllItems();
        this.comboSourceType.addItems(new Object[]{AllEnum.NULL, CentralPurReqSourceTypeEnum.PM, CentralPurReqSourceTypeEnum.MAN});
        elements.add((FilterElement)new SingleFilterElement("sourceType", (Component)this.comboSourceType, (Object)AllEnum.NULL));
        this.checkboxNoplan.setSelected(true);
        this.checkboxReplan.setSelected(true);
        this.getFilterManager().setElement((FilterElement)elements);
        this.getFilterManager().setMainOrgElement((FilterElement)mainOrgElement, this.getPropertyOfMainBizOrg());
        this.f7Manager.registerContextChangeF7(this.prmtReqNumFrom, "storageOrgUnit.id");
        this.f7Manager.registerContextChangeF7(this.prmtReqNumTo, "storageOrgUnit.id");
        UIHelper.registerProjectF7ForFilter((KDBizPromptBox)this.prmtStorageOrgUnit, (KDBizPromptBox)this.prmtProjectNumFrom);
        UIHelper.registerProjectF7ForFilter((KDBizPromptBox)this.prmtStorageOrgUnit, (KDBizPromptBox)this.prmtProjectNumTo);
        UIHelper.registerTrackNumberF7ForFilter((KDBizPromptBox)this.prmtStorageOrgUnit, (KDBizPromptBox)this.prmtTrackNumFrom);
        UIHelper.registerTrackNumberF7ForFilter((KDBizPromptBox)this.prmtStorageOrgUnit, (KDBizPromptBox)this.prmtTrackNumTo);
        this.setNeedMainOrgF7s(new KDBizPromptBox[]{this.prmtBomFrom, this.prmtBomTo, this.prmtSourceBillNumFrom, this.prmtSourceBillNumTo, this.prmtSourceOrgUnitFrom, this.prmtSourceOrgUnitTo, this.prmtMaterialFrom, this.prmtMaterialTo, this.prmtReqNumFrom, this.prmtReqNumTo});
        this.setMaterialFilter();
        this.setBomFilter();
        this.setSourceBillFilter();
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmtStorageOrgUnit;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    protected String getViewPermission() {
        return "mm_planning_centralpurreqplan_view";
    }

    protected String getPropertyOfMainBizOrg() {
        return "storageOrgUnit.id";
    }

    private void setMaterialFilter() {
        String queryInfo = UIHelper.getMaterialPlanQuery((int)this.f7Manager.getF7DisplayMode());
        this.setBizMaterialF7(this.prmtMaterialFrom, false, queryInfo);
        this.setBizMaterialF7(this.prmtMaterialTo, false, queryInfo);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("Status", (Object)String.valueOf(UsedStatusEnum.APPROVED.getValue()), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("Inventory.status", (Object)String.valueOf(UsedStatusEnum.APPROVED.getValue()), CompareType.EQUALS));
        view.setFilter(filter);
        this.prmtMaterialFrom.setEntityViewInfo(view);
        this.prmtMaterialTo.setEntityViewInfo(view);
        this.prmtMaterialFrom.getQueryAgent().resetRuntimeEntityView();
        this.prmtMaterialTo.getQueryAgent().resetRuntimeEntityView();
    }

    private void setBomFilter() {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        String StorageOrgUnitID = null;
        if (this.prmtStorageOrgUnit.getValue() != null) {
            StorageOrgUnitID = this.prmtStorageOrgUnit.getData() instanceof OrgUnitInfo[] ? ((OrgUnitInfo[])this.prmtStorageOrgUnit.getData())[0].getId().toString() : (this.prmtStorageOrgUnit.getData() instanceof FullOrgUnitInfo ? ((FullOrgUnitInfo)this.prmtStorageOrgUnit.getData()).getId().toString() : ((StorageOrgUnitInfo)this.prmtStorageOrgUnit.getData()).getId().toString());
            filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)StorageOrgUnitID, CompareType.EQUALS));
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("basestatus", (Object)new Integer(4), CompareType.EQUALS));
        view.setFilter(filterInfo);
        this.prmtBomFrom.setEntityViewInfo(view);
        this.prmtBomTo.setEntityViewInfo(view);
        this.prmtBomFrom.getQueryAgent().resetRuntimeEntityView();
        this.prmtBomTo.getQueryAgent().resetRuntimeEntityView();
    }

    private void setSourceBillFilter() {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        HashSet<Integer> status = new HashSet<Integer>();
        status.add(new Integer(5));
        status.add(new Integer(7));
        filterInfo.getFilterItems().add(new FilterItemInfo("baseStatus", status, CompareType.INNER));
        view.setFilter(filterInfo);
        this.prmtSourceBillNumFrom.setEntityViewInfo(view);
        this.prmtSourceBillNumTo.setEntityViewInfo(view);
        this.prmtSourceBillNumFrom.getQueryAgent().resetRuntimeEntityView();
        this.prmtSourceBillNumTo.getQueryAgent().resetRuntimeEntityView();
    }

    private String getResource(String strKey) {
        return EASResource.getString((String)"com.kingdee.eas.mm.planning.CentralPurReqPlanResource", (String)strKey);
    }

    private boolean isValidDate(Date start, Date end) {
        if (start == null || end == null) {
            return true;
        }
        long startDay = start.getTime();
        long endDay = end.getTime();
        boolean result = false;
        if (endDay - startDay >= 0L) {
            result = true;
        }
        return result;
    }

    public void setCustomerParams(CustomerParams cp) {
        super.setCustomerParams(cp);
        this.cp = cp;
    }

    public CustomerParams getCustomerParams() {
        CustomerParams pp = super.getCustomerParams();
        if (this.prmtStorageOrgUnit.getValue() != null) {
            if (this.checkboxNoplan.isSelected()) {
                pp.addCustomerParam("statusNoplan", "4");
            }
            if (this.checkboxPlanned.isSelected()) {
                pp.addCustomerParam("statusPlanned", "1");
            }
            if (this.checkboxReplan.isSelected()) {
                pp.addCustomerParam("statusReplan", "2");
            }
            if (this.checkboxClosed.isSelected()) {
                pp.addCustomerParam("statusClosed", "60");
            }
            if (this.checkboxFailure.isSelected()) {
                pp.addCustomerParam("statusFailure", "7");
            }
        }
        return pp;
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        this.checkboxReplan.setSelected(false);
        this.checkboxPlanned.setSelected(false);
        this.checkboxClosed.setSelected(false);
        this.checkboxFailure.setSelected(false);
        this.checkboxNoplan.setSelected(false);
        super.loadData(entityViewInfo);
        if (this.cp.getCustomerParam("statusNoplan") != null && this.cp.getCustomerParam("statusNoplan").length() > 0) {
            this.checkboxNoplan.setSelected(true);
        }
        if (this.cp.getCustomerParam("statusPlanned") != null && this.cp.getCustomerParam("statusPlanned").length() > 0) {
            this.checkboxPlanned.setSelected(true);
        }
        if (this.cp.getCustomerParam("statusReplan") != null && this.cp.getCustomerParam("statusReplan").length() > 0) {
            this.checkboxReplan.setSelected(true);
        }
        if (this.cp.getCustomerParam("statusClosed") != null && this.cp.getCustomerParam("statusClosed").length() > 0) {
            this.checkboxClosed.setSelected(true);
        }
        if (this.cp.getCustomerParam("statusFailure") != null && this.cp.getCustomerParam("statusFailure").length() > 0) {
            this.checkboxFailure.setSelected(true);
        }
    }

    public void clear() {
        super.clear();
        this.checkboxNoplan.setSelected(true);
        this.checkboxReplan.setSelected(true);
        this.checkboxPlanned.setSelected(false);
        this.checkboxClosed.setSelected(false);
        this.checkboxFailure.setSelected(false);
    }

    public boolean verify() {
        boolean ret = super.verify();
        if (!ret) {
            return ret;
        }
        StringBuffer alertInfo = new StringBuffer("");
        if (this.pkPlanStartTimeFrom.getValue() == null || this.pkPlanStartTimeTo.getValue() == null) {
            ret = false;
            alertInfo.append(this.getResource("PLANSTARTTIME_NOT_NULL"));
        }
        if (!this.isValidDate((Date)this.pkPlanStartTimeFrom.getValue(), (Date)this.pkPlanStartTimeTo.getValue())) {
            ret = false;
            if (alertInfo.length() > 0) {
                alertInfo.append("\n");
            }
            alertInfo.append(this.getResource("PLANSTARTTIME_NOT_VALID"));
        }
        boolean temp = false;
        if (this.checkboxNoplan.isSelected()) {
            temp = true;
        }
        if (this.checkboxReplan.isSelected()) {
            temp = true;
        }
        if (this.checkboxPlanned.isSelected()) {
            temp = true;
        }
        if (this.checkboxClosed.isSelected()) {
            temp = true;
        }
        if (this.checkboxFailure.isSelected()) {
            temp = true;
        }
        if (!temp) {
            ret = false;
            if (alertInfo.length() > 0) {
                alertInfo.append("\n");
            }
            alertInfo.append(this.getResource("MUST_ONE_STATUS"));
        }
        if (alertInfo.length() > 0) {
            MsgBox.showInfo((String)alertInfo.toString());
            SysUtil.abort();
        }
        return ret;
    }

    public FilterInfo getFilterInfo() {
        HashSet<Integer> set = new HashSet<Integer>();
        FilterInfo filterInfo = super.getFilterInfo();
        if (this.checkboxPlanned.isSelected()) {
            set.add(new Integer(20));
        }
        if (this.checkboxReplan.isSelected()) {
            set.add(new Integer(30));
        }
        if (this.checkboxNoplan.isSelected()) {
            set.add(new Integer(10));
        }
        if (this.checkboxClosed.isSelected()) {
            set.add(new Integer(40));
        }
        if (this.checkboxFailure.isSelected()) {
            set.add(new Integer(50));
        }
        if (set.size() > 0) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("status", set, CompareType.INCLUDE));
            try {
                filterInfo.mergeFilter(filter, "AND");
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        }
        return filterInfo;
    }

    public void afterMainOrgChanged(String ids) {
        this.setMaterialFilter();
        this.setBomFilter();
        this.setSourceBillFilter();
    }
}

