/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.client;

import com.kingdee.bos.ctrl.common.util.ControlUtilities;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.event.BeforeActionEvent;
import com.kingdee.bos.ctrl.kdf.table.event.BeforeActionListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTPropertyChangeEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTPropertyChangeListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.client.AssistantClientUtils;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.mm.planning.CounteractSetFactory;
import com.kingdee.eas.mm.planning.ICounteractSet;
import com.kingdee.eas.mm.planning.client.AbstractCounteractSetEditUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.LocaleUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JCheckBox;
import org.apache.log4j.Logger;

public class CounteractSetEditUI
extends AbstractCounteractSetEditUI {
    private static final String RESOURCE_BASEDATA = "com.kingdee.eas.mm.planning.client.PlanningResource";
    private static final Logger logger = CoreUIObject.getLogger(CounteractSetEditUI.class);
    private static final Color colorDisabledCell = new Color(232, 232, 232);
    private boolean modified = false;
    private boolean doNotCountModified = true;
    private static final String TB_BILLTYPE = "billType";
    private static final String TB_ISCNTACT = "isCntact";
    private static final String TB_ISDEFAULT = "isDefault";

    @Override
    public void loadFields() {
        String[] parts;
        String tmp;
        super.loadFields();
        Map ui = this.getUIContext();
        this.txtSU.setText((String)ui.get("storageOrgUnit.name"));
        this.txtMTS.setText((String)ui.get("manuStrategy.number"));
        this.txtName.setText((String)ui.get("manuStrategy.name"));
        this.txtMTSDesc.setText((String)ui.get("manuStrategy.description"));
        this.txtMTSDesc.select(0, 1);
        this.doNotCountModified = true;
        this.kDTable1.removeRows();
        String[] recs = this.editData._getSettings().split(";");
        for (int i = 0; i < recs.length && (tmp = (parts = recs[i].split(","))[0]).length() > 0; ++i) {
            int pos = tmp.indexOf(91);
            parts[0] = tmp.substring(0, pos);
            tmp = tmp.substring(pos + 1, tmp.length() - 2);
            String[] billParts = tmp.split("\\]\\[");
            BillTypeInfo billType = new BillTypeInfo();
            billType.setId(BOSUuid.read((String)parts[0]));
            billType.setNumber(billParts[0]);
            billType.setName(billParts[1], LocaleUtils.getLocale((String)"L1"));
            billType.setName(billParts[2], LocaleUtils.getLocale((String)"L2"));
            billType.setName(billParts[3], LocaleUtils.getLocale((String)"L3"));
            IRow row = this.kDTable1.addRow();
            row.getCell(0).setValue((Object)billType);
            row.getCell(1).setValue((Object)Boolean.valueOf(parts[1]));
            row.getCell(2).setValue((Object)Boolean.valueOf(parts[2]));
        }
        this.doNotCountModified = false;
        this.kDTable1.getActionMap().remove("Delete");
        this.kDTable1.getActionMap().remove("Paste");
        this.kDTable1.getActionMap().remove("Cut");
    }

    @Override
    public void storeFields() {
    }

    public IObjectPK runSubmit() throws Exception {
        String id = null;
        try {
            ICounteractSet svc = CounteractSetFactory.getRemoteInstance();
            id = svc.submitValueWithSettings(this.editData);
        }
        catch (Exception e) {
            this.handleException(e);
            SysUtil.abort();
        }
        this.modified = false;
        return new ObjectUuidPK(id);
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        Hashtable<String, String> recs = new Hashtable<String, String>();
        boolean hasSelected = false;
        for (int i = 0; i < this.kDTable1.getRowCount(); ++i) {
            IRow row = this.kDTable1.getRow(i);
            Object obj = row.getCell(0).getValue();
            if (obj == null) {
                throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{this.kDTable1.getHead().getRow(0).getCell(0).getValue().toString() + " "});
            }
            String tmp = ((BillTypeInfo)obj).getId().toString();
            if (recs.containsKey(tmp)) {
                throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{((BillTypeInfo)obj).getName() + " "});
            }
            if (((Boolean)row.getCell(TB_ISCNTACT).getValue()).booleanValue()) {
                hasSelected = true;
            }
            recs.put(tmp, tmp + "," + ((Boolean)row.getCell(TB_ISCNTACT).getValue()).toString() + "," + ((Boolean)row.getCell(TB_ISDEFAULT).getValue()).toString());
        }
        if ("ATO10".equalsIgnoreCase(this.txtMTS.getText()) || "ATO20".equalsIgnoreCase(this.txtMTS.getText()) || "ATO30".equalsIgnoreCase(this.txtMTS.getText()) || "ATO40".equalsIgnoreCase(this.txtMTS.getText()) || "MTO10".equalsIgnoreCase(this.txtMTS.getText()) || "MTO20".equalsIgnoreCase(this.txtMTS.getText()) || "MTS20".equalsIgnoreCase(this.txtMTS.getText())) {
            hasSelected = true;
        }
        if (!hasSelected) {
            MsgBox.showWarning((String)EASResource.getString((String)RESOURCE_BASEDATA, (String)"ATLEASTONEBILL_DEDUCTREQ"));
            SysUtil.abort();
        }
        StringBuffer settings = new StringBuffer();
        Iterator values = recs.values().iterator();
        while (values.hasNext()) {
            if (settings.length() > 0) {
                settings.append(";");
            }
            settings.append(values.next());
        }
        this.editData._setSettings(settings.toString());
    }

    @Override
    protected void btnInsertLine_actionPerformed(ActionEvent e) throws Exception {
        IRow row;
        if (this.kDTable1.getSelectManager().size() > 0) {
            KDTSelectBlock block = this.kDTable1.getSelectManager().get();
            int top = block.getTop();
            int mode = block.getMode();
            row = mode == 4 || mode == 8 ? this.kDTable1.addRow() : this.kDTable1.addRow(top);
        } else {
            row = this.kDTable1.addRow();
        }
        row.getCell(1).setValue((Object)Boolean.FALSE);
        row.getCell(2).setValue((Object)Boolean.FALSE);
    }

    @Override
    protected void btnNewLine_actionPerformed(ActionEvent e) throws Exception {
        IRow row = this.kDTable1.addRow();
        row.getCell(1).setValue((Object)Boolean.FALSE);
        row.getCell(2).setValue((Object)Boolean.FALSE);
    }

    @Override
    protected void btnRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        if (this.kDTable1.getSelectManager().size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
            return;
        }
        KDTSelectBlock block = this.kDTable1.getSelectManager().get();
        this.kDTable1.removeRow(block.getBeginRow());
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        AssistantClientUtils.setupUITitle((CoreUIObject)this, (String)EASResource.getString((String)RESOURCE_BASEDATA, (String)"CounteractSetQueryF7WindowTitle"));
        this.txtMTSDesc.select(0, 1);
        this.enableKDTable(true);
    }

    public boolean isModify() {
        String[] parts;
        String tmp;
        String[] recs = this.editData._getSettings().split(";");
        try {
            ControlUtilities.checkFocusAndCommit();
        }
        catch (Exception err) {
            this.handleControlException();
            this.abort();
        }
        for (int i = 0; i < recs.length && (tmp = (parts = recs[i].split(","))[0]).length() > 0; ++i) {
            int pos = tmp.indexOf(91);
            String billTypeId = tmp.substring(0, pos);
            boolean isCntact = Boolean.valueOf(parts[1]);
            boolean isDefalut = Boolean.valueOf(parts[2]);
            for (int rowIndex = 0; rowIndex < this.kDTable1.getBody().size(); ++rowIndex) {
                BillTypeInfo billType = (BillTypeInfo)this.kDTable1.getRow(rowIndex).getCell(TB_BILLTYPE).getValue();
                if (!billTypeId.equals(billType.getId().toString()) || isCntact == (Boolean)this.kDTable1.getRow(rowIndex).getCell(TB_ISCNTACT).getValue() && isDefalut == (Boolean)this.kDTable1.getRow(rowIndex).getCell(TB_ISDEFAULT).getValue()) continue;
                return true;
            }
        }
        return false;
    }

    protected IObjectValue getValue(IObjectPK pk) throws Exception {
        ICounteractSet svc = CounteractSetFactory.getRemoteInstance();
        return svc.getValueWithSettings(pk.toString());
    }

    public void onLoad() throws Exception {
        KDBizPromptBox cBillType = new KDBizPromptBox();
        cBillType.setQueryInfo("com.kingdee.eas.basedata.scm.common.app.F7BillTypeQuery");
        cBillType.setDisplayFormat("$number$");
        cBillType.setEditFormat("$number$");
        cBillType.setCommitFormat("$number$");
        cBillType.setRequired(true);
        this.kDTable1.getColumn(0).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)cBillType));
        KDCheckBox cIsCntact = new KDCheckBox();
        this.kDTable1.getColumn(1).setEditor((ICellEditor)new KDTDefaultCellEditor((JCheckBox)cIsCntact));
        KDCheckBox cIsDefault = new KDCheckBox();
        this.kDTable1.getColumn(2).setEditor((ICellEditor)new KDTDefaultCellEditor((JCheckBox)cIsDefault));
        super.onLoad();
        AssistantClientUtils.setupUITitle((CoreUIObject)this, (String)EASResource.getString((String)RESOURCE_BASEDATA, (String)"CounteractSetQueryF7WindowTitle"));
        this.kDTable1.addKDTPropertyChangeListener(new KDTPropertyChangeListener(){

            public void propertyChange(KDTPropertyChangeEvent evt) {
                CounteractSetEditUI.this.onTableChange();
            }
        });
        this.kDTable1.setAfterAction(new BeforeActionListener(){

            public void beforeAction(BeforeActionEvent e) {
                CounteractSetEditUI.this.onTableChange();
            }
        });
        if (this.getOprtState().equals(OprtState.VIEW)) {
            this.enableKDTable(false);
        } else {
            this.enableKDTable(true);
        }
        if ("ATO10".equalsIgnoreCase(this.txtMTS.getText()) || "ATO20".equalsIgnoreCase(this.txtMTS.getText()) || "ATO30".equalsIgnoreCase(this.txtMTS.getText()) || "ATO40".equalsIgnoreCase(this.txtMTS.getText())) {
            this.kDTable1.getColumn(1).getStyleAttributes().setLocked(false);
            this.kDTable1.getColumn(1).getEditor().getComponent().setEnabled(true);
        }
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return CounteractSetFactory.getRemoteInstance();
    }

    private void enableKDTable(boolean enable) {
        if (enable) {
            this.kDTable1.getColumn(0).setRequired(false);
            this.kDTable1.getColumn(0).getStyleAttributes().setBackground(colorDisabledCell);
            this.kDTable1.getColumn(1).setRequired(true);
            this.kDTable1.getColumn(2).setRequired(false);
            this.kDTable1.getColumn(2).getStyleAttributes().setBackground(colorDisabledCell);
            this.kDTable1.setEnabled(true);
        } else {
            this.kDTable1.getColumn(0).setRequired(false);
            this.kDTable1.getColumn(1).setRequired(false);
            this.kDTable1.getColumn(2).setRequired(false);
            this.kDTable1.getStyleAttributes().setBackground(colorDisabledCell);
            this.kDTable1.setEnabled(false);
        }
    }

    private void onTableChange() {
    }
}

