/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.mm.planning.CounteractSetFactory;
import com.kingdee.eas.mm.planning.CounteractSetInfo;
import com.kingdee.eas.mm.planning.ICounteractSet;
import com.kingdee.eas.mm.planning.client.AbstractCounteractSetListUI;
import com.kingdee.eas.mm.planning.client.CounteractSetEditUI;
import com.kingdee.eas.mm.planning.client.CounteractSetFilterUI;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.Map;
import org.apache.log4j.Logger;

public class CounteractSetListUI
extends AbstractCounteractSetListUI {
    private static final String RESOURCE_FULLNAME = "com.kingdee.eas.mm.planning.client.PlanningResource";
    private static final Logger logger = CoreUIObject.getLogger(CounteractSetListUI.class);
    private CounteractSetFilterUI filterPanel = null;

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = super.getDefaultFilterForQuery();
        Map uiContext = this.getUIContext();
        if (uiContext.get("sourceID") != null && uiContext.get("sourceID").equals("InitMmParamsUI")) {
            this.setIsNeedDefaultFilter(false);
            filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)((String)uiContext.get("storageOrgUnitID")), CompareType.EQUALS));
        }
        return filter;
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return CounteractSetFactory.getRemoteInstance();
    }

    @Override
    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    protected EntityViewInfo getInitDefaultSolution() {
        return null;
    }

    protected String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
    }

    public String getUITitle() {
        return EASResource.getString((String)RESOURCE_FULLNAME, (String)"CounteractSetQueryF7WindowTitle");
    }

    @Override
    protected String getEditUIName() {
        return CounteractSetEditUI.class.getName();
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        int[] rowIDs = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        if (rowIDs.length <= 0) {
            return;
        }
        String sou = (String)this.tblMain.getCell(rowIDs[0], "storageOrgUnit.name").getValue();
        String mtsNum = (String)this.tblMain.getCell(rowIDs[0], "manuStrategy.number").getValue();
        String mtsName = (String)this.tblMain.getCell(rowIDs[0], "manuStrategy.name").getValue();
        String mtsDescript = (String)this.tblMain.getCell(rowIDs[0], "manuStrategy.description").getValue();
        uiContext.put((Object)"storageOrgUnit.name", (Object)sou);
        uiContext.put((Object)"manuStrategy.number", (Object)mtsNum);
        uiContext.put((Object)"manuStrategy.name", (Object)mtsName);
        uiContext.put((Object)"manuStrategy.description", (Object)mtsDescript);
        super.prepareUIContext(uiContext, e);
    }

    protected void execQuery() {
        FilterInfo filter = this.mainQuery.getFilter();
        OrgUnitCollection orgUnits = this.filterPanel != null ? this.filterPanel.getMainBizOrgs() : null;
        FilterInfo storageOrgFilter = SCMClientUtils.getF7FilterInfoByAuthorizeStorageOrg((String)"storageOrgUnit.id", (String)"mm_counteractset_view");
        try {
            if (orgUnits != null) {
                Object[] orgIds = new Object[orgUnits.size()];
                int size = orgUnits.size();
                for (int i = 0; i < size; ++i) {
                    orgIds[i] = orgUnits.get(i).getId().toString();
                }
                ICounteractSet svc = CounteractSetFactory.getRemoteInstance();
                svc.initData(orgIds);
            }
            filter.mergeFilter(storageOrgFilter, "AND");
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
        super.execQuery();
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        CommonQueryDialog dialog = super.initCommonQueryDialog();
        MessageFormat format = BOSLocaleUtil.getMessageFormat((String)"{0}-{1}");
        String title = format.format(new Object[]{EASResource.getString((String)RESOURCE_FULLNAME, (String)"ManufacturePolicy"), EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Query_Filter")});
        dialog.setTitle(title);
        try {
            if (this.filterPanel == null) {
                this.filterPanel = new CounteractSetFilterUI();
            }
            this.filterPanel.onLoad();
            dialog.addUserPanel((KDPanel)this.filterPanel);
            dialog.setShowFilter(false);
            dialog.setShowSorter(true);
            dialog.setHeight(300);
            dialog.setWidth(400);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        return dialog;
    }

    protected boolean initDefaultFilter() {
        return true;
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    protected String getOnloadPermItemName() {
        return "mm_counteractset_view";
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        IObjectPK orgPK = null;
        String actoinName = null;
        if (action != null) {
            actoinName = action.getClass().getName();
        }
        if (actoinName != null && actoinName.indexOf("$") >= 0) {
            actoinName = actoinName.substring(actoinName.indexOf("$") + 1);
        }
        if (actoinName != null && actoinName.equals("ActionEdit")) {
            String id = this.getSelectedKeyValue();
            if (id == null) {
                return super.getOrgPK(action);
            }
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)id));
            CounteractSetInfo counteractSetInfo = null;
            try {
                counteractSetInfo = (CounteractSetInfo)this.getBizInterface().getValue((IObjectPK)pk);
            }
            catch (EASBizException e) {
                this.handUIException(e);
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
            catch (Exception e) {
                this.handUIException(e);
            }
            orgPK = new ObjectUuidPK(counteractSetInfo.getStorageOrgUnit().getId());
        } else {
            orgPK = super.getOrgPK(action);
        }
        return orgPK;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.getColumn("manuStrategy.description").getStyleAttributes().setWrapText(true);
        this.releaseAction(this.tblMain);
        this.tblMain.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                int selectRow = e.getSelectBlock().getBottom();
            }
        });
    }

    private void releaseAction(KDTable table) {
        table.getActionMap().remove("AddRow");
        table.getActionMap().remove("RemoveRow");
        table.getActionMap().remove("Delete");
        table.getActionMap().remove("Paste");
        table.getActionMap().remove("Copy");
        table.getActionMap().remove("Cut");
    }
}

