/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.client;

import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.mm.planning.ExceptionTypeEnum;
import com.kingdee.eas.mm.planning.client.AbstractExceptionInfoFilterUI;
import java.util.Date;
import org.apache.log4j.Logger;

public class ExceptionInfoFilterUI
extends AbstractExceptionInfoFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(ExceptionInfoFilterUI.class);
    private static final String FILTER_PRO_CREATEDATE = "createTime";
    private static final String FILTER_PRO_EXCEPTIONTYPE = "exceType";

    public void onLoad() throws Exception {
        super.onLoad();
        this.cboExceptionType.removeAllItems();
        this.cboExceptionType.addItem((Object)ExceptionTypeEnum.NULL);
        this.cboExceptionType.addItem((Object)ExceptionTypeEnum.HIGHWARNING);
        this.cboExceptionType.addItem((Object)ExceptionTypeEnum.WARNING);
        this.cboExceptionType.addItem((Object)ExceptionTypeEnum.SYSERROR);
        this.kddStartDate.setTimeEnabled(true);
        this.kddEndDate.setTimeEnabled(true);
    }

    public FilterInfo getFilterInfo() {
        FilterInfo filterInfo = new FilterInfo();
        Date beginDate = (Date)this.kddStartDate.getValue();
        Date endDate = (Date)this.kddEndDate.getValue();
        ExceptionTypeEnum exceType = (ExceptionTypeEnum)((Object)this.cboExceptionType.getSelectedItem());
        if (beginDate != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo(FILTER_PRO_CREATEDATE, (Object)beginDate, CompareType.GREATER_EQUALS));
        }
        if (endDate != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo(FILTER_PRO_CREATEDATE, (Object)endDate, CompareType.LESS_EQUALS));
        }
        if (!exceType.equals((Object)ExceptionTypeEnum.NULL)) {
            filterInfo.getFilterItems().add(new FilterItemInfo(FILTER_PRO_EXCEPTIONTYPE, (Object)new Integer(exceType.getValue()), CompareType.EQUALS));
        }
        return filterInfo;
    }

    public void clear() {
        super.clear();
        this.setDefaultValue();
    }

    protected void setDefaultValue() {
        this.kddStartDate.setValue(null);
        this.kddEndDate.setValue(null);
        this.cboExceptionType.setSelectedItem((Object)ExceptionTypeEnum.NULL);
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        super.loadData(entityViewInfo);
        FilterInfo filterInfo = entityViewInfo.getFilter();
        if (filterInfo.getFilterItems() != null && filterInfo.getFilterItems().size() > 0) {
            for (int i = 0; i < filterInfo.getFilterItems().size(); ++i) {
                Date beginDate;
                FilterItemInfo filterItemInfo = filterInfo.getFilterItems().get(i);
                if (filterItemInfo.getPropertyName().equals(FILTER_PRO_CREATEDATE) && filterItemInfo.getCompareType().equals((Object)CompareType.GREATER_EQUALS)) {
                    beginDate = (Date)filterItemInfo.getCompareValue();
                    this.kddStartDate.setValue((Object)beginDate);
                }
                if (filterItemInfo.getPropertyName().equals(FILTER_PRO_CREATEDATE) && filterItemInfo.getCompareType().equals((Object)CompareType.LESS_EQUALS)) {
                    beginDate = (Date)filterItemInfo.getCompareValue();
                    this.kddEndDate.setValue((Object)beginDate);
                }
                if (!filterItemInfo.getPropertyName().equals(FILTER_PRO_EXCEPTIONTYPE)) continue;
                ExceptionTypeEnum exceType = ExceptionTypeEnum.getEnum((Integer)filterItemInfo.getCompareValue());
                this.cboExceptionType.setSelectedItem((Object)exceType);
            }
        }
    }
}

