/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.util.ControlUtilities;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.FrameWorkUtils;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.framework.client.IIDList;
import com.kingdee.eas.framework.client.RealModeIDList;
import com.kingdee.eas.mm.planning.AbstractRequirementPlanInfo;
import com.kingdee.eas.mm.planning.IBatchInfo;
import com.kingdee.eas.mm.planning.MMBatchResult;
import com.kingdee.eas.mm.planning.ReqPlanStatusEnum;
import com.kingdee.eas.mm.planning.RequirementPlanInfo;
import com.kingdee.eas.mm.planning.client.AbstractMMBatchEditUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public abstract class MMBatchEditUI
extends AbstractMMBatchEditUI {
    private static final Logger logger = CoreUIObject.getLogger(MMBatchEditUI.class);
    private IIDList idList = null;
    protected IObjectCollection editCollection = null;
    protected int currentRow = 0;
    protected int preRow = 0;

    protected void tblMain_tableDataRequest(KDTDataRequestEvent e) {
    }

    protected abstract IObjectCollection createBatchDataBaseCollection();

    protected abstract IBatchInfo createBatchDataBase();

    protected abstract List runSubmit(List var1) throws Exception;

    protected abstract ICoreBase getBatchBizInterface() throws Exception;

    public void loadCollectionFields(IObjectCollection collection) {
        this.tblMain.setUserObject((Object)this.editCollection);
        if (collection != null && collection.size() > 0) {
            for (CoreBaseInfo info : collection) {
                IRow row = this.tblMain.addRow();
                this.loadLineFields(this.tblMain, row, (IObjectValue)info);
            }
        }
    }

    public void storeCollectionFields() {
        this.dataBinder.storeCollectionFields();
    }

    public void doQuery() {
        this.editCollection.clear();
        this.tblMain.removeRows();
    }

    @Override
    public void setOprtState(String oprtType) {
        super.setOprtState(oprtType);
        this.actionAudit.setVisible(false);
        this.actionUnAudit.setVisible(false);
        if (OprtState.VIEW.equals(this.oprtState)) {
            this.actionSave.setEnabled(false);
            this.actionSubmit.setEnabled(false);
            this.actionRemoveLine.setEnabled(false);
            this.actionInsertLine.setEnabled(false);
            this.actionAddLine.setEnabled(false);
        } else {
            this.actionRemoveLine.setEnabled(true);
            this.actionInsertLine.setEnabled(true);
            this.actionSave.setEnabled(true);
            this.actionSubmit.setEnabled(true);
            this.actionAddLine.setEnabled(true);
        }
    }

    protected final void setDataCollection(IObjectCollection collection) {
        if (collection == null || collection.size() <= 0) {
            return;
        }
        for (CoreBaseInfo info : collection) {
            int index;
            if (this.editCollection.containsKey((Object)info.getId().toString()) || (index = this.editCollection.indexOf((Object)info.getId().toString())) > 0) continue;
            this.editCollection.addObject((IObjectValue)info);
        }
        this.dataBinder.setObjectCollection(this.editCollection);
    }

    protected CoreBaseCollection getCoreBaseCollection() {
        return (CoreBaseCollection)this.editCollection.cast(CoreBaseCollection.class);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionAudit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_auditing"));
        this.actionUnAudit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_fauditing"));
        this.actionSave.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_temporarilysave"));
        this.actionSubmit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_submit"));
        this.actionAddLine.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_addline"));
        this.actionInsertLine.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_insert"));
        this.actionCopyLine.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_copy"));
        this.actionRemoveLine.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_deleteline"));
    }

    public void onLoad() throws Exception {
        this.tblMain.checkParsed();
        this.initUIControl();
        super.onLoad();
        this.idList = (IIDList)this.getUIContext().get("IDList");
        if (this.idList == null) {
            this.idList = new RealModeIDList();
        }
        this.loadDataCollection();
        this.getUIContext().put("DataBinder", this.dataBinder);
    }

    protected void initUIControl() throws Exception {
    }

    protected void loadDataCollection() throws Exception {
        if (this.getUIContext().get("InitDataObject") != null && this.getUIContext().get("InitDataObject") instanceof IObjectCollection) {
            this.setDataCollection((IObjectCollection)this.getUIContext().get("InitDataObject"));
        } else if ("ADDNEW".equals(this.getOprtState())) {
            this.editCollection = this.createBatchDataBaseCollection();
            this.setDataCollection(this.editCollection);
        } else if (this.idList != null && this.idList.size() > 0) {
            this.setDataCollection(this.getCollection(this.idList));
        } else {
            return;
        }
        this.loadCollectionFields(this.editCollection);
        this.showMessageForStatus();
    }

    protected String getKeyFieldName() {
        return "id";
    }

    protected IObjectCollection getCollection(IIDList idList) throws Exception {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        StringBuffer maskString = new StringBuffer();
        for (int i = 0; i < idList.size(); ++i) {
            FilterItemInfo filterItem = new FilterItemInfo(this.getKeyFieldName(), (Object)idList.getID(i));
            filter.getFilterItems().add(filterItem);
            maskString.append("#");
            maskString.append(i);
            if (i == idList.size() - 1) continue;
            maskString.append(" OR ");
        }
        filter.setMaskString(maskString.toString());
        ev.setFilter(filter);
        ev.setSelector(this.getSelectors());
        return this.getBatchBizInterface().getCollection(ev);
    }

    protected void showMessageForStatus() {
        this.setShowMessagePolicy(2);
        if ("EDIT".equals(this.getOprtState())) {
            this.showEdit();
        } else if ("ADDNEW".equals(this.getOprtState())) {
            this.showAddNew();
        }
    }

    protected void showAddNew() {
        this.setMessageText(this.getClassAlise() + " " + EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_AddNew"));
        this.showMessage();
    }

    protected void showEdit() {
        this.setMessageText(this.getClassAlise() + " " + EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Edit"));
        this.setIsShowTextOnly(true);
        this.showMessage();
    }

    protected String getClassAlise() {
        String className = FrameWorkUtils.getClassAlias((CoreBaseInfo)((CoreBaseInfo)this.createBatchDataBase()));
        return className;
    }

    protected void loadLineFields(KDTable table, IRow row, IObjectValue obj) {
        this.dataBinder.loadLineFields(table, row, obj);
    }

    protected void storeLineFields(KDTable table, IRow row, IObjectValue obj) {
        this.dataBinder.storeLineFields(table, row, obj);
    }

    protected KDTable getTable() {
        return this.tblMain;
    }

    protected void addLine(KDTable table) {
        if (table == null) {
            return;
        }
        IObjectValue detailData = (IObjectValue)this.createBatchDataBase();
        IRow row = table.addRow();
        this.beforeAddLine(table, row, detailData);
        this.editCollection.addObject(detailData);
        this.loadLineFields(table, row, detailData);
        this.afterAddLine(table, row, detailData);
    }

    protected void afterAddLine(KDTable table, IRow row, IObjectValue lineData) {
    }

    protected void beforeAddLine(KDTable table, IRow row, IObjectValue lineData) {
    }

    protected boolean isTableColumnSelected(KDTable table) {
        KDTSelectBlock block;
        return table.getSelectManager().size() > 0 && ((block = table.getSelectManager().get()).getMode() == 4 || block.getMode() == 8);
    }

    protected void insertLine(KDTable table) {
        if (table == null) {
            return;
        }
        IObjectValue detailData = (IObjectValue)this.createBatchDataBase();
        IRow row = null;
        if (table.getSelectManager().size() > 0) {
            int top = table.getSelectManager().get().getTop();
            row = this.isTableColumnSelected(table) ? table.addRow() : table.addRow(top);
        } else {
            row = table.addRow();
        }
        this.beforeInsertLine(table, row, detailData);
        this.editCollection.addObject(row.getRowIndex(), detailData);
        this.loadLineFields(table, row, detailData);
        this.afterInsertLine(table, row, detailData);
    }

    protected void beforeInsertLine(KDTable table, IRow row, IObjectValue detailData) {
    }

    protected void afterInsertLine(KDTable table, IRow row, IObjectValue lineData) {
    }

    protected void copyLine(KDTable table) {
        if (table == null) {
            return;
        }
        if (table.getSelectManager().size() == 0 || this.isTableColumnSelected(table)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"85_MMBatchEditUI"));
            return;
        }
        if (table.getSelectManager().size() > 0) {
            int i;
            IRow row = null;
            int[] selectRows = KDTableUtil.getSelectedRows((KDTable)table);
            CoreBaseInfo[] baseInfo = new CoreBaseInfo[selectRows.length];
            for (i = 0; i < selectRows.length; ++i) {
                baseInfo[i] = (CoreBaseInfo)table.getRow(selectRows[i]).getUserObject();
                this.storeLineFields(this.tblMain, this.tblMain.getRow(i), (IObjectValue)baseInfo[i]);
            }
            this.beforeCopyLine(baseInfo);
            for (i = 0; i < selectRows.length; ++i) {
                CoreBaseInfo detailData = baseInfo[i];
                IObjectValue newDetailData = (IObjectValue)this.createBatchDataBase();
                this.doCopyData((IObjectValue)detailData, newDetailData);
                ((CoreBaseInfo)newDetailData).setId(null);
                ((ObjectBaseInfo)newDetailData).setCreateTime(new Timestamp(System.currentTimeMillis()));
                ((ObjectBaseInfo)newDetailData).setLastUpdateUser(SysContext.getSysContext().getCurrentUserInfo());
                ((ObjectBaseInfo)newDetailData).setLastUpdateTime(((ObjectBaseInfo)newDetailData).getCreateTime());
                ((RequirementPlanInfo)newDetailData).setStatus(ReqPlanStatusEnum.ACTIVE);
                ((RequirementPlanInfo)newDetailData).setQty(new BigDecimal(0));
                ((RequirementPlanInfo)newDetailData).setBaseQty(new BigDecimal(0));
                ((RequirementPlanInfo)newDetailData).setCntactTotalQty(new BigDecimal(0));
                ((RequirementPlanInfo)newDetailData).setBaseCntactTotalQty(new BigDecimal(0));
                ((RequirementPlanInfo)newDetailData).setBaseNotCntactQty(new BigDecimal(0));
                ((RequirementPlanInfo)newDetailData).setNotCntactQty(new BigDecimal(0));
                ((IBatchInfo)newDetailData).setOprStatus((short)1);
                this.editCollection.addObject(newDetailData);
                row = table.addRow();
                this.loadLineFields(table, row, newDetailData);
                this.afterCopyLine(table, row, newDetailData);
            }
        }
    }

    protected void doCopyData(IObjectValue copyFromObj, IObjectValue copyToObj) {
    }

    protected void beforeCopyLine(CoreBaseInfo[] baseInfo) {
    }

    protected void afterCopyLine(KDTable table, IRow row, IObjectValue lineData) {
    }

    protected boolean confirmMsg(String msg) {
        return MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)msg));
    }

    protected void removeLine(KDTable table) {
        if (table == null) {
            return;
        }
        if (table.getSelectManager().size() == 0 || this.isTableColumnSelected(table)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
            return;
        }
        String msg = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Delete");
        if (this.confirmMsg(msg)) {
            int i;
            int[] selectRows = KDTableUtil.getSelectedRows((KDTable)table);
            ArrayList<CoreBaseInfo> delList = new ArrayList<CoreBaseInfo>();
            for (i = 0; i < selectRows.length; ++i) {
                delList.add((CoreBaseInfo)table.getRow(selectRows[i]).getUserObject());
            }
            this.beforeRemoveLine(delList);
            block1: for (i = 0; i < delList.size(); ++i) {
                CoreBaseInfo detailData = (CoreBaseInfo)delList.get(i);
                for (int j = 0; j < table.getBody().size(); ++j) {
                    CoreBaseInfo tmpDetail;
                    IRow row = table.getRow2(j);
                    if (row == null || !(tmpDetail = (CoreBaseInfo)row.getUserObject()).equals((Object)detailData)) continue;
                    this.removeRow(j);
                    if (detailData.getId() != null && ((IBatchInfo)detailData).getOprStatus() != 1) {
                        this.updateValueObjectStatus(detailData, (short)3);
                        continue block1;
                    }
                    this.editCollection.removeObject((IObjectValue)detailData);
                    continue block1;
                }
            }
            this.afterRemoveLine(delList);
        }
    }

    protected void beforeRemoveLine(List delList) {
    }

    protected void afterRemoveLine(List delList) {
    }

    protected void updateValueObjectStatus(CoreBaseInfo detailData, short oprStatus) {
        for (CoreBaseInfo info : this.editCollection) {
            if (info.getId() == null || !info.getId().toString().equals(detailData.getId().toString())) continue;
            ((IBatchInfo)info).setOprStatus(oprStatus);
            if (2 != oprStatus) break;
            ((ObjectBaseInfo)info).setLastUpdateUser(SysContext.getSysContext().getCurrentUserInfo());
            break;
        }
    }

    public boolean isModify() {
        try {
            ControlUtilities.checkFocusAndCommit();
        }
        catch (ParseException e) {
            this.handleControlException();
            this.abort();
        }
        boolean isModify = false;
        for (IBatchInfo info : this.editCollection) {
            if (!info.isModify()) continue;
            isModify = true;
            break;
        }
        return isModify;
    }

    public boolean checkBeforeWindowClosing() {
        boolean b = super.checkBeforeWindowClosing();
        if (!b) {
            return b;
        }
        try {
            b = this.isModify();
            if (b) {
                int result = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Save_Exit"));
                if (result == 0) {
                    this.actionSubmit.setDaemonRun(false);
                    ActionEvent event = new ActionEvent(this.btnSubmit, 1001, this.btnSubmit.getActionCommand());
                    this.actionSubmit.actionPerformed(event);
                    return !this.actionSubmit.isInvokeFailed();
                }
                if (result == 1) {
                    return true;
                }
                if (result == 2) {
                    this.abort();
                }
            }
        }
        catch (Exception exc) {
            return false;
        }
        return true;
    }

    @Override
    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        if (this.getTable() != null) {
            this.addLine(this.getTable());
        }
    }

    @Override
    public void actionInsertLine_actionPerformed(ActionEvent e) throws Exception {
        if (this.getTable() != null) {
            this.insertLine(this.getTable());
        }
    }

    @Override
    public void actionRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        if (this.getTable() != null) {
            this.removeLine(this.getTable());
        }
    }

    @Override
    public void actionCopyLine_actionPerformed(ActionEvent e) throws Exception {
        if (this.getTable() != null) {
            this.copyLine(this.getTable());
        }
    }

    @Override
    protected void tblMain_editStarting(KDTEditEvent e) throws Exception {
        super.tblMain_editStarting(e);
    }

    @Override
    protected void tblMain_editStopped(KDTEditEvent e) throws Exception {
        super.tblMain_editStopped(e);
        this.doModify(e);
    }

    private void doModify(KDTEditEvent e) {
        int sm = this.getTable().getSelectManager().getSelectMode();
        if (sm == 0 || sm == 8 || sm == 4 || sm == 12) {
            return;
        }
        if (e.getOldValue() == null && e.getValue() == null) {
            return;
        }
        CoreBaseInfo info = (CoreBaseInfo)this.getTable().getRow(e.getRowIndex()).getUserObject();
        if (e.getOldValue() != null && e.getValue() != null && e.getOldValue().equals(e.getValue())) {
            return;
        }
        boolean modify = false;
        if (e.getOldValue() != null && e.getValue() != null && e.getOldValue() instanceof Date && e.getValue() instanceof Date) {
            String d2;
            SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
            String d1 = sf.format((Date)e.getOldValue());
            modify = !d1.equals(d2 = sf.format((Date)e.getValue()));
        } else {
            boolean bl = modify = e.getOldValue() == null && e.getValue() != null || e.getOldValue() != null && e.getValue() == null || e.getOldValue() != null && e.getValue() != null && !e.getOldValue().equals(e.getValue());
        }
        if (modify) {
            IRow row = this.getTable().getRow(e.getRowIndex());
            this.storeLineFields(this.getTable(), row, (IObjectValue)info);
            ((IBatchInfo)info).setModify(true);
            if (info.getId() != null && ((IBatchInfo)info).getOprStatus() == 0) {
                this.updateValueObjectStatus(info, (short)2);
            }
        }
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        ArrayList<Object> updateCollection = new ArrayList<Object>();
        for (IBatchInfo info : this.editCollection) {
            if (info.getOprStatus() == 3) {
                updateCollection.add(((CoreBaseInfo)info).getId().toString());
                continue;
            }
            if (info.getOprStatus() == 0) continue;
            updateCollection.add(info);
        }
        if (updateCollection.size() <= 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"86_MMBatchEditUI"));
        } else if (this.verifyInput()) {
            List result = this.runSubmit(updateCollection);
            this.processResult(result);
        } else {
            this.abort();
        }
    }

    protected boolean verifyInput() throws Exception {
        return true;
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
    }

    protected void processResult(List rlts) throws Exception {
        if (rlts == null) {
            throw new Exception(EASResource.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"87_MMBatchEditUI"));
        }
        MMBatchResult result = (MMBatchResult)rlts.get(0);
        StringBuffer headlineMsg = result.getHeadMsg();
        StringBuffer detailMsg = result.getDetailMsg();
        this.updateSuccessResultToEditCollection(result.getInsertedObject(), (short)1);
        this.updateSuccessResultToEditCollection(result.getDeletedPK(), (short)3);
        this.updateSuccessResultToEditCollection(result.getUpdatedObject(), (short)2);
        this.updateFailureResultToEditCollection(result.getErrDeletePK(), (short)3);
        if (detailMsg.length() > 0) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)headlineMsg.toString(), (String)detailMsg.toString(), (int)1);
        } else {
            this.setIsShowTextOnly(false);
            this.setMessageText(this.getClassAlise() + " " + headlineMsg.toString());
            this.setNextMessageText("");
            this.setShowMessagePolicy(0);
            this.showMessage();
        }
    }

    protected void updateFailureResultToEditCollection(List failureResList, short oprStatus) {
        if (failureResList == null || failureResList.size() <= 0) {
            return;
        }
        for (Object obj : failureResList) {
            switch (oprStatus) {
                case 3: {
                    int index = this.indexOfCollection((String)obj, (short)2);
                    if (index <= -1) break;
                    IBatchInfo info = (IBatchInfo)this.editCollection.getObject(index);
                    info.setOprStatus((short)0);
                    IRow row = this.tblMain.addRow();
                    this.loadLineFields(this.tblMain, row, (IObjectValue)info);
                    break;
                }
            }
        }
    }

    protected void removeRow(int rowIndex) {
        if (rowIndex > -1 && rowIndex < this.tblMain.getBody().size()) {
            this.tblMain.removeRow(rowIndex);
        }
    }

    protected void updateSuccessResultToEditCollection(List successResList, short oprStatus) {
        if (successResList == null || successResList.size() <= 0) {
            return;
        }
        block5: for (Object obj : successResList) {
            switch (oprStatus) {
                case 1: {
                    int index = this.indexOfCollection(((RequirementPlanInfo)obj).getNumber(), oprStatus);
                    if (index <= -1) break;
                    this.editCollection.setObject(index, (IObjectValue)((DataBaseInfo)obj));
                    int rowIndex = this.indexOfTblMain(((RequirementPlanInfo)obj).getNumber(), oprStatus);
                    if (rowIndex <= -1) continue block5;
                    this.loadLineFields(this.tblMain, this.tblMain.getRow(rowIndex), (IObjectValue)obj);
                    break;
                }
                case 2: {
                    int index = this.indexOfCollection(((RequirementPlanInfo)obj).getId().toString(), oprStatus);
                    if (index <= -1) break;
                    this.editCollection.setObject(index, (IObjectValue)((DataBaseInfo)obj));
                    int rowIndex = this.indexOfTblMain(((RequirementPlanInfo)obj).getId().toString(), oprStatus);
                    if (rowIndex <= -1) continue block5;
                    this.loadLineFields(this.tblMain, this.tblMain.getRow(rowIndex), (IObjectValue)obj);
                    break;
                }
                case 3: {
                    int index = this.indexOfCollection((String)obj, oprStatus);
                    if (index <= -1) break;
                    this.editCollection.removeObject(index);
                    break;
                }
            }
        }
    }

    protected int indexOfTblMain(String featureValue, short oprStatus) {
        if (this.tblMain.getBody().size() <= 0) {
            return -1;
        }
        if (featureValue == null || featureValue.length() <= 0) {
            return -1;
        }
        int n = this.tblMain.getBody().size();
        for (int i = 0; i < n; ++i) {
            IBatchInfo batchInfo;
            IRow row = this.tblMain.getRow(i);
            DataBaseInfo info = (DataBaseInfo)row.getUserObject();
            if (!(oprStatus == 2 || oprStatus == 3 ? info.getId() != null && info.getId().toString().equals(featureValue) : oprStatus == 1 && featureValue.equals((batchInfo = (IBatchInfo)info).getFeatureValue()))) continue;
            return row.getRowIndex();
        }
        return -1;
    }

    protected int indexOfCollection(String featureValue, short oprStatus) {
        if (this.editCollection == null || this.editCollection.size() <= 0) {
            return -1;
        }
        if (featureValue == null || featureValue.length() <= 0) {
            return -1;
        }
        int n = this.editCollection.size();
        for (int i = 0; i < n; ++i) {
            IBatchInfo batchInfo;
            DataBaseInfo info = (DataBaseInfo)this.editCollection.getObject(i);
            if (!(oprStatus == 2 || oprStatus == 3 ? info.getId() != null && info.getId().toString().equals(featureValue) : oprStatus == 1 && featureValue.equals((batchInfo = (IBatchInfo)info).getFeatureValue()))) continue;
            return i;
        }
        return -1;
    }

    public IObjectCollection getObjectCollectionByOprStatus(short oprStatus) {
        IObjectCollection collection = this.createBatchDataBaseCollection();
        if (this.editCollection != null && this.editCollection.size() > 0) {
            for (IBatchInfo info : this.editCollection) {
                if (info.getOprStatus() != oprStatus) continue;
                collection.addObject((IObjectValue)info);
            }
        }
        return collection;
    }

    protected String getMultiLangString(String key) {
        return EASResource.getString((String)"com.kingdee.eas.mm.planning.MMBatchEditResource", (String)key);
    }

    public String getNewNumberByUnit(String bizOrgUnitID, IObjectValue editData) throws BOSException, EASBizException {
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
        if (iCodingRuleManager.isExist(editData, bizOrgUnitID)) {
            return iCodingRuleManager.getNumber(editData, bizOrgUnitID);
        }
        return null;
    }

    public void recycleNumber(String orgUnitid, IObjectValue editData, String[] number) throws BOSException, EASBizException {
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
        if (iCodingRuleManager.isExist(editData, orgUnitid) && iCodingRuleManager.isUseIntermitNumber(editData, orgUnitid)) {
            iCodingRuleManager.recycleBatchNumber(editData, orgUnitid, number);
        }
    }

    public void recycleNumber(Object obj) {
        if (obj == null) {
            return;
        }
        ArrayList<String> numberList = new ArrayList<String>();
        Iterator iter = null;
        if (obj instanceof List) {
            iter = ((List)obj).iterator();
        } else if (obj instanceof IObjectCollection) {
            iter = ((IObjectCollection)obj).iterator();
        }
        AbstractRequirementPlanInfo info = null;
        while (iter != null && iter.hasNext()) {
            RequirementPlanInfo tmp = (RequirementPlanInfo)iter.next();
            if (info == null) {
                info = tmp;
            }
            if (tmp.getId() != null || tmp.getOprStatus() != 1) continue;
            numberList.add(tmp.getNumber());
        }
        if (numberList != null && numberList.size() > 0 && info != null) {
            try {
                if (info.getStorageOrgUnit() != null) {
                    this.recycleNumber(info.getStorageOrgUnit().getId().toString(), (IObjectValue)info, numberList.toArray(new String[numberList.size()]));
                }
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
    }
}

