/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.mm.planning.IMRPCalcFacade;
import com.kingdee.eas.mm.planning.MRPCalcFacadeFactory;
import com.kingdee.eas.mm.planning.MRPRunLogInfo;
import com.kingdee.eas.mm.planning.client.AbstractMRPRunLogGeneralListUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import org.apache.log4j.Logger;

public class MRPRunLogGeneralListUI
extends AbstractMRPRunLogGeneralListUI {
    private static final Logger logger = CoreUIObject.getLogger(MRPRunLogGeneralListUI.class);
    public static final String strResource = "com.kingdee.eas.mm.planning.client.PlanningResource.";
    private MRPRunLogInfo mrpLogInfo;
    private int showContent;

    public void onLoad() throws Exception {
        this.actionQuery.setVisible(true);
        this.tblGeneral.checkParsed();
        this.tblMain.setFormatXml(this.resHelper.getString("tblGeneral.formatXml"));
        this.tblMain.checkParsed();
        super.onLoad();
        this.tblGeneral.getStyleAttributes().setLocked(true);
        this.tblGeneral.getColumn("FPlanBeginDate").getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDateFormatString());
        this.tblGeneral.getColumn("FPlanEndDate").getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDateFormatString());
        this.tblGeneral.getColumn("FPAB").getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDateFormatString());
        this.actionQuery.setVisible(false);
    }

    public String getPrintTitle() {
        return this.getUITitle();
    }

    public void onShow() throws Exception {
        this.prepareAndShowContent();
        super.onShow();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void setMrpRunLogInfo(MRPRunLogInfo mrpLogInfo) {
        this.mrpLogInfo = mrpLogInfo;
    }

    private static String formatNumericTypeData(int nPrecision, BigDecimal bdValue) throws Exception {
        DecimalFormat format = (DecimalFormat)DecimalFormat.getInstance();
        format.setMaximumFractionDigits(nPrecision);
        format.setMinimumFractionDigits(nPrecision);
        return format.format(bdValue).toString();
    }

    private void setQtyCellValue(ICell cell, BigDecimal nPrecision, BigDecimal bdValue) throws Exception {
        cell.setValue((Object)MRPRunLogGeneralListUI.formatNumericTypeData(nPrecision.intValue(), bdValue));
    }

    public IRowSet fetchRowset(int dataType, String strStorageUnitID, String strMrpLogID) {
        IRowSet rs = null;
        try {
            IMRPCalcFacade calcFacade = MRPCalcFacadeFactory.getRemoteInstance();
            rs = calcFacade.fetchPlanData(dataType, strStorageUnitID, strMrpLogID);
        }
        catch (Exception e1) {
            this.handleException(e1);
        }
        return rs;
    }

    public void setContentToDisplay(int nShowContent) {
        this.showContent = nShowContent;
    }

    private void hideIndividualCols() {
        this.tblGeneral.getColumn("FBillNumber").getStyleAttributes().setHided(true);
        this.tblGeneral.getColumn("FException1").getStyleAttributes().setHided(true);
        this.tblGeneral.getColumn("FException2").getStyleAttributes().setHided(true);
        this.tblGeneral.getColumn("FException3").getStyleAttributes().setHided(true);
        this.tblGeneral.getColumn("FSafeStock").getStyleAttributes().setHided(true);
        this.tblGeneral.getColumn("FOnHand").getStyleAttributes().setHided(true);
        this.tblGeneral.getColumn("FPlannedQty").getStyleAttributes().setHided(true);
        this.tblGeneral.getColumn("FPlanBeginDate").getStyleAttributes().setHided(true);
        this.tblGeneral.getColumn("FPlanEndDate").getStyleAttributes().setHided(true);
        this.tblGeneral.getColumn("FPAB").getStyleAttributes().setHided(true);
    }

    private void resetKDTable(int dataType) {
        this.hideIndividualCols();
        switch (dataType) {
            case 1: {
                this.tblGeneral.getColumn("FBillNumber").getStyleAttributes().setHided(false);
                this.tblGeneral.getColumn("FException1").getStyleAttributes().setHided(false);
                this.tblGeneral.getColumn("FException2").getStyleAttributes().setHided(false);
                this.tblGeneral.getColumn("FException3").getStyleAttributes().setHided(false);
                break;
            }
            case 2: {
                this.tblGeneral.getColumn("FSafeStock").getStyleAttributes().setHided(false);
                this.tblGeneral.getColumn("FOnHand").getStyleAttributes().setHided(false);
                break;
            }
            case 3: {
                this.tblGeneral.getColumn("FBillNumber").getStyleAttributes().setHided(false);
                this.tblGeneral.getColumn("FPlannedQty").getStyleAttributes().setHided(false);
                this.tblGeneral.getColumn("FPlanBeginDate").getStyleAttributes().setHided(false);
                this.tblGeneral.getColumn("FPlanEndDate").getStyleAttributes().setHided(false);
                this.tblGeneral.getColumn("FPAB").getStyleAttributes().setHided(false);
            }
        }
    }

    private int fillTableWithExcep(String strStorageUnitID, String strMrpLogID) throws Exception {
        this.resetKDTable(1);
        IRowSet rs = this.fetchRowset(1, strStorageUnitID, strMrpLogID);
        while (rs.next()) {
            IRow row = this.tblGeneral.addRow();
            row.getCell("FMatNumber").setValue(rs.getObject("FMatNumber"));
            row.getCell("FMatName").setValue(rs.getObject("FMatName"));
            row.getCell("FBillNumber").setValue(rs.getObject("FBillNumber"));
            row.getCell("FException1").setValue(rs.getObject("Exception1"));
            row.getCell("FException2").setValue(rs.getObject("Exception2"));
            row.getCell("FException3").setValue(rs.getObject("Exception3"));
        }
        return rs.size();
    }

    private void prepareAndShowContent() {
        try {
            int nRowCount = 0;
            switch (this.showContent) {
                case 1: {
                    this.setUITitle(EASResource.getString((String)"com.kingdee.eas.mm.planning.client.PlanningResource.MRP_RUN_LOG_DETAIL_EXCEPTION"));
                    nRowCount = this.fillTableWithExcep(this.mrpLogInfo.getStorageOrgUnit().getId().toString(), this.mrpLogInfo.getId().toString());
                    break;
                }
                case 2: {
                    this.setUITitle(EASResource.getString((String)"com.kingdee.eas.mm.planning.client.PlanningResource.MRP_RUN_LOG_DETAIL_STORAGE"));
                    nRowCount = this.fillTableWithStorage(this.mrpLogInfo.getStorageOrgUnit().getId().toString(), this.mrpLogInfo.getId().toString());
                    break;
                }
                case 3: {
                    this.setUITitle(EASResource.getString((String)"com.kingdee.eas.mm.planning.client.PlanningResource.MRP_RUN_LOG_DETAIL_ORDER"));
                    nRowCount = this.fillTableWtihOrder(this.mrpLogInfo.getStorageOrgUnit().getId().toString(), this.mrpLogInfo.getId().toString());
                }
            }
            this.tblMain = this.tblGeneral;
            if (nRowCount <= 0) {
                MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.mm.planning.client.PlanningResource.MPS_MRP_RUN_LOG_OVERLAP_QUERY_LATEST_PLS"));
                this.actionExitCurrent_actionPerformed(null);
            }
        }
        catch (Exception e1) {
            this.handleException(e1);
        }
    }

    private int fillTableWithStorage(String strStorageUnitID, String strMrpLogID) throws Exception {
        this.resetKDTable(2);
        IRowSet rs = this.fetchRowset(2, strStorageUnitID, strMrpLogID);
        while (rs.next()) {
            IRow row = this.tblGeneral.addRow();
            row.getCell("FMatNumber").setValue(rs.getObject("FMatNumber"));
            row.getCell("FMatName").setValue(rs.getObject("FMatName"));
            this.setQtyCellValue(row.getCell("FOnHand"), rs.getBigDecimal("FBaseQtyPrc"), rs.getBigDecimal("FOnHand"));
            this.setQtyCellValue(row.getCell("FSafeStock"), rs.getBigDecimal("FBaseQtyPrc"), rs.getBigDecimal("FSafeStock"));
        }
        return rs.size();
    }

    private int fillTableWtihOrder(String strStorageUnitID, String strMrpLogID) throws Exception {
        this.resetKDTable(3);
        IRowSet rs = this.fetchRowset(3, strStorageUnitID, strMrpLogID);
        while (rs.next()) {
            IRow row = this.tblGeneral.addRow();
            row.getCell("FMatNumber").setValue(rs.getObject("FMatNumber"));
            row.getCell("FMatName").setValue(rs.getObject("FMatName"));
            row.getCell("FBillNumber").setValue(rs.getObject("FBillNumber"));
            this.setQtyCellValue(row.getCell("FPlannedQty"), rs.getBigDecimal("FBaseQtyPrc"), rs.getBigDecimal("FPlannedQty"));
            row.getCell("FPlanBeginDate").setValue(rs.getObject("FPlanBeginDate"));
            row.getCell("FPlanEndDate").setValue(rs.getObject("FPlanEndDate"));
            row.getCell("FPAB").setValue(rs.getObject("FBillDate"));
        }
        return rs.size();
    }

    public QuerySolutionInfo getQuerySolutionInfo() {
        return null;
    }

    public Object getTablePreferenceSchemaKey() {
        return new Integer(this.showContent);
    }

    @Override
    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        super.tblMain_tableClicked(e);
    }

    protected void menuItemImportData_actionPerformed(ActionEvent e) throws Exception {
        super.menuItemImportData_actionPerformed(e);
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    public void actionSendMessage_actionPerformed(ActionEvent e) throws Exception {
        super.actionSendMessage_actionPerformed(e);
    }

    public void actionCalculator_actionPerformed(ActionEvent e) throws Exception {
        super.actionCalculator_actionPerformed(e);
    }

    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        super.actionExport_actionPerformed(e);
    }

    public void actionExportSelected_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportSelected_actionPerformed(e);
    }

    public void actionRegProduct_actionPerformed(ActionEvent e) throws Exception {
        super.actionRegProduct_actionPerformed(e);
    }

    public void actionPersonalSite_actionPerformed(ActionEvent e) throws Exception {
        super.actionPersonalSite_actionPerformed(e);
    }

    public void actionProcductVal_actionPerformed(ActionEvent e) throws Exception {
        super.actionProcductVal_actionPerformed(e);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        super.actionView_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemove_actionPerformed(e);
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.tblGeneral);
        this.tblGeneral.getPrintManager().print();
    }

    protected KDTable getTableForPrintSetting() {
        return this.tblGeneral;
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.tblGeneral.getPrintManager().printPreview();
    }

    public void actionLocate_actionPerformed(ActionEvent e) throws Exception {
        super.actionLocate_actionPerformed(e);
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
    }

    public void actionImportData_actionPerformed(ActionEvent e) throws Exception {
        super.actionImportData_actionPerformed(e);
    }

    public void actionAttachment_actionPerformed(ActionEvent e) throws Exception {
        super.actionAttachment_actionPerformed(e);
    }

    public void actionExportData_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportData_actionPerformed(e);
    }

    public void actionToExcel_actionPerformed(ActionEvent e) throws Exception {
        super.actionToExcel_actionPerformed(e);
    }

    public void actionStartWorkFlow_actionPerformed(ActionEvent e) throws Exception {
        super.actionStartWorkFlow_actionPerformed(e);
    }

    public void actionPublishReport_actionPerformed(ActionEvent e) throws Exception {
        super.actionPublishReport_actionPerformed(e);
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancelCancel_actionPerformed(e);
    }

    public void actionQueryScheme_actionPerformed(ActionEvent e) throws Exception {
        super.actionQueryScheme_actionPerformed(e);
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }
}

