/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.appframework.uistatemanage.ActionManager;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.base.commonquery.QueryPanelCollection;
import com.kingdee.eas.base.commonquery.QueryPanelInfo;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.XMLBean;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.commonquery.client.IPromptBoxFactory;
import com.kingdee.eas.base.license.LicenseException;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.IStorageOrgUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ContextTypeEnum;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.FrameWorkUtils;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchaction.ActionLevelEnum;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchSelectionEntries;
import com.kingdee.eas.framework.client.CoreBillListUI;
import com.kingdee.eas.mm.common.client.MMSpecialLicenseAdapter;
import com.kingdee.eas.mm.common.util.EditTableUtil;
import com.kingdee.eas.mm.planning.IMRPCalcFacade;
import com.kingdee.eas.mm.planning.IMRPRunLog;
import com.kingdee.eas.mm.planning.MRPCalcFacadeFactory;
import com.kingdee.eas.mm.planning.MRPRunLogFactory;
import com.kingdee.eas.mm.planning.MRPRunLogInfo;
import com.kingdee.eas.mm.planning.MRPRunLogStatusEnum;
import com.kingdee.eas.mm.planning.client.AbstractMRPRunLogListUI;
import com.kingdee.eas.mm.planning.client.MRPRunLogListFilterUI;
import com.kingdee.eas.mm.planning.client.MrpRunLogDetailUI;
import com.kingdee.eas.scm.common.action.ActionProxy;
import com.kingdee.eas.scm.common.action.ActionProxyFactory;
import com.kingdee.eas.scm.common.action.ISupportBatchAction;
import com.kingdee.eas.scm.common.action.ISupportObjContext;
import com.kingdee.eas.scm.common.action.ITableSelectionHelper;
import com.kingdee.eas.scm.common.action.SCMActionManager;
import com.kingdee.eas.scm.common.action.TableSelectionHelper;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Timer;

public class MRPRunLogListUI
extends AbstractMRPRunLogListUI
implements ISupportBatchAction,
ISupportObjContext {
    private Timer timer;
    private boolean isFromMenu = false;
    private EntityViewInfo view;
    private OrgUnitCollection authorizedMainOrgs = null;
    private String logIdToObserve = null;
    private boolean isTheObservedLogExist = this.logIdToObserve == null;
    protected SCMActionManager actionManager = null;
    private TableSelectionHelper tableSelectionHelper;
    private boolean isRefresh = false;
    public static final String strResource = "com.kingdee.eas.mm.planning.client.PlanningResource.";
    private static final String[] KDT_DATES = new String[]{"planDate"};
    private static final String[] KDT_DATETIMES = new String[]{"startTime", "endTime"};
    private String uiName = EASResource.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"88_MRPRunLogListUI");
    private MMSpecialLicenseAdapter licenseAdapter = null;

    public MRPRunLogListUI() throws Exception {
        this.getActionManager();
        this.setHasQyeryPK(true);
        this.tblMain.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                int firstIndex = e.getFirstRow();
                int lastIndex = e.getLastRow();
                String strGlobal = EASResource.getString((String)"com.kingdee.eas.mm.planning.client.PlanningResource.PLAN_GLOBAL");
                String strSimulation = EASResource.getString((String)"com.kingdee.eas.mm.planning.client.PlanningResource.PLAN_TRAIL");
            }
        });
    }

    public void setEntityViewInfo(EntityViewInfo view) {
        this.view = view;
    }

    public void setRefresh(boolean isRefresh) {
        this.isRefresh = isRefresh;
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        CommonQueryDialog dialog = new CommonQueryDialog();
        if (this.getUIWindow() == null) {
            dialog.setOwner((Component)this.getUIContext().get("OwnerWindow"));
        } else {
            dialog.setOwner((Component)((Object)this));
        }
        dialog.setUiObject((IUIObject)this);
        dialog.setParentUIClassName(((Object)((Object)this)).getClass().getName());
        dialog.setQueryObjectPK(this.mainQueryPK);
        dialog.setTitle(this.getUITitle() + " - " + EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Query_Filter"));
        try {
            MRPRunLogListFilterUI userPanel = new MRPRunLogListFilterUI();
            dialog.addUserPanel((KDPanel)userPanel);
        }
        catch (Exception e1) {
            this.handleException(e1);
        }
        IPromptBoxFactory promptBoxFactory = this.getPromptBoxFactory();
        if (promptBoxFactory != null) {
            dialog.setPromptBoxFactory(promptBoxFactory);
        }
        dialog.setMaxReturnCountVisible(true);
        return dialog;
    }

    public boolean destroyWindow() {
        boolean b;
        if (this.timer != null) {
            this.timer.stop();
        }
        if (b = super.destroyWindow()) {
            try {
                if (this.licenseAdapter != null) {
                    this.licenseAdapter.requestLicenseOrReleaseLicense(false, (IUIObject)this, this.uiName);
                }
            }
            catch (LicenseException e) {
                e.printStackTrace();
                this.abort();
            }
            catch (Exception e) {
                e.printStackTrace();
                this.abort();
            }
        }
        return b;
    }

    public void refreshProgress() throws Exception {
        if (this.isRefresh) {
            this.refreshList();
            this.isRefresh = false;
            return;
        }
        int rowCount = this.tblMain.getRowCount();
        HashMap<String, Integer> rows = new HashMap<String, Integer>();
        EntityViewInfo query = (EntityViewInfo)this.mainQuery.clone();
        FilterInfo filterInfo = new FilterInfo();
        query.setSorter(null);
        StringBuffer sbMask = new StringBuffer();
        MRPRunLogStatusEnum running = MRPRunLogStatusEnum.Running;
        String strStorageId = null;
        int maskIndex = 0;
        for (int i = 0; i < rowCount; ++i) {
            ICell cellStatus = this.tblMain.getRow(i).getCell("status");
            String strStatus = cellStatus.getValue().toString();
            if (!strStatus.equals(running.getAlias(SysContext.getSysContext().getLocale()))) continue;
            ICell cellId = this.tblMain.getRow(i).getCell("id");
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)cellId.getValue().toString(), CompareType.EQUALS));
            sbMask.append("or #").append(maskIndex++).append(" ");
            rows.put(cellId.getValue().toString(), new Integer(i));
            strStorageId = (String)this.tblMain.getRow(i).getCell("storageId").getValue();
        }
        if (sbMask.length() > 0) {
            this.updateStatusIfExit(strStorageId);
            filterInfo.setMaskString(sbMask.substring(3));
            query.setFilter(filterInfo);
            IMRPRunLog ctrlEntity = MRPRunLogFactory.getRemoteInstance();
            CoreBaseCollection colEntity = ctrlEntity.getCollection(query);
            for (int i = 0; i < colEntity.size(); ++i) {
                MRPRunLogInfo log = (MRPRunLogInfo)colEntity.get(i);
                Integer rowIndex = (Integer)rows.get(log.getId().toString());
                IRow row = this.tblMain.getRow(rowIndex.intValue());
                ICell cell = row.getCell("percent");
                int percent = log.getPercent();
                if (percent <= 100) {
                    cell.setValue((Object)new Integer(percent));
                }
                cell = row.getCell("endTime");
                cell.setValue((Object)log.getEndTime());
                cell = row.getCell("status");
                cell.setValue((Object)log.getStatus());
            }
        }
    }

    private void updateStatusIfExit(String strStorageId) {
        try {
            IMRPCalcFacade calcFacade = MRPCalcFacadeFactory.getRemoteInstance();
            calcFacade.updateExcepExitCalcStatus(strStorageId + "\n" + SysContext.getSysContext().getDcName());
        }
        catch (Exception e1) {
            this.handleException(e1);
        }
    }

    protected String getPropertyOfBizOrg(OrgType orgType) {
        return "storageOrgUnit.id";
    }

    private OrgUnitInfo[] getMainOrgFromSolution(QuerySolutionInfo solution) {
        String key = this.getPropertyOfBizOrg(this.getMainBizOrgType());
        if (solution != null && key != null) {
            QueryPanelCollection queryPanelCollection = solution.getQueryPanelInfo();
            int size = queryPanelCollection.size();
            for (int i = 0; i < size; ++i) {
                String params;
                QueryPanelInfo queryPanelInfo = queryPanelCollection.get(i);
                if (queryPanelInfo.getPanelClassName() == null || queryPanelInfo.getPanelClassName().equalsIgnoreCase("com.kingdee.eas.base.commonquery.client.CommonFilterPanel") || queryPanelInfo.getPanelClassName().equalsIgnoreCase("com.kingdee.eas.base.commonquery.client.CommonSorterPanel") || (params = queryPanelInfo.getCustomerParams()) == null) continue;
                CustomerParams cp = new CustomerParams();
                try {
                    ArrayList al = XMLBean.TransStrToAL((String)params);
                    Iterator j = al.iterator();
                    XMLBean xb = null;
                    while (j.hasNext()) {
                        xb = (XMLBean)j.next();
                        cp.addCustomerParam(xb.getName(), xb.getValue());
                    }
                    String orgs = cp.getCustomerParam(key);
                    if (orgs != null) {
                        return SCMGroupClientUtils.getOrgUnitInfos((String)orgs);
                    }
                    continue;
                }
                catch (Exception e) {
                    this.handUIException(e);
                }
            }
        }
        return null;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    protected List getMainBizOrgs(QuerySolutionInfo solution) {
        ArrayList<String> list = new ArrayList<String>();
        if (solution != null) {
            OrgUnitInfo[] orgUnitInfos = this.getMainOrgFromSolution(solution);
            if (orgUnitInfos != null && orgUnitInfos.length >= 1) {
                this.getUIContext().put(this.getMainBizOrgType(), orgUnitInfos[0]);
                for (int i = 0; i < orgUnitInfos.length; ++i) {
                    if (orgUnitInfos[i] == null) continue;
                    list.add(orgUnitInfos[i].getId().toString());
                }
            } else {
                this.getUIContext().put(this.getMainBizOrgType(), null);
                if (this.getMainOrgContext() != null) {
                    FrameWorkUtils.setCurrentOrgUnit((Context)this.getMainOrgContext(), null);
                }
            }
        } else if (this.getUIContext().get(this.getMainBizOrgType()) != null) {
            list.add(((OrgUnitInfo)this.getUIContext().get(this.getMainBizOrgType())).getId().toString());
        }
        return list;
    }

    public void onShow() throws Exception {
        this.refresh(null);
        super.onShow();
        this.btnRemove.setEnabled(true);
        this.actionRemove.setEnabled(true);
        this.menuItemRemove.setEnabled(true);
    }

    private void checkSpecialLicense(String planMode) {
        String fullName = "com.kingdee.eas.mm.planning.client.MRPRunLogListUI";
        if (planMode != null) {
            if (planMode.equalsIgnoreCase("MRP")) {
                fullName = fullName + "_MRP";
            } else if (planMode.equalsIgnoreCase("MPS")) {
                fullName = fullName + "_MPS";
            }
            this.licenseAdapter = new MMSpecialLicenseAdapter(fullName, planMode);
            try {
                this.licenseAdapter.requestLicenseOrReleaseLicense(true, (IUIObject)this, this.uiName);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.abort();
            }
        }
    }

    public void onLoad() throws Exception {
        String uiParam = (String)this.getUIContext().get("UIClassParam");
        this.checkSpecialLicense(uiParam);
        if (this.isFirstOnload() && this.isSupportedBatchActions()) {
            this.initBatchActions();
        }
        if (this.getUIContext().get("FromMpsGlobalPlanRunUI") == null) {
            this.isFromMenu = true;
        }
        this.logIdToObserve = (String)this.getUIContext().get("ThisMrpRunLogId");
        boolean bl = this.isTheObservedLogExist = this.logIdToObserve == null;
        if (!this.isFromMenu) {
            this.setIsNeedDefaultFilter(false);
        }
        super.onLoad();
        this.btnStop.setIcon(EASResource.getIcon((String)"imgTbtn_forbid"));
        this.menuItemStop.setIcon(EASResource.getIcon((String)"imgTbtn_forbid"));
        this.actionCreateTo.setVisible(false);
        this.menuItemCreateTo.setVisible(false);
        this.actionTraceUp.setVisible(false);
        this.menuItemTraceUp.setVisible(false);
        this.actionTraceDown.setVisible(false);
        this.menuItemTraceDown.setVisible(false);
        this.actionWorkFlowG.setVisible(false);
        this.menuWorkFlow.setVisible(false);
        this.actionAuditResult.setVisible(false);
        this.menuItemAuditResult.setVisible(false);
        this.btnAttachment.setVisible(false);
        this.MenuItemAttachment.setVisible(false);
        EditTableUtil.formatColDate((KDTable)this.tblMain, (String[])KDT_DATES);
        EditTableUtil.formatColDateTime((KDTable)this.tblMain, (String[])KDT_DATETIMES);
        final MRPRunLogListUI thisUI = this;
        this.timer = new Timer(5000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    if (thisUI.isVisible()) {
                        MRPRunLogListUI.this.refreshProgress();
                    }
                }
                catch (Exception e1) {
                    MRPRunLogListUI.this.handleException(e1);
                }
            }
        });
        this.timer.start();
        this.menuBar.remove((Component)this.menuBiz);
    }

    public static String getStorageOrgUnitId(String strNumber) throws BOSException {
        String strRet = null;
        IStorageOrgUnit ctrlEntity = StorageOrgUnitFactory.getRemoteInstance();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)strNumber));
        filter.setMaskString("#0");
        view.setFilter(filter);
        CoreBaseCollection colEntity = ctrlEntity.getCollection(view);
        if (colEntity.size() > 0) {
            strRet = colEntity.get(0).getId().toString();
        }
        return strRet;
    }

    protected boolean initDefaultFilter() {
        return this.isFromMenu;
    }

    protected IObjectPK getUserPk() {
        UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
        ObjectUuidPK userPK = new ObjectUuidPK(userInfo.getId());
        return userPK;
    }

    protected IObjectPK getOrgPK(String id) {
        return new ObjectUuidPK(id);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void actionStop_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int rowNum = this.tblMain.getSelectManager().get().getTop();
        ICell cellNumber = this.tblMain.getRow(rowNum).getCell("number");
        ICell cellOrg = this.tblMain.getRow(rowNum).getCell("storageId");
        String msg = EASResource.getString((String)"com.kingdee.eas.mm.planning.MRPResource", (String)"CONFIRM_STOPRUNNING");
        int result = MsgBox.showConfirm2((String)msg);
        if (result == 0) {
            MRPCalcFacadeFactory.getRemoteInstance().stopMRP((String)cellNumber.getValue(), (String)cellOrg.getValue());
        }
    }

    @Override
    public void actionShowDetailMRPRunLog_actionPerformed(ActionEvent e) throws Exception {
        super.actionView_actionPerformed(e);
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        super.tblMain_tableClicked(e);
    }

    protected void menuItemImportData_actionPerformed(ActionEvent e) throws Exception {
        super.menuItemImportData_actionPerformed(e);
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    public void actionSendMessage_actionPerformed(ActionEvent e) throws Exception {
        super.actionSendMessage_actionPerformed(e);
    }

    public void actionCalculator_actionPerformed(ActionEvent e) throws Exception {
        super.actionCalculator_actionPerformed(e);
    }

    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        super.actionExport_actionPerformed(e);
    }

    public void actionExportSelected_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportSelected_actionPerformed(e);
    }

    public void actionRegProduct_actionPerformed(ActionEvent e) throws Exception {
        super.actionRegProduct_actionPerformed(e);
    }

    public void actionPersonalSite_actionPerformed(ActionEvent e) throws Exception {
        super.actionPersonalSite_actionPerformed(e);
    }

    public void actionProcductVal_actionPerformed(ActionEvent e) throws Exception {
        super.actionProcductVal_actionPerformed(e);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
    }

    private String getSelectedPlanType() {
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        return this.tblMain.getRow(selectRows[0]).getCell("planType").toString();
    }

    public void initTableListner(KDTable table) {
        super.initTableListner(table);
        table.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                int[] selectRows = KDTableUtil.getSelectedRows((KDTable)MRPRunLogListUI.this.tblMain);
                if (selectRows.length == 1) {
                    String status;
                    MRPRunLogListUI.this.actionStop.setEnabled(true);
                    IRow row = KDTableUtil.getSelectedRow((KDTable)MRPRunLogListUI.this.tblMain);
                    ICell cellStatus = row.getCell("status");
                    String string = status = cellStatus.getValue() != null ? cellStatus.getValue().toString() : null;
                    if (!MRPRunLogStatusEnum.Running.getAlias(SysContext.getSysContext().getLocale()).equals(status)) {
                        MRPRunLogListUI.this.actionStop.setEnabled(false);
                    }
                } else {
                    MRPRunLogListUI.this.actionStop.setEnabled(false);
                }
            }
        });
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        super.actionView_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
    }

    protected ArrayList getSelectedIdValues() {
        ArrayList list = super.getSelectedIdValues();
        int rowCount = this.tblMain.getRowCount();
        MRPRunLogStatusEnum running = MRPRunLogStatusEnum.Running;
        block0: for (int i = list.size(); i > 0; --i) {
            for (int j = 0; j < rowCount; ++j) {
                ICell cellId = this.tblMain.getRow(j).getCell("id");
                if (!list.get(i - 1).toString().equals(cellId.getValue().toString())) continue;
                ICell cellStatus = this.tblMain.getRow(j).getCell("status");
                String strStatus = cellStatus.getValue().toString();
                if (!strStatus.equals(running.getAlias(SysContext.getSysContext().getLocale()))) continue block0;
                list.remove(i - 1);
                continue block0;
            }
        }
        return list;
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemove_actionPerformed(e);
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrintPreview_actionPerformed(e);
    }

    public void actionLocate_actionPerformed(ActionEvent e) throws Exception {
        super.actionLocate_actionPerformed(e);
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
    }

    public void actionImportData_actionPerformed(ActionEvent e) throws Exception {
        super.actionImportData_actionPerformed(e);
    }

    public void actionAttachment_actionPerformed(ActionEvent e) throws Exception {
        super.actionAttachment_actionPerformed(e);
    }

    public void actionExportData_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportData_actionPerformed(e);
    }

    public void actionToExcel_actionPerformed(ActionEvent e) throws Exception {
        super.actionToExcel_actionPerformed(e);
    }

    public void actionStartWorkFlow_actionPerformed(ActionEvent e) throws Exception {
        super.actionStartWorkFlow_actionPerformed(e);
    }

    public void actionPublishReport_actionPerformed(ActionEvent e) throws Exception {
        super.actionPublishReport_actionPerformed(e);
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancelCancel_actionPerformed(e);
    }

    public void actionQueryScheme_actionPerformed(ActionEvent e) throws Exception {
        super.actionQueryScheme_actionPerformed(e);
    }

    protected ICoreBase getBizInterface() throws Exception {
        return MRPRunLogFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return MrpRunLogDetailUI.class.getName();
    }

    protected FilterInfo getDefaultFilterForQuery() {
        return null;
    }

    public ActionManager getActionManager() {
        if (this.actionManager == null) {
            this.actionManager = new SCMActionManager((CoreUIObject)this, ContextTypeEnum.INQUERYING);
            this.actionManager.setTableSelectionHelper((ITableSelectionHelper)this.getTableSelectionHelper());
            this.actionManager.setServiceContext(this.getServiceContext());
        }
        return this.actionManager;
    }

    public void initBatchActions() throws BOSException {
        this.actionManager.setClzIBizFactory(ActionLevelEnum.HEAD, MRPRunLogFactory.class);
        this.getTableSelectionHelper().setTableProperty((CoreBillListUI)this, this.mainQueryPK, this.tblMain, "id", "desc", "number", "desc", "storageOrgUnit.id");
        ActionProxy actionProxy = ActionProxyFactory.createActionProxy((BatchActionEnum)BatchActionEnum.DELETE, (ItemAction)this.actionRemove, (String)"delete");
        this.actionManager.registerBatchAction(actionProxy, "actionRemove");
        actionProxy.bindTo((AbstractButton)this.btnRemove);
        actionProxy.bindTo((AbstractButton)this.menuItemRemove);
    }

    public TableSelectionHelper getTableSelectionHelper() {
        if (this.tableSelectionHelper == null) {
            this.tableSelectionHelper = new TableSelectionHelper((CoreBillListUI)this);
        }
        return this.tableSelectionHelper;
    }

    public void afterAction(BatchActionEnum bizAction, BatchSelectionEntries selectionEntries, int countSuccess) {
    }

    public boolean beforeAction(BatchActionEnum bizAction, BatchSelectionEntries selectionEntries, ActionEvent event) {
        return true;
    }

    public void doActionPerformed(BatchActionEnum bizAction, BatchSelectionEntries selectionEntry) {
    }

    public void handleBatchException(ActionProxy actionProxy, BatchSelectionEntries selectionEntry) throws Exception {
    }

    public boolean isSupportedBatchActions() {
        return true;
    }

    public void refresh(BatchActionEnum bizAction, BatchSelectionEntries selectionEntries, int countSuccess) throws Exception {
    }

    public Context getMainContext() {
        return this.getMainOrgContext();
    }
}

