/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.param.ParamItemInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.mm.common.client.MMRangeFilterElement;
import com.kingdee.eas.mm.common.client.MMUtils;
import com.kingdee.eas.mm.common.client.UIHelper;
import com.kingdee.eas.mm.planning.IRequirementPlanFacade;
import com.kingdee.eas.mm.planning.RequirementPlanFacadeFactory;
import com.kingdee.eas.mm.planning.RequirementTypeFactory;
import com.kingdee.eas.mm.planning.client.AbstractMoveToHisUI;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.scm.common.util.F7ContextManager;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import org.apache.log4j.Logger;

public class MoveToHisUI
extends AbstractMoveToHisUI {
    private static final Logger logger = CoreUIObject.getLogger(MoveToHisUI.class);
    private EntityViewInfo viewInfo = null;
    private F7ContextManager f7Manager = new F7ContextManager((Component)((Object)this), OrgType.Storage, 0);

    public void onLoad() throws Exception {
        super.onLoad();
        MMUtils.filterRangF7Helper((Component)this.prmtmaterialFrom, (Component)this.prmtmaterialTo);
        this.initConfirmButton();
        this.initCancelButton();
        this.initSpDay();
        this.registerMaterial();
    }

    private void registerMaterial() throws EASBizException, BOSException {
        this.prmtmaterialFrom.setDisplayFormat("$name$");
        this.prmtmaterialFrom.setEditFormat("$number$");
        this.prmtmaterialFrom.setCommitFormat("$number$");
        this.prmtmaterialTo.setDisplayFormat("$name$");
        this.prmtmaterialTo.setEditFormat("$number$");
        this.prmtmaterialTo.setCommitFormat("$number$");
        Map uiContext = this.getUIContext();
        if (uiContext.get("orgUnitID") != null) {
            String orgUintId = (String)uiContext.get("orgUnitID");
            StorageOrgUnitInfo orgInfo = StorageOrgUnitFactory.getRemoteInstance().getStorageOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgUintId));
            UIHelper.registerBizMaterialF7((F7ContextManager)this.f7Manager, (KDBizPromptBox)this.prmtmaterialFrom, (OrgUnitInfo)orgInfo);
            UIHelper.registerBizMaterialF7((F7ContextManager)this.f7Manager, (KDBizPromptBox)this.prmtmaterialTo, (OrgUnitInfo)orgInfo);
            this.viewInfo = this.prmtmaterialFrom.getEntityViewInfo();
            if (this.viewInfo == null) {
                this.viewInfo = new EntityViewInfo();
            }
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("StorageOrgUnit.id", (Object)orgUintId, CompareType.EQUALS));
            this.viewInfo.getFilter().mergeFilter(filter, "AND");
            this.prmtmaterialFrom.setEntityViewInfo(this.viewInfo);
            this.prmtmaterialTo.setEntityViewInfo(this.viewInfo);
        }
    }

    private void initReqType() {
        EntityViewInfo viewInfo = new EntityViewInfo();
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("id"));
        selectors.add(new SelectorItemInfo("name"));
        selectors.add(new SelectorItemInfo("number"));
        viewInfo.setSelector(selectors);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("name", (Object)"PIC", CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("name", (Object)"PID", CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("name", (Object)"SID", CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("name", (Object)"MTD", CompareType.EQUALS));
        filterInfo.setMaskString("#0 or #1 or #2 or #3");
        viewInfo.setFilter(filterInfo);
        Object[] reqTypes = null;
        try {
            CoreBaseCollection c = RequirementTypeFactory.getRemoteInstance().getCollection(viewInfo);
            reqTypes = c.toArray();
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        this.prmtreqType.setValue((Object)reqTypes);
    }

    private void initSpDay() {
        Map uiContext = this.getUIContext();
        String orgUintId = (String)uiContext.get("orgUnitID");
        int minReqPlanLen = 0;
        if (orgUintId != null) {
            try {
                IParamControl iParamControl = ParamControlFactory.getRemoteInstance();
                ParamItemInfo pm = iParamControl.getParamItemByNumberAndOrg("MinReqPlanLen", orgUintId);
                if (pm != null && pm.getValue() != null) {
                    minReqPlanLen = new Integer(pm.getValue());
                }
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
            catch (EASBizException e1) {
                this.handUIException(e1);
            }
        }
        int max = minReqPlanLen >= 100 ? minReqPlanLen + 10 : 100;
        SpinnerNumberModel dayLength = new SpinnerNumberModel(minReqPlanLen, minReqPlanLen, max, 1);
        this.spdays.setModel((SpinnerModel)dayLength);
    }

    private KDButton initConfirmButton() {
        this.btnConfirm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MoveToHisUI.this.confirmButton_actionPerformed(e);
            }
        });
        return this.btnConfirm;
    }

    private KDButton initCancelButton() {
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MoveToHisUI.this.cancelButton_actionPerformed(e);
            }
        });
        return this.btnConfirm;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    protected void confirmButton_actionPerformed(ActionEvent e) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add("*");
        viewInfo.getSelector().add("storageOrgUnit.id");
        viewInfo.getSelector().add("storageOrgUnit.number");
        viewInfo.getSelector().add("storageOrgUnit.name");
        viewInfo.getSelector().add("material.id");
        viewInfo.getSelector().add("material.number");
        viewInfo.getSelector().add("material.name");
        viewInfo.getSelector().add("unit.id");
        viewInfo.getSelector().add("unit.number");
        viewInfo.getSelector().add("unit.name");
        viewInfo.getSelector().add("baseUnit.id");
        viewInfo.getSelector().add("baseUnit.number");
        viewInfo.getSelector().add("baseUnit.name");
        viewInfo.getSelector().add("sourceSU.id");
        viewInfo.getSelector().add("sourceSU.number");
        viewInfo.getSelector().add("sourceSU.name");
        viewInfo.getSelector().add("manuStrategy.id");
        viewInfo.getSelector().add("manuStrategy.number");
        viewInfo.getSelector().add("manuStrategy.name");
        viewInfo.getSelector().add("reqType.id");
        viewInfo.getSelector().add("reqType.number");
        viewInfo.getSelector().add("reqType.name");
        CompositeFilterElement elements = new CompositeFilterElement(0);
        MMRangeFilterElement materialElement = new MMRangeFilterElement("material.number", (Component)this.prmtmaterialFrom, (Component)this.prmtmaterialTo);
        elements.add((FilterElement)materialElement);
        SingleFilterElement plannerElement = new SingleFilterElement("reqType.number", (Component)this.prmtreqType);
        elements.add((FilterElement)plannerElement);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(SCMClientUtils.getServerDate2());
        this.pkrequireDateTo.setValue((Object)new Timestamp(calendar.getTimeInMillis()));
        Integer days = (Integer)this.spdays.getValue();
        String strDays = "-" + days.toString();
        int intdays = new Integer(strDays);
        calendar.add(5, intdays);
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0);
        this.pkrequireDateFrom.setValue((Object)new Timestamp(calendar.getTimeInMillis()));
        SingleFilterElement reqDateElement = new SingleFilterElement("requireDate", (Component)this.pkrequireDateFrom);
        reqDateElement.setCompareType(CompareType.LESS_EQUALS);
        elements.add((FilterElement)reqDateElement);
        FilterInfo filter = elements.getFilterInfo();
        FilterInfo statusFilter = new FilterInfo();
        statusFilter.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(20), CompareType.EQUALS));
        try {
            filter.mergeFilter(statusFilter, "AND");
        }
        catch (BOSException e2) {
            this.handUIException(e2);
        }
        String tt = filter.toString();
        viewInfo.setFilter(filter);
        try {
            IRequirementPlanFacade iReqPlanFacade = RequirementPlanFacadeFactory.getRemoteInstance();
            iReqPlanFacade.moveToHis(viewInfo);
        }
        catch (Exception e1) {
            this.handleException(e1);
        }
        this.destroyWindow();
    }

    public void cancelButton_actionPerformed(ActionEvent e) {
        this.destroyWindow();
    }
}

