/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.extendcontrols.ext.IFilterInfoProducer;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.event.CommitEvent;
import com.kingdee.bos.ctrl.swing.event.CommitListener;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.SQLExecutor;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.license.LicenseException;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.permission.client.util.PermissionHelper;
import com.kingdee.eas.basedata.common.perf.CreateJobFacadeFactory;
import com.kingdee.eas.basedata.common.perf.ICreateJobFacade;
import com.kingdee.eas.basedata.common.perf.JobConfig;
import com.kingdee.eas.basedata.common.perf.JobParam;
import com.kingdee.eas.basedata.common.perf.client.JobMonitorManager;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialPlanInfo;
import com.kingdee.eas.basedata.master.material.UsedStatusEnum;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.NewOrgUnitFilterInfoProducer;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.mm.basedata.FactoryCalendarFactory;
import com.kingdee.eas.mm.basedata.FactoryCalendarInfo;
import com.kingdee.eas.mm.basedata.IPlanVersionSet;
import com.kingdee.eas.mm.basedata.MaterialRangeEnum;
import com.kingdee.eas.mm.basedata.PlanTypeEnum;
import com.kingdee.eas.mm.basedata.PlanVersionSetFactory;
import com.kingdee.eas.mm.basedata.PlanVersionSetInfo;
import com.kingdee.eas.mm.common.client.MMSpecialLicenseAdapter;
import com.kingdee.eas.mm.common.client.MMUtils;
import com.kingdee.eas.mm.common.client.UIHelper;
import com.kingdee.eas.mm.planning.IMRPCalcFacade;
import com.kingdee.eas.mm.planning.IMRPRunLog;
import com.kingdee.eas.mm.planning.IMpsGlobalPlanRunUserCond;
import com.kingdee.eas.mm.planning.MRPCalcFacadeFactory;
import com.kingdee.eas.mm.planning.MRPRunLogFactory;
import com.kingdee.eas.mm.planning.MRPRunLogInfo;
import com.kingdee.eas.mm.planning.MRPRunMaterialEntryCollection;
import com.kingdee.eas.mm.planning.MRPRunMaterialEntryInfo;
import com.kingdee.eas.mm.planning.MpsGlobalPlanRunUserCondCollection;
import com.kingdee.eas.mm.planning.MpsGlobalPlanRunUserCondFactory;
import com.kingdee.eas.mm.planning.MpsGlobalPlanRunUserCondInfo;
import com.kingdee.eas.mm.planning.MrpRunEnum;
import com.kingdee.eas.mm.planning.client.AbstractMpsGlobalPlanRunUI;
import com.kingdee.eas.mm.planning.client.BomCompletionConfirmBox;
import com.kingdee.eas.mm.planning.client.ProgressDialog;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.scm.common.loadmass.SCMEntryDataVO;
import com.kingdee.eas.scm.common.util.F7ContextManager;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.ComponentUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import javax.swing.Action;
import javax.swing.SwingUtilities;

public class MpsGlobalPlanRunUI
extends AbstractMpsGlobalPlanRunUI {
    protected boolean bIsMPSPlan = false;
    protected boolean bIsGlobalPlan = true;
    private boolean bIsSimulator = false;
    private boolean bIsContinuePrompted = false;
    protected String strPermissionItem;
    protected String strOpLog;
    public static final String strResource = "com.kingdee.eas.mm.planning.client.PlanningResource";
    protected MrpRunEnum mrpRunEnum = null;
    protected KDBizPromptBox bizMaterialBox = null;
    protected KDTEditListener kDTEditListener = null;
    protected ItemListener customMaterial = null;
    private boolean bIsSelectMaterial = false;
    private boolean bIsOutputLog = false;
    private static final String TB_Material_NUMBER = "materailNumber";
    private MMSpecialLicenseAdapter licenseAdapter = null;
    protected MpsGlobalPlanRunUserCondInfo mpsGPRUserCondInfo = null;

    public MpsGlobalPlanRunUI() throws Exception {
        this.matEntry.checkParsed();
    }

    public KDBizPromptBox getMainOrg() {
        return this.prmtStorageOrgUnit;
    }

    protected KDBizPromptBox getMainBizOrg() {
        return this.prmtStorageOrgUnit;
    }

    protected void setF7PlanVersion(StorageOrgUnitInfo sInfo) {
        String storageId = "";
        if (sInfo != null) {
            storageId = sInfo.getId().toString();
        }
        HashSet<String> planNumberSet = new HashSet<String>();
        HashSet<String> set = new HashSet<String>();
        planNumberSet.add("903");
        planNumberSet.add("902");
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(20), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("number", planNumberSet, CompareType.NOTINCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storageId, CompareType.EQUALS));
        if (this.bIsGlobalPlan) {
            set.add("901");
            set.add("900");
            filterInfo.getFilterItems().add(new FilterItemInfo("number", set, CompareType.INCLUDE));
        }
        viewInfo.setFilter(filterInfo);
        this.prmtPlanVersion.setEntityViewInfo(viewInfo);
        this.prmtPlanVersion.getQueryAgent().setDefaultFilterInfo(null);
        this.prmtPlanVersion.getQueryAgent().resetRuntimeEntityView();
    }

    protected boolean checkPlanVersionExist(PlanVersionSetInfo planVersion, String planVersionType) {
        boolean bRet = false;
        if (planVersion == null) {
            String prompt = planVersionType + EASResource.getString((String)strResource, (String)"MPS_MRP_PLANVERSION_NOT_EXIST");
            MsgBox.showError((Component)((Object)this), (String)prompt);
        } else {
            bRet = true;
        }
        return bRet;
    }

    protected void setMainBizOrgF7(KDBizPromptBox bizOrgUnitBox, OrgType orgType) {
        if (SysContext.getSysContext().getCurrentStorageUnit() != null) {
            NewOrgUnitFilterInfoProducer iProducer = new NewOrgUnitFilterInfoProducer(orgType);
            iProducer.getModel().setPermissionItem(this.strPermissionItem);
            bizOrgUnitBox.setFilterInfoProducer((IFilterInfoProducer)iProducer);
        }
    }

    public PlanVersionSetInfo getPlanVersionByNumber(String strNumber, String strStorageUnitId) throws BOSException {
        PlanVersionSetInfo planVersion = null;
        IPlanVersionSet ctrlEntity = PlanVersionSetFactory.getRemoteInstance();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)strNumber));
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(20), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)strStorageUnitId));
        view.setFilter(filter);
        CoreBaseCollection colEntity = ctrlEntity.getCollection(view);
        if (colEntity.size() > 0) {
            planVersion = (PlanVersionSetInfo)colEntity.get(0);
        }
        return planVersion;
    }

    public MRPRunLogInfo getMRPRunLog(String strCreatorId, PlanTypeEnum planType, CompareType planNumberCompare, String planNumber) throws BOSException {
        MRPRunLogInfo mrpLog = null;
        IMRPRunLog ctrlEntity = MRPRunLogFactory.getRemoteInstance();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("creator.id", (Object)strCreatorId));
        filter.getFilterItems().add(new FilterItemInfo("planVersion.PlanType", (Object)planType));
        filter.getFilterItems().add(new FilterItemInfo("planVersion.number", (Object)planNumber, planNumberCompare));
        view.setFilter(filter);
        SorterItemInfo sorter = new SorterItemInfo("startTime");
        sorter.setSortType(SortType.DESCEND);
        view.getSorter().add(sorter);
        view.setTopCount(1);
        CoreBaseCollection colEntity = ctrlEntity.getCollection(view);
        if (colEntity.size() > 0) {
            mrpLog = (MRPRunLogInfo)colEntity.get(0);
        }
        return mrpLog;
    }

    protected void setButtonAction(KDButton btn, ItemAction act) {
        btn.setAction((Action)act);
    }

    protected void initWithMenuParam(String strParam) throws NumberFormatException {
        int nParam = Integer.parseInt(strParam);
        switch (nParam) {
            case 1: {
                this.bIsMPSPlan = true;
                this.bIsGlobalPlan = true;
                this.setButtonAction(this.btnRunPlan, this.actionMpsPlanGlobal);
                this.strPermissionItem = "mm_mps_planGlobal_execution";
                this.mrpRunEnum = MrpRunEnum.MPS_GLOBAL;
                this.matEntry.getStyleAttributes().setHided(true);
                this.cbIsTransformPlannedOrder.setVisible(false);
                this.radioAllMaterial.setSelected(true);
                this.kDContainer1.setVisible(false);
                this.cbManageMRP.setVisible(true);
                break;
            }
            case 2: {
                this.bIsMPSPlan = true;
                this.bIsGlobalPlan = false;
                this.setButtonAction(this.btnRunPlan, this.actionMpsPlanSimulation);
                this.strPermissionItem = "mm_mps_planSimulation_execution";
                this.mrpRunEnum = MrpRunEnum.MPS_Simulator;
                this.radioCustomMaterial.setSelected(true);
                this.cbManageMRP.setVisible(true);
                this.bIsSimulator = true;
                break;
            }
            case 3: {
                this.bIsMPSPlan = false;
                this.bIsGlobalPlan = true;
                this.setButtonAction(this.btnRunPlan, this.actionMrpPlanGlobal);
                this.strPermissionItem = "mm_mrp_planGlobal_execution";
                this.mrpRunEnum = MrpRunEnum.MRP_GLOBAL;
                this.matEntry.getStyleAttributes().setHided(true);
                this.cbIsTransformPlannedOrder.setVisible(false);
                this.radioAllMaterial.setSelected(true);
                this.kDContainer1.setVisible(false);
                this.cbManageMRP.setVisible(false);
                break;
            }
            case 4: {
                this.bIsMPSPlan = false;
                this.bIsGlobalPlan = false;
                this.setButtonAction(this.btnRunPlan, this.actionMrpPlanSimulation);
                this.strPermissionItem = "mm_mrp_planSimulation_execution";
                this.mrpRunEnum = MrpRunEnum.MRP_Simulator;
                this.radioCustomMaterial.setSelected(true);
                this.cbManageMRP.setVisible(false);
                this.bIsSimulator = true;
                break;
            }
            case 7: {
                this.bIsMPSPlan = false;
                this.bIsGlobalPlan = false;
                this.setButtonAction(this.btnRunPlan, this.actionMrpMaterial);
                this.strPermissionItem = "mm_mrp_planChoiseMateial_execution";
                this.mrpRunEnum = MrpRunEnum.MRP_Material;
                this.radioCustomMaterial.setSelected(true);
                this.cbManageMRP.setVisible(false);
                this.cbIsTransformPlannedOrder.setVisible(false);
                this.bIsSelectMaterial = true;
                break;
            }
            case 6: {
                this.bIsMPSPlan = false;
                this.bIsGlobalPlan = false;
                this.setButtonAction(this.btnRunPlan, this.actionMpsMaterial);
                this.strPermissionItem = "mm_mps_planChoiseMateial_execution";
                this.mrpRunEnum = MrpRunEnum.MPS_Material;
                this.radioCustomMaterial.setSelected(true);
                this.cbManageMRP.setVisible(false);
                this.cbIsTransformPlannedOrder.setVisible(false);
                this.bIsSelectMaterial = true;
                break;
            }
            default: {
                MsgBox.showError((Component)((Object)this), (String)"error run parameter");
                this.abort();
            }
        }
    }

    protected void checkPermission(MRPRunLogInfo runLog) throws EASBizException, BOSException {
        PermissionHelper.checkFunctionPermission((IObjectPK)this.getUserPk(), (IObjectPK)new ObjectUuidPK(runLog.getStorageOrgUnit().getId()), (String)this.strPermissionItem);
    }

    private void checkSpecialLicense() {
        String fullName = "com.kingdee.eas.mm.planning.client.MpsGlobalPlanRunUI";
        if (this.mrpRunEnum.equals((Object)MrpRunEnum.MPS_GLOBAL)) {
            fullName = fullName + "_MPS_Global";
        } else if (this.mrpRunEnum.equals((Object)MrpRunEnum.MRP_GLOBAL)) {
            fullName = fullName + "_MRP_Global";
        } else if (this.mrpRunEnum.equals((Object)MrpRunEnum.MPS_Simulator)) {
            fullName = fullName + "_MPS_Simulation";
        } else if (this.mrpRunEnum.equals((Object)MrpRunEnum.MRP_Simulator)) {
            fullName = fullName + "_MRP_Simulation";
        } else if (this.mrpRunEnum.equals((Object)MrpRunEnum.MPS_Material)) {
            fullName = fullName + "_MPS_ChoiseMateial";
        } else if (this.mrpRunEnum.equals((Object)MrpRunEnum.MRP_Material)) {
            fullName = fullName + "_MRP_ChoiseMateial";
        }
        this.licenseAdapter = new MMSpecialLicenseAdapter(fullName, this.mrpRunEnum.getName().substring(0, 3));
        try {
            this.licenseAdapter.requestLicenseOrReleaseLicense(true, (IUIObject)this, this.mrpRunEnum.getAlias(this.getLocale()));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.abort();
        }
    }

    public boolean destroyWindow() {
        boolean b = super.destroyWindow();
        if (b && this.licenseAdapter != null) {
            try {
                this.licenseAdapter.requestLicenseOrReleaseLicense(false, (IUIObject)this, this.mrpRunEnum.getAlias(this.getLocale()));
            }
            catch (LicenseException e) {
                e.printStackTrace();
                this.abort();
            }
            catch (Exception e) {
                e.printStackTrace();
                this.abort();
            }
        }
        return b;
    }

    public void onLoad() throws Exception {
        MRPRunLogInfo info;
        StorageOrgUnitInfo orgInfo;
        String strParam = (String)this.getUIContext().get("UIClassParam");
        this.initWithMenuParam(strParam);
        this.checkSpecialLicense();
        super.onLoad();
        this.prmtPlanVersion.setEditable(true);
        this.setMainBizOrgF7(this.prmtStorageOrgUnit, OrgType.Storage);
        this.setF7PlanVersion(this.editData.getStorageOrgUnit());
        if (this.mrpRunEnum.equals((Object)MrpRunEnum.MPS_GLOBAL) && (orgInfo = (StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue()) != null) {
            String strStoreageOrgId = orgInfo.getId().toString();
            this.getMpsGlobalPlanRunUserCondInfo(strStoreageOrgId, this.mrpRunEnum);
            if (this.mpsGPRUserCondInfo.getId() != null) {
                this.loadMpsGlobalPlanRunUserCondInfo();
            }
        }
        this.checkPermission();
        this.setUI();
        this.initF7();
        this.addListeners();
        this.btnMaterialAddLine.setText(null);
        this.btnMatInsertLine.setText(null);
        this.btnMatDelLine.setText(null);
        this.matEntry.getActionMap().remove("Delete");
        this.matEntry.getActionMap().remove("Paste");
        this.matEntry.getActionMap().remove("Copy");
        this.matEntry.getActionMap().remove("Cut");
        if (this.bIsSelectMaterial && (info = this.getMRPRunLogInfo((PlanVersionSetInfo)this.prmtPlanVersion.getValue(), this.editData.getStorageOrgUnit())) != null) {
            this.editData.setPreRunLogId(info.getId().toString());
            info.setMateriaRange(MaterialRangeEnum.CUSTOM);
            this.setEntry(info);
        }
    }

    protected void setMaterialfilter(boolean isDuplicate) {
        HashSet set;
        HashSet<Integer> planningModeSet = new HashSet<Integer>();
        if (this.bIsMPSPlan) {
            planningModeSet.add(new Integer(2));
            if (this.cbManageMRP.isSelected()) {
                planningModeSet.add(new Integer(3));
            }
        } else {
            planningModeSet.add(new Integer(3));
        }
        if (this.mrpRunEnum.equals((Object)MrpRunEnum.MPS_Material)) {
            planningModeSet.clear();
            planningModeSet.add(new Integer(2));
        } else if (this.mrpRunEnum.equals((Object)MrpRunEnum.MRP_Material)) {
            planningModeSet.clear();
            planningModeSet.add(new Integer(3));
        }
        FilterInfo filterInfo = new FilterInfo();
        EntityViewInfo view = new EntityViewInfo();
        String sid = null;
        StorageOrgUnitInfo sInfo = (StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue();
        if (sInfo != null) {
            sid = sInfo.getId().toString();
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("StorageOrgUnit.id", (Object)sid, CompareType.EQUALS));
        if (!isDuplicate && (set = this.getTablefieldSet(this.matEntry, "materialID")) != null && set.size() > 0) {
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)set, CompareType.NOTINCLUDE));
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("plan.planningMode", planningModeSet, CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(2), CompareType.NOTEQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("plan.status", (Object)new Integer(2), CompareType.NOTEQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("Inventory.status", (Object)new Integer(2), CompareType.NOTEQUALS));
        view.setFilter(filterInfo);
        this.bizMaterialBox.setEntityViewInfo(view);
        this.bizMaterialBox.getQueryAgent().resetRuntimeEntityView();
    }

    protected HashSet getTablefieldSet(KDTable table, String colunm) {
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < table.getRowCount(); ++i) {
            if (table.getRow(i).getCell(colunm).getValue() == null) continue;
            String str = table.getRow(i).getCell(colunm).getValue().toString();
            set.add(str);
        }
        return set;
    }

    protected void setUI() throws Exception {
        String sPlanTitle;
        String sPlanVersion;
        this.setPreferredSize(new Dimension(580, 600));
        if (!this.mrpRunEnum.equals((Object)MrpRunEnum.MPS_Simulator) && !this.mrpRunEnum.equals((Object)MrpRunEnum.MRP_Simulator)) {
            this.kDPanel2.add((Component)this.cbAllowOverduePlanDate, (Object)new KDLayout.Constraints(20, 37, 220, 19, 261));
            this.kDPanel2.add((Component)this.cbManageMRP, (Object)new KDLayout.Constraints(280, 37, 220, 19, 137));
        }
        this.kDPanel3.add((Component)this.cbValidateBOM, (Object)new KDLayout.Constraints(20, 37, 220, 19, 261));
        this.kDPanel3.add((Component)this.cbReCalcLLC, (Object)new KDLayout.Constraints(280, 37, 220, 19, 137));
        StringBuffer sb = new StringBuffer();
        if (this.bIsGlobalPlan) {
            sPlanVersion = EASResource.getString((String)strResource, (String)"PLAN_GLOBAL");
            this.btnRunPlan.setBounds(new Rectangle(480, 315, 19, 100));
            this.add((Component)this.btnRunPlan, new KDLayout.Constraints(450, 315, 100, 19, 385));
            this.btnRunPlan.updateUI();
            this.repaint();
        } else {
            this.contPlanVersion.setVisible(true);
            sPlanVersion = EASResource.getString((String)strResource, (String)"PLAN_TRAIL");
        }
        if (this.bIsMPSPlan) {
            sb.append("MPS");
            sPlanTitle = EASResource.getString((String)strResource, (String)"MPS_PLAN_RUN_TITLE");
            this.cbManageMRP.setVisible(true);
        } else {
            sb.append("MRP");
            sPlanTitle = EASResource.getString((String)strResource, (String)"MRP_PLAN_RUN_TITLE");
        }
        sb.append(sPlanVersion);
        this.strOpLog = this.mrpRunEnum.getAlias(this.getLocale());
        this.setUITitle(sPlanTitle + "-" + sPlanVersion);
        MessageFormat format = BOSLocaleUtil.getMessageFormat((String)"{0}-{1}");
        if (this.mrpRunEnum.equals((Object)MrpRunEnum.MPS_Material)) {
            String name1 = format.format(new Object[]{EASResource.getString((String)strResource, (String)"MPS_PLAN_RUN_TITLE"), EASResource.getString((String)strResource, (String)"selectMateialPlan")});
            this.selectMaterailUI(name1);
        } else if (this.mrpRunEnum.equals((Object)MrpRunEnum.MRP_Material)) {
            String name1 = format.format(new Object[]{EASResource.getString((String)strResource, (String)"MRP_PLAN_RUN_TITLE"), EASResource.getString((String)strResource, (String)"selectMateialPlan")});
            this.selectMaterailUI(name1);
        }
    }

    private void selectMaterailUI(String name1) throws Exception {
        this.setUITitle(name1);
        this.kDLabelContainer1.setVisible(true);
        this.kDComboBox1.setSelectedIndex(0);
        this.radioAllMaterial.setVisible(false);
        this.radioPurMaterial.setVisible(false);
        this.radioCustomMaterial.setVisible(false);
        this.radioCustomMaterial.setSelected(true);
    }

    protected void writeOpLog(String strMethod, String strDetail) {
        IObjectPK pk = LogUtil.beginLog(null, (String)strMethod, (BOSObjectType)BOSObjectType.create((String)"F94043EF"), null, (String)strDetail);
        LogUtil.afterLog(null, (IObjectPK)pk);
    }

    @Override
    public void actionMrpPlanGlobal_actionPerformed(ActionEvent e) throws Exception {
        this.calcMpsMrpPlan();
    }

    @Override
    public void actionMrpPlanSimulation_actionPerformed(ActionEvent e) throws Exception {
        this.calcMpsMrpPlan();
    }

    @Override
    public void actionMpsPlanGlobal_actionPerformed(ActionEvent e) throws Exception {
        this.calcMpsMrpPlan();
    }

    @Override
    public void actionMpsPlanSimulation_actionPerformed(ActionEvent e) throws Exception {
        this.calcMpsMrpPlan();
    }

    @Override
    public void actionMrpMaterial_actionPerformed(ActionEvent e) throws Exception {
        this.calcMpsMrpPlan();
    }

    @Override
    public void actionMpsMaterial_actionPerformed(ActionEvent e) throws Exception {
        this.calcMpsMrpPlan();
    }

    protected boolean handleBomCheckAndReCalcLLC(Map rsMap, MRPRunLogInfo objRunLog) {
        int confirmResult;
        boolean bRet = true;
        Boolean isOutFactoryCalendar = (Boolean)rsMap.get("isOutFactoryCalendar");
        if (isOutFactoryCalendar.booleanValue() && 0 != (confirmResult = MsgBox.showConfirm2((String)EASResource.getString((String)strResource, (String)"HORIZONLENGTH_OUT_FACTORYCALENDAR")))) {
            return false;
        }
        Boolean isBomComplete = (Boolean)rsMap.get("isBomComplete");
        if (!isBomComplete.booleanValue()) {
            Window ownerWindow = ComponentUtil.getOwnerWindow(null);
            BomCompletionConfirmBox box = BomCompletionConfirmBox.createBomCompletionConfirmBox(ownerWindow, EASResource.getString((String)"promotInfoBox"), EASResource.getString((String)strResource, (String)"BOM_INCPMPLETE"), null, 3, 8190);
            box.setCtx(new UIContext((Object)this));
            StorageOrgUnitInfo storageOrgUnit = (StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue();
            box.setStorageOrgUnit(storageOrgUnit);
            box.setBomCompleteRs((IRowSet)rsMap.get("bomCompleteRs"));
            box.setNoMasterBomRs((IRowSet)rsMap.get("noMasterBomRs"));
            box.show();
            int confirmResult2 = box.getResult();
            if (0 != confirmResult2) {
                return false;
            }
        }
        Integer nVal = null;
        StringBuffer sbPrompt = new StringBuffer();
        Object obj = rsMap.get("ValidateBOM");
        if (obj != null) {
            nVal = (Integer)obj;
        }
        if (new Integer(10).equals(nVal)) {
            objRunLog.setBomNestingCheck(true);
            sbPrompt.append(EASResource.getString((String)strResource, (String)"MPS_MRP_RUN_BOM_NESTED_PROMPT")).append("\n");
        } else {
            objRunLog.setBomNestingCheck(false);
        }
        obj = rsMap.get("ReCalcLLC");
        if (obj != null) {
            nVal = (Integer)obj;
        }
        if (new Integer(1).equals(nVal)) {
            objRunLog.setIsCalculateLLC(false);
            sbPrompt.append(EASResource.getString((String)strResource, (String)"MPS_MRP_RUN_RECALC_LLC_FAIL_PROMPT"));
        } else {
            objRunLog.setIsCalculateLLC(true);
        }
        if (sbPrompt.length() > 0) {
            this.bIsContinuePrompted = true;
            int nYes = MsgBox.showConfirm2((String)sbPrompt.toString());
            if (0 != nYes) {
                bRet = false;
            }
        }
        return bRet;
    }

    protected void checkMaterial() {
        boolean isnull = true;
        if (this.matEntry.getRowCount() > 0) {
            for (int i = 0; i < this.matEntry.getRowCount(); ++i) {
                if (this.matEntry.getCell(i, TB_Material_NUMBER).getValue() == null) continue;
                isnull = false;
                break;
            }
        }
        if (isnull) {
            MsgBox.showInfo((String)EASResource.getString((String)strResource, (String)"materailNotNull"));
            this.abort();
        }
        if (this.matEntry.getRowCount() > 800) {
            MsgBox.showInfo((String)EASResource.getString((String)strResource, (String)"outOfLimit"));
            this.abort();
        }
    }

    protected void calcMpsMrpPlan() throws EASBizException, BOSException {
        FactoryCalendarInfo info;
        this.removeNullLines();
        this.storeFields();
        MRPRunLogInfo objRunLog = this.editData;
        objRunLog.setIsOutputLog(this.log.isSelected());
        this.bIsContinuePrompted = false;
        if (this.matEntry.getRowCount() <= 0 && this.radioCustomMaterial.isSelected()) {
            this.insertLine(0, this.createNewDetailData());
        }
        if (!this.checkPlanVersionExist(objRunLog.getPlanVersion(), "")) {
            return;
        }
        objRunLog.setRunName(this.mrpRunEnum);
        if (this.radioAllMaterial.isSelected()) {
            objRunLog.setMateriaRange(MaterialRangeEnum.ALL);
        } else if (this.radioPurMaterial.isSelected()) {
            objRunLog.setMateriaRange(MaterialRangeEnum.PUR);
        } else if (this.radioCustomMaterial.isSelected()) {
            objRunLog.setMateriaRange(MaterialRangeEnum.CUSTOM);
            this.checkMaterial();
        }
        StringBuffer sb = new StringBuffer();
        StorageOrgUnitInfo org = objRunLog.getStorageOrgUnit();
        if (org == null) {
            sb.append(EASResource.getString((String)strResource, (String)"MPS_MRP_RUN_NO_STORAGE_ORG")).append("\n");
        }
        if (org != null && (info = FactoryCalendarFactory.getRemoteInstance().getOrgUnitWorkCalendar(org.getId().toString(), objRunLog.getPlanDate(), objRunLog.getPlanDate())) == null) {
            sb.append(org.getName());
            sb.append(EASResource.getString((String)strResource, (String)"MPS_MRP_RUN_NO_PLAN_DATE"));
        }
        if (sb.length() > 0) {
            MsgBox.showError((String)sb.toString());
            return;
        }
        this.checkPermission(objRunLog);
        objRunLog.setStartTime(Calendar.getInstance().getTime());
        try {
            IMRPCalcFacade calcFacade = MRPCalcFacadeFactory.getRemoteInstance();
            Map rsMap = calcFacade.checkData(org.getId().toString(), objRunLog);
            if (this.handleBomCheckAndReCalcLLC(rsMap, objRunLog)) {
                boolean bRun = this.bIsContinuePrompted;
                if (!this.bIsContinuePrompted) {
                    bRun = true;
                }
                if (bRun) {
                    this.writeOpLog(this.strOpLog, this.strOpLog);
                    objRunLog.setId(BOSUuid.create((BOSObjectType)objRunLog.getBOSType()));
                    if (MrpRunEnum.MPS_GLOBAL.equals((Object)objRunLog.getRunName()) || MrpRunEnum.MRP_GLOBAL.equals((Object)objRunLog.getRunName()) || MrpRunEnum.MRP_Simulator.equals((Object)objRunLog.getRunName()) || MrpRunEnum.MPS_Simulator.equals((Object)objRunLog.getRunName())) {
                        Map result = this.executeJob(objRunLog);
                        if (result == null || Collections.EMPTY_MAP.equals(result)) {
                            calcFacade.backRun(objRunLog, false);
                        }
                    } else {
                        calcFacade.backRun(objRunLog, false);
                    }
                    if (MrpRunEnum.MPS_GLOBAL.equals((Object)this.mrpRunEnum)) {
                        this.saveMpsGlobalPlanRunUserCondInfo(this.mrpRunEnum);
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            MpsGlobalPlanRunUI.this.showProgressDialog();
                        }
                    });
                }
            }
        }
        catch (Exception e1) {
            this.handleException(e1);
        }
    }

    private Map executeJob(MRPRunLogInfo objRunLog) throws BOSException, EASBizException {
        int dbTypeInt = (Integer)SysContext.getSysContext().getProperty((Object)"dbType");
        String dbType = "";
        dbType = dbTypeInt == 2 ? "oracle" : (dbTypeInt == 1 ? "sqlserver" : "db2");
        Object[] params = new Object[]{objRunLog, Boolean.FALSE, dbType};
        JobParam jobParam = new JobParam((Object)params);
        jobParam.setLocale(SysContext.getSysContext().getLocale());
        JobConfig jobCfg = this.creteJobCfg(objRunLog);
        ICreateJobFacade jobFacade = CreateJobFacadeFactory.getRemoteInstance();
        Map result = jobFacade.executeJob(jobParam, jobCfg);
        if (result != null && result.get("jobInstExtId") != null) {
            JobMonitorManager.getInstance().addMonitorInfo((String)result.get("jobInstExtId"), jobCfg.getTitle());
        }
        return result;
    }

    private JobConfig creteJobCfg(MRPRunLogInfo objRunLog) {
        JobConfig jobCfg = new JobConfig();
        jobCfg.setTitle(this.getUITitle());
        jobCfg.setTaskType(objRunLog.getStorageOrgUnit().getNumber() + "MM_MRP_0001");
        jobCfg.setDescription(this.getUITitle());
        jobCfg.setNeedCheckTaskType(false);
        jobCfg.setNumber("MM_MRP_0001");
        jobCfg.setNeedCheckTaskType(true);
        return jobCfg;
    }

    protected void showProgressDialog() {
        ProgressDialog dialog = ProgressDialog.getDialogInstance(null);
        MRPRunLogInfo objRunLog = (MRPRunLogInfo)this.getDataObject();
        try {
            this.displayMRPRunLogListUI(objRunLog);
        }
        catch (Exception e1) {
            this.handleException(e1);
        }
    }

    protected IObjectPK getOrgPK(MRPRunLogInfo objLog) {
        ObjectUuidPK orgPK = null;
        if (objLog != null) {
            orgPK = new ObjectUuidPK(objLog.getStorageOrgUnit().getId().toString());
        }
        return orgPK;
    }

    protected void displayMRPRunLogListUI(MRPRunLogInfo objLog) throws EASBizException, UIException, BOSException, Exception {
        Object mrpLogUI = null;
        try {
            PermissionHelper.checkFunctionPermission((IObjectPK)this.getUserPk(), (IObjectPK)this.getOrgPK(objLog), (String)"mm_mps_plan_runlog_view");
            String uiClassName = "com.kingdee.eas.mm.planning.client.MrpRunLogDetailUI";
            UIContext ctx = new UIContext((Object)this);
            ctx.put((Object)"MrpRunLogDetailUI", (Object)"true");
            ctx.put((Object)"UIClassParam", (Object)"1");
            ctx.put((Object)"ID", (Object)objLog.getId().toString());
            ctx.put((Object)"ISCalUI", (Object)"ISCalUI");
            IUIWindow uiWindow = null;
            uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(uiClassName, (Map)ctx, null, OprtState.VIEW);
            this.actionExitCurrent_actionPerformed(null);
            uiWindow.show();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    protected IObjectValue createNewData() {
        StorageOrgUnitInfo orgUnit = (StorageOrgUnitInfo)MMUtils.getDefaultMainBizOrg((OrgType)OrgType.Storage, (String)this.strPermissionItem);
        PlanVersionSetInfo planVersionInfo = null;
        MRPRunLogInfo info = new MRPRunLogInfo();
        info.setBomCompleteCheck(false);
        info.setIsManageLLC(true);
        info.setIsCheckBOM(true);
        info.setStorageOrgUnit(orgUnit);
        info.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        if (orgUnit == null) {
            return info;
        }
        try {
            info.setPlanDate(MRPRunLogFactory.getRemoteInstance().getCurrentTime());
            planVersionInfo = !this.bIsMPSPlan && this.bIsGlobalPlan ? this.getPlanVersionByNumber("901", orgUnit.getId().toString()) : this.getPlanVersionByNumber("900", orgUnit.getId().toString());
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        if (this.bIsGlobalPlan) {
            info.setMateriaRange(MaterialRangeEnum.ALL);
            info.setPlanVersion(planVersionInfo);
        } else if (this.bIsSelectMaterial) {
            info.setPlanVersion(planVersionInfo);
        } else {
            info.setMateriaRange(MaterialRangeEnum.CUSTOM);
            info.getMaterialEntry().add(new MRPRunMaterialEntryInfo());
        }
        return info;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return MRPRunLogFactory.getRemoteInstance();
    }

    public OrgType getMainType() {
        return OrgType.Storage;
    }

    protected IObjectValue createNewDetailData() {
        return new MRPRunMaterialEntryInfo();
    }

    @Override
    public void actionMatAddLine_actionPerformed(ActionEvent e) throws Exception {
        this.addLine();
    }

    private void addLine() {
        IObjectValue detailData = this.createNewDetailData();
        if (detailData != null) {
            IRow row = this.matEntry.addRow();
            this.getUILifeCycleHandler().fireOnAddNewLine((Object)this.matEntry, detailData);
            this.dataBinder.setTablePropertyChange(true);
            this.dataBinder.loadLineFields(this.matEntry, row, detailData);
        }
    }

    @Override
    public void actionMatInsertLine_actionPerformed(ActionEvent e) throws Exception {
        IObjectValue detailData = this.createNewDetailData();
        IRow row = null;
        if (this.matEntry.getSelectManager().size() > 0) {
            int top = this.matEntry.getSelectManager().get().getTop();
            row = this.isTableColumnSelected(this.matEntry) ? this.matEntry.addRow() : this.matEntry.addRow(top);
        } else {
            row = this.matEntry.addRow();
        }
        this.dataBinder.setTablePropertyChange(true);
        this.getUILifeCycleHandler().fireOnAddNewLine((Object)this.matEntry, detailData);
        this.dataBinder.loadLineFields(this.matEntry, row, detailData);
    }

    @Override
    public void actionMatDelLine_actionPerformed(ActionEvent e) throws Exception {
        this.removeLine(this.matEntry);
    }

    protected void insertLine(int row, IObjectValue detailData) {
        IRow irow = null;
        irow = this.matEntry.addRow(row);
        this.dataBinder.loadLineFields(this.matEntry, irow, detailData);
    }

    protected void removeLine(KDTable table) {
        this.checkSelected();
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.matEntry);
        boolean isYes = MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Delete")));
        if (!isYes) {
            return;
        }
        for (int i = selectRows.length; i > 0; --i) {
            this.matEntry.removeRow(selectRows[i - 1]);
        }
    }

    public void checkSelected() {
        if (this.matEntry.getRowCount() == 0 || this.matEntry.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
    }

    protected boolean isTableColumnSelected(KDTable table) {
        KDTSelectBlock block;
        return table.getSelectManager().size() > 0 && ((block = table.getSelectManager().get()).getMode() == 4 || block.getMode() == 8);
    }

    protected void initF7() throws EASBizException, BOSException {
        ObjectValueRender avr = new ObjectValueRender();
        avr.setFormat((IDataFormat)new BizDataFormat("$number$"));
        this.bizMaterialBox = this.getBizMaterialF7(this.matEntry.getColumn(TB_Material_NUMBER));
        this.bizMaterialBox.addCommitListener(new CommitListener(){

            public void willCommit(CommitEvent e) {
                MpsGlobalPlanRunUI.this.setMaterialfilter(false);
            }
        });
        this.bizMaterialBox.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                MpsGlobalPlanRunUI.this.setMaterialfilter(true);
            }
        });
    }

    protected KDBizPromptBox getBizMaterialF7(IColumn col) throws EASBizException, BOSException {
        StorageOrgUnitInfo orgInfo = null;
        KDBizPromptBox bizMaterialBox = new KDBizPromptBox();
        Object sid = null;
        orgInfo = (StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue();
        F7ContextManager f7Manager = new F7ContextManager((Component)((Object)this), this.getMainBizOrgType());
        String materialPlanQuery = UIHelper.getMaterialPlanQuery((int)f7Manager.getF7DisplayMode());
        f7Manager.registerBizMaterialF7(bizMaterialBox, col, materialPlanQuery, (OrgUnitInfo)orgInfo, true);
        return bizMaterialBox;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    protected void addListeners() {
        this.bizMaterialBox.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    MpsGlobalPlanRunUI.this.materialDataChanged(e);
                }
                catch (Exception e1) {
                    MpsGlobalPlanRunUI.this.handUIException(e1);
                }
            }
        });
        this.matEntry.addKDTEditListener(this.kDTEditListener);
        this.cbManageMRP.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                MpsGlobalPlanRunUI.this.cbManageMRP(e);
            }
        });
        this.prmtStorageOrgUnit.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                MpsGlobalPlanRunUI.this.prmtStorageOrgUnitChanged(e);
            }
        });
        this.prmtPlanVersion.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                MpsGlobalPlanRunUI.this.prmtPlanVersionChanged(e);
            }
        });
        if (this.customMaterial == null) {
            this.customMaterial = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    MpsGlobalPlanRunUI.this.customMaterialChanged();
                }
            };
        }
        if (!this.bIsGlobalPlan) {
            this.radioCustomMaterial.addItemListener(this.customMaterial);
        }
    }

    private boolean ischeck() {
        boolean ischeck = false;
        for (int i = 0; i < this.matEntry.getRowCount(); ++i) {
            if (this.matEntry.getCell(i, TB_Material_NUMBER).getValue() == null) continue;
            return true;
        }
        return ischeck;
    }

    protected void customMaterialChanged() {
        if (!this.radioCustomMaterial.isSelected()) {
            boolean ischeck = this.ischeck();
            if (ischeck) {
                int isOk = MsgBox.showConfirm2((String)EASResource.getString((String)strResource, (String)"MRP_isDelete_material"));
                if (isOk == 2) {
                    this.radioCustomMaterial.setSelected(true);
                    this.abort();
                } else {
                    this.btnMaterialAddLine.setEnabled(false);
                    this.btnMatInsertLine.setEnabled(false);
                    this.btnMatDelLine.setEnabled(false);
                    this.matEntry.removeRows();
                }
            } else {
                this.btnMaterialAddLine.setEnabled(false);
                this.btnMatInsertLine.setEnabled(false);
                this.btnMatDelLine.setEnabled(false);
                this.matEntry.removeRows();
            }
        } else {
            if (this.matEntry.getRowCount() <= 0) {
                this.insertLine(0, this.createNewDetailData());
            }
            this.btnMaterialAddLine.setEnabled(true);
            this.btnMatInsertLine.setEnabled(true);
            this.btnMatDelLine.setEnabled(true);
        }
    }

    protected void prmtPlanVersionChanged(DataChangeEvent e) {
        PlanVersionSetInfo info = (PlanVersionSetInfo)e.getNewValue();
        this.editData.setPlanVersion(info);
        StorageOrgUnitInfo org = (StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue();
        MRPRunLogInfo logInfo = this.getMRPRunLogInfo(info, org);
        if (logInfo != null) {
            this.editData.setPreRunLogId(logInfo.getId().toString());
            if (this.bIsSimulator) {
                this.radioCustomMaterial.removeItemListener(this.customMaterial);
            }
            if (MaterialRangeEnum.ALL.equals((Object)logInfo.getMateriaRange())) {
                this.radioAllMaterial.setSelected(true);
                this.setMaterialRange(false);
            } else if (MaterialRangeEnum.PUR.equals((Object)logInfo.getMateriaRange())) {
                this.radioPurMaterial.setSelected(true);
                this.setMaterialRange(false);
            } else if (MaterialRangeEnum.CUSTOM.equals((Object)logInfo.getMateriaRange())) {
                this.radioCustomMaterial.setSelected(true);
                this.setMaterialRange(true);
            }
            if (this.bIsSimulator) {
                this.radioCustomMaterial.addItemListener(this.customMaterial);
            }
            this.setEntry(logInfo);
        } else if (this.bIsSimulator || this.bIsSelectMaterial) {
            this.radioCustomMaterial.setSelected(true);
            this.matEntry.removeRows();
            this.addLine();
        }
    }

    private MRPRunLogInfo getMRPRunLogInfo(PlanVersionSetInfo info, StorageOrgUnitInfo org) {
        MRPRunLogInfo logInfo = null;
        if (info != null && org != null) {
            try {
                StringBuffer select = new StringBuffer();
                select.append("select top 1 fid from T_MM_MRPRunLog where ");
                select.append(" fStorageorgunitid ='").append(org.getId().toString()).append("'");
                select.append(" and fplanVersionid='").append(info.getId().toString()).append("'");
                select.append(" and frunName=").append(this.mrpRunEnum.getValue()).append("");
                select.append(" order by fstartTime desc");
                SQLExecutor se = new SQLExecutor(null, select.toString());
                IRowSet result = se.executeSQL();
                if (result.next()) {
                    String id = result.getString("fid");
                    SelectorItemCollection sic = new SelectorItemCollection();
                    sic.add(new SelectorItemInfo("id"));
                    sic.add(new SelectorItemInfo("number"));
                    sic.add(new SelectorItemInfo("isContainsMRPMaterial"));
                    sic.add(new SelectorItemInfo("materiaRange"));
                    sic.add(new SelectorItemInfo("materialEntry.material.id"));
                    sic.add(new SelectorItemInfo("materialEntry.material.name"));
                    sic.add(new SelectorItemInfo("materialEntry.material.number"));
                    sic.add(new SelectorItemInfo("materialEntry.material.model"));
                    sic.add(new SelectorItemInfo("materialEntry.material.status"));
                    sic.add(new SelectorItemInfo("materialEntry.materialPlan.id"));
                    sic.add(new SelectorItemInfo("materialEntry.materialPlan.materialAttr"));
                    sic.add(new SelectorItemInfo("materialEntry.materialPlan.planningMode"));
                    logInfo = (MRPRunLogInfo)MRPRunLogFactory.getRemoteInstance().getValue((IObjectPK)new ObjectUuidPK(id), sic);
                }
            }
            catch (SQLException e) {
                this.handUIException(e);
            }
            catch (EASBizException e) {
                this.handUIException(e);
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        }
        return logInfo;
    }

    private void setMaterialRange(boolean enable) {
        this.btnMaterialAddLine.setEnabled(enable);
        this.btnMatInsertLine.setEnabled(enable);
        this.btnMatDelLine.setEnabled(enable);
    }

    protected void setEntry(MRPRunLogInfo logInfo) {
        MRPRunMaterialEntryCollection entry = logInfo.getMaterialEntry();
        MRPRunMaterialEntryInfo info = null;
        MaterialRangeEnum materilRange = logInfo.getMateriaRange();
        this.matEntry.removeRows();
        if (MaterialRangeEnum.ALL.equals((Object)materilRange)) {
            this.radioAllMaterial.setSelected(true);
        } else if (MaterialRangeEnum.PUR.equals((Object)materilRange)) {
            this.radioPurMaterial.setSelected(true);
        } else if (MaterialRangeEnum.CUSTOM.equals((Object)logInfo.getMateriaRange())) {
            this.radioCustomMaterial.setSelected(true);
            boolean isMRP = this.cbManageMRP.isSelected();
            for (int i = 0; i < entry.size(); ++i) {
                info = entry.get(i);
                IRow row = this.matEntry.addRow();
                this.afterDataChanged(row, info.getMaterial(), info.getMaterialPlan());
            }
            if (!isMRP && (MrpRunEnum.MPS_Material.equals((Object)this.mrpRunEnum) || MrpRunEnum.MPS_Simulator.equals((Object)this.mrpRunEnum))) {
                this.removeMaterialByPlanType("MRP");
            }
            if (MrpRunEnum.MRP_Material.equals((Object)this.mrpRunEnum) || MrpRunEnum.MRP_Simulator.equals((Object)this.mrpRunEnum)) {
                this.removeMaterialByPlanType("MPS");
            }
        }
    }

    protected void removeNullLines() {
        for (int i = this.matEntry.getRowCount() - 1; i >= 0; --i) {
            if (this.matEntry.getCell(i, TB_Material_NUMBER).getValue() != null) continue;
            this.matEntry.removeRow(i);
        }
    }

    protected void removeMaterialByPlanType(String materialPlanType) {
        String plantype = null;
        for (int i = this.matEntry.getRowCount() - 1; i >= 0; --i) {
            if (this.matEntry.getCell(i, "plantype").getValue() == null || !materialPlanType.equalsIgnoreCase(plantype = this.matEntry.getCell(i, "plantype").getValue().toString())) continue;
            this.matEntry.removeRow(i);
        }
        if (this.matEntry.getRowCount() == 0 && this.radioCustomMaterial.isSelected()) {
            this.matEntry.addRow();
        }
    }

    protected void cbManageMRP(ItemEvent e) {
        if (!this.cbManageMRP.isSelected()) {
            this.removeMaterialByPlanType("MRP");
        }
    }

    protected void prmtStorageOrgUnitChanged(DataChangeEvent e) {
        StorageOrgUnitInfo org = (StorageOrgUnitInfo)e.getNewValue();
        boolean isDiffrent = SCMGroupClientUtils.isDiffrent((Object)e.getNewValue(), (Object)e.getOldValue());
        String storageId = null;
        if (org != null && isDiffrent) {
            storageId = org.getId().toString();
            if (this.bIsGlobalPlan) {
                try {
                    this.prmtPlanVersion.setValue((Object)this.getPlanVersionByNumber("900", storageId));
                }
                catch (BOSException e1) {
                    this.handUIException(e1);
                }
            } else {
                this.prmtPlanVersion.setValue(null);
                this.matEntry.removeRows();
                if (this.radioCustomMaterial.isSelected()) {
                    this.insertLine(0, this.createNewDetailData());
                }
            }
        } else {
            if (isDiffrent) {
                this.prmtPlanVersion.setValue(null);
            }
            this.matEntry.removeRows();
            if (this.radioCustomMaterial.isSelected()) {
                this.insertLine(0, this.createNewDetailData());
            }
        }
        this.setF7PlanVersion(org);
        if (this.bIsGlobalPlan && isDiffrent) {
            try {
                this.getMpsGlobalPlanRunUserCondInfo(storageId, MrpRunEnum.MPS_GLOBAL);
                this.loadMpsGlobalPlanRunUserCondInfo();
            }
            catch (BOSException e1) {
                this.handUIException(e1);
            }
        }
    }

    protected void materialDataChanged(DataChangeEvent e) throws Exception {
        HashSet set = this.getTablefieldSet(this.matEntry, "materialID");
        Object newValue = e.getNewValue();
        IRow curRow = this.matEntry.getRow(this.matEntry.getSelectManager().getActiveRowIndex());
        if (newValue == null) {
            this.clear(curRow);
        } else if (newValue instanceof Object[]) {
            int i;
            Object[] value = (Object[])newValue;
            ArrayList<Object> mas = new ArrayList<Object>();
            for (i = 0; i < value.length; ++i) {
                mas.add(value[i]);
            }
            for (i = mas.size() - 1; i >= 0; --i) {
                MaterialInfo ma = (MaterialInfo)mas.get(i);
                if (!set.contains(ma.getId().toString())) continue;
                mas.remove(ma);
            }
            if (mas.size() == 0) {
                e.setNewValue(null);
                curRow.getCell(TB_Material_NUMBER).setValue((Object)new MaterialInfo());
                for (i = 0; i < this.matEntry.getRowCount(); ++i) {
                    if (this.matEntry.getRow(i).getCell("materialID").getValue() != null) continue;
                    this.matEntry.getRow(i).getCell(TB_Material_NUMBER).setValue(null);
                }
                return;
            }
            value = mas.toArray();
            this.doDataChanged(value);
        }
    }

    protected void clear(IRow row) {
        row.getCell("materailName").setValue(null);
        row.getCell("materailModel").setValue(null);
        row.getCell("plantype").setValue(null);
        row.getCell("materailAttr").setValue(null);
        row.getCell("materialID").setValue(null);
        row.getCell(TB_Material_NUMBER).setValue(null);
        row.getCell("materialPlan").setValue(null);
    }

    protected void doDataChanged(Object[] infos) throws Exception {
        HashSet set = this.getTablefieldSet(this.matEntry, "materialID");
        KDTSelectBlock ksb = this.matEntry.getSelectManager().get();
        int beginRow = ksb.getBeginRow();
        IRow curRow = this.matEntry.getRow(beginRow);
        int curCol = this.matEntry.getColumnIndex(TB_Material_NUMBER);
        Object material = new Object();
        MaterialPlanInfo materialPlan = new MaterialPlanInfo();
        if (infos == null) {
            return;
        }
        MaterialInfo[] materialInfos = new MaterialInfo[infos.length];
        System.arraycopy(infos, 0, materialInfos, 0, infos.length);
        StorageOrgUnitInfo sInfo = (StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue();
        SCMEntryDataVO voResult = UIHelper.getDataVO((StorageOrgUnitInfo)sInfo, (MaterialInfo[])materialInfos);
        int length = infos.length;
        if (length > 0) {
            IRow curRow2 = null;
            boolean needInsert = false;
            int insertedRowCount = 0;
            for (int i = 0; i < length; ++i) {
                material = infos[i];
                if (needInsert && infos[i] != null) {
                    if (set.contains(((MaterialInfo)material).getId().toString())) continue;
                    this.insertLine(beginRow + insertedRowCount, this.createNewDetailData());
                    needInsert = false;
                }
                String key = materialInfos[i].getId().toString() + sInfo.getId().toString();
                materialPlan = (MaterialPlanInfo)voResult.getMaterialPlanInfos().get(key);
                curRow2 = insertedRowCount != 0 ? this.matEntry.getRow(beginRow + insertedRowCount) : curRow;
                if (infos[i] == null) continue;
                curRow2.getCell(curCol).setValue(null);
                this.bizMaterialBox.commitEdit();
                if (set.contains(((MaterialInfo)material).getId().toString())) continue;
                try {
                    curRow2.getCell(curCol).setValue(material);
                    this.afterDataChanged(curRow2, material, materialPlan);
                }
                catch (Exception ex) {
                    curRow2.getCell(curCol).setValue(material);
                    curRow2.getCell(curCol).setValue(null);
                    continue;
                }
                ++insertedRowCount;
                needInsert = true;
            }
        } else {
            curRow.getCell(curCol).setValue(null);
        }
    }

    protected void afterDataChanged(IRow row, Object material, MaterialPlanInfo materialPlan) {
        MaterialInfo materialInfo = (MaterialInfo)material;
        if (!UsedStatusEnum.DELETED.equals((Object)materialInfo.getStatus())) {
            row.getCell("materailName").setValue((Object)materialInfo.getName());
            row.getCell("materailModel").setValue((Object)materialInfo.getModel());
            row.getCell("plantype").setValue((Object)materialPlan.getPlanningMode());
            row.getCell("materailAttr").setValue((Object)materialPlan.getMaterialAttr());
            row.getCell("materialID").setValue((Object)materialInfo.getId());
            row.getCell(TB_Material_NUMBER).setValue((Object)materialInfo);
            row.getCell("materialPlan").setValue((Object)materialPlan);
        }
    }

    public boolean isModify() {
        return false;
    }

    private void checkPermission() throws EASBizException, BOSException {
        if (this.mrpRunEnum.equals((Object)MrpRunEnum.MPS_GLOBAL)) {
            PermissionHelper.checkFunctionPermission((IObjectPK)this.getUserPk(), (IObjectPK)this.getOrgPK(this.actionMpsPlanGlobal), (String)"mm_mps_planGlobal_execution");
        }
        if (this.mrpRunEnum.equals((Object)MrpRunEnum.MRP_GLOBAL)) {
            PermissionHelper.checkFunctionPermission((IObjectPK)this.getUserPk(), (IObjectPK)this.getOrgPK(this.actionMrpPlanGlobal), (String)"mm_mrp_planGlobal_execution");
        }
        if (this.mrpRunEnum.equals((Object)MrpRunEnum.MPS_Simulator)) {
            PermissionHelper.checkFunctionPermission((IObjectPK)this.getUserPk(), (IObjectPK)this.getOrgPK(this.actionMpsPlanSimulation), (String)"mm_mps_planSimulation_execution");
        }
        if (this.mrpRunEnum.equals((Object)MrpRunEnum.MRP_Simulator)) {
            PermissionHelper.checkFunctionPermission((IObjectPK)this.getUserPk(), (IObjectPK)this.getOrgPK(this.actionMrpPlanSimulation), (String)"mm_mrp_planSimulation_execution");
        }
        if (this.mrpRunEnum.equals((Object)MrpRunEnum.MPS_Material)) {
            PermissionHelper.checkFunctionPermission((IObjectPK)this.getUserPk(), (IObjectPK)this.getOrgPK(this.actionMpsMaterial), (String)"mm_mps_planChoiseMateial_execution");
        }
        if (this.mrpRunEnum.equals((Object)MrpRunEnum.MRP_Material)) {
            PermissionHelper.checkFunctionPermission((IObjectPK)this.getUserPk(), (IObjectPK)this.getOrgPK(this.actionMrpMaterial), (String)"mm_mrp_planChoiseMateial_execution");
        }
    }

    private void getMpsGlobalPlanRunUserCondInfo(String strStorageOrgId, MrpRunEnum runEnum) throws BOSException {
        if (strStorageOrgId != null) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
            FilterItemInfo itemInfoorg = new FilterItemInfo("storageOrgUnit.id", (Object)strStorageOrgId, CompareType.EQUALS);
            FilterItemInfo itemInfo = new FilterItemInfo("creator.id", (Object)userId, CompareType.EQUALS);
            FilterItemInfo itemInfo1 = new FilterItemInfo("runName", (Object)runEnum.getValue(), CompareType.EQUALS);
            filter.getFilterItems().add(itemInfoorg);
            filter.getFilterItems().add(itemInfo);
            filter.getFilterItems().add(itemInfo1);
            filter.setMaskString("#0 and #1 and #2");
            view.setFilter(filter);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("storageOrgUnit.number"));
            sic.add(new SelectorItemInfo("storageOrgUnit.name"));
            sic.add(new SelectorItemInfo("storageOrgUnit.name"));
            sic.add(new SelectorItemInfo("storageOrgUnit.CU.id"));
            sic.add(new SelectorItemInfo("planVersionSet.number"));
            sic.add(new SelectorItemInfo("planVersionSet.name"));
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("isAllowOverduePlanDate"));
            sic.add(new SelectorItemInfo("isManageMRP"));
            sic.add(new SelectorItemInfo("isValidateBOM"));
            sic.add(new SelectorItemInfo("isReCalcLLC"));
            view.setSelector(sic);
            MpsGlobalPlanRunUserCondCollection mpsColl = MpsGlobalPlanRunUserCondFactory.getRemoteInstance().getMpsGlobalPlanRunUserCondCollection(view);
            if (mpsColl.size() > 0) {
                this.mpsGPRUserCondInfo = mpsColl.get(0);
            } else {
                this.mpsGPRUserCondInfo = new MpsGlobalPlanRunUserCondInfo();
                this.mpsGPRUserCondInfo.setIsValidateBOM(true);
                this.mpsGPRUserCondInfo.setIsReCalcLLC(true);
            }
        }
    }

    protected void loadMpsGlobalPlanRunUserCondInfo() {
        this.prmtPlanVersion.setValue((Object)this.mpsGPRUserCondInfo.getPlanVersionSet());
        this.cbAllowOverduePlanDate.setSelected(this.mpsGPRUserCondInfo.isIsAllowOverduePlanDate());
        this.cbManageMRP.setSelected(this.mpsGPRUserCondInfo.isIsManageMRP());
        this.cbReCalcLLC.setSelected(this.mpsGPRUserCondInfo.isIsReCalcLLC());
        this.cbValidateBOM.setSelected(this.mpsGPRUserCondInfo.isIsValidateBOM());
    }

    protected void saveMpsGlobalPlanRunUserCondInfo(MrpRunEnum runEnum) throws BOSException, EASBizException {
        this.mpsGPRUserCondInfo.setStorageOrgUnit((StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue());
        this.mpsGPRUserCondInfo.setPlanVersionSet((PlanVersionSetInfo)this.prmtPlanVersion.getValue());
        this.mpsGPRUserCondInfo.setIsAllowOverduePlanDate(this.cbAllowOverduePlanDate.isSelected());
        this.mpsGPRUserCondInfo.setIsManageMRP(this.cbManageMRP.isSelected());
        this.mpsGPRUserCondInfo.setIsReCalcLLC(this.cbReCalcLLC.isSelected());
        this.mpsGPRUserCondInfo.setIsValidateBOM(this.cbValidateBOM.isSelected());
        this.mpsGPRUserCondInfo.setRunName(runEnum);
        IMpsGlobalPlanRunUserCond factory = MpsGlobalPlanRunUserCondFactory.getRemoteInstance();
        factory.save((CoreBaseInfo)this.mpsGPRUserCondInfo);
    }
}

