/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.DefaultNoteDataProvider;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.reportone.r1.print.data.AbstractPrintDataProvider;
import com.kingdee.bos.ctrl.reportone.r1.print.data.R1PrintDataSource;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPKFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.base.permission.client.longtime.LongTimeDialog;
import com.kingdee.eas.base.permission.client.util.PermissionHelper;
import com.kingdee.eas.base.permission.client.util.UITools;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.mm.basedata.MaterialRangeEnum;
import com.kingdee.eas.mm.common.client.tableutils.resize.KDTAutoResizeManager;
import com.kingdee.eas.mm.planning.IMRPCalcFacade;
import com.kingdee.eas.mm.planning.IMRPRunLog;
import com.kingdee.eas.mm.planning.MRPCalcFacadeFactory;
import com.kingdee.eas.mm.planning.MRPRunLogCollection;
import com.kingdee.eas.mm.planning.MRPRunLogFactory;
import com.kingdee.eas.mm.planning.MRPRunLogInfo;
import com.kingdee.eas.mm.planning.MRPRunLogStatusEnum;
import com.kingdee.eas.mm.planning.MRPRunStepLogCollection;
import com.kingdee.eas.mm.planning.MRPRunStepLogInfo;
import com.kingdee.eas.mm.planning.MRPStepStatusEnum;
import com.kingdee.eas.mm.planning.MrpRunEnum;
import com.kingdee.eas.mm.planning.PlanningConst;
import com.kingdee.eas.mm.planning.client.AbstractMrpRunLogDetailUI;
import com.kingdee.eas.mm.planning.client.MRPLogMaterialUI;
import com.kingdee.eas.mm.report.client.PlanerWorkPlatformTotalUI;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.Timer;
import org.apache.log4j.Logger;

public class MrpRunLogDetailUI
extends AbstractMrpRunLogDetailUI {
    private static final Logger logger = CoreUIObject.getLogger(MrpRunLogDetailUI.class);
    private Timer timer;
    public static final String strResource = "com.kingdee.eas.mm.planning.client.PlanningResource.";
    public static final String UICONTEXT_KEY_BE_JOINQUERY = "com.kingdee.eas.base.report.client.ReportViewerUI#UICONTEXT_KEY_BE_JOINQUERY";
    public static final String UICONTEXT_KEY_JOINQUERY_PARAMS = "com.kingdee.eas.base.report.client.ReportViewerUI#UICONTEXT_KEY_JOINQUERY_PARAMS";
    public static final String UICONTEXT_KEY_JOINQUERY_DATA = "com.kingdee.eas.base.report.client.ReportViewerUI#UICONTEXT_KEY_JOINQUERY_DATA";
    public static final String REPORTVIEW_EXP_ID = "de8ada12-2c61-a466-49f9-f0bfdb5a2133mrp09031";
    IUIWindow uiWindow = null;
    protected boolean isForme = false;
    private boolean isFinished = false;
    private boolean isFromMultiOrgPlan = false;

    public MrpRunLogDetailUI() throws Exception {
        this.kdtDetail.checkParsed();
    }

    public void onLoad() throws Exception {
        String isCalUI = (String)this.getUIContext().get("ISCalUI");
        if (isCalUI != null && isCalUI.equals("ISCalUI")) {
            String strId = (String)this.getUIContext().get("ID");
            IMRPRunLog logFac = MRPRunLogFactory.getRemoteInstance();
            FilterInfo filter = new FilterInfo();
            filter.appendFilterItem("id", (Object)strId);
            boolean isexist = logFac.exists(filter);
            int count = 0;
            while (!isexist) {
                isexist = logFac.exists(filter);
                long timeout = 1000L;
                Thread.sleep(timeout);
                if (++count < 100) continue;
                break;
            }
        }
        super.onLoad();
        this.AdjustDisplay();
        this.btnStop.setIcon(EASResource.getIcon((String)"imgTbtn_forbid"));
        this.menuItemStop.setIcon(EASResource.getIcon((String)"imgTbtn_forbid"));
        this.kDWorkButtonWorkPlat.setIcon(EASResource.getIcon((String)"imgTbtn_demandcollateresult"));
        this.kDMenuItemWorkPlat.setIcon(EASResource.getIcon((String)"imgTbtn_demandcollateresult"));
        this.menuItemGetLog.setIcon(EASResource.getIcon((String)"imgTbtn_output"));
        if (this.getUIContext().get("isFromMultiOrgPlan") != null) {
            this.isFromMultiOrgPlan = (Boolean)this.getUIContext().get("isFromMultiOrgPlan");
            if (this.isFromMultiOrgPlan) {
                this.btnNext.setEnabled(false);
                this.btnNext.setVisible(false);
                this.btnPre.setEnabled(false);
                this.btnPre.setVisible(false);
                this.btnLast.setEnabled(false);
                this.btnLast.setVisible(false);
                this.btnFirst.setEnabled(false);
                this.btnFirst.setVisible(false);
                this.menuItemNext.setEnabled(false);
                this.menuItemNext.setVisible(false);
                this.menuItemPre.setEnabled(false);
                this.menuItemPre.setVisible(false);
                this.menuItemLast.setEnabled(false);
                this.menuItemLast.setVisible(false);
                this.menuItemFirst.setEnabled(false);
                this.menuItemFirst.setVisible(false);
            }
        }
        this.txtTotalMaterals.setHorizontalAlignment(4);
        this.txtNumOfexceptionMaterials.setHorizontalAlignment(4);
        this.txtNumOflowerSafeStockMtl.setHorizontalAlignment(4);
        this.txtTotalPlanOrders.setHorizontalAlignment(4);
        this.txtDuration.setHorizontalAlignment(4);
        this.kdtDetail.getSelectManager().setSelectMode(2);
        this.kdtDetail.getActionMap().remove("Delete");
        this.kdtDetail.getColumn("dataAmount").getStyleAttributes().setNumberFormat(SCMClientUtils.getFormatPattern((int)0, (boolean)true));
        KDTAutoResizeManager.register((KDTable)this.kdtDetail);
        final MrpRunLogDetailUI thisUI = this;
        this.timer = new Timer(5000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    if (thisUI.isVisible()) {
                        MrpRunLogDetailUI.this.refreshProgress();
                    }
                }
                catch (Exception e1) {
                    MrpRunLogDetailUI.this.handleException(e1);
                }
            }
        });
        this.timer.start();
    }

    public void refreshProgress() throws Exception {
        this.kDProgressBar1.setMinimum(0);
        int rowCount = this.kdtDetail.getRowCount();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        SorterItemCollection sorts = new SorterItemCollection();
        sorts.add(new SorterItemInfo("stepEntries.seq"));
        view.setSorter(sorts);
        view.setSelector(this.getSelectors());
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)this.editData.getId().toString()));
        view.setFilter(filterInfo);
        MRPRunLogCollection logs = MRPRunLogFactory.getRemoteInstance().getMRPRunLogCollection(view);
        MRPRunStepLogCollection logEntrys = null;
        if (logs != null && logs.size() != 0) {
            MRPRunLogInfo logInfo = logs.get(0);
            int status = logInfo.getStatus().getValue();
            this.isFinished = status == 20 || status == 10;
            logEntrys = logInfo.getStepEntries();
        }
        this.refreshProcessBar(logEntrys);
        if (this.isFinished) {
            if ((IObjectValue)this.getUIContext().get("InitDataObject") != null) {
                this.setDataObject((IObjectValue)this.getUIContext().get("InitDataObject"));
            } else {
                this.setDataObject(this.getValue((IObjectPK)new ObjectUuidPK(this.editData.getId())));
            }
            this.loadFields();
            this.initOldData((IObjectValue)this.editData);
            this.AdjustDisplay();
            this.timer.stop();
            return;
        }
        ArrayList<MRPRunStepLogInfo> insertLogs = new ArrayList<MRPRunStepLogInfo>();
        int rowIndex = 0;
        for (int i = 0; i < logEntrys.size(); ++i) {
            MRPRunStepLogInfo log = logEntrys.get(i);
            boolean hasLog = true;
            for (int j = 0; j < rowCount; ++j) {
                String step = (String)this.kdtDetail.getRow(j).getCell("stepNum").getValue();
                MRPStepStatusEnum status = (MRPStepStatusEnum)((Object)this.kdtDetail.getRow(j).getCell("status").getValue());
                Integer seq = (Integer)this.kdtDetail.getRow(j).getCell("seq").getValue();
                if (seq < log.getSeq()) {
                    rowIndex = j - 1;
                }
                if (log.getStepNum().equals(step)) {
                    hasLog = true;
                    if (MRPStepStatusEnum.ERROR_STOP.equals((Object)status) || MRPStepStatusEnum.FINISHED.equals((Object)status)) break;
                    this.kdtDetail.getRow(j).getCell("status").setValue((Object)log.getStatus());
                    this.kdtDetail.getRow(j).getCell("time").setValue((Object)log.getTime());
                    this.kdtDetail.getRow(j).getCell("exception").setValue((Object)log.getException());
                    this.kdtDetail.getRow(j).getCell("status").setRenderer((IBasicRender)new IconRender());
                    this.kdtDetail.getRow(j).getCell("dataAmount").getStyleAttributes().setNumberFormat(SCMClientUtils.getFormatPattern((int)0, (boolean)true));
                    this.kdtDetail.getRow(j).getCell("dataAmount").setValue((Object)log.getDataAmount());
                    break;
                }
                hasLog = false;
            }
            if (hasLog) continue;
            insertLogs.add(log);
        }
        IRow row = null;
        for (int i = 0; i < insertLogs.size(); ++i) {
            MRPRunStepLogInfo log = (MRPRunStepLogInfo)insertLogs.get(i);
            row = this.kdtDetail.addRow(rowIndex++);
            row.getCell("stepNum").setValue((Object)log.getStepNum());
            row.getCell("name").setValue((Object)log.getName());
            row.getCell("status").setValue((Object)log.getStatus());
            row.getCell("time").setValue((Object)log.getTime());
            row.getCell("exception").setValue((Object)log.getException());
            row.getCell("seq").setValue((Object)new Integer(log.getSeq()));
            row.getCell("status").setRenderer((IBasicRender)new IconRender());
            row.getCell("dataAmount").getStyleAttributes().setNumberFormat(SCMClientUtils.getFormatPattern((int)0, (boolean)true));
            row.getCell("dataAmount").setValue((Object)log.getDataAmount());
        }
    }

    public boolean destroyWindow() {
        if (this.timer != null && !this.isFinished) {
            this.timer.stop();
        }
        return super.destroyWindow();
    }

    public void AdjustDisplay() throws Exception {
        MRPRunLogInfo objRunLog;
        if (this.chkIsCalculateLLC.getModel().isSelected()) {
            this.txtReCalcLLCResult.setText(EASResource.getString((String)CustomDataProvider.getResName(this.txtReCalcLLCResult.getText(), "MPS_MRP_RUN_RECALC_LLC_RESULT")));
        } else {
            this.txtReCalcLLCResult.setText("");
        }
        if (this.chkIsCheckBOM.getModel().isSelected()) {
            this.txtBomCheckResult.setText(EASResource.getString((String)CustomDataProvider.getResNameOpposite(this.txtBomCheckResult.getText(), "MPS_MRP_RUN_BOM_CHECK_RESULT")));
        } else {
            this.txtBomCheckResult.setText("");
        }
        this.txtDuration.setText(null);
        Date dStart = (Date)this.pkStartTime.getValue();
        Date dEnd = (Date)this.pkEndTime.getValue();
        if (dEnd != null && dStart != null) {
            double dValue = dEnd.getTime() - dStart.getTime();
            BigDecimal duration = new BigDecimal(dValue / 1000.0 / 60.0);
            this.txtDuration.setText(PlanningConst.formatNumericTypeData(2, duration));
        }
        String strGlobal = EASResource.getString((String)"com.kingdee.eas.mm.planning.client.PlanningResource.PLAN_GLOBAL");
        String strSimulation = EASResource.getString((String)"com.kingdee.eas.mm.planning.client.PlanningResource.PLAN_TRAIL");
        String strPlanNumber = this.txtPlanNumber.getText();
        MRPRunLogInfo dataObject = (MRPRunLogInfo)this.getDataObject();
        if (dataObject.getRunName() != null) {
            this.txtPlanType.setText(dataObject.getRunName().getAlias());
        }
        if ((objRunLog = (MRPRunLogInfo)this.getDataObject()).getNumOfexceptionMaterials().doubleValue() > 0.0) {
            this.btnDetailExcep.setEnabled(true);
        } else {
            this.btnDetailExcep.setEnabled(false);
        }
        if (objRunLog.getNumOflowerSafeStockMtl().doubleValue() > 0.0) {
            this.btnDetailStorage.setEnabled(true);
        } else {
            this.btnDetailStorage.setEnabled(false);
        }
        if (objRunLog.getTotalPlanOrders().doubleValue() > 0.0) {
            this.btnDetailOrder.setEnabled(true);
        } else {
            this.btnDetailOrder.setEnabled(false);
        }
        if (objRunLog.getMateriaRange() != null) {
            if (objRunLog.getMateriaRange().equals((Object)MaterialRangeEnum.ALL)) {
                this.mateialMrp.setText(EASResource.getString((String)"com.kingdee.eas.mm.planning.client.PlanningResource.MATERILA_ALL"));
                this.mateialMrp.setEnabled(false);
            } else if (objRunLog.getMateriaRange().equals((Object)MaterialRangeEnum.PUR)) {
                this.mateialMrp.setText(EASResource.getString((String)"com.kingdee.eas.mm.planning.client.PlanningResource.PURE_MATERIAL"));
                this.mateialMrp.setEnabled(false);
            } else if (objRunLog.getMateriaRange().equals((Object)MaterialRangeEnum.CUSTOM)) {
                this.mateialMrp.setText(EASResource.getString((String)"com.kingdee.eas.mm.planning.client.PlanningResource.MATERIAL_RUN"));
                this.mateialMrp.setEnabled(true);
            }
        } else {
            this.mateialMrp.setText(EASResource.getString((String)"com.kingdee.eas.mm.planning.client.PlanningResource.MATERILA_ALL"));
            this.mateialMrp.setEnabled(false);
        }
        for (int i = 0; i < this.kdtDetail.getRowCount3(); ++i) {
            this.kdtDetail.getRow(i).getCell("status").setRenderer((IBasicRender)new IconRender());
        }
        this.actionStop.setEnabled(MRPRunLogStatusEnum.Running.equals((Object)this.editData.getStatus()));
    }

    public void setPlanType(String strPlanType) {
        this.txtPlanType.setText(strPlanType);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("planVersion.id"));
        sic.add(new SelectorItemInfo("planVersion.number"));
        sic.add(new SelectorItemInfo("planVersion.planType"));
        sic.add(new SelectorItemInfo("planVersion.name"));
        sic.add(new SelectorItemInfo("creator.id"));
        sic.add(new SelectorItemInfo("creator.name"));
        sic.add(new SelectorItemInfo("stepEntries.*"));
        return sic;
    }

    protected void displayGeneralListUI(int nContentToDisplay) throws EASBizException, UIException, BOSException, Exception {
        MRPRunLogInfo objRunLog = (MRPRunLogInfo)this.getDataObject();
        this.setCursorOfWair();
        this.isForme = this.isTransform();
        RptParams filter = new RptParams();
        filter.setString("storageUnitId", objRunLog.getStorageOrgUnit().getId().toString());
        filter.setString("mrpRunLogId", objRunLog.getId().toString());
        filter.setString("type", String.valueOf(nContentToDisplay));
        filter.setString("isForme", String.valueOf(this.isForme));
        HashMap<String, String> mapData = new HashMap<String, String>();
        mapData.put("type", String.valueOf(nContentToDisplay));
        UIContext ctx = new UIContext((Object)this);
        ctx.put((Object)"UIClassParam", (Object)REPORTVIEW_EXP_ID);
        ctx.put((Object)UICONTEXT_KEY_BE_JOINQUERY, (Object)true);
        ctx.put((Object)UICONTEXT_KEY_JOINQUERY_PARAMS, (Object)filter);
        ctx.put((Object)UICONTEXT_KEY_JOINQUERY_DATA, mapData);
        ctx.put((Object)"ID", (Object)("ss" + mapData.hashCode()));
        IUIWindow win = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create("com.kingdee.eas.base.report.client.ReportViewerUI", (Map)ctx, null);
        win.show();
        this.setCursorOfDefault();
    }

    public IRowSet fetchRowset(int dataType, String strStorageUnitID, String strMrpLogID) {
        IRowSet rs = null;
        try {
            IMRPCalcFacade calcFacade = MRPCalcFacadeFactory.getRemoteInstance();
            rs = calcFacade.fetchPlanData(dataType, strStorageUnitID, strMrpLogID);
        }
        catch (Exception e1) {
            this.handleException(e1);
        }
        return rs;
    }

    @Override
    protected void btnDetailExcep_actionPerformed(ActionEvent e) throws Exception {
        this.displayGeneralListUI(1);
    }

    @Override
    protected void mateialMrp_actionPerformed(ActionEvent e) throws Exception {
        MRPRunLogInfo objRunLog = (MRPRunLogInfo)this.getDataObject();
        UIContext context = new UIContext();
        context.put((Object)"Owner", (Object)this);
        this.isForme = this.isTransform();
        context.put((Object)"RunLog", (Object)objRunLog);
        context.put((Object)"isForm", (Object)this.isForme);
        IUIWindow dialog = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create("com.kingdee.eas.mm.planning.client.MRPLogMaterialUI", (Map)context, null, OprtState.VIEW);
        MRPLogMaterialUI ui = (MRPLogMaterialUI)dialog.getUIObject();
        dialog.show();
    }

    @Override
    protected void btnDetailStorage_actionPerformed(ActionEvent e) throws Exception {
        this.displayGeneralListUI(2);
    }

    @Override
    protected void btnDetailOrder_actionPerformed(ActionEvent e) throws Exception {
        this.displayGeneralListUI(3);
    }

    public void actionFirst_actionPerformed(ActionEvent e) throws Exception {
        super.actionFirst_actionPerformed(e);
        this.AdjustDisplay();
    }

    public void actionPre_actionPerformed(ActionEvent e) throws Exception {
        super.actionPre_actionPerformed(e);
        this.AdjustDisplay();
    }

    public void actionNext_actionPerformed(ActionEvent e) throws Exception {
        super.actionNext_actionPerformed(e);
        this.AdjustDisplay();
    }

    public void actionLast_actionPerformed(ActionEvent e) throws Exception {
        super.actionLast_actionPerformed(e);
        this.AdjustDisplay();
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
        this.printOfPrintPreview(false);
    }

    private void printOfPrintPreview(boolean isPreview) {
        KDNoteHelper helper = new KDNoteHelper();
        IMetaDataPK pk = MetaDataPKFactory.getMetaDataPK((String)"com.kingdee.eas.mm.planning.app.MRPRunLogDetailQuery");
        ArrayList<String> idList = new ArrayList<String>();
        if (this.editData != null && !StringUtils.isEmpty((String)this.editData.getString("id"))) {
            idList.add(this.editData.getString("id"));
        }
        CustomDataProvider dataProvider = new CustomDataProvider();
        dataProvider.idList = idList;
        dataProvider.pk = pk;
        dataProvider.strPlanType = this.txtPlanType.getText();
        dataProvider.strDuration = this.txtDuration.getText();
        if (isPreview) {
            helper.printPreview("/MM/planning/MM_MRPRunLog", (Object)dataProvider, (Component)((Object)this));
        } else {
            helper.print("/MM/planning/MM_MRPRunLog", (Object)dataProvider, (Component)((Object)this));
        }
    }

    @Override
    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrintPreview_actionPerformed(e);
        this.printOfPrintPreview(true);
    }

    protected IObjectValue createNewData() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return MRPRunLogFactory.getRemoteInstance();
    }

    public boolean isTransform() {
        if (this.isGloabalPlan()) {
            return true;
        }
        return this.editData.isIsTransformPlannedOrder();
    }

    public boolean isGloabalPlan() {
        return this.editData.getRunName() != null && (this.editData.getRunName().equals((Object)MrpRunEnum.MPS_GLOBAL) || this.editData.getRunName().equals((Object)MrpRunEnum.MRP_GLOBAL) || this.editData.getRunName().equals((Object)MrpRunEnum.MRP_Material) || this.editData.getRunName().equals((Object)MrpRunEnum.MPS_Material) || this.editData.getRunName().equals((Object)MrpRunEnum.MPS_GROSS) || this.editData.getRunName().equals((Object)MrpRunEnum.COOPERATE_PLAN));
    }

    @Override
    public void actionStop_actionPerformed(ActionEvent e) throws Exception {
        UserInfo user = SysContext.getSysContext().getCurrentUserInfo();
        StorageOrgUnitInfo curCtrlUnitInfo = SysContext.getSysContext().getCurrentStorageUnit();
        PermissionHelper.checkFunctionPermission((IObjectPK)new ObjectUuidPK(user.getId()), (IObjectPK)new ObjectUuidPK(curCtrlUnitInfo.getId().toString()), (String)this.getPermissionItem());
        String msg = EASResource.getString((String)"com.kingdee.eas.mm.planning.MRPResource", (String)"CONFIRM_STOPRUNNING");
        int result = MsgBox.showConfirm2((String)msg);
        if (result == 0) {
            MRPCalcFacadeFactory.getRemoteInstance().stopMRP(this.editData.getNumber(), this.editData.getStorageOrgUnit().getId().toString());
        }
    }

    protected String getPermissionItem() {
        int value = this.editData.getRunName().getValue();
        String strPermissionItem = null;
        switch (value) {
            case 1: {
                strPermissionItem = "mm_mps_planGlobal_execution";
                break;
            }
            case 3: {
                strPermissionItem = "mm_mps_planSimulation_execution";
                break;
            }
            case 2: {
                strPermissionItem = "mm_mrp_planGlobal_execution";
                break;
            }
            case 4: {
                strPermissionItem = "mm_mrp_planSimulation_execution";
                break;
            }
            case 7: {
                strPermissionItem = "mm_mrp_planChoiseMateial_execution";
                break;
            }
            case 6: {
                strPermissionItem = "mm_mps_planChoiseMateial_execution";
                break;
            }
            case 5: {
                strPermissionItem = "mm_selectBill_plan_execution";
                break;
            }
        }
        return strPermissionItem;
    }

    public void refreshProcessBar(MRPRunStepLogCollection coll) {
        int total = 0;
        if (coll != null) {
            total = coll.size();
        }
        int process = 0;
        for (int i = 0; i < total; ++i) {
            MRPRunStepLogInfo log = coll.get(i);
            if (log.getStatus() == null || log.getStatus().getValue() != 20) continue;
            ++process;
        }
        if (total > 0 && process > 0) {
            BigDecimal bigTotal = new BigDecimal(total);
            BigDecimal bigProcess = new BigDecimal(process);
            int pre = bigProcess.divide(bigTotal, 2, 4).multiply(new BigDecimal("100")).intValue();
            this.kDProgressBar1.setValue(pre);
            this.kDProgressBar1.setString(pre + "%");
            this.kDProgressBar1.setStringPainted(true);
        }
    }

    @Override
    public void actionWorkPlat_actionPerformed(ActionEvent e) throws Exception {
        super.actionWorkPlat_actionPerformed(e);
        try {
            String uiClassName = "com.kingdee.eas.mm.report.client.PlanerWorkPlatformTotalUI";
            UIContext ctx = new UIContext((Object)this);
            ctx.put((Object)"UIClassParam", (Object)"1");
            ctx.put((Object)"InitDataObject", (Object)this.editData);
            IUIWindow uiWindow = null;
            uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(uiClassName, (Map)ctx, null, OprtState.VIEW);
            PlanerWorkPlatformTotalUI workPlat = (PlanerWorkPlatformTotalUI)uiWindow.getUIObject();
            uiWindow.show();
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
    }

    @Override
    public void actionGetLog_actionPerformed(ActionEvent e) throws Exception {
        LongTimeDialog dialog = UITools.getDialog((Component)((Object)this));
        JLabel text = (JLabel)dialog.getContentPane().getComponent(1);
        String downloadingMsg = EASResource.getString((String)"com.kingdee.eas.mm.planning.client.PlanningResource.MRP_downLoad");
        text.setText(downloadingMsg);
        dialog.setLongTimeTask(new ILongTimeTask(){
            String successMsg = EASResource.getString((String)"com.kingdee.eas.mm.planning.client.PlanningResource.SAVE_SUCCESS");

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object exec() throws Exception {
                IMRPRunLog logFac = MRPRunLogFactory.getRemoteInstance();
                byte[] res = logFac.getLogFile();
                try (FileOutputStream os = null;){
                    String toDir = "C:/MRP/";
                    File toFileDir = new File(toDir);
                    if (toFileDir.exists()) {
                        File[] toFiles;
                        for (File file : toFiles = toFileDir.listFiles()) {
                            file.delete();
                        }
                    } else {
                        toFileDir.mkdir();
                    }
                    os = new FileOutputStream(toDir + "mrp.log", true);
                    os.write(res);
                }
                MsgBox.showInfo((String)this.successMsg);
                return null;
            }

            public void afterExec(Object result) throws Exception {
            }
        });
        dialog.show();
    }

    static /* synthetic */ void access$200(MrpRunLogDetailUI x0, Exception x1) {
        x0.handleException(x1);
    }

    static /* synthetic */ void access$300(MrpRunLogDetailUI x0, Exception x1) {
        x0.handleException(x1);
    }

    class IconRender
    extends KDLabel
    implements IBasicRender {
        public IconRender() {
            this.setHorizontalAlignment(0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void draw(Graphics graphics, Shape clip, Object object, Style cellStyle) {
            MRPStepStatusEnum result = MRPStepStatusEnum.NULL;
            if (object instanceof MRPStepStatusEnum) {
                result = (MRPStepStatusEnum)((Object)object);
            }
            if (MRPStepStatusEnum.FINISHED.equals((Object)result)) {
                this.setIcon(EASResource.getIcon((String)"imgTable_success"));
            } else if (MRPStepStatusEnum.NULL.equals((Object)result)) {
                this.setIcon(null);
            } else if (MRPStepStatusEnum.RUNNING.equals((Object)result)) {
                this.setIcon(EASResource.getIcon((String)"imgTable_low"));
            } else {
                this.setIcon(EASResource.getIcon((String)"imgTable_failure"));
            }
            Rectangle rect = clip.getBounds();
            this.setBounds(rect);
            Graphics cg = graphics.create(rect.x, rect.y, rect.width, rect.height);
            try {
                this.paint(cg);
            }
            finally {
                cg.dispose();
            }
        }

        protected void printComponent(Graphics g) {
            super.printComponent(g);
            g.drawRect(1, 1, this.getWidth() - 2, this.getHeight() - 2);
        }
    }

    private static class CustomDataProvider
    extends AbstractPrintDataProvider {
        public ArrayList idList;
        public IMetaDataPK pk;
        public String strPlanType;
        public String strDuration;

        private CustomDataProvider() {
        }

        public IRowSet getData(R1PrintDataSource dataSource) throws Exception {
            DefaultNoteDataProvider dataProvider = new DefaultNoteDataProvider((List)this.idList, this.pk);
            IRowSet rowset = dataProvider.getData(dataSource);
            if (rowset.next()) {
                rowset.updateString("duration", this.strDuration);
                this.setFieldDisplay(rowset, "isManageLLC", "displayIsReCalcLLC", "MPS_MRP_RUN_PARAMETER");
                this.setFieldDisplay(rowset, "isContainsMRPMaterial", "displayIsIncludeMrp", "MPS_MRP_RUN_PARAMETER");
                this.setFieldDisplay(rowset, "isCheckBOM", "displayIsBomCheck", "MPS_MRP_RUN_PARAMETER");
                this.setFieldDisplay(rowset, "isDelayOrder", "displayIsAllowDelay", "MPS_MRP_RUN_PARAMETER");
                this.setFieldDisplay(rowset, "isManageLLC", "isCalculateLLC", "displayLlcReCalcResult", "MPS_MRP_RUN_RECALC_LLC_RESULT");
                this.setFieldDisplay(rowset, "isCheckBOM", "bomNestingCheck", "displayBomCheckResult", "MPS_MRP_RUN_BOM_CHECK_RESULT");
                rowset.updateString("planVersion.planType", this.strPlanType);
            }
            rowset.beforeFirst();
            return rowset;
        }

        public static String getResName(boolean bln, String strResName) {
            String strFullResName = bln ? MrpRunLogDetailUI.strResource + strResName + "_OK" : MrpRunLogDetailUI.strResource + strResName + "_NOT_OK";
            return strFullResName;
        }

        public static String getResName(String strBln, String strResName) {
            boolean bln = Boolean.valueOf(strBln);
            String strFullResName = bln ? MrpRunLogDetailUI.strResource + strResName + "_OK" : MrpRunLogDetailUI.strResource + strResName + "_NOT_OK";
            return strFullResName;
        }

        public static String getResNameOpposite(String strBln, String strResName) {
            boolean bln = Boolean.valueOf(strBln);
            String strFullResName = !bln ? MrpRunLogDetailUI.strResource + strResName + "_OK" : MrpRunLogDetailUI.strResource + strResName + "_NOT_OK";
            return strFullResName;
        }

        public void setFieldDisplay(IRowSet rs, String strFromFieldName, String strToFieldName, String strResName) throws Exception {
            String strDisplay;
            boolean bln = rs.getBoolean(strFromFieldName);
            if (strFromFieldName.equalsIgnoreCase("bomNestingCheck")) {
                boolean bl = bln = !bln;
            }
            if ((strDisplay = EASResource.getString((String)CustomDataProvider.getResName(bln, strResName))) != null) {
                rs.updateString(strToFieldName, strDisplay);
            }
        }

        public void setFieldDisplay(IRowSet rs, String strOptionSetted, String strFromFieldName, String strToFieldName, String strResName) throws Exception {
            boolean blnOptionSetted = rs.getBoolean(strOptionSetted);
            if (blnOptionSetted) {
                this.setFieldDisplay(rs, strFromFieldName, strToFieldName, strResName);
            }
        }
    }
}

