/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.base.commonquery.client.IProcessor;
import com.kingdee.eas.base.commonquery.client.IPromptBoxFactory;
import com.kingdee.eas.base.form.model.combin.CombinUIApplication;
import com.kingdee.eas.base.form.model.combin.IPlugUI;
import com.kingdee.eas.base.permission.client.util.PermissionHelper;
import com.kingdee.eas.base.uiframe.client.UIModelDialog;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.IIDList;
import com.kingdee.eas.mm.common.client.KDTableUtils;
import com.kingdee.eas.mm.planning.IMultiOrgPlan;
import com.kingdee.eas.mm.planning.MultiOrgPlanFactory;
import com.kingdee.eas.mm.planning.MultiOrgPlanInfo;
import com.kingdee.eas.mm.planning.client.AbstractMultiOrgPlanListUI;
import com.kingdee.eas.mm.planning.client.MultiOrgPlanFilterUI;
import com.kingdee.eas.mm.planning.client.MultiOrgPlanRunLogUI;
import com.kingdee.eas.mm.planning.client.ProgressDialog;
import com.kingdee.eas.scm.common.ISCMBillBase;
import com.kingdee.eas.scm.common.action.TableSelectionHelper;
import com.kingdee.eas.scm.common.client.ISCMFilter;
import com.kingdee.eas.scm.common.client.SCMCommonProcessor;
import com.kingdee.eas.scm.common.client.SCMPromptBoxFactory;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.LinkedHashSet;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class MultiOrgPlanListUI
extends AbstractMultiOrgPlanListUI
implements IPlugUI {
    private static final long serialVersionUID = 7924846495237647021L;
    private static final Logger logger = CoreUIObject.getLogger(MultiOrgPlanListUI.class);
    private static final String RESOURCE = "com.kingdee.eas.mm.planning.MultiOrgPlanResource";
    private static final String TB_ID = "id";
    private static final String TB_STORAGEORGUNITID = "storageOrgUnit.id";
    private static final String TB_CREATETIME = "createTime";
    private static final String TB_LASTUPDATETIME = "lastUpdateTime";
    private static final String TB_MODIFYTIME = "modifyTime";
    private String runLogId = null;
    public CommonQueryDialog commonQueryDialog = null;
    private OrgUnitCollection authorizedMainOrgs = null;
    protected MultiOrgPlanFilterUI conditionPanel = null;
    private TableSelectionHelper tableSelectionHelper = null;
    private CombinUIApplication application = null;

    public void onLoad() throws Exception {
        this.setMergeColumn();
        super.onLoad();
        this.tblMain.getColumn(TB_CREATETIME).getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDateTimeFormatString());
        this.tblMain.getColumn(TB_LASTUPDATETIME).getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDateTimeFormatString());
        this.tblMain.getColumn(TB_MODIFYTIME).getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDateTimeFormatString());
    }

    public void onShow() throws Exception {
        super.onShow();
        KDTableUtils.setDefaultFreezeCol((KDTable)this.tblMain, (int)4);
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    private Integer getSelectedRow(KDTable tb) {
        KDTSelectBlock selected = tb.getSelectManager().get();
        if (selected == null) {
            return null;
        }
        return new Integer(selected.getBeginRow());
    }

    public String[] getMergeColumnKeys() {
        String[] str = new String[]{"storageOrgUnit.name", "name", "number", "isProcessMRP", "isCalcLvlCode", "isBomCheck", "isAllowPlanPast"};
        return str;
    }

    private void setMergeColumn() {
        String[] mergeColumnKeys = this.getMergeColumnKeys();
        if (mergeColumnKeys != null && mergeColumnKeys.length > 0) {
            this.tblMain.checkParsed();
            this.tblMain.getGroupManager().setGroup(true);
            for (int i = 0; i < mergeColumnKeys.length; ++i) {
                this.tblMain.getColumn(mergeColumnKeys[i]).setGroup(true);
                this.tblMain.getColumn(mergeColumnKeys[i]).setMergeable(true);
            }
        }
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() == 2 && this.getUIContext().get("oprState") != null && this.getUIContext().get("oprState").toString().equals("FINDVIEW")) {
            if (e.getType() == 0) {
                return;
            }
            this.checkSelected();
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"ID", (Object)this.getSelectedKeyValue());
            this.prepareUIContext(uiContext, new ActionEvent(this.btnView, 0, "Double Clicked"));
            IUIWindow window = this.getUIWindow();
            this.uiWindow = window != null && window instanceof UIModelDialog ? UIFactory.createUIFactory((String)this.getEditUIModal()).create(this.getEditUIName(), (Map)uiContext, null, "FINDVIEW") : UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(this.getEditUIName(), (Map)uiContext, null, "FINDVIEW");
            this.uiWindow.show();
        } else {
            super.tblMain_tableClicked(e);
        }
    }

    protected ICoreBase getBizInterface() throws Exception {
        return MultiOrgPlanFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return "com.kingdee.eas.mm.planning.client.MultiOrgPlanUI";
    }

    protected String[] getQueryShowField() {
        String[] str = new String[]{"storageOrgUnit.name", "name", "number", "planCalcType", "isProcessMRP", "isCalcLvlCode", "isBomCheck", "isAllowPlanPast", "isMaterialReplace", "entry.calcSeq", "storageOrgUnit1.name", "planVersionSet.number", "planVersionSet.name", "planningHorizon.number", "planningHorizon.name", "creator.name", TB_CREATETIME};
        return str;
    }

    protected String getKeyFieldName() {
        return TB_ID;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    protected boolean initDefaultFilter() {
        return true;
    }

    protected CustomerQueryPanel getFilterUI() throws Exception {
        if (this.conditionPanel == null) {
            this.conditionPanel = new MultiOrgPlanFilterUI();
        }
        return this.conditionPanel;
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        if (this.commonQueryDialog == null) {
            if (this.mainQuery == null) {
                this.mainQuery = new EntityViewInfo();
            }
            this.commonQueryDialog = super.initCommonQueryDialog();
            this.commonQueryDialog.setWidth(450);
            this.commonQueryDialog.setHeight(320);
            try {
                SCMPromptBoxFactory scmF7Factory = new SCMPromptBoxFactory(this.getFilterUI(), this.getMainBizOrgType());
                this.commonQueryDialog.setPromptBoxFactory((IPromptBoxFactory)scmF7Factory);
                this.commonQueryDialog.setProcessor((IProcessor)new SCMCommonProcessor());
                ISCMFilter iFilter = (ISCMFilter)this.getFilterUI();
                iFilter.setIsSupportMultiOrgs(true);
                iFilter.setContextObject(null);
                iFilter.setAuthorizedMainOrgs(this.authorizedMainOrgs);
                this.commonQueryDialog.addUserPanel((KDPanel)this.getFilterUI());
            }
            catch (Exception e) {
                this.handUIException(e);
                SysUtil.abort();
            }
        }
        this.commonQueryDialog.setShowSorter(true);
        return this.commonQueryDialog;
    }

    protected String getResource(String key) {
        return EASResource.getString((String)RESOURCE, (String)key);
    }

    private void showProgressDialog() {
        ProgressDialog dialog = ProgressDialog.getDialogInstance((Object)this);
        dialog.show();
    }

    private void openRunLogUI(int selectedRow, String runLogId) throws Exception {
        String orgId = (String)this.tblMain.getCell(selectedRow, TB_STORAGEORGUNITID).getValue();
        PermissionHelper.checkFunctionPermission((IObjectPK)this.getUserPk(), (IObjectPK)new ObjectUuidPK(orgId), (String)"mm_multiOrgPlan_run");
        if (this.application != null) {
            this.application.setRefresh("com.kingdee.eas.mm.planning.client.MultiOrgPlanRunLogUI");
            Context ctx = new Context();
            ctx.put((Object)"isFromMultiOrgPlanUI", (Object)new Boolean(true));
            ctx.put((Object)"multiOrgPlanRunLogId", (Object)runLogId);
            ctx.put((Object)"planStorageOrgUnit.id", (Object)orgId);
            this.application.setContext(ctx);
            this.application.getView().changePage(2);
        } else {
            String uiClassName = "com.kingdee.eas.mm.planning.client.MultiOrgPlanRunLogUI";
            UIContext ctx = new UIContext((Object)this);
            ctx.put((Object)"isFromMultiOrgPlanUI", (Object)new Boolean(true));
            ctx.put((Object)"multiOrgPlanRunLogId", (Object)runLogId);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(uiClassName, (Map)ctx, null, OprtState.VIEW);
            MultiOrgPlanRunLogUI logUI = (MultiOrgPlanRunLogUI)uiWindow.getUIObject();
            logUI.setIsNeedDefaultFilter(false);
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit1.id", (Object)orgId, CompareType.EQUALS));
            logUI.getMainQuery().setFilter(filterInfo);
            logUI.refreshList();
            uiWindow.show();
        }
    }

    private void runMultiOrgPlan() throws BOSException, EASBizException {
        logger.info((Object)"MultiOrgPlan start run.");
        this.checkSelected();
        Integer selected = this.getSelectedRow(this.tblMain);
        if (selected == null) {
            return;
        }
        int selectedRow = selected;
        String multiOrgPlanId = (String)this.tblMain.getCell(selectedRow, TB_ID).getValue();
        MultiOrgPlanInfo multiOrgPlan = new MultiOrgPlanInfo();
        multiOrgPlan.setId(BOSUuid.read((String)multiOrgPlanId));
        IMultiOrgPlan iMultiOrgPlan = MultiOrgPlanFactory.getRemoteInstance();
        this.runLogId = iMultiOrgPlan.multiOrgPlanRun((IObjectValue)multiOrgPlan);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    Integer selected = MultiOrgPlanListUI.this.getSelectedRow(MultiOrgPlanListUI.this.tblMain);
                    if (selected == null) {
                        return;
                    }
                    MultiOrgPlanListUI.this.showProgressDialog();
                    MultiOrgPlanListUI.this.openRunLogUI(selected, MultiOrgPlanListUI.this.runLogId);
                    if (MultiOrgPlanListUI.this.application == null) {
                        MultiOrgPlanListUI.this.actionExitCurrent_actionPerformed(null);
                    }
                }
                catch (Exception e) {
                    MultiOrgPlanListUI.this.handUIExceptionAndAbort(e);
                }
            }
        });
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor exec = super.getQueryExecutor(queryPK, viewInfo);
        if (viewInfo.getSorter() != null && viewInfo.getSorter().size() > 0 && !viewInfo.getSorter().toString().equals("")) {
            SorterItemCollection sorters = viewInfo.getSorter();
            boolean hasCreateTimeSorter = false;
            boolean hasCalcSeqSorter = false;
            boolean hasIdSorter = false;
            int idIndex = -1;
            for (int i = 0; i < sorters.size(); ++i) {
                if (sorters.get(i).getPropertyName().equals(TB_CREATETIME)) {
                    hasCreateTimeSorter = true;
                }
                if (sorters.get(i).getPropertyName().equals("entry.calcSeq")) {
                    hasCalcSeqSorter = true;
                }
                if (!sorters.get(i).getPropertyName().equals(TB_ID)) continue;
                hasIdSorter = true;
                idIndex = i;
            }
            if (!hasCreateTimeSorter) {
                SorterItemInfo aSorterItemInfo = new SorterItemInfo(TB_CREATETIME);
                aSorterItemInfo.setSortType(SortType.DESCEND);
                viewInfo.getSorter().add(aSorterItemInfo);
            }
            if (!hasCalcSeqSorter) {
                SorterItemInfo bSorterItemInfo = new SorterItemInfo("entry.calcSeq");
                bSorterItemInfo.setSortType(SortType.ASCEND);
                viewInfo.getSorter().add(bSorterItemInfo);
            }
            if (hasIdSorter) {
                sorters.removeObject(idIndex);
            }
        } else {
            SorterItemCollection collection = new SorterItemCollection();
            SorterItemInfo aSorterItemInfo = new SorterItemInfo(TB_CREATETIME);
            aSorterItemInfo.setSortType(SortType.DESCEND);
            collection.add(aSorterItemInfo);
            SorterItemInfo bSorterItemInfo = new SorterItemInfo("entry.calcSeq");
            bSorterItemInfo.setSortType(SortType.ASCEND);
            collection.add(bSorterItemInfo);
            viewInfo.setSorter(collection);
        }
        return exec;
    }

    protected String[] getCountQueryFields() {
        return new String[]{TB_ID};
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filterInfo = new FilterInfo();
        FilterInfo filterPerm = this.getHasPermissionOrgFilterForQuery();
        if (filterPerm != null) {
            filterInfo = filterPerm;
        }
        return filterInfo;
    }

    private FilterInfo getHasPermissionOrgFilterForQuery() {
        FilterInfo filterInfo = new FilterInfo();
        try {
            if (this.authorizedMainOrgs == null) {
                ISCMBillBase iBiz = (ISCMBillBase)this.getBizInterface();
                this.authorizedMainOrgs = iBiz.getAuthOrgsByType(this.getMainBizOrgType(), this.mainQueryPK);
            }
            OrgUnitInfo newMainOrg = null;
            String key = TB_STORAGEORGUNITID;
            if (this.authorizedMainOrgs != null && this.authorizedMainOrgs.size() > 0) {
                if (key == null) {
                    throw new IllegalArgumentException("getMainBizOrgType() should return a correct value.");
                }
                newMainOrg = this.authorizedMainOrgs.get(0);
                LinkedHashSet<String> keys = new LinkedHashSet<String>();
                for (int i = 0; i < this.authorizedMainOrgs.size(); ++i) {
                    keys.add(this.authorizedMainOrgs.get(i).getId().toString());
                }
                filterInfo.getFilterItems().add(new FilterItemInfo(key, keys, CompareType.INCLUDE));
                OrgUnitInfo mainOrg = (OrgUnitInfo)this.getUIContext().get(this.getMainBizOrgType());
                if (mainOrg != null && keys.contains(mainOrg.getId().toString())) {
                    return filterInfo;
                }
                this.getUIContext().put(this.getMainBizOrgType(), newMainOrg);
                if (newMainOrg != null) {
                    this.initUIMainOrgContext(newMainOrg.getId().toString());
                }
            } else {
                this.getUIContext().put(this.getMainBizOrgType(), null);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return filterInfo;
    }

    protected String getOrgFieldName() {
        return TB_STORAGEORGUNITID;
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        ObjectStringPK pk = null;
        if (this.tblMain == null) {
            return null;
        }
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        if (selectRows.length > 0) {
            int rowIndex = selectRows[0];
            IRow row = this.tblMain.getRow(rowIndex);
            if (row == null) {
                return null;
            }
            ICell cell = row.getCell(this.getOrgFieldName());
            if (cell == null) {
                return null;
            }
            Object keyValue = cell.getValue();
            if (keyValue != null) {
                pk = new ObjectStringPK(keyValue.toString());
            }
        }
        if (pk != null) {
            return pk;
        }
        if (this.getMainOrgContext() != null && this.getMainOrgContext().get((Object)this.getMainBizOrgType()) != null) {
            pk = new ObjectStringPK(((OrgUnitInfo)this.getMainOrgContext().get((Object)this.getMainBizOrgType())).getId().toString());
            return pk;
        }
        return super.getOrgPK(action);
    }

    public void attach(CombinUIApplication app) {
        this.application = app;
    }

    @Override
    public void actionRunMPS_actionPerformed(ActionEvent e) throws Exception {
        this.runMultiOrgPlan();
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        IIDList idList = this.getSelectedKeyValuesForHasQueryPK();
        if (idList == null || idList.size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
        if (this.application != null) {
            this.application.setIdList(idList);
            this.application.setEditType("VIEW");
            this.application.setRefresh("com.kingdee.eas.mm.planning.client.MultiOrgPlanUI");
            this.application.getView().changePage(1);
        } else {
            super.actionView_actionPerformed(e);
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        IIDList idList = this.getSelectedKeyValuesForHasQueryPK();
        if (idList == null || idList.size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
        if (this.application != null) {
            this.application.setIdList(idList);
            this.application.setEditType("EDIT");
            this.application.setRefresh("com.kingdee.eas.mm.planning.client.MultiOrgPlanUI");
            this.application.getView().changePage(1);
        } else {
            super.actionEdit_actionPerformed(e);
        }
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        if (this.application != null) {
            this.application.setIdList(null);
            this.application.setEditType("ADDNEW");
            this.application.setRefresh("com.kingdee.eas.mm.planning.client.MultiOrgPlanUI");
            this.application.getView().changePage(1);
        } else {
            super.actionAddNew_actionPerformed(e);
        }
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        this.setFilterForQuery(null);
        super.actionQuery_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemove_actionPerformed(e);
        if (this.application != null) {
            this.application.setRefresh("com.kingdee.eas.mm.planning.client.MultiOrgPlanUI");
        }
    }
}

