/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.KDTableHelper;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.framework.batch.BatchExecuteResult;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.form.model.combin.CombinUIApplication;
import com.kingdee.eas.base.form.model.combin.IPlugUI;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.client.util.PermissionHelper;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchHandler.UtilRequest;
import com.kingdee.eas.framework.util.ExceptionMessageUtility;
import com.kingdee.eas.mm.basedata.PlanVersionSetInfo;
import com.kingdee.eas.mm.basedata.PlanningHorizonSetFactory;
import com.kingdee.eas.mm.basedata.PlanningHorizonSetInfo;
import com.kingdee.eas.mm.planning.MultiOrgPlanEntryInfo;
import com.kingdee.eas.mm.planning.MultiOrgPlanFactory;
import com.kingdee.eas.mm.planning.MultiOrgPlanInfo;
import com.kingdee.eas.mm.planning.PlanningCalcTypeEnum;
import com.kingdee.eas.mm.planning.client.AbstractMultiOrgPlanUI;
import com.kingdee.eas.mm.planning.client.MultiOrgPlanRunLogUI;
import com.kingdee.eas.mm.planning.client.ProgressDialog;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.scm.common.util.ResourceUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.enums.EnumUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class MultiOrgPlanUI
extends AbstractMultiOrgPlanUI
implements IPlugUI {
    private static final long serialVersionUID = -1395836858827117869L;
    private static final Logger logger = CoreUIObject.getLogger(MultiOrgPlanUI.class);
    private static final String TB_ENTRY_CALCSEQ = "calcSeq";
    private static final String TB_ENTRY_STORAGEORGUNIT = "storageOrgUnit";
    private static final String TB_ENTRY_PLANVERSETNUM = "planVerSetNumber";
    private static final String TB_ENTRY_PLANVERSETNAME = "planVerSetName";
    private static final String TB_ENTRY_PLANNINGHORIZON = "PlanningHorizon";
    private static final String TB_ENTRY_REMARK = "remark";
    private KDTEditAdapter entryChangedListener = null;
    private KDTSelectListener entrySelectListener = null;
    private ChangeListener chkProcMRPChangeListener = null;
    private DataChangeListener prmtStorageOrgUnitListener = null;
    private DataChangeListener f7Planversetlistener = null;
    private static final String RESOURCE = "com.kingdee.eas.mm.planning.MultiOrgPlanResource";
    private KDBizPromptBox bizStorageOrgUnit = null;
    private String runLogId = null;
    private CombinUIApplication application = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.actionSubmit.setVisible(false);
        this.actionSubmit.setEnabled(false);
        this.actionSave.setVisible(true);
        this.actionSave.setEnabled(true);
        this.comboBaseStatus.addItems(EnumUtils.getEnumList((String)"com.kingdee.eas.scm.common.BillBaseStatusEnum").toArray());
        this.kdtEntry.getSelectManager().setSelectMode(15);
        this.kdtEntry.getActionMap().remove("Paste");
        this.kdtEntry.getActionMap().remove("Delete");
        this.kdtEntry.getActionMap().remove("Copy");
        this.kdtEntry.getActionMap().remove("Cut");
        this.btnAuditResult.setEnabled(false);
        this.btnAuditResult.setVisible(false);
        if (this.getOprtState() == "VIEW" && this.editData.getId() != null) {
            this.btnRunMPS.setEnabled(true);
            this.menuItemRunMPS.setEnabled(true);
        } else {
            this.btnRunMPS.setEnabled(false);
            this.menuItemRunMPS.setEnabled(false);
        }
        this.btnRunMPS.setVisible(true);
        this.menuItemRunMPS.setVisible(true);
        this.menuItemRunMPS.setIcon(EASResource.getIcon((String)"imgTbtn_execute"));
        if (this.getOprtState() == "ADDNEW" || this.getOprtState() == "EDIT") {
            this.initTableKeyStroke(this.kdtEntry, true);
        } else {
            KDTableHelper.downArrowAutoAddRow((KDTable)this.kdtEntry, (boolean)false, null);
            KDTableHelper.updateEnterWithTab((KDTable)this.kdtEntry, (boolean)false);
        }
        this.setLockFiled();
        this.initEntries();
        if (this.application != null) {
            if ("ADDNEW".equals(this.application.getEditType())) {
                this.txtName.setEditable(true);
            }
            if (this.getUIContext().get("lastId") != null) {
                MutexServiceControlFactory.getRemoteInstance().releaseObjIDForUpdate((String)this.getUIContext().get("lastId"));
            }
            this.getUIContext().put("lastId", this.idList.getCurrentID());
        }
        this.btnAttachment.setVisible(false);
        this.prmtStorageOrgUnit.requestFocus(true);
        this.btnAddEntries.setText(null);
        this.btnInsertEntries.setText(null);
        this.btnRemoveEntries.setText(null);
        super.setReservationVisible(false);
    }

    @Override
    public void loadFields() {
        this.removeListener();
        super.loadFields();
        this.addListener();
        if (this.getOprtState() == "VIEW" && this.editData.getId() != null) {
            this.btnRunMPS.setEnabled(true);
            this.menuItemRunMPS.setEnabled(true);
        } else {
            this.btnRunMPS.setEnabled(false);
            this.menuItemRunMPS.setEnabled(false);
        }
        if (this.getOprtState() == "ADDNEW" || this.getOprtState() == "EDIT") {
            this.initTableKeyStroke(this.kdtEntry, true);
            this.unLockUI();
        } else {
            KDTableHelper.downArrowAutoAddRow((KDTable)this.kdtEntry, (boolean)false, null);
            KDTableHelper.updateEnterWithTab((KDTable)this.kdtEntry, (boolean)false);
            this.lockUIForViewStatus();
        }
        if (this.getOprtState() == "ADDNEW") {
            int rowCount;
            this.prmtStorageOrgUnit.setAccessAuthority(0);
            this.prmtStorageOrgUnit.setEditable(true);
            this.prmtStorageOrgUnit.setEnabled(true);
            if (this.editData.getBaseStatus().equals((Object)BillBaseStatusEnum.ADD) && this.editData.getId() == null && (rowCount = this.getDetailTable().getRowCount()) == 1) {
                this.getDetailTable().getCell(0, TB_ENTRY_CALCSEQ).setValue((Object)new Integer(1));
            }
        } else if (this.getOprtState() == "EDIT") {
            this.prmtStorageOrgUnit.setAccessAuthority(0);
            this.prmtStorageOrgUnit.setEditable(true);
            this.prmtStorageOrgUnit.setEnabled(true);
            this.txtName.setEnabled(true);
            this.txtName.setEditable(true);
            this.txtNumber.setEnabled(true);
            this.txtNumber.setEditable(true);
        } else {
            this.prmtStorageOrgUnit.setAccessAuthority(1);
            this.prmtStorageOrgUnit.setEditable(false);
            this.prmtStorageOrgUnit.setEnabled(false);
        }
        if (!this.isFirstOnload()) {
            this.setLockFiled();
        }
    }

    public void onShow() throws Exception {
        super.onShow();
        if (this.getMainOrgUnit() != null) {
            if (!(this.editData.getBaseStatus() != BillBaseStatusEnum.ADD && this.editData.getBaseStatus() != BillBaseStatusEnum.VERSION || this.isBotpBill())) {
                this.getMainOrgUnit().setAccessAuthority(0);
                this.getMainOrgUnit().setEditable(true);
            } else {
                this.getMainOrgUnit().setAccessAuthority(1);
                this.getMainOrgUnit().setAccessAuthority(1);
                this.getMainOrgUnit().setEditable(false);
            }
        }
    }

    public String getOprtState() {
        if (this.oprtState == null) {
            this.oprtState = "ADDNEW";
        }
        return this.oprtState;
    }

    private void removeListener() {
        if (this.entryChangedListener != null) {
            this.kdtEntry.removeKDTEditListener((KDTEditListener)this.entryChangedListener);
        }
        if (this.entrySelectListener != null) {
            this.kdtEntry.removeKDTSelectListener(this.entrySelectListener);
        }
        if (this.chkProcMRPChangeListener != null) {
            this.chkIsProcessMRP.removeChangeListener(this.chkProcMRPChangeListener);
        }
    }

    private void addListener() {
        if (this.entrySelectListener == null) {
            this.entrySelectListener = new KDTSelectListener(){

                public void tableSelectChanged(KDTSelectEvent e) {
                }
            };
        }
        this.kdtEntry.addKDTSelectListener(this.entrySelectListener);
        if (this.entryChangedListener == null) {
            this.entryChangedListener = new KDTEditAdapter(){

                public void editStopped(KDTEditEvent e) {
                    MultiOrgPlanUI.this.kdtEntryChangedProcess(e);
                }
            };
        }
        this.kdtEntry.addKDTEditListener((KDTEditListener)this.entryChangedListener);
    }

    private void initEntries() {
        SCMClientUtils.setNecessColorInTable((KDTable)this.kdtEntry, (String[])new String[]{TB_ENTRY_STORAGEORGUNIT, TB_ENTRY_CALCSEQ, TB_ENTRY_PLANVERSETNUM});
        KDFormattedTextField qtyTxtField = new KDFormattedTextField();
        qtyTxtField.setDataType(0);
        qtyTxtField.setRemoveingZeroInDispaly(false);
        qtyTxtField.setSupportedEmpty(false);
        qtyTxtField.setNegatived(false);
        KDTDefaultCellEditor qtyCellEditor = new KDTDefaultCellEditor((JTextField)qtyTxtField);
        this.kdtEntry.getColumn(TB_ENTRY_CALCSEQ).setEditor((ICellEditor)qtyCellEditor);
        this.bizStorageOrgUnit = new KDBizPromptBox();
        this.bizStorageOrgUnit.setQueryInfo("com.kingdee.eas.basedata.org.app.StorageOrgUnitQuery");
        this.bizStorageOrgUnit.setEditFormat("$number$");
        this.bizStorageOrgUnit.setDisplayFormat("$name$");
        this.bizStorageOrgUnit.setCommitFormat("$number$");
        SCMClientUtils.setMainBizOrgF7((KDBizPromptBox)this.bizStorageOrgUnit, (OrgType)OrgType.Storage, null);
        this.bizStorageOrgUnit.setEnabledMultiSelection(true);
        this.prmtStorageOrgUnitListener = new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    MultiOrgPlanUI.this.executionOrgUnitChangedProcess(e);
                }
                catch (EASBizException e1) {
                    MultiOrgPlanUI.this.handUIException(e1);
                }
                catch (BOSException e2) {
                    MultiOrgPlanUI.this.handUIException(e2);
                }
            }
        };
        this.bizStorageOrgUnit.addDataChangeListener(this.prmtStorageOrgUnitListener);
        KDTDefaultCellEditor bizboxEditor = new KDTDefaultCellEditor((IKDEditor)this.bizStorageOrgUnit);
        this.kdtEntry.getColumn(TB_ENTRY_STORAGEORGUNIT).setEditor((ICellEditor)bizboxEditor);
        KDBizPromptBox planverF7 = new KDBizPromptBox();
        planverF7.setQueryInfo("com.kingdee.eas.mm.basedata.app.F7PlanVersionSetQuery");
        planverF7.setEditFormat("$number$");
        planverF7.setDisplayFormat("$number$");
        planverF7.setCommitFormat("$number$");
        ObjectValueRender avr = new ObjectValueRender();
        avr.setFormat((IDataFormat)new BizDataFormat("$number$"));
        KDTDefaultCellEditor bizboxEditor1 = new KDTDefaultCellEditor((IKDEditor)planverF7);
        this.kdtEntry.getColumn(TB_ENTRY_PLANVERSETNUM).setEditor((ICellEditor)bizboxEditor1);
        this.kdtEntry.getColumn(TB_ENTRY_PLANVERSETNUM).setRenderer((IBasicRender)avr);
        this.f7Planversetlistener = new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    MultiOrgPlanUI.this.f7PlanversetChanged(e);
                }
                catch (Exception e1) {
                    MultiOrgPlanUI.this.handleException(e1);
                }
            }
        };
        planverF7.addDataChangeListener(this.f7Planversetlistener);
        this.kdtEntry.addKDTActiveCellListener(new KDTActiveCellListener(){

            public void activeCellChanged(KDTActiveCellEvent e) {
                MultiOrgPlanUI.this.f7addFilter(e);
            }
        });
        this.kdtEntry.getColumn(TB_ENTRY_PLANVERSETNAME).getStyleAttributes().setLocked(true);
        this.kdtEntry.getColumn(TB_ENTRY_PLANNINGHORIZON).getStyleAttributes().setLocked(true);
        this.kdtEntry.getColumn("planningHorizonNumber").getStyleAttributes().setLocked(true);
        KDTextField txtRemark = new KDTextField();
        txtRemark.setMaxLength(80);
        KDTDefaultCellEditor remarkCellEditor = new KDTDefaultCellEditor((JTextField)txtRemark);
        this.kdtEntry.getColumn(TB_ENTRY_REMARK).setEditor((ICellEditor)remarkCellEditor);
    }

    private void f7PlanversetChanged(DataChangeEvent e) throws EASBizException, BOSException {
        Integer selected = this.getSelectedRow(this.getDetailTable());
        if (selected == null) {
            return;
        }
        if (e.getNewValue() != null) {
            boolean isDiffrent = SCMGroupClientUtils.isDiffrent((Object)e.getOldValue(), (Object)e.getNewValue());
            if (isDiffrent) {
                PlanVersionSetInfo newValue = (PlanVersionSetInfo)e.getNewValue();
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add(new SelectorItemInfo("id"));
                selector.add(new SelectorItemInfo("number"));
                selector.add(new SelectorItemInfo("name"));
                ObjectUuidPK pk = new ObjectUuidPK(newValue.getPlanningHorizon().getId());
                PlanningHorizonSetInfo value = (PlanningHorizonSetInfo)PlanningHorizonSetFactory.getRemoteInstanceWithObjectContext((Context)this.getMainOrgContext()).getValue((IObjectPK)pk, selector);
                this.kdtEntry.getCell(selected.intValue(), TB_ENTRY_PLANVERSETNAME).setValue((Object)newValue.getName());
                this.kdtEntry.getCell(selected.intValue(), TB_ENTRY_PLANNINGHORIZON).setValue((Object)value.getName());
                this.kdtEntry.getCell(selected.intValue(), "planningHorizonNumber").setValue((Object)value.getNumber());
                this.kdtEntry.getCell(selected.intValue(), "planVerSetId").setValue((Object)newValue);
            }
        } else {
            this.kdtEntry.getCell(selected.intValue(), TB_ENTRY_PLANVERSETNAME).setValue(null);
            this.kdtEntry.getCell(selected.intValue(), TB_ENTRY_PLANNINGHORIZON).setValue(null);
            this.kdtEntry.getCell(selected.intValue(), "planningHorizonNumber").setValue(null);
            this.kdtEntry.getCell(selected.intValue(), "planVerSetId").setValue(null);
        }
    }

    private void f7addFilter(KDTActiveCellEvent e) {
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColumnIndex();
        if (rowIndex < 0) {
            return;
        }
        if (colIndex == this.kdtEntry.getColumn(TB_ENTRY_PLANVERSETNUM).getColumnIndex()) {
            StorageOrgUnitInfo value = (StorageOrgUnitInfo)this.kdtEntry.getCell(rowIndex, TB_ENTRY_STORAGEORGUNIT).getValue();
            if (value == null) {
                value = new StorageOrgUnitInfo();
                value.setId(BOSUuid.create((String)"123"));
            }
            UserInfo currentUserInfo = SysContext.getSysContext().getCurrentUserInfo();
            ObjectUuidPK userPK = new ObjectUuidPK(currentUserInfo.getId());
            ObjectUuidPK orgPK = new ObjectUuidPK(value.getId().toString());
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)value.getId().toString(), CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)this.getMRPandMPS(), CompareType.INCLUDE));
            filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(20), CompareType.EQUALS));
            view.setFilter(filterInfo);
            KDBizPromptBox bizBox = (KDBizPromptBox)this.kdtEntry.getColumn(TB_ENTRY_PLANVERSETNUM).getEditor().getComponent();
            bizBox.setEntityViewInfo(view);
        }
    }

    private Set getMRPandMPS() {
        HashSet<String> set = new HashSet<String>();
        set.add("900");
        set.add("901");
        return set;
    }

    private void loadPlanVersionSet() throws EASBizException, BOSException {
        Locale locale = this.getLocale();
        KDTable tb = this.getDetailTable();
        if (tb.getRowCount() <= 0) {
            return;
        }
        StorageOrgUnitInfo[] storageOrgUnitInfos = new StorageOrgUnitInfo[tb.getRowCount()];
        StorageOrgUnitInfo orgInfo = null;
        HashMap<String, Integer> orgRowMap = null;
        int orgLen = 0;
        for (int i = 0; i < tb.getRowCount(); ++i) {
            orgInfo = (StorageOrgUnitInfo)tb.getCell(i, TB_ENTRY_STORAGEORGUNIT).getValue();
            if (orgInfo == null) continue;
            storageOrgUnitInfos[orgLen] = orgInfo;
            ++orgLen;
            if (orgRowMap == null) {
                orgRowMap = new HashMap<String, Integer>();
            }
            orgRowMap.put(orgInfo.getId().toString(), new Integer(i));
        }
        HashMap map = MultiOrgPlanFactory.getRemoteInstance().getPlanVerSet(storageOrgUnitInfos);
        if (map == null) {
            logger.error((Object)"Get plan version return null!");
            return;
        }
        int curRow = 0;
        PlanVersionSetInfo planVerSet = null;
        for (int i = 0; i < storageOrgUnitInfos.length; ++i) {
            if (storageOrgUnitInfos[i] == null || (planVerSet = (PlanVersionSetInfo)map.get(storageOrgUnitInfos[i].getId().toString())) == null) continue;
            curRow = (Integer)orgRowMap.get(storageOrgUnitInfos[i].getId().toString());
            tb.getCell(curRow, "planVerSetId").setValue((Object)planVerSet);
            tb.getCell(curRow, TB_ENTRY_PLANVERSETNAME).setValue((Object)planVerSet.getName(locale));
            tb.getCell(curRow, TB_ENTRY_PLANVERSETNUM).setValue((Object)planVerSet);
            tb.getCell(curRow, TB_ENTRY_PLANNINGHORIZON).setValue((Object)planVerSet.getPlanningHorizon().getName(locale));
        }
    }

    private void kdtEntryChangedProcess(KDTEditEvent e) {
        if (!e.getSource().equals(this.kdtEntry)) {
            return;
        }
        Object oldValue = e.getOldValue();
        Object newValue = e.getValue();
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        KDTable tb = this.getDetailTable();
        if (colIndex == this.kdtEntry.getColumn(TB_ENTRY_CALCSEQ).getColumnIndex()) {
            if (newValue == null) {
                return;
            }
            if ((Integer)newValue == 0) {
                return;
            }
            Integer seq = null;
            int rowCount = tb.getRowCount();
            boolean isExist = false;
            for (int i = 0; i < rowCount; ++i) {
                if (i == rowIndex || (seq = (Integer)tb.getCell(i, colIndex).getValue()) == null || seq.intValue() != ((Integer)newValue).intValue()) continue;
                isExist = true;
                break;
            }
            if (isExist) {
                tb.getCell(rowIndex, colIndex).setValue(null);
                MsgBox.showInfo((String)ResourceUtils.getMessage((String)RESOURCE, (String)"CALCSEQ_EXIST", (String[])new String[]{newValue.toString()}));
                tb.getCell(rowIndex, colIndex).setValue(e.getOldValue());
                tb.getEditManager().editCellAt(rowIndex, colIndex);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void kdtEntrySelectProcess(KDTSelectEvent e) {
        int selectRow = e.getSelectBlock().getBeginRow();
        KDTable tb = this.getDetailTable();
        if (e.getPrevSelectBlock() != null) {
            StorageOrgUnitInfo orgInfo;
            int prevSelectRow = e.getPrevSelectBlock().getBeginRow();
            if (prevSelectRow != selectRow && tb.getCell(prevSelectRow, TB_ENTRY_STORAGEORGUNIT) != null && (orgInfo = (StorageOrgUnitInfo)tb.getCell(prevSelectRow, TB_ENTRY_STORAGEORGUNIT).getValue()) == null) return;
        }
        if (e.getSelectBlock() == null) return;
    }

    private void executionOrgUnitChangedProcess(DataChangeEvent e) throws EASBizException, BOSException {
        KDBizPromptBox bizStorageOrgUnitBox = (KDBizPromptBox)e.getSource();
        Object oldOrg = e.getOldValue();
        Integer selected = this.getSelectedRow(this.getDetailTable());
        if (selected == null) {
            return;
        }
        int selectedRow = selected;
        KDTable tb = this.getDetailTable();
        if (bizStorageOrgUnitBox.getValue() == null) {
            tb.getRow(selectedRow).getCell(TB_ENTRY_PLANVERSETNUM).setValue(null);
            tb.getRow(selectedRow).getCell(TB_ENTRY_PLANVERSETNAME).setValue(null);
            tb.getRow(selectedRow).getCell(TB_ENTRY_PLANNINGHORIZON).setValue(null);
            tb.getRow(selectedRow).getCell("planningHorizonNumber").setValue(null);
            tb.getRow(selectedRow).getCell(TB_ENTRY_REMARK).setValue(null);
            return;
        }
        StorageOrgUnitInfo[] storageOrgUnitInfos = null;
        if (bizStorageOrgUnitBox.getValue() instanceof StorageOrgUnitInfo[]) {
            storageOrgUnitInfos = (StorageOrgUnitInfo[])bizStorageOrgUnitBox.getValue();
        } else if (bizStorageOrgUnitBox.getValue() instanceof StorageOrgUnitInfo) {
            Object oCol;
            ICell cell;
            storageOrgUnitInfos = new StorageOrgUnitInfo[]{(StorageOrgUnitInfo)bizStorageOrgUnitBox.getValue()};
            if (selected != null && selectedRow >= 0 && (cell = tb.getRow(selectedRow).getCell(TB_ENTRY_STORAGEORGUNIT)) != null && (oCol = cell.getValue()) != null && oCol instanceof StorageOrgUnitInfo && storageOrgUnitInfos[0].getId().toString().equals(((StorageOrgUnitInfo)oCol).getId().toString())) {
                return;
            }
        } else if (bizStorageOrgUnitBox.getValue() instanceof Object[]) {
            Object[] objects = (Object[])bizStorageOrgUnitBox.getValue();
            if (objects.length == 0) {
                return;
            }
            storageOrgUnitInfos = new StorageOrgUnitInfo[objects.length];
            System.arraycopy(objects, 0, storageOrgUnitInfos, 0, objects.length);
        } else {
            return;
        }
        Set orgIdSet = this.getTableStorageOrgMap();
        ArrayList<StorageOrgUnitInfo> orgList = new ArrayList<StorageOrgUnitInfo>();
        for (int i = 0; i < storageOrgUnitInfos.length; ++i) {
            if (orgIdSet != null && orgIdSet.contains(storageOrgUnitInfos[i].getId().toString()) && (oldOrg == null || !(oldOrg instanceof StorageOrgUnitInfo) || !((StorageOrgUnitInfo)oldOrg).getId().toString().equals(storageOrgUnitInfos[i].getId().toString()))) continue;
            orgList.add(storageOrgUnitInfos[i]);
        }
        StorageOrgUnitInfo[] inserOrgs = new StorageOrgUnitInfo[orgList.size()];
        orgList.toArray(inserOrgs);
        bizStorageOrgUnitBox.removeDataChangeListener(this.prmtStorageOrgUnitListener);
        IRow curRow = tb.getRow(selectedRow);
        int curCol = tb.getColumnIndex(TB_ENTRY_STORAGEORGUNIT);
        int length = inserOrgs.length;
        if (length > 0) {
            IRow curRow2 = null;
            StorageOrgUnitInfo orgInfo = null;
            boolean needInsert = false;
            int insertedRowCount = 0;
            for (int i = 0; i < length; ++i) {
                if (needInsert) {
                    this.insertLine(selectedRow + insertedRowCount);
                    needInsert = false;
                }
                orgInfo = inserOrgs[i];
                curRow2 = tb.getRow(selectedRow + insertedRowCount);
                curRow2.getCell(curCol).setValue(null);
                curRow2.getCell(curCol).setValue((Object)orgInfo);
                this.getUIContext().put("STORG.ID", orgInfo.getId().toString());
                if (inserOrgs[i] == null) {
                    return;
                }
                needInsert = true;
                ++insertedRowCount;
            }
            if (!needInsert && insertedRowCount > 0) {
                this.removeLine(tb, selectedRow + insertedRowCount);
            }
            this.afterInsertExecStorageOrgUnits(selectedRow, inserOrgs);
        } else if (oldOrg == null) {
            curRow.getCell(curCol).setValue((Object)new StorageOrgUnitInfo());
            curRow.getCell(curCol).setValue(null);
            bizStorageOrgUnitBox.setValue((Object)new StorageOrgUnitInfo());
            bizStorageOrgUnitBox.setValue(null);
        } else if (oldOrg instanceof StorageOrgUnitInfo) {
            curRow.getCell(curCol).setValue((Object)new StorageOrgUnitInfo());
            curRow.getCell(curCol).setValue(oldOrg);
            bizStorageOrgUnitBox.setValue((Object)new StorageOrgUnitInfo());
            bizStorageOrgUnitBox.setValue(oldOrg);
        }
        bizStorageOrgUnitBox.addDataChangeListener(this.prmtStorageOrgUnitListener);
    }

    private void procMRPChangeProcess(ChangeEvent e) throws EASBizException, BOSException {
        this.loadPlanVersionSet();
    }

    private void afterInsertExecStorageOrgUnits(int selectedRow, StorageOrgUnitInfo[] storageOrgUnitInfos) throws EASBizException, BOSException {
        Locale locale = this.getLocale();
        KDTable tb = this.getDetailTable();
        HashMap map = MultiOrgPlanFactory.getRemoteInstance().getPlanVerSet(storageOrgUnitInfos);
        if (map == null) {
            map = new HashMap();
        }
        int curRow = selectedRow;
        PlanVersionSetInfo planVerSet = null;
        IRow row = null;
        MultiOrgPlanEntryInfo info = null;
        for (int i = 0; i < storageOrgUnitInfos.length; ++i) {
            planVerSet = (PlanVersionSetInfo)map.get(storageOrgUnitInfos[i].getId().toString());
            if (planVerSet != null) {
                row = tb.getRow(curRow);
                info = (MultiOrgPlanEntryInfo)row.getUserObject();
                tb.getCell(curRow, TB_ENTRY_PLANVERSETNAME).setValue((Object)planVerSet.getName(locale));
                tb.getCell(curRow, TB_ENTRY_PLANVERSETNUM).setValue((Object)planVerSet);
                tb.getCell(curRow, TB_ENTRY_PLANNINGHORIZON).setValue((Object)planVerSet.getPlanningHorizon().getName(locale));
                tb.getRow(curRow).getCell("planningHorizonNumber").setValue((Object)planVerSet.getPlanningHorizon().getNumber());
                tb.getCell(curRow, "planVerSetId").setValue((Object)planVerSet);
                info.setPlanVersionSet(planVerSet);
            } else {
                tb.getRow(selectedRow).getCell(TB_ENTRY_PLANVERSETNUM).setValue(null);
                tb.getRow(selectedRow).getCell(TB_ENTRY_PLANVERSETNAME).setValue(null);
                tb.getRow(selectedRow).getCell(TB_ENTRY_PLANNINGHORIZON).setValue(null);
                tb.getRow(selectedRow).getCell("planningHorizonNumber").setValue(null);
                tb.getRow(selectedRow).getCell(TB_ENTRY_REMARK).setValue(null);
            }
            ++curRow;
        }
    }

    private Set getTableStorageOrgMap() {
        HashSet<String> set = null;
        KDTable tb = this.getDetailTable();
        StorageOrgUnitInfo orgInfo = null;
        for (int i = 0; i < tb.getRowCount(); ++i) {
            orgInfo = (StorageOrgUnitInfo)tb.getCell(i, TB_ENTRY_STORAGEORGUNIT).getValue();
            if (orgInfo == null) continue;
            if (set == null) {
                set = new HashSet<String>();
            }
            set.add(orgInfo.getId().toString());
        }
        return set;
    }

    private Integer getSelectedRow(KDTable tb) {
        KDTSelectBlock selected = tb.getSelectManager().get();
        if (selected == null) {
            return null;
        }
        return new Integer(selected.getBeginRow());
    }

    private boolean verify() {
        if (this.prmtStorageOrgUnit.getValue() == null) {
            MsgBox.showWarning((String)this.getResource("PLANING_ORG_ISNULL"));
            this.prmtStorageOrgUnit.requestFocus(true);
            return false;
        }
        if ("".equals(this.txtNumber.getText().trim()) || this.txtNumber.getText() == null) {
            MsgBox.showWarning((String)this.getResource("NUMBER_ISNULL"));
            this.txtNumber.requestFocus(true);
            return false;
        }
        if ("".equals(((String)this.txtName.getSelectedItemData()).trim()) || this.txtName.getSelectedItemData() == null) {
            MsgBox.showWarning((String)this.getResource("NAME_ISNULL"));
            this.txtName.requestFocus(true);
            return false;
        }
        if (this.kdtEntry.getRowCount() <= 0) {
            MsgBox.showWarning((String)this.getResource("EXEC_ORG_LESSTHAN_2"));
            return false;
        }
        return true;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("entry.planVersionSet.planningHorizon.name"));
        sic.add(new SelectorItemInfo("entry.planVersionSet.planningHorizon.number"));
        return sic;
    }

    private void setLockFiled() {
        if (this.getOprtState() == "ADDNEW") {
            this.txtNumber.setEnabled(true);
            this.txtNumber.setEditable(true);
            this.txtNumber.setAccessAuthority(0);
            this.txtName.setEnabled(true);
            this.txtName.setEditable(true);
            this.txtName.setAccessAuthority(0);
            this.kdtEntry.setEnabled(true);
            this.actionAddLine.setEnabled(true);
            this.actionRemoveLine.setEnabled(true);
            this.actionInsertLine.setEnabled(true);
            this.prmtStorageOrgUnit.setEnabled(true);
            this.kdtEntry.getColumn(TB_ENTRY_CALCSEQ).getStyleAttributes().setLocked(false);
            this.kdtEntry.getColumn(TB_ENTRY_STORAGEORGUNIT).getStyleAttributes().setLocked(false);
            return;
        }
        if (this.getOprtState() == "EDIT") {
            String id = this.editData.getId().toString();
            try {
                boolean hasRunLog = MultiOrgPlanFactory.getRemoteInstance().isMultiOrgPlanHasRunlog(id);
                boolean isEnable = false;
                isEnable = !hasRunLog;
                if (isEnable) {
                    this.txtNumber.setAccessAuthority(0);
                    this.txtName.setAccessAuthority(0);
                    this.txtName.setEditable(true);
                } else {
                    this.txtNumber.setAccessAuthority(1);
                    this.txtName.setAccessAuthority(1);
                }
                this.kdtEntry.getColumn(TB_ENTRY_CALCSEQ).getStyleAttributes().setLocked(!isEnable);
                this.kdtEntry.getColumn(TB_ENTRY_STORAGEORGUNIT).getStyleAttributes().setLocked(!isEnable);
                this.kdtEntry.getColumn(TB_ENTRY_REMARK).getStyleAttributes().setLocked(!isEnable);
                KDTableHelper.downArrowAutoAddRow((KDTable)this.kdtEntry, (boolean)isEnable, null);
                KDTableHelper.updateEnterWithTab((KDTable)this.kdtEntry, (boolean)isEnable);
                this.actionAddLine.setEnabled(isEnable);
                this.actionRemoveLine.setEnabled(isEnable);
                this.actionInsertLine.setEnabled(isEnable);
                this.prmtStorageOrgUnit.setAccessAuthority(1);
            }
            catch (EASBizException e) {
                this.handUIException(e);
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        } else if (this.getOprtState() == "VIEW") {
            this.actionSave.setEnabled(false);
        }
    }

    protected void afterMainOrgChanged(String arg0, String arg1) {
        super.afterMainOrgChanged(arg0, arg1);
    }

    protected KDTable getDetailTable() {
        return this.kdtEntry;
    }

    protected IObjectValue createNewData() {
        MultiOrgPlanInfo info = new MultiOrgPlanInfo();
        StorageOrgUnitInfo storageOrgInfo = (StorageOrgUnitInfo)this.getDefaultMainBizOrg();
        info.setStorageOrgUnit(storageOrgInfo);
        info.setPlanCalcType(PlanningCalcTypeEnum.MPS_GLOBAL);
        info.setIsCalcLvlCode(true);
        info.setIsBomCheck(true);
        info.setBaseStatus(BillBaseStatusEnum.ADD);
        KDTable tb = this.getDetailTable();
        MultiOrgPlanEntryInfo entry = (MultiOrgPlanEntryInfo)this.createNewDetailData(tb);
        info.getEntry().add(entry);
        return info;
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        int rowCount = table.getRowCount();
        int maxSeq = 0;
        Integer seq = null;
        for (int i = 0; i < rowCount; ++i) {
            seq = (Integer)table.getCell(i, TB_ENTRY_CALCSEQ).getValue();
            if (seq == null || seq <= maxSeq) continue;
            maxSeq = seq;
        }
        MultiOrgPlanEntryInfo entry = new MultiOrgPlanEntryInfo();
        entry.setCalcSeq(maxSeq + 1);
        return entry;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return MultiOrgPlanFactory.getRemoteInstance();
    }

    protected KDBizPromptBox getMainBizOrg() {
        return this.prmtStorageOrgUnit;
    }

    public KDBizPromptBox getMainOrgUnit() {
        return this.prmtStorageOrgUnit;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    public KDTextField getNumTextField() {
        return new KDTextField();
    }

    protected boolean isAutoNumber() throws Exception {
        return false;
    }

    protected String getPermissionItem(String status) {
        if ("ADDNEW".equals(status)) {
            return "mm_multiOrgPlan_addnew";
        }
        if ("EDIT".equals(status)) {
            return "mm_multiOrgPlan_update";
        }
        if ("VIEW".equals(status)) {
            return "mm_multiOrgPlan_view";
        }
        return null;
    }

    protected String getResource(String key) {
        return EASResource.getString((String)RESOURCE, (String)key);
    }

    protected void removeLine(KDTable table) {
        if (table == null) {
            return;
        }
        if (table.getSelectManager().size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
            return;
        }
        if (this.confirmRemove()) {
            int i;
            int size = table.getSelectManager().size();
            KDTSelectBlock selectBlock = null;
            KDTSelectBlock tempBlock = null;
            IRow iRow = null;
            Vector<KDTSelectBlock> vtemp = new Vector<KDTSelectBlock>(0);
            for (i = 0; i < size; ++i) {
                selectBlock = table.getSelectManager().get(i);
                boolean find = false;
                for (int j = 0; j < vtemp.size(); ++j) {
                    tempBlock = (KDTSelectBlock)vtemp.get(j);
                    if (selectBlock.getTop() > tempBlock.getTop()) continue;
                    vtemp.add(j, selectBlock);
                    find = true;
                    break;
                }
                if (find) continue;
                vtemp.add(selectBlock);
            }
            for (i = size - 1; i >= 0; --i) {
                selectBlock = (KDTSelectBlock)vtemp.get(i);
                for (int j = selectBlock.getBottom(); j >= selectBlock.getTop(); --j) {
                    iRow = table.getRow(j);
                    if (iRow == null) {
                        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
                        return;
                    }
                    IObjectValue detailData = (IObjectValue)iRow.getUserObject();
                    this.beforeRemoveLine(table, detailData);
                    table.removeRow(j);
                    IObjectCollection collection = (IObjectCollection)table.getUserObject();
                    if (collection == null) {
                        logger.error((Object)"collection not be binded to table");
                    } else {
                        int index = -1;
                        if (detailData != null) {
                            if (collection != null) {
                                for (int j1 = collection.size() - 1; j1 >= 0; --j1) {
                                    if (detailData != collection.getObject(j1)) continue;
                                    index = j1;
                                    break;
                                }
                            }
                            if (index != -1) {
                                collection.removeObject(index);
                            }
                        }
                    }
                    this.afterRemoveLine(table, detailData);
                }
            }
        }
    }

    private void showProgressDialog() throws Exception {
        ProgressDialog dialog = ProgressDialog.getDialogInstance((Object)this);
        dialog.show();
    }

    private void openRunLogUI(String runLogId) throws Exception {
        StorageOrgUnitInfo orgInfo = (StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue();
        PermissionHelper.checkFunctionPermission((IObjectPK)this.getUserPk(), (IObjectPK)new ObjectUuidPK(orgInfo.getId().toString()), (String)"mm_multiOrgPlan_run");
        if (this.application != null) {
            this.application.setRefresh("com.kingdee.eas.mm.planning.client.MultiOrgPlanRunLogUI");
            Context ctx = new Context();
            ctx.put((Object)"isFromMultiOrgPlanUI", (Object)new Boolean(true));
            ctx.put((Object)"multiOrgPlanRunLogId", (Object)runLogId);
            ctx.put((Object)"planStorageOrgUnit.id", (Object)orgInfo.getId().toString());
            this.application.setContext(ctx);
            this.application.getView().changePage(2);
        } else {
            String uiClassName = "com.kingdee.eas.mm.planning.client.MultiOrgPlanRunLogUI";
            UIContext ctx = new UIContext((Object)this);
            ctx.put((Object)"isFromMultiOrgPlanUI", (Object)new Boolean(true));
            ctx.put((Object)"multiOrgPlanRunLogId", (Object)runLogId);
            ctx.put((Object)"UIClassParam", (Object)"1");
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(uiClassName, (Map)ctx, null, OprtState.VIEW);
            MultiOrgPlanRunLogUI logUI = (MultiOrgPlanRunLogUI)uiWindow.getUIObject();
            logUI.setIsNeedDefaultFilter(false);
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit1.id", (Object)orgInfo.getId().toString(), CompareType.EQUALS));
            logUI.getMainQuery().setFilter(filterInfo);
            logUI.refreshList();
            uiWindow.show();
        }
    }

    public void attach(CombinUIApplication app) {
        this.application = app;
    }

    @Override
    public void actionRunMPS_actionPerformed(ActionEvent e) throws Exception {
        logger.info((Object)"MultiOrgPlan start run.");
        MultiOrgPlanInfo multiOrgPlan = (MultiOrgPlanInfo)this.getDataObject();
        this.runLogId = MultiOrgPlanFactory.getRemoteInstance().multiOrgPlanRun((IObjectValue)multiOrgPlan);
        if (this.runLogId == null) {
            logger.info((Object)"MultiOrgPlan run log ID is NULL.");
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    MultiOrgPlanUI.this.showProgressDialog();
                    MultiOrgPlanUI.this.openRunLogUI(MultiOrgPlanUI.this.runLogId);
                    if (MultiOrgPlanUI.this.application == null) {
                        MultiOrgPlanUI.this.actionExitCurrent_actionPerformed(null);
                    }
                }
                catch (Exception e) {
                    MultiOrgPlanUI.this.handUIExceptionAndAbort(e);
                }
            }
        });
    }

    public void actionRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemoveLine_actionPerformed(e);
        Integer selected = this.getSelectedRow(this.getDetailTable());
        if (selected == null) {
            return;
        }
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemove_actionPerformed(e);
        if (this.editData.getBaseStatus().equals((Object)BillBaseStatusEnum.ADD) && this.editData.getId() == null) {
            int rowCount = this.getDetailTable().getRowCount();
            if (rowCount > 0) {
                this.getDetailTable().getCell(0, TB_ENTRY_CALCSEQ).setValue((Object)new Integer(1));
            }
            super.unLockUI();
        }
        this.resetList();
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        if (!this.verify()) {
            SysUtil.abort();
            return;
        }
        try {
            this.editData.setOperateState(1);
            super.actionSave_actionPerformed(e);
            this.setOprtState("VIEW");
            this.lockUIForViewStatus();
            this.menuItemRunMPS.setEnabled(true);
            this.btnRunMPS.setEnabled(true);
            KDTable tb = this.getDetailTable();
            tb.getSortMange().sort(tb.getColumn(TB_ENTRY_CALCSEQ).getColumnIndex(), 0);
            KDTableHelper.downArrowAutoAddRow((KDTable)this.kdtEntry, (boolean)false, null);
            KDTableHelper.updateEnterWithTab((KDTable)this.kdtEntry, (boolean)false);
            this.resetList();
        }
        catch (Exception ex) {
            if (ex instanceof EASBizException) {
                String msg = ex.getMessage();
                String[] msgArr = msg.split("\n");
                StringBuffer detail = new StringBuffer();
                if (msgArr.length > 1) {
                    for (int i = 1; i < msgArr.length; ++i) {
                        if (detail.length() > 0) {
                            detail.append("\n");
                        }
                        detail.append(msgArr[i]);
                    }
                } else {
                    detail.append(msg);
                }
                MsgBox.showDetailAndOK((Component)((Object)this), (String)this.getResource("MULTIPLAN_SAVE_FAILURE"), (String)detail.toString(), (int)2);
            } else {
                this.handUIException(ex);
            }
            SysUtil.abort();
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        this.btnRunMPS.setEnabled(false);
        this.menuItemRunMPS.setEnabled(false);
        this.initTableKeyStroke(this.kdtEntry, true);
        this.setLockFiled();
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        super.actionCopy_actionPerformed(e);
        this.txtNumber.setText(null);
        this.txtName.setSelectedItemData(null);
        this.txtNumber.setRequestFocusEnabled(true);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        int rowCount;
        super.actionAddNew_actionPerformed(e);
        if (this.editData.getBaseStatus().equals((Object)BillBaseStatusEnum.ADD) && this.editData.getId() == null && (rowCount = this.getDetailTable().getRowCount()) > 0) {
            this.getDetailTable().getCell(0, TB_ENTRY_CALCSEQ).setValue((Object)new Integer(1));
        }
        this.prmtStorageOrgUnit.setEnabled(true);
        this.setLockFiled();
        this.resetList();
    }

    public void actionPre_actionPerformed(ActionEvent e) throws Exception {
        super.actionPre_actionPerformed(e);
    }

    public void actionNext_actionPerformed(ActionEvent e) throws Exception {
        super.actionNext_actionPerformed(e);
    }

    public void actionFirst_actionPerformed(ActionEvent e) throws Exception {
        super.actionFirst_actionPerformed(e);
    }

    public void actionLast_actionPerformed(ActionEvent e) throws Exception {
        super.actionLast_actionPerformed(e);
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.actionSave_actionPerformed(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeByPK(IObjectPK pk) throws Exception {
        String tempState = this.getOprtState();
        this.setOprtState("REMOVE");
        try {
            this.pubFireVOChangeListener(pk.toString());
        }
        catch (Throwable e) {
            this.setOprtState(tempState);
            this.handUIException(e);
            this.abort();
        }
        try {
            if (!UtilRequest.isPrepare((String)"ActionRemove", (CoreUIObject)this)) {
                BatchExecuteParamsEntry entry = new BatchExecuteParamsEntry(new Class[]{IObjectPK.class}, new Object[]{pk});
                BatchExecuteParamsEntry[] paramEntries = new BatchExecuteParamsEntry[]{entry};
                BatchExecuteResult result = this.getBizInterface().batchExecute("delete", new Class[]{IObjectPK.class}, paramEntries);
                Throwable[] ex = result.getExceptions();
                if (ex.length > 0 && ex[0] != null) {
                    if (ex[0] instanceof ObjectNotFoundException) {
                        throw new EASBizException(EASBizException.CHECKEXIST);
                    }
                    MsgBox.showWarning((String)ExceptionMessageUtility.getMessage((Throwable)ex[0]));
                    this.prmtStorageOrgUnit.requestFocus();
                    this.abort();
                }
            }
        }
        finally {
            this.setOprtState(tempState);
            this.initOldData(null);
        }
        if (this.idList.size() > 1) {
            this.editData = null;
            this.setDataObject(null);
            if (this.actionNext.isEnabled()) {
                this.actionNext_actionPerformed(null);
            } else {
                this.actionPre_actionPerformed(null);
            }
            this.idList.remove(pk.toString(), false);
            this.initScrollButtons();
        } else {
            this.idList.remove(pk.toString(), false);
            try {
                this.setOprtState("RELEASEALL");
                this.pubFireVOChangeListener(pk.toString());
            }
            catch (Throwable e1) {
                logger.error((Object)("pubFireVOChangeListener() error! :" + e1));
            }
            this.setOprtState("ADDNEW");
            IObjectValue value = this.createNewData();
            if (value != null) {
                this.setDataObject(value);
            } else {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.confirm_close"));
                this.destroyWindow();
            }
            this.loadFields();
            if (this.idList.size() == 0) {
                this.actionEdit.setEnabled(false);
            }
        }
        this.setSave(true);
        this.setSaved(true);
    }

    private void resetList() {
        if (this.application != null) {
            this.application.setRefresh("com.kingdee.eas.mm.planning.client.MultiOrgPlanListUI");
        }
    }
}

