/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.client;

import com.kingdee.bos.ctrl.swing.event.CommitEvent;
import com.kingdee.bos.ctrl.swing.event.CommitListener;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.mm.planning.SrcTypeEnum;
import com.kingdee.eas.mm.planning.client.AbstractPLCFilterUI;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class PLCFilterUI
extends AbstractPLCFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(PLCFilterUI.class);
    public static final String RES_SCHEDULING = "com.kingdee.eas.mm.planning.ProductionLineSchedulingResource";
    private DataChangeListener workShopChangeListener = null;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        HashMap<String, Object> filterMap = new HashMap<String, Object>();
        filterMap.put("storageOrgUnit", (StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue());
        filterMap.put("workShop", this.prmtWorkShop.getValue());
        filterMap.put("productLine", this.prmtProductLine.getValue());
        filterMap.put("material", this.prmtMaterial.getValue());
        filterMap.put("srcType", this.cmbSrcType.getSelectedItem());
        this.getUIContext().put("filterMap", filterMap);
        this.disposeUIWindow();
    }

    public void onLoad() throws Exception {
        StorageOrgUnitInfo storageOrgUnit = (StorageOrgUnitInfo)this.getUIContext().get("storageOrgUnit");
        this.prmtStorageOrgUnit.setValue((Object)storageOrgUnit);
        this.prmtStorageOrgUnit.setEnabled(false);
        Set materialSet = (Set)this.getUIContext().get("materials");
        Set productLineSet = (Set)this.getUIContext().get("productLines");
        Set workShopSet = (Set)this.getUIContext().get("workShops");
        this.initWorkShopF7(workShopSet);
        this.initProductLineF7(productLineSet);
        this.initMaterialF7(materialSet);
        this.prmtWorkShop.setValue(null);
        this.prmtProductLine.setValue(null);
        this.prmtMaterial.setValue(null);
        this.cmbSrcType.setSelectedItem((Object)SrcTypeEnum.ALL);
        this.initPrmtWorkShopListener();
    }

    protected void initPrmtWorkShopListener() {
        if (this.workShopChangeListener == null) {
            this.workShopChangeListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent e) {
                    try {
                        PLCFilterUI.this.prmtWorkShop_changed(e);
                    }
                    catch (Exception exc) {
                        PLCFilterUI.this.handUIException(exc);
                    }
                }
            };
        }
        this.prmtWorkShop.addDataChangeListener(this.workShopChangeListener);
    }

    private void prmtWorkShop_changed(DataChangeEvent e) {
        if (this.prmtWorkShop.getValue() != null && this.prmtWorkShop.getText() != null && this.prmtWorkShop.getText().length() > 0) {
            HashSet<String> set = new HashSet<String>();
            for (int i = 0; i < ((Object[])this.prmtWorkShop.getValue()).length; ++i) {
                AdminOrgUnitInfo workShop = (AdminOrgUnitInfo)((Object[])this.prmtWorkShop.getValue())[i];
                set.add(workShop.getId().toString());
                this.changProductLineF7(set);
            }
        }
    }

    private void initWorkShopF7(Set workShopSet) throws Exception {
        this.prmtWorkShop.setEnabledMultiSelection(true);
        this.prmtWorkShop.setDisplayFormat("$name$");
        this.prmtWorkShop.setEditFormat("$number$");
        this.prmtWorkShop.setCommitFormat("$number$");
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)workShopSet, CompareType.INCLUDE));
        viewInfo.setFilter(filterInfo);
        this.prmtWorkShop.setEntityViewInfo(viewInfo);
    }

    private void initProductLineF7(Set productLineSet) throws Exception {
        this.prmtProductLine.setEnabledMultiSelection(true);
        this.prmtProductLine.setDisplayFormat("$name$");
        this.prmtProductLine.setEditFormat("$number$");
        this.prmtProductLine.setCommitFormat("$number$");
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)productLineSet, CompareType.INCLUDE));
        viewInfo.setFilter(filterInfo);
        this.prmtProductLine.setEntityViewInfo(viewInfo);
    }

    private void changProductLineF7(Set workshopSet) {
        EntityViewInfo viewInfo = this.prmtProductLine.getEntityViewInfo();
        FilterInfo filterInfo = viewInfo.getFilter();
        filterInfo.getFilterItems().add(new FilterItemInfo("workshop.id", (Object)workshopSet, CompareType.INCLUDE));
        viewInfo.setFilter(filterInfo);
        this.prmtProductLine.setEntityViewInfo(viewInfo);
    }

    private void initMaterialF7(Set materialSet) throws Exception {
        this.prmtMaterial.setEnabledMultiSelection(true);
        this.prmtMaterial.setDisplayFormat("$name$");
        this.prmtMaterial.setEditFormat("$number$");
        this.prmtMaterial.setCommitFormat("$number$");
        final Set mSet = materialSet;
        this.prmtMaterial.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                PLCFilterUI.this.prmtMaterial.getQueryAgent().setDefaultFilterInfo(null);
                EntityViewInfo viewInfo = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)mSet, CompareType.INCLUDE));
                viewInfo.setFilter(filter);
                PLCFilterUI.this.prmtMaterial.setEntityViewInfo(viewInfo);
                PLCFilterUI.this.prmtMaterial.getQueryAgent().resetRuntimeEntityView();
            }
        });
        this.prmtMaterial.addCommitListener(new CommitListener(){

            public void willCommit(CommitEvent e) {
                PLCFilterUI.this.prmtMaterial.getQueryAgent().setDefaultFilterInfo(null);
                EntityViewInfo viewInfo = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)mSet, CompareType.INCLUDE));
                viewInfo.setFilter(filter);
                PLCFilterUI.this.prmtMaterial.setEntityViewInfo(viewInfo);
                PLCFilterUI.this.prmtMaterial.getQueryAgent().resetRuntimeEntityView();
            }
        });
    }
}

