/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.mm.common.client.MMRangeFilterElement;
import com.kingdee.eas.mm.common.client.MMUtils;
import com.kingdee.eas.mm.common.client.UIHelper;
import com.kingdee.eas.mm.planning.DayAbilityPlanUserPermFactory;
import com.kingdee.eas.mm.planning.IDayAbilityPlanUserPerm;
import com.kingdee.eas.mm.planning.client.AbstractPLSBatchFilterUI;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.QueryFilterManager;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.scm.common.util.F7ContextManager;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.common.verify.VerifyItem;
import com.kingdee.eas.scm.common.verify.VerifyType;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.sql.Timestamp;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class PLSBatchFilterUI
extends AbstractPLSBatchFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(PLSBatchFilterUI.class);
    private static final String PLSBATCH_RESOURCE = "com.kingdee.eas.mm.planning.PLSBatchResource";
    private QueryFilterManager manager = new QueryFilterManager();
    private CustomerParams params = null;
    private static final String FILTER_PROP_STORAGEORGUNIT = "parent.storageOrgUnit.number";
    private static final String FILTER_PROP_PLSEBEGINDATE = "beginDate";
    private static final String FILTER_PROP_NUMBER = "parent.number";
    private static final String FILTER_PROP_WORKSHOP = "productLine.workshop.number";
    private static final String FILTER_PROP_PRODUCTLINE = "productLine.number";
    private static final String FILTER_PROP_MATERIAL = "material.number";
    private static final String FILTER_PROP_PLSESTATUS = "baseStatus";
    private static final String FILTER_PROP_LINESCHEDULINGMODEL = "parent.plSModel.number";
    private Set workshopSet = null;
    protected F7ContextManager f7Manager = new F7ContextManager((Component)((Object)this), this.getMainBizOrgType(), 1);
    private DataChangeListener storageOrgUnitChanged = null;
    private DataChangeListener workshopChanged = null;

    public void onLoad() throws Exception {
        this.removeListener();
        super.onLoad();
        SCMClientUtils.setMainBizOrgF7((KDBizPromptBox)this.prmtStorageOrgUnit, (OrgType)OrgType.Storage, (String)"mm_PLSBatch_view");
        StorageOrgUnitInfo defaultOrgInfo = (StorageOrgUnitInfo)MMUtils.getDefaultMainBizOrg((OrgType)OrgType.Storage, (String)"mm_PLSBatch_view");
        this.prmtStorageOrgUnit.setValue((Object)defaultOrgInfo);
        if (defaultOrgInfo != null) {
            this.initWorkShop((OrgUnitInfo)defaultOrgInfo);
            this.initLineSchedulingModel(defaultOrgInfo.getId().toString());
            this.initMaterial((OrgUnitInfo)defaultOrgInfo);
            this.initBillNumber((OrgUnitInfo)defaultOrgInfo);
        }
        this.kdDateFrom.setTimeEnabled(true);
        this.kdDateTo.setTimeEnabled(true);
        this.kdDateFrom.setDatePattern(CtrlFormatUtilities.getDateTimeFormatString());
        this.kdDateTo.setDatePattern(CtrlFormatUtilities.getDateTimeFormatString());
        CompositeFilterElement elements = new CompositeFilterElement(0);
        MMRangeFilterElement element = new MMRangeFilterElement(FILTER_PROP_PLSEBEGINDATE, (Component)this.kdDateFrom, (Component)this.kdDateTo);
        element.addVerifyItem(new VerifyItem(VerifyType.LESS_EQUAL_TYPE, SCMClientUtils.getResource((String)"CompareDate")));
        element.setDefaultValue((Object)new Timestamp[]{SCMUtils.getSCMQueryTime(null, (String)"startDate"), SCMUtils.getSCMQueryTime(null, (String)"endDate")});
        elements.add((FilterElement)element);
        elements.add((FilterElement)new MMRangeFilterElement(FILTER_PROP_NUMBER, (Component)this.prmtNumberFrom, (Component)this.prmtNumberTo));
        elements.add((FilterElement)new SingleFilterElement(FILTER_PROP_WORKSHOP, (Component)this.prmtWorkshop));
        elements.add((FilterElement)new SingleFilterElement(FILTER_PROP_PRODUCTLINE, (Component)this.prmtProductline));
        elements.add((FilterElement)new MMRangeFilterElement(FILTER_PROP_MATERIAL, (Component)this.prmtMaterialFrom, (Component)this.prmtMaterialTo));
        elements.add((FilterElement)new SingleFilterElement(FILTER_PROP_LINESCHEDULINGMODEL, (Component)this.prmtLineSchedulingModel));
        SingleFilterElement mainOrgElement = new SingleFilterElement(FILTER_PROP_STORAGEORGUNIT, (Component)this.prmtStorageOrgUnit);
        mainOrgElement.addVerifyItem(new VerifyItem(VerifyType.REQUIRED_TYPE, EASResource.getString((String)PLSBATCH_RESOURCE, (String)"StorageOrgUnit_NotNull")));
        elements.add((FilterElement)mainOrgElement);
        this.getFilterManager().setElement((FilterElement)elements);
        this.getFilterManager().setMainOrgElement((FilterElement)mainOrgElement, this.getPropertyOfMainBizOrg());
        OrgUnitInfo orgInfo = (OrgUnitInfo)this.prmtStorageOrgUnit.getValue();
        UIHelper.registerBizMaterialF7((F7ContextManager)this.f7Manager, (KDBizPromptBox)this.prmtMaterialFrom, (OrgUnitInfo)orgInfo);
        UIHelper.registerBizMaterialF7((F7ContextManager)this.f7Manager, (KDBizPromptBox)this.prmtMaterialTo, (OrgUnitInfo)orgInfo);
        this.addListener();
    }

    public QueryFilterManager getFilterManager() {
        return this.manager;
    }

    protected String getPropertyOfMainBizOrg() {
        return "storageOrgUnit.id";
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void clear() {
        this.removeListener();
        this.manager.clearAll();
        this.setDefaultValue();
        this.addListener();
    }

    protected void setDefaultValue() {
        StorageOrgUnitInfo storageOrgInfo = (StorageOrgUnitInfo)MMUtils.getDefaultMainBizOrg((OrgType)this.getMainBizOrgType(), (String)"mm_PLSBatch_view");
        this.prmtStorageOrgUnit.setValue((Object)storageOrgInfo);
        this.chkIsSubmited.setSelected(true);
        this.chkIsAudited.setSelected(true);
        this.chkIsReleased.setSelected(true);
        this.chkIsPutIn.setSelected(true);
        this.chkIsFinished.setSelected(false);
        this.chkIsDeleted.setSelected(false);
    }

    public FilterInfo getFilterInfo() {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo = this.manager.getFilterInfo();
        FilterInfo statusFilter = new FilterInfo();
        HashSet<Integer> statusSet = new HashSet<Integer>();
        if (this.chkIsSubmited.isSelected()) {
            statusSet.add(new Integer(2));
        }
        if (this.chkIsAudited.isSelected()) {
            statusSet.add(new Integer(4));
        }
        if (this.chkIsReleased.isSelected()) {
            statusSet.add(new Integer(5));
        }
        if (this.chkIsPutIn.isSelected()) {
            statusSet.add(new Integer(8));
        }
        if (this.chkIsFinished.isSelected()) {
            statusSet.add(new Integer(9));
        }
        if (this.chkIsDeleted.isSelected()) {
            statusSet.add(new Integer(3));
        }
        if (statusSet.size() > 0) {
            statusFilter.getFilterItems().add(new FilterItemInfo(FILTER_PROP_PLSESTATUS, statusSet, CompareType.INCLUDE));
            try {
                filterInfo.mergeFilter(statusFilter, "AND");
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        }
        FilterInfo newFilterInfo = new FilterInfo();
        if (filterInfo.getFilterItems() != null && filterInfo.getFilterItems().size() > 0) {
            for (int i = 0; i < filterInfo.getFilterItems().size(); ++i) {
                FilterItemInfo itemInfo = filterInfo.getFilterItems().get(i);
                String propName = itemInfo.getPropertyName();
                CompareType comp = itemInfo.getCompareType();
                if (propName.equals(FILTER_PROP_PLSEBEGINDATE)) {
                    if (comp.equals((Object)CompareType.LESS_EQUALS)) {
                        itemInfo = new FilterItemInfo(FILTER_PROP_PLSEBEGINDATE, this.kdDateTo.getValue(Timestamp.class), CompareType.LESS_EQUALS);
                        newFilterInfo.getFilterItems().add(itemInfo);
                        continue;
                    }
                    if (!comp.equals((Object)CompareType.GREATER_EQUALS)) continue;
                    itemInfo = new FilterItemInfo(FILTER_PROP_PLSEBEGINDATE, this.kdDateFrom.getValue(Timestamp.class), CompareType.GREATER_EQUALS);
                    newFilterInfo.getFilterItems().add(itemInfo);
                    continue;
                }
                newFilterInfo.getFilterItems().add(itemInfo);
            }
        }
        return newFilterInfo;
    }

    public boolean verify() {
        boolean flag = this.manager.verify();
        if (!flag) {
            return false;
        }
        if (!(this.chkIsSubmited.isSelected() || this.chkIsAudited.isSelected() || this.chkIsReleased.isSelected() || this.chkIsPutIn.isSelected() || this.chkIsFinished.isSelected() || this.chkIsDeleted.isSelected())) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)PLSBATCH_RESOURCE, (String)"AtLeastSelectOneStatus"));
            return false;
        }
        return true;
    }

    public CustomerParams getCustomerParams() {
        return this.manager.getCustomerParams();
    }

    public void setCustomerParams(CustomerParams cp) {
        this.params = cp;
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmtStorageOrgUnit;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        this.removeListener();
        super.loadData(entityViewInfo);
        this.manager.clearAll();
        this.chkIsSubmited.setSelected(false);
        this.chkIsAudited.setSelected(false);
        this.chkIsReleased.setSelected(false);
        this.chkIsPutIn.setSelected(false);
        this.chkIsFinished.setSelected(false);
        this.chkIsDeleted.setSelected(false);
        this.manager.setCustomerParams(this.params, false);
        try {
            FilterInfo filterInfo;
            if (entityViewInfo != null && (filterInfo = entityViewInfo.getFilter()).getFilterItems() != null && filterInfo.getFilterItems().size() > 0) {
                for (int i = 0; i < filterInfo.getFilterItems().size(); ++i) {
                    FilterItemInfo filterItemInfo = filterInfo.getFilterItems().get(i);
                    filterItemInfo.getCompareValue();
                    if (!filterItemInfo.getPropertyName().equals(FILTER_PROP_PLSESTATUS)) continue;
                    HashSet statusSet = (HashSet)filterItemInfo.getCompareValue();
                    if (statusSet.contains(new Integer(2))) {
                        this.chkIsSubmited.setSelected(true);
                    }
                    if (statusSet.contains(new Integer(4))) {
                        this.chkIsAudited.setSelected(true);
                    }
                    if (statusSet.contains(new Integer(5))) {
                        this.chkIsReleased.setSelected(true);
                    }
                    if (statusSet.contains(new Integer(8))) {
                        this.chkIsPutIn.setSelected(true);
                    }
                    if (statusSet.contains(new Integer(9))) {
                        this.chkIsFinished.setSelected(true);
                    }
                    if (!statusSet.contains(new Integer(3))) continue;
                    this.chkIsDeleted.setSelected(true);
                }
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        this.addListener();
    }

    private void addListener() {
        this.storageOrgUnitChanged = new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    PLSBatchFilterUI.this.prmtStorageOrgUnit_datachanged(e);
                }
                catch (Exception exc) {
                    PLSBatchFilterUI.this.handUIException(exc);
                }
            }
        };
        this.prmtStorageOrgUnit.addDataChangeListener(this.storageOrgUnitChanged);
        this.workshopChanged = new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    PLSBatchFilterUI.this.prmtworkshop_dataChanged(e);
                }
                catch (Exception exc) {
                    PLSBatchFilterUI.this.handUIException(exc);
                }
            }
        };
        this.prmtWorkshop.addDataChangeListener(this.workshopChanged);
    }

    private void removeListener() {
        if (this.storageOrgUnitChanged != null) {
            this.prmtStorageOrgUnit.removeDataChangeListener(this.storageOrgUnitChanged);
        }
        if (this.workshopChanged != null) {
            this.prmtWorkshop.removeDataChangeListener(this.workshopChanged);
        }
    }

    protected void prmtStorageOrgUnit_datachanged(DataChangeEvent e) throws Exception {
        OrgUnitInfo newStorageOrgInfo;
        OrgUnitInfo oldStorageOrgInfo = (OrgUnitInfo)e.getOldValue();
        boolean isDifferent = SCMGroupClientUtils.isDiffrent((Object)oldStorageOrgInfo, (Object)(newStorageOrgInfo = (OrgUnitInfo)e.getNewValue()));
        if (isDifferent) {
            this.prmtWorkshop.removeDataChangeListener(this.workshopChanged);
            this.prmtWorkshop.setValue(null);
            this.prmtWorkshop.addDataChangeListener(this.workshopChanged);
            this.prmtProductline.setValue(null);
            this.prmtLineSchedulingModel.setValue(null);
            if (newStorageOrgInfo != null) {
                this.initWorkShop(newStorageOrgInfo);
                this.initLineSchedulingModel(newStorageOrgInfo.getId().toString());
                this.initProductLine(newStorageOrgInfo.getId().toString(), null);
                this.initMaterial(newStorageOrgInfo);
                this.initBillNumber(newStorageOrgInfo);
            } else {
                this.initProductLine(null, null);
            }
        }
    }

    protected void prmtworkshop_dataChanged(DataChangeEvent e) throws Exception {
        Object[] newWorkshop;
        Object[] oldWorkshop = (Object[])e.getOldValue();
        boolean isDifferent = SCMGroupClientUtils.isDiffrent((Object)oldWorkshop, (Object)(newWorkshop = (Object[])e.getNewValue()));
        if (isDifferent) {
            this.prmtProductline.setValue(null);
            String storageOrgID = null;
            if (this.prmtStorageOrgUnit.getValue() != null) {
                storageOrgID = ((OrgUnitInfo)this.prmtStorageOrgUnit.getValue()).getId().toString();
            }
            if (newWorkshop != null) {
                HashSet<String> workshopIds = new HashSet<String>();
                int m = newWorkshop.length;
                for (int i = 0; i < m; ++i) {
                    AdminOrgUnitInfo workshopInfo = (AdminOrgUnitInfo)newWorkshop[i];
                    if (workshopInfo == null) continue;
                    workshopIds.add(workshopInfo.getId().toString());
                }
                this.initProductLine(storageOrgID, workshopIds);
            } else {
                this.initProductLine(storageOrgID, null);
            }
        }
    }

    private void initMaterial(OrgUnitInfo orgInfo) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        String materialPlanQuery = UIHelper.getMaterialPlanQuery((int)this.f7Manager.getF7DisplayMode());
        this.prmtMaterialFrom.setQueryInfo(materialPlanQuery);
        this.prmtMaterialTo.setQueryInfo(materialPlanQuery);
        this.f7Manager.registerBizMaterialF7(this.prmtMaterialFrom, null, materialPlanQuery, orgInfo, false);
        this.f7Manager.registerBizMaterialF7(this.prmtMaterialTo, null, materialPlanQuery, orgInfo, false);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)orgInfo.getId().toString(), CompareType.EQUALS));
        viewInfo.setFilter(filter);
        this.prmtMaterialFrom.setEntityViewInfo(viewInfo);
        this.prmtMaterialTo.setEntityViewInfo(viewInfo);
        this.prmtMaterialFrom.setValue(null);
        this.prmtMaterialTo.setValue(null);
    }

    private void initBillNumber(OrgUnitInfo orgInfo) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)orgInfo.getId().toString(), CompareType.EQUALS));
        viewInfo.setFilter(filter);
        this.prmtNumberFrom.setEntityViewInfo(viewInfo);
        this.prmtNumberTo.setEntityViewInfo(viewInfo);
        this.prmtNumberFrom.setValue(null);
        this.prmtNumberTo.setValue(null);
    }

    protected void initWorkShop(OrgUnitInfo storageOrgInfo) throws Exception {
        MMUtils.initWorkshopF7((KDBizPromptBox)this.prmtWorkshop, (StorageOrgUnitInfo)((StorageOrgUnitInfo)storageOrgInfo));
        IDayAbilityPlanUserPerm iuserPerm = DayAbilityPlanUserPermFactory.getRemoteInstance();
        Map map = iuserPerm.getAuthorizedWorkshop(storageOrgInfo.getId().toString(), "VIEW");
        Set workshops = (Set)map.get("VIEW");
        FilterInfo filter = this.prmtWorkshop.getEntityViewInfo().getFilter();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)workshops, CompareType.INCLUDE));
    }

    protected void initLineSchedulingModel(String storageOrgID) throws Exception {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storageOrgID, CompareType.EQUALS));
        viewInfo.setFilter(filter);
        this.prmtLineSchedulingModel.setEntityViewInfo(viewInfo);
    }

    protected void initProductLine(String storageOrgID, Set workshopIds) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storageOrgID, CompareType.EQUALS));
        if (workshopIds != null && workshopIds.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("workshop.id", (Object)workshopIds, CompareType.INCLUDE));
        }
        viewInfo.setFilter(filter);
        this.prmtProductline.setEntityViewInfo(viewInfo);
    }
}

