/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.core.util.PrecisionUtil;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.mm.basedata.PLSModelInfo;
import com.kingdee.eas.mm.basedata.ProductLineInfo;
import com.kingdee.eas.mm.planning.IPLSRunFacade;
import com.kingdee.eas.mm.planning.PLSCapAnalyzeDataTypeEnum;
import com.kingdee.eas.mm.planning.PLSConstant;
import com.kingdee.eas.mm.planning.PLSEntryInfo;
import com.kingdee.eas.mm.planning.PLSRunFacadeFactory;
import com.kingdee.eas.mm.planning.RunResult;
import com.kingdee.eas.mm.planning.client.AbstractPLSCapAnalyzeUI;
import com.kingdee.eas.mm.planning.client.PLSCapFilterUI;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class PLSCapAnalyzeUI
extends AbstractPLSCapAnalyzeUI {
    private static final Logger logger = CoreUIObject.getLogger(PLSCapAnalyzeUI.class);
    private static final String TB_DEPARTMENT = "department";
    private static final String TB_PRODUCTLINEID = "productLineID";
    private static final String TB_PRODUCTLINENAME = "productLineName";
    private static final String TB_TYPENUMBER = "typeNumber";
    private static final String TB_DATATYPE = "dataType";
    private static final String TB_TOTAL = "total";
    private static final int FIXEDCOLUMN = 5;
    private static final int FIXEDROW = 6;
    private StorageOrgUnitInfo storageOrgUnit;
    private String voucherId;
    private PLSModelInfo pLSModelInfo;

    public void onLoad() throws Exception {
        super.onLoad();
        this.kdtMain.checkParsed();
        this.storageOrgUnit = (StorageOrgUnitInfo)this.getUIContext().get("storageOrgUnit");
        this.prmtOrgUnit.setValue((Object)this.storageOrgUnit);
        Date beginDate = (Date)this.getUIContext().get("beginDate");
        Date endDate = (Date)this.getUIContext().get("endDate");
        this.pkBeginDate.setValue((Object)beginDate);
        this.pkEndDate.setValue((Object)endDate);
        this.voucherId = (String)this.getUIContext().get("voucherID");
        this.pLSModelInfo = (PLSModelInfo)this.getUIContext().get("pLSModelInfo");
        this.actionQuery_actionPerformed(null);
    }

    private void fillData(List list) throws Exception {
        if (list != null && list.size() > 0) {
            int rowCount = this.kdtMain.getRowCount();
            int colCount = this.kdtMain.getColumnCount();
            int n = list.size();
            for (int m = 0; m < n; ++m) {
                Map map = (Map)list.get(m);
                for (int j = 5; j < colCount; ++j) {
                    String key = this.kdtMain.getColumn(j).getKey();
                    if (!key.equals(map.get("strDate"))) continue;
                    for (int i = 0; i < rowCount; i += 6) {
                        String productLineID = (String)this.kdtMain.getRow(i).getCell(TB_PRODUCTLINEID).getValue();
                        if (!productLineID.equals(map.get("productLineId"))) continue;
                        BigDecimal sumCap = PLSConstant.ZERO;
                        BigDecimal planQty = PLSConstant.ZERO;
                        BigDecimal releasedQty = PLSConstant.ZERO;
                        if (map.get("sumCap") != null) {
                            sumCap = (BigDecimal)map.get("sumCap");
                        }
                        if (map.get("planQty") != null) {
                            planQty = (BigDecimal)map.get("planQty");
                        }
                        if (map.get("releasedQty") != null) {
                            releasedQty = (BigDecimal)map.get("releasedQty");
                        }
                        BigDecimal sumQty = planQty.add(releasedQty);
                        BigDecimal diffQty = sumCap.subtract(sumQty);
                        BigDecimal diffRate = new BigDecimal(100);
                        if (sumCap.doubleValue() != 0.0) {
                            diffRate = diffQty.divide(sumCap, 4, 4).multiply(new BigDecimal(100));
                        }
                        this.kdtMain.getCell(i + 0, j).setValue((Object)sumCap);
                        this.kdtMain.getCell(i + 1, j).setValue((Object)planQty);
                        this.kdtMain.getCell(i + 2, j).setValue((Object)releasedQty);
                        this.kdtMain.getCell(i + 3, j).setValue((Object)sumQty);
                        this.kdtMain.getCell(i + 4, j).setValue((Object)diffQty);
                        this.kdtMain.getCell(i + 5, j).setValue((Object)diffRate);
                    }
                }
            }
            for (int i = 0; i < rowCount; ++i) {
                BigDecimal total = PLSConstant.ZERO;
                for (int j = 5; j < colCount - 1; ++j) {
                    total = total.add((BigDecimal)this.kdtMain.getCell(i, j).getValue());
                }
                this.kdtMain.getCell(i, TB_TOTAL).setValue((Object)total);
                if (i % 6 != 5) continue;
                BigDecimal sumCap = (BigDecimal)this.kdtMain.getCell(i - 5, TB_TOTAL).getValue();
                BigDecimal diffQty = (BigDecimal)this.kdtMain.getCell(i - 1, TB_TOTAL).getValue();
                BigDecimal diffRate = new BigDecimal(100);
                if (sumCap.doubleValue() != 0.0) {
                    diffRate = diffQty.divide(sumCap, 4, 4).multiply(new BigDecimal(100));
                }
                this.kdtMain.getCell(i, TB_TOTAL).setValue((Object)diffRate);
            }
        }
    }

    private void fillTable(Set productLineSet, List list) throws Exception {
        if (this.kdtMain.getRowCount() > 0) {
            this.kdtMain.removeRows();
        }
        while (this.kdtMain.getColumnCount() > 5) {
            this.kdtMain.removeColumn(5);
        }
        HashSet<String> dateSet = new HashSet<String>();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Map map = (Map)list.get(i);
            String strDate = (String)map.get("strDate");
            dateSet.add(strDate);
        }
        Object[] strDates = dateSet.toArray();
        Arrays.sort(strDates, new Comparator(){

            public int compare(Object o1, Object o2) {
                String key1 = (String)o1;
                String key2 = (String)o2;
                return key1.compareTo(key2);
            }
        });
        if (strDates != null && strDates.length > 0) {
            int colIndex = 5;
            int n2 = strDates.length;
            for (int i = 0; i < n2; ++i) {
                String key = (String)strDates[i];
                this.kdtMain.addColumn();
                this.kdtMain.getColumn(colIndex).setKey(key);
                this.kdtMain.getHeadRow(0).getCell(colIndex).setValue((Object)key);
                this.kdtMain.getHeadRow(0).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.CENTER);
                ++colIndex;
            }
            IColumn column = this.kdtMain.addColumn();
            column.getStyleAttributes().setLocked(true);
            column.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            String total = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Total");
            this.kdtMain.getColumn(colIndex).setKey(TB_TOTAL);
            this.kdtMain.getHeadRow(0).getCell(colIndex).setValue((Object)total);
            this.kdtMain.getHeadRow(0).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.CENTER);
            column.getStyleAttributes().setBackground(new Color(246, 246, 191));
        }
        if (productLineSet != null && productLineSet.size() > 0) {
            int rowIndex = 0;
            int left = this.kdtMain.getColumnIndex(TB_DEPARTMENT);
            int right = this.kdtMain.getColumnIndex(TB_PRODUCTLINENAME);
            for (ProductLineInfo productLine : productLineSet) {
                int top = rowIndex;
                int bottom = top + 6 - 1;
                int colCount = this.kdtMain.getColumnCount();
                for (int i = 0; i < 6; ++i) {
                    IRow row = this.kdtMain.addRow();
                    row.getCell(TB_DEPARTMENT).setValue((Object)productLine.getWorkshop().getName());
                    row.getCell(TB_PRODUCTLINEID).setValue((Object)productLine.getId().toString());
                    row.getCell(TB_PRODUCTLINENAME).setValue((Object)productLine.getName());
                    row.getCell(TB_TYPENUMBER).setValue((Object)PLSCapAnalyzeDataTypeEnum.getEnum(i));
                    row.getCell(TB_DATATYPE).setValue((Object)PLSCapAnalyzeDataTypeEnum.getEnum(i).getAlias());
                    for (int j = 5; j < colCount; ++j) {
                        this.initPrecisions(row.getCell(j), i);
                    }
                    ++rowIndex;
                }
                this.kdtMain.getMergeManager().mergeBlock(top, left, bottom, left);
                this.kdtMain.getMergeManager().mergeBlock(top, right, bottom, right);
            }
        }
    }

    private void initPrecisions(ICell cell, int dateType) throws Exception {
        cell.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        if (dateType == 5) {
            cell.getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatString((int)2));
        } else {
            cell.getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDecimalFormatString());
        }
        cell.getStyleAttributes().setLocked(true);
    }

    @Override
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"analyzeSrc", (Object)"PLS");
        uiContext.put((Object)"storageOrgUnit", (Object)this.storageOrgUnit);
        uiContext.put((Object)"beginDate", this.pkBeginDate.getValue());
        uiContext.put((Object)"endDate", this.pkEndDate.getValue());
        List pLSList = (List)this.getUIContext().get("pLSList");
        Set workShopSet = this.getWorkShops(pLSList);
        uiContext.put((Object)"workShopSet", (Object)workShopSet);
        Set productLineSet = this.getProductLines(pLSList);
        uiContext.put((Object)"productLineSet", (Object)productLineSet);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(PLSCapFilterUI.class.getName(), (Map)uiContext);
        uiWindow.show();
        PLSCapFilterUI filterUI = (PLSCapFilterUI)uiWindow.getUIObject();
        boolean isQuery = false;
        if (filterUI.getUIContext().get("isQuery") != null) {
            isQuery = (Boolean)filterUI.getUIContext().get("isQuery");
        }
        if (isQuery) {
            PLSEntryInfo pLSInfo;
            Iterator ite;
            HashMap<String, Object> filterMap = new HashMap<String, Object>();
            Set productLines = (Set)filterUI.getUIContext().get("productLines");
            Set workShops = (Set)filterUI.getUIContext().get("workShops");
            if (productLines != null && productLines.size() > 0) {
                ite = pLSList.iterator();
                while (ite.hasNext()) {
                    pLSInfo = (PLSEntryInfo)ite.next();
                    if (productLines.contains(pLSInfo.getProductLine().getId().toString())) continue;
                    ite.remove();
                }
            } else if (workShops != null && workShops.size() > 0) {
                ite = pLSList.iterator();
                while (ite.hasNext()) {
                    pLSInfo = (PLSEntryInfo)ite.next();
                    if (workShops.contains(pLSInfo.getWorkShop().getId().toString())) continue;
                    ite.remove();
                }
            }
            Timestamp beginDate = (Timestamp)filterUI.getUIContext().get("beginDate");
            Timestamp endDate = (Timestamp)filterUI.getUIContext().get("endDate");
            this.pkBeginDate.setValue((Object)beginDate);
            this.pkEndDate.setValue((Object)endDate);
            filterMap.put("beginDate", beginDate);
            filterMap.put("endDate", endDate);
            filterMap.put("srcList", pLSList);
            filterMap.put("analyzeSrc", "PLS");
            IPLSRunFacade iPLSRunFacade = PLSRunFacadeFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
            RunResult result = iPLSRunFacade.capAnalyze(this.storageOrgUnit, filterMap, this.voucherId, this.pLSModelInfo);
            List list = result.getReturnList();
            if (list != null && list.size() > 0) {
                Set lineSet = this.getProductLines(pLSList, productLines);
                this.fillTable(lineSet, list);
                this.fillData(list);
            }
        } else {
            this.abort();
        }
    }

    private Set getProductLines(List pLSList, Set productLines) {
        HashSet<ProductLineInfo> set = new HashSet<ProductLineInfo>();
        if (productLines != null && productLines.size() > 0) {
            int n = pLSList.size();
            for (int i = 0; i < n; ++i) {
                PLSEntryInfo pLSInfo = (PLSEntryInfo)pLSList.get(i);
                String productLineId = pLSInfo.getProductLine().getId().toString();
                if (!productLines.contains(productLineId)) continue;
                set.add(pLSInfo.getProductLine());
            }
        } else {
            int n = pLSList.size();
            for (int i = 0; i < n; ++i) {
                PLSEntryInfo pLSInfo = (PLSEntryInfo)pLSList.get(i);
                set.add(pLSInfo.getProductLine());
            }
        }
        return set;
    }

    private Set getProductLines(List pLSList) {
        HashSet<String> productLineSet = new HashSet<String>();
        int n = pLSList.size();
        for (int i = 0; i < n; ++i) {
            PLSEntryInfo pLSInfo = (PLSEntryInfo)pLSList.get(i);
            productLineSet.add(pLSInfo.getProductLine().getId().toString());
        }
        return productLineSet;
    }

    private Set getWorkShops(List pLSList) {
        HashSet<String> workShopSet = new HashSet<String>();
        int n = pLSList.size();
        for (int i = 0; i < n; ++i) {
            PLSEntryInfo pLSInfo = (PLSEntryInfo)pLSList.get(i);
            workShopSet.add(pLSInfo.getWorkShop().getId().toString());
        }
        return workShopSet;
    }
}

