/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.client;

import com.kingdee.bos.ctrl.swing.event.CommitEvent;
import com.kingdee.bos.ctrl.swing.event.CommitListener;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.mm.basedata.BooleanAllEnum;
import com.kingdee.eas.mm.basedata.PLSModelCollection;
import com.kingdee.eas.mm.basedata.PLSModelFactory;
import com.kingdee.eas.mm.basedata.PLSModelInfo;
import com.kingdee.eas.mm.planning.SrcTypeEnum;
import com.kingdee.eas.mm.planning.client.AbstractPLSFilterUI;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class PLSFilterUI
extends AbstractPLSFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(PLSFilterUI.class);
    public static final String RES_SCHEDULING = "com.kingdee.eas.mm.planning.ProductionLineSchedulingResource";
    private final int TYPE_BEGINDATE = 0;
    private final int TYPE_ENDDATE = 1;
    private DataChangeListener workShopChangeListener = null;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    private Timestamp setDateTime(Date date, int Type2) {
        if (date == null) {
            return null;
        }
        Calendar ca = Calendar.getInstance();
        ca.setTime(date);
        if (Type2 == 0) {
            ca.set(11, 0);
            ca.set(12, 0);
            ca.set(13, 0);
            ca.set(14, 0);
        } else {
            ca.set(11, 23);
            ca.set(12, 59);
            ca.set(13, 59);
            ca.set(14, 0);
        }
        return new Timestamp(ca.getTimeInMillis());
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        this.checkData();
        HashMap<String, Object> filterMap = new HashMap<String, Object>();
        filterMap.put("storageOrgUnit", (StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue());
        Timestamp beginDate = this.setDateTime((Date)this.kdDateFrom.getValue(), 0);
        Timestamp endDate = this.setDateTime((Date)this.kdDateTo.getValue(), 1);
        filterMap.put("beginDate", beginDate);
        filterMap.put("endDate", endDate);
        filterMap.put("workShop", this.prmtWorkShop.getValue());
        filterMap.put("productLine", this.prmtProductLine.getValue());
        filterMap.put("material", this.prmtMaterial.getValue());
        filterMap.put("srcType", this.cmbSrcType.getSelectedItem());
        filterMap.put("isSubmit", new Boolean(this.chkIsSubmit.isSelected()));
        filterMap.put("isAudit", new Boolean(this.chkIsAudit.isSelected()));
        filterMap.put("isReleased", new Boolean(this.chkIsReleased.isSelected()));
        filterMap.put("isPutIn", new Boolean(this.chkIsPutIn.isSelected()));
        filterMap.put("isFinish", new Boolean(this.chkIsFinish.isSelected()));
        filterMap.put("isDelete", new Boolean(this.chkIsDelete.isSelected()));
        filterMap.put("isSubPlan", this.isSubPlan.getSelectedItem());
        filterMap.put("isExpand", this.isExpand.getSelectedItem());
        this.getUIContext().put("filterMap", filterMap);
        this.disposeUIWindow();
    }

    private void checkData() {
        if (!(this.chkIsSubmit.isSelected() || this.chkIsAudit.isSelected() || this.chkIsReleased.isSelected() || this.chkIsPutIn.isSelected() || this.chkIsFinish.isSelected() || this.chkIsDelete.isSelected())) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"14_PLSFilterUI"));
            SysUtil.abort();
        }
        Timestamp beginDate = this.setDateTime((Date)this.kdDateFrom.getValue(), 0);
        Timestamp endDate = this.setDateTime((Date)this.kdDateTo.getValue(), 1);
        if (endDate != null && beginDate != null && endDate.before(beginDate)) {
            MsgBox.showInfo((Component)((Object)this), (String)SCMClientUtils.getResource((String)"CompareDate"));
            SysUtil.abort();
        }
    }

    public void onLoad() throws Exception {
        StorageOrgUnitInfo storageOrgUnit = (StorageOrgUnitInfo)this.getUIContext().get("storageOrgUnit");
        this.prmtStorageOrgUnit.setValue((Object)storageOrgUnit);
        this.prmtStorageOrgUnit.setEnabled(false);
        Date beginDate = (Date)this.getUIContext().get("beginDate");
        Date endDate = (Date)this.getUIContext().get("endDate");
        if (this.getUIContext().get("PLSModel") != null) {
            PLSModelInfo PLSMI = (PLSModelInfo)this.getUIContext().get("PLSModel");
            EntityViewInfo viewInfo = new EntityViewInfo();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("isDateBefAbility"));
            viewInfo.setSelector(sic);
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)PLSMI.getId(), CompareType.EQUALS));
            viewInfo.setFilter(filterInfo);
            PLSModelCollection Collection2 = PLSModelFactory.getRemoteInstance().getPLSModelCollection(viewInfo);
            Boolean isDateBefAbility = true;
            if (Collection2 != null || Collection2.size() != 0) {
                isDateBefAbility = Collection2.get(0).getBoolean("isDateBefAbility");
                if (isDateBefAbility.booleanValue()) {
                    Calendar calDate = Calendar.getInstance();
                    calDate.set(11, 0);
                    calDate.set(12, 0);
                    calDate.set(13, 0);
                    calDate.set(14, 0);
                    beginDate = new Date(calDate.getTimeInMillis());
                    endDate = (Date)this.getUIContext().get("endDate");
                } else {
                    beginDate = (Date)this.getUIContext().get("beginDate");
                    endDate = (Date)this.getUIContext().get("endDate");
                }
            }
        }
        this.kdDateFrom.setValue((Object)beginDate);
        this.kdDateTo.setValue((Object)endDate);
        Set materialSet = (Set)this.getUIContext().get("materials");
        Set productLineSet = (Set)this.getUIContext().get("productLines");
        Set workShopSet = (Set)this.getUIContext().get("workShops");
        this.isSubPlan.setSelectedItem((Object)BooleanAllEnum.All);
        this.isExpand.setSelectedItem((Object)BooleanAllEnum.All);
        this.cmbSrcType.setSelectedItem((Object)SrcTypeEnum.ALL);
        this.initWorkShopF7(workShopSet);
        this.initProductLineF7(productLineSet);
        this.initMaterialF7(materialSet);
        this.prmtWorkShop.setValue(null);
        this.prmtProductLine.setValue(null);
        this.prmtMaterial.setValue(null);
        this.initPrmtWorkShopListener();
    }

    protected void initPrmtWorkShopListener() {
        if (this.workShopChangeListener == null) {
            this.workShopChangeListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent e) {
                    try {
                        PLSFilterUI.this.prmtWorkShop_changed(e);
                    }
                    catch (Exception exc) {
                        PLSFilterUI.this.handUIException(exc);
                    }
                }
            };
        }
        this.prmtWorkShop.addDataChangeListener(this.workShopChangeListener);
    }

    private void prmtWorkShop_changed(DataChangeEvent e) {
        if (this.prmtWorkShop.getValue() != null && this.prmtWorkShop.getText() != null && this.prmtWorkShop.getText().length() > 0) {
            HashSet<String> set = new HashSet<String>();
            for (int i = 0; i < ((Object[])this.prmtWorkShop.getValue()).length; ++i) {
                AdminOrgUnitInfo workShop = (AdminOrgUnitInfo)((Object[])this.prmtWorkShop.getValue())[i];
                set.add(workShop.getId().toString());
                this.changProductLineF7(set);
            }
        }
    }

    private void initWorkShopF7(Set workShopSet) throws Exception {
        this.prmtWorkShop.setEnabledMultiSelection(true);
        this.prmtWorkShop.setDisplayFormat("$name$");
        this.prmtWorkShop.setEditFormat("$number$");
        this.prmtWorkShop.setCommitFormat("$number$");
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)workShopSet, CompareType.INCLUDE));
        viewInfo.setFilter(filterInfo);
        this.prmtWorkShop.setEntityViewInfo(viewInfo);
    }

    private void initProductLineF7(Set productLineSet) throws Exception {
        this.prmtProductLine.setEnabledMultiSelection(true);
        this.prmtProductLine.setDisplayFormat("$name$");
        this.prmtProductLine.setEditFormat("$number$");
        this.prmtProductLine.setCommitFormat("$number$");
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)productLineSet, CompareType.INCLUDE));
        viewInfo.setFilter(filterInfo);
        this.prmtProductLine.setEntityViewInfo(viewInfo);
    }

    private void changProductLineF7(Set workshopSet) {
        EntityViewInfo viewInfo = this.prmtProductLine.getEntityViewInfo();
        FilterInfo filterInfo = viewInfo.getFilter();
        filterInfo.getFilterItems().add(new FilterItemInfo("workshop.id", (Object)workshopSet, CompareType.INCLUDE));
        viewInfo.setFilter(filterInfo);
        this.prmtProductLine.setEntityViewInfo(viewInfo);
    }

    private void initMaterialF7(Set materialSet) throws Exception {
        this.prmtMaterial.setEnabledMultiSelection(true);
        this.prmtMaterial.setDisplayFormat("$name$");
        this.prmtMaterial.setEditFormat("$number$");
        this.prmtMaterial.setCommitFormat("$number$");
        final Set mSet = materialSet;
        this.prmtMaterial.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                PLSFilterUI.this.prmtMaterial.getQueryAgent().setDefaultFilterInfo(null);
                EntityViewInfo viewInfo = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)mSet, CompareType.INCLUDE));
                viewInfo.setFilter(filter);
                PLSFilterUI.this.prmtMaterial.setEntityViewInfo(viewInfo);
                PLSFilterUI.this.prmtMaterial.getQueryAgent().resetRuntimeEntityView();
            }
        });
        this.prmtMaterial.addCommitListener(new CommitListener(){

            public void willCommit(CommitEvent e) {
                PLSFilterUI.this.prmtMaterial.getQueryAgent().setDefaultFilterInfo(null);
                EntityViewInfo viewInfo = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)mSet, CompareType.INCLUDE));
                viewInfo.setFilter(filter);
                PLSFilterUI.this.prmtMaterial.setEntityViewInfo(viewInfo);
                PLSFilterUI.this.prmtMaterial.getQueryAgent().resetRuntimeEntityView();
            }
        });
    }
}

