/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.mm.planning.client.AbstractPlanDiffAnalyseUI;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Set;
import org.apache.log4j.Logger;

public class PlanDiffAnalyseUI
extends AbstractPlanDiffAnalyseUI {
    private static final Logger logger = CoreUIObject.getLogger(PlanDiffAnalyseUI.class);
    private static final String TB_DIFFQTY = "diffQty";
    private static final String TB_DIFFRATE = "diffRate";

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        HashMap datasMap = (HashMap)this.getUIContext().get("datas");
        IRow row = null;
        this.kdtResult.checkParsed();
        if (!datasMap.isEmpty()) {
            Set keySet = datasMap.keySet();
            for (String materialId : keySet) {
                HashMap materialMap = (HashMap)datasMap.get(materialId);
                BigDecimal noSchedulingQty = (BigDecimal)materialMap.get("noSchedulingQty");
                BigDecimal planQty = (BigDecimal)materialMap.get("planQty");
                BigDecimal diffQty = noSchedulingQty.subtract(planQty);
                BigDecimal diffRate = diffQty.divide(planQty, diffQty.scale(), 4);
                String strDiffRate = diffRate.multiply(new BigDecimal(100)).toString() + "%";
                row = this.kdtResult.addRow();
                for (int i = 0; i < this.kdtResult.getColumnCount(); ++i) {
                    String columnKey = this.kdtResult.getColumn(i).getKey();
                    if (columnKey.equals(TB_DIFFQTY)) {
                        row.getCell(i).setValue((Object)diffQty);
                    } else if (columnKey.equals(TB_DIFFRATE)) {
                        row.getCell(i).setValue((Object)strDiffRate);
                    } else {
                        row.getCell(i).setValue(materialMap.get(this.kdtResult.getColumn(i).getKey()));
                    }
                    row.getStyleAttributes().setLocked(true);
                }
            }
        }
    }
}

