/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.IsolatedRuleEnum;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialInventoryFactory;
import com.kingdee.eas.basedata.master.material.MaterialLeadTimeTypeEnum;
import com.kingdee.eas.basedata.master.material.MaterialPlanCollection;
import com.kingdee.eas.basedata.master.material.MaterialPlanFactory;
import com.kingdee.eas.basedata.master.material.MaterialPlanInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.mm.basedata.TrackNumberCollection;
import com.kingdee.eas.mm.basedata.TrackNumberFactory;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.common.client.UIHelper;
import com.kingdee.eas.mm.planning.IPlanOrderChange;
import com.kingdee.eas.mm.planning.PlanOrderChangeFactory;
import com.kingdee.eas.mm.planning.PlanOrderChangeInfo;
import com.kingdee.eas.mm.planning.PlannedOrderInfo;
import com.kingdee.eas.mm.planning.PlannedOrderTypeEnum;
import com.kingdee.eas.mm.planning.client.AbstractPlanOrderChangeUI;
import com.kingdee.eas.mm.planning.util.PLSUtil;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class PlanOrderChangeUI
extends AbstractPlanOrderChangeUI {
    private static final long serialVersionUID = -8625389531162052348L;
    private PlannedOrderInfo plannedOrderInfo;
    private Map qtyPrecisionCatch = new HashMap();
    private boolean isTrackNumberRequired = false;
    private DataChangeListener endChangedateListener = null;
    private DataChangeListener startChangedateListener = null;
    private DataChangeListener changeQtyListener = null;

    protected IObjectValue createNewData() {
        PlanOrderChangeInfo info = new PlanOrderChangeInfo();
        info.setPlanedOrderSrc(this.plannedOrderInfo);
        info.setStorageOrgUnit(this.plannedOrderInfo.getStorageOrgUnit());
        info.setQty(this.plannedOrderInfo.getQty());
        info.setChangeQty(this.plannedOrderInfo.getQty());
        info.setScheduleQty(this.plannedOrderInfo.getScheduleQty());
        info.setTotalReleaseQty(this.plannedOrderInfo.getTotalReleaseQty());
        info.setStartDate(this.plannedOrderInfo.getStartDate());
        info.setStartDateChange(this.plannedOrderInfo.getStartDate());
        info.setEndDate(this.plannedOrderInfo.getEndDate());
        info.setEndDateChange(this.plannedOrderInfo.getEndDate());
        info.setAvilableDate(this.plannedOrderInfo.getAvilableDate());
        info.setAvilableDateChange(this.plannedOrderInfo.getAvilableDate());
        info.setTrackNumber(this.plannedOrderInfo.getTrackNumber());
        info.setTrackNumberChange(this.plannedOrderInfo.getTrackNumber());
        return info;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return PlanOrderChangeFactory.getRemoteInstance();
    }

    @Override
    public void actionCanceled_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        this.doBeforeSave(e);
        if (this.isTrackNumberRequired && this.prmtTrackNumberChange.getValue() == null) {
            MsgBox.showError((String)this.getPlanOrderResource("please_input_tracknumber"));
            return;
        }
        if (this.editData.getChangeQty().compareTo(this.editData.getQty()) == 0 && this.equalsDate(this.editData.getStartDate(), this.editData.getStartDateChange()) && this.equalsDate(this.editData.getEndDate(), this.editData.getEndDateChange()) && this.equalsDate(this.editData.getAvilableDate(), this.editData.getAvilableDateChange()) && this.checkTrackNumber(this.editData.getTrackNumber(), this.editData.getTrackNumberChange())) {
            if (MsgBox.showConfirm2New((Component)((Object)this), (String)this.getPlanOrderResource("Not_Change")) == 0) {
                super.actionExitCurrent_actionPerformed(e);
                return;
            }
            return;
        }
        IObjectPK pk = this.runSave();
        if (pk != null) {
            this.setSave(true);
            this.setSaved(true);
            this.loadFields();
            this.initOldData((IObjectValue)this.editData);
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("PLANEDORDERID", this.plannedOrderInfo.getId().toString());
            param.put("PLANEDORDERCHANGEID", pk.toString());
            param.put("PLANEDORDERTYPE", (Object)this.plannedOrderInfo.getOrderType());
            param.put("STORAGEORGUNITID", this.plannedOrderInfo.getStorageOrgUnit().getId().toString());
            param.put("STARTDATE", this.editData.getStartDate());
            param.put("STARTCHANGEDATE", this.editData.getStartDateChange());
            param.put("QTY", this.editData.getQty());
            param.put("CHANGEQTY", this.editData.getChangeQty());
            param.put("TOTALQTY", this.editData.getTotalReleaseQty());
            ((IPlanOrderChange)this.getBizInterface()).writeBackPlannedOrder(param);
            super.actionExitCurrent_actionPerformed(e);
        }
    }

    public void onLoad() throws Exception {
        this.txtChangeQty.setNegatived(false);
        this.txtChangeQty.setRemoveingZeroInDispaly(true);
        Map ctx = this.getUIContext();
        this.plannedOrderInfo = (PlannedOrderInfo)ctx.get("PLANEDORDERINFO");
        super.onLoad();
        this.initTrackNumber();
        this.kDBCanceled.setEnabled(true);
        this.kDBConfirm.setEnabled(true);
        this.txtNumber.setEnabled(false);
        this.comboOrderType.setEnabled(false);
        this.prmtMaterial.setEnabled(false);
        this.txtMaterialName.setEnabled(false);
        this.txtQty.setEnabled(false);
        this.txtScheduleQty.setEnabled(false);
        this.txtScheduleChangeQty.setEnabled(false);
        this.txtTotalReleaseQty.setEnabled(false);
        this.txtTotalReleaseChangeQty.setEnabled(false);
        this.pkEndDate.setEnabled(false);
        this.pkStartDate.setEnabled(false);
        this.pkAvilableDate.setEnabled(false);
        this.pkAvilableDateChange.setEnabled(false);
        this.prmtTrackNumber.setEnabled(false);
        if (this.checkTrackNumber(this.plannedOrderInfo.getStorageOrgUnit(), this.plannedOrderInfo.getMaterial())) {
            this.isTrackNumberRequired = true;
            this.prmtTrackNumberChange.setRequired(true);
        }
        BigDecimal totalReleaseChangeQty = this.txtTotalReleaseChangeQty.getBigDecimalValue();
        this.txtChangeQty.setMinimumValue((Comparable)totalReleaseChangeQty);
    }

    @Override
    public void loadFields() {
        this.removeListeners();
        super.loadFields();
        this.txtScheduleQty.setValue((Object)this.plannedOrderInfo.getScheduleQty());
        this.txtTotalReleaseQty.setValue((Object)this.plannedOrderInfo.getTotalReleaseQty());
        try {
            this.changePrdQtyPrecision(this.plannedOrderInfo.getMaterial(), this.plannedOrderInfo.getProductUnit());
        }
        catch (Exception e) {
            this.handleException(e);
        }
        this.addListeners();
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        Date avilableDate;
        Date end;
        Date start;
        if (this.editData.getChangeQty() == null || this.editData.getChangeQty().compareTo(SCMClientUtils.ZERO) <= 0) {
            MsgBox.showInfo((String)this.getPlanOrderResource("OrderQtyChange_can_not_be_zero"));
            this.txtQty.requestFocus();
            SysUtil.abort();
        }
        if (this.editData.getChangeQty().compareTo(this.editData.getTotalReleaseQty()) < 0) {
            MsgBox.showInfo((String)this.getPlanOrderResource("OrderQtyChange_can_notless_TotalReleaseQty"));
            this.txtQty.requestFocus();
            SysUtil.abort();
        }
        if (this.editData.getChangeQty().compareTo(this.editData.getScheduleQty()) < 0) {
            MsgBox.showInfo((String)this.getPlanOrderResource("OrderQtyChange_can_notless_ScheduleQty"));
            this.txtQty.requestFocus();
            SysUtil.abort();
        }
        if (this.editData.getStartDateChange() == null) {
            MsgBox.showInfo((String)this.getPlanOrderResource("MSG_STARTDATECHANGENOTNULL"));
            this.pkStartDateChange.requestFocus();
            SysUtil.abort();
        }
        if (this.editData.getEndDateChange() == null) {
            MsgBox.showInfo((String)this.getPlanOrderResource("MSG_ENDDATECHANGENOTNULL"));
            this.pkEndDateChange.requestFocus();
            SysUtil.abort();
        }
        if (this.compareDate(start = this.editData.getStartDateChange(), end = this.editData.getEndDateChange())) {
            MsgBox.showInfo((String)this.getPlanOrderResource("MSG_ENDDATECHANGELESSTHANSTARTDATECHANGE"));
            SysUtil.abort();
        }
        if (this.editData.getAvilableDateChange() == null) {
            MsgBox.showInfo((String)this.getPlanOrderResource("MSG_AVILDATECHANGENOTNULL"));
            this.pkAvilableDateChange.requestFocus();
            SysUtil.abort();
        }
        if (this.compareDate(start, avilableDate = this.editData.getAvilableDateChange())) {
            MsgBox.showInfo((String)this.getPlanOrderResource("MSG_AVILDATECHANGELESSTHANSTARTDATECHANGE"));
            SysUtil.abort();
        }
        boolean isValidate = false;
        try {
            isValidate = ((IPlanOrderChange)this.getBizInterface()).isValidateCalendar(this.plannedOrderInfo.getStorageOrgUnit().getId().toString(), start);
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
        if (!isValidate) {
            MsgBox.showInfo((String)this.getPlanOrderResource("StartDate_can_not_be_WorkDate"));
            SysUtil.abort();
        }
        if (!this.equalsDate(start, end)) {
            try {
                isValidate = false;
                isValidate = ((IPlanOrderChange)this.getBizInterface()).isValidateCalendar(this.plannedOrderInfo.getStorageOrgUnit().getId().toString(), end);
            }
            catch (Exception ex) {
                this.handleException(ex);
            }
            if (!isValidate) {
                MsgBox.showInfo((String)this.getPlanOrderResource("EndDate_can_not_be_WorkDate"));
                SysUtil.abort();
            }
        }
        if (!this.equalsDate(start, avilableDate)) {
            try {
                isValidate = false;
                isValidate = ((IPlanOrderChange)this.getBizInterface()).isValidateCalendar(this.plannedOrderInfo.getStorageOrgUnit().getId().toString(), avilableDate);
            }
            catch (Exception ex) {
                this.handleException(ex);
            }
            if (!isValidate) {
                MsgBox.showInfo((String)this.getPlanOrderResource("AvilDate_can_not_be_WorkDate"));
                SysUtil.abort();
            }
        }
    }

    private String getPlanOrderResource(String sKey) {
        return EASResource.getString((String)"com.kingdee.eas.mm.planning.client.PlanningResource", (String)sKey);
    }

    private boolean compareDate(Date start, Date end) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
        int startDay = Integer.parseInt(dateFormat.format(start).toString());
        int endDay = Integer.parseInt(dateFormat.format(end).toString());
        boolean result = false;
        if (endDay - startDay < 0) {
            result = true;
        }
        return result;
    }

    private boolean equalsDate(Date start, Date end) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
        int startDay = Integer.parseInt(dateFormat.format(start).toString());
        int endDay = Integer.parseInt(dateFormat.format(end).toString());
        boolean result = false;
        if (endDay - startDay == 0) {
            result = true;
        }
        return result;
    }

    private void changePrdQtyPrecision(MaterialInfo matInfo, MeasureUnitInfo unitInfo) throws Exception {
        if (matInfo != null && unitInfo != null) {
            int precision = 2;
            if (this.qtyPrecisionCatch.containsKey(matInfo.getId().toString() + "_" + unitInfo.getId().toString())) {
                precision = (Integer)this.qtyPrecisionCatch.get(matInfo.getId().toString() + "_" + unitInfo.getId().toString());
            } else {
                MultiMeasureUnitInfo measureUnitInfo = null;
                measureUnitInfo = MultiMeasureUnitFactory.getRemoteInstance().getMultiUnit(matInfo.getId().toString(), unitInfo.getId().toString());
                if (measureUnitInfo != null) {
                    precision = measureUnitInfo.getQtyPrecision();
                }
                this.qtyPrecisionCatch.put(matInfo.getId().toString() + "_" + unitInfo.getId().toString(), new Integer(precision));
            }
            this.txtQty.setPrecision(precision);
            this.txtScheduleQty.setPrecision(precision);
            this.txtTotalReleaseQty.setPrecision(precision);
            this.txtChangeQty.setPrecision(precision);
            this.txtScheduleChangeQty.setPrecision(precision);
            this.txtTotalReleaseChangeQty.setPrecision(precision);
            BigDecimal qty = this.txtQty.getBigDecimalValue();
            this.txtQty.setValue((Object)(qty == null ? SCMClientUtils.ZERO : qty.setScale(precision, 4)));
            qty = this.txtScheduleQty.getBigDecimalValue();
            this.txtScheduleQty.setValue((Object)(qty == null ? SCMClientUtils.ZERO : qty.setScale(precision, 4)));
            qty = this.txtTotalReleaseQty.getBigDecimalValue();
            this.txtTotalReleaseQty.setValue((Object)(qty == null ? SCMClientUtils.ZERO : qty.setScale(precision, 4)));
            qty = this.txtChangeQty.getBigDecimalValue();
            this.txtChangeQty.setValue((Object)(qty == null ? SCMClientUtils.ZERO : qty.setScale(precision, 4)));
            qty = this.txtScheduleChangeQty.getBigDecimalValue();
            this.txtScheduleChangeQty.setValue((Object)(qty == null ? SCMClientUtils.ZERO : qty.setScale(precision, 4)));
            qty = this.txtTotalReleaseChangeQty.getBigDecimalValue();
            this.txtTotalReleaseChangeQty.setValue((Object)(qty == null ? SCMClientUtils.ZERO : qty.setScale(precision, 4)));
        }
    }

    private void addListeners() {
        if (this.endChangedateListener == null) {
            this.endChangedateListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent dataChangeEvent) {
                    try {
                        PlanOrderChangeUI.this.endChangeDate_dataChanged(dataChangeEvent);
                    }
                    catch (Exception e) {
                        PlanOrderChangeUI.this.handleException(e);
                    }
                }
            };
        }
        this.pkEndDateChange.addDataChangeListener(this.endChangedateListener);
        if (this.startChangedateListener == null) {
            this.startChangedateListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent dataChangeEvent) {
                    try {
                        PlanOrderChangeUI.this.startChangeDate_dataChanged(dataChangeEvent);
                    }
                    catch (Exception e) {
                        PlanOrderChangeUI.this.handleException(e);
                    }
                }
            };
        }
        this.pkStartDateChange.addDataChangeListener(this.startChangedateListener);
        if (this.changeQtyListener == null) {
            this.changeQtyListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent dataChangeEvent) {
                    try {
                        PlanOrderChangeUI.this.changeQty_dataChanged(dataChangeEvent);
                    }
                    catch (Exception e) {
                        PlanOrderChangeUI.this.handleException(e);
                    }
                }
            };
        }
        this.txtChangeQty.addDataChangeListener(this.changeQtyListener);
    }

    private void removeListeners() {
        if (this.endChangedateListener != null) {
            this.pkEndDateChange.removeDataChangeListener(this.endChangedateListener);
        }
        if (this.startChangedateListener != null) {
            this.pkStartDateChange.removeDataChangeListener(this.startChangedateListener);
        }
        if (this.endChangedateListener != null) {
            this.txtChangeQty.removeDataChangeListener(this.changeQtyListener);
        }
    }

    private MaterialPlanInfo getPlanInfo(String materialID, String storageOrgUnitID) throws BOSException {
        MaterialPlanInfo materialPlanInfo = null;
        MaterialPlanCollection colls = null;
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialID));
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)storageOrgUnitID));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        viewInfo.setSelector(this.getMaterialPlanSelector());
        colls = MaterialPlanFactory.getRemoteInstance().getMaterialPlanCollection(viewInfo);
        materialPlanInfo = colls.get(0);
        return materialPlanInfo;
    }

    private SelectorItemCollection getMaterialPlanSelector() {
        SelectorItemCollection coll = new SelectorItemCollection();
        coll.add("productUnit.id");
        coll.add("produceLeadTime");
        coll.add("recevingLeadTime");
        coll.add("forwardProcessTime");
        coll.add("backwardProcessTime");
        coll.add("material.id");
        coll.add("orgUnit.id");
        coll.add("leadTimeType");
        coll.add("changeBatch");
        coll.add("changeLeadTime");
        return coll;
    }

    private void endChangeDate_dataChanged(DataChangeEvent eventObj) throws EASBizException, BOSException {
        Date objDate = (Date)eventObj.getNewValue();
        StorageOrgUnitInfo orgUnitInfo = this.plannedOrderInfo.getStorageOrgUnit();
        MaterialInfo material = this.plannedOrderInfo.getMaterial();
        if (orgUnitInfo == null || material == null) {
            return;
        }
        MaterialPlanInfo matPlanInfo = this.getPlanInfo(material.getId().toString(), orgUnitInfo.getId().toString());
        if (objDate != null) {
            String orgId = matPlanInfo.getOrgUnit().getId().toString();
            Date avilableDate = PLSUtil.getAvalibleDate(orgId, objDate, matPlanInfo.getRecevingLeadTime());
            this.pkAvilableDateChange.setValue((Object)avilableDate);
        }
    }

    private void startChangeDate_dataChanged(DataChangeEvent eventObj) throws BOSException, EASBizException {
        Date objDate = (Date)eventObj.getNewValue();
        if (objDate != null) {
            BigDecimal qty = this.txtChangeQty.getBigDecimalValue();
            this.calcEndDate(objDate, qty, false);
        }
    }

    public boolean checkBeforeWindowClosing() {
        return true;
    }

    private boolean checkTrackNumber(StorageOrgUnitInfo org, MaterialInfo material) {
        TrackNumberInfo trackNumberInfo = this.plannedOrderInfo.getTrackNumber();
        if (trackNumberInfo == null) {
            return false;
        }
        MaterialPlanInfo materialPlan = null;
        MaterialPlanCollection materialPlans = this.getMaterialPlanCollection(org.getId().toString(), material.getId().toString());
        CoreBaseCollection invents = this.getMaterialInventoryCollection(org.getId().toString(), material.getId().toString());
        if (invents != null && invents.size() < 0) {
            return false;
        }
        if (materialPlans != null && materialPlans.size() < 0) {
            return false;
        }
        materialPlan = materialPlans.get(0);
        String manufactureStregy = materialPlan.getManufactureStrategy().getId().toString();
        if (this.getManufactureStrategy().contains(manufactureStregy)) {
            return true;
        }
        return (manufactureStregy.equals("GE2FIa4GQ6uhdx0RDGuibtg0uEU=") || manufactureStregy.equals("qAXoUB/uBg/gQKjAYj0WQ9g0uEU=")) && materialPlan.getIsolatedRule().equals((Object)IsolatedRuleEnum.ITEM_TRACKNO);
    }

    private Set getManufactureStrategy() {
        HashSet<String> set = new HashSet<String>();
        set.add("qAYbemEdG9ngQKjAYj0V1dg0uEU=");
        set.add("qAYfaBzTrmLgQKjAYj0f3dg0uEU=");
        set.add("qAYfaBzUrmLgQKjAYj0f3dg0uEU=");
        set.add("fpPxtypCS/ihJ30GjB/UJtg0uEU=");
        set.add("qAXoUB/tBg/gQKjAYj0WQ9g0uEU=");
        return set;
    }

    private void initTrackNumber() {
        HashSet<Integer> status = new HashSet<Integer>();
        status.add(new Integer(10));
        KDBizPromptBox prmtstorageOrgUnit = new KDBizPromptBox();
        KDBizPromptBox prmtProjectNum = new KDBizPromptBox();
        prmtProjectNum.setValue((Object)this.plannedOrderInfo.getProject());
        prmtstorageOrgUnit.setValue((Object)SysContext.getSysContext().getCurrentStorageUnit());
        CtrlUnitInfo adminCU = SysContext.getSysContext().getCurrentCtrlUnit();
        TrackNumberInfo trackNumberInfo = null;
        this.prmtTrackNumberChange.setDisplayFormat("$number$");
        this.prmtTrackNumberChange.setCommitFormat("$number$");
        this.prmtTrackNumberChange.setEditFormat("$number$");
        this.prmtTrackNumberChange.setQueryInfo("com.kingdee.eas.mm.basedata.app.TrackNumberQuery");
        EntityViewInfo TrackNumberview = new EntityViewInfo();
        FilterInfo TrackNumberfilter = new FilterInfo();
        TrackNumberfilter.getFilterItems().add(new FilterItemInfo("adminCU.id", (Object)adminCU.getId().toString(), CompareType.EQUALS));
        TrackNumberfilter.getFilterItems().add(new FilterItemInfo("defaultTraceNumberFlag", (Object)new Integer(1), CompareType.EQUALS));
        TrackNumberview.setFilter(TrackNumberfilter);
        SelectorItemCollection coll = new SelectorItemCollection();
        coll.add(new SelectorItemInfo("id"));
        coll.add(new SelectorItemInfo("orgUnit"));
        coll.add(new SelectorItemInfo("number"));
        TrackNumberview.setSelector(coll);
        TrackNumberCollection colls = null;
        try {
            colls = TrackNumberFactory.getRemoteInstance().getTrackNumberCollection(TrackNumberview);
        }
        catch (BOSException e) {
            this.handleException((Exception)((Object)e));
        }
        String defaultTrackNumberID = null;
        if (colls != null && colls.size() > 0) {
            trackNumberInfo = colls.get(0);
            defaultTrackNumberID = trackNumberInfo.getId().toString();
        }
        UIHelper.registerTrackNumberF7((KDBizPromptBox)prmtstorageOrgUnit, null, (KDBizPromptBox)prmtProjectNum, (KDBizPromptBox)this.prmtTrackNumberChange, status, (boolean)false, (boolean)false, defaultTrackNumberID);
    }

    private MaterialPlanCollection getMaterialPlanCollection(String StorageOrgUnitID, String materialID) {
        MaterialPlanCollection materialPlans = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)StorageOrgUnitID));
        filter.getFilterItems().add(new FilterItemInfo("material", (Object)materialID));
        SelectorItemCollection coll = new SelectorItemCollection();
        coll.add(new SelectorItemInfo("manufactureStrategy"));
        coll.add(new SelectorItemInfo("isolatedRule"));
        view.setSelector(coll);
        view.setFilter(filter);
        try {
            materialPlans = MaterialPlanFactory.getRemoteInstance().getMaterialPlanCollection(view);
        }
        catch (BOSException e1) {
            this.handleException((Exception)((Object)e1));
        }
        return materialPlans;
    }

    private CoreBaseCollection getMaterialInventoryCollection(String StorageOrgUnitID, String materialID) {
        EntityViewInfo viewInvent = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)StorageOrgUnitID));
        filter.getFilterItems().add(new FilterItemInfo("material", (Object)materialID));
        SelectorItemCollection coll = new SelectorItemCollection();
        coll.add(new SelectorItemInfo("isProjectNumber"));
        coll.add(new SelectorItemInfo("isTrackingNumber"));
        coll.add(new SelectorItemInfo("id"));
        coll.add(new SelectorItemInfo("orgUnit"));
        coll.add(new SelectorItemInfo("material"));
        viewInvent.setSelector(coll);
        viewInvent.setFilter(filter);
        CoreBaseCollection invents = null;
        try {
            invents = MaterialInventoryFactory.getRemoteInstance().getCollection(viewInvent);
        }
        catch (BOSException e) {
            this.handleException((Exception)((Object)e));
        }
        return invents;
    }

    private void calcEndDate(Date startDate, BigDecimal qty, boolean isChangeQty) throws EASBizException, BOSException {
        PlannedOrderTypeEnum orderType = this.plannedOrderInfo.getOrderType();
        StorageOrgUnitInfo orgUnitInfo = this.plannedOrderInfo.getStorageOrgUnit();
        MaterialInfo material = this.plannedOrderInfo.getMaterial();
        MaterialPlanInfo matPlanInfo = this.getPlanInfo(material.getId().toString(), orgUnitInfo.getId().toString());
        if (isChangeQty && MaterialLeadTimeTypeEnum.FIXBATCHTYPE.equals((Object)matPlanInfo.getLeadTimeType())) {
            return;
        }
        BigDecimal releaseQty = this.txtTotalReleaseChangeQty.getBigDecimalValue();
        qty = qty.subtract(releaseQty);
        Date endDate = PLSUtil.getPlannedEndDate(orderType, matPlanInfo, startDate, qty);
        this.pkEndDateChange.setValue((Object)endDate);
    }

    private void changeQty_dataChanged(DataChangeEvent eventObj) throws BOSException, EASBizException {
        BigDecimal newQty = (BigDecimal)eventObj.getNewValue();
        if (newQty != null) {
            Date startDate = (Date)this.pkStartDateChange.getValue();
            this.calcEndDate(startDate, newQty, true);
        }
    }

    private boolean checkTrackNumber(TrackNumberInfo sourceInfo, TrackNumberInfo targetInfo) {
        if (sourceInfo == null && targetInfo != null || sourceInfo != null && targetInfo == null) {
            return false;
        }
        if (sourceInfo == null && targetInfo == null) {
            return true;
        }
        return sourceInfo != null && targetInfo != null && sourceInfo.getId().equals((Object)targetInfo.getId());
    }
}

