/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.client;

import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.mm.planning.PlannedOrderCollection;
import com.kingdee.eas.mm.planning.PlannedOrderFactory;
import com.kingdee.eas.mm.planning.PlannedOrderInfo;
import com.kingdee.eas.mm.planning.client.PlanOrderSplitUI;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.util.Map;

public class PlanOrderSplitDialog {
    private IUIWindow window = null;
    private Map uiContext = null;
    private PlannedOrderInfo planOrderInfo = null;
    private boolean isSuccess = false;

    public PlanOrderSplitDialog(Map uiContext) {
        this.uiContext = uiContext;
    }

    public boolean show() {
        this.getPlanOrderInfoById();
        this.checkBeforeShowWindow();
        return this.createTargetUI();
    }

    public PlannedOrderInfo getPlanOrderInfo() {
        return this.planOrderInfo;
    }

    private boolean createTargetUI() {
        try {
            IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
            this.window = uiFactory.create(PlanOrderSplitUI.class.getName(), this.uiContext, null, OprtState.VIEW, 95);
            this.window.show();
            this.isSuccess = ((PlanOrderSplitUI)this.window.getUIObject()).isSplitSuccess();
        }
        catch (UIException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return this.isSuccess;
    }

    private void getPlanOrderInfoById() {
        String planOrderId = (String)this.uiContext.get("planOrderId");
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        String maskString = "#0 OR #1";
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)planOrderId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("sourceBillId", (Object)planOrderId, CompareType.EQUALS));
        filter.setMaskString(maskString);
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("number"));
        view.getSelector().add(new SelectorItemInfo("startDate"));
        view.getSelector().add(new SelectorItemInfo("endDate"));
        view.getSelector().add("avilableDate");
        view.getSelector().add("finalProductsRate");
        view.getSelector().add("finalProductsQty");
        view.getSelector().add(new SelectorItemInfo("qty"));
        view.getSelector().add(new SelectorItemInfo("baseStatus"));
        view.getSelector().add(new SelectorItemInfo("storageOrgUnit.id"));
        view.getSelector().add(new SelectorItemInfo("material.id"));
        view.getSelector().add(new SelectorItemInfo("productUnit.name"));
        view.getSelector().add(new SelectorItemInfo("isSimulant"));
        view.getSelector().add(new SelectorItemInfo("isCannotRelease"));
        view.getSelector().add(new SelectorItemInfo("orderType"));
        view.getSelector().add(new SelectorItemInfo("baseQty"));
        view.getSelector().add(new SelectorItemInfo("unit.id"));
        view.setFilter(filter);
        try {
            PlannedOrderCollection planOrderCollection = PlannedOrderFactory.getRemoteInstance().getPlannedOrderCollection(view);
            if (planOrderCollection != null && planOrderCollection.size() > 0) {
                for (int i = 0; i < planOrderCollection.size(); ++i) {
                    if (!planOrderId.equals(planOrderCollection.get(i).getId().toString())) continue;
                    this.planOrderInfo = planOrderCollection.get(i);
                    this.uiContext.put("planOrderInfo", this.planOrderInfo);
                }
                this.uiContext.put("poSplitSize", new Integer(planOrderCollection.size() - 1));
            } else if (planOrderCollection.size() == 0) {
                throw new EASBizException(EASBizException.CHECKEXIST);
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
            SysUtil.abort();
        }
    }

    private void checkBeforeShowWindow() {
        if (this.isNotSaveOrSubmitStatus()) {
            MsgBox.showInfo((String)this.getResource("SAVE_OR_SUBMIT_PLANORDER_CAN_SPLIT"));
            SysUtil.abort();
        }
        if (this.planOrderInfo.getMaterial() == null) {
            MsgBox.showInfo((String)this.getResource("MATERIAL_IS_NULL_CANNOT_SPLIT"));
            SysUtil.abort();
        }
        if (this.planOrderInfo.getStartDate() == null) {
            MsgBox.showInfo((String)this.getResource("STARTDATE_IS_NULL_CANNOT_SPLIT"));
            SysUtil.abort();
        }
        if (this.planOrderInfo.getEndDate() == null) {
            MsgBox.showInfo((String)this.getResource("ENDDATE_IS_NULL_CANNOT_SPLIT"));
            SysUtil.abort();
        }
        if (this.planOrderInfo.isIsSimulant()) {
            MsgBox.showInfo((String)this.getResource("SIMULANT_PLANORDER_CANNOT_SPLIT"));
            SysUtil.abort();
        }
        if (this.planOrderInfo.isIsCannotRelease()) {
            MsgBox.showInfo((String)this.getResource("CANTRELEASEDORDER_CANT_SPLIT"));
            SysUtil.abort();
        }
    }

    private boolean isNotSaveOrSubmitStatus() {
        return !BillBaseStatusEnum.TEMPORARILYSAVED.equals((Object)this.planOrderInfo.getBaseStatus()) && !BillBaseStatusEnum.SUBMITED.equals((Object)this.planOrderInfo.getBaseStatus());
    }

    private String getResource(String key) {
        return EASResource.getString((String)"com.kingdee.eas.mm.planning.client.PlanningResource", (String)key);
    }
}

