/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialLeadTimeTypeEnum;
import com.kingdee.eas.basedata.master.material.MaterialPlanCollection;
import com.kingdee.eas.basedata.master.material.MaterialPlanFactory;
import com.kingdee.eas.basedata.master.material.MaterialPlanInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.mm.common.util.EditTableUtil;
import com.kingdee.eas.mm.common.util.MMConstant;
import com.kingdee.eas.mm.planning.IPlannedOrder;
import com.kingdee.eas.mm.planning.PlannedOrderFactory;
import com.kingdee.eas.mm.planning.PlannedOrderInfo;
import com.kingdee.eas.mm.planning.PlannedOrderTypeEnum;
import com.kingdee.eas.mm.planning.client.AbstractPlanOrderSplitUI;
import com.kingdee.eas.mm.planning.util.PLSUtil;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class PlanOrderSplitUI
extends AbstractPlanOrderSplitUI {
    private static final long serialVersionUID = 6952201405792589993L;
    private static final BigDecimal DEFAULT_SPLIT_NUMBER = new BigDecimal("1");
    private static final BigDecimal MAX_SPLIT_NUMBER = new BigDecimal("20");
    private static final BigDecimal DEFAULT_QTY = new BigDecimal("0.00");
    private static final String TABLE_COLUMN_PLANSTARTDATE = "planStartDate";
    private static final String TABLE_COLUMN_PLANENDDATE = "planEndDate";
    private static final String TABLE_COLUMN_AVAILABLEDATE = "availableDate";
    private static final String TABLE_COLUMN_QTY = "qty";
    private static final String TABLE_COLUMN_BASEQTY = "baseQty";
    private static final String TABLE_COLUMN_NUMBER = "number";
    private static final String[] TABLE_QTY = new String[]{"qty"};
    private final KDFormattedTextField[] txtRequestQty;
    private PlannedOrderInfo planOrderInfo;
    private MaterialPlanInfo materialPlanInfo;
    private KDTEditAdapter entryTableChange;
    private boolean isSplitSuccess;
    private int precision;
    private static final String[] KDT_DATES = new String[]{"planStartDate", "planEndDate", "availableDate"};

    public PlanOrderSplitUI() throws Exception {
        this.txtRequestQty = new KDFormattedTextField[]{this.txtQty, this.txtTotalQtySplit};
        this.planOrderInfo = null;
        this.materialPlanInfo = null;
        this.entryTableChange = null;
        this.isSplitSuccess = false;
        this.precision = 2;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.getUIMenuBar().setVisible(false);
        this.initComponent();
        this.setDefaultValue();
        this.addListeners();
        EditTableUtil.formatColDate((KDTable)this.kDTable1, (String[])KDT_DATES);
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        try {
            IPlannedOrder plannedOrder = PlannedOrderFactory.getRemoteInstance();
            PlannedOrderInfo poInfo = (PlannedOrderInfo)plannedOrder.getValue((IObjectPK)new ObjectUuidPK(this.getUIContext().get("planOrderId").toString()));
            return new ObjectUuidPK(poInfo.getStorageOrgUnit().getId());
        }
        catch (Exception e) {
            this.handUIException(e);
            return super.getOrgPK(action);
        }
    }

    public boolean isSplitSuccess() {
        return this.isSplitSuccess;
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.kDPanel1.putClientProperty((Object)"OriginalBounds", (Object)new Rectangle(0, 0, this.kDTabbedPane1.getWidth(), this.kDTabbedPane1.getHeight()));
    }

    @Override
    public void actionSplitPreview_actionPerformed(ActionEvent e) throws Exception {
        this.setPreviewPlanOrders();
        this.calculateTotalQtySplit();
        this.setQtyFieldsPrecision();
        int rowCount = this.kDTable1.getRowCount3();
        IRow row = null;
        Date startDate = null;
        BigDecimal qty = null;
        BigDecimal oldQty = this.txtQty.getBigDecimalValue();
        boolean isChangeQty = false;
        for (int i = 0; i < rowCount; ++i) {
            row = this.kDTable1.getRow(i);
            startDate = (Date)row.getCell(TABLE_COLUMN_PLANSTARTDATE).getValue();
            qty = (BigDecimal)row.getCell(TABLE_COLUMN_QTY).getValue();
            if (oldQty.compareTo(qty) == 0) continue;
            this.calcEndDate(row, startDate, qty, isChangeQty);
        }
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        this.checkBeforeSplit();
        this.planOrderSplit();
        this.destroyWindow();
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.destroyWindow();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return PlannedOrderFactory.getRemoteInstanceWithObjectContext(this.getUserContext());
    }

    private void addListeners() {
        if (this.entryTableChange == null) {
            this.entryTableChange = new KDTEditAdapter(){

                public void editStarting(KDTEditEvent e) {
                }

                public void editStopped(KDTEditEvent e) {
                    try {
                        PlanOrderSplitUI.this.kdtChangedStopped(e);
                    }
                    catch (Exception exc) {
                        PlanOrderSplitUI.this.handUIException(exc);
                    }
                }
            };
        }
        this.kDTable1.addKDTEditListener((KDTEditListener)this.entryTableChange);
    }

    private void setPreviewPlanOrders() throws EASBizException, BOSException {
        BigDecimal billNumber = new BigDecimal(this.txtPlanOrders.getText());
        List splitQtys = this.calculateQty(billNumber);
        List splitBaseQtys = this.calculateBaseQty(splitQtys);
        int numberSeq = (Integer)this.getUIContext().get("poSplitSize") + 1;
        IRow newPlanOrderRow = null;
        this.kDTable1.removeRows();
        for (int i = 0; i < billNumber.intValue(); ++i) {
            newPlanOrderRow = this.kDTable1.addRow(i);
            newPlanOrderRow.getCell(TABLE_COLUMN_NUMBER).setValue((Object)(this.planOrderInfo.getNumber() + "-" + (i + numberSeq)));
            newPlanOrderRow.getCell(TABLE_COLUMN_PLANSTARTDATE).setValue((Object)this.planOrderInfo.getStartDate());
            newPlanOrderRow.getCell(TABLE_COLUMN_PLANENDDATE).setValue((Object)this.planOrderInfo.getEndDate());
            newPlanOrderRow.getCell(TABLE_COLUMN_AVAILABLEDATE).setValue((Object)this.planOrderInfo.getAvilableDate());
            newPlanOrderRow.getCell(TABLE_COLUMN_QTY).setValue(splitQtys.get(i));
            newPlanOrderRow.getCell(TABLE_COLUMN_BASEQTY).setValue(splitBaseQtys.get(i));
        }
    }

    private void initComponent() {
        this.txtQty.setHorizontalAlignment(4);
        this.txtTotalQtySplit.setHorizontalAlignment(4);
        this.txtPlanOrders.setHorizontalAlignment(4);
        this.txtPlanOrders.setMaximumValue((Comparable)MAX_SPLIT_NUMBER);
        this.txtPlanOrders.setMinimumValue((Comparable)DEFAULT_SPLIT_NUMBER);
        this.kDTable1.checkParsed();
        this.kDTable1.getActionMap().remove("Copy");
        this.kDTable1.getActionMap().remove("Paste");
        this.kDTable1.getActionMap().remove("Cut");
        this.kDTable1.getActionMap().remove("Delete");
        KDDatePicker datePicker = new KDDatePicker();
        this.kDTable1.getColumn(TABLE_COLUMN_PLANSTARTDATE).setEditor((ICellEditor)new KDTDefaultCellEditor(datePicker));
        this.kDTable1.getColumn(TABLE_COLUMN_PLANENDDATE).setEditor((ICellEditor)new KDTDefaultCellEditor(datePicker));
        this.kDTable1.getColumn(TABLE_COLUMN_AVAILABLEDATE).setEditor((ICellEditor)new KDTDefaultCellEditor(datePicker));
    }

    private void setDefaultValue() throws Exception {
        this.planOrderInfo = (PlannedOrderInfo)this.getUIContext().get("planOrderInfo");
        this.txtNumber.setText(this.planOrderInfo.getNumber());
        this.txtQty.setValue((Object)this.planOrderInfo.getQty());
        this.txtPlanOrders.setValue((Object)DEFAULT_SPLIT_NUMBER);
        this.dpPlanStartDate.setValue((Object)this.planOrderInfo.getStartDate());
        this.dpPlanEndDate.setValue((Object)this.planOrderInfo.getEndDate());
        this.prmtUnit.setValue((Object)this.planOrderInfo.getProductUnit());
        this.materialPlanInfo = this.getMaterialPlanInfo(this.planOrderInfo.getMaterial().getId().toString(), this.planOrderInfo.getStorageOrgUnit().getId().toString());
        this.precision = this.getPrecision(this.planOrderInfo.getMaterial(), this.materialPlanInfo.getProductUnit());
        this.setQtyFieldsPrecision();
    }

    private boolean isAverageSplit() {
        return this.chkAverageSplit.isSelected();
    }

    private void kdtChangedStopped(KDTEditEvent e) throws Exception {
        Object oldValue;
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        IRow curRow = this.kDTable1.getRow(rowIndex);
        String fieldName = this.kDTable1.getColumnKey(colIndex);
        Object newValue = e.getValue();
        boolean isDiffrent = SCMGroupClientUtils.isDiffrent((Object)newValue, (Object)(oldValue = e.getOldValue()));
        if (!isDiffrent) {
            return;
        }
        if (TABLE_COLUMN_PLANSTARTDATE.equalsIgnoreCase(fieldName)) {
            Date startDate = (Date)curRow.getCell(TABLE_COLUMN_PLANSTARTDATE).getValue();
            if (startDate == null) {
                MsgBox.showInfo((String)this.getResource("PLANSTARTDATE_CANNOT_BE_NULL"));
                curRow.getCell(TABLE_COLUMN_PLANSTARTDATE).setValue(e.getOldValue());
                return;
            }
            BigDecimal qty = (BigDecimal)curRow.getCell(TABLE_COLUMN_QTY).getValue();
            this.calcEndDate(curRow, startDate, qty, false);
        } else if (TABLE_COLUMN_PLANENDDATE.equalsIgnoreCase(fieldName)) {
            Date startDate = (Date)curRow.getCell(TABLE_COLUMN_PLANSTARTDATE).getValue();
            Date endDate = (Date)curRow.getCell(TABLE_COLUMN_PLANENDDATE).getValue();
            if (endDate == null) {
                MsgBox.showInfo((String)this.getResource("PLANENDDATE_CANNOT_BE_NULL"));
                curRow.getCell(TABLE_COLUMN_PLANENDDATE).setValue(e.getOldValue());
                return;
            }
            if (endDate.before(startDate)) {
                MsgBox.showInfo((String)this.getResource("ENDDATE_CANNOT_LT_STARTDATE"));
                curRow.getCell(TABLE_COLUMN_PLANENDDATE).setValue(e.getOldValue());
                this.abort();
            }
            this.calcAvailableDate(curRow, endDate);
        } else if (TABLE_COLUMN_QTY.equalsIgnoreCase(fieldName)) {
            BigDecimal qty = (BigDecimal)e.getValue();
            if (qty == null) {
                MsgBox.showInfo((String)this.getResource("OrderQty_can_not_be_zero"));
                curRow.getCell(TABLE_COLUMN_QTY).setValue(e.getOldValue());
                return;
            }
            this.calculateTotalQtySplit();
            MaterialInfo material = this.planOrderInfo.getMaterial();
            BigDecimal splitBaseQty = SCMUtils.getExchangePricesionQtyForClient((String)material.getId().toString(), (MeasureUnitInfo)this.planOrderInfo.getProductUnit(), (MeasureUnitInfo)this.planOrderInfo.getUnit(), (BigDecimal)qty);
            curRow.getCell(TABLE_COLUMN_BASEQTY).setValue((Object)splitBaseQty);
            Date startDate = (Date)curRow.getCell(TABLE_COLUMN_PLANSTARTDATE).getValue();
            this.calcEndDate(curRow, startDate, qty, true);
        }
    }

    private MaterialPlanInfo getMaterialPlanInfo(String materialID, String storageOrgUnitID) {
        MaterialPlanInfo materialPlanInfo = null;
        MaterialPlanCollection materialPlanColls = null;
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialID));
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)storageOrgUnitID));
        viewInfo.setFilter(filter);
        SelectorItemCollection selectorColl = this.getMaterialPlanSelector();
        viewInfo.setSelector(selectorColl);
        try {
            materialPlanColls = MaterialPlanFactory.getRemoteInstance().getMaterialPlanCollection(viewInfo);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        if (materialPlanColls != null && materialPlanColls.size() > 0) {
            materialPlanInfo = materialPlanColls.get(0);
        }
        return materialPlanInfo;
    }

    private SelectorItemCollection getMaterialPlanSelector() {
        SelectorItemCollection coll = new SelectorItemCollection();
        coll.add("productUnit.id");
        coll.add("produceLeadTime");
        coll.add("recevingLeadTime");
        coll.add("forwardProcessTime");
        coll.add("backwardProcessTime");
        coll.add("material.id");
        coll.add("orgUnit.id");
        coll.add("leadTimeType");
        coll.add("changeBatch");
        coll.add("changeLeadTime");
        return coll;
    }

    private void calculateTotalQtySplit() {
        BigDecimal totalQtySplit = DEFAULT_QTY;
        BigDecimal newPlanOrderQty = DEFAULT_QTY;
        for (int i = 0; i < this.kDTable1.getRowCount(); ++i) {
            newPlanOrderQty = (BigDecimal)this.kDTable1.getCell(i, TABLE_COLUMN_QTY).getValue();
            if (newPlanOrderQty == null) continue;
            totalQtySplit = totalQtySplit.add(newPlanOrderQty);
        }
        this.txtTotalQtySplit.setValue((Object)totalQtySplit);
    }

    private List calculateQty(BigDecimal billNumber) {
        ArrayList<BigDecimal> splitQtys = new ArrayList<BigDecimal>();
        if (this.isAverageSplit()) {
            BigDecimal planOrderQty = this.planOrderInfo.getQty();
            BigDecimal requestQty = planOrderQty.divide(billNumber, this.precision, 4);
            BigDecimal preRequestQty = requestQty.multiply(billNumber.subtract(new BigDecimal("1")));
            BigDecimal lastRequestQty = planOrderQty.subtract(preRequestQty);
            for (int i = 0; i < billNumber.intValue() - 1; ++i) {
                splitQtys.add(requestQty);
            }
            splitQtys.add(lastRequestQty);
        } else {
            for (int i = 0; i < billNumber.intValue(); ++i) {
                splitQtys.add(DEFAULT_QTY);
            }
        }
        return splitQtys;
    }

    private List calculateBaseQty(List splitQtys) throws EASBizException, BOSException {
        ArrayList<BigDecimal> splitBseQtys = new ArrayList<BigDecimal>();
        if (this.isAverageSplit()) {
            MaterialInfo material = this.planOrderInfo.getMaterial();
            BigDecimal planOrderBaseQty = this.planOrderInfo.getBaseQty();
            BigDecimal preRequesBasetQty = MMConstant.BIGDECIMAL_ZERO;
            BigDecimal splitBaseQty = MMConstant.BIGDECIMAL_ZERO;
            for (int i = 0; i < splitQtys.size() - 1; ++i) {
                splitBaseQty = SCMUtils.getExchangePricesionQtyForClient((String)material.getId().toString(), (MeasureUnitInfo)this.planOrderInfo.getProductUnit(), (MeasureUnitInfo)this.planOrderInfo.getUnit(), (BigDecimal)((BigDecimal)splitQtys.get(i)));
                splitBseQtys.add(splitBaseQty);
                preRequesBasetQty = preRequesBasetQty.add(splitBaseQty);
            }
            BigDecimal lastRequestQty = planOrderBaseQty.subtract(preRequesBasetQty);
            splitBseQtys.add(lastRequestQty);
        } else {
            for (int i = 0; i < splitQtys.size(); ++i) {
                splitBseQtys.add(DEFAULT_QTY);
            }
        }
        return splitBseQtys;
    }

    private void setQtyFieldsPrecision() {
        SCMClientUtils.changeTableColPrecision((int)this.precision, (KDFormattedTextField[])this.txtRequestQty);
        for (int i = 0; i < this.kDTable1.getRowCount(); ++i) {
            SCMClientUtils.changeTableColPrecision((int)this.precision, (KDTable)this.kDTable1, (String[])TABLE_QTY, (int)i);
        }
    }

    private void checkBeforeSplit() {
        if (this.kDTable1.getRowCount() < 1) {
            SysUtil.abort();
        }
        if (this.isTotalQtySplitIllegal()) {
            MsgBox.showInfo((String)this.getResource("TOTALQTYSPLIT_LT_QTY"));
            SysUtil.abort();
        }
        for (int i = 0; i < this.kDTable1.getRowCount(); ++i) {
            if (this.isSplitQtyEqZero(i)) {
                MsgBox.showInfo((String)MessageFormat.format(this.getResource("SPLITQTY_CANNOT_EQ_ZERO"), this.kDTable1.getCell(i, TABLE_COLUMN_NUMBER).getValue()));
                SysUtil.abort();
            }
            if (!this.isSplitQtyBelowZero(i)) continue;
            MsgBox.showInfo((String)MessageFormat.format(this.getResource("SPLITQTY_CANNOT_BELOW_ZERO"), this.kDTable1.getCell(i, TABLE_COLUMN_NUMBER).getValue()));
            SysUtil.abort();
        }
    }

    private boolean isSplitQtyEqZero(int rowNumber) {
        BigDecimal spltQty = (BigDecimal)this.kDTable1.getCell(rowNumber, TABLE_COLUMN_QTY).getValue();
        return spltQty == null || spltQty.compareTo(DEFAULT_QTY) == 0;
    }

    private boolean isSplitQtyBelowZero(int rowNumber) {
        BigDecimal spltQty = (BigDecimal)this.kDTable1.getCell(rowNumber, TABLE_COLUMN_QTY).getValue();
        return spltQty != null && spltQty.compareTo(DEFAULT_QTY) < 0;
    }

    private boolean isTotalQtySplitIllegal() {
        BigDecimal totalQtySplit = (BigDecimal)this.txtTotalQtySplit.getNumberValue();
        return this.planOrderInfo.getQty().compareTo(totalQtySplit) < 0;
    }

    private String getResource(String key) {
        return EASResource.getString((String)"com.kingdee.eas.mm.planning.client.PlanningResource", (String)key);
    }

    private List encapsulateSplitParams() {
        BigDecimal totalQtySplit = (BigDecimal)this.txtTotalQtySplit.getNumberValue();
        BigDecimal qty = (BigDecimal)this.txtQty.getNumberValue();
        BigDecimal baseQty = this.planOrderInfo.getBaseQty();
        BigDecimal remainQty = qty.subtract(totalQtySplit);
        ArrayList splitParams = new ArrayList();
        HashMap<String, Object> planOrderParam = null;
        BigDecimal splitQty = null;
        BigDecimal splitBaseQty = null;
        BigDecimal totalProductsQty = this.planOrderInfo.getFinalProductsQty();
        BigDecimal calcProductsQty = MMConstant.BIGDECIMAL_ZERO;
        BigDecimal finalProductsQty = null;
        int num = this.kDTable1.getRowCount();
        for (int i = 0; i < num; ++i) {
            planOrderParam = new HashMap<String, Object>();
            planOrderParam.put(TABLE_COLUMN_NUMBER, this.kDTable1.getCell(i, TABLE_COLUMN_NUMBER).getValue());
            splitQty = (BigDecimal)this.kDTable1.getCell(i, TABLE_COLUMN_QTY).getValue();
            splitBaseQty = (BigDecimal)this.kDTable1.getCell(i, TABLE_COLUMN_BASEQTY).getValue();
            planOrderParam.put(TABLE_COLUMN_QTY, splitQty);
            planOrderParam.put(TABLE_COLUMN_BASEQTY, splitBaseQty);
            planOrderParam.put("startDate", this.kDTable1.getCell(i, TABLE_COLUMN_PLANSTARTDATE).getValue());
            planOrderParam.put("endDate", this.kDTable1.getCell(i, TABLE_COLUMN_PLANENDDATE).getValue());
            planOrderParam.put(TABLE_COLUMN_AVAILABLEDATE, this.kDTable1.getCell(i, TABLE_COLUMN_AVAILABLEDATE).getValue());
            planOrderParam.put("remainQty", remainQty);
            if (i == num - 1 && remainQty.compareTo(MMConstant.BIGDECIMAL_ZERO) == 0) {
                finalProductsQty = totalProductsQty.subtract(calcProductsQty);
            } else {
                finalProductsQty = this.getFinalProductsQty(splitQty);
                calcProductsQty = calcProductsQty.add(finalProductsQty);
            }
            planOrderParam.put("finalProductsQty", finalProductsQty);
            splitParams.add(planOrderParam);
        }
        return splitParams;
    }

    private BigDecimal getFinalProductsQty(BigDecimal qty) {
        BigDecimal finalProductsRate = this.planOrderInfo.getFinalProductsRate();
        finalProductsRate = finalProductsRate.divide(new BigDecimal("100.00"), 4, 2);
        BigDecimal finalProductsQty = qty.multiply(finalProductsRate).setScale(this.precision, 1);
        return finalProductsQty;
    }

    private void planOrderSplit() throws Exception {
        ArrayList dateParam = new ArrayList();
        HashMap<String, Object> dateAndOffset = null;
        for (int i = 0; i < this.kDTable1.getRowCount(); ++i) {
            dateAndOffset = new HashMap<String, Object>();
            dateAndOffset.put("offset", new Integer(this.materialPlanInfo.getRecevingLeadTime()));
            dateAndOffset.put("srcDate", this.kDTable1.getCell(i, TABLE_COLUMN_PLANENDDATE).getValue());
            dateParam.add(dateAndOffset);
        }
        IPlannedOrder planOrderInterface = (IPlannedOrder)this.getBizInterface();
        String storageOrgUnitId = this.planOrderInfo.getStorageOrgUnit().getId().toString();
        String planOrderId = this.planOrderInfo.getId().toString();
        List avalableDates = planOrderInterface.getValidateCalendar(storageOrgUnitId, dateParam);
        for (int i = 0; i < this.kDTable1.getRowCount(); ++i) {
            this.kDTable1.getCell(i, TABLE_COLUMN_AVAILABLEDATE).setValue(avalableDates.get(i));
        }
        List splitParams = this.encapsulateSplitParams();
        planOrderInterface.planOrderSplit(storageOrgUnitId, planOrderId, splitParams);
        this.isSplitSuccess = true;
    }

    private int getPrecision(MaterialInfo materialInfo, MeasureUnitInfo unitInfo) throws Exception {
        IMultiMeasureUnit imultiUnit;
        MultiMeasureUnitInfo multiUnitInfo;
        int precision = 2;
        if (materialInfo != null && unitInfo != null && (multiUnitInfo = (imultiUnit = MultiMeasureUnitFactory.getRemoteInstance()).getMultiUnit(materialInfo.getId().toString(), unitInfo.getId().toString())) != null) {
            precision = multiUnitInfo.getQtyPrecision();
        }
        return precision;
    }

    private void calcEndDate(IRow curRow, Date startDate, BigDecimal qty, boolean isChangeQty) throws EASBizException, BOSException {
        if (isChangeQty && MaterialLeadTimeTypeEnum.FIXBATCHTYPE.equals((Object)this.materialPlanInfo.getLeadTimeType())) {
            return;
        }
        PlannedOrderTypeEnum orderType = this.planOrderInfo.getOrderType();
        Date endDate = PLSUtil.getPlannedEndDate(orderType, this.materialPlanInfo, startDate, qty);
        curRow.getCell(TABLE_COLUMN_PLANENDDATE).setValue((Object)endDate);
        this.calcAvailableDate(curRow, endDate);
    }

    private void calcAvailableDate(IRow curRow, Date endDate) throws EASBizException, BOSException {
        String orgId = this.materialPlanInfo.getOrgUnit().getId().toString();
        Date availableDate = PLSUtil.getAvalibleDate(orgId, endDate, this.materialPlanInfo.getRecevingLeadTime());
        curRow.getCell(TABLE_COLUMN_AVAILABLEDATE).setValue((Object)availableDate);
    }
}

