/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.extendcontrols.ext.IFilterInfoProducer;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.license.LicenseException;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.NewOrgUnitFilterInfoProducer;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.mm.basedata.PlanVersionSetInfo;
import com.kingdee.eas.mm.common.client.MMSpecialLicenseAdapter;
import com.kingdee.eas.mm.planning.PlanOrderException;
import com.kingdee.eas.mm.planning.PlannedOrderFactory;
import com.kingdee.eas.mm.planning.client.AbstractPlanSimulantListCreateToUI;
import com.kingdee.eas.mm.planning.client.PlannedOrderListUI;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.scm.common.service.SCMServiceFactory;
import com.kingdee.eas.scm.common.util.SortUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;

public class PlanSimulantListCreateToUI
extends AbstractPlanSimulantListCreateToUI {
    private static final long serialVersionUID = 2602604341667974743L;
    private static final String TB_SELECTED = "colSelect";
    private static final String TB_PLANID = "colPlanID";
    private static final String TB_PLANNUMBER = "colPlanNum";
    private static final String TB_PLANNAME = "colPlanName";
    private static final String TB_PLAUDITCOUNT = "colPLAuditCount";
    private static final String TB_PLSUMMITCOUNT = "colPLSubmitCount";
    private OrgUnitInfo mainOrg = null;
    private int idxDefaultMainOrg = -1;
    private OrgUnitInfo[] mainOrgs = null;
    private String uiName = EASResource.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"95_PlanSimulantListCreateToUI");
    private MMSpecialLicenseAdapter licenseAdapter = null;

    @Override
    public void actionPlanOrderView_actionPerformed(ActionEvent e) throws Exception {
        IRow row = null;
        for (int i = 0; i < this.kdtPLTable.getRowCount(); ++i) {
            Boolean isSelect = (Boolean)this.kdtPLTable.getRow(i).getCell(TB_SELECTED).getValue();
            if (!isSelect.booleanValue()) continue;
            row = this.kdtPLTable.getRow(i);
        }
        if (row == null || row.getCell(TB_PLANNUMBER).getValue() == null) {
            return;
        }
        super.actionPlanOrderView_actionPerformed(e);
        UIContext uiContext = new UIContext((Object)this);
        StorageOrgUnitInfo info = (StorageOrgUnitInfo)this.prmtOrgUnit.getValue();
        PlanVersionSetInfo plVerSet = new PlanVersionSetInfo();
        plVerSet.setId(BOSUuid.read((String)row.getCell(TB_PLANID).getValue().toString()));
        plVerSet.setNumber(row.getCell(TB_PLANNUMBER).getValue().toString());
        plVerSet.setName(row.getCell(TB_PLANNAME).getValue().toString());
        uiContext.put((Object)"SCHEME", (Object)plVerSet);
        uiContext.put((Object)"STORAGEORGUNIT", (Object)info);
        IUIWindow uiWindow = null;
        uiWindow = SwingUtilities.getWindowAncestor((Component)((Object)this)) != null && SwingUtilities.getWindowAncestor((Component)((Object)this)) instanceof JDialog ? UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(this.getEditUIName(), (Map)uiContext, null, OprtState.EDIT) : UIFactory.createUIFactory((String)this.getEditUIModal()).create(this.getEditUIName(), (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
        StorageOrgUnitInfo info = (StorageOrgUnitInfo)this.prmtOrgUnit.getValue();
        if (info == null) {
            return;
        }
        this.refreshKdtTableData(info);
        if (this.kdtPLTable.getRowCount() == 0) {
            this.kdtPLTable.getColumn(TB_SELECTED).getStyleAttributes().setLocked(true);
            IRow row = this.kdtPLTable.addRow();
            row.getCell(TB_SELECTED).setValue((Object)Boolean.FALSE);
            this.kdtPLTable.getColumn(TB_PLSUMMITCOUNT).getStyleAttributes().setLocked(true);
        } else {
            this.kdtPLTable.getColumn(TB_PLSUMMITCOUNT).getStyleAttributes().setLocked(true);
        }
    }

    @Override
    public void actionTransform_actionPerformed(ActionEvent e) throws Exception {
        if (this.prmtOrgUnit.getValue() == null) {
            String msg = this.getPlanOrderResource("STORAGE_NOT_NULL");
            MsgBox.showInfo((String)msg);
            return;
        }
        this.checkHasAuditedOrders();
        ArrayList<String> planVersionIds = new ArrayList<String>();
        ArrayList<String> planVersionNumbers = new ArrayList<String>();
        IRow row = null;
        for (int i = 0; i < this.kdtPLTable.getRowCount(); ++i) {
            row = this.kdtPLTable.getRow(i);
            if (!((Boolean)row.getCell(TB_SELECTED).getValue()).booleanValue()) continue;
            planVersionIds.add(row.getCell(TB_PLANID).getValue().toString());
            planVersionNumbers.add(row.getCell(TB_PLANNUMBER).getValue().toString());
        }
        String[] sNumber = new String[]{((Object)planVersionNumbers).toString()};
        StorageOrgUnitInfo orgUnitInfo = (StorageOrgUnitInfo)this.prmtOrgUnit.getValue();
        String msg = this.getPlanOrderResource("MSG_PL_TRANSFORMSUCESS");
        MessageFormat msgFmt = new MessageFormat(msg);
        if (MsgBox.showConfirm2((String)msgFmt.format(sNumber)) == 0) {
            Map errorMap = PlannedOrderFactory.getRemoteInstance().simulantTransform(orgUnitInfo.getId().toString(), planVersionIds);
            if (errorMap.size() > 0) {
                String errorMsg = MessageFormat.format(this.getPlanOrderResource("SIMULANT_TRANSFER_ERROR"), new Integer(errorMap.size()));
                String seperator = "     ";
                StringBuffer detailMsg = new StringBuffer(this.getPlanOrderResource("BILLNUMBER_AND_FAILREASON"));
                detailMsg.append("\n");
                for (String key : errorMap.keySet()) {
                    detailMsg.append(key).append(seperator).append(errorMap.get(key)).append("\n");
                }
                MsgBox.showDetailAndOK((Component)((Object)this), (String)errorMsg, (String)detailMsg.toString(), (int)0);
            } else {
                MsgBox.showInfo((String)this.getPlanOrderResource("MSG_PL_TRANSFORMSUCESS1"));
            }
            this.refreshKdtTableData(orgUnitInfo);
        }
    }

    private void initData() throws Exception {
        this.kdtPLTable.checkParsed();
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.btnPlanOrderView.setIcon(EASResource.getIcon((String)"imgTbtn_showlist"));
        this.btnTransform.setIcon(EASResource.getIcon((String)"imgTbtn_referbatch"));
        this.btnPlanOrderDelete.setIcon(EASResource.getIcon((String)"imgTbtn_delete"));
        this.menuItemRemove.setIcon(EASResource.getIcon((String)"imgTbtn_delete"));
        this.actionPlanOrderView.setEnabled(false);
        try {
            this.prmtOrgUnit.setEntityViewInfo(SCMClientUtils.getStorageOrgF7OUFilter());
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
        }
        this.prmtOrgUnit.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                PlanSimulantListCreateToUI.this.prmtOrgUnitOrgUnit_dataChanged(e);
            }
        });
        this.kdtPLTable.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editValueChanged(KDTEditEvent e) {
                try {
                    PlanSimulantListCreateToUI.this.kdtPLTable_Changed(e);
                }
                catch (Exception exc) {
                    PlanSimulantListCreateToUI.this.handUIException(exc);
                }
            }
        });
        this.kdtPLTable.getColumn(TB_PLANID).getStyleAttributes().setHided(true);
        this.kdtPLTable.getColumn(TB_PLANID).getStyleAttributes().setLocked(true);
        this.kdtPLTable.getColumn(TB_PLANNUMBER).getStyleAttributes().setLocked(true);
        this.kdtPLTable.getColumn(TB_PLANNAME).getStyleAttributes().setLocked(true);
        this.kdtPLTable.getColumn(TB_PLANNAME).setWidth(150);
        this.kdtPLTable.getColumn(TB_PLSUMMITCOUNT).getStyleAttributes().setLocked(true);
        this.kdtPLTable.getColumn(TB_PLSUMMITCOUNT).setWidth(180);
        this.kdtPLTable.getColumn(TB_PLAUDITCOUNT).getStyleAttributes().setLocked(true);
        this.kdtPLTable.getColumn(TB_PLAUDITCOUNT).setWidth(180);
        this.kdtPLTable.getColumn(TB_SELECTED).getStyleAttributes().setLocked(true);
        this.kdtPLTable.getColumn(TB_SELECTED).setWidth(50);
        KDCheckBox chkBox = new KDCheckBox();
        KDTDefaultCellEditor bizchkBoxEditor = new KDTDefaultCellEditor((JCheckBox)chkBox);
        this.kdtPLTable.getColumn(TB_SELECTED).setEditor((ICellEditor)bizchkBoxEditor);
        IRow row = this.kdtPLTable.addRow();
        row.getCell(TB_SELECTED).setValue((Object)Boolean.FALSE);
        this.kdtPLTable.getColumn(TB_PLSUMMITCOUNT).getStyleAttributes().setLocked(true);
        StorageOrgUnitInfo info = (StorageOrgUnitInfo)this.getDefaultMainBizOrg();
        this.prmtOrgUnit.setRequired(true);
        if (info == null) {
            return;
        }
        this.prmtOrgUnit.setValue((Object)info);
        this.refreshKdtTableData(info);
        if (this.kdtPLTable.getRowCount() == 0) {
            this.kdtPLTable.getColumn(TB_SELECTED).getStyleAttributes().setLocked(true);
            row = this.kdtPLTable.addRow();
            row.getCell(TB_SELECTED).setValue((Object)Boolean.FALSE);
            this.kdtPLTable.getColumn(TB_PLSUMMITCOUNT).getStyleAttributes().setLocked(true);
        } else {
            this.kdtPLTable.getColumn(TB_PLSUMMITCOUNT).getStyleAttributes().setLocked(true);
        }
    }

    private void prmtOrgUnitOrgUnit_dataChanged(DataChangeEvent e) {
        if (!SCMGroupClientUtils.isDiffrent((Object)e.getNewValue(), (Object)e.getOldValue())) {
            return;
        }
        StorageOrgUnitInfo info = (StorageOrgUnitInfo)e.getNewValue();
        if (info != null) {
            try {
                this.refreshKdtTableData(info);
            }
            catch (Exception e1) {
                this.handUIExceptionAndAbort(e1);
            }
        } else {
            int i;
            int i2;
            MsgBox.showInfo((String)this.getPlanOrderResource("STORAGE_NOT_NULL"));
            DataChangeListener[] datachange = (DataChangeListener[])this.prmtOrgUnit.getListeners(DataChangeListener.class);
            ChangeListener[] changelistener = (ChangeListener[])this.prmtOrgUnit.getListeners(ChangeListener.class);
            for (i2 = 0; i2 < datachange.length; ++i2) {
                this.prmtOrgUnit.removeDataChangeListener(datachange[i2]);
            }
            for (i2 = 0; i2 < changelistener.length; ++i2) {
                this.prmtOrgUnit.removeChangeListener(changelistener[i2]);
            }
            StorageOrgUnitInfo oldStorageOrgUnitInfo = (StorageOrgUnitInfo)e.getOldValue();
            this.prmtOrgUnit.setValue((Object)oldStorageOrgUnitInfo);
            for (i = 0; i < datachange.length; ++i) {
                this.prmtOrgUnit.addDataChangeListener(datachange[i]);
            }
            for (i = 0; i < changelistener.length; ++i) {
                this.prmtOrgUnit.addChangeListener(changelistener[i]);
            }
            this.prmtOrgUnit.requestFocus();
        }
    }

    private void refreshKdtTableData(StorageOrgUnitInfo info) throws EASBizException, BOSException {
        IRowSet rs = null;
        this.kdtPLTable.removeRows();
        IRow row = null;
        try {
            rs = PlannedOrderFactory.getRemoteInstance().getSchemeInfo(info.getId().toString());
            this.kdtPLTable.removeRows();
            while (rs.next()) {
                row = this.kdtPLTable.addRow();
                row.getCell(TB_SELECTED).setValue((Object)Boolean.FALSE);
                row.getCell(TB_PLANID).setValue((Object)rs.getString("FSchemeID"));
                row.getCell(TB_PLANNUMBER).setValue((Object)rs.getString("FNumber"));
                row.getCell(TB_PLANNAME).setValue((Object)rs.getString("FName"));
                row.getCell(TB_PLAUDITCOUNT).setValue((Object)rs.getString("FPLAuditCount"));
                row.getCell(TB_PLSUMMITCOUNT).setValue((Object)rs.getString("FPLsubmitCount"));
            }
            if (this.kdtPLTable.getRowCount() > 0) {
                this.kdtPLTable.getColumn(TB_SELECTED).getStyleAttributes().setLocked(false);
            } else {
                this.kdtPLTable.getColumn(TB_SELECTED).getStyleAttributes().setLocked(true);
            }
            this.actionTransform.setEnabled(false);
            this.actionTransformInBatch.setEnabled(false);
            this.actionPlanOrderView.setEnabled(false);
            this.actionPlanOrderDelete.setEnabled(false);
        }
        catch (PlanOrderException e1) {
            throw new BOSException((Throwable)((Object)e1));
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public void kdtPLTable_Changed(KDTEditEvent e) throws Exception {
        Object newValue = e.getValue();
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        String fieldName = this.kdtPLTable.getColumnKey(colIndex);
        if (TB_SELECTED.equalsIgnoreCase(fieldName)) {
            if (this.kdtPLTable.getRow(rowIndex).getCell(TB_PLANNUMBER).getValue() == null) {
                e.setCancel(false);
            }
            this.kdtPLTable.getRow(rowIndex).getCell(TB_SELECTED).setValue(newValue);
            int rowsSelected = this.getRowsSelected();
            if (rowsSelected < 1) {
                this.actionTransform.setEnabled(false);
                this.actionPlanOrderView.setEnabled(false);
                this.actionTransformInBatch.setEnabled(false);
                this.actionPlanOrderDelete.setEnabled(false);
            }
            if (rowsSelected == 1) {
                this.actionTransform.setEnabled(true);
                this.actionPlanOrderView.setEnabled(true);
                this.actionTransformInBatch.setEnabled(true);
                this.actionPlanOrderDelete.setEnabled(true);
            }
            if (rowsSelected > 1) {
                this.actionTransform.setEnabled(true);
                this.actionPlanOrderView.setEnabled(false);
                this.actionTransformInBatch.setEnabled(false);
                this.actionPlanOrderDelete.setEnabled(true);
            }
        }
    }

    private int getRowsSelected() {
        int count = 0;
        for (int i = 0; i < this.kdtPLTable.getRowCount(); ++i) {
            if (!((Boolean)this.kdtPLTable.getRow(i).getCell(TB_SELECTED).getValue()).booleanValue()) continue;
            ++count;
        }
        return count;
    }

    private String getEditUIName() {
        return PlannedOrderListUI.class.getName();
    }

    private String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UINewTabFactory";
    }

    private int getSelectRowIndex() {
        int rowIndex = -1;
        KDTSelectBlock selectBlock = this.kdtPLTable.getSelectManager().get();
        if (selectBlock != null) {
            rowIndex = selectBlock.getTop();
        }
        return rowIndex;
    }

    private String getPlanOrderResource(String sKey) {
        return EASResource.getString((String)"com.kingdee.eas.mm.planning.client.PlanningResource", (String)sKey);
    }

    protected void setMainBizOrgF7(KDBizPromptBox bizOrgUnitBox, OrgType orgType) {
        NewOrgUnitFilterInfoProducer iProducer = new NewOrgUnitFilterInfoProducer(orgType);
        String permissionItem = this.getPermissionItem(this.getOprtState());
        if (permissionItem != null) {
            iProducer.getModel().setPermissionItem(permissionItem);
        }
        bizOrgUnitBox.setFilterInfoProducer((IFilterInfoProducer)iProducer);
        bizOrgUnitBox.setCommitFormat("$number$;$code$");
    }

    protected String getPermissionItem(String status) {
        return "mm_planorder_view";
    }

    protected KDBizPromptBox getMainBizOrg() {
        return this.prmtOrgUnit;
    }

    private void checkSpecialLicense(String planMode) {
        String fullName = "com.kingdee.eas.mm.planning.client.PlanSimulantListCreateToUI";
        if (planMode != null) {
            if (planMode.equalsIgnoreCase("MRP")) {
                fullName = fullName + "_MRP";
            } else if (planMode.equalsIgnoreCase("MPS")) {
                fullName = fullName + "_MPS";
            }
            this.licenseAdapter = new MMSpecialLicenseAdapter(fullName, planMode);
            try {
                this.licenseAdapter.requestLicenseOrReleaseLicense(true, (IUIObject)this, this.uiName);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.abort();
            }
        }
    }

    public boolean destroyWindow() {
        boolean b = super.destroyWindow();
        if (b) {
            try {
                if (this.licenseAdapter != null) {
                    this.licenseAdapter.requestLicenseOrReleaseLicense(false, (IUIObject)this, this.uiName);
                }
            }
            catch (LicenseException e) {
                e.printStackTrace();
                this.abort();
            }
            catch (Exception e) {
                e.printStackTrace();
                this.abort();
            }
        }
        return b;
    }

    public void onLoad() throws Exception {
        String uiParam = (String)this.getUIContext().get("UIClassParam");
        this.checkSpecialLicense(uiParam);
        super.onLoad();
        this.setMainBizOrgF7(this.getMainBizOrg(), this.getMainBizOrgType());
        this.initData();
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    protected final OrgUnitInfo getDefaultMainBizOrg() {
        OrgUnitInfo currentMainOrg;
        if (this.mainOrg != null) {
            return this.mainOrg;
        }
        if (this.idxDefaultMainOrg > -1) {
            return this.mainOrgs[this.idxDefaultMainOrg];
        }
        if (this.mainOrgs == null) {
            try {
                this.mainOrgs = SCMServiceFactory.getPermissionService().getAuthorizedBizOrgUnits((IObjectPK)new ObjectStringPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString()), this.getMainBizOrgType(), this.getPermissionItem("ADDNEW"));
                if (this.mainOrgs == null || this.mainOrgs.length == 0) {
                    return null;
                }
                if (this.mainOrgs.length > 0) {
                    this.mainOrgs = (OrgUnitInfo[])SortUtil.sortDataByNumber((DataBaseInfo[])this.mainOrgs, (boolean)true);
                }
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        if ((currentMainOrg = SysContext.getSysContext().getCurrentOrgUnit(this.getMainBizOrgType())) != null && this.mainOrgs != null && this.mainOrgs.length > 0) {
            for (int i = 0; i < this.mainOrgs.length; ++i) {
                if (!currentMainOrg.getId().toString().equals(this.mainOrgs[i].getId().toString())) continue;
                this.idxDefaultMainOrg = i;
                return currentMainOrg;
            }
        }
        if (this.mainOrgs.length > 0) {
            this.idxDefaultMainOrg = 0;
            return this.mainOrgs[0];
        }
        return null;
    }

    @Override
    public void actionTransformInBatch_actionPerformed(ActionEvent e) throws Exception {
        IUIWindow uiWindow = null;
        if (this.getMainBizOrg().getValue() == null) {
            MsgBox.showInfo((String)this.getPlanOrderResource("STORAGE_NOT_NULL"));
            SysUtil.abort();
        }
        this.checkHasAuditedOrders();
        StorageOrgUnitInfo storageOrgUnit = (StorageOrgUnitInfo)this.getMainBizOrg().getValue();
        this.getUIContext().put("storageOrgUnit", storageOrgUnit);
        PlanVersionSetInfo planVersionSetInfo = new PlanVersionSetInfo();
        ArrayList<IRow> PlanVersionList = new ArrayList<IRow>();
        for (int i = 0; i < this.kdtPLTable.getRowCount(); ++i) {
            if (!this.kdtPLTable.getRow(i).getCell(TB_SELECTED).getValue().equals(Boolean.TRUE)) continue;
            PlanVersionList.add(this.kdtPLTable.getRow(i));
        }
        if (PlanVersionList.size() == 1) {
            IRow planVersionRow = (IRow)PlanVersionList.get(0);
            planVersionSetInfo.setId(BOSUuid.read((String)planVersionRow.getCell(TB_PLANID).getValue().toString()));
            planVersionSetInfo.setNumber(planVersionRow.getCell(TB_PLANNUMBER).getValue().toString());
            planVersionSetInfo.setName(planVersionRow.getCell(TB_PLANNAME).getValue().toString());
            this.getUIContext().put("planVersionSetInfo", planVersionSetInfo);
        } else if (PlanVersionList.size() > 1) {
            MsgBox.showInfo((String)this.getPlanOrderResource("SUPPORT_TRANSFORM_ONE_PLANVERSION"));
            SysUtil.abort();
        }
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create("com.kingdee.eas.mm.planning.client.SimulantPlanOrderListUI", this.getUIContext(), null, OprtState.VIEW, 95);
        uiWindow.show();
    }

    @Override
    public void actionPlanOrderDelete_actionPerformed(ActionEvent e) throws Exception {
        if (MsgBox.showConfirm2((String)this.getPlanOrderResource("DELETE_PLANORDER_CONFIRM")) == 0) {
            ArrayList<String> planVersionIds = new ArrayList<String>();
            IRow row = null;
            for (int i = 0; i < this.kdtPLTable.getRowCount(); ++i) {
                row = this.kdtPLTable.getRow(i);
                if (!((Boolean)row.getCell(TB_SELECTED).getValue()).booleanValue()) continue;
                planVersionIds.add(row.getCell(TB_PLANID).getValue().toString());
            }
            StorageOrgUnitInfo storageOrgUnitInfo = (StorageOrgUnitInfo)this.prmtOrgUnit.getValue();
            PlannedOrderFactory.getRemoteInstance().deletePlanOrder(storageOrgUnitInfo.getId().toString(), planVersionIds);
            MsgBox.showInfo((String)this.getPlanOrderResource("DELETE_PLANORDER_SUCCESS"));
            this.refreshKdtTableData(storageOrgUnitInfo);
        }
    }

    private void checkHasAuditedOrders() {
        ArrayList<String> auditedOrderIsNull = new ArrayList<String>();
        IRow row = null;
        for (int i = 0; i < this.kdtPLTable.getRowCount(); ++i) {
            row = this.kdtPLTable.getRow(i);
            if (!((Boolean)row.getCell(TB_SELECTED).getValue()).booleanValue() || new Integer((String)row.getCell(TB_PLAUDITCOUNT).getValue()) != 0) continue;
            auditedOrderIsNull.add(row.getCell(TB_PLANNUMBER).getValue().toString());
        }
        if (auditedOrderIsNull.size() > 0) {
            String errorMsg = this.getPlanOrderResource("NO_AUDITED_PLANORDER");
            MsgBox.showInfo((String)MessageFormat.format(errorMsg, ((Object)auditedOrderIsNull).toString()));
            SysUtil.abort();
        }
    }
}

