/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.btp.client.BTPBillListImpl;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.base.license.LicenseException;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchaction.ActionLevelEnum;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchSelectionEntries;
import com.kingdee.eas.framework.client.CoreBillListUI;
import com.kingdee.eas.framework.query.QuickFilteringSupportItems;
import com.kingdee.eas.framework.util.BizOrgEnum;
import com.kingdee.eas.framework.util.DateEnum;
import com.kingdee.eas.mm.basedata.PlanVersionSetInfo;
import com.kingdee.eas.mm.common.client.KDTableUtils;
import com.kingdee.eas.mm.common.client.MMSpecialLicenseAdapter;
import com.kingdee.eas.mm.common.util.EditTableUtil;
import com.kingdee.eas.mm.common.util.ResourceUtils;
import com.kingdee.eas.mm.planning.IPlannedOrder;
import com.kingdee.eas.mm.planning.PlannedOrderFactory;
import com.kingdee.eas.mm.planning.PlannedOrderInfo;
import com.kingdee.eas.mm.planning.PlannedOrderNewMappingFacadeFactory;
import com.kingdee.eas.mm.planning.client.AbstractPlannedOrderListUI;
import com.kingdee.eas.mm.planning.client.PlanOrderSplitDialog;
import com.kingdee.eas.mm.planning.client.PlannedOrderFilterUI;
import com.kingdee.eas.mm.project.client.ListSubmitActionProxy;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.ISCMBillParam;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.common.SCMBillParamFactory;
import com.kingdee.eas.scm.common.action.ActionProxy;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.sm.pur.util.PurUtil;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import javax.swing.AbstractButton;

public class PlannedOrderListUI
extends AbstractPlannedOrderListUI {
    private static final long serialVersionUID = -5501882164910098735L;
    private static final String[] KDT_DATES = new String[]{"startDate", "endDate", "avilableDate"};
    private PlannedOrderFilterUI conditionPanel = null;
    CommonQueryDialog commonQueryDialog = null;
    private String uiName = EASResource.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"93_PlannedOrderListUI");
    private MMSpecialLicenseAdapter licenseAdapter = null;
    private QuickFilteringSupportItems qfsi = new QuickFilteringSupportItems(true, true);

    private void checkSpecialLicense(String planMode) {
        String fullName = "com.kingdee.eas.mm.planning.client.PlannedOrderListUI";
        fullName = planMode == null ? fullName + "_MRP" : (planMode.equalsIgnoreCase("MRP") ? fullName + "_MRP" : (planMode.equalsIgnoreCase("MPS") ? fullName + "_MPS" : fullName + "_MRP"));
        this.licenseAdapter = new MMSpecialLicenseAdapter(fullName, planMode);
        try {
            this.licenseAdapter.requestLicenseOrReleaseLicense(true, (IUIObject)this, this.uiName);
        }
        catch (LicenseException e) {
            e.printStackTrace();
            this.abort();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.abort();
        }
    }

    public boolean destroyWindow() {
        boolean b = super.destroyWindow();
        if (b) {
            try {
                if (this.licenseAdapter != null) {
                    this.licenseAdapter.requestLicenseOrReleaseLicense(false, (IUIObject)this, this.uiName);
                }
            }
            catch (LicenseException e) {
                e.printStackTrace();
                this.abort();
            }
            catch (Exception e) {
                e.printStackTrace();
                this.abort();
            }
        }
        return b;
    }

    public void onLoad() throws Exception {
        String planMode = (String)this.getUIContext().get("UIClassParam");
        this.checkSpecialLicense(planMode);
        super.onLoad();
        this.actionImportData.setVisible(false);
        this.actionExportData.setVisible(false);
        this.actionCreateTo.setVisible(false);
        this.actionReleaseDirect.setEnabled(true);
        this.btnDelVoucher.setVisible(false);
        this.btnVoucher.setVisible(false);
        this.btnReleaseDirect.setIcon(EASResource.getIcon((String)"imgTbtn_makeknown"));
        this.btnReleaseCollect.setIcon(EASCommonResource.getIcon((String)"com.kingdee.eas.basedata.common.EASImageResource", (String)"imgTbtn_musterputin", (Locale)SysContext.getSysContext().getLocale()));
        this.btnSubmit.setIcon(EASResource.getIcon((String)"imgTbtn_submit"));
        this.actionTraceUp.setEnabled(false);
        this.btnTraceUp.setVisible(false);
        this.menuItemTraceUp.setVisible(false);
        this.btnSubmit.setEnabled(false);
        this.btnSubmit.setVisible(false);
        this.menuItemSubmit.setVisible(false);
        this.actionSubmit.setEnabled(false);
        this.actionSubmit.setVisible(false);
        this.btnMultiapprove.setVisible(true);
        this.tblMain.getColumn("schemeid").getStyleAttributes().setHided(true);
        this.actionChange.setEnabled(true);
        this.btnChange.setIcon(EASResource.getIcon((String)"imgTbtn_assetchange"));
        this.menuItemChange.setIcon(EASResource.getIcon((String)"imgTbtn_assetchange"));
        this.menuReleaseDirect.setIcon(EASResource.getIcon((String)"imgTbtn_makeknown"));
        this.menuReleaseCollect.setIcon(EASCommonResource.getIcon((String)"com.kingdee.eas.basedata.common.EASImageResource", (String)"imgTbtn_musterputin", (Locale)SysContext.getSysContext().getLocale()));
        this.menuItemBatchSubmit.setIcon(EASResource.getIcon((String)"imgTbtn_submit"));
        this.btnBatchSubmit.setIcon(EASResource.getIcon((String)"imgTbtn_submit"));
        this.menuBizCloase.setIcon(EASResource.getIcon((String)"imgTbtn_close"));
        this.btnAttachment.setVisible(false);
        this.btnLocate.setVisible(false);
        this.btnAuditResult.setVisible(false);
        this.btnMultiapprove.setVisible(false);
        EditTableUtil.formatColDate((KDTable)this.tblMain, (String[])KDT_DATES);
        super.setReservationVisible(false);
    }

    protected void setDefaultQuickFilterInfo() {
        QuickFilteringSupportItems qfsi = this.getQuickFilteringSupport();
        if (qfsi != null) {
            qfsi.getSystemSolutionItem().getDefaultFilter().add("storageOrgUnit.id", CompareType.EQUALS, (Object)BizOrgEnum.DEFAULTMAINORG).add("productionOrgUnit.id", CompareType.EQUALS, (Object)BizOrgEnum.DEFAULTMAINORG).add("startDate", CompareType.IS, (Object)DateEnum.RECENTONEMONTH).add("endDate", CompareType.IS, (Object)DateEnum.RECENTONEMONTH);
        }
    }

    @Override
    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    public String getEntriesName() {
        return "entrys";
    }

    protected String getPropertyOfBizOrg(OrgType orgType) {
        if (orgType.equals((Object)OrgType.Storage)) {
            return "storageOrgUnit.id";
        }
        return null;
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return PlannedOrderFactory.getRemoteInstance();
    }

    @Override
    protected IObjectValue createNewData() {
        PlannedOrderInfo objectValue = new PlannedOrderInfo();
        return objectValue;
    }

    protected boolean initDefaultFilter() {
        return true;
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor exec = super.getQueryExecutor(queryPK, viewInfo);
        SorterItemCollection sorters = viewInfo.getSorter();
        for (int i = 0; i < sorters.size(); ++i) {
            if (!sorters.get(i).getPropertyName().equals(this.getEntriesName() + ".seq")) continue;
            sorters.removeObject(i);
            break;
        }
        return exec;
    }

    protected String getKeyFieldName() {
        return "id";
    }

    protected CustomerQueryPanel getFilterUI() throws Exception {
        if (this.conditionPanel == null) {
            HashMap<String, Object> hsMap = new HashMap<String, Object>();
            this.conditionPanel = new PlannedOrderFilterUI();
            if (this.getUIContext().get("STORAGEORGUNIT") != null) {
                hsMap.put("STORAGEORGUNIT", (StorageOrgUnitInfo)this.getUIContext().get("STORAGEORGUNIT"));
            }
            if (this.getUIContext().get("SCHEME") != null) {
                hsMap.put("SCHEME", (PlanVersionSetInfo)this.getUIContext().get("SCHEME"));
            }
            this.conditionPanel.setContextHashMap(hsMap);
        }
        return this.conditionPanel;
    }

    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        String[] planScheme = SCMClientUtils.getSelectRowFieldValue((KDTable)this.tblMain, (String)"schemeid");
        if (planScheme != null && planScheme.length > 0) {
            MutexServiceControlFactory.getRemoteInstance().requestObjIDForUpdate(planScheme[0]);
        }
        super.actionRemove_actionPerformed(e);
        if (planScheme != null && planScheme.length > 0) {
            MutexServiceControlFactory.getRemoteInstance().releaseObjIDForUpdate(planScheme[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        StorageOrgUnitInfo orgUnit = SysContext.getSysContext().getCurrentStorageUnit();
        boolean isAuditWhenSubmit = SCMClientUtils.isAuditWhenSubmit((String)orgUnit.getId().toString(), (int)4, (String)"660");
        super.actionSubmit_actionPerformed(e);
        this.checkSubmit();
        IPlannedOrder iPlannedOrder = PlannedOrderFactory.getRemoteInstance();
        String[] billIdlist = SCMClientUtils.getSelectRowFieldValue((KDTable)this.tblMain, (String)this.getKeyFieldName());
        SCMClientUtils.checkCurrentBillIsInActiveWorkFlow((String[])billIdlist);
        try {
            iPlannedOrder.submit(billIdlist[0]);
            MsgBox.showInfo((String)this.getPlanOrderResource("MSG_PL_SUBMITSUCESS"));
            if (isAuditWhenSubmit) {
                iPlannedOrder.audit(PurUtil.converStringtoIObjectPK((String[])billIdlist));
            }
            this.loadFields();
            this.refreshList();
        }
        catch (Throwable t) {
            this.handUIException(t);
        }
    }

    public boolean isUnAuditInParam(String orgUnitInfoID, int orgType, String billTypeNumber) throws EASBizException, BOSException {
        String paramNumber = "SCM_UnAudit_01";
        boolean isUnAuditInParam = false;
        ISCMBillParam scmParam = SCMBillParamFactory.getRemoteInstance();
        String strUnAudit = scmParam.getParamByBillTypeNumber(paramNumber, orgType, orgUnitInfoID, billTypeNumber);
        if (strUnAudit != null && strUnAudit.trim().length() != 0 && strUnAudit.trim().toLowerCase().equals("1")) {
            isUnAuditInParam = true;
        }
        return isUnAuditInParam;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.checkAudit();
        IPlannedOrder iPlannedOrder = PlannedOrderFactory.getRemoteInstance();
        String[] billIdlist = SCMClientUtils.getSelectRowFieldValue((KDTable)this.tblMain, (String)this.getKeyFieldName());
        String[] planScheme = SCMClientUtils.getSelectRowFieldValue((KDTable)this.tblMain, (String)"schemeid");
        ArrayList<String> lkList = new ArrayList<String>();
        SCMClientUtils.checkCurrentBillIsInActiveWorkFlow((String[])billIdlist);
        try {
            this.actionAudit.getExtendProperty("Mutex");
            this.setOprtState("AUDIT");
            int num = billIdlist.length;
            for (int j = 0; j < num; ++j) {
                this.pubFireVOChangeListener(billIdlist[j]);
            }
            if (planScheme != null) {
                int num1 = planScheme.length;
                for (int k = 0; k < num1; ++k) {
                    if (lkList.contains(planScheme[k])) continue;
                    lkList.add(planScheme[k]);
                }
                MutexServiceControlFactory.getRemoteInstance().batchRequestObjIDForUpdate(lkList);
            }
            iPlannedOrder.audit(PurUtil.converStringtoIObjectPK((String[])billIdlist));
            MsgBox.showInfo((String)this.getPlanOrderResource("MSG_PL_AuditSucess"));
            this.loadFields();
            this.refreshList();
        }
        catch (Throwable t) {
            this.handUIException(t);
        }
        finally {
            this.setOprtState("RELEASEALL");
            try {
                this.pubFireVOChangeListener(null);
            }
            catch (Throwable t) {
                this.handUIException(t);
            }
            if (planScheme != null) {
                MutexServiceControlFactory.getRemoteInstance().batchReleaseObjIDForUpdate(lkList);
            }
        }
    }

    @Override
    public void actionUnAudit_actionPerformed(ActionEvent e) throws Exception {
        StorageOrgUnitInfo orgUnit = SysContext.getSysContext().getCurrentStorageUnit();
        boolean isUnAuditInParam = this.isUnAuditInParam(orgUnit.getId().toString(), 4, "660");
        if (!isUnAuditInParam) {
            throw new SCMBillException(SCMBillException.ISUNAUDITINPARAM);
        }
        this.checkCanUnAudit();
        super.actionUnAudit_actionPerformed(e);
        MsgBox.showInfo((String)this.getPlanOrderResource("MSG_PL_UNAUDITSUCESS"));
        this.loadFields();
        this.refreshList();
    }

    protected void checkCanUnAudit() {
        int size = this.tblMain.getSelectManager().size();
        for (int j = 0; j < size; ++j) {
            KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get(j);
            if (selectBlock == null) continue;
            int num = selectBlock.getEndRow();
            for (int i = selectBlock.getTop(); i <= num && i >= 0; ++i) {
                String baseStatus;
                IRow row = this.tblMain.getRow(i);
                BigDecimal totalReleaseQty = (BigDecimal)row.getCell("totalReleaseQty").getValue();
                BigDecimal scheduleqty = (BigDecimal)row.getCell("scheduleqty").getValue();
                if (totalReleaseQty != null && totalReleaseQty.compareTo(new BigDecimal("0")) > 0) {
                    MsgBox.showError((String)this.getPlanOrderResource("PlannedOrder_has_targetBill"));
                    SysUtil.abort();
                }
                if (scheduleqty != null && scheduleqty.compareTo(new BigDecimal("0")) > 0) {
                    MsgBox.showError((String)this.getPlanOrderResource("PlannedOrder_has_targetBill"));
                    SysUtil.abort();
                }
                if ((baseStatus = row.getCell("baseStatus").getValue().toString()).trim().equalsIgnoreCase(BillBaseStatusEnum.AUDITED.toString())) continue;
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.scm.common.SDSMResource", (String)"check_unaudit"));
                SysUtil.abort();
            }
        }
    }

    private String getPlanOrderResource(String sKey) {
        return EASResource.getString((String)"com.kingdee.eas.mm.planning.client.PlanningResource", (String)sKey);
    }

    public String[] getMergeColumnKeys() {
        String[] columns = new String[]{"id", "number", "baseStatus", "sourceType", "material.number", "material.name", "material.model", "orderType", "startDate", "endDate", "avilableDate", "qty", "scheduleqty", "totalReleaseQty", "unit.name", "storageOrgUnit", "supplyStorageOrgUnit", "planner", "scheme", "calcID", "BomNumber", "materialAttribute", "schemeid", "project.number", "trackNumber.number"};
        return columns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionBizClose_actionPerformed(ActionEvent e) throws Exception {
        IPlannedOrder iPlannedOrder = PlannedOrderFactory.getRemoteInstance();
        this.checkClose();
        String[] billIdlist = SCMClientUtils.getSelectRowFieldValue((KDTable)this.tblMain, (String)this.getKeyFieldName());
        if (billIdlist == null) {
            return;
        }
        SCMClientUtils.checkCurrentBillIsInActiveWorkFlow((String[])billIdlist);
        try {
            iPlannedOrder.closed(PurUtil.converStringtoIObjectPK((String[])billIdlist));
            MsgBox.showInfo((String)this.getPlanOrderResource("MSG_PL_CloseSucess"));
            this.loadFields();
            this.refreshList();
        }
        catch (Throwable t) {
            this.handUIException(t);
        }
    }

    protected void checkClose() {
        int size = this.tblMain.getSelectManager().size();
        for (int j = 0; j < size; ++j) {
            KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get(j);
            if (selectBlock == null) continue;
            int num = selectBlock.getEndRow();
            for (int i = selectBlock.getTop(); i <= num && i >= 0; ++i) {
                IRow row = this.tblMain.getRow(i);
                String baseStatus = row.getCell("baseStatus").getValue().toString();
                if (baseStatus.trim().equalsIgnoreCase(BillBaseStatusEnum.AUDITED.toString())) continue;
                MsgBox.showError((String)this.getPlanOrderResource("Only_the_audit_PlannedOrder_can_closed"));
                SysUtil.abort();
            }
        }
    }

    protected void checkSubmit() {
        int size = this.tblMain.getSelectManager().size();
        for (int j = 0; j < size; ++j) {
            KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get(j);
            if (selectBlock == null) continue;
            int num = selectBlock.getEndRow();
            for (int i = selectBlock.getTop(); i <= num && i >= 0; ++i) {
                IRow row = this.tblMain.getRow(i);
                String baseStatus = row.getCell("baseStatus").getValue().toString();
                if (baseStatus.trim().equalsIgnoreCase(BillBaseStatusEnum.ADD.toString()) || baseStatus.trim().equalsIgnoreCase(BillBaseStatusEnum.TEMPORARILYSAVED.toString())) continue;
                MsgBox.showError((String)this.getPlanOrderResource("Only_the_addnew_PlannedOrder_can_submit"));
                SysUtil.abort();
            }
        }
    }

    @Override
    public void actionReleaseDirect_actionPerformed(ActionEvent e) {
        ArrayList idList = this.getSelectedIdValues();
        int idSize = idList.size();
        if (idSize == 0 || idSize < 0) {
            MsgBox.showInfo((String)this.getPlanOrderResource("YOU_SHOULD_SELEST_AT_LEAST_A_ROW"));
            return;
        }
        String sInterID = idList.get(0).toString();
        if ("".equalsIgnoreCase(sInterID)) {
            return;
        }
        StringBuffer errorDetail = new StringBuffer();
        try {
            Map map = PlannedOrderNewMappingFacadeFactory.getRemoteInstance().mapping(idList);
            if (map.size() != 0) {
                for (String key : map.keySet()) {
                    errorDetail.append(key).append("  ").append(map.get(key)).append("\n");
                }
            }
            if (map.size() > 0) {
                String failMsg = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.mm.planning.PlannedOrderResource.RELEASE_FAIL"), new Integer(idSize), new Integer(map.size()));
                MsgBox.showDetailAndOK((Component)((Object)this), (String)failMsg, (String)errorDetail.toString(), (int)0);
            } else {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.mm.planning.PlannedOrderResource.RELEASE_SUCCESS"));
            }
            this.refreshList();
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
    }

    @Override
    public void actionReleaseCollect_actionPerformed(ActionEvent e) throws Exception {
        int i;
        IUIWindow uiWindow = null;
        UIContext uiContext = new UIContext((Object)this);
        int winStyle = 95;
        HashSet idSet = new HashSet();
        HashSet baseStatusSet = new HashSet();
        ArrayList idList = this.getSelectedIdValues();
        ArrayList baseStatusList = this.getSelectedFieldValues("baseStatus");
        int size = idList.size();
        for (i = 0; i < size; ++i) {
            idSet.add(idList.get(i));
        }
        size = baseStatusList.size();
        for (i = 0; i < size; ++i) {
            baseStatusSet.add(baseStatusList.get(i));
        }
        int idSize = idList.size();
        if (idSize == 0 || idSize < 0) {
            MsgBox.showInfo((String)this.getPlanOrderResource("YOU_SHOULD_SELEST_AT_LEAST_A_ROW"));
            return;
        }
        uiContext.put((Object)"selectedId", idSet);
        uiContext.put((Object)"baseStatus", baseStatusSet);
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create("com.kingdee.eas.mm.planning.client.PlannedOrderReleaseUI", (Map)uiContext, null, OprtState.ADDNEW, winStyle);
        uiWindow.show();
    }

    protected ArrayList getImportParam() {
        String solutionName;
        DatataskParameter param = new DatataskParameter();
        param.solutionName = solutionName = "eas.mm.Planning.app.PlanOrderImpExp";
        param.alias = this.getPlanOrderResource("Import_PlanOrder");
        param.datataskMode = 0;
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    protected ArrayList getExportParam() {
        String solutionName;
        DatataskParameter param = new DatataskParameter();
        param.solutionName = solutionName = "eas.mm.Planning.app.PlanOrderImpExp";
        param.alias = this.getPlanOrderResource("Export_PlanOrder");
        param.datataskMode = 1;
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    public boolean isSupportedBatchActions() {
        return true;
    }

    public void initBatchActions() throws BOSException {
        this.actionManager.setClzIBizFactory(ActionLevelEnum.HEAD, PlannedOrderFactory.class);
        this.getTableSelectionHelper().setTableProperty((CoreBillListUI)this, this.mainQueryPK, this.tblMain, "id", null, "number", null, "storageOrgUnit.id");
        super.initBatchActions();
        ListSubmitActionProxy actionProxySubmit = new ListSubmitActionProxy((ItemAction)this.actionBatchSubmit, "submitRelations", ActionLevelEnum.HEAD, BatchActionEnum.SUBMIT);
        actionProxySubmit.setBillInfoClass(PlannedOrderInfo.class);
        this.actionManager.registerBatchAction((ActionProxy)actionProxySubmit, "actionBatchSubmit");
        actionProxySubmit.bindTo((AbstractButton)this.btnBatchSubmit);
        actionProxySubmit.bindTo((AbstractButton)this.menuItemBatchSubmit);
    }

    public boolean beforeAction(BatchActionEnum bizAction, BatchSelectionEntries selectionEntries, ActionEvent event) {
        if (bizAction.equals((Object)BatchActionEnum.DELETE) || bizAction.equals((Object)BatchActionEnum.AUDIT)) {
            String[] planScheme = SCMClientUtils.getSelectRowFieldValue((KDTable)this.tblMain, (String)"schemeid");
            ArrayList<String> lkList = new ArrayList<String>();
            if (planScheme != null) {
                int num1 = planScheme.length;
                for (int k = 0; k < num1; ++k) {
                    if (lkList.contains(planScheme[k])) continue;
                    lkList.add(planScheme[k]);
                }
                MutexServiceControlFactory.getRemoteInstance().batchRequestObjIDForUpdate(lkList);
            }
        }
        return true;
    }

    public void afterAction(BatchActionEnum bizAction, BatchSelectionEntries selectionEntries, int countSuccess) {
        super.afterAction(bizAction, selectionEntries, countSuccess);
        String[] idList1 = SCMClientUtils.getSelectRowFieldValue((KDTable)this.tblMain, (String)"id");
        ArrayList<String> idArrayList = new ArrayList<String>();
        if (idList1 != null) {
            int num1 = idList1.length;
            for (int k = 0; k < num1; ++k) {
                if (idArrayList.contains(idList1[k])) continue;
                idArrayList.add(idList1[k]);
            }
            MutexServiceControlFactory.getRemoteInstance().batchReleaseObjIDForUpdate(idArrayList);
        }
        if (bizAction.equals((Object)BatchActionEnum.DELETE) || bizAction.equals((Object)BatchActionEnum.AUDIT)) {
            String[] planScheme = SCMClientUtils.getSelectRowFieldValue((KDTable)this.tblMain, (String)"schemeid");
            ArrayList<String> lkList = new ArrayList<String>();
            if (planScheme != null) {
                int num1 = planScheme.length;
                for (int k = 0; k < num1; ++k) {
                    if (lkList.contains(planScheme[k])) continue;
                    lkList.add(planScheme[k]);
                }
                MutexServiceControlFactory.getRemoteInstance().batchReleaseObjIDForUpdate(lkList);
            }
        }
    }

    protected void logPrint() {
        PlannedOrderInfo plInfo = new PlannedOrderInfo();
        IObjectPK pk = LogUtil.beginLog(null, (String)"1", (BOSObjectType)plInfo.getBOSType(), null, (String)this.getPlanOrderResource("MSG_PLANORDER_PRINT"), (String)"mm_planorder_print");
        LogUtil.afterLog(null, (IObjectPK)pk);
    }

    protected String[] getQtyColumns() throws Exception {
        return new String[]{"qty", "scheduleqty", "totalReleaseQty", "finalProductsRate", "finalProdcutsQty"};
    }

    public boolean isPrepareActionTraceDown() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionChange_actionPerformed(ActionEvent e) throws Exception {
        boolean locked = false;
        if (KDTableUtil.getSelectedRows((KDTable)this.tblMain).length != 1) {
            MsgBox.showInfo((String)this.getPlanOrderResource("MSG_SELECT_ONE"));
            SysUtil.abort();
        } else {
            String[] idList = SCMClientUtils.getSelectRowFieldValue((KDTable)this.tblMain, (String)"id");
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("*"));
            selector.add(new SelectorItemInfo("trackNumber.number"));
            selector.add(new SelectorItemInfo("material.id"));
            selector.add(new SelectorItemInfo("material.name"));
            selector.add(new SelectorItemInfo("material.number"));
            selector.add(new SelectorItemInfo("storageOrgUnit.id"));
            selector.add(new SelectorItemInfo("storageOrgUnit.name"));
            selector.add(new SelectorItemInfo("storageOrgUnit.number"));
            PlannedOrderInfo info = PlannedOrderFactory.getRemoteInstance().getPlannedOrderInfo((IObjectPK)new ObjectUuidPK(idList[0]), selector);
            if (info.getBaseStatus() != BillBaseStatusEnum.AUDITED) {
                MsgBox.showInfo((String)this.getPlanOrderResource("MSG_NOT_PLANNEDORDERCHANGE_AUDITED"));
                SysUtil.abort();
            }
            if (info.getTotalReleaseQty().compareTo(SCMClientUtils.ZERO) <= 0 && info.getScheduleQty().compareTo(SCMClientUtils.ZERO) <= 0) {
                MsgBox.showInfo((String)this.getPlanOrderResource("MSG_NOT_PLANNEDORDERCHANGE_QTY"));
                SysUtil.abort();
            }
            try {
                if (MutexServiceControlFactory.getRemoteInstance().requestObjIDForUpdate(idList[0])) {
                    locked = true;
                    UIContext uiContext = new UIContext((Object)this);
                    uiContext.put((Object)"ID", null);
                    uiContext.put((Object)"PLANEDORDERINFO", (Object)info);
                    int winStyle = 16;
                    IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.mm.planning.client.PlanOrderChangeUI", (Map)uiContext, null, OprtState.ADDNEW, winStyle);
                    uiWindow.show();
                    this.refreshList();
                } else {
                    MsgBox.showError((String)this.getPlanOrderResource("MSG_LOCK"));
                }
            }
            catch (Throwable t) {
                this.handUIException(t);
            }
            finally {
                if (locked) {
                    MutexServiceControlFactory.getRemoteInstance().releaseObjIDForUpdate(idList[0]);
                }
            }
        }
    }

    @Override
    public void actionPlanOrderSplit_actionPerformed(ActionEvent e) throws Exception {
        ArrayList planOrderIdList = this.getSelectedIdValues();
        Map numberMap = this.getSelectedIdNumber();
        if (planOrderIdList.size() > 1) {
            MsgBox.showInfo((String)this.getPlanOrderResource("SUPPORT_SINGLE_ORDER_SPLIT"));
            SysUtil.abort();
        } else if (planOrderIdList.size() < 1) {
            MsgBox.showInfo((String)this.getPlanOrderResource("PLEASE_SELECT_BILL"));
            SysUtil.abort();
        } else {
            this.checkCurrentBillIsInActiveWorkFlow((String)planOrderIdList.get(0), (String)numberMap.get((String)planOrderIdList.get(0)));
            this.getUIContext().put("planOrderId", (String)planOrderIdList.get(0));
            PlanOrderSplitDialog dialog = new PlanOrderSplitDialog(this.getUIContext());
            if (dialog.show()) {
                PlannedOrderInfo planOrderInfo = dialog.getPlanOrderInfo();
                MsgBox.showInfo((String)MessageFormat.format(this.getPlanOrderResource("PLANORDER_SPLIT_SUCCESS"), planOrderInfo.getNumber()));
                this.setIsShowTextOnly(false);
                this.setMessageText(this.getPlanOrderResource("TOOLBAR_PLANORDER_SPLIT_SUCCESS"));
                this.setNextMessageText("");
                this.setShowMessagePolicy(0);
                this.showMessage();
                this.refreshList();
            }
        }
    }

    protected String[] getQueryShowField() {
        return new String[]{"number", "baseStatus", "orderType", "material.number", "material.name", "material.model", "materialAttribute", "startDate", "endDate", "avilableDate", "unit.name", "qty", "totalReleaseQty", "scheduleqty", "project.number", "trackNumber.number", "lot", "storageOrgUnit", "supplyStorageOrgUnit", "planner", "adminiOrgUnit.name", "planOrgUnit.name", "transactionType.name", "scheme", "calcID", "sourceType", "isSimulant", "isCannotRelease", "finalProductsRate", "finalProdcutsQty", "hierarchyCode", "BomNumber", "sourceType", "isStraightIssueMode", "isCannotRelease"};
    }

    protected String[] getQueryHideField() {
        return new String[]{"avilableDate", "endDate", "scheduleqty", "project.number", "trackNumber.number", "hierarchyCode", "lot", "storageOrgUnit", "supplyStorageOrgUnit", "planOrgUnit.name", "planner", "adminiOrgUnit.name", "scheme", "calcID", "BomNumber", "sourceType", "isStraightIssueMode", "isCannotRelease"};
    }

    public void onShow() throws Exception {
        super.onShow();
        KDTableUtils.setDefaultFreezeCol((KDTable)this.tblMain, (int)5);
    }

    protected boolean isLazyMode() {
        return true;
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    public void checkCurrentBillIsInActiveWorkFlow(String keyID, String number) throws BOSException {
        IEnactmentService service = EnactmentServiceFactory.createRemoteEnactService();
        ProcessInstInfo instInfo = null;
        ProcessInstInfo[] procInsts = service.getProcessInstanceByHoldedObjectId(keyID);
        int n = procInsts.length;
        for (int j = 0; j < n; ++j) {
            if (!"open.running".equals(procInsts[j].getState())) continue;
            instInfo = procInsts[j];
        }
        if (instInfo != null) {
            MsgBox.showInfo((String)this.getPlanOrderResource("HAVE_BEEN_IN_WORKFLOW", new String[]{number}));
            SysUtil.abort();
        }
    }

    private String getPlanOrderResource(String sKey, String[] params) {
        return ResourceUtils.getMessageForClient((String)"com.kingdee.eas.mm.planning.client.PlanningResource", (String)sKey, (String[])params);
    }

    protected QuickFilteringSupportItems getQuickFilteringSupport() {
        return this.qfsi;
    }

    public void actionTraceDown_actionPerformed(ActionEvent e) throws Exception {
        BTPBillListImpl billList = new BTPBillListImpl((CoreBillListUI)this);
        billList.init();
        CoreBillBaseCollection bills = this.getNewBillList();
        billList.traceDown(bills, "", this.getUIContext());
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        super.prepareUIContext(uiContext, e);
        uiContext.put((Object)"UIClassParam", this.getUIContext().get("UIClassParam"));
    }
}

