/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.mm.basedata.PlanVersionSetFactory;
import com.kingdee.eas.mm.basedata.PlanVersionSetInfo;
import com.kingdee.eas.mm.common.util.EditTableUtil;
import com.kingdee.eas.mm.planning.ProductLineSupplyMaterialPlanFactory;
import com.kingdee.eas.mm.planning.SupplyMaterialCalculateScaleEnum;
import com.kingdee.eas.mm.planning.SupplyMaterialShowTypeEnum;
import com.kingdee.eas.mm.planning.client.AbstractProductLineSupplyMaterialPlanListUI;
import com.kingdee.eas.mm.planning.client.ProductLineSupplyMaterialPlanFilterUI;
import com.kingdee.eas.mm.planning.client.SupplyMaterialCalculateUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.ResultSetMetaData;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class ProductLineSupplyMaterialPlanListUI
extends AbstractProductLineSupplyMaterialPlanListUI {
    private static final Logger logger = CoreUIObject.getLogger(ProductLineSupplyMaterialPlanListUI.class);
    private static final String[] KDT_DATETIMES = new String[]{"requireDate"};
    private CommonQueryDialog dialog;
    private ProductLineSupplyMaterialPlanFilterUI productLineSupplyMaterialPlanFilterUI;
    private FilterInfo filterInfo;
    private Map history = new HashMap();

    public ProductLineSupplyMaterialPlanListUI() throws Exception {
        this.setButtonDefaultStyl(this.btnQuery);
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    public KDTable getTableForCommon() {
        return this.kdtSupplyMaterial;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        Boolean isFilter = (Boolean)this.getUIContext().get("isFilter");
        if (isFilter != null && !isFilter.booleanValue()) {
            this.calculateResultList(this.getUIContext());
            return;
        }
        if (this.dialog == null) {
            this.initCommonQueryDialog();
            this.dialog.init();
            QuerySolutionInfo currSolution = this.dialog.getCurrentSolutionInfo();
            if (currSolution.isIsUserDefaultSolu() && currSolution.getEntityViewInfo() != null) {
                PlanVersionSetInfo planVersionSetInfo = null;
                StorageOrgUnitInfo storageOrgUnitInfo = null;
                EntityViewInfo entityViewInfo = new EntityViewInfo(currSolution.getEntityViewInfo());
                this.filterInfo = entityViewInfo.getFilter();
                for (FilterItemInfo filterItem : this.filterInfo.getFilterItems()) {
                    if ("planVersionId".equals(filterItem.getPropertyName())) {
                        planVersionSetInfo = PlanVersionSetFactory.getRemoteInstance().getPlanVersionSetInfo((IObjectPK)new ObjectUuidPK(filterItem.getCompareValue().toString()));
                    }
                    if (!"storageOrgUnitId".equals(filterItem.getPropertyName())) continue;
                    storageOrgUnitInfo = StorageOrgUnitFactory.getRemoteInstance().getStorageOrgUnitInfo((IObjectPK)new ObjectUuidPK(filterItem.getCompareValue().toString()));
                }
                this.gatherSupplyMaterialPlan(this.filterInfo, planVersionSetInfo, storageOrgUnitInfo);
            } else if (this.dialog.show()) {
                PlanVersionSetInfo planVersionSetInfo = null;
                StorageOrgUnitInfo storageOrgUnitInfo = null;
                ProductLineSupplyMaterialPlanFilterUI productLineSupplyMaterialPlanFilterUI = (ProductLineSupplyMaterialPlanFilterUI)this.dialog.getUserPanel(0);
                this.filterInfo = productLineSupplyMaterialPlanFilterUI.getFilterInfo();
                for (FilterItemInfo filterItem : this.filterInfo.getFilterItems()) {
                    if ("planVersionId".equals(filterItem.getPropertyName())) {
                        planVersionSetInfo = PlanVersionSetFactory.getRemoteInstance().getPlanVersionSetInfo((IObjectPK)new ObjectUuidPK(filterItem.getCompareValue().toString()));
                        this.history.put("VERSION", planVersionSetInfo);
                    }
                    if (!"storageOrgUnitId".equals(filterItem.getPropertyName())) continue;
                    storageOrgUnitInfo = StorageOrgUnitFactory.getRemoteInstance().getStorageOrgUnitInfo((IObjectPK)new ObjectUuidPK(filterItem.getCompareValue().toString()));
                    this.history.put("STORAGE", storageOrgUnitInfo);
                }
                this.gatherSupplyMaterialPlan(this.filterInfo, planVersionSetInfo, storageOrgUnitInfo);
            } else {
                this.tHelper.setDialog(this.dialog);
                SysUtil.abort();
            }
        }
        EditTableUtil.formatColDateTime((KDTable)this.kdtSupplyMaterial, (String[])KDT_DATETIMES);
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        this.dialog = new CommonQueryDialog();
        if (this.getUIWindow() == null) {
            this.dialog.setOwner((Component)this.getUIContext().get("OwnerWindow"));
        } else {
            this.dialog.setOwner((Component)((Object)this));
        }
        this.dialog.setUiObject((IUIObject)this);
        this.dialog.setParentUIClassName(((Object)((Object)this)).getClass().getName());
        this.dialog.setQueryObjectPK(this.getQueryPK());
        MessageFormat format = BOSLocaleUtil.getMessageFormat((String)"{0}-{1}");
        String title = format.format(new Object[]{this.getUITitle(), EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Query_Filter")});
        this.dialog.setTitle(title);
        try {
            this.productLineSupplyMaterialPlanFilterUI = new ProductLineSupplyMaterialPlanFilterUI();
            this.productLineSupplyMaterialPlanFilterUI.onLoad();
            this.dialog.setShowFilter(false);
            this.dialog.setShowSorter(false);
            this.dialog.setHeight(435);
            this.dialog.setWidth(580);
            this.dialog.addUserPanel((KDPanel)this.productLineSupplyMaterialPlanFilterUI);
        }
        catch (Exception e) {
            this.handUIException(e);
            SysUtil.abort();
        }
        return this.dialog;
    }

    private void gatherSupplyMaterialPlan(FilterInfo filterInfo, PlanVersionSetInfo planVersionSetInfo, StorageOrgUnitInfo storageOrgUnitInfo) throws BOSException {
        try {
            this.prmptPlanVersion.setValue((Object)planVersionSetInfo);
            this.prmptStorageOrgUnit.setValue((Object)storageOrgUnitInfo);
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            this.kdBeginDate.setValue(null);
            this.kdEndDate.setValue(null);
            for (FilterItemInfo filterItem : filterInfo.getFilterItems()) {
                if ("beginDate".equals(filterItem.getPropertyName())) {
                    this.kdBeginDate.setValue((Object)format.parse((String)filterItem.getCompareValue()));
                }
                if ("endDate".equals(filterItem.getPropertyName())) {
                    this.kdEndDate.setValue((Object)format.parse((String)filterItem.getCompareValue()));
                }
                if (!"showType".equals(filterItem.getPropertyName())) continue;
                this.cmbShowType.setSelectedItem((Object)SupplyMaterialShowTypeEnum.getEnum((Integer)filterItem.getCompareValue()));
            }
            IRowSet rows = ProductLineSupplyMaterialPlanFactory.getRemoteInstance().gatherSupplyMaterialPlan(filterInfo);
            if (rows != null) {
                this.fillKdtSupplyMaterial(this.getTableForCommon(), rows);
            }
            this.getTableForCommon().getStyleAttributes().setLocked(true);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    private void fillKdtSupplyMaterial(KDTable kdTable, IRowSet rowSet) throws BOSException {
        try {
            HashMap<String, String> columnNameMap = new HashMap<String, String>();
            ResultSetMetaData resultSetMetaData = rowSet.getMetaData();
            int dbColumnCount = resultSetMetaData.getColumnCount();
            for (int i = 1; i <= dbColumnCount; ++i) {
                String columnName = resultSetMetaData.getColumnName(i);
                columnNameMap.put(columnName, columnName);
            }
            kdTable.checkParsed();
            kdTable.removeRows();
            int tableColumnCount = kdTable.getColumnCount();
            IRow row = null;
            while (rowSet.next()) {
                row = kdTable.addRow();
                for (int i = 0; i < tableColumnCount; ++i) {
                    String columnKey = kdTable.getColumn(i).getKey();
                    if (columnNameMap.containsKey(columnKey.toUpperCase())) {
                        row.getCell(i).setValue((Object)rowSet.getString(columnKey));
                        kdTable.getColumn(i).getStyleAttributes().setHided(false);
                        continue;
                    }
                    kdTable.getColumn(i).getStyleAttributes().setHided(true);
                }
            }
            this.repaint();
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    public void actionPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionPreview_actionPerformed(e);
        this.preparePrintPage(this.getTableForCommon());
        this.getTableForCommon().getPrintManager().printPreview();
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
        this.preparePrintPage(this.getTableForCommon());
        this.getTableForCommon().getPrintManager().print();
    }

    @Override
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
        this.initCommonQueryDialog();
        this.productLineSupplyMaterialPlanFilterUI.getUIContext().clear();
        this.productLineSupplyMaterialPlanFilterUI.getUIContext().putAll(this.getUIContext());
        this.productLineSupplyMaterialPlanFilterUI.getUIContext().put("HISTORY", this.history);
        if (this.dialog.show()) {
            PlanVersionSetInfo planVersionSetInfo = null;
            StorageOrgUnitInfo storageOrgUnitInfo = null;
            ProductLineSupplyMaterialPlanFilterUI productLineSupplyMaterialPlanFilterUI = (ProductLineSupplyMaterialPlanFilterUI)this.dialog.getUserPanel(0);
            this.filterInfo = productLineSupplyMaterialPlanFilterUI.getFilterInfo();
            for (FilterItemInfo filterItem : this.filterInfo.getFilterItems()) {
                if ("planVersionId".equals(filterItem.getPropertyName())) {
                    planVersionSetInfo = PlanVersionSetFactory.getRemoteInstance().getPlanVersionSetInfo((IObjectPK)new ObjectUuidPK(filterItem.getCompareValue().toString()));
                }
                if (!"storageOrgUnitId".equals(filterItem.getPropertyName())) continue;
                storageOrgUnitInfo = StorageOrgUnitFactory.getRemoteInstance().getStorageOrgUnitInfo((IObjectPK)new ObjectUuidPK(filterItem.getCompareValue().toString()));
            }
            this.gatherSupplyMaterialPlan(this.filterInfo, planVersionSetInfo, storageOrgUnitInfo);
        } else {
            this.tHelper.setDialog(this.dialog);
            SysUtil.abort();
        }
    }

    public IMetaDataPK getQueryPK() {
        return new MetaDataPK("com.kingdee.eas.base.message", "MsgQuery");
    }

    @Override
    public void actionSupplyMaterialCal_actionPerformed(ActionEvent e) throws Exception {
        try {
            PlanVersionSetInfo planVersionSetInfo = (PlanVersionSetInfo)this.prmptPlanVersion.getValue();
            StorageOrgUnitInfo storageOrgUnitInfo = (StorageOrgUnitInfo)this.prmptStorageOrgUnit.getValue();
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"openModel", (Object)"frame");
            uiContext.put((Object)"from", (Object)new Boolean(true));
            uiContext.put((Object)"planVersion", (Object)planVersionSetInfo);
            uiContext.put((Object)"storageOrgUnit", (Object)storageOrgUnitInfo);
            uiContext.put((Object)"calculateScale", (Object)SupplyMaterialCalculateScaleEnum.productLineSupplyMaterial);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(SupplyMaterialCalculateUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
            uiWindow.show();
            if (uiWindow.getUIObject().getUIContext().get("ok") != null) {
                this.gatherSupplyMaterialPlan(this.filterInfo, planVersionSetInfo, storageOrgUnitInfo);
            }
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    private void calculateResultList(Map uiContext) throws Exception {
        try {
            PlanVersionSetInfo planVersionSetInfo = (PlanVersionSetInfo)uiContext.get("planVersion");
            StorageOrgUnitInfo storageOrgUnitInfo = (StorageOrgUnitInfo)uiContext.get("storageOrgUnit");
            this.filterInfo = new FilterInfo();
            FilterItemCollection items = this.filterInfo.getFilterItems();
            items.add(new FilterItemInfo("planVersionId", (Object)planVersionSetInfo.getId().toString(), CompareType.EQUALS));
            items.add(new FilterItemInfo("storageOrgUnitId", (Object)storageOrgUnitInfo.getId().toString(), CompareType.EQUALS));
            items.add(new FilterItemInfo("showType", (Object)new Integer(10), CompareType.EQUALS));
            this.gatherSupplyMaterialPlan(this.filterInfo, planVersionSetInfo, storageOrgUnitInfo);
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    protected String getOnloadPermItemName() {
        return "mm_SupplyMaterialPlan_view";
    }
}

