/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.extendcontrols.ext.CommonF7KDTableListener;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.mm.common.MMSingleFilterElement;
import com.kingdee.eas.mm.common.client.MMRangeFilterElement;
import com.kingdee.eas.mm.common.client.UIHelper;
import com.kingdee.eas.mm.common.util.ResourceUtils;
import com.kingdee.eas.mm.planning.client.AbstractProductionLineSchedulingFilterUI;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.client.SCMCommonF7KDTableListener;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.scm.common.verify.VerifyItem;
import com.kingdee.eas.scm.common.verify.VerifyType;
import com.kingdee.eas.scm.im.inv.client.InvClientUtils;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.util.Date;
import org.apache.log4j.Logger;

public class ProductionLineSchedulingFilterUI
extends AbstractProductionLineSchedulingFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(ProductionLineSchedulingFilterUI.class);
    private static final String RES_SCHEDULING = "com.kingdee.eas.mm.planning.ProductionLineSchedulingResource";
    private DataChangeListener departmentDataChanged = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.setF7Filter();
        if (this.getMainBizOrgF7().getText() != null) {
            this.mainOrgChanged();
        }
        this.cmbbaseStatus.removeAllItems();
        this.cmbbaseStatus.addItem((Object)BillBaseStatusEnum.NULL);
        this.cmbbaseStatus.addItem((Object)BillBaseStatusEnum.SUBMITED);
        this.cmbbaseStatus.addItem((Object)BillBaseStatusEnum.CLOSED);
        this.getElementsInfo();
    }

    private void setF7Filter() throws Exception {
        this.f7Manager.registerContextChangeF7(this.prmtNumberFrom, this.getPropertyOfMainBizOrg());
        this.f7Manager.registerContextChangeF7(this.prmtNumberTo, this.getPropertyOfMainBizOrg());
        this.prmtNumberFrom.addCommonF7KDTableListener((CommonF7KDTableListener)new SCMCommonF7KDTableListener("baseStatus"));
        this.prmtNumberTo.addCommonF7KDTableListener((CommonF7KDTableListener)new SCMCommonF7KDTableListener("baseStatus"));
        this.setBillNumberF7s(new KDBizPromptBox[]{this.prmtbizDepartment, this.prmtNumberFrom, this.prmtNumberTo});
    }

    private void getElementsInfo() {
        CompositeFilterElement elements = new CompositeFilterElement(0);
        elements.add((FilterElement)new MMRangeFilterElement("number", (Component)this.prmtNumberFrom, (Component)this.prmtNumberTo));
        elements.add((FilterElement)new MMRangeFilterElement("beginDate", (Component)this.kdBeginDateFrom, (Component)this.kdBeginDateTo));
        elements.add((FilterElement)new MMRangeFilterElement("endDate", (Component)this.kdEndDateFrom, (Component)this.kdEndDateTo));
        UIHelper.registerBizOrgF7((KDBizPromptBox)this.prmtbizDepartment, null, null, (OrgType)this.getMainBizOrgType(), (OrgType)OrgType.Admin, (boolean)false);
        this.setNeedMainOrgF7s(new KDBizPromptBox[]{this.prmtbizDepartment});
        elements.add((FilterElement)new MMSingleFilterElement("bizDepartment.number", (Component)this.prmtbizDepartment));
        elements.add((FilterElement)new MMSingleFilterElement("creator.number", (Component)this.prmtBizCreator));
        SingleFilterElement statusElement = new SingleFilterElement("baseStatus", (Component)this.cmbbaseStatus, (Object)BillBaseStatusEnum.NULL);
        statusElement.setDefaultValue((Object)BillBaseStatusEnum.SUBMITED);
        elements.add((FilterElement)statusElement);
        SingleFilterElement mainOrgElement = new SingleFilterElement("storageOrgUnit.number", (Component)this.prmtStorageOrgUnit);
        mainOrgElement.addVerifyItem(new VerifyItem(VerifyType.REQUIRED_TYPE, InvClientUtils.getResource((String)"StorageOrgUnitNotNull")));
        elements.add((FilterElement)mainOrgElement);
        this.getFilterManager().setElement((FilterElement)elements);
        this.getFilterManager().setMainOrgElement((FilterElement)mainOrgElement, "storageOrgUnit.id");
    }

    private void initBizCreatorF7(AdminOrgUnitInfo adminOrgUnitInfo) throws Exception {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("AdminOrgUnit.id", (Object)adminOrgUnitInfo.getId().toString(), CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        this.prmtBizCreator.setEntityViewInfo(viewInfo);
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmtStorageOrgUnit;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    protected String getViewPermission() {
        return "mm_ProductionLineScheduling_view";
    }

    protected String getPropertyOfMainBizOrg() {
        return "storageOrgUnit.id";
    }

    protected void prmtbizDepartment_dataChanged(DataChangeEvent e) throws Exception {
        if (SCMGroupClientUtils.isDiffrent((Object)e.getOldValue(), (Object)e.getNewValue())) {
            if (this.prmtbizDepartment.getData() != null) {
                this.prmtBizCreator.setValue(null);
                this.prmtBizCreator.setEnabled(true);
                AdminOrgUnitInfo adminOrgUnitInfo = (AdminOrgUnitInfo)this.prmtbizDepartment.getData();
                this.initBizCreatorF7(adminOrgUnitInfo);
            } else {
                this.prmtBizCreator.setValue(null);
                this.prmtBizCreator.setEnabled(false);
            }
        }
    }

    public boolean verify() {
        boolean bRet = super.verify();
        if (bRet) {
            StringBuffer showInfo = new StringBuffer();
            Date beginDateFrom = (Date)this.kdBeginDateFrom.getValue();
            Date beginDateTo = (Date)this.kdBeginDateTo.getValue();
            Date endDateFrom = (Date)this.kdEndDateFrom.getValue();
            Date endDateTo = (Date)this.kdEndDateTo.getValue();
            if (beginDateFrom != null && beginDateTo != null && beginDateFrom.after(beginDateTo)) {
                showInfo.append(ResourceUtils.getMessageForClient((String)RES_SCHEDULING, (String)"Msg_BeginDate_Check") + "\n");
                bRet = false;
            }
            if (endDateFrom != null && endDateTo != null && endDateFrom.after(endDateTo)) {
                showInfo.append(ResourceUtils.getMessageForClient((String)RES_SCHEDULING, (String)"Msg_EndDate_Check") + "\n");
                bRet = false;
            }
            if (!bRet) {
                MsgBox.showInfo((Component)((Object)this), (String)showInfo.toString());
            }
        }
        return bRet;
    }

    public void afterMainOrgChanged(String ids) {
        if (ids != null) {
            if (ids.indexOf(",") > -1) {
                this.prmtbizDepartment.setValue(null);
                this.prmtBizCreator.setValue(null);
                this.prmtBizCreator.setEnabled(false);
            } else {
                this.prmtbizDepartment.setValue(null);
                this.prmtBizCreator.setValue(null);
                this.prmtbizDepartment.setEnabled(true);
                this.prmtBizCreator.setEnabled(false);
            }
        }
    }

    protected void initListener() {
        super.initListener();
        if (this.departmentDataChanged == null) {
            this.departmentDataChanged = new DataChangeListener(){

                public void dataChanged(DataChangeEvent e) {
                    try {
                        ProductionLineSchedulingFilterUI.this.prmtbizDepartment_dataChanged(e);
                    }
                    catch (Exception exc) {
                        ProductionLineSchedulingFilterUI.this.handUIException(exc);
                    }
                }
            };
        }
        this.prmtbizDepartment.addDataChangeListener(this.departmentDataChanged);
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        int i;
        this.prmtbizDepartment.removeDataChangeListener(this.departmentDataChanged);
        DataChangeListener[] dc = null;
        if (this.prmtStorageOrgUnit.getListeners(DataChangeListener.class) != null) {
            dc = (DataChangeListener[])this.prmtStorageOrgUnit.getListeners(DataChangeListener.class);
            for (i = 0; i < dc.length; ++i) {
                this.prmtStorageOrgUnit.removeDataChangeListener(dc[i]);
            }
        }
        super.loadData(entityViewInfo);
        this.prmtbizDepartment.addDataChangeListener(this.departmentDataChanged);
        if (dc != null && dc.length > 0) {
            for (i = 0; i < dc.length; ++i) {
                this.prmtStorageOrgUnit.addDataChangeListener(dc[i]);
            }
        }
        if (this.prmtbizDepartment.getValue() != null) {
            this.prmtBizCreator.setEnabled(true);
        } else {
            this.prmtBizCreator.setEnabled(false);
        }
    }
}

