/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.client;

import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.mm.common.util.EditTableUtil;
import com.kingdee.eas.mm.common.util.ResourceUtils;
import com.kingdee.eas.mm.planning.PLSEntryCollection;
import com.kingdee.eas.mm.planning.PLSEntryInfo;
import com.kingdee.eas.mm.planning.ProductionLineSchedulingFactory;
import com.kingdee.eas.mm.planning.ProductionLineSchedulingInfo;
import com.kingdee.eas.mm.planning.client.AbstractProductionLineSchedulingListUI;
import com.kingdee.eas.mm.planning.client.ProductionLineSchedulingFilterUI;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.JMenuItem;
import org.apache.log4j.Logger;

public class ProductionLineSchedulingListUI
extends AbstractProductionLineSchedulingListUI {
    private static final Logger logger = CoreUIObject.getLogger(ProductionLineSchedulingListUI.class);
    private ProductionLineSchedulingFilterUI conditionPanel = null;
    public static final String RES_SCHEDULING = "com.kingdee.eas.mm.planning.ProductionLineSchedulingResource";
    private static String[] NUMBERTAB = new String[]{"pLSEntry.qty", "pLSEntry.delayTime"};
    private static final String[] KDT_DATES = new String[]{"beginDate", "endDate", "bizDate", "lastUpdateTime", "auditTime", "releaseTime"};
    private static final String[] KDT_DATETIMES = new String[]{"pLSEntry.beginDate", "pLSEntry.endDate", "pLSEntry.outputDate"};

    @Override
    public void initUIMenuBarLayout() {
        super.initUIMenuBarLayout();
        this.menuBar.remove((Component)this.menuWorkFlow);
        this.menuBar.remove((Component)this.menuBiz);
        this.menuEdit.remove((JMenuItem)this.menuItemCreateTo);
        this.menuFile.remove((JMenuItem)this.MenuItemAttachment);
    }

    protected String[] getQtyColumns() throws Exception {
        return NUMBERTAB;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return ProductionLineSchedulingFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    protected String getKeyFieldName() {
        return "id";
    }

    @Override
    protected IObjectValue createNewData() {
        ProductionLineSchedulingInfo objectValue = new ProductionLineSchedulingInfo();
        return objectValue;
    }

    @Override
    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    protected String getPropertyOfBizOrg(OrgType orgType) {
        if (orgType.equals((Object)OrgType.Storage)) {
            return "storageOrgUnit.id";
        }
        return null;
    }

    protected CustomerQueryPanel getFilterUI() throws Exception {
        if (this.conditionPanel == null) {
            this.conditionPanel = new ProductionLineSchedulingFilterUI();
        }
        return this.conditionPanel;
    }

    protected boolean initDefaultFilter() {
        return true;
    }

    public String getEntriesName() {
        return "pLSEntry";
    }

    protected void initWorkButton() {
        super.initWorkButton();
    }

    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        ArrayList idList = this.getSelectedIdValues();
        if (idList == null || idList.size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
            return;
        }
        for (int i = 0; i < idList.size(); ++i) {
            String pkId = idList.get(i).toString();
            ObjectUuidPK pk = new ObjectUuidPK(pkId);
            ProductionLineSchedulingInfo schedulingInfo = (ProductionLineSchedulingInfo)this.getBizInterface().getValue((IObjectPK)pk);
            PLSEntryCollection pLSEntryCollection = schedulingInfo.getPLSEntry();
            if (schedulingInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.SUBMITED)) {
                for (int index = 0; index < pLSEntryCollection.size(); ++index) {
                    PLSEntryInfo pLSEntryInfo = pLSEntryCollection.get(index);
                    int intStatus = pLSEntryInfo.getBaseStatus().getValue();
                    if (intStatus == 2) continue;
                    MsgBox.showInfo((Component)((Object)this), (String)ResourceUtils.getMessageForClient((String)RES_SCHEDULING, (String)"Msg_Edit_LineIsNotSubmit"));
                    return;
                }
                continue;
            }
            MsgBox.showInfo((Component)((Object)this), (String)ResourceUtils.getMessageForClient((String)RES_SCHEDULING, (String)"Msg_Edit_IsClosed"));
            return;
        }
        super.actionRemove_actionPerformed(e);
    }

    @Override
    public void initUIToolBarLayout() {
        super.initUIToolBarLayout();
        this.toolBar.remove((Component)this.btnAttachment);
        this.toolBar.remove((Component)this.btnAudit);
        this.toolBar.remove((Component)this.btnUnAudit);
        this.toolBar.remove((Component)this.btnSubmit);
        this.toolBar.remove((Component)this.btnAuditResult);
        this.toolBar.remove((Component)this.btnWorkFlowG);
        this.toolBar.remove((Component)this.btnCreateTo);
        this.toolBar.remove((Component)this.btnVoucher);
        this.toolBar.remove((Component)this.btnDelVoucher);
    }

    public void onLoad() throws Exception {
        this.setCanCopyPaste(false);
        super.onLoad();
        EditTableUtil.formatColDate((KDTable)this.tblMain, (String[])KDT_DATES);
        EditTableUtil.formatColDateTime((KDTable)this.tblMain, (String[])KDT_DATETIMES);
        super.setReservationVisible(false);
    }
}

