/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSortManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTPropertyChangeEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTPropertyChangeListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDContainer;
import com.kingdee.bos.ctrl.swing.event.CommitEvent;
import com.kingdee.bos.ctrl.swing.event.CommitListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.material.IMaterialPlan;
import com.kingdee.eas.basedata.master.material.MaterialPlanCollection;
import com.kingdee.eas.basedata.master.material.MaterialPlanFactory;
import com.kingdee.eas.basedata.master.material.MaterialPlanInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.mm.basedata.ITrackNumber;
import com.kingdee.eas.mm.basedata.TrackNumberFactory;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.common.util.EditTableUtil;
import com.kingdee.eas.mm.planning.IReqSubConsumeRecord;
import com.kingdee.eas.mm.planning.ReqPlanStatusEnum;
import com.kingdee.eas.mm.planning.ReqSubConsumeRecordDEntryInfo;
import com.kingdee.eas.mm.planning.ReqSubConsumeRecordEntryInfo;
import com.kingdee.eas.mm.planning.ReqSubConsumeRecordFactory;
import com.kingdee.eas.mm.planning.ReqSubConsumeRecordInfo;
import com.kingdee.eas.mm.planning.RequirementPlanInfo;
import com.kingdee.eas.mm.planning.SubConsumeEnum;
import com.kingdee.eas.mm.planning.client.AbstractReqSubConsumeRecordEditUI;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.util.ResourceUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.enums.EnumUtils;
import java.awt.event.ActionEvent;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class ReqSubConsumeRecordEditUI
extends AbstractReqSubConsumeRecordEditUI {
    private static final Logger logger = CoreUIObject.getLogger(ReqSubConsumeRecordEditUI.class);
    private static final String TB_CURCONSUMEQTY = "curConsumeQty";
    private static final String TB_REQQTY = "reqQty";
    private static final String TB_CONSUMEDQTY = "cntactTotalQty";
    private static final String[] KDT_DATES = new String[]{"reqDate"};
    private KDTPropertyChangeListener curConsumeQtyChangeListener;
    private KDTSelectListener selectListener;
    private boolean isLoading = false;
    private boolean isModified = false;
    private StorageOrgUnitInfo storageOrgUnitInfo = null;
    private boolean Req_Writeoff_Control = false;
    private String defaultTrackNumber = null;
    final KDBizPromptBox prmtReqPlanF7 = new KDBizPromptBox();
    private int focusIdx_kdtentry = 0;
    private KDTEditListener kDTEditListener = null;
    private int preIdx_kdtentry = 0;

    public boolean isModified() {
        return this.isModified;
    }

    public ReqSubConsumeRecordEditUI() throws Exception {
        this.ftxtReqQty.setHorizontalAlignment(4);
        this.kdtEntrys.checkParsed();
        this.kDTable1.checkParsed();
    }

    @Override
    public void loadFields() {
        this.isLoading = true;
        super.loadFields();
        this.isLoading = false;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("reqPlan.id"));
        sic.add(new SelectorItemInfo("entrys.dentrys.consumedQty"));
        sic.add(new SelectorItemInfo("entrys.dentrys.baseConsumedQty"));
        sic.add(new SelectorItemInfo("entrys.dentrys.reqPlan.baseCntactTotalQty"));
        sic.add(new SelectorItemInfo("entrys.dentrys.reqPlan.notCntactQty"));
        sic.add(new SelectorItemInfo("entrys.dentrys.reqPlan.baseNotCntactQty"));
        sic.add(new SelectorItemInfo("entrys.dentrys.reqPlan.unit"));
        sic.add(new SelectorItemInfo("entrys.dentrys.reqPlan.baseUnit"));
        sic.add(new SelectorItemInfo("entrys.unit.qtyPrecision"));
        sic.add(new SelectorItemInfo("entrys.dentrys.unit.qtyPrecision"));
        return sic;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        Map uiContext = this.getUIContext();
        this.txtDocNum.setText((String)uiContext.get("Number"));
        this.txtItemCode.setText((String)uiContext.get("material"));
        this.txtItemName.setText((String)uiContext.get("materialName"));
        this.txtModel.setText((String)uiContext.get("model"));
        TrackNumberInfo trackNumInfo = (TrackNumberInfo)uiContext.get("trackNumCol");
        if (trackNumInfo != null) {
            this.txtTraceNum.setText(trackNumInfo.getNumber());
        }
        this.dpReqDate.setValue(uiContext.get("requireDate"));
        this.txtUnit.setText((String)uiContext.get("unit"));
        this.ftxtReqQty.setText(uiContext.get("qty").toString());
        ReqPlanStatusEnum status = (ReqPlanStatusEnum)((Object)uiContext.get("status"));
        this.cmbStatus.setSelectedItem((Object)status.getValue());
        CustomerInfo customerInfo = (CustomerInfo)uiContext.get("customer");
        if (customerInfo != null) {
            this.txtCustomer.setText(customerInfo.getName());
        }
        SubConsumeEnum subConsumeStatus = (SubConsumeEnum)((Object)uiContext.get("subConsumeStatus"));
        this.cmbSubConsume.setSelectedItem((Object)subConsumeStatus);
        if (ReqPlanStatusEnum.CLOSED.equals((Object)status)) {
            this.btnRefreshConsume.setEnabled(false);
            this.btnUndoConsume.setEnabled(false);
            this.btnMySave.setEnabled(false);
            this.setOprtState(OprtState.VIEW);
            this.kDTable1.setEditable(false);
        }
        this.kdtEntrys.getSelectManager().setSelectMode(2);
        KDTSortManager sortManager = new KDTSortManager(this.kdtEntrys);
        sortManager.setSortAuto(true);
        for (int i = 0; i < this.kdtEntrys.getColumnCount(); ++i) {
            this.kdtEntrys.getColumn(i).setSortable(true);
        }
        this.kDTable1.getSelectManager().setSelectMode(2);
        KDTSortManager dsortManager = new KDTSortManager(this.kDTable1);
        dsortManager.setSortAuto(true);
        for (int i = 0; i < this.kDTable1.getColumnCount(); ++i) {
            this.kDTable1.getColumn(i).setSortable(true);
        }
        if (this.selectListener == null) {
            Object[] listeners = this.kdtEntrys.getListenerList().getListenerList();
            ArrayList<KDTSelectListener> oldListeners = new ArrayList<KDTSelectListener>();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != KDTSelectListener.class) continue;
                KDTSelectListener curListener = (KDTSelectListener)listeners[i + 1];
                this.kdtEntrys.removeKDTSelectListener(curListener);
                oldListeners.add(curListener);
            }
            this.selectListener = new KDTSelectListener(){

                public void tableSelectChanged(KDTSelectEvent event) {
                    if (event.getSelectBlock() == null) {
                        return;
                    }
                    ReqSubConsumeRecordEditUI.this.preIdx_kdtentry = event.getSelectBlock().getBeginRow();
                    ReqSubConsumeRecordEditUI.this.resetDEntryPrecision();
                }
            };
            this.kdtEntrys.addKDTSelectListener(this.selectListener);
            for (int idx = 0; idx < oldListeners.size(); ++idx) {
                this.kdtEntrys.addKDTSelectListener((KDTSelectListener)oldListeners.get(idx));
            }
        }
        if (this.curConsumeQtyChangeListener == null) {
            this.curConsumeQtyChangeListener = new KDTPropertyChangeListener(){

                public void propertyChange(KDTPropertyChangeEvent e) {
                    ReqSubConsumeRecordEditUI.this.curConsumeQty_propertyChange(e);
                }
            };
            this.kDTable1.addKDTPropertyChangeListener(this.curConsumeQtyChangeListener);
        }
        this.storageOrgUnitInfo = (StorageOrgUnitInfo)uiContext.get("storageOrgUnit");
        this.defaultTrackNumber = this.getDefaultTrackNumber();
        String param = ParamManager.getParamValue(null, (IObjectPK)new ObjectUuidPK(this.storageOrgUnitInfo.getId()), (String)"Req_Writeoff_Control");
        this.Req_Writeoff_Control = Boolean.valueOf(param);
        this.initReqPlanF7();
        this.onReqPlanF7Changed();
        this.onReqPlanF7FocusIn();
        String reqPlanId = uiContext.get("id").toString();
        IReqSubConsumeRecord service = ReqSubConsumeRecordFactory.getRemoteInstance();
        try {
            ReqSubConsumeRecordInfo rcdInfo = service.getReqSubConsumeRecordInfo("where reqPlan='" + reqPlanId + "'");
            if (rcdInfo != null) {
                this.loadData((IObjectPK)new ObjectUuidPK(rcdInfo.getId()));
            }
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            // empty catch block
        }
        EditTableUtil.formatColDate((KDTable)this.kDTable1, (String[])KDT_DATES);
    }

    private String getDefaultTrackNumber() throws BOSException, EASBizException {
        if (this.defaultTrackNumber != null) {
            return this.defaultTrackNumber;
        }
        String rtnNumber = "";
        try {
            String cuId = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
            ITrackNumber trackNumberBiz = TrackNumberFactory.getRemoteInstance();
            TrackNumberInfo defaultTNInfo = trackNumberBiz.getTrackNumberInfo("where defaultTraceNumberFlag=1 and CU='" + cuId + "'");
            if (defaultTNInfo != null && defaultTNInfo.getId() != null) {
                rtnNumber = defaultTNInfo.getId().toString();
            }
        }
        catch (ObjectNotFoundException e) {
            rtnNumber = "";
        }
        return rtnNumber;
    }

    private void initManufactureStrategy() throws BOSException {
        HashMap<String, String> materialMfgStrategy = new HashMap<String, String>();
        if (this.editData == null || this.editData.getEntrys() == null || this.editData.getEntrys().size() <= 0) {
            return;
        }
        Iterator iter = this.editData.getEntrys().iterator();
        StringBuilder materialIds = new StringBuilder();
        while (iter.hasNext()) {
            ReqSubConsumeRecordEntryInfo entryInfo = (ReqSubConsumeRecordEntryInfo)iter.next();
            String materialId = entryInfo.getMaterial().getId().toString();
            materialIds.append(materialId).append(",");
        }
        materialIds.delete(materialIds.length() - 1, materialIds.length());
        IMaterialPlan materialPlanBiz = MaterialPlanFactory.getRemoteInstance();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("orgUnit", (Object)this.storageOrgUnitInfo.getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("material", (Object)materialIds.toString(), CompareType.INCLUDE));
        SelectorItemCollection coll = new SelectorItemCollection();
        view.setSelector(coll);
        coll.add(new SelectorItemInfo("material"));
        coll.add(new SelectorItemInfo("manufactureStrategy.number"));
        MaterialPlanCollection materialPlans = materialPlanBiz.getMaterialPlanCollection(view);
        if (materialPlans == null || materialPlans.size() <= 0) {
            return;
        }
        for (MaterialPlanInfo planInfo : materialPlans) {
            String materialId = planInfo.getMaterial().getId().toString();
            String mfgStrategy = "";
            if (planInfo.getManufactureStrategy() != null) {
                mfgStrategy = planInfo.getManufactureStrategy().getNumber();
            }
            if (materialMfgStrategy.containsKey(materialId)) continue;
            materialMfgStrategy.put(materialId, mfgStrategy);
        }
        int rowCnt = this.kdtEntrys.getRowCount();
        for (int idx = 0; idx < rowCnt; ++idx) {
            String materialId = this.kdtEntrys.getCell(idx, "material").getValue().toString();
            this.kdtEntrys.getCell(idx, "mfgStrategy").setValue(materialMfgStrategy.get(materialId));
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnRefreshConsume.setIcon(EASResource.getIcon((String)"imgTbtn_timingrefer"));
        this.btnUndoConsume.setIcon(EASResource.getIcon((String)"imgTbtn_holscarryforward"));
        this.btnMySave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.btnRefreshConsume.setEnabled(true);
        this.btnUndoConsume.setEnabled(true);
        this.btnMySave.setEnabled(true);
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        try {
            Field fkdConTitle = this.kDTable1_detailPanel.getClass().getDeclaredField("kdConTitle");
            fkdConTitle.setAccessible(true);
            KDContainer kdConTitle = (KDContainer)fkdConTitle.get(this.kDTable1_detailPanel);
            kdConTitle.setVisible(false);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        this.menuBar.setVisible(false);
        this.cmbStatus.addItems(EnumUtils.getEnumList((String)"com.kingdee.eas.mm.planning.ReqPlanStatusEnum").toArray());
        this.cmbSubConsume.addItems(EnumUtils.getEnumList((String)"com.kingdee.eas.mm.planning.SubConsumeEnum").toArray());
    }

    private void initReqPlanF7() {
        this.prmtReqPlanF7.setQueryInfo("com.kingdee.eas.mm.planning.app.F7ReqPlan4SubConsumeQuery");
        this.prmtReqPlanF7.setVisible(true);
        this.prmtReqPlanF7.setEditable(true);
        this.prmtReqPlanF7.setDisplayFormat("$number$");
        this.prmtReqPlanF7.setEditFormat("$number$");
        this.prmtReqPlanF7.setCommitFormat("$number$");
        this.prmtReqPlanF7.setEnabledMultiSelection(true);
        this.prmtReqPlanF7.setSelectorCollection(this.getF7Selectors());
        KDTDefaultCellEditor kDTable1_reqPlan_CellEditor = new KDTDefaultCellEditor((IKDEditor)this.prmtReqPlanF7);
        this.kDTable1.getColumn("reqPlan").setEditor((ICellEditor)kDTable1_reqPlan_CellEditor);
        ObjectValueRender kDTable1_reqPlan_OVR = new ObjectValueRender();
        kDTable1_reqPlan_OVR.setFormat((IDataFormat)new BizDataFormat("$number$"));
        this.kDTable1.getColumn("reqPlan").setRenderer((IBasicRender)kDTable1_reqPlan_OVR);
    }

    private SelectorItemCollection getF7Selectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("qty"));
        sic.add(new SelectorItemInfo("baseQty"));
        sic.add(new SelectorItemInfo(TB_CONSUMEDQTY));
        sic.add(new SelectorItemInfo("baseCntactTotalQty"));
        sic.add(new SelectorItemInfo("notCntactQty"));
        sic.add(new SelectorItemInfo("baseNotCntactQty"));
        sic.add(new SelectorItemInfo("unit.id"));
        sic.add(new SelectorItemInfo("baseUnit.id"));
        sic.add(new SelectorItemInfo("unit.qtyPrecision"));
        sic.add(new SelectorItemInfo("requireDate"));
        sic.add(new SelectorItemInfo("reqSource"));
        sic.add(new SelectorItemInfo("productionDept.name"));
        sic.add(new SelectorItemInfo("trackNumber.number"));
        return sic;
    }

    private void onReqPlanF7FocusIn() {
        this.prmtReqPlanF7.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                ReqSubConsumeRecordEditUI.this.initReqPlanF7Filter((EventObject)e);
            }
        });
        this.prmtReqPlanF7.addCommitListener(new CommitListener(){

            public void willCommit(CommitEvent e) {
                ReqSubConsumeRecordEditUI.this.initReqPlanF7Filter((EventObject)e);
            }
        });
    }

    private void initReqPlanF7Filter(EventObject e) {
        int curRowIdx;
        EntityViewInfo entityInfo = this.prmtReqPlanF7.getEntityViewInfo();
        if (entityInfo == null) {
            entityInfo = new EntityViewInfo();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("material.number"));
            sic.add(new SelectorItemInfo("material.name"));
            sic.add(new SelectorItemInfo("material.model"));
            sic.add(new SelectorItemInfo("manuStrategy.number"));
            sic.add(new SelectorItemInfo("qty"));
            sic.add(new SelectorItemInfo("baseQty"));
            sic.add(new SelectorItemInfo(TB_CONSUMEDQTY));
            sic.add(new SelectorItemInfo("NotConsumedQty"));
            sic.add(new SelectorItemInfo("unit.id"));
            sic.add(new SelectorItemInfo("unit.qtyPrecision"));
            sic.add(new SelectorItemInfo("requireDate"));
            sic.add(new SelectorItemInfo("reqSource"));
            sic.add(new SelectorItemInfo("productionDept.id"));
            sic.add(new SelectorItemInfo("productionDept.name"));
            sic.add(new SelectorItemInfo("trackNumber.id"));
            sic.add(new SelectorItemInfo("trackNumber.number"));
            entityInfo.setSelector(sic);
            this.prmtReqPlanF7.setEntityViewInfo(entityInfo);
        }
        FilterInfo filterInfo = new FilterInfo();
        entityInfo.setFilter(filterInfo);
        this.focusIdx_kdtentry = curRowIdx = this.kdtEntrys.getSelectManager().getActiveRowIndex();
        IRow curRow = this.kdtEntrys.getRow(curRowIdx);
        if (curRow == null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)"0", CompareType.EQUALS));
            this.prmtReqPlanF7.setRefresh(true);
            this.prmtReqPlanF7.getQueryAgent().resetRuntimeEntityView();
            return;
        }
        HashSet<String> notInIds = new HashSet<String>();
        notInIds.add(Long.toString(System.currentTimeMillis()));
        int dtblARI = this.kDTable1.getSelectManager().getActiveRowIndex();
        for (int rowIdx = 0; rowIdx < this.kDTable1.getRowCount(); ++rowIdx) {
            RequirementPlanInfo reqPlan = (RequirementPlanInfo)this.kDTable1.getCell(rowIdx, "reqPlan").getValue();
            if (reqPlan == null || reqPlan.getId() == null) continue;
            notInIds.add(reqPlan.getId().toString());
        }
        Object trackNumId = curRow.getCell("trackNumId").getValue();
        if (trackNumId != null) {
            trackNumId = trackNumId.toString();
        }
        String mfgStrategy = curRow.getCell("mfgStrategy").getValue().toString();
        String materialId = curRow.getCell("material").getValue().toString();
        filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)this.storageOrgUnitInfo.getId().toString(), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialId, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)10, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("reqType.id", (Object)"NcvxPgEcEADgAAiowKgL09hs+cg=", CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("id", notInIds, CompareType.NOTINCLUDE));
        if (mfgStrategy.equals("ATO10") || mfgStrategy.equals("ATO20")) {
            if (this.Req_Writeoff_Control) {
                if (trackNumId == null || trackNumId.toString().length() <= 0) {
                    trackNumId = "-1";
                }
                if (this.defaultTrackNumber == null || this.defaultTrackNumber.length() <= 0) {
                    this.defaultTrackNumber = "-1";
                }
                if (trackNumId.equals(this.defaultTrackNumber) || trackNumId.equals("-1")) {
                    filterInfo.getFilterItems().add(new FilterItemInfo("trackNumber.id", null, CompareType.IS));
                    filterInfo.getFilterItems().add(new FilterItemInfo("trackNumber.id", (Object)this.defaultTrackNumber, CompareType.EQUALS));
                    filterInfo.setMaskString("#0 and #1 and #2 and #3 and #4 and (#5 or #6)");
                } else {
                    filterInfo.getFilterItems().add(new FilterItemInfo("trackNumber.id", null, CompareType.IS));
                    filterInfo.getFilterItems().add(new FilterItemInfo("trackNumber.id", (Object)this.defaultTrackNumber, CompareType.EQUALS));
                    filterInfo.getFilterItems().add(new FilterItemInfo("trackNumber.id", trackNumId, CompareType.EQUALS));
                    filterInfo.setMaskString("#0 and #1 and #2 and #3 and #4 and (#5 or #6 or #7)");
                }
            } else {
                if (trackNumId == null || trackNumId.toString().length() <= 0) {
                    trackNumId = "-1";
                }
                if (this.defaultTrackNumber == null || this.defaultTrackNumber.length() <= 0) {
                    this.defaultTrackNumber = "-1";
                }
                if (trackNumId.equals(this.defaultTrackNumber) || trackNumId.equals("-1")) {
                    filterInfo.getFilterItems().add(new FilterItemInfo("trackNumber.id", null, CompareType.IS));
                    filterInfo.getFilterItems().add(new FilterItemInfo("trackNumber.id", (Object)this.defaultTrackNumber, CompareType.EQUALS));
                    filterInfo.setMaskString("#0 and #1 and #2 and #3 and #4 and (#5 or #6)");
                } else {
                    filterInfo.getFilterItems().add(new FilterItemInfo("trackNumber.id", trackNumId, CompareType.EQUALS));
                    filterInfo.setMaskString("#0 and #1 and #2 and #3 and #4 and #5");
                }
            }
        }
        this.prmtReqPlanF7.setUseCacheObject(false);
        this.prmtReqPlanF7.setRefresh(true);
        this.prmtReqPlanF7.getQueryAgent().resetRuntimeEntityView();
    }

    private void onReqPlanF7Changed() {
        if (this.kDTEditListener == null) {
            this.kDTEditListener = new KDTEditListener(){

                public void editStopped(KDTEditEvent e) {
                    try {
                        ReqSubConsumeRecordEditUI.this.tableValueChanged(e);
                    }
                    catch (Exception e1) {
                        ReqSubConsumeRecordEditUI.this.handUIException(e1);
                    }
                }

                public void editStopping(KDTEditEvent e) {
                }

                public void editValueChanged(KDTEditEvent e) {
                }

                public void editCanceled(KDTEditEvent e) {
                }

                public void editStarted(KDTEditEvent e) {
                }

                public void editStarting(KDTEditEvent e) {
                    ReqSubConsumeRecordEditUI.this.tableEditStarting(e);
                }
            };
        }
        this.kDTable1.addKDTEditListener(this.kDTEditListener);
    }

    private void tableEditStarting(KDTEditEvent e) {
        BigDecimal consumedQty;
        int curColIndex = e.getColIndex();
        int curRowIndex = e.getRowIndex();
        String fieldName = this.kDTable1.getColumnKey(curColIndex);
        if (!"reqPlan".equalsIgnoreCase(fieldName)) {
            return;
        }
        ReqSubConsumeRecordDEntryInfo dinfo = (ReqSubConsumeRecordDEntryInfo)this.kDTable1.getRow(curRowIndex).getUserObject();
        if (dinfo != null && (consumedQty = dinfo.getConsumedQty()) != null && consumedQty.compareTo(BigDecimal.ZERO) > 0) {
            e.setCancel(true);
        }
    }

    private void tableValueChanged(KDTEditEvent e) throws Exception {
        int curColIndex = e.getColIndex();
        int curRowIndex = e.getRowIndex();
        String fieldName = this.kDTable1.getColumnKey(curColIndex);
        if ("reqPlan".equalsIgnoreCase(fieldName)) {
            this.reqPlanDataChanged(e);
        }
    }

    private void reqPlanDataChanged(KDTEditEvent e) throws Exception {
        Object newValue = e.getValue();
        int curRowIndex = e.getRowIndex();
        IRow curRow = this.kDTable1.getRow(curRowIndex);
        if (newValue instanceof Object[]) {
            Object[] value = (Object[])newValue;
            this.doDataChanged(value);
        }
    }

    private void doDataChanged(Object[] infos) throws Exception {
        if (infos == null || infos.length <= 0) {
            return;
        }
        ReqSubConsumeRecordEntryInfo entryInfo = (ReqSubConsumeRecordEntryInfo)this.kdtEntrys.getRow(this.focusIdx_kdtentry).getUserObject();
        int beginRow = this.kDTable1.getSelectManager().getActiveRowIndex();
        IRow curRow = this.kDTable1.getRow(beginRow);
        for (int idx = 0; idx < infos.length; ++idx) {
            if (idx > 0) {
                this.kDTable1.addRow(beginRow + idx);
                curRow = this.kDTable1.getRow(beginRow + idx);
            }
            this.afterDataChanged(curRow, infos[idx], entryInfo);
        }
    }

    private void afterDataChanged(IRow row, Object obj, ReqSubConsumeRecordEntryInfo entryInfo) {
        RequirementPlanInfo reqPlanInfo = (RequirementPlanInfo)obj;
        SCMClientUtils.changeCellPrecision((IRow)row, (String[])new String[]{TB_REQQTY, TB_CONSUMEDQTY, TB_CURCONSUMEQTY}, (int)reqPlanInfo.getUnit().getQtyPrecision(), (boolean)false);
        row.getCell("reqPlan").setValue((Object)reqPlanInfo);
        row.getCell(TB_REQQTY).setValue((Object)reqPlanInfo.getQty());
        row.getCell(TB_CONSUMEDQTY).setValue((Object)reqPlanInfo.getCntactTotalQty());
        row.getCell(TB_CURCONSUMEQTY).setValue(null);
        row.getCell("reqDate").setValue((Object)reqPlanInfo.getRequireDate());
        row.getCell("reqSource").setValue((Object)reqPlanInfo.getReqSource());
        if (reqPlanInfo.getProductionDept() != null) {
            row.getCell("mainOrg").setValue((Object)reqPlanInfo.getProductionDept().getName());
        } else {
            row.getCell("mainOrg").setValue(null);
        }
        if (reqPlanInfo.getTrackNumber() != null) {
            row.getCell("traceNum").setValue((Object)reqPlanInfo.getTrackNumber().getNumber());
        } else {
            row.getCell("traceNum").setValue(null);
        }
        ReqSubConsumeRecordDEntryInfo dentryInfo = (ReqSubConsumeRecordDEntryInfo)row.getUserObject();
        if (row.getUserObject() == null) {
            dentryInfo = new ReqSubConsumeRecordDEntryInfo();
            dentryInfo.setParentEntry(entryInfo);
            dentryInfo.setReqPlan(reqPlanInfo);
            entryInfo.getDentrys().add(dentryInfo);
            row.setUserObject((Object)dentryInfo);
        }
        dentryInfo.setUnit(reqPlanInfo.getUnit());
    }

    private void curConsumeQty_propertyChange(KDTPropertyChangeEvent evt) {
        BigDecimal consumedQty;
        if (evt.getType() != 1 || evt.getColIndex() != this.kDTable1.getColumnIndex(TB_CURCONSUMEQTY)) {
            return;
        }
        if (evt.getNewValue() != null && !evt.getNewValue().getClass().equals(BigDecimal.class)) {
            return;
        }
        if (evt.getNewValue() == null || ((BigDecimal)evt.getNewValue()).compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        int rowIndex = evt.getRowIndex();
        int colIndex = evt.getColIndex();
        IRow row = this.kDTable1.getRow(rowIndex);
        ReqSubConsumeRecordDEntryInfo dentry = (ReqSubConsumeRecordDEntryInfo)row.getUserObject();
        if (dentry == null) {
            return;
        }
        BigDecimal reqQty = (BigDecimal)row.getCell(TB_REQQTY).getValue();
        if (reqQty == null) {
            reqQty = BigDecimal.ZERO;
        }
        if ((consumedQty = (BigDecimal)row.getCell(TB_CONSUMEDQTY).getValue()) == null) {
            consumedQty = BigDecimal.ZERO;
        }
        BigDecimal maxConsumeQty = reqQty.subtract(consumedQty);
        BigDecimal newValue = (BigDecimal)evt.getNewValue();
        if (evt.getOldValue() != null && evt.getOldValue().getClass().equals(String.class)) {
            this.kDTable1.removeKDTPropertyChangeListener(this.curConsumeQtyChangeListener);
            row.getCell(TB_CURCONSUMEQTY).setValue((Object)BigDecimal.ZERO);
            dentry.setCurConsumeQty(BigDecimal.ZERO);
            this.kDTable1.addKDTPropertyChangeListener(this.curConsumeQtyChangeListener);
            return;
        }
        if (newValue.compareTo(maxConsumeQty) > 0) {
            this.kDTable1.removeKDTPropertyChangeListener(this.curConsumeQtyChangeListener);
            row.getCell(TB_CURCONSUMEQTY).setValue(evt.getOldValue());
            dentry.setCurConsumeQty((BigDecimal)evt.getOldValue());
            this.kDTable1.addKDTPropertyChangeListener(this.curConsumeQtyChangeListener);
            return;
        }
        int parentRowIdx = this.preIdx_kdtentry;
        if (parentRowIdx < 0) {
            return;
        }
        ReqSubConsumeRecordEntryInfo entryInfo = (ReqSubConsumeRecordEntryInfo)this.kdtEntrys.getRow(parentRowIdx).getUserObject();
        if (entryInfo == null) {
            return;
        }
        BigDecimal maxQty = entryInfo.getReqQty().subtract(entryInfo.getConsumedQty());
        BigDecimal sumConsumedQty = BigDecimal.ZERO;
        int deRowCnt = this.kDTable1.getRowCount();
        for (int curIdx = 0; curIdx < deRowCnt; ++curIdx) {
            IRow curRow = this.kDTable1.getRow(curIdx);
            BigDecimal curConsumeQty = (BigDecimal)curRow.getCell(TB_CURCONSUMEQTY).getValue();
            if (curConsumeQty == null) continue;
            sumConsumedQty = sumConsumedQty.add(curConsumeQty);
        }
        if (sumConsumedQty.compareTo(maxQty) > 0) {
            String msg = ResourceUtils.getMessage((String)"com.kingdee.eas.mm.planning.ReqSubConsumeRecordSource", (String)"CURCONSUME_QTY_TOOBIG", (String[])new String[]{sumConsumedQty.toString(), maxQty.toString()});
            int result = MsgBox.showConfirm2((String)msg);
            if (result == 2) {
                this.kDTable1.removeKDTPropertyChangeListener(this.curConsumeQtyChangeListener);
                row.getCell(TB_CURCONSUMEQTY).setValue(evt.getOldValue());
                dentry.setCurConsumeQty((BigDecimal)evt.getOldValue());
                this.kDTable1.addKDTPropertyChangeListener(this.curConsumeQtyChangeListener);
            } else {
                dentry.setCurConsumeQty((BigDecimal)evt.getNewValue());
            }
            this.kdtEntrys.fireTableClick(parentRowIdx, 1, 1);
        } else {
            dentry.setCurConsumeQty((BigDecimal)evt.getNewValue());
        }
    }

    @Override
    public void actionRefreshConsume_actionPerformed(ActionEvent e) throws Exception {
        Map uiContext = this.getUIContext();
        String reqPlanId = uiContext.get("id").toString();
        IReqSubConsumeRecord service = ReqSubConsumeRecordFactory.getRemoteInstance();
        IObjectPK pk = service.refreshByReqPlanId(reqPlanId);
        this.loadData(pk);
        this.setMessageText(ResourceUtils.getMessage((String)"com.kingdee.eas.mm.planning.ReqSubConsumeRecordSource", (String)"REFRESH_OK"));
        MessageFormat format = BOSLocaleUtil.getMessageFormat((String)"{0} {1}");
        String messageText = format.format(new Object[]{this.getClassAlise(), EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Edit")});
        this.setMessageText(messageText);
        this.setShowMessagePolicy(0);
        this.setIsShowTextOnly(false);
        this.showMessage();
        this.isModified = true;
    }

    private void loadData(IObjectPK pk) throws Exception {
        this.setDataObject(this.getValue(pk));
        super.loadFields();
        this.setOprtState("EDIT");
        int sortIdx = this.kdtEntrys.getSortMange().getColIndex();
        if (sortIdx < 0) {
            sortIdx = this.kdtEntrys.getColumnIndex("material_number");
        }
        this.kdtEntrys.getSortMange().sort(sortIdx, this.kdtEntrys.getSortMange().getSortType());
        this.kdtEntrys.getSelectManager().select(new KDTSelectBlock(0, 0, 0, this.kdtEntrys.getColumnCount() - 1));
        int dsortIdx = this.kDTable1.getSortMange().getColIndex();
        if (dsortIdx < 0) {
            dsortIdx = this.kDTable1.getColumnIndex("reqDate");
        }
        this.kDTable1.getSortMange().sort(dsortIdx, this.kDTable1.getSortMange().getSortType());
        this.initManufactureStrategy();
        this.resetEntryPrecision();
        this.resetDEntryPrecision();
        this.dataBinder.storeFields();
        this.initOldData((IObjectValue)this.editData);
        this.setSave(true);
        this.setSaved(true);
    }

    private void resetEntryPrecision() {
        int entrySize = this.kdtEntrys.getRowCount();
        for (int curIdx = 0; curIdx < entrySize; ++curIdx) {
            IRow curRow = this.kdtEntrys.getRow(curIdx);
            ReqSubConsumeRecordEntryInfo entryInfo = (ReqSubConsumeRecordEntryInfo)curRow.getUserObject();
            SCMClientUtils.changeCellPrecision((IRow)curRow, (String[])new String[]{"perQty", TB_REQQTY, "consumedQty"}, (int)entryInfo.getUnit().getQtyPrecision(), (boolean)false);
        }
    }

    private void resetDEntryPrecision() {
        int dentrySize = this.kDTable1.getRowCount();
        for (int curIdx = 0; curIdx < dentrySize; ++curIdx) {
            IRow curRow = this.kDTable1.getRow(curIdx);
            ReqSubConsumeRecordDEntryInfo dentryInfo = (ReqSubConsumeRecordDEntryInfo)curRow.getUserObject();
            if (dentryInfo == null || dentryInfo.getUnit() == null) continue;
            SCMClientUtils.changeCellPrecision((IRow)curRow, (String[])new String[]{TB_REQQTY, TB_CONSUMEDQTY, TB_CURCONSUMEQTY}, (int)dentryInfo.getUnit().getQtyPrecision(), (boolean)false);
        }
    }

    @Override
    public void actionUndoConsume_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData == null || this.editData.getId() == null) {
            return;
        }
        IReqSubConsumeRecord service = ReqSubConsumeRecordFactory.getRemoteInstance();
        service.antiConsume(this.editData.getId().toString());
        this.setDataObject(this.createNewData());
        this.dataBinder.loadFields();
        this.isModified = true;
    }

    protected void doBeforeSave(ActionEvent e) throws Exception {
        ReqSubConsumeRecordInfo curInfo;
        super.doBeforeSave(e);
        if (this.getOprtState().equals("ADDNEW")) {
            MsgBox.showInfo((String)ResourceUtils.getMessage((String)"com.kingdee.eas.mm.planning.ReqSubConsumeRecordSource", (String)"REFRESH_FIRST"));
            this.abort();
        }
        if ((curInfo = this.editData) == null || curInfo.getEntrys() == null || curInfo.getEntrys().size() <= 0) {
            MsgBox.showInfo((String)ResourceUtils.getMessage((String)"com.kingdee.eas.mm.planning.ReqSubConsumeRecordSource", (String)"CONSUMEENTRY_ISNULL"));
            this.abort();
        }
        StringBuilder materialNumbers = new StringBuilder();
        String msgCurConsumeQtyIsNull = null;
        Iterator iter = curInfo.getEntrys().iterator();
        block0: while (iter.hasNext()) {
            ReqSubConsumeRecordEntryInfo curEntryInfo = (ReqSubConsumeRecordEntryInfo)iter.next();
            if (curEntryInfo.getDentrys() == null || curEntryInfo.getDentrys().size() <= 0) continue;
            Iterator diter = curEntryInfo.getDentrys().iterator();
            while (diter.hasNext()) {
                ReqSubConsumeRecordDEntryInfo curDentryInfo = (ReqSubConsumeRecordDEntryInfo)diter.next();
                if (curDentryInfo.getReqPlan() == null) {
                    diter.remove();
                }
                if (curDentryInfo.getConsumedQty() != null && curDentryInfo.getConsumedQty().compareTo(BigDecimal.ZERO) > 0 || curDentryInfo.getCurConsumeQty() != null && curDentryInfo.getCurConsumeQty().compareTo(BigDecimal.ZERO) > 0) continue;
                materialNumbers.append(curEntryInfo.getMaterial().getNumber()).append(", ");
                continue block0;
            }
        }
        if (materialNumbers.length() > 1) {
            materialNumbers.delete(materialNumbers.length() - 2, materialNumbers.length());
            msgCurConsumeQtyIsNull = ResourceUtils.getMessage((String)"com.kingdee.eas.mm.planning.ReqSubConsumeRecordSource", (String)"CURCONSUME_QTY_ISNULL", (String[])new String[]{materialNumbers.toString()});
            if (msgCurConsumeQtyIsNull != null) {
                MsgBox.showWarning((String)msgCurConsumeQtyIsNull.toString());
                this.abort();
            }
        }
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        KDTSelectBlock selectBlock = this.kdtEntrys.getSelectManager().get();
        super.actionSave_actionPerformed(e);
        this.kdtEntrys.getSortMange().sort(this.kdtEntrys.getSortMange().getColIndex(), this.kdtEntrys.getSortMange().getSortType());
        this.kdtEntrys.getSelectManager().select(selectBlock, true);
        this.kDTable1.getSortMange().sort(this.kDTable1.getSortMange().getColIndex(), this.kDTable1.getSortMange().getSortType());
        this.initManufactureStrategy();
        this.resetEntryPrecision();
        this.resetDEntryPrecision();
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
        this.isModified = true;
    }

    protected void showSaveSuccess() {
        MessageFormat format = BOSLocaleUtil.getMessageFormat((String)"{0} {1}");
        String messageText = format.format(new Object[]{this.getClassAlise(), EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Save_OK")});
        this.setMessageText(messageText);
        String nextMessageText = format.format(new Object[]{this.getClassAlise(), EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Edit")});
        this.setNextMessageText(nextMessageText);
        this.setShowMessagePolicy(0);
        this.setIsShowTextOnly(false);
        this.showMessage();
    }

    protected String getEditUIName() {
        return ReqSubConsumeRecordEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return ReqSubConsumeRecordFactory.getRemoteInstance();
    }

    protected IObjectValue createNewData() {
        ReqSubConsumeRecordInfo objectValue = new ReqSubConsumeRecordInfo();
        objectValue.setCreator((UserInfo)SysContext.getSysContext().getCurrentUser());
        RequirementPlanInfo reqPlanInfo = new RequirementPlanInfo();
        reqPlanInfo.setStatus(ReqPlanStatusEnum.ACTIVE);
        objectValue.setReqPlan(reqPlanInfo);
        return objectValue;
    }

    protected String getTDFileName() {
        return "/bim/mm/planning/ReqSubConsumeRecord";
    }

    protected KDTable getDetailTable() {
        return this.kdtEntrys;
    }

    protected void applyDefaultValue(IObjectValue vo) {
    }

    protected void setFieldsNull(AbstractObjectValue arg0) {
        super.setFieldsNull(arg0);
        arg0.put("number", null);
    }
}

