/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.IMaterialGroup;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialGroupFactory;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.mm.common.client.MMUtils;
import com.kingdee.eas.mm.planning.client.AbstractRequirementCollectFilterUI;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.common.verify.VerifyItem;
import com.kingdee.eas.scm.common.verify.VerifyType;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import org.apache.log4j.Logger;

public class RequirementCollectFilterUI
extends AbstractRequirementCollectFilterUI {
    private static final String REQPLAN_RESOURCE_FULLNAME = "com.kingdee.eas.mm.planning.client.RequirementPlanResource";
    private static final Logger logger = CoreUIObject.getLogger(RequirementCollectFilterUI.class);
    private static final int MAX_COLUMNS = 60;
    private boolean isLoadingData = false;
    private boolean isOnloaded = false;

    public RequirementCollectFilterUI() throws Exception {
        this.isReport = true;
        this.fldMGroup.setQueryInfo("com.kingdee.eas.basedata.master.material.app.F7MaterialGroupQuery");
        this.fldMGroup.setDisplayFormat("$number$");
        this.fldMGroup.setEditFormat("$number$");
        this.fldMGroup.setCommitFormat("$number$");
        this.fldMStart.setQueryInfo("com.kingdee.eas.mm.planning.app.F7MaterialQuery");
        this.fldMStart.setDisplayFormat("$number$");
        this.fldMStart.setEditFormat("$number$");
        this.fldMStart.setCommitFormat("$number$");
        this.fldMEnd.setQueryInfo("com.kingdee.eas.mm.planning.app.F7MaterialQuery");
        this.fldMEnd.setDisplayFormat("$number$");
        this.fldMEnd.setEditFormat("$number$");
        this.fldMEnd.setCommitFormat("$number$");
        this.fldDateStart.setRequired(true);
        this.fldDateEnd.setRequired(true);
        this.isLoadingData = true;
        CompositeFilterElement elements = new CompositeFilterElement(0);
        SingleFilterElement mainElement = new SingleFilterElement("storageOrgUnit", (Component)this.fldSU);
        mainElement.addVerifyItem(new VerifyItem(VerifyType.REQUIRED_TYPE, EASResource.getString((String)REQPLAN_RESOURCE_FULLNAME, (String)"CollectFilterErrorPrompt")));
        mainElement.setDefaultValue((Object)MMUtils.getDefaultMainBizOrg((OrgType)this.getMainBizOrgType(), (String)"mm_reqcollect_view"));
        elements.add((FilterElement)mainElement);
        SingleFilterElement element = new SingleFilterElement("materialGroup", (Component)this.fldMGroup);
        elements.add((FilterElement)element);
        element = new SingleFilterElement("materialStart", (Component)this.fldMStart);
        elements.add((FilterElement)element);
        element = new SingleFilterElement("materialEnd", (Component)this.fldMEnd);
        elements.add((FilterElement)element);
        element = new SingleFilterElement("dateStart", (Component)this.fldDateStart);
        element.addVerifyItem(new VerifyItem(VerifyType.REQUIRED_TYPE, EASResource.getString((String)REQPLAN_RESOURCE_FULLNAME, (String)"CollectFilterDateErrorPrompt")));
        elements.add((FilterElement)element);
        element = new SingleFilterElement("dateEnd", (Component)this.fldDateEnd);
        element.addVerifyItem(new VerifyItem(VerifyType.REQUIRED_TYPE, EASResource.getString((String)REQPLAN_RESOURCE_FULLNAME, (String)"CollectFilterDateErrorPrompt")));
        elements.add((FilterElement)element);
        MMUtils.filterRangF7Helper((Component)this.fldMStart, (Component)this.fldMEnd);
        this.getFilterManager().setElement((FilterElement)elements);
        this.getFilterManager().setMainOrgElement((FilterElement)mainElement, this.getPropertyOfMainBizOrg());
        this.isLoadingData = false;
    }

    protected void setDefaultValue() {
        this.fldSU.setValue((Object)MMUtils.getDefaultMainBizOrg((OrgType)OrgType.Storage, (String)"mm_reqplan_update"));
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(SCMUtils.getSCMQueryTime(null, (String)"startDate"));
        calendar.add(2, 1);
        this.fldDateStart.setValue((Object)new Timestamp(calendar.getTimeInMillis()));
        calendar.setTime(SCMUtils.getSCMQueryTime(null, (String)"endDate"));
        calendar.add(2, 1);
        this.fldDateEnd.setValue((Object)new Timestamp(calendar.getTimeInMillis()));
    }

    public void clear() {
        super.clear();
        this.fldSU.setValue((Object)MMUtils.getDefaultMainBizOrg((OrgType)OrgType.Storage, (String)"mm_reqplan_update"));
    }

    public void onLoad() throws Exception {
        super.onLoad();
        if (!this.isOnloaded) {
            this.isOnloaded = true;
        }
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.fldSU;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    protected String getPropertyOfMainBizOrg() {
        return "storageOrgUnit.id";
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        this.isLoadingData = true;
        super.loadData(entityViewInfo);
        try {
            CoreBaseCollection items;
            String numbers = this.transformNumberArray(this.fldPlanner);
            if (numbers != null) {
                IPerson svcP = PersonFactory.getRemoteInstance();
                items = svcP.getCollection("select id,number where number in ('" + numbers + "')");
                this.fldPlanner.setValue((Object)items.toArray());
            }
            if ((numbers = this.transformNumberArray(this.fldMGroup)) != null) {
                IMaterialGroup svcMG = MaterialGroupFactory.getRemoteInstance();
                items = svcMG.getCollection("select id,name,number where number in ('" + numbers + "')");
                this.fldMGroup.setValue((Object)items.toArray());
            }
            IMaterial svcM = MaterialFactory.getRemoteInstance();
            numbers = this.transformNumberArray(this.fldMEnd);
            if (numbers != null) {
                items = svcM.getCollection("select id,name,number where number = '" + numbers + "'");
                this.fldMEnd.setValue((Object)items.get(0));
            }
            if ((numbers = this.transformNumberArray(this.fldMStart)) != null) {
                items = svcM.getCollection("select id,name,number where number = '" + numbers + "'");
                this.fldMStart.setValue((Object)items.get(0));
            }
        }
        catch (Throwable t) {
            this.handUIException(t);
        }
        this.isLoadingData = false;
    }

    private String transformNumberArray(KDBizPromptBox control) {
        String ids = control.getText();
        if (ids == null || ids != null && ids.length() == 0) {
            return null;
        }
        return ids.replaceAll(" ", "").replaceAll(";", "','");
    }

    @Override
    protected void fldMGroup_dataChanged(DataChangeEvent e) throws Exception {
        this.initFilters();
    }

    @Override
    protected void fldPlanner_dataChanged(DataChangeEvent e) throws Exception {
        this.initFilters();
    }

    @Override
    protected void fldSU_dataChanged(DataChangeEvent e) throws Exception {
        this.initFilters();
    }

    @Override
    protected void fldMEnd_willShow(SelectorEvent e) throws Exception {
        this.forceInitFilters();
    }

    @Override
    protected void fldMStart_willShow(SelectorEvent e) throws Exception {
        this.forceInitFilters();
    }

    private FilterInfo getFilterInfoFromControl(KDBizPromptBox control, String fieldName) {
        Object value = control.getValue();
        FilterInfo filter = new FilterInfo();
        if (value != null) {
            Object[] objectArray;
            if (value instanceof DataBaseInfo) {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = value;
            } else {
                objectArray = (Object[])value;
            }
            Object[] arrValues = objectArray;
            StringBuffer arr = new StringBuffer();
            for (int i = 0; i < arrValues.length; ++i) {
                if (arrValues[i] == null) continue;
                if (arr.length() > 0) {
                    arr.append(", ");
                }
                if (!(arrValues[i] instanceof DataBaseInfo)) continue;
                arr.append("'").append(((DataBaseInfo)arrValues[i]).getId().toString()).append("'");
            }
            if (arr.length() > 0) {
                filter.getFilterItems().add(new FilterItemInfo(fieldName, (Object)arr.toString(), CompareType.INNER));
            }
        }
        return filter;
    }

    private void forceInitFilters() throws Exception {
        this.isLoadingData = true;
        this.fldMGroup.commitEdit();
        this.fldPlanner.commitEdit();
        this.fldSU.commitEdit();
        this.initFilters();
        this.isLoadingData = false;
    }

    private void initFilters() {
        FilterInfo fiSU = null;
        Object value = this.fldSU.getValue();
        fiSU = value == null || value != null && value instanceof Object[] && (((Object[])value).length == 0 || ((Object[])value)[0] == null) ? SCMClientUtils.getF7FilterInfoByAuthorizeStorageOrg((String)"storageOrgUnit.id", null) : this.getFilterInfoFromControl(this.fldSU, "storageOrgUnit.id");
        FilterInfo fiP = this.getFilterInfoFromControl(this.fldPlanner, "planner.id");
        FilterInfo fiMG = this.getFilterInfoFromControl(this.fldMGroup, "MaterialGroup.id");
        EntityViewInfo vi = new EntityViewInfo();
        try {
            FilterInfo fi = new FilterInfo();
            fi.mergeFilter(fiSU, "AND");
            fi.mergeFilter(fiP, "AND");
            fi.mergeFilter(fiMG, "AND");
            vi.setFilter(fi);
        }
        catch (Throwable t) {
            this.handUIException(t);
        }
        this.fldMStart.setEntityViewInfo(vi);
        this.fldMEnd.setEntityViewInfo(vi);
        if (!this.isOnloaded || this.isLoadingData) {
            return;
        }
        this.fldMStart.setValue(null);
        this.fldMEnd.setValue(null);
    }

    public boolean verify() {
        boolean result = super.verify();
        if (result) {
            if (((Date)this.fldDateEnd.getValue()).getTime() < ((Date)this.fldDateStart.getValue()).getTime()) {
                MsgBox.showInfo((String)EASResource.getString((String)REQPLAN_RESOURCE_FULLNAME, (String)"CollectFilterDateErrorPrompt"));
                return false;
            }
            long days = (((Date)this.fldDateEnd.getValue()).getTime() - ((Date)this.fldDateStart.getValue()).getTime()) / 1000L / 60L / 60L / 24L + 1L;
            if (days / 34L > 60L) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)REQPLAN_RESOURCE_FULLNAME, (String)"SettingsOverflowPrompt").replaceAll("%1", "60"));
            }
        }
        return result;
    }
}

